/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsAdminPermissionDialog;
import com.tibco.gems.GemsBrowser;
import com.tibco.gems.GemsConfigDialog;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsConnectionPanel;
import com.tibco.gems.GemsConnectionPicker;
import com.tibco.gems.GemsConsumerDisplay;
import com.tibco.gems.GemsCreateBridgeDialog;
import com.tibco.gems.GemsDestDisplay;
import com.tibco.gems.GemsDestMonitor;
import com.tibco.gems.GemsDestPropEditor;
import com.tibco.gems.GemsDetailsPanel;
import com.tibco.gems.GemsDummyConnectionFactoryInfo;
import com.tibco.gems.GemsDurableBrowser;
import com.tibco.gems.GemsDynamicPropertyDialog;
import com.tibco.gems.GemsEventMessagePanel;
import com.tibco.gems.GemsEventMonitor;
import com.tibco.gems.GemsEventMonitorDialog;
import com.tibco.gems.GemsIconNode;
import com.tibco.gems.GemsIconNodeRenderer;
import com.tibco.gems.GemsJNDILookup;
import com.tibco.gems.GemsJSONConfigEditor;
import com.tibco.gems.GemsLimitsDialog;
import com.tibco.gems.GemsManageBridgesDialog;
import com.tibco.gems.GemsMessageCopier;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsMessageSender;
import com.tibco.gems.GemsPermissionDialog;
import com.tibco.gems.GemsPopupEventQueue;
import com.tibco.gems.GemsPurgeQueues;
import com.tibco.gems.GemsPurgeTopics;
import com.tibco.gems.GemsQueueBrowser;
import com.tibco.gems.GemsQueueNode;
import com.tibco.gems.GemsReqReplyMonitor;
import com.tibco.gems.GemsReqReplyTester;
import com.tibco.gems.GemsSSDetailsTableModel;
import com.tibco.gems.GemsSSNode;
import com.tibco.gems.GemsServerInfoPanel;
import com.tibco.gems.GemsServerMonitorPanel;
import com.tibco.gems.GemsServerMonitorTableModel;
import com.tibco.gems.GemsService;
import com.tibco.gems.GemsSubscriptionDisplay;
import com.tibco.gems.GemsTextIcons;
import com.tibco.gems.GemsTopicNode;
import com.tibco.gems.GemsTopicSubscriber;
import com.tibco.gems.GemsTreeModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.chart.GemsChartFrame;
import com.tibco.security.ObfuscationEngine;
import com.tibco.security.TIBCOSecurity;
import com.tibco.tibjms.Tibjms;
import com.tibco.tibjms.admin.ConnectionFactoryInfo;
import com.tibco.tibjms.admin.QueueInfo;
import com.tibco.tibjms.admin.RouteInfo;
import com.tibco.tibjms.admin.ServerInfo;
import com.tibco.tibjms.admin.TibjmsAdmin;
import com.tibco.tibjms.admin.TibjmsAdminException;
import com.tibco.tibjms.admin.TopicInfo;
import com.tibco.tibjms.version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.imageio.ImageIO;
import javax.jms.Message;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.text.DefaultEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Gems {
    static Gems m_gems;
    final String m_version = "Gems v5.2";
    String m_buildVersion = "0";
    public final int m_supportedApplianceVersion = 2;
    String m_jreVersion = null;
    JFrame m_frame;
    JMenuBar m_menuBar;
    protected JTree m_tree;
    protected JTabbedPane m_tabPane;
    protected GemsTreeModel m_treeModel;
    public ImageIcon m_icon = null;
    public ImageIcon m_redicon = null;
    public boolean m_useMetalIcons = true;
    public boolean m_isJMS2 = false;
    public boolean m_isDirty = false;
    protected GemsServerMonitorPanel m_servMonitorPanel;
    protected GemsServerInfoPanel m_servPanel;
    protected GemsConnectionPanel m_connPanel;
    protected GemsDetailsPanel m_detailsPanel;
    protected GemsEventMessagePanel m_messagePanel;
    protected int m_lastSelectedTab = 0;
    public int m_displayRefresh = 20;
    protected Properties m_props;
    final String p_maxMessageView = "MaxMessageView";
    final String p_viewOldMessagesFirst = "ViewOldMessagesFirst";
    final String p_queueNamePattern = "QueueNamePattern";
    final String p_topicNamePattern = "TopicNamePattern";
    final String p_userNameFilter = "UserNameFilter";
    final String p_showExtendedProperties = "ShowExtendedProperties";
    final String p_displayRefresh = "DisplayRefresh";
    final String p_showMonitorTopics = "ShowMonitorTopics";
    final String p_showRootNode = "ShowRootNode";
    final String p_screenWidth = "DisplayWidth";
    final String p_screenHeight = "DisplayHeight";
    final String p_msgReadDelay = "MsgReadDelay";
    final String p_requestReplyTimeout = "RequestReplyTimeout";
    final String p_colourPendingMsgs = "ColourPendingMsgs";
    final String p_serverConfigFile = "ServerConfigFile";
    final String p_viewOnlyMode = "ViewOnlyMode";
    final String p_allowMsgReadInViewOnlyMode = "AllowMsgReadInViewOnlyMode";
    final String p_lookAndFeel = "LookAndFeel";
    final String p_permType = "PermType";
    final String p_debug = "Debug";
    final String p_showTotals = "ShowTotals";
    final String p_maxDisplayBytes = "MaxDisplayBytes";
    final String p_showClientId = "ShowClientId";
    final String p_hideViews = "HideViews";
    final String p_connectTimeout = "ConnectTimeout";
    final String p_SSTimeout = "SSTimeout";
    final String p_SSCountersErrorTH = "SSCountersErrorTH";
    final String p_SSCountersWarnTH = "SSCountersWarnTH";
    final String p_SSCountersHighTH = "SSCountersHighTH";
    final String p_SSStressErrorTH = "SSStressErrorTH";
    final String p_SSStressWarnTH = "SSStressWarnTH";
    final String p_SSBusyErrorTH = "SSBusyErrorTH";
    final String p_SSBusyWarnTH = "SSBusyWarnTH";
    final String p_allowStandbyOperations = "AllowStandbyOperations";
    final String p_adminTimeout = "AdminTimeout";
    final String p_useServerTimestamps = "UseServerTimestamps";
    final String p_showPathInTitleBar = "ShowPathInTitleBar";
    final String p_showRootInTitleBar = "ShowRootInTitleBar";
    final String p_detailPaneColWidths = "DetailPanelColWidths";
    final String p_logDateTimeFormat = "LogDateTimeFormat";
    final String p_CSVFileDelimiter = "CSVFileDelimiter";
    final String p_maxQueues = "MaxQueues";
    final String p_maxTopics = "MaxTopics";
    final String p_maxConsumers = "MaxConsumers";
    final String p_maxProducers = "MaxProducers";
    final String p_maxMonitorEvents = "MaxMonitorEvents";
    final String p_serverInfoColPositions = "ServerInfoColPositions";
    final String p_disableAutoConnectAfterTimeoutException = "DisableAutoConnectAfterTimeoutException";
    final String p_autoReconnectToPrimary = "AutoReconnectToPrimary";
    final String p_maxMonitorBacklog = "MaxMonitorBacklog";
    final String p_destCursorSize = "DestCursorSize";
    final String p_disableCursors = "DisableCursors";
    final String p_allowPatternOverride = "AllowPatternOverride";
    final String p_appliancePollPeriod = "AppliancePollPeriod";
    final String p_applianceSshTimeout = "ApplianceSshTimeout";
    final String p_showApplFullyOp = "ShowApplFullyOp";
    final String p_autoConnectOnStart = "AutoConnectOnStart";
    final String p_hideTreeDests = "HideTreeDests";
    protected boolean m_lock = false;
    protected boolean m_serviceMenu = false;
    protected boolean m_substationMenu = false;
    protected boolean m_showEvents = true;
    protected JCheckBoxMenuItem m_autoRefresh = null;
    protected JCheckBoxMenuItem m_showTotals = null;
    protected Timer m_timer = null;
    protected String m_detailsTableModelClass = "com.tibco.gems.GemsDetailsTableModel";
    protected long m_connectStart = 0L;
    protected String m_propsFileArg = null;
    protected String m_serversFileArg = null;

    public Gems(String[] args) {
        if (args.length > 1) {
            this.parseArgs(args);
            this.initProps(this.m_propsFileArg);
        } else if (args.length == 1) {
            this.initProps(args[0]);
        } else {
            this.initProps(null);
        }
    }

    void parseArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].compareTo("-p") == 0) {
                if (i + 1 >= args.length) {
                    this.usage();
                }
                this.m_propsFileArg = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].compareTo("-s") == 0) {
                if (i + 1 >= args.length) {
                    this.usage();
                }
                this.m_serversFileArg = args[i + 1];
                i += 2;
                continue;
            }
            System.err.println("Invalid argument: " + args[i]);
            this.usage();
        }
    }

    void usage() {
        System.err.println("\nUsage: java com.tibco.gems.Gems -p <properties file> [-s <servers file>]");
        System.exit(0);
    }

    public void start() {
        this.m_jreVersion = System.getProperty("java.version");
        Gems.debug("JRE Version = " + this.m_jreVersion);
        try {
            Attributes attr;
            String classpath = this.getClass().getResource(this.getClass().getSimpleName() + ".class").toString();
            String manifestPath = classpath.substring(0, classpath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            if (manifest != null && (attr = manifest.getMainAttributes()) != null) {
                this.m_buildVersion = attr.getValue("Build-Version");
            }
        }
        catch (IOException e) {
            System.err.println("Couldn't read manifest: " + e.toString());
        }
        System.err.print("TIBCO Gems v5.2");
        Gems.debug("Build: " + this.m_buildVersion);
        version.main(null);
        try {
            Class.forName("javax.jms.JMSContext");
            this.m_isJMS2 = true;
            System.err.println("JMS2.0 API available");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        Gems.debug("Default socketConnectionTimeout: " + String.valueOf(Tibjms.getSocketConnectTimeout()));
        Tibjms.setSocketConnectTimeout((long)this.getConnectTimeout());
        Gems.debug("Setting socketConnectionTimeout: " + String.valueOf(this.getConnectTimeout()));
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new GemsPopupEventQueue());
        this.buildFrame();
        this.treeSelectionChange(this.getSelectedNode(), false);
        long t = this.m_displayRefresh / 5;
        if (t < 1L) {
            t = 1L;
        }
        ConnectThread ct = new ConnectThread(this.m_displayRefresh);
        ct.start();
        if (this.m_displayRefresh > 0) {
            this.m_timer = new Timer(this.m_displayRefresh * 1000 + 1000, new RefreshTimerAction());
            this.m_timer.start();
            this.m_timer.setInitialDelay(200);
        }
    }

    public void buildFrame() {
        try {
            String lf = this.getLookAndFeel();
            if (lf == null || lf.length() == 0) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(lf);
                if (lf.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                    this.m_useMetalIcons = true;
                }
                UIDefaults uIDefaults = UIManager.getDefaults();
            }
        }
        catch (Exception exc) {
            System.err.println("Error loading L&F: " + exc);
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JComponent treeChild = this.buildTreeViewFromFile(this.getServerConfigFile());
        if (treeChild == null) {
            treeChild = this.buildTreeView();
        }
        JComponent viewChild = this.buildTabbedView();
        this.m_menuBar = this.constructMenuBar();
        JPanel panel = new JPanel(true);
        String title = this.getTitlePrefix() + "Gems v5.2";
        if (this.getViewOnlyMode()) {
            title = title + " (view only)";
        }
        this.m_frame = new JFrame(title);
        this.m_frame.getContentPane().add("Center", panel);
        this.m_frame.setJMenuBar(this.m_menuBar);
        this.m_frame.setBackground(Color.lightGray);
        JSplitPane splitPane = new JSplitPane(1, treeChild, viewChild);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(200);
        treeChild.setMinimumSize(new Dimension(100, 50));
        viewChild.setMinimumSize(new Dimension(100, 50));
        panel.setLayout(new BorderLayout());
        panel.add("Center", splitPane);
        this.m_frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Gems.this.doExit();
            }
        });
        this.m_tree.addTreeSelectionListener(this.m_treeModel);
        this.m_frame.setSize(new Dimension(this.getScreenWidth(), this.getScreenHeight()));
        String iconImagePath = "/images/gem.jpg";
        URL iconImageURL = this.getClass().getResource(iconImagePath);
        this.m_icon = iconImageURL != null ? new ImageIcon(iconImageURL) : new ImageIcon("gem.jpg");
        if (this.m_icon != null) {
            this.m_frame.setIconImage(this.m_icon.getImage());
        }
        iconImagePath = "/images/RedCircle.gif";
        iconImageURL = this.getClass().getResource(iconImagePath);
        this.m_redicon = iconImageURL != null ? new ImageIcon(iconImageURL) : new ImageIcon("RedCircle.gif");
        this.m_frame.setVisible(true);
    }

    public void setTitle() {
        String title = this.getTitlePrefix() + "Gems v5.2";
        if (this.getViewOnlyMode()) {
            title = title + " (view only)";
        }
        this.m_frame.setTitle(title);
    }

    public JComponent buildTreeView() {
        ImageIcon ii;
        GemsIconNode root = new GemsIconNode("EMS-Servers");
        String iconImagePath = "/images/gem16.gif";
        URL iconImageURL = this.getClass().getResource(iconImagePath);
        if (iconImageURL != null) {
            ii = new ImageIcon(iconImageURL);
            if (ii.getImageLoadStatus() == 8) {
                root.setIcon(ii);
            }
        } else {
            ii = new ImageIcon("gem16.jpg");
            if (ii.getImageLoadStatus() == 8) {
                root.setIcon(ii);
            }
        }
        iconImagePath = "/images/RedCircle.gif";
        iconImageURL = this.getClass().getResource(iconImagePath);
        this.m_redicon = iconImageURL != null ? new ImageIcon(iconImageURL) : new ImageIcon("RedCircle.gif");
        this.m_treeModel = new GemsTreeModel(root);
        this.m_treeModel.m_tree = this.m_tree = new JTree(this.m_treeModel);
        this.m_treeModel.m_gems = this;
        this.m_tree.setCellRenderer(new GemsIconNodeRenderer());
        this.m_tree.putClientProperty("JTree.icons", this.makeIcons());
        this.m_tree.setRowHeight(-1);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.expandRow(0);
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add(this.m_tree);
        return sp;
    }

    public JComponent buildTreeViewFromFile(String xmlfile) {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Exception: " + e.getMessage());
            return null;
        }
        try {
            DefaultMutableTreeNode n;
            File serversFile = new File(xmlfile);
            System.err.println("Loading XML server config from file: " + serversFile.getAbsolutePath());
            Document doc = db.parse(serversFile);
            Element xroot = doc.getDocumentElement();
            GemsIconNode root = new GemsIconNode(xroot.getNodeName());
            String iconf = xroot.getAttribute("icon");
            if (iconf != null && iconf.length() > 0) {
                ImageIcon ii = new ImageIcon(iconf);
                if (ii.getImageLoadStatus() == 8) {
                    root.setIcon(ii);
                }
            } else {
                ImageIcon ii;
                String iconImagePath = "/images/gem16.jpg";
                URL iconImageURL = this.getClass().getResource(iconImagePath);
                if (iconImageURL != null) {
                    ii = new ImageIcon(iconImageURL);
                    if (ii.getImageLoadStatus() == 8) {
                        root.setIcon(ii);
                    }
                } else {
                    ii = new ImageIcon("gem16.jpg");
                    if (ii.getImageLoadStatus() == 8) {
                        root.setIcon(ii);
                    }
                }
            }
            this.m_treeModel = new GemsTreeModel(root);
            this.m_treeModel.m_tree = this.m_tree = new JTree(this.m_treeModel);
            this.m_treeModel.m_gems = this;
            this.m_tree.setCellRenderer(new GemsIconNodeRenderer());
            this.m_tree.putClientProperty("JTree.icons", this.makeIcons());
            this.m_tree.setRowHeight(-1);
            this.m_tree.getSelectionModel().setSelectionMode(1);
            this.m_tree.setRootVisible(this.getShowRootNode());
            DefaultMutableTreeNode selNode = this.buildNodes(xroot, root);
            this.m_tree.expandPath(new TreePath(root.getPath()));
            Enumeration<TreeNode> ch = root.children();
            if (ch.hasMoreElements() && (n = (DefaultMutableTreeNode)ch.nextElement()) != null) {
                this.m_tree.expandPath(new TreePath(n.getPath()));
            }
            this.m_tree.setSelectionPath(new TreePath(root.getPath()));
            JScrollPane sp = new JScrollPane();
            sp.getViewport().add(this.m_tree);
            return sp;
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            return null;
        }
    }

    public DefaultMutableTreeNode buildNodes(Node xnode, DefaultMutableTreeNode tnode) {
        DefaultMutableTreeNode selNode;
        block65: {
            selNode = null;
            try {
                NodeList xnodes = xnode.getChildNodes();
                if (xnodes == null) break block65;
                for (int i = 0; i < xnodes.getLength(); ++i) {
                    Node xn = xnodes.item(i);
                    if (xn.getNodeType() != 1) continue;
                    if (xn.getNodeName().equals("ConnectionNode")) {
                        ImageIcon ii;
                        String iconf;
                        String uf;
                        String tsf;
                        String qsf;
                        String tp;
                        String name = ((Element)xn).getAttribute("alias");
                        if (name == null || name.length() == 0) {
                            name = ((Element)xn).getAttribute("name");
                        }
                        String url = ((Element)xn).getAttribute("url");
                        String user = ((Element)xn).getAttribute("user");
                        String passwd = ((Element)xn).getAttribute("encryptedPassword");
                        if (passwd != null && passwd.length() > 0) {
                            if (passwd.startsWith("#")) {
                                this.isDirty(true);
                                try {
                                    TIBCOSecurity.init((String)"j2se-default", (boolean)false, (boolean)true, (boolean)false);
                                    passwd = String.copyValueOf(ObfuscationEngine.decrypt((String)passwd));
                                    System.err.println("Warning: use of tibcrypt.jar for encryption no longer supported, please resave config");
                                }
                                catch (Throwable ex) {
                                    System.err.println("Error decrypting password: " + ex.toString());
                                    System.err.println("Warning: use of tibcrypt.jar for encryption no longer supported, please re-enter passwords and save config");
                                    passwd = ((Element)xn).getAttribute("password");
                                }
                            } else {
                                try {
                                    passwd = TibjmsAdmin.unmanglePassword((String)passwd);
                                }
                                catch (Throwable ex) {
                                    System.err.println("Error unmangling password: " + ex.toString());
                                    passwd = ((Element)xn).getAttribute("password");
                                }
                            }
                        } else {
                            passwd = ((Element)xn).getAttribute("password");
                        }
                        String autos = ((Element)xn).getAttribute("autoConnect");
                        String ld = ((Element)xn).getAttribute("logDir");
                        String lsis = ((Element)xn).getAttribute("logServerInfo");
                        GemsConnectionNode.LOG_TYPE lsi = null;
                        if (lsis != null && lsis.length() > 0) {
                            if (lsis.equals(GemsConnectionNode.LOG_TYPE.Never.toString())) {
                                lsi = GemsConnectionNode.LOG_TYPE.Never;
                            } else if (lsis.equals(GemsConnectionNode.LOG_TYPE.WarnLimits.toString())) {
                                lsi = GemsConnectionNode.LOG_TYPE.WarnLimits;
                            } else if (lsis.equals(GemsConnectionNode.LOG_TYPE.ErrorLimits.toString())) {
                                lsi = GemsConnectionNode.LOG_TYPE.ErrorLimits;
                            } else if (lsis.equals(GemsConnectionNode.LOG_TYPE.Always.toString())) {
                                lsi = GemsConnectionNode.LOG_TYPE.Always;
                            } else {
                                System.err.println("ERROR: Illegal logServerInfo attribute: " + lsis + " for " + name + " must be one of: Never, WarnLimits, ErrorLimits, Always. Using WarnLimits");
                                lsi = GemsConnectionNode.LOG_TYPE.WarnLimits;
                            }
                        } else {
                            System.err.println("WARNING: No logServerInfo attribute specified for " + name + " logging of ServerInfo will be disabled (see servers.xml for details)");
                            lsi = GemsConnectionNode.LOG_TYPE.Never;
                        }
                        boolean auto = true;
                        if (autos != null && autos.length() > 0) {
                            auto = Boolean.valueOf(autos);
                        }
                        if (name == null) {
                            name = "EMS Server";
                        }
                        if (url == null) {
                            url = "tcp://localhost:7222";
                        }
                        if (user == null) {
                            name = "admin";
                        }
                        if (ld == null) {
                            ld = "./log";
                        }
                        GemsConnectionNode tn = new GemsConnectionNode(name, url, user, passwd, 15L, auto, lsi, ld);
                        String qp = ((Element)xn).getAttribute("queueNamePattern");
                        if (qp != null && qp.length() > 0) {
                            tn.m_queueNamePattern = qp;
                        }
                        if ((tp = ((Element)xn).getAttribute("topicNamePattern")) != null && tp.length() > 0) {
                            tn.m_topicNamePattern = tp;
                        }
                        if ((qsf = ((Element)xn).getAttribute("queueStoreFilter")) != null && qsf.length() > 0) {
                            tn.m_queueStoreFilter = qsf;
                        }
                        if ((tsf = ((Element)xn).getAttribute("topicStoreFilter")) != null && tsf.length() > 0) {
                            tn.m_topicStoreFilter = tsf;
                        }
                        if ((uf = ((Element)xn).getAttribute("userNameFilter")) != null && uf.length() > 0) {
                            tn.m_userNameFilter = uf;
                        }
                        if ((iconf = ((Element)xn).getAttribute("icon")) != null && (ii = new ImageIcon(iconf)).getImageLoadStatus() == 8) {
                            tn.setIconName(iconf);
                            tn.setIcon(ii);
                        }
                        tnode.add(tn);
                        NodeList xns = xn.getChildNodes();
                        for (int j = 0; xns != null && j < xns.getLength(); ++j) {
                            String p;
                            Node xn1 = xns.item(j);
                            if (xn1.getNodeName().equals("WarnLimits")) {
                                tn.addWarnLimits(xn1);
                                continue;
                            }
                            if (xn1.getNodeName().equals("ErrorLimits")) {
                                tn.addErrorLimits(xn1);
                                continue;
                            }
                            if (xn1.getNodeName().equals("SSLParam")) {
                                tn.addSSLParam(xn1);
                                continue;
                            }
                            if (xn1.getNodeName().equals("EventMonitor")) {
                                p = ((Element)xn1).getAttribute("maxDisplayedEvents");
                                long me = 100L;
                                try {
                                    me = Long.parseLong(p);
                                }
                                catch (Exception e) {
                                    System.err.println("Exception: " + e.getMessage());
                                }
                                String en = ((Element)xn1).getAttribute("enabled");
                                boolean eb = false;
                                if (en != null && en.length() > 0) {
                                    eb = Boolean.valueOf(en);
                                }
                                tn.addEventMonitor(me, eb);
                                this.m_showEvents = true;
                                NodeList xn1s = xn1.getChildNodes();
                                for (int k = 0; xn1s != null && k < xn1s.getLength(); ++k) {
                                    Node xn2 = xn1s.item(k);
                                    if (!xn2.getNodeName().equals("EventSubscription")) continue;
                                    String n = ((Element)xn2).getAttribute("monitorTopic");
                                    String s = ((Element)xn2).getAttribute("selector");
                                    if (n == null) continue;
                                    tn.addEventSubscription(n, s);
                                }
                                continue;
                            }
                            if (xn1.getNodeName().equals("ServiceMonitor")) {
                                p = ((Element)xn1).getAttribute("period");
                                long pl = 60L;
                                try {
                                    pl = Long.parseLong(p);
                                }
                                catch (Exception e) {
                                    System.err.println("Exception: " + e.getMessage());
                                }
                                String qs = ((Element)xn1).getAttribute("tmpQueueReplies");
                                String ts = ((Element)xn1).getAttribute("tmpTopicReplies");
                                String en = ((Element)xn1).getAttribute("enabled");
                                boolean qb = false;
                                boolean tb = false;
                                boolean eb = false;
                                if (qs != null && qs.length() > 0) {
                                    qb = Boolean.valueOf(qs);
                                }
                                if (ts != null && ts.length() > 0) {
                                    tb = Boolean.valueOf(ts);
                                }
                                if (en != null && en.length() > 0) {
                                    eb = Boolean.valueOf(en);
                                }
                                tn.addServiceTable(pl, qb, tb, eb);
                                this.m_serviceMenu = true;
                                NodeList xn1s = xn1.getChildNodes();
                                for (int k = 0; xn1s != null && k < xn1s.getLength(); ++k) {
                                    Node xn2 = xn1s.item(k);
                                    if (!xn2.getNodeName().equals("Service")) continue;
                                    String n = ((Element)xn2).getAttribute("name");
                                    String reqq = ((Element)xn2).getAttribute("requestQueue");
                                    String reqt = ((Element)xn2).getAttribute("requestTopic");
                                    String respq = ((Element)xn2).getAttribute("replyQueue");
                                    String respt = ((Element)xn2).getAttribute("replyTopic");
                                    long ll = 1000L;
                                    String l = ((Element)xn2).getAttribute("responseTimeLimit");
                                    if (l != null && l.length() > 0) {
                                        try {
                                            ll = Long.parseLong(l);
                                        }
                                        catch (Exception e) {
                                            System.err.println("Exception: " + e.getMessage());
                                        }
                                    }
                                    if (n == null || reqq == null && reqt == null) continue;
                                    tn.addService(n, reqq != null ? reqq : reqt, reqq != null, respq != null ? respq : respt, respq != null, ll);
                                }
                                continue;
                            }
                            if (xn1.getNodeName().equals("SS-Node")) {
                                this.m_detailsTableModelClass = "com.tibco.gems.GemsSSDetailsTableModel";
                                tn.addSubStation(xn1);
                                this.m_substationMenu = true;
                                continue;
                            }
                            if (!xn1.getNodeName().equals("ApplianceMonitor")) continue;
                            String inst = ((Element)xn1).getAttribute("instanceId");
                            String mgmtIP = ((Element)xn1).getAttribute("mgmtIpAddress");
                            String admPasswd = ((Element)xn1).getAttribute("tibadmEncryptedPassword");
                            if (admPasswd != null && admPasswd.length() > 0) {
                                if (admPasswd.startsWith("#")) {
                                    this.isDirty(true);
                                    try {
                                        TIBCOSecurity.init((String)"j2se-default", (boolean)false, (boolean)true, (boolean)false);
                                        admPasswd = String.copyValueOf(ObfuscationEngine.decrypt((String)admPasswd));
                                    }
                                    catch (Throwable ex) {
                                        System.err.println("Error decrypting password: " + ex.toString());
                                        admPasswd = ((Element)xn1).getAttribute("tibadmPassword");
                                    }
                                } else {
                                    try {
                                        admPasswd = TibjmsAdmin.unmanglePassword((String)admPasswd);
                                    }
                                    catch (Throwable ex) {
                                        System.err.println("Error unmangling password: " + ex.toString());
                                        admPasswd = ((Element)xn1).getAttribute("tibadmPassword");
                                    }
                                }
                            } else {
                                admPasswd = ((Element)xn1).getAttribute("tibadmPassword");
                            }
                            tn.setApplianceInfo(mgmtIP, inst, admPasswd);
                        }
                        if (selNode == null) {
                            selNode = tn;
                        }
                        if (!this.getAutoConnectOnStart() || !auto) continue;
                        tn.connect();
                        tn.reconnectToActiveIfStandby();
                        continue;
                    }
                    GemsIconNode tn = new GemsIconNode(xn.getNodeName());
                    String iconf = ((Element)xn).getAttribute("icon");
                    if (iconf != null) {
                        tn.setIconName(iconf);
                        ImageIcon ii = new ImageIcon(iconf);
                        if (ii.getImageLoadStatus() == 8) {
                            tn.setIcon(ii);
                        }
                    }
                    tnode.add(tn);
                    DefaultMutableTreeNode sn = this.buildNodes(xn, tn);
                    if (selNode != null) continue;
                    selNode = sn;
                }
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
        }
        return selNode;
    }

    public Document buildConfigDocument() {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
            if (node != null) {
                Element el = doc.createElement(node.getUserObject().toString());
                doc.appendChild(el);
                this.buildConfigChildElements(doc, el, node);
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
        }
        return doc;
    }

    public void buildConfigChildElements(Document doc, Node xnode, DefaultMutableTreeNode tnode) {
        try {
            Enumeration<TreeNode> ch = tnode.children();
            while (ch.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)ch.nextElement();
                if (n instanceof GemsConnectionNode) {
                    Element e2;
                    GemsEventMonitor ev;
                    String l;
                    Element e1;
                    String ep;
                    GemsConnectionNode cn = (GemsConnectionNode)n;
                    Element e = doc.createElement("ConnectionNode");
                    xnode.appendChild(e);
                    e.setAttribute("alias", n.getUserObject().toString());
                    e.setAttribute("url", cn.m_url);
                    e.setAttribute("user", cn.m_user);
                    if (cn.m_password != null && cn.m_password.length() > 0) {
                        try {
                            ep = TibjmsAdmin.manglePassword((String)cn.m_password);
                            e.setAttribute("encryptedPassword", ep);
                        }
                        catch (Throwable ex) {
                            System.err.println("Error mangling password: " + ex.toString());
                            e.setAttribute("password", cn.m_password);
                        }
                    } else {
                        e.setAttribute("password", cn.m_password);
                    }
                    e.setAttribute("autoConnect", new Boolean(cn.m_isAutoConnect).toString());
                    e.setAttribute("queueNamePattern", cn.m_queueNamePattern);
                    e.setAttribute("topicNamePattern", cn.m_topicNamePattern);
                    e.setAttribute("queueStoreFilter", cn.m_queueStoreFilter);
                    e.setAttribute("topicStoreFilter", cn.m_topicStoreFilter);
                    e.setAttribute("userNameFilter", cn.m_userNameFilter);
                    e.setAttribute("logServerInfo", cn.m_logServerInfo.toString());
                    e.setAttribute("logDir", cn.m_logDir);
                    if (cn.getIcon() != null) {
                        e.setAttribute("icon", cn.getIconName());
                    }
                    Enumeration k = ((Hashtable)cn.m_sslParams).keys();
                    while (k.hasMoreElements()) {
                        e1 = doc.createElement("SSLParam");
                        e.appendChild(e1);
                        l = (String)k.nextElement();
                        Object v = cn.m_sslParams.get(l);
                        e1.setAttribute("name", l);
                        e1.setAttribute("value", v.toString());
                        if (v instanceof String) {
                            e1.setAttribute("type", "string");
                            continue;
                        }
                        if (v instanceof Boolean) {
                            e1.setAttribute("type", "boolean");
                            continue;
                        }
                        if (v instanceof Integer) {
                            e1.setAttribute("type", "integer");
                            continue;
                        }
                        if (!(v instanceof Long)) continue;
                        e1.setAttribute("type", "long");
                    }
                    if (cn.m_warnLimits != null) {
                        e1 = doc.createElement("WarnLimits");
                        k = cn.m_warnLimits.keys();
                        if (k.hasMoreElements()) {
                            e.appendChild(e1);
                        }
                        while (k.hasMoreElements()) {
                            l = (String)k.nextElement();
                            e1.setAttribute(l, cn.m_warnLimits.get(l).toString());
                        }
                    }
                    if (cn.m_errorLimits != null) {
                        e1 = doc.createElement("ErrorLimits");
                        k = cn.m_errorLimits.keys();
                        if (k.hasMoreElements()) {
                            e.appendChild(e1);
                        }
                        while (k.hasMoreElements()) {
                            l = (String)k.nextElement();
                            e1.setAttribute(l, cn.m_errorLimits.get(l).toString());
                        }
                    }
                    if ((ev = cn.m_eventMonitor) != null) {
                        e1 = doc.createElement("EventMonitor");
                        e.appendChild(e1);
                        e1.setAttribute("maxDisplayedEvents", new Long(ev.m_maxEvents).toString());
                        e1.setAttribute("enabled", new Boolean(ev.m_enabled).toString());
                        for (int i = 0; i < ev.m_subscriptions.size(); ++i) {
                            e2 = doc.createElement("EventSubscription");
                            e1.appendChild(e2);
                            GemsEventMonitor.subscription s = (GemsEventMonitor.subscription)ev.m_subscriptions.get(i);
                            e2.setAttribute("monitorTopic", s.m_dest);
                            if (s.m_sel == null || s.m_sel.length() <= 0) continue;
                            e2.setAttribute("selector", s.m_sel);
                        }
                    }
                    if (cn.m_applPoller != null) {
                        e1 = doc.createElement("ApplianceMonitor");
                        e.appendChild(e1);
                        e1.setAttribute("instanceId", cn.m_applPoller.getInstanceId());
                        e1.setAttribute("mgmtIpAddress", cn.m_applPoller.getHost());
                        if (cn.m_applPoller.getPassword() != null && cn.m_applPoller.getPassword().length() > 0) {
                            try {
                                ep = TibjmsAdmin.manglePassword((String)cn.m_applPoller.getPassword());
                                e.setAttribute("tibadmEncryptedPassword", ep);
                            }
                            catch (Throwable ex) {
                                System.err.println("Error mangling password: " + ex.toString());
                                e.setAttribute("tibadmPassword", cn.m_applPoller.getPassword());
                            }
                        } else {
                            e1.setAttribute("tibadmPassword", cn.m_applPoller.getPassword());
                        }
                    }
                    Enumeration<?> eS = cn.m_SSSystems.propertyNames();
                    while (eS.hasMoreElements()) {
                        String key = (String)eS.nextElement();
                        Properties m_SSInterfaces = (Properties)cn.m_SSSystems.get(key);
                        e1 = doc.createElement("SS-Node");
                        e.appendChild(e1);
                        e1.setAttribute("alias", key);
                        e1.setAttribute("adminqueue", m_SSInterfaces.getProperty("QUEUE"));
                        e1.setAttribute("version", m_SSInterfaces.getProperty("VERSION"));
                        Enumeration<?> eI = m_SSInterfaces.propertyNames();
                        while (eI.hasMoreElements()) {
                            String keyI = (String)eI.nextElement();
                            if (keyI == "QUEUE" || keyI == "VERSION") continue;
                            Element e22 = doc.createElement("Interface");
                            e1.appendChild(e22);
                            e22.setAttribute("name", keyI);
                            e22.setAttribute("type", m_SSInterfaces.getProperty(keyI));
                        }
                    }
                    if (cn.m_services == null) continue;
                    e1 = doc.createElement("ServiceMonitor");
                    e.appendChild(e1);
                    e1.setAttribute("period", new Long(cn.m_services.m_period).toString());
                    e1.setAttribute("tmpQueueReplies", new Boolean(cn.m_services.m_useQTemps).toString());
                    e1.setAttribute("tmpTopicReplies", new Boolean(cn.m_services.m_useTTemps).toString());
                    e1.setAttribute("enabled", new Boolean(cn.m_services.m_enabled).toString());
                    k = cn.m_services.m_services.keys();
                    while (k.hasMoreElements()) {
                        String l2 = (String)k.nextElement();
                        GemsService gs = (GemsService)cn.m_services.m_services.get(l2);
                        e2 = doc.createElement("Service");
                        e1.appendChild(e2);
                        e2.setAttribute("name", gs.m_name);
                        if (gs.m_reqIsQueue) {
                            e2.setAttribute("requestQueue", gs.m_reqDest);
                        } else {
                            e2.setAttribute("requestTopic", gs.m_reqDest);
                        }
                        if (gs.m_respIsQueue) {
                            e2.setAttribute("replyQueue", gs.m_respDest);
                        } else {
                            e2.setAttribute("replyTopic", gs.m_respDest);
                        }
                        e2.setAttribute("responseTimeLimit", new Long(gs.m_respLimit).toString());
                    }
                    continue;
                }
                Element e = doc.createElement(n.getUserObject().toString());
                xnode.appendChild(e);
                if (n instanceof GemsIconNode && ((GemsIconNode)n).getIcon() != null) {
                    e.setAttribute("icon", ((GemsIconNode)n).getIconName());
                }
                this.buildConfigChildElements(doc, e, n);
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
        }
    }

    private Hashtable makeIcons() {
        Hashtable<String, Icon> m_treeicons = new Hashtable<String, Icon>();
        m_treeicons.put("floppyDrive", MetalIconFactory.getTreeFloppyDriveIcon());
        m_treeicons.put("hardDrive", MetalIconFactory.getTreeHardDriveIcon());
        m_treeicons.put("computer", MetalIconFactory.getTreeComputerIcon());
        m_treeicons.put("queue", GemsTextIcons.getIcon("queue"));
        m_treeicons.put("routedqueue", GemsTextIcons.getIcon("routedqueue"));
        m_treeicons.put("topic", GemsTextIcons.getIcon("topic"));
        try {
            URL imageURL = this.getClass().getResource("/images/sprites.png");
            BufferedImage bigImg = ImageIO.read(imageURL);
            m_treeicons.put("acls", new ImageIcon(bigImg.getSubimage(138, 0, 16, 16)));
            m_treeicons.put("bridges", new ImageIcon(bigImg.getSubimage(266, 0, 16, 16)));
            m_treeicons.put("channels", new ImageIcon(bigImg.getSubimage(296, 0, 16, 16)));
            m_treeicons.put("prodcons", new ImageIcon(bigImg.getSubimage(202, 0, 16, 16)));
            m_treeicons.put("connections", new ImageIcon(bigImg.getSubimage(330, 0, 16, 16)));
            m_treeicons.put("durables", new ImageIcon(bigImg.getSubimage(48, 20, 16, 16)));
            m_treeicons.put("factories", new ImageIcon(bigImg.getSubimage(80, 20, 16, 16)));
            m_treeicons.put("groups", new ImageIcon(bigImg.getSubimage(128, 20, 16, 16)));
            m_treeicons.put("queues", new ImageIcon(bigImg.getSubimage(272, 20, 16, 16)));
            m_treeicons.put("routes", new ImageIcon(bigImg.getSubimage(368, 20, 16, 16)));
            m_treeicons.put("stores", new ImageIcon(bigImg.getSubimage(48, 36, 16, 16)));
            m_treeicons.put("topics", new ImageIcon(bigImg.getSubimage(128, 36, 16, 16)));
            m_treeicons.put("transactions", new ImageIcon(bigImg.getSubimage(160, 36, 16, 16)));
            m_treeicons.put("transports", new ImageIcon(bigImg.getSubimage(176, 36, 16, 16)));
            m_treeicons.put("users", new ImageIcon(bigImg.getSubimage(208, 36, 16, 16)));
        }
        catch (Exception ie) {
            System.err.println("JavaIOException: " + ie.getMessage());
        }
        return m_treeicons;
    }

    public GemsTreeModel getTreeModel() {
        return this.m_treeModel;
    }

    public JComponent buildTabbedView() {
        this.m_tabPane = new JTabbedPane();
        this.m_connPanel = new GemsConnectionPanel(this.m_treeModel);
        this.m_servPanel = new GemsServerInfoPanel();
        this.m_servMonitorPanel = new GemsServerMonitorPanel();
        this.m_detailsPanel = new GemsDetailsPanel(this.m_detailsTableModelClass);
        this.m_messagePanel = new GemsEventMessagePanel();
        this.m_tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                int sel = pane.getSelectedIndex();
                if (sel > 0) {
                    Gems.this.m_lastSelectedTab = sel;
                }
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), false);
            }
        });
        return this.m_tabPane;
    }

    public void reloadTree() {
        if (this.m_treeModel != null) {
            this.m_treeModel.reloadTree();
        }
    }

    public void treeSelectionChange(DefaultMutableTreeNode node, boolean isAuto) {
        if (node != null && node.isRoot()) {
            this.m_autoRefresh.setState(true);
        }
        this.treeSelectionChange1(node, isAuto, false);
    }

    public void treeSelectionChange(DefaultMutableTreeNode node, boolean isAuto, boolean forceUpdate) {
        if (node != null && node.isRoot()) {
            this.m_autoRefresh.setState(true);
        }
        this.treeSelectionChange1(node, isAuto, forceUpdate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void treeSelectionChange1(DefaultMutableTreeNode node, boolean isAuto, boolean forceUpdate) {
        GemsConnectionNode cn = null;
        try {
            block145: {
                int maxTabIndex;
                String nodename;
                int level;
                int sel;
                block171: {
                    block176: {
                        block175: {
                            block174: {
                                block173: {
                                    String parentname;
                                    block172: {
                                        block147: {
                                            block170: {
                                                block169: {
                                                    block168: {
                                                        block167: {
                                                            block166: {
                                                                block165: {
                                                                    block164: {
                                                                        block163: {
                                                                            block162: {
                                                                                block161: {
                                                                                    block160: {
                                                                                        block159: {
                                                                                            block157: {
                                                                                                ServerInfo si;
                                                                                                block158: {
                                                                                                    block155: {
                                                                                                        ServerInfo si2;
                                                                                                        block156: {
                                                                                                            block154: {
                                                                                                                block153: {
                                                                                                                    block152: {
                                                                                                                        block151: {
                                                                                                                            block150: {
                                                                                                                                block149: {
                                                                                                                                    block148: {
                                                                                                                                        block146: {
                                                                                                                                            String state;
                                                                                                                                            if (this.m_lock) {
                                                                                                                                                return;
                                                                                                                                            }
                                                                                                                                            this.m_lock = true;
                                                                                                                                            this.setTitle();
                                                                                                                                            sel = this.m_tabPane.getSelectedIndex();
                                                                                                                                            level = 1;
                                                                                                                                            for (DefaultMutableTreeNode n = node; n != null; ++level, n = (DefaultMutableTreeNode)n.getParent()) {
                                                                                                                                                if (!(n instanceof GemsConnectionNode)) continue;
                                                                                                                                                cn = (GemsConnectionNode)n;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            if (cn == null) {
                                                                                                                                                while (this.m_tabPane.getTabCount() > 1) {
                                                                                                                                                    this.m_tabPane.removeTabAt(this.m_tabPane.getTabCount() - 1);
                                                                                                                                                }
                                                                                                                                                if (this.m_tabPane.getTabCount() == 1) {
                                                                                                                                                    if (!this.m_tabPane.getTitleAt(0).equals("Server Monitor")) {
                                                                                                                                                        this.m_tabPane.removeTabAt(0);
                                                                                                                                                        this.m_tabPane.addTab("Server Monitor", this.m_servMonitorPanel);
                                                                                                                                                    }
                                                                                                                                                } else {
                                                                                                                                                    this.m_tabPane.addTab("Server Monitor", this.m_servMonitorPanel);
                                                                                                                                                }
                                                                                                                                                if (node != null && node.getParent() == null && node.getChildCount() == 0) {
                                                                                                                                                    this.m_treeModel.reload();
                                                                                                                                                    this.m_lock = false;
                                                                                                                                                    return;
                                                                                                                                                }
                                                                                                                                                if (node == null) {
                                                                                                                                                    node = (DefaultMutableTreeNode)this.m_treeModel.getRoot();
                                                                                                                                                }
                                                                                                                                                if (this.m_servMonitorPanel.getModel().populateTable(node, false, this.m_showEvents) && this.m_tabPane.getTabCount() == 1) {
                                                                                                                                                    this.m_tabPane.removeTabAt(0);
                                                                                                                                                }
                                                                                                                                                this.m_lock = false;
                                                                                                                                                return;
                                                                                                                                            }
                                                                                                                                            if (this.m_tabPane.getTabCount() == 0) {
                                                                                                                                                this.m_tabPane.addTab("Connection", this.m_connPanel);
                                                                                                                                                sel = 0;
                                                                                                                                            } else if (!this.m_tabPane.getTitleAt(0).equals("Connection")) {
                                                                                                                                                this.m_tabPane.removeTabAt(0);
                                                                                                                                                this.m_tabPane.insertTab("Connection", null, this.m_connPanel, null, 0);
                                                                                                                                                sel = 0;
                                                                                                                                            }
                                                                                                                                            if (!isAuto) {
                                                                                                                                                this.m_connPanel.setDetails((String)cn.getUserObject(), cn.m_url, cn.m_user, cn.m_password, cn.m_isAutoConnect, cn.isConnected(), cn.getServerLogInfo(), cn.getServerLogDir(), cn.getQueueNamePattern(), cn.getTopicNamePattern(), cn.getQueueStoreFilter(), cn.getTopicStoreFilter(), cn.getUserNameFilter(), cn.eventMonitorEnabled());
                                                                                                                                            }
                                                                                                                                            if (cn.isConnected() && this.m_tabPane.getTabCount() == 1) {
                                                                                                                                                sel = 1;
                                                                                                                                                if (this.m_showEvents) {
                                                                                                                                                    state = "(stopped)";
                                                                                                                                                    if (cn.getEventMonitor() != null && cn.getEventMonitor().m_running) {
                                                                                                                                                        state = "(running)";
                                                                                                                                                    }
                                                                                                                                                    this.m_tabPane.addTab("Event Monitor" + state, this.m_messagePanel);
                                                                                                                                                    ++sel;
                                                                                                                                                }
                                                                                                                                                this.m_tabPane.addTab("Server Info", this.m_servPanel);
                                                                                                                                                this.m_tabPane.setSelectedIndex(sel);
                                                                                                                                            }
                                                                                                                                            if (!cn.isConnected()) {
                                                                                                                                                while (this.m_tabPane.getTabCount() > 1) {
                                                                                                                                                    this.m_tabPane.removeTabAt(this.m_tabPane.getTabCount() - 1);
                                                                                                                                                }
                                                                                                                                            } else {
                                                                                                                                                if (sel == 2 && this.m_tabPane.getTabCount() > 2) {
                                                                                                                                                    this.m_servPanel.getModel().populateTable(cn.getJmsServerInfoUserReq(forceUpdate), cn.getStateInfo(), cn.getLDAPParams(), cn.isRestartRequired(), cn);
                                                                                                                                                }
                                                                                                                                                if (this.m_tabPane.getTabCount() > 1 && this.m_showEvents) {
                                                                                                                                                    if (sel == 1) {
                                                                                                                                                        this.m_messagePanel.getModel().populateMessageInfo(cn.getEventMessages());
                                                                                                                                                    }
                                                                                                                                                    state = "(stopped)";
                                                                                                                                                    if (cn.getEventMonitor() != null && cn.getEventMonitor().m_running) {
                                                                                                                                                        state = "(running)";
                                                                                                                                                    }
                                                                                                                                                    this.m_tabPane.setTitleAt(1, "Event Monitor" + state);
                                                                                                                                                    if (cn.getEventMonitor() != null && cn.getEventMonitor().getMessageCount() > 0) {
                                                                                                                                                        this.m_tabPane.setIconAt(1, this.m_redicon);
                                                                                                                                                    } else {
                                                                                                                                                        this.m_tabPane.setIconAt(1, null);
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (node == null) {
                                                                                                                                                this.m_lock = false;
                                                                                                                                                return;
                                                                                                                                            }
                                                                                                                                            nodename = (String)node.getUserObject();
                                                                                                                                            maxTabIndex = 2;
                                                                                                                                            if (this.m_showEvents) {
                                                                                                                                                maxTabIndex = 3;
                                                                                                                                            }
                                                                                                                                            if (level != 1) break block146;
                                                                                                                                            while (this.m_tabPane.getTabCount() > maxTabIndex) {
                                                                                                                                                this.m_tabPane.removeTabAt(this.m_tabPane.getTabCount() - 1);
                                                                                                                                            }
                                                                                                                                            break block145;
                                                                                                                                        }
                                                                                                                                        if (level != 2) break block147;
                                                                                                                                        while (this.m_tabPane.getTabCount() > maxTabIndex + 1) {
                                                                                                                                            this.m_tabPane.removeTabAt(this.m_tabPane.getTabCount() - 1);
                                                                                                                                        }
                                                                                                                                        if (!cn.isConnected()) {
                                                                                                                                            this.m_lock = false;
                                                                                                                                            return;
                                                                                                                                        }
                                                                                                                                        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
                                                                                                                                        if (!nodename.startsWith("Consumers")) break block148;
                                                                                                                                        if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                                                                            this.m_tabPane.addTab("Consumer Info", this.m_detailsPanel);
                                                                                                                                            sel = maxTabIndex;
                                                                                                                                            this.m_tabPane.setSelectedIndex(sel);
                                                                                                                                        }
                                                                                                                                        this.m_tabPane.setTitleAt(maxTabIndex, "Consumer Info");
                                                                                                                                        if (sel >= maxTabIndex) {
                                                                                                                                            ServerInfo si3 = cn.getJmsServerInfo(false);
                                                                                                                                            if (si3.getConsumerCount() > Gems.getGems().getMaxConsumers()) {
                                                                                                                                                this.m_detailsPanel.getModel().populateErrorInfo("Too many consumers, use Show Queue/Topic Consumers. To override increase MaxConsumers in the gems.props property file");
                                                                                                                                                break block145;
                                                                                                                                            } else {
                                                                                                                                                this.m_detailsPanel.getModel().populateConsumerInfo(cn);
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                        break block145;
                                                                                                                                    }
                                                                                                                                    if (!nodename.startsWith("Producers")) break block149;
                                                                                                                                    if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                                                                        this.m_tabPane.addTab("Producer Info", this.m_detailsPanel);
                                                                                                                                        sel = maxTabIndex;
                                                                                                                                        this.m_tabPane.setSelectedIndex(sel);
                                                                                                                                    }
                                                                                                                                    this.m_tabPane.setTitleAt(maxTabIndex, "Producer Info");
                                                                                                                                    if (sel >= maxTabIndex) {
                                                                                                                                        ServerInfo si4 = cn.getJmsServerInfo(false);
                                                                                                                                        if (si4.getProducerCount() > Gems.getGems().getMaxProducers()) {
                                                                                                                                            this.m_detailsPanel.getModel().populateErrorInfo("Too many producers. To override increase MaxProducers in the gems.props property file");
                                                                                                                                            break block145;
                                                                                                                                        } else {
                                                                                                                                            this.m_detailsPanel.getModel().populateProducerInfo(cn);
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    break block145;
                                                                                                                                }
                                                                                                                                if (!nodename.equals("Users")) break block150;
                                                                                                                                if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                                                                    this.m_tabPane.addTab("User Info", this.m_detailsPanel);
                                                                                                                                    sel = maxTabIndex;
                                                                                                                                    this.m_tabPane.setSelectedIndex(sel);
                                                                                                                                }
                                                                                                                                this.m_tabPane.setTitleAt(maxTabIndex, "User Info");
                                                                                                                                if (sel >= maxTabIndex) {
                                                                                                                                    this.m_detailsPanel.getModel().populateUserInfo(cn.getJmsAdmin());
                                                                                                                                }
                                                                                                                                break block145;
                                                                                                                            }
                                                                                                                            if (!nodename.equals("Connections(Client)")) break block151;
                                                                                                                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                                                                this.m_tabPane.addTab("Client Connection Info", this.m_detailsPanel);
                                                                                                                                sel = maxTabIndex;
                                                                                                                                this.m_tabPane.setSelectedIndex(sel);
                                                                                                                            }
                                                                                                                            this.m_tabPane.setTitleAt(maxTabIndex, "Client Connection Info");
                                                                                                                            if (sel >= maxTabIndex) {
                                                                                                                                this.m_detailsPanel.getModel().populateConnectionInfo(cn);
                                                                                                                            }
                                                                                                                            break block145;
                                                                                                                        }
                                                                                                                        if (!nodename.equals("Connections(User)")) break block152;
                                                                                                                        if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                                                            this.m_tabPane.addTab("User Connection Info", this.m_detailsPanel);
                                                                                                                            sel = maxTabIndex;
                                                                                                                            this.m_tabPane.setSelectedIndex(sel);
                                                                                                                        }
                                                                                                                        this.m_tabPane.setTitleAt(maxTabIndex, "User Connection Info");
                                                                                                                        if (sel >= maxTabIndex) {
                                                                                                                            this.m_detailsPanel.getModel().populateUserConnectionInfo(cn);
                                                                                                                        }
                                                                                                                        break block145;
                                                                                                                    }
                                                                                                                    if (!nodename.equals("Connections(System)")) break block153;
                                                                                                                    if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                                                        this.m_tabPane.addTab("System Connection Info", this.m_detailsPanel);
                                                                                                                        sel = maxTabIndex;
                                                                                                                        this.m_tabPane.setSelectedIndex(sel);
                                                                                                                    }
                                                                                                                    this.m_tabPane.setTitleAt(maxTabIndex, "System Connection Info");
                                                                                                                    if (sel >= maxTabIndex) {
                                                                                                                        this.m_detailsPanel.getModel().populateSystemConnectionInfo(cn.getJmsAdmin());
                                                                                                                    }
                                                                                                                    break block145;
                                                                                                                }
                                                                                                                if (!nodename.startsWith("Connections(")) break block154;
                                                                                                                if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                                                    this.m_tabPane.addTab("Client Connection Info", this.m_detailsPanel);
                                                                                                                    sel = maxTabIndex;
                                                                                                                    this.m_tabPane.setSelectedIndex(sel);
                                                                                                                }
                                                                                                                this.m_tabPane.setTitleAt(maxTabIndex, "Client Connection Info");
                                                                                                                if (sel >= maxTabIndex) {
                                                                                                                    this.m_detailsPanel.getModel().populateConnectionInfo(cn);
                                                                                                                }
                                                                                                                break block145;
                                                                                                            }
                                                                                                            if (!nodename.startsWith("Topics")) break block155;
                                                                                                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                                                this.m_tabPane.addTab("Topics Info", this.m_detailsPanel);
                                                                                                                sel = maxTabIndex;
                                                                                                                this.m_tabPane.setSelectedIndex(sel);
                                                                                                            }
                                                                                                            this.m_tabPane.setTitleAt(maxTabIndex, "Topics Info");
                                                                                                            if (sel < maxTabIndex) break block145;
                                                                                                            si2 = cn.getJmsServerInfo(false);
                                                                                                            if (si2 != null) break block156;
                                                                                                            this.m_detailsPanel.getModel().populateErrorInfo("Not connected to EMS server");
                                                                                                            break block145;
                                                                                                        }
                                                                                                        if (si2.getTopicCount() > Gems.getGems().getMaxTopics() && cn.getTopicNamePattern().length() <= 1) {
                                                                                                            this.m_detailsPanel.getModel().populateErrorInfo("Too many topics, use Show Topics. To override increase MaxTopics in the gems.props property file or set a TopicNamePattern for this connection. ");
                                                                                                            break block145;
                                                                                                        } else {
                                                                                                            TopicInfo[] ti = cn.getTopics(cn.getTopicNamePattern(), this.getPermType());
                                                                                                            if (ti != null && ti.length == 0 && cn.getTopicStoreFilter().length() > 0 && !Arrays.asList(cn.getStoreNames()).contains(cn.getTopicStoreFilter())) {
                                                                                                                this.m_detailsPanel.getModel().populateErrorInfo("The store " + cn.getTopicStoreFilter() + " does not exist, choose a valid store filter name (case sensitive) for this connection.");
                                                                                                                break block145;
                                                                                                            } else {
                                                                                                                this.m_detailsPanel.getModel().populateTopicsInfo(cn, ti);
                                                                                                            }
                                                                                                        }
                                                                                                        break block145;
                                                                                                    }
                                                                                                    if (!nodename.startsWith("Queues")) break block157;
                                                                                                    if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                                        this.m_tabPane.addTab("Queues Info", this.m_detailsPanel);
                                                                                                        sel = maxTabIndex;
                                                                                                        this.m_tabPane.setSelectedIndex(sel);
                                                                                                    }
                                                                                                    this.m_tabPane.setTitleAt(maxTabIndex, "Queues Info");
                                                                                                    if (sel < maxTabIndex) break block145;
                                                                                                    si = cn.getJmsServerInfo(false);
                                                                                                    if (si != null) break block158;
                                                                                                    this.m_detailsPanel.getModel().populateErrorInfo("Not connected to EMS server");
                                                                                                    break block145;
                                                                                                }
                                                                                                if (si.getQueueCount() > Gems.getGems().getMaxQueues() && cn.getQueueNamePattern().length() <= 1) {
                                                                                                    this.m_detailsPanel.getModel().populateErrorInfo("Too many queues, use Show Queues. To override increase MaxQueues in the gems.props property file or set a QueueNamePattern for this connection. ");
                                                                                                    break block145;
                                                                                                } else {
                                                                                                    QueueInfo[] qi = cn.getQueues(cn.getQueueNamePattern(), this.getPermType());
                                                                                                    if (qi != null && qi.length == 0 && cn.getQueueStoreFilter().length() > 0 && !Arrays.asList(cn.getStoreNames()).contains(cn.getQueueStoreFilter())) {
                                                                                                        this.m_detailsPanel.getModel().populateErrorInfo("The store " + cn.getQueueStoreFilter() + " does not exist, choose a valid store filter name (case sensitive) for this connection.");
                                                                                                        break block145;
                                                                                                    } else {
                                                                                                        this.m_detailsPanel.getModel().populateQueuesInfo(cn, qi);
                                                                                                    }
                                                                                                }
                                                                                                break block145;
                                                                                            }
                                                                                            if (!nodename.equals("Bridges")) break block159;
                                                                                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                                this.m_tabPane.addTab("Bridge Info", this.m_detailsPanel);
                                                                                                sel = maxTabIndex;
                                                                                                this.m_tabPane.setSelectedIndex(sel);
                                                                                            }
                                                                                            this.m_tabPane.setTitleAt(maxTabIndex, "Bridge Info");
                                                                                            if (sel >= maxTabIndex) {
                                                                                                this.m_detailsPanel.getModel().populateBridgeInfo(cn);
                                                                                            }
                                                                                            break block145;
                                                                                        }
                                                                                        if (!nodename.equals("Factories")) break block160;
                                                                                        if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                            this.m_tabPane.addTab("Factories Info", this.m_detailsPanel);
                                                                                            sel = maxTabIndex;
                                                                                            this.m_tabPane.setSelectedIndex(sel);
                                                                                        }
                                                                                        this.m_tabPane.setTitleAt(maxTabIndex, "Factories Info");
                                                                                        if (sel >= maxTabIndex) {
                                                                                            this.m_detailsPanel.getModel().populateFactoryInfo(cn);
                                                                                        }
                                                                                        break block145;
                                                                                    }
                                                                                    if (!nodename.equals("Channels")) break block161;
                                                                                    if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                        this.m_tabPane.addTab("Channels Info", this.m_detailsPanel);
                                                                                        sel = maxTabIndex;
                                                                                        this.m_tabPane.setSelectedIndex(sel);
                                                                                    }
                                                                                    this.m_tabPane.setTitleAt(maxTabIndex, "Channels Info");
                                                                                    if (sel >= maxTabIndex) {
                                                                                        this.m_detailsPanel.getModel().populateChannelsInfo(cn);
                                                                                    }
                                                                                    break block145;
                                                                                }
                                                                                if (!nodename.equals("Stores")) break block162;
                                                                                if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                    this.m_tabPane.addTab("Stores Info", this.m_detailsPanel);
                                                                                    sel = maxTabIndex;
                                                                                    this.m_tabPane.setSelectedIndex(sel);
                                                                                }
                                                                                this.m_tabPane.setTitleAt(maxTabIndex, "Stores Info");
                                                                                if (sel >= maxTabIndex) {
                                                                                    this.m_detailsPanel.getModel().populateStoresFileInfo(cn);
                                                                                }
                                                                                break block145;
                                                                            }
                                                                            if (!nodename.equals("Stores(DB)")) break block163;
                                                                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                                this.m_tabPane.addTab("Stores(DB) Info", this.m_detailsPanel);
                                                                                sel = maxTabIndex;
                                                                                this.m_tabPane.setSelectedIndex(sel);
                                                                            }
                                                                            this.m_tabPane.setTitleAt(maxTabIndex, "Stores(DB) Info");
                                                                            if (sel >= maxTabIndex) {
                                                                                this.m_detailsPanel.getModel().populateStoresDbInfo(cn);
                                                                            }
                                                                            break block145;
                                                                        }
                                                                        if (!nodename.equals("Services")) break block164;
                                                                        if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                            this.m_tabPane.addTab("Service Info", this.m_detailsPanel);
                                                                            sel = maxTabIndex;
                                                                            this.m_tabPane.setSelectedIndex(sel);
                                                                        }
                                                                        this.m_tabPane.setTitleAt(maxTabIndex, "Service Info");
                                                                        if (sel >= maxTabIndex) {
                                                                            this.m_detailsPanel.getModel().populateServiceInfo(cn.m_services);
                                                                        }
                                                                        break block145;
                                                                    }
                                                                    if (!nodename.equals("Routes")) break block165;
                                                                    if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                        this.m_tabPane.addTab("Route Info", this.m_detailsPanel);
                                                                        sel = maxTabIndex;
                                                                        this.m_tabPane.setSelectedIndex(sel);
                                                                    }
                                                                    this.m_tabPane.setTitleAt(maxTabIndex, "Route Info");
                                                                    if (sel >= maxTabIndex) {
                                                                        this.m_detailsPanel.getModel().populateRoutesInfo(cn.getJmsAdmin());
                                                                    }
                                                                    break block145;
                                                                }
                                                                if (!nodename.equals("Transactions")) break block166;
                                                                if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                    this.m_tabPane.addTab("Transaction Info", this.m_detailsPanel);
                                                                    sel = maxTabIndex;
                                                                    this.m_tabPane.setSelectedIndex(sel);
                                                                }
                                                                this.m_tabPane.setTitleAt(maxTabIndex, "Transaction Info");
                                                                if (sel >= maxTabIndex) {
                                                                    this.m_detailsPanel.getModel().populateTransactionInfo(cn.getJmsAdmin());
                                                                }
                                                                break block145;
                                                            }
                                                            if (!nodename.equals("Transports")) break block167;
                                                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                                this.m_tabPane.addTab("Transport Info", this.m_detailsPanel);
                                                                sel = maxTabIndex;
                                                                this.m_tabPane.setSelectedIndex(sel);
                                                            }
                                                            this.m_tabPane.setTitleAt(maxTabIndex, "Transport Info");
                                                            if (sel >= maxTabIndex) {
                                                                this.m_detailsPanel.getModel().populateTransportInfo(cn.getJmsAdmin());
                                                            }
                                                            break block145;
                                                        }
                                                        if (!nodename.equals("Durables")) break block168;
                                                        if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                            this.m_tabPane.addTab("Durable Info", this.m_detailsPanel);
                                                            sel = maxTabIndex;
                                                            this.m_tabPane.setSelectedIndex(sel);
                                                        }
                                                        this.m_tabPane.setTitleAt(maxTabIndex, "Durable Info");
                                                        if (sel >= maxTabIndex) {
                                                            this.m_detailsPanel.getModel().populateDurablesInfo(cn.getJmsAdmin());
                                                        }
                                                        break block145;
                                                    }
                                                    if (!nodename.equals("Groups")) break block169;
                                                    if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                        this.m_tabPane.addTab("Group Info", this.m_detailsPanel);
                                                        sel = maxTabIndex;
                                                        this.m_tabPane.setSelectedIndex(sel);
                                                    }
                                                    this.m_tabPane.setTitleAt(maxTabIndex, "Group Info");
                                                    if (sel >= maxTabIndex) {
                                                        this.m_detailsPanel.getModel().populateGroupInfo(cn);
                                                    }
                                                    break block145;
                                                }
                                                if (!nodename.equals("ACLs")) break block170;
                                                if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                    this.m_tabPane.addTab("ACL Info", this.m_detailsPanel);
                                                    sel = maxTabIndex;
                                                    this.m_tabPane.setSelectedIndex(sel);
                                                }
                                                this.m_tabPane.setTitleAt(maxTabIndex, "ACL Info");
                                                if (sel >= maxTabIndex) {
                                                    this.m_detailsPanel.getModel().populateACLInfo(cn);
                                                }
                                                break block145;
                                            }
                                            if (nodename.equals("AdminACLs")) {
                                                if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                    this.m_tabPane.addTab("AdminACL Info", this.m_detailsPanel);
                                                    sel = maxTabIndex;
                                                    this.m_tabPane.setSelectedIndex(sel);
                                                }
                                                this.m_tabPane.setTitleAt(maxTabIndex, "AdminACL Info");
                                                if (sel >= maxTabIndex) {
                                                    this.m_detailsPanel.getModel().populateAdminACLInfo(cn);
                                                }
                                                break block145;
                                            } else {
                                                if (!node.getClass().getSimpleName().equals("GemsSSNode")) {
                                                    this.m_lock = false;
                                                    this.m_frame.setCursor(Cursor.getDefaultCursor());
                                                    return;
                                                }
                                                if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                                    this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                                                    sel = maxTabIndex;
                                                    this.m_tabPane.setSelectedIndex(sel);
                                                }
                                                this.m_tabPane.setTitleAt(maxTabIndex, "SubStation Info");
                                                if (sel >= maxTabIndex) {
                                                    ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSInfo(cn, (GemsSSNode)node);
                                                }
                                            }
                                            break block145;
                                        }
                                        if (level != 3) break block171;
                                        if (!cn.isConnected()) {
                                            this.m_lock = false;
                                            return;
                                        }
                                        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
                                        parentname = (String)((DefaultMutableTreeNode)node.getParent()).getUserObject();
                                        if (!parentname.startsWith("Topics")) break block172;
                                        if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                            this.m_tabPane.addTab("Topic Info", this.m_detailsPanel);
                                            sel = maxTabIndex;
                                            this.m_tabPane.setSelectedIndex(sel);
                                        }
                                        this.m_tabPane.setTitleAt(maxTabIndex, "Topic Info");
                                        if (sel >= maxTabIndex) {
                                            this.m_detailsPanel.getModel().populateTopicInfo(cn, nodename);
                                        }
                                        break block145;
                                    }
                                    if (!parentname.startsWith("Queues")) break block173;
                                    if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                        this.m_tabPane.addTab("Queue Info", this.m_detailsPanel);
                                        sel = maxTabIndex;
                                        this.m_tabPane.setSelectedIndex(sel);
                                    }
                                    this.m_tabPane.setTitleAt(maxTabIndex, "Queue Info");
                                    if (sel >= maxTabIndex) {
                                        this.m_detailsPanel.getModel().populateQueueInfo(cn, nodename);
                                    }
                                    break block145;
                                }
                                if (!node.getParent().getClass().getSimpleName().equals("GemsSSNode")) break block145;
                                if (!nodename.equals("Counters")) break block174;
                                if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                    this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                                    sel = maxTabIndex;
                                    this.m_tabPane.setSelectedIndex(sel);
                                }
                                this.m_tabPane.setTitleAt(maxTabIndex, "SubStation Counters Info");
                                if (sel >= maxTabIndex) {
                                    ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSCounters(cn, (GemsSSNode)node.getParent());
                                }
                                break block145;
                            }
                            if (!nodename.equals("Interfaces")) break block175;
                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                                sel = maxTabIndex;
                                this.m_tabPane.setSelectedIndex(sel);
                            }
                            this.m_tabPane.setTitleAt(maxTabIndex, "SubStation Interfaces Info");
                            if (sel >= maxTabIndex) {
                                ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSInterface(cn, (GemsSSNode)node.getParent());
                            }
                            break block145;
                        }
                        if (!nodename.equals("Transports")) break block176;
                        if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                            this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                            sel = maxTabIndex;
                            this.m_tabPane.setSelectedIndex(sel);
                        }
                        this.m_tabPane.setTitleAt(maxTabIndex, "SubStation Transports Info");
                        if (sel >= maxTabIndex) {
                            ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSTransport(cn, (GemsSSNode)node.getParent());
                        }
                        break block145;
                    }
                    if (nodename.equals("IMS")) {
                        if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                            this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                            sel = maxTabIndex;
                            this.m_tabPane.setSelectedIndex(sel);
                        }
                        this.m_tabPane.setTitleAt(maxTabIndex, "SubStation IMS General");
                        if (sel >= maxTabIndex) {
                            ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSIMSGen(cn, (GemsSSNode)node.getParent());
                        }
                    }
                    break block145;
                }
                if (level == 4) {
                    if (!cn.isConnected()) {
                        this.m_lock = false;
                        return;
                    }
                    this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
                    String parentname2 = (String)((DefaultMutableTreeNode)node.getParent()).getUserObject();
                    String IntName = "";
                    IntName = parentname2.startsWith("CICS") ? parentname2.substring(6) : parentname2.substring(5);
                    if (node.getParent().getParent().getClass().getSimpleName().equals("GemsSSNode")) {
                        if (nodename.equals("Listeners")) {
                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                                sel = maxTabIndex;
                                this.m_tabPane.setSelectedIndex(sel);
                            }
                            this.m_tabPane.setTitleAt(maxTabIndex, "SubStation Listeners Info");
                            if (sel >= maxTabIndex) {
                                ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSListeners(cn, (GemsSSNode)node.getParent().getParent(), IntName);
                            }
                        } else if (nodename.equals("Active Recipes")) {
                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                                sel = maxTabIndex;
                                this.m_tabPane.setSelectedIndex(sel);
                            }
                            this.m_tabPane.setTitleAt(maxTabIndex, "SubStation Active Recipes Info");
                            if (sel >= maxTabIndex) {
                                ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSActive(cn, (GemsSSNode)node.getParent().getParent(), "RID", IntName);
                            }
                        } else if (nodename.equals("Suspended")) {
                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                                sel = maxTabIndex;
                                this.m_tabPane.setSelectedIndex(sel);
                            }
                            this.m_tabPane.setTitleAt(maxTabIndex, "SubStation Suspended Recipes Info");
                            if (sel >= maxTabIndex) {
                                ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSSuspend(cn, (GemsSSNode)node.getParent().getParent(), IntName);
                            }
                        } else if (nodename.equals("Active Triggers")) {
                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                                sel = maxTabIndex;
                                this.m_tabPane.setSelectedIndex(sel);
                            }
                            this.m_tabPane.setTitleAt(maxTabIndex, "SubStation Active Triggers Info");
                            if (sel >= maxTabIndex) {
                                ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSActive(cn, (GemsSSNode)node.getParent().getParent(), "TID", IntName);
                            }
                        } else if (nodename.equals("Disabled")) {
                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                                sel = maxTabIndex;
                                this.m_tabPane.setSelectedIndex(sel);
                            }
                            this.m_tabPane.setTitleAt(maxTabIndex, "SubStation Disabled Info");
                            if (sel >= maxTabIndex) {
                                ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSInActive(cn, (GemsSSNode)node.getParent().getParent(), IntName);
                            }
                        } else if (nodename.equals("IMS Statistics")) {
                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                                sel = maxTabIndex;
                                this.m_tabPane.setSelectedIndex(sel);
                            }
                            this.m_tabPane.setTitleAt(maxTabIndex, "SubStation IMS Statistics");
                            if (sel >= maxTabIndex) {
                                ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSIMSStats(cn, (GemsSSNode)node.getParent().getParent(), IntName);
                            }
                        } else if (nodename.equals("IMS Buffers")) {
                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                this.m_tabPane.addTab("SubStation Info", this.m_detailsPanel);
                                sel = maxTabIndex;
                                this.m_tabPane.setSelectedIndex(sel);
                            }
                            this.m_tabPane.setTitleAt(maxTabIndex, "SubStation IMS Buffers");
                            if (sel >= maxTabIndex) {
                                ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSIMSBuffers(cn, (GemsSSNode)node.getParent().getParent(), IntName);
                            }
                        } else if (nodename.equals("SXTH")) {
                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                this.m_tabPane.addTab("SXTH Info", this.m_detailsPanel);
                                sel = maxTabIndex;
                                this.m_tabPane.setSelectedIndex(sel);
                            }
                            this.m_tabPane.setTitleAt(maxTabIndex, "SXTH Data");
                            if (sel >= maxTabIndex) {
                                ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSSXTH(cn, (GemsSSNode)node.getParent().getParent(), IntName);
                            }
                        } else if (nodename.equals("Transactions")) {
                            if (cn.isConnected() && this.m_tabPane.getTabCount() == maxTabIndex) {
                                this.m_tabPane.addTab("CICS Transactions", this.m_detailsPanel);
                                sel = maxTabIndex;
                                this.m_tabPane.setSelectedIndex(sel);
                            }
                            this.m_tabPane.setTitleAt(maxTabIndex, "Transactions");
                            if (sel >= maxTabIndex) {
                                ((GemsSSDetailsTableModel)this.m_detailsPanel.getModel()).populateSSCEMT(cn, (GemsSSNode)node.getParent().getParent(), IntName);
                            }
                        }
                    }
                }
            }
            this.m_frame.setCursor(Cursor.getDefaultCursor());
            this.m_lock = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Gems.debug(ex.toString());
            System.err.println("Exception: " + ex.getMessage());
            this.m_frame.setCursor(Cursor.getDefaultCursor());
            this.m_lock = false;
            if (cn != null) {
                cn.disconnect(true);
            }
            return;
        }
        this.m_lock = false;
    }

    public void selectLastTab() {
        if (this.m_tabPane.getSelectedIndex() != this.m_tabPane.getTabCount() - 1) {
            this.m_tabPane.setSelectedIndex(this.m_tabPane.getTabCount() - 1);
        }
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        String hv = Gems.getGems().getHideViews();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Save Config..."));
        menuItem.addActionListener(new ShowConfig());
        menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ExitAction());
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuItem = menu.add(new JMenuItem("Add New EMS Server"));
        menuItem.addActionListener(new AddConnectionAction());
        menuItem = menu.add(new JMenuItem("Remove Selected EMS Server"));
        menuItem.addActionListener(new RemoveConnectionAction());
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("Add New Folder..."));
        menuItem.addActionListener(new AddFolderAction());
        menuItem = menu.add(new JMenuItem("Remove Selected Folder"));
        menuItem.addActionListener(new RemoveFolderAction());
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("Edit Warning Limits..."));
        menuItem.addActionListener(new SetLimitsAction("Warning"));
        menuItem = menu.add(new JMenuItem("Edit Error Limits..."));
        menuItem.addActionListener(new SetLimitsAction("Error"));
        menuItem = menu.add(new JMenuItem("Edit Monitor Events..."));
        menuItem.addActionListener(new EditMonitorEventsAction());
        menu.addSeparator();
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("View");
        menu.setMnemonic(86);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("All Servers"));
        menuItem.addActionListener(new ShowAllServersAction());
        this.m_showTotals = new JCheckBoxMenuItem("Show Server Totals");
        this.m_showTotals.setState(this.getShowTotals());
        this.m_showTotals.addActionListener(new ShowTotalsAction());
        menuItem = menu.add(this.m_showTotals);
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("Refresh"));
        menuItem.addActionListener(new RefreshAction());
        this.m_autoRefresh = new JCheckBoxMenuItem("Auto Refresh");
        if (this.m_displayRefresh > 0) {
            this.m_autoRefresh.setState(true);
            menuItem = menu.add(this.m_autoRefresh);
        }
        if (this.m_displayRefresh > 0) {
            menu = new JMenu("Chart");
            menu.setMnemonic(67);
            menuBar.add(menu);
            menuItem = menu.add(new JMenuItem("Real Time Chart..."));
            menuItem.addActionListener(new ChartAction());
            menuItem = menu.add(new JMenuItem("Today's Chart..."));
            menuItem.addActionListener(new TodaysChartAction());
            menuItem = menu.add(new JMenuItem("Historical Chart..."));
            menuItem.addActionListener(new HistoricalChartAction());
        }
        menu = new JMenu("Server");
        menu.setMnemonic(83);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("Show Server Properties"));
        menuItem.addActionListener(new ShowServerPropertiesAction());
        menuItem = menu.add(new JMenuItem("Show Server Events"));
        menuItem.addActionListener(new ShowServerEventsAction());
        menuItem = menu.add(new JMenuItem("Show System Queues..."));
        menuItem.addActionListener(new ShowSystemQueuesAction());
        menuItem = menu.add(new JMenuItem("Show System Topics..."));
        menuItem.addActionListener(new ShowSystemTopicsAction());
        menu.addSeparator();
        if (!this.getViewOnlyMode()) {
            menuItem = menu.add(new JMenuItem("Set Server Property..."));
            menuItem.addActionListener(new SetServerPropertyAction());
            menuItem = menu.add(new JMenuItem("Set Server Trace..."));
            menuItem.addActionListener(new SetServerTraceAction());
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Edit Server JSON Config..."));
            menuItem.addActionListener(new EditJSONConfig());
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Monitor Client Connections..."));
            menuItem.addActionListener(new MonitorConnectionAction());
        }
        if (!this.getViewOnlyMode() && hv.indexOf("Connections") < 0) {
            menuItem = menu.add(new JMenuItem("Destroy Client Connection"));
            menuItem.addActionListener(new DisconnectClientAction());
            menu.addSeparator();
        }
        if (!this.getViewOnlyMode()) {
            menuItem = menu.add(new JMenuItem("Monitor Local Transactions..."));
            menuItem.addActionListener(new MonitorLocalTransactionsAction());
            menuItem = menu.add(new JMenuItem("Monitor XA Transactions..."));
            menuItem.addActionListener(new MonitorXATransactionsAction());
            menu.addSeparator();
        }
        JMenu menu1 = new JMenu("Enable Client Trace");
        menu.add(menu1);
        menuItem = menu1.add(new JMenuItem("To stdout"));
        menuItem.addActionListener(new EnableClientTraceAction(true));
        menuItem = menu1.add(new JMenuItem("To stderr"));
        menuItem.addActionListener(new EnableClientTraceAction(false));
        menuItem = menu.add(new JMenuItem("Disable Client Trace"));
        menuItem.addActionListener(new DisableClientTraceAction());
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("Lookup JNDI Name..."));
        menuItem.addActionListener(new LookupJNDIAction());
        if (!this.getViewOnlyMode() && hv.indexOf("Bridges") < 0) {
            menu = new JMenu("Bridges");
            menu.setMnemonic(66);
            menuBar.add(menu);
            menuItem = menu.add(new JMenuItem("Create Bridge"));
            menuItem.addActionListener(new CreateBridgeAction());
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Destroy Bridge"));
            menuItem.addActionListener(new DestroyBridgeAction());
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Manage Bridges..."));
            menuItem.addActionListener(new FindBridgeTargetsAction());
        }
        menu = new JMenu("Queues");
        menu.setMnemonic(81);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("Show Queues..."));
        menuItem.addActionListener(new ShowQueuesAction());
        menuItem = menu.add(new JMenuItem("Show Queue Properties..."));
        menuItem.addActionListener(new SetQueuePropertyAction());
        menuItem = menu.add(new JMenuItem("Show Queue Consumers..."));
        menuItem.addActionListener(new ShowQueueConsumersAction());
        if (!this.getViewOnlyMode() || this.getAllowMsgReadInViewOnlyMode()) {
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Browse Queue..."));
            menuItem.addActionListener(new BrowseQueueAction());
        }
        if (!this.getViewOnlyMode()) {
            menuItem = menu.add(new JMenuItem("Monitor Queue..."));
            menuItem.addActionListener(new MonitorQueueAction());
            menuItem = menu.add(new JMenuItem("Monitor Request/Reply Queue..."));
            menuItem.addActionListener(new MonitorReqReplyQueueAction());
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Send TextMessage..."));
            menuItem.addActionListener(new SendMessageAction(false));
            menuItem = menu.add(new JMenuItem("Send MapMessage..."));
            menuItem.addActionListener(new SendMessageAction(true));
            menuItem = menu.add(new JMenuItem("Send Saved Messages..."));
            menuItem.addActionListener(new QueueMessageSenderAction());
            menuItem = menu.add(new JMenuItem("Copy All Messages..."));
            menuItem.addActionListener(new CopyQueueMessagesAction());
            menuItem = menu.add(new JMenuItem("Request/Reply Tester..."));
            menuItem.addActionListener(new RequestReplyTesterAction(true));
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Create Queue"));
            menuItem.addActionListener(new CreateQueueAction());
            menuItem = menu.add(new JMenuItem("Set Queue Permissions..."));
            menuItem.addActionListener(new SetQueuePermissionsAction());
            menu.addSeparator();
            if (hv.indexOf("Queues") < 0) {
                menuItem = menu.add(new JMenuItem("Purge Queue"));
                menuItem.addActionListener(new PurgeQueueAction());
            }
            menuItem = menu.add(new JMenuItem("Purge Multiple Queues..."));
            menuItem.addActionListener(new PurgeQueuesAction());
            menuItem = menu.add(new JMenuItem("Purge $TMP Queues..."));
            menuItem.addActionListener(new PurgeTMPQueuesAction());
            if (hv.indexOf("Queues") < 0) {
                menuItem = menu.add(new JMenuItem("Destroy Queue"));
                menuItem.addActionListener(new DeleteQueueAction());
            }
        }
        menu = new JMenu("Topics");
        menu.setMnemonic(84);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("Show Topics..."));
        menuItem.addActionListener(new ShowTopicsAction());
        menuItem = menu.add(new JMenuItem("Show Topic Properties..."));
        menuItem.addActionListener(new SetTopicPropertyAction());
        menuItem = menu.add(new JMenuItem("Show Topic Consumers..."));
        menuItem.addActionListener(new ShowTopicConsumersAction());
        try {
            Class.forName("com.tibco.tibjms.admin.SubscriptionInfo");
            menuItem = menu.add(new JMenuItem("Show Topic Subscriptions..."));
            menuItem.addActionListener(new ShowTopicSubscriptionsAction());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!this.getViewOnlyMode() || this.getAllowMsgReadInViewOnlyMode()) {
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Subscribe to Topic..."));
            menuItem.addActionListener(new SubscribeTopicAction());
        }
        if (!this.getViewOnlyMode()) {
            menuItem = menu.add(new JMenuItem("Monitor Topic..."));
            menuItem.addActionListener(new MonitorTopicAction());
            menuItem = menu.add(new JMenuItem("Monitor Request/Reply Topic..."));
            menuItem.addActionListener(new MonitorReqReplyTopicAction());
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Publish TextMessage..."));
            menuItem.addActionListener(new PublishMessageAction(false));
            menuItem = menu.add(new JMenuItem("Publish MapMessage..."));
            menuItem.addActionListener(new PublishMessageAction(true));
            menuItem = menu.add(new JMenuItem("Publish Saved Messages..."));
            menuItem.addActionListener(new TopicMessageSenderAction());
            menuItem = menu.add(new JMenuItem("Request/Reply Tester..."));
            menuItem.addActionListener(new RequestReplyTesterAction(false));
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Create Topic"));
            menuItem.addActionListener(new CreateTopicAction());
            menuItem = menu.add(new JMenuItem("Set Topic Permissions..."));
            menuItem.addActionListener(new SetTopicPermissionsAction());
            menu.addSeparator();
            if (hv.indexOf("Topics") < 0) {
                menuItem = menu.add(new JMenuItem("Purge Topic"));
                menuItem.addActionListener(new PurgeTopicAction());
            }
            menuItem = menu.add(new JMenuItem("Purge Multiple Topics..."));
            menuItem.addActionListener(new PurgeTopicsAction());
            menuItem = menu.add(new JMenuItem("Purge $TMP Topics..."));
            menuItem.addActionListener(new PurgeTMPTopicsAction());
            if (hv.indexOf("Topics") < 0) {
                menuItem = menu.add(new JMenuItem("Destroy Topic"));
                menuItem.addActionListener(new DeleteTopicAction());
            }
        }
        if (hv.indexOf("Durables") < 0 && (!this.getViewOnlyMode() || this.getAllowMsgReadInViewOnlyMode())) {
            menu = new JMenu("Durables");
            menu.setMnemonic(68);
            menuBar.add(menu);
            menuItem = menu.add(new JMenuItem("Browse Durable..."));
            menuItem.addActionListener(new BrowseDurableAction());
            if (!this.getViewOnlyMode()) {
                menuItem = menu.add(new JMenuItem("Create Durable"));
                menuItem.addActionListener(new CreateDurableAction());
                menu.addSeparator();
                menuItem = menu.add(new JMenuItem("Destroy Durable"));
                menuItem.addActionListener(new DestroyDurableAction());
                menuItem = menu.add(new JMenuItem("Purge Durable"));
                menuItem.addActionListener(new PurgeDurableAction());
            }
        }
        if (!this.getViewOnlyMode() && hv.indexOf("Users") < 0) {
            menu = new JMenu("Users");
            menu.setMnemonic(85);
            menuBar.add(menu);
            menuItem = menu.add(new JMenuItem("Create User"));
            menuItem.addActionListener(new CreateUserAction());
            menuItem = menu.add(new JMenuItem("Update User"));
            menuItem.addActionListener(new UpdateUserAction());
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Create Group"));
            menuItem.addActionListener(new CreateGroupAction());
            menuItem = menu.add(new JMenuItem("Add User To Group"));
            menuItem.addActionListener(new AddUserToGroupAction());
            menuItem = menu.add(new JMenuItem("Remove User From Group"));
            menuItem.addActionListener(new RemoveUserFromGroupAction());
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Set Admin Permissions..."));
            menuItem.addActionListener(new SetAdminPermissionsAction());
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Destroy User"));
            menuItem.addActionListener(new DestroyUserAction());
            menuItem = menu.add(new JMenuItem("Destroy Group"));
            menuItem.addActionListener(new DestroyGroupAction());
        }
        if (!this.getViewOnlyMode() && hv.indexOf("Routes") < 0) {
            menu = new JMenu("Routes");
            menu.setMnemonic(82);
            menuBar.add(menu);
            menuItem = menu.add(new JMenuItem("Create Route"));
            menuItem.addActionListener(new CreateRouteAction());
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Destroy Route"));
            menuItem.addActionListener(new DestroyRouteAction());
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Monitor Routes..."));
            menuItem.addActionListener(new MonitorRouteAction());
        }
        if (this.m_serviceMenu) {
            menu = new JMenu("Services");
            menu.setMnemonic(83);
            menuBar.add(menu);
            menuItem = menu.add(new JMenuItem("Enable Service Monitoring"));
            menuItem.addActionListener(new StartServiceMonitoringAction());
            menuItem = menu.add(new JMenuItem("Disable Service Monitoring"));
            menuItem.addActionListener(new StopServiceMonitoringAction());
        }
        if (!this.getViewOnlyMode() && hv.indexOf("Factories") < 0) {
            menu = new JMenu("Factories");
            menu.setMnemonic(65);
            menuBar.add(menu);
            menuItem = menu.add(new JMenuItem("Create Connection Factory..."));
            menuItem.addActionListener(new CreateFactoryAction());
            menuItem = menu.add(new JMenuItem("Update Connection Factory..."));
            menuItem.addActionListener(new UpdateFactoryAction());
            menuItem = menu.add(new JMenuItem("Destroy Connection Factory"));
            menuItem.addActionListener(new DestroyFactoryAction());
        }
        if (!this.getViewOnlyMode() && this.m_substationMenu) {
            menu = new JMenu("SubStation");
            menu.setMnemonic(78);
            menuBar.add(menu);
            menuItem = menu.add(new JMenuItem("Refresh"));
            menuItem.addActionListener(new RefreshSSAction());
            menuItem = menu.add(new JMenuItem("Enable"));
            menuItem.addActionListener(new EnableSSAction());
            menuItem = menu.add(new JMenuItem("Disable"));
            menuItem.addActionListener(new DisableSSAction());
            menuItem = menu.add(new JMenuItem("Suspend"));
            menuItem.addActionListener(new SuspendSSAction());
            menuItem = menu.add(new JMenuItem("Unload"));
            menuItem.addActionListener(new UnloadSSAction());
            menuItem = menu.add(new JMenuItem("Recover"));
            menuItem.addActionListener(new RecoverSSAction());
            menuItem = menu.add(new JMenuItem("Enable New Object"));
            menuItem.addActionListener(new NewSSRecipeAction());
            menuItem = menu.add(new JMenuItem("Reset Counters"));
            menuItem.addActionListener(new ResetSSAction());
        }
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menuBar.add(menu);
        if (this.m_jreVersion != null && !this.m_jreVersion.startsWith("1.5")) {
            menuItem = menu.add(new JMenuItem("Help..."));
            menuItem.addActionListener(new ShowHelp());
        }
        menuItem = menu.add(new JMenuItem("About Gems..."));
        menuItem.addActionListener(new AboutAction());
        return menuBar;
    }

    protected DefaultMutableTreeNode getSelectedNode() {
        TreePath selPath = this.m_tree.getSelectionPath();
        if (selPath != null) {
            return (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    protected GemsConnectionNode getConnectionNode() {
        TreePath selPath = this.m_tree.getSelectionPath();
        if (selPath != null) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if (n.isRoot()) {
                DefaultMutableTreeNode n1;
                if (n.getChildCount() == 1 && (n1 = (DefaultMutableTreeNode)n.getChildAt(0)) instanceof GemsConnectionNode) {
                    return (GemsConnectionNode)n1;
                }
                return null;
            }
            GemsConnectionNode cn = null;
            while (n.getLevel() > 0) {
                if (n instanceof GemsConnectionNode) {
                    cn = (GemsConnectionNode)n;
                    break;
                }
                n = (DefaultMutableTreeNode)n.getParent();
            }
            return cn;
        }
        return null;
    }

    protected GemsSSNode getSSConnectionNode() {
        TreePath selPath = this.m_tree.getSelectionPath();
        if (selPath != null) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if (n.isRoot()) {
                return null;
            }
            GemsSSNode cn = null;
            while (n.getLevel() > 0) {
                if (n instanceof GemsSSNode) {
                    cn = (GemsSSNode)n;
                    break;
                }
                n = (DefaultMutableTreeNode)n.getParent();
            }
            return cn;
        }
        return null;
    }

    protected boolean checkConnected(String word) {
        GemsConnectionNode node = this.getConnectionNode();
        if (node == null || !node.isConnected()) {
            if (word != null) {
                JOptionPane.showMessageDialog(this.m_frame, "Select a " + word + " for an EMS server!", "Error", 1);
            } else {
                JOptionPane.showMessageDialog(this.m_frame, "Select an EMS server in the tree view", "Error", 1);
            }
            return false;
        }
        return true;
    }

    protected TreePath[] getSelectedPaths() {
        return this.m_tree.getSelectionPaths();
    }

    public void doExit() {
        int opt;
        if (this.isDirty() && (opt = JOptionPane.showConfirmDialog(this.m_frame, "Configuration has changed, save changes?", "Exit", 0)) == 0) {
            GemsConfigDialog d = new GemsConfigDialog(this.m_frame);
            d.show();
            if (this.isDirty()) {
                return;
            }
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        m_gems = new Gems(args);
        m_gems.start();
    }

    public static Gems getGems() {
        return m_gems;
    }

    public void initProps(String propFile) {
        this.m_props = new Properties();
        this.m_props.setProperty("MaxMessageView", "100");
        this.m_props.setProperty("ViewOldMessagesFirst", "false");
        this.m_props.setProperty("QueueNamePattern", ">");
        this.m_props.setProperty("TopicNamePattern", ">");
        this.m_props.setProperty("ShowExtendedProperties", "false");
        this.m_props.setProperty("DisplayRefresh", "20");
        this.m_props.setProperty("ShowMonitorTopics", "false");
        this.m_props.setProperty("DisplayWidth", "1200");
        this.m_props.setProperty("DisplayHeight", "600");
        this.m_props.setProperty("ShowRootNode", "true");
        this.m_props.setProperty("ColourPendingMsgs", "true");
        this.m_props.setProperty("MsgReadDelay", "100");
        this.m_props.setProperty("RequestReplyTimeout", "10");
        this.m_props.setProperty("ServerConfigFile", "servers.xml");
        this.m_props.setProperty("ViewOnlyMode", "true");
        this.m_props.setProperty("AllowMsgReadInViewOnlyMode", "false");
        this.m_props.setProperty("Debug", "false");
        this.m_props.setProperty("LookAndFeel", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        this.m_props.setProperty("PermType", "3");
        this.m_props.setProperty("MaxDisplayBytes", "1024");
        this.m_props.setProperty("ShowClientId", "false");
        this.m_props.setProperty("HideViews", "");
        this.m_props.setProperty("ShowTotals", "false");
        this.m_props.setProperty("ConnectTimeout", "500");
        this.m_props.setProperty("SSTimeout", "5000");
        this.m_props.setProperty("SSCountersErrorTH", "10");
        this.m_props.setProperty("SSCountersWarnTH", "10000");
        this.m_props.setProperty("SSCountersHighTH", "100000");
        this.m_props.setProperty("SSStressErrorTH", "100000");
        this.m_props.setProperty("SSStressWarnTH", "10000");
        this.m_props.setProperty("SSBusyErrorTH", "1000");
        this.m_props.setProperty("SSBusyWarnTH", "10");
        this.m_props.setProperty("AdminTimeout", "5000");
        this.m_props.setProperty("AllowStandbyOperations", "false");
        this.m_props.setProperty("UseServerTimestamps", "false");
        this.m_props.setProperty("ShowRootInTitleBar", "false");
        this.m_props.setProperty("ShowPathInTitleBar", "true");
        this.m_props.setProperty("DetailPanelColWidths", "");
        this.m_props.setProperty("LogDateTimeFormat", "EEE MMM dd HH:mm:ss SSS zzz yyyy");
        this.m_props.setProperty("CSVFileDelimiter", ",");
        this.m_props.setProperty("MaxQueues", "1000");
        this.m_props.setProperty("MaxTopics", "1000");
        this.m_props.setProperty("MaxConsumers", "1000");
        this.m_props.setProperty("MaxProducers", "1000");
        this.m_props.setProperty("MaxMonitorEvents", "1000");
        this.m_props.setProperty("ServerInfoColPositions", "");
        this.m_props.setProperty("DisableAutoConnectAfterTimeoutException", "false");
        this.m_props.setProperty("AutoReconnectToPrimary", "true");
        this.m_props.setProperty("MaxMonitorBacklog", "1000");
        this.m_props.setProperty("DestCursorSize", "100");
        this.m_props.setProperty("DisableCursors", "false");
        this.m_props.setProperty("AllowPatternOverride", "false");
        this.m_props.setProperty("AppliancePollPeriod", "60");
        this.m_props.setProperty("ApplianceSshTimeout", "5");
        this.m_props.setProperty("UserNameFilter", "");
        this.m_props.setProperty("ShowApplFullyOp", "false");
        this.m_props.setProperty("AutoConnectOnStart", "true");
        this.m_props.setProperty("HideTreeDests", "true");
        if (propFile != null) {
            try {
                FileInputStream f = new FileInputStream(propFile);
                this.m_props.load(f);
            }
            catch (Exception ie) {
                System.err.println("Exception: " + ie.getMessage());
                return;
            }
        }
        this.m_displayRefresh = this.getDisplayRefresh();
    }

    public String getProp(String prop) {
        return this.m_props.getProperty(prop);
    }

    public String getQueueNamePattern() {
        return this.m_props.getProperty("QueueNamePattern");
    }

    public String getTopicNamePattern() {
        return this.m_props.getProperty("TopicNamePattern");
    }

    public String getUserNameFilter() {
        String s = this.m_props.getProperty("UserNameFilter");
        if (s != null && s.length() == 0) {
            return "";
        }
        return s;
    }

    public String getServerConfigFile() {
        if (this.m_serversFileArg != null) {
            return this.m_serversFileArg;
        }
        return this.m_props.getProperty("ServerConfigFile");
    }

    public String getLookAndFeel() {
        return this.m_props.getProperty("LookAndFeel");
    }

    public String getHideViews() {
        return this.m_props.getProperty("HideViews");
    }

    public String getDetailPaneColWidths() {
        return this.m_props.getProperty("DetailPanelColWidths");
    }

    public String getLogDateTimeFormat() {
        return this.m_props.getProperty("LogDateTimeFormat");
    }

    public int getMaxDisplayBytes() {
        try {
            return Integer.parseInt(this.m_props.getProperty("MaxDisplayBytes"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 1024;
        }
    }

    public int getScreenWidth() {
        try {
            return Integer.parseInt(this.m_props.getProperty("DisplayWidth"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 1200;
        }
    }

    public int getPermType() {
        try {
            return Integer.parseInt(this.m_props.getProperty("PermType"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 3;
        }
    }

    public int getScreenHeight() {
        try {
            return Integer.parseInt(this.m_props.getProperty("DisplayHeight"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 600;
        }
    }

    public int getMaxMessageView() {
        try {
            return Integer.parseInt(this.m_props.getProperty("MaxMessageView"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 100;
        }
    }

    public int getDisplayRefresh() {
        try {
            return Integer.parseInt(this.m_props.getProperty("DisplayRefresh"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 20;
        }
    }

    public long getConnectTimeout() {
        try {
            return Long.parseLong(this.m_props.getProperty("ConnectTimeout"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 500L;
        }
    }

    public long getMaxMonitorBacklog() {
        try {
            return Long.parseLong(this.m_props.getProperty("MaxMonitorBacklog"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 1000L;
        }
    }

    public int getDestCursorSize() {
        try {
            return Integer.parseInt(this.m_props.getProperty("DestCursorSize"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 100;
        }
    }

    public long getSSTimeout() {
        try {
            return Long.parseLong(this.m_props.getProperty("SSTimeout"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 5000L;
        }
    }

    public int getSSCountersErrorTH() {
        try {
            return Integer.parseInt(this.m_props.getProperty("SSCountersErrorTH"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 100;
        }
    }

    public int getSSCountersHighTH() {
        try {
            return Integer.parseInt(this.m_props.getProperty("SSCountersHighTH"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 100000;
        }
    }

    public int getSSCountersWarnTH() {
        try {
            return Integer.parseInt(this.m_props.getProperty("SSCountersWarnTH"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 10000;
        }
    }

    public int getSSStressErrorTH() {
        try {
            return Integer.parseInt(this.m_props.getProperty("SSStressErrorTH"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 100;
        }
    }

    public int getSSStressWarnTH() {
        try {
            return Integer.parseInt(this.m_props.getProperty("SSStressWarnTH"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 1;
        }
    }

    public int getSSBusyErrorTH() {
        try {
            return Integer.parseInt(this.m_props.getProperty("SSBusyErrorTH"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 100;
        }
    }

    public int getSSBusyWarnTH() {
        try {
            return Integer.parseInt(this.m_props.getProperty("SSBusyWarnTH"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 1;
        }
    }

    public long getAdminTimeout() {
        try {
            return Long.parseLong(this.m_props.getProperty("AdminTimeout"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 5000L;
        }
    }

    public boolean getAutoConnectOnStart() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("AutoConnectOnStart"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return true;
        }
    }

    public boolean getAutoReconnectToPrimary() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("AutoReconnectToPrimary"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return true;
        }
    }

    public boolean getDisableAutoConnectAfterTimeoutException() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("DisableAutoConnectAfterTimeoutException"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return false;
        }
    }

    public boolean getShowPathInTitleBar() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("ShowPathInTitleBar"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return true;
        }
    }

    public boolean getShowRootInTitleBar() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("ShowRootInTitleBar"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return false;
        }
    }

    public boolean getViewOldMessagesFirst() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("ViewOldMessagesFirst"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return false;
        }
    }

    public void setViewOldMessagesFirst(boolean b) {
        if (b) {
            this.m_props.setProperty("ViewOldMessagesFirst", "true");
        } else {
            this.m_props.setProperty("ViewOldMessagesFirst", "false");
        }
    }

    public boolean getUseServerTimestamps() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("UseServerTimestamps"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return false;
        }
    }

    public void setUseServerTimestamps(boolean b) {
        if (b) {
            this.m_props.setProperty("UseServerTimestamps", "true");
        } else {
            this.m_props.setProperty("UseServerTimestamps", "false");
        }
    }

    public boolean getViewOnlyMode() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("ViewOnlyMode"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return true;
        }
    }

    public boolean getAllowMsgReadInViewOnlyMode() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("AllowMsgReadInViewOnlyMode"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return false;
        }
    }

    public boolean getAllowStandbyOperations() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("AllowStandbyOperations"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return false;
        }
    }

    public void setShowTotals(boolean b) {
        if (b) {
            this.m_props.setProperty("ShowTotals", "true");
        } else {
            this.m_props.setProperty("ShowTotals", "false");
        }
        this.m_showTotals.setState(b);
        this.treeSelectionChange(this.getSelectedNode(), true);
    }

    public boolean getShowTotals() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("ShowTotals"));
        }
        catch (Exception ie) {
            return false;
        }
    }

    public boolean getShowApplFullyOp() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("ShowApplFullyOp"));
        }
        catch (Exception ie) {
            return false;
        }
    }

    public boolean getDebug() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("Debug"));
        }
        catch (Exception ie) {
            return false;
        }
    }

    public boolean getShowRootNode() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("ShowRootNode"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return true;
        }
    }

    public boolean getShowMonitorTopics() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("ShowMonitorTopics"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return false;
        }
    }

    public boolean getColourPendingMsgs() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("ColourPendingMsgs"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return true;
        }
    }

    public boolean getShowExtendedProperties() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("ShowExtendedProperties"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return false;
        }
    }

    public boolean getShowClientId() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("ShowClientId"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return false;
        }
    }

    public boolean getAllowPatternOverride() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("AllowPatternOverride"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return false;
        }
    }

    public boolean getDisableCursors() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("DisableCursors"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return false;
        }
    }

    public boolean getHideTreeDests() {
        try {
            return Boolean.valueOf(this.m_props.getProperty("HideTreeDests"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return true;
        }
    }

    public int getMsgReadDelay() {
        try {
            int i = Integer.parseInt(this.m_props.getProperty("MsgReadDelay"));
            if (i < 10) {
                i = 10;
            }
            return i;
        }
        catch (Exception ie) {
            this.m_props.setProperty("MsgReadDelay", "100");
            return 100;
        }
    }

    public int getRequestReplyTimeout() {
        try {
            return Integer.parseInt(this.m_props.getProperty("RequestReplyTimeout"));
        }
        catch (Exception ie) {
            this.m_props.setProperty("RequestReplyTimeout", "10");
            return 10;
        }
    }

    public String getRequestReplyTimeoutStr() {
        return this.m_props.getProperty("RequestReplyTimeout");
    }

    public void setRequestReplyTimeout(String t) {
        this.m_props.setProperty("RequestReplyTimeout", t);
    }

    public String getMsgReadDelayStr() {
        return this.m_props.getProperty("MsgReadDelay");
    }

    public void setMsgReadDelay(String del) {
        this.m_props.setProperty("MsgReadDelay", del);
    }

    public String getCSVFileDelimiter() {
        return this.m_props.getProperty("CSVFileDelimiter");
    }

    public int getMaxConsumers() {
        try {
            return Integer.parseInt(this.m_props.getProperty("MaxConsumers"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 1000;
        }
    }

    public int getMaxProducers() {
        try {
            return Integer.parseInt(this.m_props.getProperty("MaxProducers"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 1000;
        }
    }

    public int getMaxTopics() {
        try {
            return Integer.parseInt(this.m_props.getProperty("MaxTopics"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 1000;
        }
    }

    public int getMaxQueues() {
        try {
            return Integer.parseInt(this.m_props.getProperty("MaxQueues"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 1000;
        }
    }

    public int getMaxMonitorEvents() {
        try {
            return Integer.parseInt(this.m_props.getProperty("MaxMonitorEvents"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 1000;
        }
    }

    public int getAppliancePollPeriod() {
        try {
            return Integer.parseInt(this.m_props.getProperty("AppliancePollPeriod"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 60;
        }
    }

    public int getApplianceSshTimeout() {
        try {
            return Integer.parseInt(this.m_props.getProperty("ApplianceSshTimeout"));
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return 5;
        }
    }

    public String getServerInfoColPositions() {
        return this.m_props.getProperty("ServerInfoColPositions");
    }

    public boolean isJMS2() {
        return this.m_isJMS2;
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void isDirty(boolean d) {
        this.m_isDirty = d;
    }

    public boolean isStandbyOpsAllowed(GemsConnectionNode cn) {
        if (!this.getAllowStandbyOperations() && cn.isStandbyMode()) {
            JOptionPane.showMessageDialog(this.m_frame, "Admin operations on standby servers are disabled (see gems.props)", "Error", 1);
            return false;
        }
        return true;
    }

    public String getTitlePrefix() {
        if (!this.getShowPathInTitleBar()) {
            return "";
        }
        TreePath selPath = this.m_tree.getSelectionPath();
        Object[] op = null;
        int showroot = 0;
        if (!this.getShowRootInTitleBar()) {
            showroot = 1;
        }
        if (selPath != null) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if (!n.isRoot()) {
                while (n.getLevel() > 0) {
                    if (n instanceof GemsConnectionNode) {
                        op = n.getUserObjectPath();
                        String s = "";
                        for (int i = showroot; i < op.length; ++i) {
                            s = s + op[i].toString();
                            if (i >= op.length - 1) continue;
                            s = s + ".";
                        }
                        if (s.length() > 0) {
                            s = s + ": ";
                        }
                        return s;
                    }
                    n = (DefaultMutableTreeNode)n.getParent();
                }
            }
            if (op == null) {
                op = selPath.getPath();
            }
            String s = "";
            for (int i = showroot; i < op.length; ++i) {
                s = s + ((DefaultMutableTreeNode)op[i]).getUserObject().toString();
                if (i >= op.length - 1) continue;
                s = s + ".";
            }
            if (s.length() > 0) {
                s = s + ": ";
            }
            return s;
        }
        return ((DefaultMutableTreeNode)this.m_treeModel.getRoot()).getUserObject().toString() + ": ";
    }

    public GemsServerMonitorTableModel getServerMonitorTableModel() {
        return this.m_servMonitorPanel.getModel();
    }

    public void treeRepaint() {
        this.m_tree.repaint();
    }

    public void scheduleRepaint() {
        if (this.m_timer != null) {
            this.m_timer.restart();
        }
    }

    public static void debug(String s) {
        if (m_gems.getDebug()) {
            System.err.println("Debug: " + s);
        }
    }

    public GemsDetailsPanel getDetailsPanel() {
        return this.m_detailsPanel;
    }

    public void clearCurrentEventsDisplay() {
        GemsConnectionNode cn = this.getConnectionNode();
        if (cn != null) {
            cn.clearEventMessages();
            this.scheduleRepaint();
        }
    }

    class ConnectThread
    extends Thread {
        long m_delay;
        boolean first = true;

        ConnectThread(long delay) {
            this.m_delay = delay * 1000L;
        }

        @Override
        public void run() {
            while (this.m_delay > 0L) {
                try {
                    if (!this.first) {
                        ConnectThread.sleep(this.m_delay);
                        Gems.this.m_connectStart = System.currentTimeMillis();
                    } else {
                        this.first = false;
                    }
                    DefaultMutableTreeNode node = Gems.this.getSelectedNode();
                    node = (DefaultMutableTreeNode)Gems.this.m_treeModel.getRoot();
                    if (Gems.this.m_servMonitorPanel.getModel().findServers(node, true, false, Gems.this.m_showEvents)) {
                        Gems.this.m_tree.repaint();
                        if (Gems.this.m_timer == null) continue;
                        Gems.this.m_timer.restart();
                        continue;
                    }
                    if (Gems.this.m_timer == null) continue;
                    Gems.this.m_timer.restart();
                }
                catch (Exception ie) {
                    System.err.println("Exception: " + ie.getMessage());
                }
            }
        }
    }

    class RefreshTimerAction
    implements ActionListener {
        long timecheck;

        RefreshTimerAction() {
            this.timecheck = Gems.this.m_displayRefresh * 750;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gems.this.m_timer != null && Gems.this.m_connectStart > 0L && System.currentTimeMillis() - Gems.this.m_connectStart < this.timecheck) {
                Gems.this.m_timer.stop();
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            if (!Gems.this.m_autoRefresh.getState()) {
                return;
            }
            String data = null;
            int row = 0;
            if (Gems.this.m_detailsPanel.isShowing()) {
                row = Gems.this.m_detailsPanel.getModel().getSelectedRow();
                data = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            }
            Gems.getGems().treeSelectionChange(node, true);
            if (Gems.this.m_detailsPanel.isShowing() && data != null) {
                Gems.this.m_detailsPanel.getModel().maintainSelection(row, data);
            }
        }
    }

    class RefreshThread
    extends Thread {
        long m_delay;

        RefreshThread(long delay) {
            this.m_delay = delay * 1000L;
        }

        @Override
        public void run() {
            while (this.m_delay > 0L) {
                try {
                    RefreshThread.sleep(this.m_delay);
                    Gems.getGems().treeSelectionChange(Gems.this.getSelectedNode(), true);
                }
                catch (Exception ie) {
                    System.err.println("Exception: " + ie.getMessage());
                }
            }
        }
    }

    class OptionsDialog
    implements ActionListener {
        OptionsDialog() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel messagePanel = new JPanel(new SpringLayout());
            messagePanel.add(new JLabel("Only show Queues with name pattern:"));
            JTextField qp = new JTextField(25);
            qp.setText(Gems.this.getQueueNamePattern());
            messagePanel.add(qp);
            messagePanel.add(new JLabel("Only show Topics with name pattern:"));
            JTextField tp = new JTextField(25);
            tp.setText(Gems.this.getTopicNamePattern());
            messagePanel.add(tp);
            messagePanel.add(new JLabel("Target Type:"));
            JComboBox<String> tt = new JComboBox<String>();
            tt.addItem("Queue");
            tt.addItem("Topic");
            messagePanel.add(tt);
            messagePanel.add(new JLabel("Selector:"));
            JTextField sf = new JTextField(25);
            messagePanel.add(sf);
            GemsUtilities.makeCompactGrid(messagePanel, 4, 2, 5, 5, 5, 5);
            int result = JOptionPane.showConfirmDialog(Gems.this.m_frame, messagePanel, "Edit Options", 2);
            if (result == 0) {
                Gems.this.m_props.setProperty("QueueNamePattern", qp.getText());
                Gems.this.m_props.setProperty("TopicNamePattern", tp.getText());
                Gems.this.m_treeModel.reloadTree();
            }
        }
    }

    class HistoricalChartAction
    implements ActionListener {
        HistoricalChartAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("CSV file", "csv");
            JFileChooser chooser = new JFileChooser(new File("."));
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
            chooser.setDialogTitle("Load Historical Chart From Server Info CSV Log File");
            int returnVal = chooser.showOpenDialog(Gems.this.m_frame);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                try {
                    GemsChartFrame gemsChartFrame = new GemsChartFrame("Historical Chart for " + f.getName(), null, null, null, f);
                }
                catch (Throwable ex) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, "<html>Failed to load chart " + ex.toString() + "<p>Please download JFreeChart libs jcommon-1.0.23.jar and jfreechart-1.0.19.jar from <p><a href=\"http://www.jfree.org/jfreechart\">http://www.jfree.org/jfreechart</a>", "Error", 0);
                }
            }
        }
    }

    class TodaysChartAction
    implements ActionListener {
        TodaysChartAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionPicker p = new GemsConnectionPicker((Frame)Gems.this.m_frame, Gems.this.getConnectionNode(), "Chart");
            GemsConnectionNode cn = p.getConnection();
            if (cn != null) {
                if (cn.m_logFile != null) {
                    try {
                        GemsChartFrame gemsChartFrame = new GemsChartFrame("Today's Chart for " + cn.getName(), null, null, null, cn.m_logFile);
                    }
                    catch (Throwable ex) {
                        JOptionPane.showMessageDialog(Gems.this.m_frame, "<html>Failed to load chart " + ex.toString() + "<p>Please download JFreeChart libs jcommon-1.0.23.jar and jfreechart-1.0.19.jar from <p><a href=\"http://www.jfree.org/jfreechart\">http://www.jfree.org/jfreechart</a>", "Error", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, "No chart data available, enable Server Info logging in the connection panel", "Error", 1);
                }
            }
        }
    }

    class ChartAction
    implements ActionListener {
        ChartAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionPicker p = new GemsConnectionPicker((Frame)Gems.this.m_frame, Gems.this.getConnectionNode(), "Chart");
            GemsConnectionNode cn = p.getConnection();
            if (cn != null) {
                Gems.this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
                cn.startCharting();
                Gems.this.m_frame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    class EditMonitorEventsAction
    implements ActionListener {
        EditMonitorEventsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsEventMonitorDialog d = new GemsEventMonitorDialog((Frame)Gems.this.m_frame, Gems.this.getConnectionNode());
            Gems.this.isDirty(true);
        }
    }

    class SetLimitsAction
    implements ActionListener {
        String m_type;

        public SetLimitsAction(String type) {
            this.m_type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsLimitsDialog d = new GemsLimitsDialog((Frame)Gems.this.m_frame, this.m_type, Gems.this.getConnectionNode());
            Gems.this.isDirty(true);
        }
    }

    class BrowseDurableAction
    implements ActionListener {
        BrowseDurableAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("durable")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String durname = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            if (node == null || durname == null || !nodename.equals("Durables")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Durable to browse!", "Browse Durable", 1);
                return;
            }
            String clientid = Gems.this.m_detailsPanel.getModel().getSelectedCol(6);
            String topic = Gems.this.m_detailsPanel.getModel().getSelectedCol(2);
            String selector = Gems.this.m_detailsPanel.getModel().getSelectedCol(9);
            Boolean nolocal = new Boolean(Gems.this.m_detailsPanel.getModel().getSelectedCol(10));
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsDurableBrowser(cn, durname, clientid, topic, selector, nolocal);
            }
        }
    }

    class StopServiceMonitoringAction
    implements ActionListener {
        StopServiceMonitoringAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                if (cn.m_services == null) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, "There are no services configured for " + cn.getName(), "Disable Service Monitoring", 1);
                    return;
                }
                if (cn.m_services.m_running) {
                    int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Disable service monitoring for " + cn.getName() + "?", "Disable Service Monitoring", 0);
                    if (opt == 0) {
                        cn.m_services.userStop();
                    }
                } else {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, "Service monitoring is currently disabled for " + cn.getName(), "Disable Service Monitoring", 1);
                }
            }
        }
    }

    class DestroyFactoryAction
    implements ActionListener {
        DestroyFactoryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String facname = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            if (node == null || facname == null || !nodename.equals("Factories")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Factory to destroy!", "Destroy Factory", 1);
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Destroy Connection Factory: " + facname, "Destroy Factory", 0);
            if (opt == 0) {
                try {
                    if (cn != null && cn.m_adminConn != null) {
                        cn.m_adminConn.destroyConnectionFactory(facname);
                    }
                    Gems.this.scheduleRepaint();
                }
                catch (TibjmsAdminException ex) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, ex.getMessage(), "Error", 1);
                    return;
                }
            }
        }
    }

    class UpdateFactoryAction
    implements ActionListener {
        UpdateFactoryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String facname = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            if (node == null || facname == null || !nodename.equals("Factories")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Factory to update!", "Update Factory", 1);
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            if (cn != null && cn.m_adminConn != null) {
                ConnectionFactoryInfo[] cfs;
                int ci = 0;
                try {
                    cfs = cn.m_adminConn.getConnectionFactories();
                    for (ci = 0; ci < cfs.length && !facname.equals(cfs[ci].getJNDINames()[0]); ++ci) {
                    }
                    if (ci >= cfs.length) {
                        JOptionPane.showMessageDialog(Gems.this.m_frame, "Could not find factory: " + facname, "Error", 1);
                        return;
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, ex.getMessage(), "Error", 1);
                    return;
                }
                String com = "<html>Jndi Name is mandatory, other fields can be left blank for defaults.<br>Set Destination Type to 1 for Queue, 2 for Topic, or leave blank for generic. <br>For load balancing, set Metric to 1 for connections, 2 for byte rate, or leave blank for none.</html>";
                GemsDummyConnectionFactoryInfo cfi = new GemsDummyConnectionFactoryInfo(cfs[ci]);
                GemsDynamicPropertyDialog d = new GemsDynamicPropertyDialog(Gems.this.m_frame, "Update Connection Factory", "com.tibco.gems.GemsDummyConnectionFactoryInfo", com, (Object)cfi);
                try {
                    cfi = (GemsDummyConnectionFactoryInfo)((Object)d.getObject());
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, e1.getMessage(), "Error", 1);
                    return;
                }
                if (cfi == null) {
                    return;
                }
                if (!facname.equals(cfi.getJndiName())) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, "JNDI name cannot be changed", "Error", 1);
                    return;
                }
                try {
                    cn.m_adminConn.updateConnectionFactory(facname, (ConnectionFactoryInfo)cfi);
                    Gems.this.scheduleRepaint();
                }
                catch (TibjmsAdminException ex) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, ex.getMessage(), "Error", 1);
                    return;
                }
            }
        }
    }

    class CreateFactoryAction
    implements ActionListener {
        CreateFactoryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            if (cn != null && cn.m_adminConn != null) {
                String com = "<html>&nbsp;Jndi Name is mandatory, other fields can be left blank for defaults.<br>&nbsp;Set Destination Type to 1 for Queue, 2 for Topic, or leave blank for generic. <br>&nbsp;For load balancing, set Metric to 1 for connections, 2 for byte rate, or leave blank for none.</html>";
                GemsDynamicPropertyDialog d = new GemsDynamicPropertyDialog(Gems.this.m_frame, "Create Connection Factory", "com.tibco.gems.GemsDummyConnectionFactoryInfo", com, null);
                GemsDummyConnectionFactoryInfo cfi = null;
                try {
                    cfi = (GemsDummyConnectionFactoryInfo)((Object)d.getObject());
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, e1.getMessage(), "Error", 1);
                    return;
                }
                if (cfi == null) {
                    return;
                }
                try {
                    cn.m_adminConn.createConnectionFactory(cfi.getJndiName(), (ConnectionFactoryInfo)cfi);
                    Gems.this.scheduleRepaint();
                }
                catch (TibjmsAdminException ex) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, ex.getMessage(), "Error", 1);
                    return;
                }
            }
        }
    }

    class StartServiceMonitoringAction
    implements ActionListener {
        StartServiceMonitoringAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                if (cn.m_services == null) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, "There are no services configured for " + cn.getName(), "Enable Service Monitoring", 1);
                    return;
                }
                if (cn.m_services.m_running) {
                    int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Service monitoring for " + cn.getName() + " is already enabled, do you want to reset stats?", "Enable Service Monitoring", 0);
                    if (opt == 0) {
                        cn.m_services.reset();
                    }
                } else {
                    int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Enable service monitoring for " + cn.getName() + "?", "Enable Service Monitoring", 0);
                    if (opt == 0) {
                        cn.m_services.userStart();
                    }
                }
            }
        }
    }

    class PurgeDurableAction
    implements ActionListener {
        PurgeDurableAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("durable")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String durname = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            if (node == null || durname == null || !nodename.equals("Durables")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Durable to purge!", "Purge Durable", 1);
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            String clientid = Gems.this.m_detailsPanel.getModel().getSelectedCol(6);
            int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Purge Durable: " + durname + " clientID " + (clientid == null ? "" : clientid), "Purge Durable", 0);
            if (opt == 0) {
                if (cn != null) {
                    cn.purgeDurable(durname, clientid);
                }
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class DestroyDurableAction
    implements ActionListener {
        DestroyDurableAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("durable")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String durname = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            if (node == null || durname == null || !nodename.equals("Durables")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Durable to destroy!", "Destroy Durable", 1);
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            String clientid = Gems.this.m_detailsPanel.getModel().getSelectedCol(6);
            int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Destroy Durable: " + durname + " clientID " + (clientid == null ? "" : clientid), "Destroy Durable", 0);
            if (opt == 0) {
                if (cn != null) {
                    cn.destroyDurable(durname, clientid);
                }
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class DisconnectClientAction
    implements ActionListener {
        DisconnectClientAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("client connection")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String id = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            if (node == null || id == null || !nodename.startsWith("Connections(Client)") && !nodename.equals("Clients")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a client connection on the Connection Info display to destroy", "Destroy Connection", 1);
                return;
            }
            int opt = 1;
            if (nodename.equals("Clients")) {
                id = Gems.this.m_detailsPanel.getModel().getSelectedCol(2);
                String clientid = Gems.this.m_detailsPanel.getModel().getSelectedCol(1);
                opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Destroy Connection: ID " + id + " for " + clientid, "Destroy Client Connection", 0);
            } else {
                String hostname = Gems.this.m_detailsPanel.getModel().getSelectedCol(3);
                opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Destroy Connection: ID " + id + " on " + hostname, "Destroy Connection", 0);
            }
            if (opt == 0) {
                GemsConnectionNode cn = Gems.this.getConnectionNode();
                if (cn != null) {
                    cn.destroyConnection(id);
                }
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class DisableClientTraceAction
    implements ActionListener {
        DisableClientTraceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                cn.disableClientTrace();
            }
        }
    }

    class EnableClientTraceAction
    implements ActionListener {
        boolean isStdout = true;

        public EnableClientTraceAction(boolean isOut) {
            this.isStdout = isOut;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("client connection")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String id = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            if (node == null || id == null || !nodename.startsWith("Connections(Client)")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a client connection on the Connection Info display to enable client tracing", "Enable Client Trace", 1);
                return;
            }
            Long idl = new Long(0L);
            try {
                idl = Long.parseLong(id);
            }
            catch (Exception ie) {
                System.err.println(ie.getMessage());
            }
            String host = Gems.this.m_detailsPanel.getModel().getSelectedCol(3);
            String user = Gems.this.m_detailsPanel.getModel().getSelectedCol(12);
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                cn.enableClientTrace(idl, user, host, this.isStdout);
            }
        }
    }

    class CreateDurableAction
    implements ActionListener {
        CreateDurableAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            JTextField jpf = new JTextField(20);
            JPanel messagePanel = new JPanel();
            messagePanel.setLayout(new BoxLayout(messagePanel, 1));
            messagePanel.add(new JLabel("Durable Name:"));
            JTextField juf = new JTextField(20);
            messagePanel.add(juf);
            messagePanel.add(new JLabel("Topic Name:"));
            messagePanel.add(jpf);
            messagePanel.add(new JLabel("Client Id:"));
            JTextField jdf = new JTextField(25);
            messagePanel.add(jdf);
            messagePanel.add(new JLabel("Selector:"));
            JTextField sel = new JTextField(25);
            messagePanel.add(sel);
            int result = JOptionPane.showConfirmDialog(null, messagePanel, "Create Durable", 2);
            if (result == 0) {
                cn.createDurable(juf.getText(), jpf.getText(), jdf.getText(), sel.getText());
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class RemoveUserFromGroupAction
    implements ActionListener {
        RemoveUserFromGroupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("user")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String name = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            if (node == null || name == null || !nodename.equals("Users") && !nodename.equals("Groups")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a User to remove or a Group to remove from!", "Remove User From Group", 1);
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            if (nodename.equals("Users")) {
                String g = JOptionPane.showInputDialog(Gems.this.m_frame, (Object)("Remove User  " + name + "  From Group:"));
                if (g != null) {
                    cn.removeUserFromGroup(name, g);
                }
            } else {
                String u = JOptionPane.showInputDialog(Gems.this.m_frame, (Object)("Remove From Group  " + name + "  User:"));
                if (u != null) {
                    cn.removeUserFromGroup(u, name);
                }
            }
            Gems.this.scheduleRepaint();
        }
    }

    class AddUserToGroupAction
    implements ActionListener {
        AddUserToGroupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("user")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String name = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            if (node == null || name == null || !nodename.equals("Users") && !nodename.equals("Groups")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a User to add or a Group to add to!", "Add User To Group", 1);
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            if (nodename.equals("Users")) {
                String g = JOptionPane.showInputDialog(Gems.this.m_frame, (Object)("Add User  " + name + "  To Group:"));
                if (g != null) {
                    cn.addUserToGroup(name, g);
                }
            } else {
                String u = JOptionPane.showInputDialog(Gems.this.m_frame, (Object)("Add To Group  " + name + "  User:"));
                if (u != null) {
                    cn.addUserToGroup(u, name);
                }
            }
            Gems.this.scheduleRepaint();
        }
    }

    class CreateGroupAction
    implements ActionListener {
        CreateGroupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            JPanel messagePanel = new JPanel();
            messagePanel.setLayout(new BoxLayout(messagePanel, 1));
            messagePanel.add(new JLabel("Groupname:"));
            JTextField juf = new JTextField(20);
            messagePanel.add(juf);
            messagePanel.add(new JLabel("Description:"));
            JTextField jdf = new JTextField(25);
            messagePanel.add(jdf);
            int result = JOptionPane.showConfirmDialog(null, messagePanel, "Create Group", 2);
            if (result == 0) {
                cn.createGroup(juf.getText(), jdf.getText());
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class DestroyGroupAction
    implements ActionListener {
        DestroyGroupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("group")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String name = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            if (node == null || name == null || !nodename.equals("Groups")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Group to destroy!", "Destroy Group", 1);
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Destroy Group: " + name, "Destroy Group", 0);
            if (opt == 0) {
                if (cn != null && cn.m_adminConn != null) {
                    try {
                        cn.m_adminConn.destroyGroup(name);
                    }
                    catch (TibjmsAdminException ex) {
                        System.err.println("JMSException: " + ex.getMessage());
                        return;
                    }
                }
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class DestroyUserAction
    implements ActionListener {
        DestroyUserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("user")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String username = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            if (node == null || username == null || !nodename.equals("Users")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a User to destroy!", "Destroy User", 1);
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Destroy User: " + username, "Destroy User", 0);
            if (opt == 0) {
                if (cn != null) {
                    cn.destroyUser(username);
                }
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class UpdateUserAction
    implements ActionListener {
        UpdateUserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn;
            if (!Gems.this.checkConnected("user")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String username = new String();
            if (node != null && username != null && nodename.equals("Users")) {
                username = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            }
            if ((cn = Gems.this.getConnectionNode()) == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            JPasswordField jpf = new JPasswordField(20);
            JPanel messagePanel = new JPanel();
            messagePanel.setLayout(new BoxLayout(messagePanel, 1));
            messagePanel.add(new JLabel("Username:"));
            JTextField juf = new JTextField(20);
            juf.setText(username);
            messagePanel.add(juf);
            messagePanel.add(new JLabel("Password:"));
            messagePanel.add(jpf);
            messagePanel.add(new JLabel("Description:"));
            JTextField jdf = new JTextField(25);
            messagePanel.add(jdf);
            int result = JOptionPane.showConfirmDialog(null, messagePanel, "Update User", 2);
            if (result == 0) {
                cn.updateUser(juf.getText(), new String(jpf.getPassword()), jdf.getText());
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class CreateUserAction
    implements ActionListener {
        CreateUserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("user")) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            JPasswordField jpf = new JPasswordField(20);
            JPanel messagePanel = new JPanel();
            messagePanel.setLayout(new BoxLayout(messagePanel, 1));
            messagePanel.add(new JLabel("Username:"));
            JTextField juf = new JTextField(20);
            messagePanel.add(juf);
            messagePanel.add(new JLabel("Password:"));
            messagePanel.add(jpf);
            messagePanel.add(new JLabel("Description:"));
            JTextField jdf = new JTextField(25);
            messagePanel.add(jdf);
            int result = JOptionPane.showConfirmDialog(null, messagePanel, "Create User", 2);
            if (result == 0) {
                cn.createUser(juf.getText(), new String(jpf.getPassword()), jdf.getText());
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class DestroyRouteAction
    implements ActionListener {
        DestroyRouteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("route")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String serv = Gems.this.m_detailsPanel.getModel().getSelectedCol(1);
            String url = Gems.this.m_detailsPanel.getModel().getSelectedCol(2);
            if (node == null || serv == null || !nodename.equals("Routes")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Route to destroy!", "Destroy Route", 1);
                return;
            }
            int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Destroy Route to Server: " + serv + " at " + url, "Destroy Route", 0);
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            if (opt == 0 && cn != null && cn.m_adminConn != null) {
                try {
                    cn.m_adminConn.destroyRoute(serv);
                }
                catch (TibjmsAdminException ex) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, ex.getMessage(), "Error", 1);
                    return;
                }
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class CreateRouteAction
    implements ActionListener {
        CreateRouteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            Object parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            JPanel messagePanel = new JPanel(new SpringLayout());
            messagePanel.add(new JLabel("Server Name"));
            JTextField sn = new JTextField(25);
            messagePanel.add(sn);
            messagePanel.add(new JLabel("Server URL:"));
            JTextField url = new JTextField(25);
            messagePanel.add(url);
            url.setText("tcp://localhost:7222");
            messagePanel.add(new JLabel("Zone Name:"));
            JTextField zn = new JTextField(25);
            zn.setText("default_mhop_zone");
            messagePanel.add(zn);
            messagePanel.add(new JLabel("Zone Type:"));
            JComboBox<String> zt = new JComboBox<String>();
            zt.addItem("MultiHop");
            zt.addItem("OneHop");
            messagePanel.add(zt);
            GemsUtilities.makeCompactGrid(messagePanel, 4, 2, 5, 5, 5, 5);
            int result = JOptionPane.showConfirmDialog(Gems.this.m_frame, messagePanel, "Create Route to Server", 2);
            if (result == 0 && cn != null && cn.m_adminConn != null) {
                try {
                    RouteInfo ri = new RouteInfo(sn.getText(), url.getText(), null, zn.getText(), zt.getSelectedItem().equals("MultiHop") ? (short)0 : 1);
                    cn.m_adminConn.createRoute(ri);
                }
                catch (TibjmsAdminException ex) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, ex.getMessage(), "Error", 1);
                    return;
                }
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class FindBridgeTargetsAction
    implements ActionListener {
        FindBridgeTargetsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            DefaultMutableTreeNode parent = null;
            parent = (DefaultMutableTreeNode)node.getParent();
            String dest = new String();
            String type = "Topic";
            if (((String)node.getUserObject()).startsWith("Topics")) {
                dest = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                type = "Topic";
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                dest = (String)node.getUserObject();
                type = "Topic";
            } else if (((String)node.getUserObject()).startsWith("Queues")) {
                dest = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                type = "Queue";
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                dest = (String)node.getUserObject();
                type = "Queue";
            }
            if (dest == null || dest.length() == 0) {
                dest = "";
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            GemsManageBridgesDialog d = new GemsManageBridgesDialog(Gems.this.m_frame, cn, type, dest, "Target");
            Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
        }
    }

    class DestroyBridgeAction
    implements ActionListener {
        DestroyBridgeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("bridge")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            String nodename = (String)node.getUserObject();
            String dest = Gems.this.m_detailsPanel.getModel().getSelectedCol(1);
            if (node == null || dest == null || !nodename.equals("Bridges")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Bridge to destroy!", "Destroy Bridge", 1);
                return;
            }
            String dtyp = Gems.this.m_detailsPanel.getModel().getSelectedCol(2);
            String targ = Gems.this.m_detailsPanel.getModel().getSelectedCol(3);
            String ttyp = Gems.this.m_detailsPanel.getModel().getSelectedCol(4);
            int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "<html>Destroy Bridge:<p>Source " + dtyp + ":" + dest + "<p>Target " + ttyp + ": " + targ + "</html>", "Destroy Bridge", 0);
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            if (opt == 0 && cn != null && cn.m_adminConn != null) {
                try {
                    cn.m_adminConn.destroyDestinationBridge(dtyp.equals("Queue") ? 1 : 2, dest, ttyp.equals("Queue") ? 1 : 2, targ);
                }
                catch (TibjmsAdminException ex) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, ex.getMessage(), "Error", 1);
                    return;
                }
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class CreateBridgeAction
    implements ActionListener {
        CreateBridgeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("destination")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (node == null || cn == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a source destination queue or topic to create a bridge from!", "Create Bridge", 1);
                return;
            }
            parent = (DefaultMutableTreeNode)node.getParent();
            String dest = new String();
            boolean isQueue = true;
            if (((String)node.getUserObject()).startsWith("Topics")) {
                dest = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                isQueue = false;
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                dest = (String)node.getUserObject();
                isQueue = false;
            } else if (((String)node.getUserObject()).startsWith("Queues")) {
                dest = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                dest = (String)node.getUserObject();
            }
            if (dest == null || dest.length() == 0) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a destination queue or topic to create a bridge from!", "Create Bridge", 1);
                return;
            }
            if (!Gems.getGems().isStandbyOpsAllowed(cn)) {
                return;
            }
            GemsCreateBridgeDialog d = new GemsCreateBridgeDialog(Gems.this.m_frame, cn, isQueue, dest);
            if (d.createBridge()) {
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class DestroyMessageAction
    implements ActionListener {
        DestroyMessageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("xxx")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            Message m = Gems.this.m_messagePanel.getModel().getSelectedMessage();
            if (node == null || parent == null || !((String)parent.getUserObject()).startsWith("Queues") || Gems.this.m_tabPane.getSelectedIndex() != 3 || m == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Message to destroy!", "Destroy Message", 1);
                return;
            }
            try {
                String nodename = (String)node.getUserObject();
                int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Destroy Message: " + m.getJMSMessageID(), "Destroy Message", 0);
                if (opt == 0) {
                    Gems.this.getConnectionNode().removeMessage(m);
                }
            }
            catch (Exception ex) {
                System.err.println("JMSException: " + ex.getMessage());
                return;
            }
        }
    }

    class MonitorXATransactionsAction
    implements ActionListener {
        MonitorXATransactionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsTopicSubscriber(cn, "$sys.monitor.xa.*", "XA Transaction Monitor");
            }
        }
    }

    class MonitorLocalTransactionsAction
    implements ActionListener {
        MonitorLocalTransactionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsTopicSubscriber(cn, "$sys.monitor.tx.*", "Local Transaction Monitor");
            }
        }
    }

    class MonitorConnectionAction
    implements ActionListener {
        MonitorConnectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsTopicSubscriber(cn, "$sys.monitor.connection.*", "Connection Monitor");
            }
        }
    }

    class MonitorRouteAction
    implements ActionListener {
        MonitorRouteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsTopicSubscriber(cn, "$sys.monitor.route.*", "Route Monitor");
            }
        }
    }

    class ShowTopicSubscriptionsAction
    implements ActionListener {
        ShowTopicSubscriptionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || parent == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Topic to show subscriptions!", "Show Topic Subscriptions", 1);
                return;
            }
            String topic = null;
            if (((String)node.getUserObject()).startsWith("Topics")) {
                topic = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                topic = (String)node.getUserObject();
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsSubscriptionDisplay(cn, topic);
            }
        }
    }

    class ShowTopicConsumersAction
    implements ActionListener {
        ShowTopicConsumersAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || parent == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Topic to show consumers!", "Show Topic Consumers", 1);
                return;
            }
            String topic = null;
            if (((String)node.getUserObject()).startsWith("Topics")) {
                topic = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                topic = (String)node.getUserObject();
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsConsumerDisplay(cn, "Topic", topic);
            }
        }
    }

    class ShowQueueConsumersAction
    implements ActionListener {
        ShowQueueConsumersAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || parent == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Queue to show consumers!", "Show Queue Consumers", 1);
                return;
            }
            String queue = null;
            if (((String)node.getUserObject()).startsWith("Queues")) {
                queue = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                queue = (String)node.getUserObject();
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsConsumerDisplay(cn, "Queue", queue);
            }
        }
    }

    class ShowTopicsAction
    implements ActionListener {
        ShowTopicsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                GemsConnectionPicker p = new GemsConnectionPicker((Frame)Gems.this.m_frame, null, "Show Topics");
                cn = p.getConnection();
            }
            if (cn != null) {
                new GemsDestDisplay(cn, "Topic", cn.getTopicNamePattern(), true);
            }
        }
    }

    class ShowQueuesAction
    implements ActionListener {
        ShowQueuesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                GemsConnectionPicker p = new GemsConnectionPicker((Frame)Gems.this.m_frame, null, "Show Queues");
                cn = p.getConnection();
            }
            if (cn != null) {
                new GemsDestDisplay(cn, "Queue", cn.getQueueNamePattern(), true);
            }
        }
    }

    class CopyQueueMessagesAction
    implements ActionListener {
        CopyQueueMessagesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            String queue = null;
            if (cn != null) {
                DefaultMutableTreeNode node = Gems.this.getSelectedNode();
                DefaultMutableTreeNode parent = null;
                if (node != null) {
                    if (((String)node.getUserObject()).startsWith("Queues")) {
                        queue = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                    } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                        queue = (String)node.getUserObject();
                    }
                }
            }
            new GemsMessageCopier(Gems.this.m_frame, cn, queue, "Queue", null);
        }
    }

    class ShowSystemTopicsAction
    implements ActionListener {
        ShowSystemTopicsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                GemsConnectionPicker p = new GemsConnectionPicker((Frame)Gems.this.m_frame, null, "Show System Topics");
                cn = p.getConnection();
            }
            if (cn != null) {
                new GemsDestDisplay(cn, "Topic", "$sys.>", true);
            }
        }
    }

    class ShowSystemQueuesAction
    implements ActionListener {
        ShowSystemQueuesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                GemsConnectionPicker p = new GemsConnectionPicker((Frame)Gems.this.m_frame, null, "Show System Queues");
                cn = p.getConnection();
            }
            if (cn != null) {
                new GemsDestDisplay(cn, "Queue", "$sys.>", true);
            }
        }
    }

    class ShowServerEventsAction
    implements ActionListener {
        ShowServerEventsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (!(cn == null || cn.getEventMonitor() != null && cn.getEventMonitor().m_enabled)) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Server event monitoring is currently disabled.\nTo enable select \"Edit Monitor Events...\" from Edit menu.", "Show Server Events", 1);
            }
            if (cn != null && Gems.this.m_tabPane.getTabCount() < 2) {
                Gems.this.m_tree.setSelectionPath(new TreePath(cn.getPath()));
            }
            if (cn != null && Gems.this.m_tabPane.getTabCount() > 1) {
                Gems.this.m_tabPane.setSelectedIndex(1);
            }
        }
    }

    class ShowServerPropertiesAction
    implements ActionListener {
        ShowServerPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null && Gems.this.m_tabPane.getTabCount() < 2) {
                Gems.this.m_tree.setSelectionPath(new TreePath(cn.getPath()));
            }
            if (cn != null && Gems.this.m_tabPane.getTabCount() > 2) {
                Gems.this.m_tabPane.setSelectedIndex(2);
            }
        }
    }

    class MonitorQueueAction
    implements ActionListener {
        MonitorQueueAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("queue")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || parent == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Queue to monitor!", "Monitor Queue", 1);
                return;
            }
            String queue = new String();
            if (((String)node.getUserObject()).startsWith("Queues")) {
                queue = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                queue = (String)node.getUserObject();
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsDestMonitor(cn, queue, true, "Queue Monitor");
            }
        }
    }

    class QueueMessageSenderAction
    implements ActionListener {
        QueueMessageSenderAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("queue")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || cn == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Queue to send saved messages to!", "Queue Sender", 1);
                return;
            }
            String queue = new String();
            if (((String)node.getUserObject()).startsWith("Queues")) {
                queue = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                queue = (String)node.getUserObject();
            }
            if (cn != null) {
                new GemsMessageSender(cn, queue, true, "Queue Message Sender");
            }
        }
    }

    class MonitorReqReplyQueueAction
    implements ActionListener {
        MonitorReqReplyQueueAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("queue")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || parent == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Request Queue to monitor!", "Monitor Request/Reply Queue", 1);
                return;
            }
            String queue = new String();
            if (((String)node.getUserObject()).startsWith("Queues")) {
                queue = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                queue = (String)node.getUserObject();
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsReqReplyMonitor(cn, queue, true, "Queue Request/Reply Monitor");
            }
        }
    }

    class ResetSSAction
    implements ActionListener {
        ResetSSAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("SubStation")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || parent == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "A SubStation Node or an item below the node must be selected", "Enable New SS Object", 1);
                return;
            }
            GemsSSNode ssn = null;
            String ssResult = "";
            if (parent.getClass().getSimpleName().equals("GemsSSNode")) {
                ssn = (GemsSSNode)parent;
            } else if (node.getClass().getSimpleName().equals("GemsSSNode")) {
                ssn = (GemsSSNode)node;
            } else {
                return;
            }
            String result = "";
            result = ssn.RunCommand("REFRESH,COUNTERS");
            JOptionPane.showMessageDialog(Gems.this.m_frame, result, "Refresh SS Counters", 1);
        }
    }

    class RecoverSSAction
    implements ActionListener {
        RecoverSSAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("SubStation")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent().getParent();
            }
            if (node == null || parent == null || !((String)node.getUserObject()).startsWith("Active R")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Recipe to Recover !", "Recover Undelivered Messages", 1);
                return;
            }
            String ssname = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            GemsSSNode ssn = null;
            String result = "";
            if (!parent.getClass().getSimpleName().equals("GemsSSNode")) {
                return;
            }
            ssn = (GemsSSNode)parent;
            String intf = ((String)((DefaultMutableTreeNode)node.getParent()).getUserObject()).substring(5);
            if (((String)node.getUserObject()).startsWith("Active R")) {
                result = ssn.RunCommand("RECOVER,RID=" + ssname.trim() + ",INTF=" + intf);
            }
            JOptionPane.showMessageDialog(Gems.this.m_frame, result, "Recover Undelivered Messages", 1);
        }
    }

    class UnloadSSAction
    implements ActionListener {
        UnloadSSAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("SubStation")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent().getParent();
            }
            if (node == null || parent == null || !((String)node.getUserObject()).startsWith("Active") && !((String)node.getUserObject()).startsWith("Disabled")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Recipe or Trigger to Unload!", "Unload SS Object", 1);
                return;
            }
            String ssname = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            String sstype = Gems.this.m_detailsPanel.getModel().getSelectedCol(2);
            GemsSSNode ssn = null;
            String result = "";
            if (!parent.getClass().getSimpleName().equals("GemsSSNode")) {
                return;
            }
            ssn = (GemsSSNode)parent;
            String intf = ((String)((DefaultMutableTreeNode)node.getParent()).getUserObject()).substring(5);
            if (((String)node.getUserObject()).startsWith("Active R")) {
                result = ssn.RunCommand("UNLOAD,RID=" + ssname.trim() + ",INTF=" + intf);
            }
            if (((String)node.getUserObject()).startsWith("Active T")) {
                result = ssn.RunCommand("UNLOAD,TID=" + ssname.trim() + ",INTF=" + intf);
            }
            if (((String)node.getUserObject()).startsWith("Disabled")) {
                result = sstype.equals("Recipe") ? ssn.RunCommand("UNLOAD,RID=" + ssname.trim() + ",INTF=" + intf) : ssn.RunCommand("UNLOAD,TID=" + ssname.trim() + ",INTF=" + intf);
            }
            JOptionPane.showMessageDialog(Gems.this.m_frame, result, "Refresh SS Object", 1);
        }
    }

    class NewSSRecipeAction
    implements ActionListener {
        NewSSRecipeAction() {
        }

        private Object makeObj(final String item) {
            return new Object(){

                public String toString() {
                    return item;
                }
            };
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name;
            DefaultMutableTreeNode chn;
            int cc;
            if (!Gems.this.checkConnected("SubStation")) {
                return;
            }
            JPanel messagePanel = new JPanel();
            messagePanel.setLayout(new BoxLayout(messagePanel, 1));
            JLabel l = new JLabel("Name:");
            messagePanel.add(l);
            JTextField juf = new JTextField(10);
            l.setLabelFor(juf);
            messagePanel.add(juf);
            DefaultMutableTreeNode intfnode = Gems.this.getSelectedNode();
            JComboBox<Object> jcmbi = new JComboBox<Object>();
            if (intfnode.getParent().getParent().getClass().getSimpleName().equals("GemsSSNode")) {
                GemsSSNode d = (GemsSSNode)intfnode.getParent().getParent();
                cc = d.getChildCount();
                for (int x = 0; x < cc; ++x) {
                    chn = (DefaultMutableTreeNode)d.getChildAt(x);
                    name = (String)chn.getUserObject();
                    if (!name.startsWith("Int:")) continue;
                    jcmbi.addItem(this.makeObj(name.substring(5)));
                }
            } else if (intfnode.getParent().getClass().getSimpleName().equals("GemsSSNode")) {
                GemsSSNode d = (GemsSSNode)intfnode.getParent();
                cc = d.getChildCount();
                for (int x = 0; x < cc; ++x) {
                    chn = (DefaultMutableTreeNode)d.getChildAt(x);
                    name = (String)chn.getUserObject();
                    if (!name.startsWith("Int:")) continue;
                    jcmbi.addItem(this.makeObj(name.substring(5)));
                }
            } else if (intfnode.getClass().getSimpleName().equals("GemsSSNode")) {
                int cc2 = intfnode.getChildCount();
                for (int x = 0; x < cc2; ++x) {
                    DefaultMutableTreeNode chn2 = (DefaultMutableTreeNode)intfnode.getChildAt(x);
                    String name2 = (String)chn2.getUserObject();
                    if (!name2.startsWith("Int:")) continue;
                    jcmbi.addItem(this.makeObj(name2.substring(5)));
                }
            } else {
                return;
            }
            messagePanel.add(jcmbi);
            JComboBox<String> jcmb = new JComboBox<String>(new String[]{"Recipe", "Trigger"});
            messagePanel.add(jcmb);
            int result = JOptionPane.showConfirmDialog(null, messagePanel, "Enable New SubStation Object", 2);
            if (result == 0) {
                DefaultMutableTreeNode node = Gems.this.getSelectedNode();
                DefaultMutableTreeNode parent = null;
                if (node != null && ((String)(parent = (DefaultMutableTreeNode)node.getParent()).getUserObject()).startsWith("Int")) {
                    parent = (DefaultMutableTreeNode)parent.getParent();
                }
                if (node == null || parent == null) {
                    JOptionPane.showMessageDialog(Gems.this.m_frame, "A SubStation Node or an item below the node must be selected", "Enable New SS Object", 1);
                    return;
                }
                GemsSSNode ssn = null;
                String ssResult = "";
                if (parent.getClass().getSimpleName().equals("GemsSSNode")) {
                    ssn = (GemsSSNode)parent;
                } else if (node.getClass().getSimpleName().equals("GemsSSNode")) {
                    ssn = (GemsSSNode)node;
                } else {
                    return;
                }
                String objName = juf.getText();
                String objType = jcmb.getSelectedItem().toString();
                String objIntf = jcmbi.getSelectedItem().toString();
                ssResult = objType.equals("Recipe") ? ssn.RunCommand("REFRESH,RID=" + objName.trim() + ",INTF=" + objIntf) : ssn.RunCommand("REFRESH,TID=" + objName.trim() + ",INTF=" + objIntf);
                JOptionPane.showMessageDialog(Gems.this.m_frame, ssResult, "Enable New SS Object", 1);
            }
        }
    }

    class SuspendSSAction
    implements ActionListener {
        SuspendSSAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("SubStation")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent().getParent();
            }
            if (node == null || parent == null || !((String)node.getUserObject()).startsWith("Active Recipes")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Recipe to Suspend !", "Suspend SS Recipe", 1);
                return;
            }
            String ssname = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            GemsSSNode ssn = null;
            String result = "";
            if (!parent.getClass().getSimpleName().equals("GemsSSNode")) {
                return;
            }
            ssn = (GemsSSNode)parent;
            String intf = ((String)((DefaultMutableTreeNode)node.getParent()).getUserObject()).substring(5);
            if (((String)node.getUserObject()).startsWith("Active R")) {
                result = ssn.RunCommand("SUSPEND,RID=" + ssname.trim());
            }
            JOptionPane.showMessageDialog(Gems.this.m_frame, result, "Suspend SS Recipe", 1);
        }
    }

    class DisableSSAction
    implements ActionListener {
        DisableSSAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("SubStation")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent().getParent();
            }
            if (node == null || parent == null || !((String)node.getUserObject()).startsWith("Active")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Recipe or Trigger to Disable!", "Enable SS Object", 1);
                return;
            }
            String ssname = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            GemsSSNode ssn = null;
            String result = "";
            if (!parent.getClass().getSimpleName().equals("GemsSSNode")) {
                return;
            }
            ssn = (GemsSSNode)parent;
            String intf = ((String)((DefaultMutableTreeNode)node.getParent()).getUserObject()).substring(5);
            if (((String)node.getUserObject()).startsWith("Active R")) {
                result = ssn.RunCommand("DISABLE,RID=" + ssname.trim() + ",INTF=" + intf);
            }
            if (((String)node.getUserObject()).startsWith("Active T")) {
                result = ssn.RunCommand("DISABLE,TID=" + ssname.trim() + ",INTF=" + intf);
            }
            JOptionPane.showMessageDialog(Gems.this.m_frame, result, "Disable SS Object", 1);
        }
    }

    class EnableSSAction
    implements ActionListener {
        EnableSSAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("SubStation")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent().getParent();
            }
            if (node == null || parent == null || !((String)node.getUserObject()).startsWith("Disabled")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Recipe or Trigger to Enable!", "Enable SS Object", 1);
                return;
            }
            String ssname = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            String sstype = Gems.this.m_detailsPanel.getModel().getSelectedCol(2);
            GemsSSNode ssn = null;
            String result = "";
            if (!parent.getClass().getSimpleName().equals("GemsSSNode")) {
                return;
            }
            ssn = (GemsSSNode)parent;
            String intf = ((String)((DefaultMutableTreeNode)node.getParent()).getUserObject()).substring(5);
            result = sstype.equals("Recipe") ? ssn.RunCommand("ENABLE,RID=" + ssname.trim() + ",INTF=" + intf) : ssn.RunCommand("ENABLE,TID=" + ssname.trim() + ",INTF=" + intf);
            JOptionPane.showMessageDialog(Gems.this.m_frame, result, "Enable SS Object", 1);
        }
    }

    class RefreshSSAction
    implements ActionListener {
        RefreshSSAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("SubStation")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent().getParent();
            }
            if (node == null || parent == null || !((String)node.getUserObject()).startsWith("Active") && !((String)node.getUserObject()).startsWith("Disabled")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Recipe or Trigger to refresh!", "Refresh SS Object", 1);
                return;
            }
            String ssname = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            String sstype = Gems.this.m_detailsPanel.getModel().getSelectedCol(2);
            GemsSSNode ssn = null;
            String result = "";
            if (!parent.getClass().getSimpleName().equals("GemsSSNode")) {
                return;
            }
            ssn = (GemsSSNode)parent;
            String intf = ((String)((DefaultMutableTreeNode)node.getParent()).getUserObject()).substring(5);
            if (((String)node.getUserObject()).startsWith("Active R")) {
                result = ssn.RunCommand("REFRESH,RID=" + ssname.trim() + ",INTF=" + intf);
            }
            if (((String)node.getUserObject()).startsWith("Active T")) {
                result = ssn.RunCommand("REFRESH,TID=" + ssname.trim() + ",INTF=" + intf);
            }
            if (((String)node.getUserObject()).startsWith("Disabled")) {
                result = sstype.equals("Recipe") ? ssn.RunCommand("REFRESH,RID=" + ssname.trim() + ",INTF=" + intf) : ssn.RunCommand("REFRESH,TID=" + ssname.trim() + ",INTF=" + intf);
            }
            JOptionPane.showMessageDialog(Gems.this.m_frame, result, "Refresh SS Object", 1);
        }
    }

    class BrowseQueueAction
    implements ActionListener {
        BrowseQueueAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("queue")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || parent == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Queue to browse!", "Browse Queue", 1);
                return;
            }
            String queue = new String();
            if (((String)node.getUserObject()).startsWith("Queues")) {
                queue = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                queue = (String)node.getUserObject();
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsQueueBrowser(cn, queue);
            }
        }
    }

    class BrowseDelayTopicAction
    implements ActionListener {
        BrowseDelayTopicAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("topic")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || parent == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Topic to browse delayed messsages!", "Browse Delayed Topic Msgs", 1);
                return;
            }
            String queue = new String();
            if (((String)node.getUserObject()).startsWith("Topics")) {
                queue = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                queue = (String)node.getUserObject();
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsQueueBrowser(cn, queue, "$sys.delayed.t.");
            }
        }
    }

    class BrowseDelayQueueAction
    implements ActionListener {
        BrowseDelayQueueAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("queue")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || parent == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Queue to browse delayed messsages!", "Browse Delayed Queue Msgs", 1);
                return;
            }
            String queue = new String();
            if (((String)node.getUserObject()).startsWith("Queues")) {
                queue = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                queue = (String)node.getUserObject();
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                new GemsQueueBrowser(cn, queue, "$sys.delayed.q.");
            }
        }
    }

    class DeleteTopicAction
    implements ActionListener {
        DeleteTopicAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("topic")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            String top = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
                String nodename = (String)node.getUserObject();
                if (nodename.startsWith("Topics")) {
                    top = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                    top = nodename;
                }
            }
            if (top == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Topic to destroy!", "Destroy Topic", 1);
                return;
            }
            int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Destroy Topic: " + top, "Destroy Topic", 0);
            if (opt == 0) {
                Gems.this.m_treeModel.removeTopic(top);
            }
        }
    }

    class CreateTopicAction
    implements ActionListener {
        CreateTopicAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            String qn = JOptionPane.showInputDialog(Gems.this.m_frame, (Object)"Create Topic:");
            if (qn != null) {
                Gems.this.m_treeModel.createTopic(qn, false);
            }
        }
    }

    class PurgeTopicAction
    implements ActionListener {
        PurgeTopicAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("topic")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            String top = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
                String nodename = (String)node.getUserObject();
                if (nodename.startsWith("Topics")) {
                    top = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                    top = nodename;
                }
            }
            if (top == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Topic to purge!", "Purge Topic", 1);
                return;
            }
            int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Purge Topic: " + top, "Purge Topic", 0);
            if (opt == 0) {
                Gems.this.m_treeModel.purgeTopic(top);
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class SetQueuePermissionsAction
    implements ActionListener {
        SetQueuePermissionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("topic")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (node == null || cn == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Queue to set permissions!", "Set Permissions On Queue", 1);
                return;
            }
            parent = (DefaultMutableTreeNode)node.getParent();
            String queue = new String();
            if (((String)node.getUserObject()).startsWith("Queues")) {
                queue = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                queue = (String)node.getUserObject();
            }
            GemsPermissionDialog d = new GemsPermissionDialog(Gems.this.m_frame, "Set Queue Permissions", true, cn, queue);
        }
    }

    class SetTopicPermissionsAction
    implements ActionListener {
        SetTopicPermissionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("topic")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (node == null || cn == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Topic to set permissions!", "Set Permissions On Topic", 1);
                return;
            }
            parent = (DefaultMutableTreeNode)node.getParent();
            String topic = new String();
            if (((String)node.getUserObject()).startsWith("Topics")) {
                topic = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                topic = (String)node.getUserObject();
            }
            GemsPermissionDialog d = new GemsPermissionDialog(Gems.this.m_frame, "Set Topic Permissions", false, cn, topic);
        }
    }

    class SetAdminPermissionsAction
    implements ActionListener {
        SetAdminPermissionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("user or group")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (node == null || cn == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a user or goup to set permissions!", "Set Admin Permissions", 1);
                return;
            }
            parent = (DefaultMutableTreeNode)node.getParent();
            String user = null;
            if (((String)node.getUserObject()).equals("Users")) {
                user = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).equals("Users")) {
                user = (String)node.getUserObject();
            }
            if (user != null) {
                GemsAdminPermissionDialog gemsAdminPermissionDialog = new GemsAdminPermissionDialog(Gems.this.m_frame, cn, user, "User", Gems.this.m_detailsPanel.getModel().getSelectedCol(3));
            } else {
                String group = null;
                if (((String)node.getUserObject()).equals("Groups")) {
                    group = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                } else if (parent != null && ((String)parent.getUserObject()).equals("Groups")) {
                    group = (String)node.getUserObject();
                }
                if (group != null) {
                    GemsAdminPermissionDialog gemsAdminPermissionDialog = new GemsAdminPermissionDialog(Gems.this.m_frame, cn, group, "Group", Gems.this.m_detailsPanel.getModel().getSelectedCol(3));
                } else {
                    GemsAdminPermissionDialog gemsAdminPermissionDialog = new GemsAdminPermissionDialog((Frame)Gems.this.m_frame, cn);
                }
            }
        }
    }

    class MonitorTopicAction
    implements ActionListener {
        MonitorTopicAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("topic")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (node == null || cn == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Topic to monitor!", "Monitor Topic", 1);
                return;
            }
            parent = (DefaultMutableTreeNode)node.getParent();
            String topic = new String();
            if (((String)node.getUserObject()).startsWith("Topics")) {
                topic = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                topic = (String)node.getUserObject();
            }
            new GemsDestMonitor(cn, topic, false, "Topic Monitor");
        }
    }

    class TopicMessageSenderAction
    implements ActionListener {
        TopicMessageSenderAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("topic")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (node == null || cn == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Topic to publish saved messages to!", "Topic Publisher", 1);
                return;
            }
            parent = (DefaultMutableTreeNode)node.getParent();
            String topic = new String();
            if (((String)node.getUserObject()).startsWith("Topics")) {
                topic = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                topic = (String)node.getUserObject();
            }
            new GemsMessageSender(cn, topic, false, "Topic Message Publisher");
        }
    }

    class RequestReplyTesterAction
    implements ActionListener {
        boolean m_isQueue = true;

        public RequestReplyTesterAction(boolean isQueue) {
            this.m_isQueue = isQueue;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select an EMS server in the tree view!", "Request/Reply Tester", 1);
                return;
            }
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (this.m_isQueue) {
                String queue = new String();
                if (node != null) {
                    if (((String)node.getUserObject()).startsWith("Queues")) {
                        queue = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                    } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                        queue = (String)node.getUserObject();
                    }
                }
                new GemsReqReplyTester(cn, queue, true, "Queue Request/Reply Tester");
            } else {
                String topic = new String();
                if (node != null) {
                    if (((String)node.getUserObject()).startsWith("Topics")) {
                        topic = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                    } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                        topic = (String)node.getUserObject();
                    }
                }
                new GemsReqReplyTester(cn, topic, false, "Topic Request/Reply Tester");
            }
        }
    }

    class MonitorReqReplyTopicAction
    implements ActionListener {
        MonitorReqReplyTopicAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("topic")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (node == null || cn == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Request Topic to monitor!", "Monitor Request/Reply Topic", 1);
                return;
            }
            parent = (DefaultMutableTreeNode)node.getParent();
            String topic = new String();
            if (((String)node.getUserObject()).startsWith("Topics")) {
                topic = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                topic = (String)node.getUserObject();
            }
            new GemsReqReplyMonitor(cn, topic, false, "Topic Request/Reply Monitor");
        }
    }

    class SubscribeTopicAction
    implements ActionListener {
        SubscribeTopicAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("topic")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (node == null || cn == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Topic to subscribe to!", "Subscribe To Topic", 1);
                return;
            }
            parent = (DefaultMutableTreeNode)node.getParent();
            String topic = new String();
            if (((String)node.getUserObject()).startsWith("Topics")) {
                topic = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                topic = (String)node.getUserObject();
            }
            new GemsTopicSubscriber(cn, topic, "Topic Subscriber");
        }
    }

    class PurgeTMPTopicsAction
    implements ActionListener {
        PurgeTMPTopicsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            Object parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            GemsPurgeTopics p = new GemsPurgeTopics(Gems.this.m_frame, cn, "$TMP$.>");
        }
    }

    class PurgeTopicsAction
    implements ActionListener {
        PurgeTopicsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            Object parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            GemsPurgeTopics p = new GemsPurgeTopics(Gems.this.m_frame, cn);
        }
    }

    class PurgeTMPQueuesAction
    implements ActionListener {
        PurgeTMPQueuesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            Object parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            GemsPurgeQueues p = new GemsPurgeQueues(Gems.this.m_frame, cn, "$TMP$.>");
        }
    }

    class PurgeQueuesAction
    implements ActionListener {
        PurgeQueuesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            Object parent = null;
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            GemsPurgeQueues p = new GemsPurgeQueues(Gems.this.m_frame, cn);
        }
    }

    class SetServerPropertyAction
    implements ActionListener {
        SetServerPropertyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn != null) {
                if (!Gems.this.isStandbyOpsAllowed(cn)) {
                    return;
                }
                cn.setServerProperty("");
            }
        }
    }

    class PurgeQueueAction
    implements ActionListener {
        PurgeQueueAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("queue")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            String top = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
                String nodename = (String)node.getUserObject();
                if (nodename.startsWith("Queues")) {
                    top = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                    top = nodename;
                }
            }
            if (top == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Queue to purge!", "Purge Queue", 1);
                return;
            }
            int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Purge Queue: " + top, "Purge Queue", 0);
            if (opt == 0) {
                Gems.this.m_treeModel.purgeQueue(top);
                Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            }
        }
    }

    class SetTopicPropertyAction
    implements ActionListener {
        SetTopicPropertyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("topic")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            String top = null;
            GemsTopicNode tn = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
                String nodename = (String)node.getUserObject();
                if (nodename.startsWith("Topics")) {
                    top = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                    if (top != null) {
                        Enumeration<TreeNode> ch = node.children();
                        while (ch.hasMoreElements()) {
                            DefaultMutableTreeNode n = (DefaultMutableTreeNode)ch.nextElement();
                            if (n == null || !top.equals((String)n.getUserObject())) continue;
                            tn = (GemsTopicNode)n;
                            break;
                        }
                    }
                } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                    tn = (GemsTopicNode)node;
                    top = (String)tn.getUserObject();
                }
            }
            GemsDestPropEditor d = new GemsDestPropEditor(Gems.this.m_frame, Gems.this.getConnectionNode(), "Topic", top);
        }
    }

    class SetQueuePropertyAction
    implements ActionListener {
        SetQueuePropertyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("queue")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            String que = null;
            GemsQueueNode qn = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
                String nodename = (String)node.getUserObject();
                if (nodename.startsWith("Queues")) {
                    que = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                    if (que != null) {
                        Enumeration<TreeNode> ch = node.children();
                        while (ch.hasMoreElements()) {
                            DefaultMutableTreeNode n = (DefaultMutableTreeNode)ch.nextElement();
                            if (n == null || !que.equals((String)n.getUserObject())) continue;
                            qn = (GemsQueueNode)n;
                            break;
                        }
                    }
                } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                    qn = (GemsQueueNode)node;
                    que = (String)qn.getUserObject();
                }
            }
            GemsDestPropEditor d = new GemsDestPropEditor(Gems.this.m_frame, Gems.this.getConnectionNode(), "Queue", que);
        }
    }

    class DeleteQueueAction
    implements ActionListener {
        DeleteQueueAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("queue")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            String top = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
                String nodename = (String)node.getUserObject();
                if (nodename.startsWith("Queues")) {
                    top = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
                } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                    top = nodename;
                }
            }
            if (top == null || top.startsWith("$")) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Queue to destroy!", "Destroy Queue", 1);
                return;
            }
            int opt = JOptionPane.showConfirmDialog(Gems.this.m_frame, "Destroy Queue: " + top, "Destroy Queue", 0);
            if (opt == 0) {
                Gems.this.m_treeModel.removeQueue(top);
            }
        }
    }

    class CreateQueueAction
    implements ActionListener {
        CreateQueueAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String qn;
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            JPanel messagePanel = new JPanel();
            messagePanel.setLayout(new BoxLayout(messagePanel, 1));
            messagePanel.add(new JLabel("Queue Name:"));
            JTextField juf = new JTextField(10);
            messagePanel.add(juf);
            messagePanel.add(new JLabel("For routed queue use queueName@serverName"));
            int result = JOptionPane.showConfirmDialog(null, messagePanel, "Create Queue", 2);
            if (result == 0 && (qn = juf.getText()) != null && qn.length() > 0) {
                Gems.this.m_treeModel.createQueue(qn, false);
            }
        }
    }

    class LookupJNDIAction
    implements ActionListener {
        LookupJNDIAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            GemsJNDILookup l = new GemsJNDILookup(Gems.this.m_frame, cn);
        }
    }

    class SetServerTraceAction
    implements ActionListener {
        SetServerTraceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected(null)) {
                return;
            }
            Gems.this.m_treeModel.setServerTrace();
        }
    }

    class AboutAction
    implements ActionListener {
        AboutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Gems.this.m_frame, "<html><font size=\"5\">Gems v5.2</font><p><font size =\"4\">Graphical Administration Tool for TIBCO&#174 EMS</font><p><p>This software comes with no warranties of any kind. <p>See license.txt for Terms of Use", "About Gems", 1, Gems.this.m_icon);
        }
    }

    class EditJSONConfig
    implements ActionListener {
        EditJSONConfig() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.this.getConnectionNode();
            if (cn == null) {
                GemsConnectionPicker p = new GemsConnectionPicker((Frame)Gems.this.m_frame, null, "Edit");
                cn = p.getConnection();
            }
            GemsJSONConfigEditor d = new GemsJSONConfigEditor((Frame)Gems.this.m_frame, cn);
        }
    }

    class ExitAction
    implements ActionListener {
        ExitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gems.this.doExit();
        }
    }

    class ShowConfig
    implements ActionListener {
        ShowConfig() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConfigDialog d = new GemsConfigDialog(Gems.this.m_frame);
            d.show();
        }
    }

    class ShowHelp
    implements ActionListener {
        ShowHelp() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsBrowser b = new GemsBrowser("file:doc/index.htm");
        }
    }

    class PublishMessageAction
    implements ActionListener {
        boolean m_isMap = false;

        public PublishMessageAction(boolean isMap) {
            this.m_isMap = isMap;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("topic")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || parent == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Topic to publish to!", "Publish Message", 1);
                return;
            }
            String topic = new String();
            if (((String)node.getUserObject()).startsWith("Topics")) {
                topic = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Topics")) {
                topic = (String)node.getUserObject();
            }
            GemsMessageFrame f = new GemsMessageFrame(Gems.this.getConnectionNode(), true, topic, false, Gems.this.m_frame, false, this.m_isMap);
        }
    }

    class SendMessageAction
    implements ActionListener {
        boolean m_isMap = false;

        public SendMessageAction(boolean isMap) {
            this.m_isMap = isMap;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Gems.this.checkConnected("queue")) {
                return;
            }
            DefaultMutableTreeNode node = Gems.this.getSelectedNode();
            DefaultMutableTreeNode parent = null;
            if (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
            }
            if (node == null || parent == null) {
                JOptionPane.showMessageDialog(Gems.this.m_frame, "Select a Queue to send to!", "Send Message", 1);
                return;
            }
            String queue = new String();
            if (((String)node.getUserObject()).startsWith("Queues")) {
                queue = Gems.this.m_detailsPanel.getModel().getSelectedCol1();
            } else if (parent != null && ((String)parent.getUserObject()).startsWith("Queues")) {
                queue = (String)node.getUserObject();
            }
            GemsMessageFrame f = new GemsMessageFrame(Gems.this.getConnectionNode(), true, queue, true, Gems.this.m_frame, false, this.m_isMap);
        }
    }

    class RefreshTreeViewAction
    implements ActionListener {
        RefreshTreeViewAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gems.this.m_treeModel.reloadTree();
        }
    }

    class RefreshAction
    implements ActionListener {
        RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), false, true);
        }
    }

    class RemoveFolderAction
    implements ActionListener {
        RemoveFolderAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gems.this.m_treeModel.removeCurrentFolder();
            Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            Gems.this.isDirty(true);
        }
    }

    class AddFolderAction
    implements ActionListener {
        AddFolderAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode n = Gems.this.getSelectedNode();
            if (n == null) {
                n = (DefaultMutableTreeNode)Gems.this.m_treeModel.getRoot();
            }
            if (n instanceof GemsConnectionNode) {
                n = (DefaultMutableTreeNode)n.getParent();
            } else if (n.getParent() != null && n.getParent() instanceof GemsConnectionNode) {
                n = (DefaultMutableTreeNode)n.getParent().getParent();
            }
            if (n != null && n instanceof GemsIconNode && n.getAllowsChildren()) {
                String fn;
                JPanel messagePanel = new JPanel();
                messagePanel.setLayout(new BoxLayout(messagePanel, 1));
                messagePanel.add(new JLabel("Folder Name:"));
                JTextField juf = new JTextField(10);
                messagePanel.add(juf);
                int result = JOptionPane.showConfirmDialog(null, messagePanel, "Create Folder", 2);
                if (result == 0 && (fn = juf.getText()) != null && fn.length() > 0) {
                    Gems.this.m_treeModel.newFolder(n, GemsUtilities.stripSpaces(fn));
                    Gems.this.isDirty(true);
                }
            }
        }
    }

    class RemoveConnectionAction
    implements ActionListener {
        RemoveConnectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gems.this.m_treeModel.removeCurrentConnnectionNode();
            Gems.this.treeSelectionChange(Gems.this.getSelectedNode(), true);
            Gems.this.isDirty(true);
        }
    }

    class AddConnectionAction
    implements ActionListener {
        AddConnectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode n = Gems.this.getSelectedNode();
            if (n != null && n instanceof GemsIconNode && n.getAllowsChildren() && !n.getUserObject().equals("Topics") && !n.getUserObject().equals("Queues")) {
                if (n instanceof GemsConnectionNode) {
                    n = (DefaultMutableTreeNode)n.getParent();
                }
                Gems.this.m_treeModel.newJMSConnection(n, "EMS Server");
            } else {
                Gems.this.m_treeModel.newJMSConnection("EMS Server");
            }
            Gems.this.isDirty(true);
        }
    }

    class ShowAllServersAction
    implements ActionListener {
        ShowAllServersAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gems.this.m_tree.setSelectionPath(new TreePath(Gems.this.m_treeModel.getRoot()));
        }
    }

    class ShowTotalsAction
    implements ActionListener {
        ShowTotalsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gems.this.m_tree.setSelectionPath(new TreePath(Gems.this.m_treeModel.getRoot()));
            Gems.this.setShowTotals(!Gems.this.getShowTotals());
        }
    }
}

