/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsCheckNode;
import com.tibco.gems.GemsCheckRenderer;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.admin.AdminACLEntry;
import com.tibco.tibjms.admin.AdminPermissions;
import com.tibco.tibjms.admin.GroupInfo;
import com.tibco.tibjms.admin.PrincipalInfo;
import com.tibco.tibjms.admin.TibjmsAdminException;
import com.tibco.tibjms.admin.UserInfo;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class GemsAdminPermissionDialog
extends JDialog {
    protected JTree m_perms;
    protected JCheckBox m_isAdmin;
    protected JComboBox m_principal;
    protected boolean m_cancelled = false;
    protected String m_selected;
    protected GemsCheckNode[] m_px;
    protected GemsConnectionNode m_cn;
    Comparator<PrincipalInfo> principalComparator = new Comparator<PrincipalInfo>(){

        @Override
        public int compare(PrincipalInfo p1, PrincipalInfo p2) {
            return p1.getName().compareTo(p2.getName());
        }
    };

    public GemsAdminPermissionDialog(Frame frame, GemsConnectionNode cn) {
        super(frame, "Set Global Administrator Permissions", true);
        this.m_cn = cn;
        this.buildFrame(frame);
        this.updatePermissions(false);
        this.pack();
        this.setVisible(true);
    }

    public GemsAdminPermissionDialog(Frame frame, GemsConnectionNode cn, String principal, String principalType, String isExternal) {
        super(frame, "Set Global Administrator Permissions", true);
        this.m_cn = cn;
        String n = principal;
        n = principalType.equals("User") ? n + " (user" : n + " (group";
        n = isExternal.equals("true") ? n + ", external)" : n + ")";
        this.buildFrame(frame);
        this.m_principal.setSelectedItem(n);
        this.m_selected = (String)this.m_principal.getSelectedItem();
        this.updatePermissions(true);
        this.pack();
        this.setVisible(true);
    }

    public void buildFrame(Frame frame) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel toppanel = new JPanel(new SpringLayout());
        mainPanel.add(toppanel);
        JLabel l2 = new JLabel("Principal:", 11);
        this.m_principal = new JComboBox();
        this.populatePrincipals();
        this.m_principal.addActionListener(new PrincipalSelected());
        toppanel.add(l2);
        toppanel.add(this.m_principal);
        GemsUtilities.makeCompactGrid(toppanel, 1, 2, 5, 5, 5, 5);
        this.m_px = new GemsCheckNode[]{new GemsCheckNode("Global Permissions:"), new GemsCheckNode("All Admin Permissions:"), new GemsCheckNode("View Permissions:"), new GemsCheckNode("View ACL"), new GemsCheckNode("View Admin ACL"), new GemsCheckNode("View Bridge"), new GemsCheckNode("View Connection"), new GemsCheckNode("View Destination"), new GemsCheckNode("View Durable"), new GemsCheckNode("View Factory"), new GemsCheckNode("View Group"), new GemsCheckNode("View Message"), new GemsCheckNode("View Route"), new GemsCheckNode("View Server"), new GemsCheckNode("View User"), new GemsCheckNode("Modify Permissions:"), new GemsCheckNode("Change ACL"), new GemsCheckNode("Change Admin ACL"), new GemsCheckNode("Change Bridge"), new GemsCheckNode("Change Connection"), new GemsCheckNode("Change Durable"), new GemsCheckNode("Change Factory"), new GemsCheckNode("Change Group"), new GemsCheckNode("Change Message"), new GemsCheckNode("Change Route"), new GemsCheckNode("Change Server"), new GemsCheckNode("Change User"), new GemsCheckNode("Create Destination"), new GemsCheckNode("Delete Destination"), new GemsCheckNode("Modify Destination"), new GemsCheckNode("Purge Permissions:"), new GemsCheckNode("Purge Destination"), new GemsCheckNode("Purge Durable"), new GemsCheckNode("Shutdown Permissions:"), new GemsCheckNode("Shutdown Server"), new GemsCheckNode("Protect Permissions:"), new GemsCheckNode("Protect1"), new GemsCheckNode("Protect2"), new GemsCheckNode("Protect3"), new GemsCheckNode("Protect4")};
        this.m_perms = new JTree(this.m_px[0]);
        this.m_perms.setUI(new MetalTreeUI());
        this.m_perms.setBorder(new EtchedBorder());
        this.m_perms.setCellRenderer(new GemsCheckRenderer());
        this.m_perms.getSelectionModel().setSelectionMode(1);
        this.m_perms.putClientProperty("JTree.lineStyle", "Angled");
        this.m_perms.addMouseListener(new NodeSelectionListener(this.m_perms));
        int p = 0;
        for (int c = 1; c < this.m_px.length; ++c) {
            if (((String)this.m_px[c].getUserObject()).equals("Protect Permissions:")) {
                p = 0;
            } else if (((String)this.m_px[c].getUserObject()).endsWith(":") && p > 1) {
                p = 1;
            }
            this.m_px[p].add(this.m_px[c]);
            if (!((String)this.m_px[c].getUserObject()).endsWith(":")) continue;
            p = c;
        }
        this.m_perms.expandRow(0);
        this.m_perms.expandRow(1);
        JScrollPane sp = new JScrollPane(this.m_perms);
        sp.setPreferredSize(new Dimension(375, 450));
        JPanel midPanel = new JPanel();
        midPanel.setBorder(new TitledBorder("Global Admin Permissions"));
        midPanel.setLayout(new BoxLayout(midPanel, 1));
        JPanel pbutpanel = new JPanel(new FlowLayout());
        JButton a3 = new JButton("Apply");
        a3.addActionListener(new ApplyPressed());
        pbutpanel.add(a3);
        JButton p2 = new JButton("Reset");
        p2.addActionListener(new ResetPressed());
        pbutpanel.add(p2);
        midPanel.add(sp);
        JPanel pbpanel = new JPanel(new FlowLayout());
        JButton p1 = new JButton("Permit All");
        JButton p3 = new JButton("Restrict All");
        pbpanel.add(p1);
        pbpanel.add(p3);
        midPanel.add(pbutpanel);
        mainPanel.add(midPanel);
        JPanel holdbut = new JPanel();
        holdbut.setLayout(new FlowLayout());
        JButton b3 = new JButton("OK");
        JButton c3 = new JButton("Cancel");
        holdbut.add(b3);
        holdbut.add(c3);
        b3.addActionListener(new OkPressed());
        c3.addActionListener(new CancelPressed());
        mainPanel.add(holdbut);
        this.setContentPane(mainPanel);
        this.setLocationRelativeTo(frame);
    }

    public String getSelectedProp() {
        return this.m_selected;
    }

    public void populatePrincipals() {
        try {
            UserInfo[] u = this.m_cn.m_adminConn.getUsers();
            Arrays.sort(u, this.principalComparator);
            for (int i = 0; i < u.length; ++i) {
                if (u[i].getName().equals("admin")) continue;
                String n = u[i].getName() + " (user";
                n = u[i].isExternal() ? n + ", external)" : n + ")";
                this.m_principal.addItem(n);
            }
            GroupInfo[] g = this.m_cn.m_adminConn.getGroups();
            Arrays.sort(g, this.principalComparator);
            for (int i = 0; i < g.length; ++i) {
                if (g[i].getName().equals("$admin")) continue;
                String n = g[i].getName() + " (group";
                n = g[i].isExternal() ? n + ", external)" : n + ")";
                this.m_principal.addItem(n);
            }
            this.m_selected = (String)this.m_principal.getSelectedItem();
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
        }
    }

    public void updatePermissions(boolean first) {
        if (first) {
            return;
        }
        try {
            for (int i = 0; i < this.m_px.length; ++i) {
                this.m_px[i].setSelected(false);
            }
            Object[] acls = this.m_cn.m_adminConn.getPermissions();
            for (int i = 0; i < acls.length; ++i) {
                if (!(acls[i] instanceof AdminACLEntry)) continue;
                AdminACLEntry acl = (AdminACLEntry)acls[i];
                String n = acl.getPrincipal().getName();
                n = acl.getPrincipal() instanceof UserInfo ? n + " (user" : n + " (group";
                if (!this.m_selected.startsWith(n)) continue;
                AdminPermissions p = acl.getPermissions();
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(8192L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(8192L)) {
                    this.m_px[3].setSelected(true);
                }
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(0x4000000L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(0x4000000L)) {
                    this.m_px[4].setSelected(true);
                }
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(0x10000000L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(0x10000000L)) {
                    this.m_px[5].setSelected(true);
                }
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(16L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(16L)) {
                    this.m_px[6].setSelected(true);
                }
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(65536L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(65536L)) {
                    this.m_px[7].setSelected(true);
                }
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(64L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(64L)) {
                    this.m_px[8].setSelected(true);
                }
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(1L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(1L)) {
                    this.m_px[9].setSelected(true);
                }
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(2048L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(2048L)) {
                    this.m_px[10].setSelected(true);
                }
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(0x200000L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(0x200000L)) {
                    this.m_px[11].setSelected(true);
                }
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(4L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(4L)) {
                    this.m_px[12].setSelected(true);
                }
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(0x800000L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(0x800000L)) {
                    this.m_px[13].setSelected(true);
                }
                if ((p.hasPositivePermission(0x2000000000000000L) || p.hasPositivePermission(512L) || p.hasPositivePermission(0x4000000000000000L)) && !p.hasNegativePermission(512L)) {
                    this.m_px[14].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(16384L)) && !p.hasNegativePermission(16384L)) {
                    this.m_px[16].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(0x8000000L)) && !p.hasNegativePermission(0x8000000L)) {
                    this.m_px[17].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(0x20000000L)) && !p.hasNegativePermission(0x20000000L)) {
                    this.m_px[18].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(32L)) && !p.hasNegativePermission(32L)) {
                    this.m_px[19].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(128L)) && !p.hasNegativePermission(128L)) {
                    this.m_px[20].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(2L)) && !p.hasNegativePermission(2L)) {
                    this.m_px[21].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(4096L)) && !p.hasNegativePermission(4096L)) {
                    this.m_px[22].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(0x400000L)) && !p.hasNegativePermission(0x400000L)) {
                    this.m_px[23].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(8L)) && !p.hasNegativePermission(8L)) {
                    this.m_px[24].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(0x1000000L)) && !p.hasNegativePermission(0x1000000L)) {
                    this.m_px[25].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(1024L)) && !p.hasNegativePermission(1024L)) {
                    this.m_px[26].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(131072L)) && !p.hasNegativePermission(131072L)) {
                    this.m_px[27].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(262144L)) && !p.hasNegativePermission(262144L)) {
                    this.m_px[28].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(524288L)) && !p.hasNegativePermission(524288L)) {
                    this.m_px[29].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(0x100000L)) && !p.hasNegativePermission(0x100000L)) {
                    this.m_px[31].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(256L)) && !p.hasNegativePermission(256L)) {
                    this.m_px[32].setSelected(true);
                }
                if ((p.hasPositivePermission(0x4000000000000000L) || p.hasPositivePermission(0x2000000L)) && !p.hasNegativePermission(0x2000000L)) {
                    this.m_px[34].setSelected(true);
                }
                if (p.hasPositivePermission(0x80000000000000L) && !p.hasNegativePermission(0x80000000000000L)) {
                    this.m_px[36].setSelected(true);
                }
                if (p.hasPositivePermission(0x100000000000000L) && !p.hasNegativePermission(0x100000000000000L)) {
                    this.m_px[37].setSelected(true);
                }
                if (p.hasPositivePermission(0x200000000000000L) && !p.hasNegativePermission(0x200000000000000L)) {
                    this.m_px[38].setSelected(true);
                }
                if (p.hasPositivePermission(0x400000000000000L) && !p.hasNegativePermission(0x400000000000000L)) {
                    this.m_px[39].setSelected(true);
                }
                break;
            }
        }
        catch (TibjmsAdminException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 1);
        }
        this.m_perms.repaint();
    }

    public void setPermissions() {
        try {
            UserInfo pr;
            AdminPermissions gp = new AdminPermissions();
            AdminPermissions rp = new AdminPermissions();
            if (this.m_px[1].areAllChildrenSelected()) {
                gp.setPermission(0x4000000000000000L, true);
            } else if (!this.m_px[1].isSelected()) {
                rp.setPermission(0x4000000000000000L, true);
            } else {
                if (this.m_px[2].areAllChildrenSelected()) {
                    gp.setPermission(0x2000000000000000L, true);
                } else if (!this.m_px[2].isSelected()) {
                    rp.setPermission(0x2000000000000000L, true);
                } else {
                    if (this.m_px[3].isSelected()) {
                        gp.setPermission(8192L, true);
                    } else {
                        rp.setPermission(8192L, true);
                    }
                    if (this.m_px[4].isSelected()) {
                        gp.setPermission(0x4000000L, true);
                    } else {
                        rp.setPermission(0x4000000L, true);
                    }
                    if (this.m_px[5].isSelected()) {
                        gp.setPermission(0x10000000L, true);
                    } else {
                        rp.setPermission(0x10000000L, true);
                    }
                    if (this.m_px[6].isSelected()) {
                        gp.setPermission(16L, true);
                    } else {
                        rp.setPermission(16L, true);
                    }
                    if (this.m_px[7].isSelected()) {
                        gp.setPermission(65536L, true);
                    } else {
                        rp.setPermission(65536L, true);
                    }
                    if (this.m_px[8].isSelected()) {
                        gp.setPermission(64L, true);
                    } else {
                        rp.setPermission(64L, true);
                    }
                    if (this.m_px[9].isSelected()) {
                        gp.setPermission(1L, true);
                    } else {
                        rp.setPermission(1L, true);
                    }
                    if (this.m_px[10].isSelected()) {
                        gp.setPermission(2048L, true);
                    } else {
                        rp.setPermission(2048L, true);
                    }
                    if (this.m_px[11].isSelected()) {
                        gp.setPermission(0x200000L, true);
                    } else {
                        rp.setPermission(0x200000L, true);
                    }
                    if (this.m_px[12].isSelected()) {
                        gp.setPermission(4L, true);
                    } else {
                        rp.setPermission(4L, true);
                    }
                    if (this.m_px[13].isSelected()) {
                        gp.setPermission(0x800000L, true);
                    } else {
                        rp.setPermission(0x800000L, true);
                    }
                    if (this.m_px[14].isSelected()) {
                        gp.setPermission(512L, true);
                    } else {
                        rp.setPermission(512L, true);
                    }
                }
                if (this.m_px[16].isSelected()) {
                    gp.setPermission(16384L, true);
                } else {
                    rp.setPermission(16384L, true);
                }
                if (this.m_px[17].isSelected()) {
                    gp.setPermission(0x8000000L, true);
                } else {
                    rp.setPermission(0x8000000L, true);
                }
                if (this.m_px[18].isSelected()) {
                    gp.setPermission(0x20000000L, true);
                } else {
                    rp.setPermission(0x20000000L, true);
                }
                if (this.m_px[19].isSelected()) {
                    gp.setPermission(32L, true);
                } else {
                    rp.setPermission(32L, true);
                }
                if (this.m_px[20].isSelected()) {
                    gp.setPermission(128L, true);
                } else {
                    rp.setPermission(128L, true);
                }
                if (this.m_px[21].isSelected()) {
                    gp.setPermission(2L, true);
                } else {
                    rp.setPermission(2L, true);
                }
                if (this.m_px[22].isSelected()) {
                    gp.setPermission(4096L, true);
                } else {
                    rp.setPermission(4096L, true);
                }
                if (this.m_px[23].isSelected()) {
                    gp.setPermission(0x400000L, true);
                } else {
                    rp.setPermission(0x400000L, true);
                }
                if (this.m_px[24].isSelected()) {
                    gp.setPermission(8L, true);
                } else {
                    rp.setPermission(8L, true);
                }
                if (this.m_px[25].isSelected()) {
                    gp.setPermission(0x1000000L, true);
                } else {
                    rp.setPermission(0x1000000L, true);
                }
                if (this.m_px[26].isSelected()) {
                    gp.setPermission(1024L, true);
                } else {
                    rp.setPermission(1024L, true);
                }
                if (this.m_px[27].isSelected()) {
                    gp.setPermission(131072L, true);
                } else {
                    rp.setPermission(131072L, true);
                }
                if (this.m_px[28].isSelected()) {
                    gp.setPermission(262144L, true);
                } else {
                    rp.setPermission(262144L, true);
                }
                if (this.m_px[29].isSelected()) {
                    gp.setPermission(524288L, true);
                } else {
                    rp.setPermission(524288L, true);
                }
                if (this.m_px[31].isSelected()) {
                    gp.setPermission(0x100000L, true);
                } else {
                    rp.setPermission(0x100000L, true);
                }
                if (this.m_px[32].isSelected()) {
                    gp.setPermission(256L, true);
                } else {
                    rp.setPermission(256L, true);
                }
                if (this.m_px[34].isSelected()) {
                    gp.setPermission(0x2000000L, true);
                } else {
                    rp.setPermission(0x2000000L, true);
                }
            }
            if (this.m_px[36].isSelected()) {
                gp.setPermission(0x80000000000000L, true);
            } else {
                rp.setPermission(0x80000000000000L, true);
            }
            if (this.m_px[37].isSelected()) {
                gp.setPermission(0x100000000000000L, true);
            } else {
                rp.setPermission(0x100000000000000L, true);
            }
            if (this.m_px[38].isSelected()) {
                gp.setPermission(0x200000000000000L, true);
            } else {
                rp.setPermission(0x200000000000000L, true);
            }
            if (this.m_px[39].isSelected()) {
                gp.setPermission(0x400000000000000L, true);
            } else {
                rp.setPermission(0x400000000000000L, true);
            }
            int i = this.m_selected.lastIndexOf(" (user");
            if (i > 0) {
                pr = new UserInfo(this.m_selected.substring(0, i));
            } else {
                i = this.m_selected.lastIndexOf(" (group");
                pr = new GroupInfo(this.m_selected.substring(0, i));
            }
            if (!rp.isEmpty()) {
                this.m_cn.m_adminConn.revoke(new AdminACLEntry((PrincipalInfo)pr, rp));
            }
            if (!gp.isEmpty()) {
                this.m_cn.m_adminConn.grant(new AdminACLEntry((PrincipalInfo)pr, gp));
            }
            if (rp.hasPositivePermission(0x4000000000000000L)) {
                this.updatePermissions(false);
            }
            Gems.getGems().scheduleRepaint();
        }
        catch (TibjmsAdminException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 1);
            this.updatePermissions(false);
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int y;
            int x = e.getX();
            int row = this.tree.getRowForLocation(x, y = e.getY());
            TreePath path = this.tree.getPathForRow(row);
            if (path != null) {
                GemsCheckNode node = (GemsCheckNode)path.getLastPathComponent();
                boolean isSelected = !node.isSelected();
                node.setSelected(isSelected);
                if (node.getSelectionMode() == 4) {
                    this.tree.expandPath(path);
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
                if (row >= 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
            }
        }
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsAdminPermissionDialog.this.m_cancelled = true;
            GemsAdminPermissionDialog.this.dispose();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsAdminPermissionDialog.this.setPermissions();
            GemsAdminPermissionDialog.this.dispose();
        }
    }

    class ApplyPressed
    implements ActionListener {
        ApplyPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsAdminPermissionDialog.this.setPermissions();
        }
    }

    class PrincipalSelected
    implements ActionListener {
        PrincipalSelected() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsAdminPermissionDialog.this.m_selected = (String)GemsAdminPermissionDialog.this.m_principal.getSelectedItem();
            GemsAdminPermissionDialog.this.updatePermissions(false);
        }
    }

    class ResetPressed
    implements ActionListener {
        ResetPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsAdminPermissionDialog.this.updatePermissions(false);
        }
    }
}

