/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsCheckboxRenderer;
import com.tibco.gems.GemsManageBridgesDialog;
import com.tibco.gems.GetPopupHandler;
import com.tibco.gems.PopupBridgeTableHandler;
import com.tibco.gems.PopupHandler;
import com.tibco.tibjms.admin.BridgeInfo;
import com.tibco.tibjms.admin.BridgeTarget;
import com.tibco.tibjms.admin.DestinationBridgeInfo;
import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class GemsBridgeTableModel
extends DefaultTableModel
implements GetPopupHandler {
    JTable m_table;
    boolean m_isEditable;
    boolean m_showCheckbox = false;
    PopupHandler m_popup = null;
    Object m_obj = new Object();
    MyRenderer m_renderer = new MyRenderer();
    GemsCheckboxRenderer m_checkRenderer = new GemsCheckboxRenderer();
    SimpleDateFormat dateFormatMillis = new SimpleDateFormat("EEE MMM dd HH:mm:ss SSS zzz yyyy");
    GemsManageBridgesDialog m_manager = null;

    public GemsBridgeTableModel(boolean editable, boolean showCheckbox, GemsManageBridgesDialog m) {
        this.m_isEditable = editable;
        this.m_showCheckbox = showCheckbox;
        this.m_manager = m;
    }

    @Override
    public PopupHandler getPopupHandler() {
        if (this.m_popup == null) {
            this.m_popup = new PopupBridgeTableHandler(this.m_table, this, this.m_manager);
        }
        return this.m_popup;
    }

    public Class getColumnClass(int columnIndex) {
        Object o = this.getValueAt(0, columnIndex);
        if (o != null) {
            return o.getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.m_showCheckbox && col < 1) {
            return true;
        }
        return this.m_isEditable;
    }

    public Vector getSelectedBridges() {
        Vector<DestinationBridgeInfo> v = new Vector<DestinationBridgeInfo>();
        if (this.m_showCheckbox) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!((Boolean)this.m_table.getValueAt(i, 0)).booleanValue()) continue;
                v.add(new DestinationBridgeInfo(this.m_table.getValueAt(i, 2).equals("Queue") ? 1 : 2, (String)this.m_table.getValueAt(i, 1), this.m_table.getValueAt(i, 4).equals("Queue") ? 1 : 2, (String)this.m_table.getValueAt(i, 3), ""));
            }
        }
        return v;
    }

    public void selectAllRows() {
        if (this.m_showCheckbox) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.m_table.setValueAt(new Boolean(true), i, 0);
            }
        }
    }

    public void toggleSelectedRow() {
        this.m_table.setValueAt(new Boolean((Boolean)this.m_table.getValueAt(this.m_table.getSelectedRow(), 0) == false), this.m_table.getSelectedRow(), 0);
    }

    public void buildColumnHeaders() {
        this.setRowCount(0);
        this.setColumnCount(0);
        this.m_table.setAutoResizeMode(0);
        this.m_table.setDefaultRenderer(Boolean.class, this.m_checkRenderer);
        Object[] cols = this.m_showCheckbox ? new String[]{"Sel", "Source Destination", "Source Type", "Target Destination", "Target Type", "Selector"} : new String[]{"Source Destination", "Source Type", "Target Destination", "Target Type", "Selector"};
        this.setColumnIdentifiers(cols);
        if (this.m_showCheckbox) {
            this.m_table.getColumn("Sel").setPreferredWidth(30);
        }
        this.m_table.getColumn("Source Destination").setPreferredWidth(250);
        this.m_table.getColumn("Target Destination").setPreferredWidth(250);
        this.m_table.getColumn("Source Type").setPreferredWidth(80);
        this.m_table.getColumn("Target Type").setPreferredWidth(80);
        this.m_table.getColumn("Selector").setPreferredWidth(250);
    }

    public void addBridge(BridgeInfo b, Pattern p) {
        if (b != null) {
            BridgeTarget[] ti = b.getTargets();
            for (int i = 0; i < ti.length; ++i) {
                if (p != null && !p.matcher(ti[i].getName()).matches()) continue;
                Object[] r = this.m_showCheckbox ? new Object[]{new Boolean(false), b.getName(), new String(b.getType() == 1 ? "Queue" : "Topic"), ti[i].getName(), new String(ti[i].getType() == 1 ? "Queue" : "Topic"), ti[i].getSelector()} : new Object[]{b.getName(), new String(b.getType() == 1 ? "Queue" : "Topic"), ti[i].getName(), new String(ti[i].getType() == 1 ? "Queue" : "Topic"), ti[i].getSelector()};
                this.addRow(r);
            }
        }
    }

    public void populateBridgeInfo(BridgeInfo[] di, Pattern p) {
        this.setRowCount(0);
        if (di == null) {
            return;
        }
        for (int i = 0; i < di.length; ++i) {
            this.addBridge(di[i], p);
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        public MyRenderer() {
            this.setToolTipText("Select checkboxes of destinations to purge");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Long) {
                this.setHorizontalAlignment(4);
                if ((Long)value > 0L && table.getColumnName(column).startsWith("Pending")) {
                    cell.setBackground(Color.orange);
                } else if (isSelected) {
                    cell.setBackground(table.getSelectionBackground());
                } else {
                    cell.setBackground(Color.white);
                }
            } else {
                this.setHorizontalAlignment(2);
                if (isSelected) {
                    cell.setBackground(table.getSelectionBackground());
                } else {
                    cell.setBackground(Color.white);
                }
            }
            return cell;
        }
    }
}

