/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class GemsBrowser
extends JFrame
implements HyperlinkListener,
ActionListener {
    private JTextField urlField;
    private JEditorPane htmlPane;
    private String initialURL;

    public GemsBrowser(String initialURL) {
        super("Gems Help");
        this.initialURL = initialURL;
        this.setDefaultCloseOperation(2);
        this.setIconImage(Gems.getGems().m_icon.getImage());
        JPanel topPanel = new JPanel();
        JLabel urlLabel = new JLabel("URL:");
        this.urlField = new JTextField(60);
        this.urlField.setText(initialURL);
        this.urlField.addActionListener(this);
        topPanel.add(urlLabel);
        topPanel.add(this.urlField);
        this.getContentPane().add((Component)topPanel, "North");
        try {
            this.htmlPane = new JEditorPane(initialURL);
            this.htmlPane.setEditable(false);
            this.htmlPane.addHyperlinkListener(this);
            JScrollPane scrollPane = new JScrollPane(this.htmlPane);
            this.getContentPane().add((Component)scrollPane, "Center");
        }
        catch (IOException ioe) {
            System.err.println("JMSException: " + ioe.getMessage());
        }
        Dimension screenSize = this.getToolkit().getScreenSize();
        int width = screenSize.width * 7 / 10;
        int height = screenSize.height * 8 / 10 + 20;
        this.setBounds(width / 7, height / 7, width, height);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String url = "";
        url = this.urlField.getText();
        try {
            this.htmlPane.setPage(new URL(url));
        }
        catch (IOException ioe) {
            System.err.println("JMSException: " + ioe.getMessage());
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                if (event instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)event;
                    HTMLDocument doc = (HTMLDocument)this.htmlPane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    this.htmlPane.setPage(event.getURL());
                    this.urlField.setText(event.getURL().toExternalForm());
                }
            }
            catch (IOException ioe) {
                System.err.println("JMSException: " + ioe.getMessage());
            }
        }
    }
}

