/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GemsBrowserFilterDialog
extends JDialog {
    protected JTextField m_filter;
    protected boolean m_cancelled = false;
    protected Frame m_frame;
    protected Pattern m_pattern = null;

    public GemsBrowserFilterDialog(Frame frame, String title) {
        super(frame, title, true);
        this.m_frame = frame;
    }

    public Pattern getFilter(Pattern p, String s) {
        Font font = new Font("Serif", 0, 14);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel spanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.add(spanel);
        spanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel l2 = new JLabel("Only show " + s + " that match this regex:");
        l2.setFont(font);
        this.m_filter = new JTextField(p != null ? p.pattern() : "");
        this.m_filter.setFont(font);
        spanel.add((Component)l2, "North");
        spanel.add((Component)this.m_filter, "Center");
        JLabel l3 = new JLabel("<html>Example: &nbsp;&nbsp;.*[Ee]rror.* &nbsp;&nbsp;matches " + s + " containing Error or error</html>");
        l3.setFont(font);
        spanel.add((Component)l3, "South");
        JPanel holdbut = new JPanel();
        holdbut.setLayout(new FlowLayout());
        JButton a3 = new JButton("OK ");
        JButton b3 = new JButton("Cancel ");
        holdbut.add(a3);
        holdbut.add(b3);
        a3.addActionListener(new OkPressed());
        b3.addActionListener(new CancelPressed());
        mainPanel.add(holdbut);
        this.setContentPane(mainPanel);
        this.setLocationRelativeTo(this.m_frame);
        this.pack();
        this.show();
        if (!this.m_cancelled) {
            return this.m_pattern;
        }
        return null;
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsBrowserFilterDialog.this.m_cancelled = true;
            GemsBrowserFilterDialog.this.dispose();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsBrowserFilterDialog.this.m_pattern = Pattern.compile(GemsBrowserFilterDialog.this.m_filter.getText());
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(GemsBrowserFilterDialog.this.m_frame, exc.getMessage(), "Error", 1);
                System.err.println("Exception: " + exc.getMessage());
                return;
            }
            GemsBrowserFilterDialog.this.dispose();
        }
    }
}

