/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsUtilities;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class GemsBrowserOptionsDialog
extends JDialog {
    protected JTextField m_delay = null;
    protected JTextField m_timeout = null;
    protected JCheckBox m_oldFirst;
    protected JCheckBox m_useServerTimestamps = null;
    protected boolean m_cancelled = false;

    public GemsBrowserOptionsDialog(Frame frame, String title, boolean showUseServerTimestamps, boolean showReqReplyTimeout, boolean showMsgReadDelay) {
        super(frame, title, true);
        this.init(frame, title, showUseServerTimestamps, showReqReplyTimeout, showMsgReadDelay);
    }

    public GemsBrowserOptionsDialog(Frame frame, String title, boolean showUseServerTimestamps) {
        super(frame, title, true);
        this.init(frame, title, showUseServerTimestamps, true, true);
    }

    public GemsBrowserOptionsDialog(Frame frame, String title) {
        super(frame, title, true);
        this.init(frame, title, false, false, true);
    }

    public void init(Frame frame, String title, boolean showUseServerTimestamps, boolean showReqReplyTimeout, boolean showMsgReadDelay) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel spanel = new JPanel(new SpringLayout(), true);
        mainPanel.add(spanel);
        int rows = 0;
        if (showMsgReadDelay) {
            JLabel l2 = new JLabel("Message read delay (millisecs):", 11);
            this.m_delay = new JTextField(Gems.getGems().getMsgReadDelayStr(), 20);
            this.m_delay.setMaximumSize(new Dimension(50, 0));
            l2.setLabelFor(this.m_delay);
            spanel.add(l2);
            spanel.add(this.m_delay);
            ++rows;
        }
        JLabel l3 = new JLabel("View oldest messages first:", 11);
        this.m_oldFirst = new JCheckBox();
        this.m_oldFirst.setSelected(Gems.getGems().getViewOldMessagesFirst());
        l3.setLabelFor(this.m_oldFirst);
        spanel.add(l3);
        spanel.add(this.m_oldFirst);
        ++rows;
        if (showUseServerTimestamps) {
            JLabel l4 = new JLabel("Use Server based timestamps:", 11);
            this.m_useServerTimestamps = new JCheckBox();
            this.m_useServerTimestamps.setSelected(Gems.getGems().getUseServerTimestamps());
            l4.setLabelFor(this.m_useServerTimestamps);
            spanel.add(l4);
            spanel.add(this.m_useServerTimestamps);
            ++rows;
        }
        if (showReqReplyTimeout) {
            JLabel l5 = new JLabel("Request/reply timeout (secs):", 11);
            this.m_timeout = new JTextField(Gems.getGems().getRequestReplyTimeoutStr(), 20);
            this.m_timeout.setMaximumSize(new Dimension(50, 0));
            l5.setLabelFor(this.m_timeout);
            spanel.add(l5);
            spanel.add(this.m_timeout);
            ++rows;
        }
        GemsUtilities.makeCompactGrid(spanel, rows, 2, 5, 5, 8, 8);
        JPanel holdbut = new JPanel();
        holdbut.setLayout(new FlowLayout());
        JButton a3 = new JButton("OK ");
        JButton b3 = new JButton("Cancel ");
        holdbut.add(a3);
        holdbut.add(b3);
        a3.addActionListener(new OkPressed());
        b3.addActionListener(new CancelPressed());
        mainPanel.add(holdbut);
        this.setContentPane(mainPanel);
        this.setLocationRelativeTo(frame);
        this.pack();
        this.show();
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsBrowserOptionsDialog.this.m_cancelled = true;
            GemsBrowserOptionsDialog.this.dispose();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsBrowserOptionsDialog.this.m_delay != null) {
                Gems.getGems().setMsgReadDelay(GemsBrowserOptionsDialog.this.m_delay.getText());
            }
            Gems.getGems().setViewOldMessagesFirst(GemsBrowserOptionsDialog.this.m_oldFirst.isSelected());
            if (GemsBrowserOptionsDialog.this.m_useServerTimestamps != null) {
                Gems.getGems().setUseServerTimestamps(GemsBrowserOptionsDialog.this.m_useServerTimestamps.isSelected());
            }
            if (GemsBrowserOptionsDialog.this.m_timeout != null && GemsBrowserOptionsDialog.this.m_timeout.getText() != null) {
                Gems.getGems().setRequestReplyTimeout(GemsBrowserOptionsDialog.this.m_timeout.getText());
            }
            GemsBrowserOptionsDialog.this.dispose();
        }
    }
}

