/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class GemsCheckNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    protected int selectionMode;
    protected boolean isSelected;

    public GemsCheckNode() {
        this(null);
    }

    public GemsCheckNode(Object userObject) {
        this(userObject, true, false);
    }

    public GemsCheckNode(Object userObject, boolean allowsChildren, boolean isSelected) {
        super(userObject, allowsChildren);
        this.isSelected = isSelected;
        this.setSelectionMode(4);
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if (this.selectionMode == 4) {
            GemsCheckNode p;
            if (this.children != null) {
                Enumeration enm = this.children.elements();
                while (enm.hasMoreElements()) {
                    GemsCheckNode node = (GemsCheckNode)enm.nextElement();
                    node.setSelected(isSelected);
                }
            }
            if ((p = (GemsCheckNode)this.getParent()) != null) {
                p.updateSelection();
            }
        }
    }

    public void updateSelection() {
        if (this.selectionMode == 4) {
            GemsCheckNode p;
            Gems.debug("UpSel " + this.toString());
            if (this.children != null) {
                Enumeration enm = this.children.elements();
                int s = 0;
                while (enm.hasMoreElements()) {
                    GemsCheckNode node = (GemsCheckNode)enm.nextElement();
                    if (!node.isSelected()) continue;
                    ++s;
                }
                this.isSelected = s > 0;
            }
            if ((p = (GemsCheckNode)this.getParent()) != null) {
                p.updateSelection();
            }
        }
    }

    public int getSelectedLeafCount(int count) {
        if (this.children() != null && this.getChildCount() > 0) {
            Enumeration<TreeNode> enm = this.children();
            while (enm.hasMoreElements()) {
                GemsCheckNode node = (GemsCheckNode)enm.nextElement();
                count = node.getSelectedLeafCount(count);
            }
            return count;
        }
        if (this.isSelected()) {
            ++count;
        }
        return count;
    }

    public boolean areAllChildrenSelected() {
        if (this.children != null) {
            Enumeration enm = this.children.elements();
            int s = 0;
            int c = 0;
            while (enm.hasMoreElements()) {
                ++c;
                GemsCheckNode node = (GemsCheckNode)enm.nextElement();
                if (!node.isSelected()) continue;
                ++s;
            }
            return c > 0 && s == c;
        }
        return false;
    }

    public boolean isSelected() {
        return this.isSelected;
    }
}

