/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class GemsConfigDialog
extends JDialog {
    Frame m_frame = null;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel lblWarning;
    private JScrollPane scrollPane1;
    private JTextPane txtConfig;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton saveButton;
    private JButton saveAsButton;

    public GemsConfigDialog(Frame owner) {
        super(owner);
        this.m_frame = owner;
        this.initComponents();
    }

    public GemsConfigDialog(Dialog owner) {
        super(owner);
        this.initComponents();
    }

    private void okButtonActionPerformed() {
        this.dispose();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.lblWarning = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.txtConfig = new JTextPane();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.saveButton = new JButton();
        this.saveAsButton = new JButton();
        this.setTitle("Gems Config");
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.dialogPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialogPane.setLayout(new BorderLayout(20, 20));
        this.contentPanel.setLayout(new BorderLayout(10, 10));
        this.lblWarning.setText("Save configuration to " + Gems.getGems().getServerConfigFile() + " file (passwords are encrypted)");
        this.lblWarning.setFont(new Font("Tahoma", 1, 14));
        this.contentPanel.add((Component)this.lblWarning, "First");
        this.scrollPane1.setHorizontalScrollBarPolicy(31);
        this.scrollPane1.setVerticalScrollBarPolicy(22);
        this.scrollPane1.setPreferredSize(new Dimension(650, 475));
        this.txtConfig.setText("text");
        this.txtConfig.setFont(new Font("Courier New", 0, 14));
        this.scrollPane1.setViewportView(this.txtConfig);
        this.contentPanel.add((Component)this.scrollPane1, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.okButton.setText("Cancel");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsConfigDialog.this.okButtonActionPerformed();
            }
        });
        this.saveButton.setText("Save ");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsConfigDialog.this.saveButtonActionPerformed();
            }
        });
        this.saveAsButton.setText("Save As...");
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsConfigDialog.this.saveAsButtonActionPerformed();
            }
        });
        this.buttonBar.add(this.saveButton);
        this.buttonBar.add(this.saveAsButton);
        this.buttonBar.add(this.okButton);
        this.dialogPane.add((Component)this.buttonBar, "Last");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.txtConfig.setText(this.getConfig());
        this.txtConfig.setCaretPosition(0);
        this.setContentPane(this.dialogPane);
        this.pack();
    }

    String getConfig() {
        try {
            Document doc = Gems.getGems().buildConfigDocument();
            TransformerFactory transfac = TransformerFactory.newInstance();
            transfac.setAttribute("indent-number", new Integer(2));
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
            return sw.toString();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            return "Error: failed to build configuration document";
        }
    }

    private void saveButtonActionPerformed() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new StringBufferInputStream(this.txtConfig.getText()));
            int opt = 0;
            File f = new File(Gems.getGems().getServerConfigFile());
            if (f.exists()) {
                opt = JOptionPane.showConfirmDialog(this, "Configuration file " + Gems.getGems().getServerConfigFile() + " will be overwritten, are you sure?", "Save Configuration", 0);
            }
            if (opt == 0) {
                FileOutputStream fout = new FileOutputStream(f);
                PrintStream p = new PrintStream(fout);
                p.println(this.txtConfig.getText());
                p.close();
                Gems.getGems().isDirty(false);
                this.dispose();
            }
        }
        catch (IOException ie) {
            JOptionPane.showMessageDialog(this, ie.getMessage(), "Error", 1);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 1);
            return;
        }
    }

    private void saveAsButtonActionPerformed() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new StringBufferInputStream(this.txtConfig.getText()));
            JFileChooser chooser = new JFileChooser(new File("."));
            chooser.setApproveButtonText("Save");
            chooser.setDialogTitle("Save Config To File");
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                f.createNewFile();
                FileOutputStream fout = new FileOutputStream(f);
                PrintStream p = new PrintStream(fout);
                p.println(this.txtConfig.getText());
                p.close();
                Gems.getGems().isDirty(false);
                this.dispose();
            }
        }
        catch (IOException ie) {
            JOptionPane.showMessageDialog(this, ie.getMessage(), "Error", 1);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 1);
            return;
        }
    }
}

