/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.tibco.gems.Gems;
import com.tibco.gems.GemsEventMonitor;
import com.tibco.gems.GemsIconNode;
import com.tibco.gems.GemsProperty;
import com.tibco.gems.GemsQueueNode;
import com.tibco.gems.GemsSSNode;
import com.tibco.gems.GemsServiceTable;
import com.tibco.gems.GemsSetPropDialog;
import com.tibco.gems.GemsTopicNode;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.chart.GemsChartFrame;
import com.tibco.gems.chart.GemsSubscriber;
import com.tibco.tibjms.admin.ConnectionInfo;
import com.tibco.tibjms.admin.ConsumerInfo;
import com.tibco.tibjms.admin.DestinationInfo;
import com.tibco.tibjms.admin.GroupInfo;
import com.tibco.tibjms.admin.LDAPParams;
import com.tibco.tibjms.admin.QueueInfo;
import com.tibco.tibjms.admin.ServerInfo;
import com.tibco.tibjms.admin.StateInfo;
import com.tibco.tibjms.admin.TibjmsAdmin;
import com.tibco.tibjms.admin.TibjmsAdminException;
import com.tibco.tibjms.admin.TibjmsAdminSecurityException;
import com.tibco.tibjms.admin.TopicInfo;
import com.tibco.tibjms.admin.TraceInfo;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.jms.Message;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GemsConnectionNode
extends GemsIconNode
implements Runnable {
    String m_url;
    String m_user;
    String m_password;
    String m_logDir = "./log";
    boolean firstLog = true;
    LOG_TYPE m_logServerInfo = LOG_TYPE.Always;
    String m_topicNamePattern = null;
    String m_queueNamePattern = null;
    String m_topicStoreFilter = null;
    String m_queueStoreFilter = null;
    String m_userNameFilter = null;
    Vector m_logColumnNames = null;
    File m_logFile = null;
    FileOutputStream m_fileOut = null;
    PrintStream m_filePrint = null;
    SimpleDateFormat m_fileDateFormat = new SimpleDateFormat("ddMMMyyyy");
    SimpleDateFormat dateFormatMillis = null;
    TibjmsAdmin m_adminConn = null;
    long m_connId = 0L;
    ServerInfo m_serverInfo = null;
    GemsIconNode m_topicsNode = null;
    GemsIconNode m_queuesNode = null;
    GemsIconNode m_usersNode = null;
    GemsIconNode m_consumersNode = null;
    GemsIconNode m_channelsNode = null;
    GemsIconNode m_producersNode = null;
    GemsIconNode m_connectionsNode = null;
    GemsIconNode m_sysConnectionsNode = null;
    GemsIconNode m_userConnectionsNode = null;
    DefaultMutableTreeNode m_clientsNode = null;
    GemsIconNode m_routesNode = null;
    GemsIconNode m_bridgesNode = null;
    GemsIconNode m_transactionsNode = null;
    GemsIconNode m_transportsNode = null;
    GemsIconNode m_durablesNode = null;
    GemsIconNode m_groupsNode = null;
    GemsIconNode m_aclsNode = null;
    GemsIconNode m_adminAclsNode = null;
    GemsIconNode m_factoriesNode = null;
    GemsIconNode m_storesFileNode = null;
    GemsIconNode m_storesDbNode = null;
    GemsIconNode m_mstoresNode = null;
    DefaultMutableTreeNode m_serviceNode = null;
    Vector m_ssNodes = null;
    DefaultMutableTreeNode m_ssTriggerNode = null;
    DefaultMutableTreeNode m_ssRecipeNode = null;
    DefaultMutableTreeNode m_ssInterfaceNode = null;
    Hashtable m_warnLimits = new Hashtable();
    Hashtable m_errorLimits = new Hashtable();
    Hashtable m_clientIDs = null;
    Properties m_SSSystems = new Properties();
    long m_delay = 0L;
    long m_respTime = 0L;
    Thread m_thread = null;
    static Hashtable props = null;
    boolean m_isAutoConnect = true;
    boolean m_isManualDisconnect = false;
    boolean m_isInError = false;
    boolean m_isInWarning = false;
    Map m_sslParams = new Hashtable();
    GemsServiceTable m_services = null;
    GemsEventMonitor m_eventMonitor = null;
    protected GemsSubscriber m_sub = null;
    protected GemsChartFrame m_chart = null;
    protected Timer m_chartUpdateTimer = null;
    protected String m_csvDelim = ",";
    public int m_serverMajorVer = 0;
    public int m_serverMinorVer = 0;
    protected boolean m_disableCursors = false;
    protected String[] m_storeNames = null;
    StateInfo m_stateInfo = null;
    String m_instanceState = null;
    public AppliancePollerThread m_applPoller = null;
    AdminDisconnectThread m_discThread = null;
    static Hashtable connections = new Hashtable();
    private Object lock1 = new Object();
    protected HashMap m_ldapParams = null;
    Comparator<DestinationInfo> destComparator = new Comparator<DestinationInfo>(){

        @Override
        public int compare(DestinationInfo d1, DestinationInfo d2) {
            return d1.getName().compareTo(d2.getName());
        }
    };

    static Hashtable getConnections() {
        return connections;
    }

    static int getConnectionsCount() {
        return connections.size();
    }

    public synchronized void init() {
        if (props == null) {
            try {
                props = new Hashtable();
                props.put("isAuthorizationEnabled", new GemsProperty("AuthorizationEnabled", Boolean.TYPE, "<html>Enable or disable Authorization mode<br> for subsequent requests</html>"));
                props.put("DetailedStatistics", new GemsProperty("DetailedStatistics", Integer.TYPE, "<html>0 = None, or a combination of<br>2 = Producers, 4 = Consumers, 8 = Routes</html>"));
                props.put("MaxMsgMemory", new GemsProperty("MaxMsgMemory", Long.TYPE, "<html>Maximum number of bytes the server can use for messages</html>"));
                props.put("MaxStatisticsMemory", new GemsProperty("MaxStatisticsMemory", Long.TYPE, "<html>Maximum amount of memory (bytes)<br>to use for detailed statistic gathering</html>"));
                props.put("isMessageSwappingEnabled", new GemsProperty("MessageSwappingEnabled", Boolean.TYPE, "<html>Enables or disables the ability to swap messages to disk</html>"));
                props.put("RateInterval", new GemsProperty("RateInterval", Long.TYPE, "<html>The statistics interval(millisecs) for routes<br>destinations, producers, and consumers</html>"));
                props.put("ServerRateInterval", new GemsProperty("ServerRateInterval", Long.TYPE, "<html>The interval(millisecs) over which server<br>statistics are averaged</html>"));
                props.put("StatisticsCleanupInterval", new GemsProperty("StatisticsCleanupInterval", Long.TYPE, "<html>How long (in millisecs) the server keeps detailed<br>statistics if the destination has no activity</html>"));
                props.put("isStatisticsEnabled", new GemsProperty("StatisticsEnabled", Boolean.TYPE, "<html>Enables or disables statistic gathering for<br>producers, consumers, destinations, and routes</html>"));
                props.put("isTrackCorrelationIds", new GemsProperty("TrackCorrelationIds", Boolean.TYPE, "<html>Enables or disables tracking messages by CorrelationID</html>"));
                props.put("isTrackMsgIds", new GemsProperty("TrackMsgIds", Boolean.TYPE, "<html>Enables or disables tracking messages by MessageID</html>"));
                props.put("isAlwaysExitOnDiskErrorEnabled", new GemsProperty("AlwaysExitOnDiskErrorEnabled", Boolean.TYPE, "<html>Enable or disable the server behavior to exit on any disk error<br>Available from EMS8.4 only</html>"));
                props.put("LargeDestCount", new GemsProperty("LargeDestCount", Long.TYPE, "<html>Set the number of messages that an unbounded destination can hold<br>before the server logs warnings about the destination's message count.<br>Available from EMS8.4 only</html>"));
                props.put("LargeDestMemory", new GemsProperty("LargeDestMemory", Long.TYPE, "<html>Set the amount of message memory that an unbounded destination can hold<br>before the server logs warnings about the destination's size.<br>Available from EMS8.4 only</html>"));
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
        try {
            this.dateFormatMillis = new SimpleDateFormat(Gems.getGems().getLogDateTimeFormat());
        }
        catch (Throwable e) {
            System.err.println("Bad LogDateTimeFormat in gems.props file: " + e);
            this.dateFormatMillis = new SimpleDateFormat("EEE MMM dd HH:mm:ss SSS zzz yyyy");
        }
        this.m_csvDelim = Gems.getGems().getCSVFileDelimiter();
        this.initLimits();
    }

    public GemsConnectionNode(String name) {
        super(name, true);
        this.m_url = "tcp://localhost:7222";
        this.m_user = "admin";
        this.setIconName("computer");
        this.init();
    }

    public GemsConnectionNode(String name, String url, String user, String passwd, long delay, boolean autoConnect, LOG_TYPE logType, String logDir) {
        super(name, true);
        this.m_url = url;
        this.m_user = user;
        this.m_password = passwd;
        this.m_delay = delay * 1000L;
        this.m_logDir = logDir;
        this.m_logServerInfo = logType;
        this.setIconName("computer");
        this.init();
        this.m_isAutoConnect = autoConnect;
    }

    public boolean showError() {
        if (this.m_adminConn == null) {
            return true;
        }
        if (this.m_eventMonitor != null && this.m_eventMonitor.m_messages.size() > 0) {
            return true;
        }
        return this.m_isInError;
    }

    public boolean showWarning() {
        return this.m_isInWarning;
    }

    public String getUrl() {
        return this.m_url;
    }

    LOG_TYPE getServerLogInfo() {
        return this.m_logServerInfo;
    }

    String getServerLogDir() {
        return this.m_logDir;
    }

    void setServerLogInfo(LOG_TYPE type) {
        this.m_logServerInfo = type;
    }

    void setServerLogDir(String dir) {
        this.m_logDir = dir;
    }

    public String getQueueNamePattern() {
        if (this.m_queueNamePattern == null) {
            this.m_queueNamePattern = Gems.getGems().getQueueNamePattern();
        }
        return this.m_queueNamePattern;
    }

    public String getTopicNamePattern() {
        if (this.m_topicNamePattern == null) {
            this.m_topicNamePattern = Gems.getGems().getTopicNamePattern();
        }
        return this.m_topicNamePattern;
    }

    public String getQueueStoreFilter() {
        if (this.m_queueStoreFilter == null) {
            this.m_queueStoreFilter = new String();
        }
        return this.m_queueStoreFilter;
    }

    public String getTopicStoreFilter() {
        if (this.m_topicStoreFilter == null) {
            this.m_topicStoreFilter = new String();
        }
        return this.m_topicStoreFilter;
    }

    public String getUserNameFilter() {
        if (this.m_userNameFilter == null) {
            this.m_userNameFilter = Gems.getGems().getUserNameFilter();
        }
        return this.m_userNameFilter;
    }

    public boolean showEvents() {
        return this.m_eventMonitor != null;
    }

    public boolean eventMonitorEnabled() {
        return this.m_eventMonitor != null && this.m_eventMonitor.m_enabled;
    }

    public boolean isAutoConnect() {
        return this.m_isAutoConnect;
    }

    public boolean isManualDisconnect() {
        return this.m_isManualDisconnect;
    }

    public void setManualDisconnect(boolean manual) {
        this.m_isManualDisconnect = manual;
    }

    public boolean isSSL() {
        return this.m_url.startsWith("ssl");
    }

    public void addEventMonitor(long maxEvents, boolean enabled) {
        this.m_eventMonitor = new GemsEventMonitor(this, maxEvents, enabled);
    }

    public void addEventSubscription(String monitorTopic, String sel) {
        this.m_eventMonitor.addSubscription(monitorTopic, sel);
    }

    public void clearEventMessages() {
        if (this.m_eventMonitor != null) {
            this.m_eventMonitor.reset();
        }
    }

    public Vector getEventMessages() {
        if (this.m_eventMonitor != null) {
            return this.m_eventMonitor.getMessages();
        }
        return null;
    }

    public int getEventCount() {
        if (this.m_eventMonitor != null) {
            return this.m_eventMonitor.getMessageCount();
        }
        return 0;
    }

    public GemsEventMonitor getEventMonitor() {
        return this.m_eventMonitor;
    }

    public long getRespTime() {
        return this.m_respTime;
    }

    public void addServiceTable(long period, boolean useTempQueues, boolean useTempTopics, boolean enabled) {
        this.m_services = new GemsServiceTable(this, period, useTempQueues, useTempTopics, enabled);
    }

    public void addService(String name, String reqDest, boolean reqIsQueue, String respDest, boolean respIsQueue, long respLimit) {
        this.m_services.addService(name, reqDest, reqIsQueue, respDest, respIsQueue, respLimit);
    }

    public long getTopicConsumerBacklog(String dest) {
        long maxBacklog = 0L;
        if (this.m_adminConn == null) {
            return 0L;
        }
        try {
            ConsumerInfo[] ci = this.m_adminConn.getConsumers(null, this.m_user, (DestinationInfo)new TopicInfo(dest), false, 1);
            if (ci != null) {
                for (int i = 0; i < ci.length; ++i) {
                    if (ci[i].getPendingMessageCount() <= maxBacklog) continue;
                    maxBacklog = ci[i].getPendingMessageCount();
                }
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
        }
        return maxBacklog;
    }

    public TraceInfo getServerTrace(boolean isLog) {
        if (this.m_adminConn == null) {
            return null;
        }
        try {
            ServerInfo si = this.m_adminConn.getInfo();
            if (si != null) {
                if (isLog) {
                    return si.getLogTraceInfo();
                }
                return si.getConsoleTraceInfo();
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
        }
        return null;
    }

    public void setServerTrace(TraceInfo ti, boolean isLog) {
        if (this.m_adminConn == null) {
            return;
        }
        try {
            ServerInfo si = this.m_adminConn.getInfo();
            if (si != null) {
                if (isLog) {
                    si.setLogTraceInfo(ti);
                } else {
                    si.setConsoleTraceInfo(ti);
                }
                this.m_adminConn.updateServer(si);
                Gems.getGems().scheduleRepaint();
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void enableClientTrace(Long connId, String user, String host, boolean isStdout) {
        if (this.m_adminConn == null) {
            return;
        }
        try {
            int result;
            ServerInfo si = this.m_adminConn.getInfo();
            if (si != null && (result = JOptionPane.showConfirmDialog(Gems.getGems().m_frame, "Enable client side trace for connection ID: " + connId + ", user: " + user + ", host: " + host + "\nTrace will be printed to client's " + (isStdout ? "stdout" : "stderr") + " stream.\n(Any existing client tracing will be disabled.)", "Enable Client Trace", 2)) == 0) {
                si.enableClientTracing(isStdout ? (short)1 : 2, (short)3, (Object)connId);
                this.m_adminConn.updateServer(si);
            }
        }
        catch (IllegalArgumentException ie) {
            JOptionPane.showMessageDialog(Gems.getGems().m_frame, ie.getMessage(), "Enable Client Trace", 0);
            return;
        }
        catch (Exception e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void disableClientTrace() {
        if (this.m_adminConn == null) {
            return;
        }
        try {
            int result;
            ServerInfo si = this.m_adminConn.getInfo();
            if (si != null && (result = JOptionPane.showConfirmDialog(Gems.getGems().m_frame, "Disable client side tracing?", "Disable Client Trace", 2)) == 0) {
                si.disableClientTracing();
                this.m_adminConn.updateServer(si);
            }
        }
        catch (Exception e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void setServerProperty(String prop) {
        if (this.m_adminConn == null || prop == null) {
            return;
        }
        try {
            GemsSetPropDialog pd;
            String val;
            GemsProperty p = (GemsProperty)props.get(prop);
            String pval = null;
            ServerInfo ti = this.m_adminConn.getInfo();
            if (ti == null) {
                return;
            }
            if (prop != null && (p = (GemsProperty)props.get(prop)) != null) {
                pval = p.getValue(ti);
            }
            if ((val = (pd = new GemsSetPropDialog((Frame)Gems.getGems().m_frame, "Set server Property for " + (String)this.getUserObject())).getValue(props, prop, pval)) != null) {
                p = (GemsProperty)props.get(pd.getSelectedProp());
                p.setValue(ti, val);
                this.m_adminConn.updateServer(ti);
                Gems.getGems().scheduleRepaint();
            }
        }
        catch (TibjmsAdminException e) {
            JOptionPane.showMessageDialog(Gems.getGems().m_frame, e.getMessage(), "Set Server Property", 0);
            return;
        }
    }

    public void disconnect(boolean force, boolean manual) {
        this.m_isManualDisconnect = manual;
        this.disconnect(force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean force) {
        Object object = this.lock1;
        synchronized (object) {
            if (force) {
                if (this.m_discThread != null && this.m_discThread.isRunning()) {
                    System.err.println("Stale admin connection id " + this.m_discThread.connId + " failed to close after " + this.m_discThread.runTime() + " secs, please restart Gems");
                }
                this.m_discThread = new AdminDisconnectThread(this.m_adminConn, this.m_connId, 10);
                this.m_discThread.start();
                this.m_adminConn = null;
                this.m_connId = 0L;
                if (this.m_isAutoConnect && Gems.getGems().getDisableAutoConnectAfterTimeoutException()) {
                    System.err.println("Auto connect disabled after Timeout Exception for: " + this.getName() + "(" + this.m_url + ")");
                    this.m_isAutoConnect = false;
                }
                this.m_serverInfo = null;
            }
            this.m_instanceState = null;
            this.m_stateInfo = null;
            boolean reload = this.getChildCount() > 0;
            this.removeAllChildren();
            String n = (String)this.getUserObject();
            n = n + "(" + this.m_url + ")";
            connections.remove(n);
            if (this.m_ssNodes != null) {
                for (int i = 0; i < this.m_ssNodes.size(); ++i) {
                    GemsSSNode ssn = (GemsSSNode)this.m_ssNodes.get(i);
                    ssn.destroy(force);
                }
                this.m_ssNodes.removeAllElements();
            }
            if (this.m_eventMonitor != null) {
                this.m_eventMonitor.systemStop(force);
            }
            if (this.m_services != null) {
                this.m_services.systemStop(force);
            }
            if (reload) {
                Gems.getGems().reloadTree();
            }
            try {
                this.m_serverInfo = null;
                if (this.m_adminConn != null) {
                    this.m_adminConn.close();
                }
                this.m_adminConn = null;
                this.m_connId = 0L;
            }
            catch (TibjmsAdminException e) {
                this.m_adminConn = null;
                this.m_connId = 0L;
                System.err.println("JMSException: " + e.getMessage());
                return;
            }
        }
    }

    public void connect(String name, String url, String user, String password, Map sslParams) {
        this.setUserObject(name);
        this.m_url = url;
        this.m_user = user;
        this.m_password = password;
        this.m_sslParams = sslParams;
        this.connect();
    }

    public void connect(String name, String url, String user, String password) {
        this.setUserObject(name);
        this.m_url = url;
        this.m_user = user;
        this.m_password = password;
        this.connect();
    }

    public void setSSLParams(Map sslParams) {
        this.m_sslParams = sslParams;
    }

    public String getName() {
        return (String)this.getUserObject();
    }

    public StateInfo getStateInfo() {
        return this.m_stateInfo;
    }

    public void reconnectToActiveIfStandby() {
    }

    public void connect() {
        this.doConnect();
        if (!Gems.getGems().getAutoReconnectToPrimary()) {
            return;
        }
        String testString = this.m_url;
        int attempts = testString.length() - testString.replace(",", "").length();
        for (int i = 0; this.isStandbyMode() && i < attempts; ++i) {
            if (this.m_serverInfo != null) {
                System.err.println("Connected to standby server(" + this.m_serverInfo.getURL() + ") will attempt to swap URLs and reconnect to active server...");
            } else if (this.m_stateInfo != null) {
                System.err.println("Connected to standby server(" + this.m_stateInfo.getServerName() + ") will attempt to swap URLs and reconnect to active server...");
            }
            int ci = this.m_url.indexOf(44);
            if (ci <= 0) continue;
            this.disconnect(false);
            String u = this.m_url.substring(ci + 1);
            u = u + ",";
            this.m_url = u = u + this.m_url.substring(0, ci);
            this.doConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConnect() {
        Object object = this.lock1;
        synchronized (object) {
            this.m_isManualDisconnect = false;
            this.removeAllChildren();
            this.m_disableCursors = Gems.getGems().getDisableCursors();
            try {
                System.err.println("Connecting to: " + this.m_url);
                this.m_adminConn = this.isSSL() && this.m_sslParams != null ? new TibjmsAdmin(this.m_url, this.m_user, this.m_password, this.m_sslParams) : new TibjmsAdmin(this.m_url, this.m_user, this.m_password);
                this.m_adminConn.setAutoSave(true);
                this.m_adminConn.setCommandTimeout(Gems.getGems().getAdminTimeout());
                String n = (String)this.getUserObject();
                n = n + "(" + this.m_url + ")";
                connections.put(n, this);
                this.m_connId = this.m_adminConn.getConnectionId();
                Gems.debug("Got connection, id: " + this.m_connId);
                try {
                    this.m_stateInfo = this.m_adminConn.getStateInfo();
                    this.m_serverMajorVer = this.m_stateInfo.getVersionInfo().getVersionMajor();
                    this.m_serverMinorVer = this.m_stateInfo.getVersionInfo().getVersionMinor();
                    Gems.debug("Got stateInfo, version " + this.m_serverMajorVer + "." + this.m_serverMinorVer);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                long start = System.nanoTime();
                this.m_serverInfo = this.m_adminConn.getInfo();
                long end = System.nanoTime();
                this.m_respTime = (end - start) / 1000000L;
                if (this.m_serverInfo != null) {
                    this.m_serverMajorVer = this.m_serverInfo.getVersionInfo().getVersionMajor();
                    this.m_serverMinorVer = this.m_serverInfo.getVersionInfo().getVersionMinor();
                    Gems.debug("Got serverInfo, version " + this.m_serverMajorVer + "." + this.m_serverMinorVer);
                }
                if (this.m_serverInfo != null) {
                    this.updateErrorWarningFlags();
                    this.m_logColumnNames = GemsUtilities.getStatsMethodNames(this.m_serverInfo.getClass());
                    this.initLDAPParams();
                }
            }
            catch (TibjmsAdminSecurityException se) {
                Gems.debug(se.toString());
                this.m_serverInfo = null;
                if (this.m_adminConn == null) {
                    return;
                }
            }
            catch (TibjmsAdminException e) {
                System.err.println(e.toString());
                return;
            }
            if (this.m_serverInfo != null) {
                String hv = Gems.getGems().getHideViews();
                if (hv.indexOf("ACLs") < 0) {
                    this.m_aclsNode = new GemsIconNode("ACLs", false);
                    this.m_aclsNode.setIconName("acls");
                    this.add(this.m_aclsNode);
                    this.m_adminAclsNode = new GemsIconNode("AdminACLs", false);
                    this.m_adminAclsNode.setIconName("acls");
                    this.add(this.m_adminAclsNode);
                }
                if (hv.indexOf("Bridges") < 0) {
                    this.m_bridgesNode = new GemsIconNode("Bridges", false);
                    this.m_bridgesNode.setIconName("bridges");
                    this.add(this.m_bridgesNode);
                }
                if (hv.indexOf("Channels") < 0 && this.m_serverInfo != null && this.m_serverInfo.isMulticastEnabled()) {
                    this.m_channelsNode = new GemsIconNode("Channels", false);
                    this.m_channelsNode.setIconName("channels");
                    this.add(this.m_channelsNode);
                }
                if ((hv.indexOf("Connections") < 0 || hv.indexOf("Connections(") >= 0) && hv.indexOf("Connections(Client)") < 0) {
                    this.m_connectionsNode = this.m_userNameFilter == null || this.m_userNameFilter.length() == 0 ? new GemsIconNode("Connections(Client)", false) : new GemsIconNode("Connections(" + this.m_userNameFilter + ")", false);
                    this.m_connectionsNode.setIconName("connections");
                    this.add(this.m_connectionsNode);
                }
                if (!(hv.indexOf("Connections") >= 0 && hv.indexOf("Connections(") < 0 || hv.indexOf("Connections(User)") >= 0 || this.m_userNameFilter != null && this.m_userNameFilter.length() != 0)) {
                    this.m_userConnectionsNode = new GemsIconNode("Connections(User)", false);
                    this.m_userConnectionsNode.setIconName("connections");
                    this.add(this.m_userConnectionsNode);
                }
                if (!(hv.indexOf("Connections") >= 0 && hv.indexOf("Connections(") < 0 || hv.indexOf("Connections(System)") >= 0 || this.m_serverInfo == null || !this.m_serverInfo.isRoutingEnabled() && this.m_serverInfo.getFaultTolerantURL() == null)) {
                    this.m_sysConnectionsNode = new GemsIconNode("Connections(System)", false);
                    this.m_sysConnectionsNode.setIconName("connections");
                    this.add(this.m_sysConnectionsNode);
                }
                if (hv.indexOf("Consumers") < 0) {
                    if (this.m_userNameFilter != null && this.m_userNameFilter.length() > 0) {
                        this.m_consumersNode = new GemsIconNode("Consumers(" + this.m_userNameFilter + ")", false);
                        this.add(this.m_consumersNode);
                    } else {
                        if (this.m_serverInfo != null && this.m_serverInfo.getConsumerCount() > Gems.getGems().getMaxConsumers()) {
                            System.err.println("WARNING: Over " + Gems.getGems().getMaxConsumers() + " consumers, main consumers display disabled.");
                        }
                        this.m_consumersNode = new GemsIconNode("Consumers", false);
                        this.m_consumersNode.setIconName("prodcons");
                        this.add(this.m_consumersNode);
                    }
                }
                if (hv.indexOf("Durables") < 0) {
                    this.m_durablesNode = new GemsIconNode("Durables", false);
                    this.m_durablesNode.setIconName("durables");
                    this.add(this.m_durablesNode);
                }
                if (hv.indexOf("Factories") < 0) {
                    this.m_factoriesNode = new GemsIconNode("Factories", false);
                    this.m_factoriesNode.setIconName("factories");
                    this.add(this.m_factoriesNode);
                }
                if (hv.indexOf("Groups") < 0) {
                    this.m_groupsNode = new GemsIconNode("Groups", false);
                    this.m_groupsNode.setIconName("groups");
                    this.add(this.m_groupsNode);
                }
                if (hv.indexOf("Producers") < 0) {
                    if (this.m_userNameFilter != null && this.m_userNameFilter.length() > 0) {
                        this.m_producersNode = new GemsIconNode("Producers(" + this.m_userNameFilter + ")", false);
                        this.m_producersNode.setIconName("prodcons");
                        this.add(this.m_producersNode);
                    } else {
                        if (this.m_serverInfo != null && this.m_serverInfo.getProducerCount() > Gems.getGems().getMaxProducers()) {
                            System.err.println("WARNING: Over " + Gems.getGems().getMaxProducers() + " producers, main producers display disabled.");
                        }
                        this.m_producersNode = new GemsIconNode("Producers", false);
                        this.m_producersNode.setIconName("prodcons");
                        this.add(this.m_producersNode);
                    }
                }
                if (hv.indexOf("Queues") < 0) {
                    String qp = this.getQueueNamePattern();
                    String qn = "Queues";
                    String ob = "(";
                    String cb = "";
                    if (!qp.equals(">")) {
                        qn = qn + ob + qp;
                        ob = " ";
                        cb = ")";
                    }
                    if (this.m_queueStoreFilter != null && this.m_queueStoreFilter.length() > 0) {
                        qn = qn + ob + this.m_queueStoreFilter;
                        cb = ")";
                    }
                    qn = qn + cb;
                    this.m_queuesNode = new GemsIconNode(qn, !Gems.getGems().getHideTreeDests());
                    this.m_queuesNode.setIconName("queues");
                    this.add(this.m_queuesNode);
                }
                if (hv.indexOf("Routes") < 0 && this.m_serverInfo != null && this.m_serverInfo.isRoutingEnabled()) {
                    this.m_routesNode = new GemsIconNode("Routes", false);
                    this.m_routesNode.setIconName("routes");
                    this.add(this.m_routesNode);
                }
                if (this.m_services != null) {
                    this.m_serviceNode = new DefaultMutableTreeNode("Services", false);
                    this.add(this.m_serviceNode);
                }
                if (hv.indexOf("Stores") < 0) {
                    this.m_storesFileNode = new GemsIconNode("Stores", false);
                    this.m_storesFileNode.setIconName("stores");
                    this.add(this.m_storesFileNode);
                }
                boolean gotDB = false;
                try {
                    if (this.m_serverInfo != null && this.m_serverInfo.getDbStoreClasspath() != null) {
                        gotDB = true;
                    }
                }
                catch (Throwable qn) {
                    // empty catch block
                }
                if ((hv.indexOf("Stores") < 0 || hv.indexOf("Stores(") >= 0) && hv.indexOf("Stores(DB)") < 0 && gotDB) {
                    this.m_storesDbNode = new GemsIconNode("Stores(DB)", false);
                    this.m_storesDbNode.setIconName("stores");
                    this.add(this.m_storesDbNode);
                }
                if (hv.indexOf("Topics") < 0) {
                    String tp = this.getTopicNamePattern();
                    String tn = "Topics";
                    String ob = "(";
                    String cb = "";
                    if (!tp.equals(">")) {
                        tn = tn + ob + tp;
                        ob = " ";
                        cb = ")";
                    }
                    if (this.m_topicStoreFilter != null && this.m_topicStoreFilter.length() > 0) {
                        tn = tn + ob + this.m_topicStoreFilter;
                        cb = ")";
                    }
                    tn = tn + cb;
                    this.m_topicsNode = new GemsIconNode(tn, !Gems.getGems().getHideTreeDests());
                    this.m_topicsNode.setIconName("topics");
                    this.add(this.m_topicsNode);
                }
                if (hv.indexOf("Transactions") < 0) {
                    this.m_transactionsNode = new GemsIconNode("Transactions", false);
                    this.m_transactionsNode.setIconName("transactions");
                    this.add(this.m_transactionsNode);
                }
                boolean ftl_enabled = false;
                try {
                    if (this.m_serverInfo.getFTLParams() != null) {
                        ftl_enabled = true;
                    }
                }
                catch (Throwable tn) {
                    // empty catch block
                }
                if (hv.indexOf("Transports") < 0 && this.m_serverInfo != null && (this.m_serverInfo.isTibssTransportsEnabled() || this.m_serverInfo.isTibrvTransportsEnabled() || ftl_enabled)) {
                    this.m_transportsNode = new GemsIconNode("Transports", false);
                    this.m_transportsNode.setIconName("transports");
                    this.add(this.m_transportsNode);
                }
                if (hv.indexOf("Users") < 0) {
                    this.m_usersNode = new GemsIconNode("Users", false);
                    this.m_usersNode.setIconName("users");
                    this.add(this.m_usersNode);
                }
                Enumeration<?> e = this.m_SSSystems.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (this.m_ssNodes == null) {
                        this.m_ssNodes = new Vector();
                    }
                    Properties m_SSInterfaces = (Properties)this.m_SSSystems.get(key);
                    GemsSSNode ssNode = new GemsSSNode(key, m_SSInterfaces.getProperty("QUEUE"), m_SSInterfaces.getProperty("VERSION"), this);
                    this.add(ssNode);
                    this.m_ssTriggerNode = new DefaultMutableTreeNode("Counters", false);
                    ssNode.add(this.m_ssTriggerNode);
                    this.m_ssTriggerNode = new DefaultMutableTreeNode("Interfaces", false);
                    ssNode.add(this.m_ssTriggerNode);
                    this.m_ssTriggerNode = new DefaultMutableTreeNode("Transports", false);
                    ssNode.add(this.m_ssTriggerNode);
                    GemsSSNode WorkNode = ssNode;
                    Enumeration<?> eI = m_SSInterfaces.propertyNames();
                    while (eI.hasMoreElements()) {
                        String keyI = (String)eI.nextElement();
                        if (keyI == "QUEUE" || keyI == "VERSION") continue;
                        if (m_SSInterfaces.getProperty(keyI) == "INT") {
                            this.m_ssInterfaceNode = new DefaultMutableTreeNode("Int: " + keyI, true);
                            ssNode.add(this.m_ssInterfaceNode);
                            this.m_ssRecipeNode = new DefaultMutableTreeNode("Active Recipes", false);
                            this.m_ssInterfaceNode.add(this.m_ssRecipeNode);
                            this.m_ssRecipeNode = new DefaultMutableTreeNode("Active Triggers", false);
                            this.m_ssInterfaceNode.add(this.m_ssRecipeNode);
                            this.m_ssTriggerNode = new DefaultMutableTreeNode("Disabled", false);
                            this.m_ssInterfaceNode.add(this.m_ssTriggerNode);
                            if (WorkNode.m_ver.equals("2.8")) {
                                this.m_ssRecipeNode = new DefaultMutableTreeNode("Suspended", false);
                                this.m_ssInterfaceNode.add(this.m_ssRecipeNode);
                            }
                            this.m_ssTriggerNode = new DefaultMutableTreeNode("Listeners", false);
                            this.m_ssInterfaceNode.add(this.m_ssTriggerNode);
                        }
                        if (m_SSInterfaces.getProperty(keyI) == "IMS") {
                            this.m_ssInterfaceNode = new DefaultMutableTreeNode("IMS: " + keyI, true);
                            ssNode.add(this.m_ssInterfaceNode);
                            this.m_ssRecipeNode = new DefaultMutableTreeNode("IMS Statistics", false);
                            this.m_ssInterfaceNode.add(this.m_ssRecipeNode);
                            this.m_ssRecipeNode = new DefaultMutableTreeNode("IMS Buffers", false);
                            this.m_ssInterfaceNode.add(this.m_ssRecipeNode);
                        }
                        if (m_SSInterfaces.getProperty(keyI) != "CICS") continue;
                        this.m_ssInterfaceNode = new DefaultMutableTreeNode("CICS: " + keyI, true);
                        ssNode.add(this.m_ssInterfaceNode);
                        this.m_ssRecipeNode = new DefaultMutableTreeNode("SXTH", false);
                        this.m_ssInterfaceNode.add(this.m_ssRecipeNode);
                        this.m_ssRecipeNode = new DefaultMutableTreeNode("Transactions", false);
                        this.m_ssInterfaceNode.add(this.m_ssRecipeNode);
                    }
                    this.m_ssNodes.add(ssNode);
                }
                if (this.m_topicsNode != null) {
                    if (this.m_serverInfo != null && this.m_serverInfo.getTopicCount() > Gems.getGems().getMaxTopics() && this.getTopicNamePattern().length() <= 1) {
                        System.err.println("WARNING: Over " + Gems.getGems().getMaxTopics() + " topics, main topics display disabled. Increase MaxTopics or configure a TopicNamePattern for this connection.");
                    } else if (!Gems.getGems().getHideTreeDests()) {
                        TopicInfo[] tops = this.getTopics(this.getTopicNamePattern(), Gems.getGems().getPermType());
                        for (int t = 0; tops != null && t < tops.length; ++t) {
                            if (!this.showTopic(tops[t])) continue;
                            this.m_topicsNode.add(new GemsTopicNode(tops[t].getName()));
                        }
                    }
                }
                if (this.m_queuesNode != null) {
                    if (this.m_serverInfo != null && this.m_serverInfo.getQueueCount() > Gems.getGems().getMaxQueues() && this.getQueueNamePattern().length() <= 1) {
                        System.err.println("WARNING: Over " + Gems.getGems().getMaxQueues() + " queues, main queues display disabled. Increase MaxQueues or configure a QueueNamePattern for this connection.");
                    } else if (!Gems.getGems().getHideTreeDests()) {
                        QueueInfo[] ques = this.getQueues(this.getQueueNamePattern(), Gems.getGems().getPermType());
                        for (int q = 0; ques != null && q < ques.length; ++q) {
                            if (!this.showQueue(ques[q])) continue;
                            try {
                                boolean isr = ques[q].isRouted();
                                this.m_queuesNode.add(new GemsQueueNode(ques[q].getName(), isr));
                                continue;
                            }
                            catch (Throwable t) {
                                this.m_queuesNode.add(new GemsQueueNode(ques[q].getName()));
                            }
                        }
                    }
                }
            }
            if (this.m_serverInfo != null && this.m_serverInfo.getState() == 4) {
                if (this.m_eventMonitor != null) {
                    this.m_eventMonitor.systemStart();
                }
                if (this.m_services != null) {
                    this.m_services.systemStart();
                }
                this.initConnectLimits();
            }
            boolean is8_1 = false;
            try {
                if (this.m_stateInfo != null && this.m_stateInfo.isAppliance()) {
                    if (this.m_applPoller != null) {
                        System.err.println("WARNING: " + this.m_stateInfo.getServerName() + "; EMS Appliance version " + this.m_serverMajorVer + "." + this.m_serverMinorVer + ", SSH poller not required, disabling.");
                    }
                    this.m_applPoller = null;
                    this.updateApplianceState();
                    is8_1 = true;
                    this.setIconName("hardDrive");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.m_applPoller != null) {
                if (this.m_serverInfo == null) {
                    System.err.println("WARNING: EMS Appliance in standby mode, SSH poller not possible, disabling.");
                    this.m_applPoller = null;
                } else if (!this.m_applPoller.isAlive()) {
                    if (this.m_serverInfo != null && this.m_serverMajorVer >= 2 && this.m_serverMinorVer >= 1) {
                        System.err.println("WARNING: " + this.m_serverInfo.getServerName() + "; server version " + this.m_serverMajorVer + "." + this.m_serverMinorVer + " please upgrade EMS client lib to 8.1 (or greater), and remove the ApplianceMonitor in servers.xml");
                    }
                    this.m_applPoller.start();
                }
            }
        }
    }

    public boolean showQueue(QueueInfo q) {
        try {
            if (this.m_queueStoreFilter != null && this.m_queueStoreFilter.length() > 0 && !this.m_queueStoreFilter.equals(q.getStore())) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public boolean showTopic(TopicInfo t) {
        if (t.getName().startsWith("$sys")) {
            return false;
        }
        try {
            if (this.m_topicStoreFilter != null && this.m_topicStoreFilter.length() > 0 && !this.m_topicStoreFilter.equals(t.getStore())) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public boolean isServerFt() {
        return this.m_serverInfo != null && this.m_serverInfo.getFaultTolerantURL() != null && this.m_serverMajorVer > Gems.getGems().m_supportedApplianceVersion;
    }

    public boolean isFtUrl() {
        return this.m_url != null && this.m_url.indexOf(44) > 0;
    }

    public synchronized boolean isStandbyMode() {
        if (this.m_stateInfo != null && (this.m_stateInfo.getState().get() & 3) != 0) {
            return true;
        }
        if (this.m_serverInfo != null && this.m_serverInfo.getState() == 3) {
            return true;
        }
        return this.m_connId < 0L;
    }

    public ServerInfo getJmsServerInfo(boolean update) {
        if (!update) {
            return this.m_serverInfo;
        }
        return this.getJmsServerInfoSync(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInfo getJmsServerInfoSync(boolean userReq) {
        Object object = this.lock1;
        synchronized (object) {
            if (this.m_adminConn != null) {
                try {
                    long start = System.nanoTime();
                    this.m_serverInfo = this.m_adminConn.getInfo();
                    long end = System.nanoTime();
                    this.m_respTime = (end - start) / 1000000L;
                    this.updateState(false);
                    if (!userReq && this.m_chartUpdateTimer != null) {
                        this.m_chartUpdateTimer.start();
                    }
                    this.updateErrorWarningFlags();
                    if (!userReq) {
                        this.doLogging();
                    }
                }
                catch (TibjmsAdminSecurityException se) {
                    this.updateState(true);
                    this.m_serverInfo = null;
                    return null;
                }
                catch (TibjmsAdminException e) {
                    System.err.println("JMSException: " + e.toString());
                    System.err.println("Disconnecting from " + this.m_url);
                    if (e.toString().contains("Timeout")) {
                        this.disconnect(true);
                    } else {
                        this.disconnect(false);
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception: " + e.toString());
                    System.err.println("Disconnecting from " + this.m_url);
                    this.disconnect(false);
                }
            }
            return this.m_serverInfo;
        }
    }

    public ServerInfo getJmsServerInfoUserReq(boolean update) {
        if (!update) {
            return this.m_serverInfo;
        }
        return this.getJmsServerInfoSync(true);
    }

    public TibjmsAdmin getJmsAdmin() {
        return this.m_adminConn;
    }

    public boolean isConnected() {
        return this.m_adminConn != null;
    }

    public boolean isClientTraceEnabled() {
        if (this.m_adminConn != null) {
            try {
                if (this.m_serverInfo != null) {
                    return this.m_serverInfo.isClientTraceEnabled();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isRestartRequired() {
        if (this.m_adminConn != null) {
            try {
                return this.m_adminConn.isRestartRequired();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public DefaultMutableTreeNode createQueue(String qn, boolean nodeOnly) {
        if (this.m_adminConn == null) {
            return null;
        }
        try {
            if (!nodeOnly) {
                QueueInfo q = new QueueInfo(qn);
                this.m_adminConn.createQueue(q);
            }
            GemsQueueNode qnode = null;
            GemsQueueNode myqnode = null;
            int ri = qn.indexOf(64);
            if (ri > 0) {
                qn = qn.substring(0, ri);
            }
            if (this.m_queuesNode == null) {
                return null;
            }
            if (Gems.getGems().getHideTreeDests()) {
                Gems.getGems().scheduleRepaint();
                return null;
            }
            if (this.m_serverInfo.getQueueCount() <= Gems.getGems().getMaxQueues() || this.getQueueNamePattern().length() > 1) {
                this.m_queuesNode.removeAllChildren();
                QueueInfo[] ques = this.getQueues(this.getQueueNamePattern(), Gems.getGems().getPermType());
                for (int i = 0; ques != null && i < ques.length; ++i) {
                    if (!this.showQueue(ques[i])) continue;
                    try {
                        boolean isr = ques[i].isRouted();
                        qnode = new GemsQueueNode(ques[i].getName(), isr);
                    }
                    catch (Throwable t) {
                        qnode = new GemsQueueNode(ques[i].getName());
                    }
                    if (qn.equals(ques[i].getName())) {
                        myqnode = qnode;
                    }
                    this.m_queuesNode.add(qnode);
                }
            } else {
                boolean isr = qn.indexOf(64) > 0;
                myqnode = new GemsQueueNode(qn, isr);
                this.m_queuesNode.add(myqnode);
            }
            return myqnode;
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return null;
        }
    }

    public DefaultMutableTreeNode removeQueue(String qn) {
        if (this.m_adminConn == null) {
            return null;
        }
        try {
            if (this.m_queuesNode == null) {
                return null;
            }
            this.m_adminConn.destroyQueue(qn);
            Enumeration<TreeNode> ch = this.m_queuesNode.children();
            while (ch.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)ch.nextElement();
                if (n == null || !qn.equals((String)n.getUserObject())) continue;
                n.removeFromParent();
                return this.m_queuesNode;
            }
            return this.m_queuesNode;
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return null;
        }
    }

    public void purgeQueue(String qn) {
        if (this.m_adminConn == null) {
            return;
        }
        try {
            this.m_adminConn.purgeQueue(qn);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void purgeTopic(String qn) {
        if (this.m_adminConn == null) {
            return;
        }
        try {
            this.m_adminConn.purgeTopic(qn);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void createUser(String name, String passwd, String desc) {
        if (this.m_adminConn == null) {
            return;
        }
        try {
            com.tibco.tibjms.admin.UserInfo u = new com.tibco.tibjms.admin.UserInfo(name, desc);
            u.setPassword(passwd);
            this.m_adminConn.createUser(u);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void updateUser(String name, String passwd, String desc) {
        if (this.m_adminConn == null) {
            return;
        }
        try {
            com.tibco.tibjms.admin.UserInfo u = new com.tibco.tibjms.admin.UserInfo(name, desc);
            u.setPassword(passwd);
            this.m_adminConn.updateUser(u);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void destroyUser(String name) {
        if (this.m_adminConn == null) {
            return;
        }
        try {
            this.m_adminConn.destroyUser(name);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void createGroup(String name, String desc) {
        if (this.m_adminConn == null) {
            return;
        }
        try {
            GroupInfo g = new GroupInfo(name, desc);
            this.m_adminConn.createGroup(g);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void addUserToGroup(String name, String group) {
        if (this.m_adminConn == null) {
            return;
        }
        try {
            this.m_adminConn.addUserToGroup(group, name);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void removeUserFromGroup(String name, String group) {
        if (this.m_adminConn == null) {
            return;
        }
        try {
            this.m_adminConn.removeUserFromGroup(group, name);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void createDurable(String name, String topic, String client, String sel) {
        if (this.m_adminConn == null) {
            return;
        }
        if (client != null && client.length() == 0) {
            client = null;
        }
        if (sel != null && sel.length() == 0) {
            sel = null;
        }
        try {
            this.m_adminConn.createDurable(topic, name, client, sel, false, false);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void destroyDurable(String name, String client) {
        if (this.m_adminConn == null) {
            return;
        }
        if (client != null && client.length() == 0) {
            client = null;
        }
        try {
            this.m_adminConn.destroyDurable(name, client);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void purgeDurable(String name, String client) {
        if (this.m_adminConn == null) {
            return;
        }
        if (client != null && client.length() == 0) {
            client = null;
        }
        try {
            this.m_adminConn.purgeDurable(name, client);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void destroyConnection(String id) {
        long lid;
        if (this.m_adminConn == null) {
            return;
        }
        try {
            lid = Long.parseLong(id);
        }
        catch (Exception ie) {
            System.err.println("Exception: " + ie.getMessage());
            return;
        }
        try {
            this.m_adminConn.destroyConnection(lid);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public DefaultMutableTreeNode createTopic(String qn, boolean nodeOnly) {
        if (this.m_adminConn == null) {
            return null;
        }
        try {
            if (!nodeOnly) {
                TopicInfo q = new TopicInfo(qn);
                this.m_adminConn.createTopic(q);
            }
            GemsTopicNode qnode = null;
            GemsTopicNode myqnode = null;
            if (this.m_topicsNode == null) {
                return null;
            }
            if (Gems.getGems().getHideTreeDests()) {
                Gems.getGems().scheduleRepaint();
                return null;
            }
            if (this.m_serverInfo.getTopicCount() <= Gems.getGems().getMaxTopics() || this.getTopicNamePattern().length() > 1) {
                this.m_topicsNode.removeAllChildren();
                TopicInfo[] ques = this.getTopics(this.getTopicNamePattern(), Gems.getGems().getPermType());
                for (int i = 0; ques != null && i < ques.length; ++i) {
                    if (!this.showTopic(ques[i])) continue;
                    qnode = new GemsTopicNode(ques[i].getName());
                    if (qn.equals(ques[i].getName())) {
                        myqnode = qnode;
                    }
                    this.m_topicsNode.add(qnode);
                }
            } else {
                myqnode = new GemsTopicNode(qn);
                this.m_topicsNode.add(myqnode);
            }
            return myqnode;
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return null;
        }
    }

    public DefaultMutableTreeNode removeTopic(String qn) {
        if (this.m_adminConn == null) {
            return null;
        }
        try {
            if (this.m_topicsNode == null) {
                return null;
            }
            this.m_adminConn.destroyTopic(qn);
            Enumeration<TreeNode> ch = this.m_topicsNode.children();
            while (ch.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)ch.nextElement();
                if (n == null || !qn.equals((String)n.getUserObject())) continue;
                n.removeFromParent();
                return this.m_topicsNode;
            }
            return this.m_topicsNode;
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return null;
        }
    }

    public String[] getStoreNames() {
        if (this.m_storeNames == null && this.m_adminConn != null) {
            try {
                String[] sn = this.m_adminConn.getStores();
                this.m_storeNames = new String[sn.length - 1];
                int j = 0;
                for (int i = 0; i < sn.length && j < this.m_storeNames.length; ++i) {
                    if (sn[i].equals("$sys.meta")) continue;
                    this.m_storeNames[j++] = sn[i];
                }
                Arrays.sort(this.m_storeNames);
            }
            catch (TibjmsAdminException e) {
                System.err.println("JMSException: " + e.getMessage());
                return null;
            }
        }
        return this.m_storeNames;
    }

    public TopicInfo[] getTopics(String pattern, int permType) {
        return this.getTopics(pattern, permType, false, this.m_topicStoreFilter);
    }

    public TopicInfo[] getTopics(String pattern, int permType, boolean doSort, boolean doFilter) {
        return this.getTopics(pattern, permType, doSort, doFilter ? this.m_topicStoreFilter : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicInfo[] getTopics(String pattern, int permType, boolean doSort, String storeFilter) {
        if (this.m_disableCursors) {
            return this.getTopicsNoCursor(pattern, permType);
        }
        Object object = this.lock1;
        synchronized (object) {
            TopicInfo[] ti;
            block14: {
                if (this.m_adminConn == null) {
                    return null;
                }
                ti = null;
                TopicInfo[] ti1 = null;
                int curSize = Gems.getGems().getDestCursorSize();
                try {
                    ti1 = this.m_adminConn.getTopics(pattern, permType, 1, curSize);
                    while (ti1 != null) {
                        Thread.yield();
                        if (storeFilter != null) {
                            ti1 = this.filterTopics(ti1, storeFilter);
                        }
                        ti = GemsUtilities.concatArrays(ti, ti1);
                        ti1 = this.m_adminConn.getTopics(pattern, permType, 2, curSize);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof TibjmsAdminException) {
                        if (ti == null && e.getMessage().endsWith("server does not support that command.")) {
                            System.err.println("getTopics: Exception: " + e.getMessage() + " disabling use of cursors for " + this.m_url);
                            this.m_disableCursors = true;
                            return this.getTopicsNoCursor(pattern, permType);
                        }
                        if (ti != null && e.getMessage().endsWith("No active cursor")) break block14;
                        System.err.println("getTopics: Exception: " + e.getMessage());
                        try {
                            this.m_adminConn.getTopics(pattern, permType, 3, 1);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return null;
                    }
                    ti = this.getTopicsNoCursor(pattern, permType);
                    doSort = false;
                }
            }
            if (doSort && ti != null) {
                Arrays.sort(ti, this.destComparator);
            }
            return ti;
        }
    }

    public TopicInfo[] filterTopics(TopicInfo[] qa, String storeFilter) {
        if (storeFilter == null || storeFilter.length() == 0) {
            return qa;
        }
        try {
            int n = 0;
            for (TopicInfo q : qa) {
                if (!storeFilter.equals(q.getStore())) continue;
                ++n;
            }
            TopicInfo[] qa1 = new TopicInfo[n];
            n = 0;
            for (TopicInfo q : qa) {
                if (!storeFilter.equals(q.getStore())) continue;
                qa1[n++] = q;
            }
            return qa1;
        }
        catch (Throwable e) {
            return qa;
        }
    }

    public TopicInfo[] getTopicsNoCursor(String pattern, int permType) {
        if (this.m_adminConn == null) {
            return null;
        }
        TopicInfo[] ti = null;
        try {
            ti = this.m_adminConn.getTopics(pattern, permType);
        }
        catch (Throwable e1) {
            try {
                ti = this.m_adminConn.getTopics(pattern);
            }
            catch (TibjmsAdminException e) {
                System.err.println("JMSException: " + e.getMessage());
                return null;
            }
        }
        return ti;
    }

    public QueueInfo[] getQueues(String pattern, int permType) {
        return this.getQueues(pattern, permType, false, this.m_queueStoreFilter);
    }

    public QueueInfo[] getQueues(String pattern, int permType, boolean doSort, boolean doFilter) {
        return this.getQueues(pattern, permType, doSort, doFilter ? this.m_queueStoreFilter : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueInfo[] getQueues(String pattern, int permType, boolean doSort, String storeFilter) {
        if (this.m_disableCursors) {
            return this.getQueuesNoCursor(pattern, permType);
        }
        Object object = this.lock1;
        synchronized (object) {
            QueueInfo[] ti;
            block14: {
                if (this.m_adminConn == null) {
                    return null;
                }
                ti = null;
                QueueInfo[] ti1 = null;
                int curSize = Gems.getGems().getDestCursorSize();
                try {
                    ti1 = this.m_adminConn.getQueues(pattern, permType, 1, curSize);
                    while (ti1 != null) {
                        Thread.yield();
                        if (storeFilter != null) {
                            ti1 = this.filterQueues(ti1, storeFilter);
                        }
                        ti = GemsUtilities.concatArrays(ti, ti1);
                        ti1 = this.m_adminConn.getQueues(pattern, permType, 2, curSize);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof TibjmsAdminException) {
                        if (ti == null && e.getMessage().endsWith("server does not support that command.")) {
                            System.err.println("getQueues: Exception: " + e.getMessage() + " disabling use of cursors for " + this.m_url);
                            this.m_disableCursors = true;
                            return this.getQueuesNoCursor(pattern, permType);
                        }
                        if (ti != null && e.getMessage().endsWith("No active cursor")) break block14;
                        System.err.println("getQueues: Exception: " + e.getMessage());
                        try {
                            this.m_adminConn.getQueues(pattern, permType, 3, 1);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return null;
                    }
                    ti = this.getQueuesNoCursor(pattern, permType);
                    doSort = false;
                }
            }
            if (doSort && ti != null) {
                Arrays.sort(ti, this.destComparator);
            }
            return ti;
        }
    }

    public QueueInfo[] getQueuesNoCursor(String pattern, int permType) {
        if (this.m_adminConn == null) {
            return null;
        }
        QueueInfo[] ti = null;
        try {
            ti = this.m_adminConn.getQueues(pattern, permType);
        }
        catch (Throwable e1) {
            try {
                ti = this.m_adminConn.getQueues(pattern);
            }
            catch (TibjmsAdminException e) {
                System.err.println("JMSException: " + e.getMessage());
                return null;
            }
        }
        return ti;
    }

    public QueueInfo[] filterQueues(QueueInfo[] qa, String storeFilter) {
        if (storeFilter == null || storeFilter.length() == 0) {
            return qa;
        }
        try {
            int n = 0;
            for (QueueInfo q : qa) {
                if (!storeFilter.equals(q.getStore())) continue;
                ++n;
            }
            QueueInfo[] qa1 = new QueueInfo[n];
            n = 0;
            for (QueueInfo q : qa) {
                if (!storeFilter.equals(q.getStore())) continue;
                qa1[n++] = q;
            }
            return qa1;
        }
        catch (Throwable e) {
            return qa;
        }
    }

    public void removeMessage(Message m) throws Exception {
        if (this.m_adminConn == null) {
            return;
        }
        this.m_adminConn.destroyMessage(m.getJMSMessageID());
    }

    public void initConnectLimits() {
        long warnMsgMem = 500000000L;
        long errorMsgMem = 1000000000L;
        if (this.isConnected() && this.m_serverInfo != null) {
            warnMsgMem = this.m_serverInfo.getMaxMsgMemory() / 2L;
            errorMsgMem = this.m_serverInfo.getMaxMsgMemory() * 3L / 4L;
        }
        if (this.m_warnLimits.get("MsgMem") == null) {
            this.m_warnLimits.put("MsgMem", new Long(warnMsgMem));
        }
        if (this.m_errorLimits.get("MsgMem") == null) {
            this.m_errorLimits.put("MsgMem", new Long(errorMsgMem));
        }
    }

    public void initLimits() {
        this.m_warnLimits.put("Connections", new Long(2000L));
        this.m_warnLimits.put("Sessions", new Long(20000L));
        this.m_warnLimits.put("Queues", new Long(2000L));
        this.m_warnLimits.put("Topics", new Long(2000L));
        this.m_warnLimits.put("Durables", new Long(2000L));
        this.m_warnLimits.put("PendingMsgs", new Long(1000000L));
        this.m_warnLimits.put("PendingMsgSize", new Long(500000000L));
        this.m_warnLimits.put("InMsgRate", new Long(5000L));
        this.m_warnLimits.put("DiskReadRate", new Long(1000000L));
        this.m_warnLimits.put("AsyncDBSize", new Long(1000000000L));
        this.m_warnLimits.put("SyncDBSize", new Long(1000000000L));
        this.m_warnLimits.put("RespTime", new Long(500L));
        this.m_errorLimits.put("Connections", new Long(5000L));
        this.m_errorLimits.put("Sessions", new Long(50000L));
        this.m_errorLimits.put("Queues", new Long(5000L));
        this.m_errorLimits.put("Topics", new Long(5000L));
        this.m_errorLimits.put("Durables", new Long(5000L));
        this.m_errorLimits.put("PendingMsgs", new Long(5000000L));
        this.m_errorLimits.put("PendingMsgSize", new Long(1000000000L));
        this.m_errorLimits.put("InMsgRate", new Long(10000L));
        this.m_errorLimits.put("DiskReadRate", new Long(10000000L));
        this.m_errorLimits.put("AsyncDBSize", new Long(4000000000L));
        this.m_errorLimits.put("SyncDBSize", new Long(4000000000L));
        this.m_errorLimits.put("RespTime", new Long(1000L));
    }

    public void addWarnLimits(Node xe) {
        NamedNodeMap m = xe.getAttributes();
        for (int i = 0; i < m.getLength(); ++i) {
            Node a = m.item(i);
            this.m_warnLimits.put(a.getNodeName(), new Long(a.getNodeValue()));
        }
    }

    public Long getWarnLimit(String l) {
        if (this.m_warnLimits != null) {
            return (Long)this.m_warnLimits.get(l);
        }
        return null;
    }

    public void addErrorLimits(Node xe) {
        NamedNodeMap m = xe.getAttributes();
        for (int i = 0; i < m.getLength(); ++i) {
            Node a = m.item(i);
            this.m_errorLimits.put(a.getNodeName(), new Long(a.getNodeValue()));
        }
    }

    public Long getErrorLimit(String l) {
        if (this.m_errorLimits != null) {
            return (Long)this.m_errorLimits.get(l);
        }
        return null;
    }

    public Hashtable getWarnLimits() {
        return this.m_warnLimits;
    }

    public Hashtable getErrorLimits() {
        return this.m_errorLimits;
    }

    public void updateErrorWarningFlags() {
        this.m_isInError = false;
        this.m_isInWarning = false;
        Long l = this.getErrorLimit("Connections");
        if (l != null && (long)this.m_serverInfo.getConnectionCount() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("Sessions");
        try {
            if (l != null && (long)this.m_serverInfo.getSessionCount() > l) {
                this.m_isInError = true;
                Gems.getGems().treeRepaint();
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        l = this.getErrorLimit("Queues");
        if (l != null && (long)this.m_serverInfo.getQueueCount() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("Topics");
        if (l != null && (long)this.m_serverInfo.getTopicCount() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("Durables");
        if (l != null && (long)this.m_serverInfo.getDurableCount() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("PendingMsgs");
        if (l != null && this.m_serverInfo.getPendingMessageCount() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("PendingMsgSize");
        if (l != null && this.m_serverInfo.getPendingMessageSize() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("MsgMem");
        if (l != null && this.m_serverInfo.getMsgMem() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("InMsgCount");
        if (l != null && this.m_serverInfo.getInboundMessageCount() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("InMsgRate");
        if (l != null && this.m_serverInfo.getInboundMessageRate() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("OutMsgCount");
        if (l != null && this.m_serverInfo.getOutboundMessageCount() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("OutMsgRate");
        if (l != null && this.m_serverInfo.getOutboundMessageRate() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("DiskReadRate");
        if (l != null && this.m_serverInfo.getDiskReadRate() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("DiskWriteRate");
        if (l != null && this.m_serverInfo.getDiskWriteRate() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("AsyncDBSize");
        if (l != null && this.m_serverInfo.getAsyncDBSize() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("SyncDBSize");
        if (l != null && this.m_serverInfo.getSyncDBSize() > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getErrorLimit("RespTime");
        if (l != null && this.m_respTime > l) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        if (this.isAppliance() && this.m_instanceState != null && this.m_instanceState.equals("ERROR")) {
            this.m_isInError = true;
            Gems.getGems().treeRepaint();
            return;
        }
        if (this.isRestartRequired()) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        if (this.isClientTraceEnabled()) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        if (!this.isAppliance() && this.isServerFt() && this.m_serverInfo.getState() == 4 && this.m_serverInfo.getBackupName() == null) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("Connections");
        if (l != null && (long)this.m_serverInfo.getConnectionCount() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("Sessions");
        try {
            if (l != null && (long)this.m_serverInfo.getSessionCount() > l) {
                this.m_isInWarning = true;
                Gems.getGems().treeRepaint();
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        l = this.getWarnLimit("Queues");
        if (l != null && (long)this.m_serverInfo.getQueueCount() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("Topics");
        if (l != null && (long)this.m_serverInfo.getTopicCount() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("Durables");
        if (l != null && (long)this.m_serverInfo.getDurableCount() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("PendingMsgs");
        if (l != null && this.m_serverInfo.getPendingMessageCount() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("PendingMsgSize");
        if (l != null && this.m_serverInfo.getPendingMessageSize() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("MsgMem");
        if (l != null && this.m_serverInfo.getMsgMem() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("InMsgCount");
        if (l != null && this.m_serverInfo.getInboundMessageCount() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("InMsgRate");
        if (l != null && this.m_serverInfo.getInboundMessageRate() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("OutMsgCount");
        if (l != null && this.m_serverInfo.getOutboundMessageCount() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("OutMsgRate");
        if (l != null && this.m_serverInfo.getOutboundMessageRate() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("DiskReadRate");
        if (l != null && this.m_serverInfo.getDiskReadRate() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("DiskWriteRate");
        if (l != null && this.m_serverInfo.getDiskWriteRate() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("AsyncDBSize");
        if (l != null && this.m_serverInfo.getAsyncDBSize() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("SyncDBSize");
        if (l != null && this.m_serverInfo.getSyncDBSize() > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        l = this.getWarnLimit("RespTime");
        if (l != null && this.m_respTime > l) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        if (this.isAppliance() && this.m_instanceState != null && this.m_instanceState.length() > 0 && !this.m_instanceState.equals("FULLY_OPERATIONAL") && !this.m_instanceState.equals("REPLICATING")) {
            this.m_isInWarning = true;
            Gems.getGems().treeRepaint();
            return;
        }
        Gems.getGems().treeRepaint();
    }

    public String getClientID(long id) {
        String cid;
        if (id == 0L) {
            return "";
        }
        if (this.m_adminConn == null) {
            return "";
        }
        if (this.m_clientIDs == null) {
            this.m_clientIDs = new Hashtable();
        }
        if ((cid = (String)this.m_clientIDs.get(String.valueOf(id))) == null) {
            this.m_clientIDs.clear();
            try {
                ConnectionInfo[] c = this.m_adminConn.getConnections();
                for (int i = 0; c != null && i < c.length; ++i) {
                    if (c[i].getClientID() == null) continue;
                    this.m_clientIDs.put(String.valueOf(c[i].getID()), c[i].getClientID());
                }
            }
            catch (TibjmsAdminException e) {
                System.err.println("JMSException: " + e.getMessage());
                return "";
            }
            cid = (String)this.m_clientIDs.get(String.valueOf(id));
        }
        if (cid != null) {
            return cid;
        }
        return "";
    }

    @Override
    public void run() {
        while (this.m_delay > 0L) {
            try {
                Thread.sleep(this.m_delay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.isConnected()) {
                this.connect();
                if (!this.isConnected()) continue;
                Gems.getGems().scheduleRepaint();
                continue;
            }
            this.getJmsServerInfo(true);
            if (this.m_sub != null) {
                this.m_sub.onData(this.m_serverInfo, this.m_respTime);
            }
            if (this.isConnected()) continue;
            Gems.getGems().scheduleRepaint();
        }
    }

    public void startCharting() {
        try {
            if (this.m_serverInfo == null) {
                return;
            }
            if (this.m_sub == null) {
                Vector v = GemsUtilities.getStatsMethodNames(this.m_serverInfo.getClass());
                v.add("responseTime");
                this.m_sub = new GemsSubscriber(v, "hello");
                this.m_chart = new GemsChartFrame(Gems.getGems().getTitlePrefix() + "Real Time Chart for " + this.getName() + " (" + this.m_url + ")", v, this.m_sub, this, null);
                this.m_sub.addChart(this.m_chart);
                this.m_chartUpdateTimer = new Timer(0, new ChartRefreshTimerAction());
                this.m_chartUpdateTimer.setRepeats(false);
            } else {
                this.m_chart.bringToFront();
            }
        }
        catch (Throwable ex) {
            JOptionPane.showMessageDialog(null, "<html>Failed to load chart " + ex.toString() + "<p>Please download JFreeChart libs jcommon-1.0.23.jar and jfreechart-1.0.19.jar from <p><a href=\"http://www.jfree.org/jfreechart\">http://www.jfree.org/jfreechart</a>", "Error", 0);
            this.m_sub = null;
            this.m_chart = null;
        }
    }

    public void stopCharting() {
        this.m_sub = null;
        this.m_chart = null;
    }

    public void addSSLParam(Node xe) {
        Node v;
        Node n;
        NamedNodeMap m = xe.getAttributes();
        Node t = m.getNamedItem("type");
        if (t == null) {
            t = m.getNamedItem("Type");
        }
        if ((n = m.getNamedItem("name")) == null) {
            n = m.getNamedItem("Name");
        }
        if ((v = m.getNamedItem("value")) == null) {
            v = m.getNamedItem("Value");
        }
        if (t == null || n == null || v == null) {
            return;
        }
        Gems.debug("SSLParam: " + n.getNodeValue() + "=" + v.getNodeValue());
        if (t.getNodeValue().equalsIgnoreCase("string")) {
            this.m_sslParams.put(n.getNodeValue(), v.getNodeValue());
        } else if (t.getNodeValue().equalsIgnoreCase("boolean")) {
            this.m_sslParams.put(n.getNodeValue(), new Boolean(v.getNodeValue()));
        } else if (t.getNodeValue().equalsIgnoreCase("long")) {
            this.m_sslParams.put(n.getNodeValue(), new Long(v.getNodeValue()));
        } else if (t.getNodeValue().equalsIgnoreCase("integer") || t.getNodeValue().equalsIgnoreCase("int")) {
            this.m_sslParams.put(n.getNodeValue(), new Integer(v.getNodeValue()));
        }
    }

    public void addSubStation(Node xe) {
        Node n;
        NamedNodeMap m = xe.getAttributes();
        Node t = m.getNamedItem("alias");
        if (t == null) {
            t = m.getNamedItem("Alias");
        }
        if ((n = m.getNamedItem("adminqueue")) == null) {
            n = m.getNamedItem("Queue");
        }
        if (t == null || n == null) {
            return;
        }
        Properties m_SSInterfaces = new Properties();
        m_SSInterfaces.put("QUEUE", n.getNodeValue());
        Node ver = m.getNamedItem("version");
        if (ver == null) {
            ver = m.getNamedItem("Version");
        }
        if (ver == null) {
            m_SSInterfaces.put("VERSION", "2.4");
        } else {
            m_SSInterfaces.put("VERSION", ver.getNodeValue().substring(0, 3));
        }
        NodeList xn1s = xe.getChildNodes();
        for (int k = 0; xn1s != null && k < xn1s.getLength(); ++k) {
            Node nT;
            Node xn2 = xn1s.item(k);
            if (!xn2.getNodeName().equals("Interface")) continue;
            NamedNodeMap mI = xn2.getAttributes();
            Node nI = mI.getNamedItem("name");
            if (nI == null) {
                nI = mI.getNamedItem("Name");
            }
            if ((nT = mI.getNamedItem("type")) == null) {
                nT = mI.getNamedItem("Type");
            }
            if (nT == null) {
                m_SSInterfaces.put(nI.getNodeValue(), "INT");
                continue;
            }
            if (nT.getNodeValue().equals("IMS")) {
                m_SSInterfaces.put(nI.getNodeValue(), "IMS");
                continue;
            }
            if (nT.getNodeValue().equals("CICS")) {
                m_SSInterfaces.put(nI.getNodeValue(), "CICS");
                continue;
            }
            m_SSInterfaces.put(nI.getNodeValue(), "INT");
        }
        this.m_SSSystems.put(t.getNodeValue(), m_SSInterfaces);
    }

    public void doLogging() {
        if (this.m_adminConn != null && this.m_logServerInfo != LOG_TYPE.Never && (this.m_logServerInfo == LOG_TYPE.Always || this.m_isInWarning && this.m_logServerInfo == LOG_TYPE.WarnLimits || this.m_isInError && (this.m_logServerInfo == LOG_TYPE.ErrorLimits || this.m_logServerInfo == LOG_TYPE.WarnLimits))) {
            Date d = new Date();
            try {
                String fd = this.m_fileDateFormat.format(d).toString() + ".csv";
                if (this.m_logFile == null || !this.m_logFile.getName().endsWith(fd)) {
                    if (this.m_filePrint != null) {
                        this.m_filePrint.close();
                    }
                    if (this.m_fileOut != null) {
                        this.m_fileOut.close();
                    }
                    File f = new File(this.m_logDir);
                    f.mkdirs();
                    this.m_logFile = new File(f, GemsUtilities.stripSpaces(this.getName()) + "-" + fd);
                    boolean exists = this.m_logFile.exists();
                    this.m_fileOut = new FileOutputStream(this.m_logFile, true);
                    this.m_filePrint = new PrintStream(this.m_fileOut);
                    if (!exists || this.firstLog) {
                        StringBuffer b = new StringBuffer("timestamp");
                        b.append(this.m_csvDelim);
                        for (int j = 0; j < this.m_logColumnNames.size(); ++j) {
                            b.append(this.m_logColumnNames.get(j));
                            b.append(this.m_csvDelim);
                        }
                        b.append("RespTime");
                        this.m_filePrint.println(b.toString());
                    }
                }
            }
            catch (IOException ie) {
                System.err.println("ERROR: Failed to create ServerInfo logfile: JavaIOException: " + ie.getMessage());
                this.m_logServerInfo = LOG_TYPE.Never;
                this.m_logFile = null;
                this.m_fileOut = null;
                this.m_filePrint = null;
                return;
            }
            if (this.m_filePrint != null) {
                Hashtable h = GemsUtilities.getStatsMethodValues(this.m_serverInfo);
                StringBuffer b = new StringBuffer(this.dateFormatMillis.format(d).toString());
                b.append(this.m_csvDelim);
                for (int j = 0; j < this.m_logColumnNames.size(); ++j) {
                    b.append(h.get(this.m_logColumnNames.get(j)));
                    b.append(this.m_csvDelim);
                }
                b.append(this.m_respTime);
                this.m_filePrint.println(b.toString());
                this.firstLog = false;
            }
        }
    }

    public void cleanup() {
        if (this.m_applPoller != null) {
            this.m_applPoller.close();
            this.m_applPoller = null;
        }
    }

    public void setApplianceInfo(String mgmtIP, String inst, String admPass) {
        if (this.m_applPoller == null) {
            this.m_applPoller = new AppliancePollerThread(Gems.getGems().getAppliancePollPeriod(), mgmtIP, inst, admPass);
            this.setIconName("hardDrive");
        }
    }

    public long getLargeDestCount() {
        long c = 0L;
        try {
            if (this.m_serverInfo != null) {
                c = this.m_serverInfo.getLargeDestCount();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return c;
    }

    public long getLargeDestMemory() {
        long c = 0L;
        try {
            if (this.m_serverInfo != null) {
                c = this.m_serverInfo.getLargeDestMemory();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return c;
    }

    public boolean isAppliance() {
        if (this.m_applPoller != null) {
            return true;
        }
        try {
            if (this.m_serverInfo != null && this.m_serverInfo.isAppliance()) {
                return true;
            }
            if (this.m_stateInfo != null && this.m_stateInfo.isAppliance()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void updateState(boolean force) {
        try {
            this.m_stateInfo = force ? this.m_adminConn.getStateInfo() : null;
            this.updateApplianceState();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void updateApplianceState() {
        if (this.m_applPoller != null) {
            return;
        }
        try {
            if (this.m_serverInfo != null && this.m_serverInfo.isAppliance()) {
                int s = this.m_serverInfo.getStateObj().get();
                this.m_instanceState = (s & 0x20) != 0 ? (Gems.getGems().getShowApplFullyOp() ? "FULLY_OPERATIONAL" : "REPLICATING") : ((s & 0x40) != 0 ? "STANDALONE" : ((s & 0x10) != 0 ? (this.m_serverInfo.getOverallSyncProgress() >= 0 ? "SYNCHRONIZING(" + this.m_serverInfo.getOverallSyncProgress() + "%)" : "SYNCHRONIZING") : ((s & 0x30) != 0 ? "PAUSED" : ((s & 8) != 0 ? "WAIT_FOR_PEER" : ""))));
            } else if (this.m_stateInfo != null && this.m_stateInfo.isAppliance()) {
                int s = this.m_stateInfo.getState().get();
                this.m_instanceState = (s & 0x20) != 0 ? (Gems.getGems().getShowApplFullyOp() ? "FULLY_OPERATIONAL" : "REPLICATING") : ((s & 0x40) != 0 ? "STANDALONE" : ((s & 0x10) != 0 ? (this.m_stateInfo.getOverallSyncProgress() >= 0 ? "SYNCHRONIZING(" + this.m_stateInfo.getOverallSyncProgress() + "%)" : "SYNCHRONIZING") : ((s & 0x30) != 0 ? "PAUSED" : ((s & 8) != 0 ? "WAIT_FOR_PEER" : ""))));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getInstanceState() {
        return this.m_instanceState;
    }

    public HashMap getLDAPParams() {
        if (this.m_ldapParams == null) {
            this.initLDAPParams();
        }
        return this.m_ldapParams;
    }

    public void initLDAPParams() {
        LDAPParams ld;
        if (this.m_serverInfo != null && (ld = this.m_serverInfo.getLDAPParams()) != null) {
            this.m_ldapParams = new HashMap();
            this.m_ldapParams.put("ldapalgfilt", null);
            this.m_ldapParams.put("ldapalufilt", null);
            this.m_ldapParams.put("ldapcache", null);
            this.m_ldapParams.put("ldapcttl", null);
            this.m_ldapParams.put("ldapconntp", null);
            this.m_ldapParams.put("ldapdgnmatr", null);
            this.m_ldapParams.put("ldapdgclass", null);
            this.m_ldapParams.put("ldapdmuatr", null);
            this.m_ldapParams.put("ldapgbasedn", null);
            this.m_ldapParams.put("ldapgnmfilt", null);
            this.m_ldapParams.put("ldapgscope", null);
            this.m_ldapParams.put("ldapprinc", null);
            this.m_ldapParams.put("ldapsgnmatr", null);
            this.m_ldapParams.put("ldapsgclass", null);
            this.m_ldapParams.put("ldapsmematr", null);
            this.m_ldapParams.put("ldapsgmfilt", null);
            this.m_ldapParams.put("ldapcadir", null);
            this.m_ldapParams.put("ldapcafile", null);
            this.m_ldapParams.put("ldapcipher", null);
            this.m_ldapParams.put("ldapcert", null);
            this.m_ldapParams.put("ldapkey", null);
            this.m_ldapParams.put("ldaprand", null);
            this.m_ldapParams.put("ldapurl", null);
            this.m_ldapParams.put("ldapunmatr", null);
            this.m_ldapParams.put("ldapubasedn", null);
            this.m_ldapParams.put("ldapuclass", null);
            this.m_ldapParams.put("ldapunmfilt", null);
            this.m_ldapParams.put("ldapuscope", null);
        }
    }

    class SSHUserInfo
    implements UserInfo {
        private String password;

        SSHUserInfo(String password) {
            this.password = password;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassword(String arg0) {
            return true;
        }

        public boolean promptPassphrase(String arg0) {
            return false;
        }

        public boolean promptYesNo(String arg0) {
            return true;
        }

        public void showMessage(String arg0) {
        }
    }

    class AppliancePollerThread
    extends Thread {
        long delay;
        String endLineStr = " > ";
        String host = null;
        String user = "tibadm";
        String password = null;
        String instanceId = null;
        int port = 22;
        boolean first = true;
        int timeout = Gems.getGems().getApplianceSshTimeout() * 1000;

        AppliancePollerThread(long delay, String host, String inst, String password) {
            this.delay = delay * 1000L;
            this.password = password;
            this.instanceId = inst;
            this.host = host;
        }

        public void close() {
            this.delay = 0L;
        }

        @Override
        public void run() {
            while (this.delay > 0L) {
                String instanceState = "ERROR";
                try {
                    boolean gotInstance = false;
                    if (this.first) {
                        AppliancePollerThread.sleep(2000L);
                    } else {
                        AppliancePollerThread.sleep(this.delay);
                    }
                    if (this.delay == 0L) {
                        return;
                    }
                    if (GemsConnectionNode.this.m_adminConn == null) continue;
                    if (this.first) {
                        System.err.println("AppliancePollerThread: Starting poller thread to " + this.getHost() + " instance " + this.getInstanceId());
                    } else {
                        Gems.debug("AppliancePollerThread: Polling " + this.getHost() + " instance " + this.getInstanceId());
                    }
                    GemsConnectionNode.this.m_instanceState = null;
                    JSch shell = new JSch();
                    Session session = shell.getSession(this.user, this.host, this.port);
                    session.setUserInfo((UserInfo)new SSHUserInfo(this.password));
                    session.connect(this.timeout);
                    Channel channel = session.openChannel("shell");
                    channel.connect(this.timeout);
                    DataInputStream dataIn = new DataInputStream(channel.getInputStream());
                    DataOutputStream dataOut = new DataOutputStream(channel.getOutputStream());
                    dataOut.writeBytes("\n");
                    dataOut.flush();
                    String line = dataIn.readLine();
                    while (!line.endsWith(this.endLineStr)) {
                        int j;
                        Gems.debug(line);
                        line = dataIn.readLine();
                        int i = line.indexOf("Version ");
                        if (i >= 0) {
                            if (line.length() <= i + 9) continue;
                            String v = line.substring(i + 8, 9);
                            int mv = 0;
                            try {
                                mv = Integer.parseInt(v);
                            }
                            catch (Exception ie) {
                                System.err.println("Exception: " + ie.getMessage());
                            }
                            if (mv == GemsConnectionNode.this.m_serverMajorVer) continue;
                            System.err.println("AppliancePollerThread: ERROR EMS reports major version " + GemsConnectionNode.this.m_serverMajorVer + " appliance reports major version " + mv + " check the servers.xml config is correct");
                            continue;
                        }
                        i = line.indexOf("INSTANCE ");
                        if (i >= 0) {
                            gotInstance = false;
                            if (!line.substring(i).startsWith("INSTANCE " + this.instanceId)) continue;
                            gotInstance = true;
                            continue;
                        }
                        if (gotInstance && (i = line.indexOf("Current State - ")) >= 0) {
                            j = line.indexOf(" :");
                            if (j > i + 16) {
                                instanceState = line.substring(i + 16, j);
                                continue;
                            }
                            if (j == -1 && line.length() > i + 16) {
                                instanceState = line.substring(i + 16);
                                continue;
                            }
                            System.err.println("AppliancePollerThread: ERROR from " + this.getHost() + " failed to parse instance state: " + line);
                            continue;
                        }
                        if (!gotInstance || (i = line.indexOf("EMS State - ")) < 0) continue;
                        j = line.indexOf(" :");
                        if (j > i + 12) {
                            instanceState = line.substring(i + 12, j);
                        } else if (j == -1 && line.length() > i + 12) {
                            instanceState = line.substring(i + 12);
                        } else {
                            System.err.println("AppliancePollerThread: ERROR from " + this.getHost() + " failed to parse instance state: " + line);
                        }
                        if (instanceState == null) continue;
                        if (instanceState.endsWith("REPLICATING") && Gems.getGems().getShowApplFullyOp()) {
                            instanceState = "FULLY_OPERATIONAL";
                            continue;
                        }
                        if (instanceState.startsWith("ACTIVE-")) {
                            instanceState = instanceState.substring(7);
                            continue;
                        }
                        if (!instanceState.startsWith("STANDBY-")) continue;
                        instanceState = instanceState.substring(8);
                    }
                    dataIn.close();
                    dataOut.close();
                    channel.disconnect();
                    session.disconnect();
                }
                catch (Exception ie) {
                    System.err.println("AppliancePollerThread: ERROR connecting to " + this.getHost() + " " + ie.toString());
                }
                if (GemsConnectionNode.this.m_instanceState == null || !GemsConnectionNode.this.m_instanceState.equals(instanceState)) {
                    GemsConnectionNode.this.m_instanceState = instanceState;
                    Gems.getGems().scheduleRepaint();
                }
                if (this.first) {
                    System.err.println("AppliancePollerThread: Initial FT state for " + this.getHost() + " instance " + this.getInstanceId() + " is " + instanceState);
                }
                this.first = false;
            }
        }

        public String getPassword() {
            return this.password;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getHost() {
            return this.host;
        }
    }

    class AdminDisconnectThread
    extends Thread {
        int delay = 10;
        long start = 0L;
        TibjmsAdmin adminConn = null;
        long connId = 0L;

        AdminDisconnectThread(TibjmsAdmin admin, long connId, int delay) {
            this.delay = delay * 1000;
            this.adminConn = admin;
            this.connId = connId;
        }

        public boolean isRunning() {
            return this.adminConn != null;
        }

        public long runTime() {
            if (this.start > 0L) {
                return (System.currentTimeMillis() - this.start) / 1000L;
            }
            return 0L;
        }

        @Override
        public void run() {
            block2: {
                this.start = System.currentTimeMillis();
                try {
                    AdminDisconnectThread.sleep(this.delay);
                    Gems.debug("AdminDisconnectThread: closing stale connection:  " + this.connId);
                    this.adminConn.close();
                    Gems.debug("AdminDisconnectThread: successfully closed stale connection: " + this.connId + " after " + this.runTime() + "secs");
                }
                catch (Exception ie) {
                    Gems.debug("AdminDisconnectThread: Connection id " + this.connId + " Exception " + ie.toString());
                    if (ie.toString().contains("terminated by the server")) break block2;
                    System.err.println("Timedout admin connection id " + this.connId + " failed to close, please restart Gems");
                }
            }
            this.adminConn = null;
            this.connId = 0L;
        }
    }

    class ChartRefreshTimerAction
    implements ActionListener {
        ChartRefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsConnectionNode.this.m_sub != null) {
                GemsConnectionNode.this.m_sub.onData(GemsConnectionNode.this.m_serverInfo, GemsConnectionNode.this.m_respTime);
            }
        }
    }

    public static enum LOG_TYPE {
        Never,
        WarnLimits,
        ErrorLimits,
        Always;

    }
}

