/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsTreeModel;
import com.tibco.gems.GemsUtilities;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class GemsConnectionPanel
extends JPanel {
    protected GemsTreeModel m_treeModel;
    protected JTextField m_alias;
    protected JTextField m_url;
    protected JTextField m_user;
    protected JTextField m_password;
    protected JTextField m_topicNamePattern;
    protected JTextField m_queueNamePattern;
    protected JTextField m_topicStore;
    protected JTextField m_queueStore;
    protected JTextField m_userNameFilter;
    protected JButton m_connButton;
    protected JButton m_disconnButton;
    protected JCheckBox m_autoConnect;
    protected JCheckBox m_enableMonitor;
    protected JComboBox m_logInfo;
    protected JTextField m_logDir;

    public GemsConnectionPanel(GemsTreeModel model) {
        super(true);
        this.setLayout(new BoxLayout(this, 3));
        this.m_treeModel = model;
        JPanel panel = new JPanel(new SpringLayout(), true);
        this.add(panel);
        JLabel l1 = new JLabel("Connection Alias:", 11);
        this.m_alias = new JTextField("EMS Connection", 20);
        this.m_alias.setMaximumSize(new Dimension(1000, 24));
        l1.setLabelFor(this.m_alias);
        panel.add(l1);
        panel.add(this.m_alias);
        JLabel l2 = new JLabel("URL:", 11);
        this.m_url = new JTextField("tcp://localhost:7222", 20);
        this.m_url.setMaximumSize(new Dimension(0, 24));
        l2.setLabelFor(this.m_url);
        panel.add(l2);
        panel.add(this.m_url);
        JLabel l3 = new JLabel("Admin Username:", 11);
        this.m_user = new JTextField("admin", 20);
        this.m_user.setMaximumSize(new Dimension(0, 24));
        l3.setLabelFor(this.m_user);
        panel.add(l3);
        panel.add(this.m_user);
        JLabel l4 = new JLabel("Password:", 11);
        this.m_password = new JPasswordField(20);
        this.m_password.setMaximumSize(new Dimension(0, 24));
        l4.setLabelFor(this.m_password);
        panel.add(l4);
        panel.add(this.m_password);
        JLabel l5 = new JLabel("Auto Connect:", 11);
        this.m_autoConnect = new JCheckBox();
        this.m_autoConnect.setMaximumSize(new Dimension(0, 24));
        this.m_autoConnect.setSelected(true);
        l5.setLabelFor(this.m_autoConnect);
        panel.add(l5);
        panel.add(this.m_autoConnect);
        JLabel l8 = new JLabel("Show Queues for Pattern:", 11);
        this.m_queueNamePattern = new JTextField(Gems.getGems().getQueueNamePattern(), 20);
        this.m_queueNamePattern.setMaximumSize(new Dimension(0, 24));
        l8.setLabelFor(this.m_queueNamePattern);
        panel.add(l8);
        panel.add(this.m_queueNamePattern);
        JLabel l9 = new JLabel("Show Topics for Pattern:", 11);
        this.m_topicNamePattern = new JTextField(Gems.getGems().getTopicNamePattern(), 20);
        this.m_topicNamePattern.setMaximumSize(new Dimension(0, 24));
        l9.setLabelFor(this.m_topicNamePattern);
        panel.add(l9);
        panel.add(this.m_topicNamePattern);
        JLabel l11 = new JLabel("Show Queues for Store:", 11);
        this.m_queueStore = new JTextField("", 20);
        this.m_queueStore.setMaximumSize(new Dimension(0, 24));
        l8.setLabelFor(this.m_queueStore);
        panel.add(l11);
        panel.add(this.m_queueStore);
        JLabel l12 = new JLabel("Show Topics for Store:", 11);
        this.m_topicStore = new JTextField("", 20);
        this.m_topicStore.setMaximumSize(new Dimension(0, 24));
        l9.setLabelFor(this.m_topicStore);
        panel.add(l12);
        panel.add(this.m_topicStore);
        JLabel l10 = new JLabel("Show Clients for User:", 11);
        this.m_userNameFilter = new JTextField("", 20);
        this.m_userNameFilter.setMaximumSize(new Dimension(0, 24));
        l10.setLabelFor(this.m_userNameFilter);
        panel.add(l10);
        panel.add(this.m_userNameFilter);
        JLabel l6 = new JLabel("Log Server Info for Historical Charts:", 11);
        this.m_logInfo = new JComboBox();
        this.m_logInfo.setMaximumSize(new Dimension(0, 24));
        l6.setLabelFor(this.m_logInfo);
        panel.add(l6);
        panel.add(this.m_logInfo);
        this.m_logInfo.addItem(GemsConnectionNode.LOG_TYPE.Always);
        this.m_logInfo.addItem((Object)((Object)GemsConnectionNode.LOG_TYPE.WarnLimits) + " (only when warning limits are reached)");
        this.m_logInfo.addItem((Object)((Object)GemsConnectionNode.LOG_TYPE.ErrorLimits) + " (only when error limits are reached)");
        this.m_logInfo.addItem(GemsConnectionNode.LOG_TYPE.Never);
        this.m_logInfo.setSelectedItem((Object)GemsConnectionNode.LOG_TYPE.Always);
        JLabel l7 = new JLabel("Log Directory:", 11);
        this.m_logDir = new JTextField("./log", 20);
        this.m_logDir.setMaximumSize(new Dimension(0, 24));
        l7.setLabelFor(this.m_logDir);
        panel.add(l7);
        panel.add(this.m_logDir);
        JLabel l13 = new JLabel("Enable $sys.monitor Events:", 11);
        this.m_enableMonitor = new JCheckBox();
        this.m_enableMonitor.setMaximumSize(new Dimension(0, 24));
        this.m_enableMonitor.setSelected(false);
        l13.setLabelFor(this.m_enableMonitor);
        panel.add(l13);
        panel.add(this.m_enableMonitor);
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 2));
        this.m_connButton = new JButton("Connect");
        this.m_connButton.addActionListener(new ConnectPressed());
        this.m_disconnButton = new JButton("Disconnect");
        this.m_disconnButton.addActionListener(new DisconnectPressed());
        this.m_disconnButton.setEnabled(false);
        bpanel.add(this.m_connButton);
        bpanel.add(this.m_disconnButton);
        this.add(bpanel);
        GemsUtilities.makeCompactGrid(panel, 13, 2, 5, 5, 5, 5);
    }

    public void setDetails(String name, String url, String user, String passwd, boolean autoConnect, boolean connected, GemsConnectionNode.LOG_TYPE logInfo, String logDir, String queuePattern, String topicPattern, String queueStore, String topicStore, String userFilter, boolean enableMonitor) {
        this.m_alias.setText(name);
        this.m_url.setText(url);
        this.m_user.setText(user);
        this.m_password.setText(passwd);
        this.m_queueNamePattern.setText(queuePattern);
        this.m_topicNamePattern.setText(topicPattern);
        this.m_queueStore.setText(queueStore);
        this.m_topicStore.setText(topicStore);
        this.m_userNameFilter.setText(userFilter);
        if (logInfo.name().startsWith("Warn")) {
            this.m_logInfo.setSelectedIndex(1);
        } else if (logInfo.name().startsWith("Error")) {
            this.m_logInfo.setSelectedIndex(2);
        } else {
            this.m_logInfo.setSelectedItem((Object)logInfo);
        }
        this.m_logDir.setText(logDir);
        this.m_autoConnect.setSelected(autoConnect);
        this.m_enableMonitor.setSelected(enableMonitor);
        this.updateState(connected);
    }

    public void updateState(boolean connected) {
        if (connected) {
            this.m_connButton.setEnabled(false);
            this.m_disconnButton.setEnabled(true);
            this.m_alias.setEnabled(false);
            this.m_url.setEnabled(false);
            this.m_user.setEnabled(false);
            this.m_password.setEnabled(false);
            this.m_queueNamePattern.setEnabled(false);
            this.m_topicNamePattern.setEnabled(false);
            this.m_queueStore.setEnabled(false);
            this.m_topicStore.setEnabled(false);
            this.m_userNameFilter.setEnabled(false);
            this.m_autoConnect.setEnabled(false);
            this.m_enableMonitor.setEnabled(false);
            this.m_logInfo.setEnabled(false);
            this.m_logDir.setEnabled(false);
        } else {
            this.m_connButton.setEnabled(true);
            this.m_disconnButton.setEnabled(false);
            this.m_alias.setEnabled(true);
            this.m_url.setEnabled(true);
            this.m_user.setEnabled(true);
            this.m_password.setEnabled(true);
            this.m_queueNamePattern.setEnabled(true);
            this.m_topicNamePattern.setEnabled(true);
            this.m_queueStore.setEnabled(true);
            this.m_topicStore.setEnabled(true);
            this.m_userNameFilter.setEnabled(true);
            this.m_autoConnect.setEnabled(true);
            this.m_enableMonitor.setEnabled(true);
            this.m_logInfo.setEnabled(true);
            this.m_logDir.setEnabled(true);
        }
    }

    class DisconnectPressed
    implements ActionListener {
        DisconnectPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionPanel.this.m_treeModel.disconnectCurrentNode(true);
            GemsConnectionPanel.this.updateState(false);
        }
    }

    class ConnectPressed
    implements ActionListener {
        ConnectPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = GemsConnectionPanel.this.m_logInfo.getSelectedIndex();
            GemsConnectionNode.LOG_TYPE li = GemsConnectionNode.LOG_TYPE.Always;
            if (i == 1) {
                li = GemsConnectionNode.LOG_TYPE.WarnLimits;
            } else if (i == 2) {
                li = GemsConnectionNode.LOG_TYPE.ErrorLimits;
            } else if (i == 3) {
                li = GemsConnectionNode.LOG_TYPE.Never;
            }
            if (GemsConnectionPanel.this.m_treeModel.connectCurrentNode(GemsConnectionPanel.this.m_alias.getText(), GemsConnectionPanel.this.m_url.getText(), GemsConnectionPanel.this.m_user.getText(), GemsConnectionPanel.this.m_password.getText(), GemsConnectionPanel.this.m_autoConnect.isSelected(), li, GemsConnectionPanel.this.m_logDir.getText(), GemsConnectionPanel.this.m_queueNamePattern.getText(), GemsConnectionPanel.this.m_topicNamePattern.getText(), GemsConnectionPanel.this.m_queueStore.getText(), GemsConnectionPanel.this.m_topicStore.getText(), GemsConnectionPanel.this.m_userNameFilter.getText(), GemsConnectionPanel.this.m_enableMonitor.isSelected())) {
                GemsConnectionPanel.this.updateState(true);
            } else {
                GemsConnectionPanel.this.updateState(false);
            }
        }
    }
}

