/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class GemsConnectionPicker
extends JDialog {
    JPanel m_panel;
    GemsConnectionNode m_cn;
    GemsConnectionNode m_result = null;
    protected JComboBox m_conn;
    protected JButton m_okButton;
    protected JButton m_cancelButton;
    protected Hashtable m_connTable;

    public GemsConnectionPicker(Frame frame, GemsConnectionNode cn, String text) {
        super(frame, "Select the EMS server to " + text, true);
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
        this.m_cn = cn;
        this.init();
    }

    public GemsConnectionPicker(JDialog frame, GemsConnectionNode cn, String text) {
        super(frame, "Select the EMS server to " + text, true);
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
        this.m_cn = cn;
        this.init();
    }

    public void init() {
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BoxLayout(m_panel, 1));
        this.getContentPane().add("Center", m_panel);
        m_panel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add(panel);
        this.m_connTable = GemsConnectionNode.getConnections();
        JLabel l1 = new JLabel(" EMS Server:", 11);
        this.m_conn = new JComboBox();
        Enumeration pe = this.m_connTable.keys();
        if (this.m_connTable.size() == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (pe.hasMoreElements()) {
            String i = (String)pe.nextElement();
            list.add(i);
            Collections.sort(list);
            this.m_conn.insertItemAt(i, list.indexOf(i));
            if (this.m_cn == null || !i.startsWith(this.m_cn.getName())) continue;
            this.m_conn.setSelectedItem(i);
        }
        if (this.m_conn.getSelectedItem() == null) {
            this.m_conn.setSelectedIndex(0);
        }
        this.m_conn.setPreferredSize(new Dimension(250, 25));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(50, 10));
        bpanel.add(bx);
        this.m_okButton = new JButton("Ok");
        this.m_okButton.addActionListener(new OkPressed());
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.addActionListener(new CancelPressed());
        bpanel.add(this.m_okButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_cancelButton);
        m_panel.add(bpanel);
        m_panel.add(Box.createRigidArea(new Dimension(0, 10)));
        GemsUtilities.makeCompactGrid(panel, 1, 2, 0, 0, 15, 10);
    }

    public GemsConnectionNode getConnection() {
        if (this.m_connTable.size() == 0) {
            return null;
        }
        if (this.m_connTable.size() == 1) {
            return (GemsConnectionNode)this.m_connTable.get(this.m_conn.getSelectedItem());
        }
        this.pack();
        this.show();
        return this.m_result;
    }

    public void ok() {
        this.m_result = (GemsConnectionNode)this.m_connTable.get(this.m_conn.getSelectedItem());
        this.dispose();
    }

    public void cancel() {
        this.m_result = null;
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionPicker.this.cancel();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionPicker.this.ok();
        }
    }
}

