/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsDetailsTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.PopupDestDisplayHandler;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.admin.ConsumerInfo;
import com.tibco.tibjms.admin.DestinationInfo;
import com.tibco.tibjms.admin.QueueInfo;
import com.tibco.tibjms.admin.ServerInfo;
import com.tibco.tibjms.admin.TibjmsAdminException;
import com.tibco.tibjms.admin.TopicInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.Timer;

public class GemsConsumerDisplay
extends JFrame {
    JFrame m_frame;
    JPanel m_panel;
    GemsConnectionNode m_cn;
    protected String m_type;
    protected JTextField m_conn;
    protected JTextField m_pattern;
    protected JTextField m_username;
    protected JCheckBox m_durablesOnly;
    protected JButton m_closeButton;
    protected JButton m_refreshButton;
    protected JButton m_lookup;
    protected boolean m_isQueue;
    protected boolean m_isFirstUpdate = false;
    protected JCheckBoxMenuItem m_autoRefresh = null;
    JTable m_table;
    protected GemsDetailsTableModel m_tableModel;
    TableSorter m_sorter;
    protected Timer m_timer = null;
    protected File m_file = null;
    protected FileOutputStream m_fileOut = null;
    protected PrintStream m_filePrint = null;
    protected String m_csvDelim = Gems.getGems().getCSVFileDelimiter();
    protected SimpleDateFormat dateFormatMillis = null;

    public GemsConsumerDisplay(GemsConnectionNode cn, String type, String dest) {
        super(Gems.getGems().getTitlePrefix() + type + " Consumers Display");
        try {
            this.dateFormatMillis = new SimpleDateFormat(Gems.getGems().getLogDateTimeFormat());
        }
        catch (Throwable e) {
            System.err.println("Bad LogDateTimeFormat in gems.props file: " + e);
            this.dateFormatMillis = new SimpleDateFormat("EEE MMM dd HH:mm:ss SSS zzz yyyy");
        }
        this.setLocation(320, 175);
        this.setDefaultCloseOperation(2);
        this.m_frame = this;
        this.m_cn = cn;
        this.m_type = type;
        this.m_isQueue = type.equals("Queue");
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 20);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JLabel l2 = new JLabel("Username:", 11);
        this.m_username = new JTextField(cn.getUserNameFilter() == null ? "" : cn.getUserNameFilter(), 20);
        this.m_username.setMaximumSize(new Dimension(0, 24));
        if (this.m_username.getText().length() > 1 && Gems.getGems().getViewOnlyMode()) {
            this.m_username.setEditable(false);
        }
        l2.setLabelFor(this.m_username);
        panel.add(l2);
        panel.add(this.m_username);
        JPanel spanel = new JPanel(true);
        spanel.setLayout(new BoxLayout(spanel, 0));
        spanel.setMinimumSize(new Dimension(600, 24));
        JLabel l5 = new JLabel(type + " Pattern:", 11);
        this.m_pattern = dest != null ? new JTextField(dest, 32) : new JTextField(this.m_isQueue ? cn.getQueueNamePattern() : cn.getTopicNamePattern(), 32);
        if (this.m_pattern.getText().length() > 1 && Gems.getGems().getViewOnlyMode()) {
            this.m_pattern.setEditable(false);
        }
        if (dest == null && this.m_pattern.getText().equals(">")) {
            this.m_pattern.setText("");
        }
        this.m_pattern.addKeyListener(new SubmitListener());
        l5.setLabelFor(this.m_pattern);
        panel.add(l5);
        spanel.add(this.m_pattern);
        this.m_lookup = new JButton("...");
        this.m_lookup.addActionListener(new DestinationWizardAction());
        spanel.add(this.m_lookup);
        panel.add(spanel);
        JLabel l3 = new JLabel("Durables Only:", 11);
        this.m_durablesOnly = new JCheckBox();
        this.m_durablesOnly.setMaximumSize(new Dimension(0, 24));
        if (this.m_isQueue) {
            this.m_durablesOnly.setEnabled(false);
            l3.setEnabled(false);
        }
        l3.setLabelFor(this.m_durablesOnly);
        panel.add(l3);
        panel.add(this.m_durablesOnly);
        this.m_tableModel = new GemsDetailsTableModel();
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_tableModel.setPopupHandler(new PopupDestDisplayHandler(this.m_table, this.m_tableModel, this.m_cn, this));
        this.m_tableModel.setTable(this.m_table);
        this.m_table.setSelectionMode(0);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(835, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(350, 10));
        bpanel.add(bx);
        this.m_closeButton = new JButton("Close");
        this.m_closeButton.addActionListener(new ClosePressed());
        this.m_refreshButton = new JButton("Refresh");
        bpanel.add(this.m_refreshButton);
        this.m_refreshButton.addActionListener(new RefreshAction());
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_closeButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 2, 4, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        if (this.m_pattern.getText().length() > 0) {
            this.lookupConsumers();
        }
        this.pack();
        this.show();
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Log Updates To CSV File...");
        menuItem.addActionListener(new LogToFile());
        menu.add(menuItem);
        menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsConsumerDisplay.this.dispose();
            }
        });
        menu = new JMenu("View");
        menu.setMnemonic(86);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("Tempory Consumers"));
        menuItem.addActionListener(new ViewTempsAction());
        this.m_autoRefresh = new JCheckBoxMenuItem("Auto Refresh");
        if (Gems.getGems().getDisplayRefresh() > 0) {
            this.m_autoRefresh.setState(false);
            menuItem = menu.add(this.m_autoRefresh);
        } else {
            this.m_autoRefresh.setState(false);
        }
        return menuBar;
    }

    public void lookupConsumers() {
        if (this.m_timer != null) {
            this.m_timer.stop();
        }
        this.m_tableModel.setRowCount(0);
        this.m_tableModel.setColumnCount(0);
        ServerInfo si = this.m_cn.getJmsServerInfo(false);
        if (si != null) {
            if (si.getConsumerCount() > Gems.getGems().getMaxConsumers() && this.m_pattern.getText().equals(">")) {
                int opt = JOptionPane.showConfirmDialog(this, "There are " + si.getConsumerCount() + " consumers. Are you sure you want to continue?", "Lookup Consumers", 0);
                if (opt != 0) {
                    return;
                }
                this.m_autoRefresh.setState(false);
            }
            this.m_isFirstUpdate = true;
            if (this.m_timer == null) {
                this.m_timer = new Timer(Gems.getGems().getDisplayRefresh() * 1000 + 1000, new RefreshTimerAction());
                this.m_timer.setInitialDelay(50);
                this.m_timer.start();
            } else {
                this.m_timer.restart();
            }
        }
    }

    public void getConsumers() {
        if (this.m_pattern.getText().length() == 0) {
            this.m_tableModel.populateErrorInfo("No " + this.m_type + " name pattern configured");
            return;
        }
        if (!this.m_cn.isConnected()) {
            this.m_tableModel.populateErrorInfo("Not connected to EMS server");
            return;
        }
        try {
            String un;
            Object di = this.m_isQueue ? new QueueInfo(this.m_pattern.getText()) : new TopicInfo(this.m_pattern.getText());
            this.m_tableModel.setRowCount(0);
            if (this.m_tableModel.getColumnCount() <= 1) {
                this.m_tableModel.setColumnCount(0);
                this.m_table.setAutoResizeMode(0);
                this.m_tableModel.setColumnIdentifiers(GemsDetailsTableModel.s_cons_cols);
                this.m_tableModel.setupColumnWidths();
            }
            if ((un = this.m_username.getText()) != null && un.length() == 0) {
                un = null;
            }
            ConsumerInfo[] c = this.m_cn.m_adminConn.getConsumers(null, un, (DestinationInfo)di, this.m_durablesOnly.isSelected(), 5);
            this.m_tableModel.addConsumerInfo(c);
            if (this.m_filePrint != null) {
                this.doLogging(c);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            this.m_autoRefresh.setState(false);
            return;
        }
        catch (Throwable e1) {
            System.err.println("Exception: " + e1.getMessage());
            this.m_autoRefresh.setState(false);
            return;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void doLogging(ConsumerInfo[] c) {
        if (c == null) {
            return;
        }
        Date d = new Date();
        try {
            for (int i = 0; c != null && i < c.length; ++i) {
                StringBuffer b = new StringBuffer(this.dateFormatMillis.format(d).toString());
                b.append(this.m_csvDelim);
                String sel = "";
                Long mpc = new Long(-1L);
                Long mps = new Long(-1L);
                try {
                    sel = c[i].getSelector();
                    if (sel == null) {
                        sel = "";
                    }
                    mpc = new Long(c[i].getPendingMessageCount());
                    mps = new Long(c[i].getPendingMessageSize());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                boolean act = true;
                boolean sys = false;
                long lastAck = -1L;
                long lastSent = -1L;
                int ackm = 0;
                long unackCount = -1L;
                ConsumerInfo.Details cid = c[i].getDetails();
                if (cid != null) {
                    try {
                        act = cid.isActive();
                        sys = cid.isSystem();
                        lastAck = cid.getElapsedSinceLastAcknowledged();
                        lastSent = cid.getElapsedSinceLastSent();
                        ackm = cid.getSessionAcknowledgeMode();
                        unackCount = cid.getCurrentMsgCountSentByServer();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                String ackMode = ackm == 5 ? "Transacted" : (ackm == 1 ? "NoAck" : (ackm == 3 ? "DupsOk" : (ackm == 4 ? "Client" : (ackm == 2 ? "Auto" : "Unknown"))));
                d.setTime(c[i].getCreateTime());
                boolean mc = false;
                try {
                    mc = c[i].isMulticast();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String typ = "Generic";
                if (c[i].getDestinationType() == 1) {
                    typ = "Queue";
                } else if (c[i].getDestinationType() == 2) {
                    typ = "Topic";
                }
                b.append(c[i].getID());
                b.append(this.m_csvDelim);
                b.append(d.toString());
                b.append(this.m_csvDelim);
                b.append(c[i].getDestinationName());
                b.append(this.m_csvDelim);
                b.append(String.valueOf(act));
                b.append(this.m_csvDelim);
                b.append(mpc);
                b.append(this.m_csvDelim);
                b.append(mps);
                b.append(this.m_csvDelim);
                b.append(c[i].getStatistics().getByteRate());
                b.append(this.m_csvDelim);
                b.append(c[i].getStatistics().getMessageRate());
                b.append(this.m_csvDelim);
                b.append(c[i].getStatistics().getTotalBytes());
                b.append(this.m_csvDelim);
                b.append(c[i].getStatistics().getTotalMessages());
                b.append(this.m_csvDelim);
                b.append(lastSent);
                b.append(this.m_csvDelim);
                b.append(lastAck);
                b.append(this.m_csvDelim);
                b.append(unackCount);
                b.append(this.m_csvDelim);
                b.append(sel);
                b.append(this.m_csvDelim);
                b.append(c[i].getUsername());
                b.append(this.m_csvDelim);
                b.append(c[i].getConnectionID());
                b.append(this.m_csvDelim);
                b.append(c[i].getSessionID());
                b.append(this.m_csvDelim);
                b.append(String.valueOf(sys));
                b.append(this.m_csvDelim);
                b.append(ackMode);
                b.append(this.m_csvDelim);
                b.append(typ);
                b.append(this.m_csvDelim);
                b.append(c[i].getDurableName() == null ? "" : c[i].getDurableName());
                b.append(this.m_csvDelim);
                b.append(String.valueOf(mc));
                this.m_filePrint.println(b.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    class LogToFile
    implements ActionListener {
        LogToFile() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (GemsConsumerDisplay.this.m_filePrint != null) {
                    GemsConsumerDisplay.this.m_filePrint.close();
                    GemsConsumerDisplay.this.m_filePrint = null;
                }
                if (GemsConsumerDisplay.this.m_fileOut != null) {
                    GemsConsumerDisplay.this.m_fileOut.close();
                    GemsConsumerDisplay.this.m_fileOut = null;
                }
            }
            catch (IOException ie) {
                GemsConsumerDisplay.this.m_filePrint = null;
                GemsConsumerDisplay.this.m_fileOut = null;
            }
            try {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Log Updates To CSV File");
                int returnVal = chooser.showOpenDialog(GemsConsumerDisplay.this.m_frame);
                if (returnVal == 0) {
                    GemsConsumerDisplay.this.m_file = chooser.getSelectedFile();
                    GemsConsumerDisplay.this.m_fileOut = new FileOutputStream(GemsConsumerDisplay.this.m_file, false);
                    GemsConsumerDisplay.this.m_filePrint = new PrintStream(GemsConsumerDisplay.this.m_fileOut);
                    StringBuffer b = new StringBuffer("Timestamp");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("ID");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("CreateTime");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("DestinationName");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("Active");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("PendingMsgCount");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("PendingMsgSize");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("ByteRate");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("MsgRate");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("TotalBytes");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("TotalMsgs");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("MillisSinceLastSent");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("MillisSinceLastAck");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("UnackedMsgCount");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("Selector");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("Username");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("ConnectionID");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("SessionID");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("System");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("AckMode");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("DestinationType");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("DurableName");
                    b.append(GemsConsumerDisplay.this.m_csvDelim);
                    b.append("Multicast");
                    GemsConsumerDisplay.this.m_filePrint.println(b.toString());
                }
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(GemsConsumerDisplay.this.m_frame, ie.getMessage(), "Error", 1);
                return;
            }
        }
    }

    class ViewTempsAction
    implements ActionListener {
        ViewTempsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConsumerDisplay.this.m_pattern.setText("$TMP$.>");
            GemsConsumerDisplay.this.lookupConsumers();
        }
    }

    class RefreshTimerAction
    implements ActionListener {
        RefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsConsumerDisplay.this.m_isFirstUpdate || GemsConsumerDisplay.this.m_autoRefresh.getState()) {
                GemsConsumerDisplay.this.getConsumers();
            }
            GemsConsumerDisplay.this.m_isFirstUpdate = false;
        }
    }

    class RefreshAction
    implements ActionListener {
        RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsConsumerDisplay.this.m_tableModel.getColumnCount() == 0) {
                GemsConsumerDisplay.this.lookupConsumers();
            } else if (GemsConsumerDisplay.this.m_timer != null) {
                GemsConsumerDisplay.this.m_isFirstUpdate = true;
                GemsConsumerDisplay.this.m_timer.restart();
            }
        }
    }

    class DestinationWizardAction
    implements ActionListener {
        DestinationWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsConsumerDisplay.this.m_frame, GemsConsumerDisplay.this.m_cn, GemsConsumerDisplay.this.m_isQueue ? GemsDestination.DEST_TYPE.Queue : GemsDestination.DEST_TYPE.Topic);
            if (dp.m_retDest != null) {
                GemsConsumerDisplay.this.m_pattern.setText(dp.m_retDest.m_destName);
                GemsConsumerDisplay.this.lookupConsumers();
            }
        }
    }

    public class SubmitListener
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                GemsConsumerDisplay.this.lookupConsumers();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    class ClosePressed
    implements ActionListener {
        ClosePressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConsumerDisplay.this.dispose();
        }
    }
}

