/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.admin.DestinationBridgeInfo;
import com.tibco.tibjms.admin.TibjmsAdminException;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class GemsCreateBridgeDialog
extends JPanel {
    JFrame m_frame;
    GemsConnectionNode m_cn;
    boolean m_isQueue;
    String m_dest;
    JTextField m_sel;
    JTextField m_tar;
    JComboBox m_tartype;

    public GemsCreateBridgeDialog(JFrame f, GemsConnectionNode cn, boolean isQueue, String dest) {
        super(new SpringLayout());
        this.m_frame = f;
        this.m_cn = cn;
        this.m_isQueue = isQueue;
        this.m_dest = dest;
        this.init();
    }

    public void init() {
        this.add(new JLabel("Source " + (this.m_isQueue ? "Queue:" : "Topic")));
        JTextField df = new JTextField(25);
        df.setText(this.m_dest);
        df.setEditable(false);
        this.add(df);
        JPanel qpanel = new JPanel(true);
        qpanel.setLayout(new BoxLayout(qpanel, 0));
        this.add(new JLabel("Target Type:"));
        this.m_tartype = new JComboBox();
        this.m_tartype.addItem("Queue");
        this.m_tartype.addItem("Topic");
        this.add(this.m_tartype);
        this.add(new JLabel("Target Destination:"));
        this.m_tar = new JTextField(25);
        qpanel.add(this.m_tar);
        JButton m_destwiz = new JButton("...");
        m_destwiz.setPreferredSize(new Dimension(18, 16));
        m_destwiz.addActionListener(new DestinationWizardAction());
        qpanel.add(m_destwiz);
        this.add(qpanel);
        this.add(new JLabel("Selector:"));
        this.m_sel = new JTextField(25);
        this.add(this.m_sel);
        GemsUtilities.makeCompactGrid(this, 4, 2, 5, 5, 5, 5);
    }

    public boolean createBridge() {
        int result = JOptionPane.showConfirmDialog(this.m_frame, this, "Create Bridge", 2);
        if (result == 0 && this.m_cn != null && this.m_cn.m_adminConn != null) {
            try {
                DestinationBridgeInfo bi = new DestinationBridgeInfo(this.m_isQueue ? 1 : 2, this.m_dest, this.m_tartype.getSelectedItem().equals("Queue") ? 1 : 2, this.m_tar.getText(), this.m_sel.getText().length() > 0 ? this.m_sel.getText() : null);
                this.m_cn.m_adminConn.createDestinationBridge(bi);
            }
            catch (TibjmsAdminException ex) {
                JOptionPane.showMessageDialog(this.m_frame, ex.getMessage(), "Error", 1);
                return false;
            }
            return true;
        }
        return false;
    }

    class DestinationWizardAction
    implements ActionListener {
        DestinationWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsCreateBridgeDialog.this.m_frame, GemsCreateBridgeDialog.this.m_cn, GemsCreateBridgeDialog.this.m_tartype.getSelectedItem().equals("Queue") ? GemsDestination.DEST_TYPE.Queue : GemsDestination.DEST_TYPE.Topic);
            if (dp.m_retDest != null) {
                GemsCreateBridgeDialog.this.m_tar.setText(dp.m_retDest.m_destName);
            }
        }
    }
}

