/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GemsDateTimePicker
extends JDialog
implements ItemListener,
MouseListener,
FocusListener,
KeyListener,
ActionListener {
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] DAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final Color WEEK_DAYS_FOREGROUND = Color.black;
    private static final Color DAYS_FOREGROUND = Color.blue;
    private static final Color SELECTED_DAY_FOREGROUND = Color.white;
    private static final Color SELECTED_DAY_BACKGROUND = Color.blue;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final Border FOCUSED_BORDER = BorderFactory.createLineBorder(Color.yellow, 1);
    private static final int FIRST_YEAR = 1900;
    private static final int LAST_YEAR = 2100;
    private GregorianCalendar calendar;
    private JLabel[][] days;
    private FocusablePanel daysGrid;
    private JComboBox month;
    private JComboBox year;
    private JComboBox hour;
    private JComboBox minute;
    private JComboBox second;
    private JButton previousMonth;
    private JButton nextMonth;
    private JButton ok;
    private JButton cancel;
    private int offset;
    private int lastDay;
    private JLabel day;
    private boolean okClicked;

    private void construct() {
        int i;
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.month = new JComboBox<String>(MONTHS);
        this.month.addItemListener(this);
        this.year = new JComboBox();
        for (i = 1900; i <= 2100; ++i) {
            this.year.addItem(Integer.toString(i));
        }
        this.year.addItemListener(this);
        this.previousMonth = new JButton("<<");
        this.previousMonth.addActionListener(this);
        this.nextMonth = new JButton(">>");
        this.nextMonth.addActionListener(this);
        this.days = new JLabel[7][7];
        for (i = 0; i < 7; ++i) {
            this.days[0][i] = new JLabel(DAYS[i], 4);
            this.days[0][i].setForeground(WEEK_DAYS_FOREGROUND);
        }
        for (i = 1; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.days[i][j] = new JLabel(" ", 4);
                this.days[i][j].setForeground(DAYS_FOREGROUND);
                this.days[i][j].setBackground(SELECTED_DAY_BACKGROUND);
                this.days[i][j].setBorder(EMPTY_BORDER);
                this.days[i][j].addMouseListener(this);
            }
        }
        String[] hours = new String[24];
        for (int hourCounter = 0; hourCounter < 24; ++hourCounter) {
            hours[hourCounter] = hourCounter < 10 ? "0" + hourCounter : Integer.toString(hourCounter);
        }
        String[] minSec = new String[60];
        for (int minutesCounter = 0; minutesCounter < 60; ++minutesCounter) {
            minSec[minutesCounter] = minutesCounter < 10 ? "0" + minutesCounter : Integer.toString(minutesCounter);
        }
        this.hour = new JComboBox<String>(hours);
        this.hour.addItemListener(this);
        this.minute = new JComboBox<String>(minSec);
        this.minute.addItemListener(this);
        this.second = new JComboBox<String>(minSec);
        this.second.addItemListener(this);
        this.ok = new JButton("Ok");
        this.ok.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        JPanel monthYear = new JPanel();
        monthYear.add(this.previousMonth);
        monthYear.add(this.month);
        monthYear.add(this.year);
        monthYear.add(this.nextMonth);
        this.daysGrid = new FocusablePanel(new GridLayout(7, 7, 5, 0));
        this.daysGrid.addFocusListener(this);
        this.daysGrid.addKeyListener(this);
        for (int i2 = 0; i2 < 7; ++i2) {
            for (int j = 0; j < 7; ++j) {
                this.daysGrid.add(this.days[i2][j]);
            }
        }
        this.daysGrid.setBackground(Color.white);
        this.daysGrid.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel daysPanel = new JPanel();
        daysPanel.add(this.daysGrid);
        GridLayout timePickerLayout = new GridLayout(2, 3);
        timePickerLayout.setHgap(10);
        JPanel timePicker = new JPanel(timePickerLayout);
        JLabel hourLabel = new JLabel("Hour");
        hourLabel.setHorizontalAlignment(0);
        JLabel minuteLabel = new JLabel("Minute");
        minuteLabel.setHorizontalAlignment(0);
        JLabel secondLabel = new JLabel("Second");
        secondLabel.setHorizontalAlignment(0);
        timePicker.add(hourLabel);
        timePicker.add(minuteLabel);
        timePicker.add(secondLabel);
        timePicker.add(this.hour);
        timePicker.add(this.minute);
        timePicker.add(this.second);
        JPanel buttons = new JPanel();
        buttons.add(this.ok);
        buttons.add(this.cancel);
        JPanel timepickerButtons = new JPanel(new BorderLayout());
        timepickerButtons.add((Component)timePicker, "North");
        timepickerButtons.add((Component)buttons, "South");
        Container dialog = this.getContentPane();
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)monthYear, "North");
        dialog.add((Component)daysPanel, "Center");
        dialog.add((Component)timepickerButtons, "South");
        this.pack();
        this.setResizable(false);
    }

    private int getSelectedDay() {
        if (this.day == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.day.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private int getSelectedHour() {
        if (this.hour == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.hour.getSelectedItem().toString());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private int getSelectedMinute() {
        if (this.minute == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.minute.getSelectedItem().toString());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private int getSelectedSecond() {
        if (this.second == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.second.getSelectedItem().toString());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void setSelected(JLabel newDay) {
        if (this.day != null) {
            this.day.setForeground(DAYS_FOREGROUND);
            this.day.setOpaque(false);
            this.day.setBorder(EMPTY_BORDER);
        }
        this.day = newDay;
        this.day.setForeground(SELECTED_DAY_FOREGROUND);
        this.day.setOpaque(true);
        if (this.daysGrid.hasFocus()) {
            this.day.setBorder(FOCUSED_BORDER);
        }
    }

    private void setSelected(int newDay) {
        this.setSelected(this.days[(newDay + this.offset - 1) / 7 + 1][(newDay + this.offset - 1) % 7]);
    }

    private void update() {
        int i;
        int iday = this.getSelectedDay();
        for (i = 0; i < 7; ++i) {
            this.days[1][i].setText(" ");
            this.days[5][i].setText(" ");
            this.days[6][i].setText(" ");
        }
        this.calendar.set(5, 1);
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        this.offset = this.calendar.get(7) - 1;
        this.lastDay = this.calendar.getActualMaximum(5);
        for (i = 0; i < this.lastDay; ++i) {
            this.days[(i + this.offset) / 7 + 1][(i + this.offset) % 7].setText(String.valueOf(i + 1));
        }
        if (iday != -1) {
            if (iday > this.lastDay) {
                iday = this.lastDay;
            }
            this.setSelected(iday);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.okClicked = true;
            this.setVisible(false);
        } else if (e.getSource() == this.previousMonth) {
            if (this.month.getSelectedIndex() == 0) {
                int previousMonthIndex = 11;
                int previousYearIndex = this.year.getSelectedIndex() - 1;
                this.month.setSelectedIndex(previousMonthIndex);
                this.year.setSelectedIndex(previousYearIndex);
            } else {
                int previousMonthIndex = this.month.getSelectedIndex() - 1;
                this.month.setSelectedIndex(previousMonthIndex);
            }
            this.update();
        } else if (e.getSource() == this.nextMonth) {
            if (this.month.getSelectedIndex() == 11) {
                int nextMonthIndex = 0;
                int nextYearIndex = this.year.getSelectedIndex() + 1;
                this.month.setSelectedIndex(nextMonthIndex);
                this.year.setSelectedIndex(nextYearIndex);
            } else {
                int nextMonthIndex = this.month.getSelectedIndex() + 1;
                this.month.setSelectedIndex(nextMonthIndex);
            }
            this.update();
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.setSelected(this.day);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setSelected(this.day);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.update();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int iday = this.getSelectedDay();
        switch (e.getKeyCode()) {
            case 37: {
                if (iday <= 1) break;
                this.setSelected(iday - 1);
                break;
            }
            case 39: {
                if (iday >= this.lastDay) break;
                this.setSelected(iday + 1);
                break;
            }
            case 38: {
                if (iday <= 7) break;
                this.setSelected(iday - 7);
                break;
            }
            case 40: {
                if (iday > this.lastDay - 7) break;
                this.setSelected(iday + 7);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JLabel day = (JLabel)e.getSource();
        if (!day.getText().equals(" ")) {
            this.setSelected(day);
        }
        this.daysGrid.requestFocus();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public GemsDateTimePicker(Dialog owner, String title) {
        super(owner, title, true);
        this.construct();
    }

    public GemsDateTimePicker(Dialog owner) {
        super(owner, true);
        this.construct();
    }

    public GemsDateTimePicker(Frame owner, String title) {
        super(owner, title, true);
        this.construct();
    }

    public GemsDateTimePicker(Frame owner) {
        super(owner, true);
        this.construct();
    }

    public Date select(Date date) {
        this.calendar.setTime(date);
        this.calendar.setTimeZone(TimeZone.getDefault());
        int _day = this.calendar.get(5);
        int _month = this.calendar.get(2);
        int _year = this.calendar.get(1);
        int _hour = this.calendar.get(11);
        int _minute = this.calendar.get(12);
        int _second = this.calendar.get(13);
        this.year.setSelectedIndex(_year - 1900);
        this.month.setSelectedIndex(_month - 0);
        this.hour.setSelectedIndex(_hour);
        this.minute.setSelectedIndex(_minute);
        this.second.setSelectedIndex(_second);
        this.setSelected(_day);
        this.okClicked = false;
        this.setVisible(true);
        if (!this.okClicked) {
            return null;
        }
        this.calendar.set(5, this.getSelectedDay());
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        this.calendar.set(11, this.getSelectedHour());
        this.calendar.set(12, this.getSelectedMinute());
        this.calendar.set(13, this.getSelectedSecond());
        return this.calendar.getTime();
    }

    public Date select() {
        return this.select(new Date());
    }

    private static class FocusablePanel
    extends JPanel {
        public FocusablePanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }
    }
}

