/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestPropEditor;
import com.tibco.gems.GemsDetailsTableModel;
import com.tibco.gems.GemsPermissionDialog;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.PopupDestDisplayHandler;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.admin.DestinationInfo;
import com.tibco.tibjms.admin.QueueInfo;
import com.tibco.tibjms.admin.ServerInfo;
import com.tibco.tibjms.admin.TopicInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.Timer;

public class GemsDestDisplay
extends JFrame {
    JFrame m_frame;
    JPanel m_panel;
    GemsConnectionNode m_cn;
    protected String m_type;
    protected JTextField m_conn;
    protected JTextField m_store;
    protected JTextField m_pattern;
    protected JButton m_closeButton;
    protected JButton m_refreshButton;
    protected JButton m_lookup;
    protected boolean m_isQueue;
    protected boolean m_isFirstUpdate = false;
    protected JComboBox m_permType;
    protected JCheckBoxMenuItem m_autoRefresh = null;
    JTable m_table;
    protected GemsDetailsTableModel m_tableModel;
    TableSorter m_sorter;
    protected Timer m_timer = null;
    protected File m_file = null;
    protected FileOutputStream m_fileOut = null;
    protected PrintStream m_filePrint = null;
    protected String m_csvDelim = Gems.getGems().getCSVFileDelimiter();
    protected SimpleDateFormat dateFormatMillis = null;
    protected GetDestThread m_destThread = null;
    protected DestinationInfo[] m_destInfo = null;
    protected String m_patternText = null;
    protected String m_patternOrig = null;
    protected boolean m_isRunning = true;

    public GemsDestDisplay(GemsConnectionNode cn, String type) {
        this(cn, type, type.equals("Queue") ? cn.getQueueNamePattern() : cn.getTopicNamePattern(), false);
    }

    public GemsDestDisplay(GemsConnectionNode cn, String type, String pattern, boolean start) {
        super(Gems.getGems().getTitlePrefix() + type + "s Display");
        try {
            this.dateFormatMillis = new SimpleDateFormat(Gems.getGems().getLogDateTimeFormat());
        }
        catch (Throwable e) {
            System.err.println("Bad LogDateTimeFormat in gems.props file: " + e);
            this.dateFormatMillis = new SimpleDateFormat("EEE MMM dd HH:mm:ss SSS zzz yyyy");
        }
        this.setLocation(300, 155);
        this.setDefaultCloseOperation(2);
        this.m_frame = this;
        this.m_cn = cn;
        this.m_type = type;
        this.m_patternText = pattern;
        this.m_patternOrig = pattern;
        this.m_isQueue = type.equals("Queue");
        JMenuBar menuBar = this.constructMenuBar(pattern);
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 30);
        this.m_conn.setEditable(false);
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JLabel l6 = new JLabel("Store Filter:", 11);
        this.m_store = new JTextField(this.getStoreFilter(), 25);
        this.m_store.setEditable(false);
        l6.setLabelFor(this.m_store);
        panel.add(l6);
        panel.add(this.m_store);
        JPanel spanel = new JPanel(true);
        spanel.setLayout(new BoxLayout(spanel, 0));
        JLabel l5 = new JLabel(type + " Pattern:", 11);
        this.m_pattern = new JTextField(pattern, 32);
        this.m_pattern.addKeyListener(new SubmitListener());
        if (pattern.length() > 1 && Gems.getGems().getViewOnlyMode()) {
            this.m_pattern.setEditable(false);
            start = true;
        }
        l5.setLabelFor(this.m_pattern);
        panel.add(l5);
        spanel.add(this.m_pattern);
        this.m_lookup = new JButton("Lookup");
        this.m_lookup.addActionListener(new LookupAction());
        spanel.add(this.m_lookup);
        panel.add(spanel);
        JLabel l7 = new JLabel(type + " Type:", 11);
        this.m_permType = new JComboBox();
        for (PERM_TYPE dm : PERM_TYPE.values()) {
            this.m_permType.addItem(dm);
        }
        if (pattern.startsWith("$TMP$.")) {
            this.m_permType.setSelectedItem((Object)PERM_TYPE.Temporaries);
            this.m_patternOrig = this.m_type.equals("Queue") ? cn.getQueueNamePattern() : cn.getTopicNamePattern();
        } else if (pattern.startsWith("$sys.")) {
            this.m_permType.setSelectedItem((Object)PERM_TYPE.System);
            this.m_patternOrig = this.m_type.equals("Queue") ? cn.getQueueNamePattern() : cn.getTopicNamePattern();
        }
        this.m_permType.addActionListener(new ViewTypeAction());
        l7.setLabelFor(this.m_permType);
        panel.add(l7);
        panel.add(this.m_permType);
        this.m_tableModel = new GemsDetailsTableModel();
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_tableModel.setPopupHandler(new PopupDestDisplayHandler(this.m_table, this.m_tableModel, this.m_cn, this));
        this.m_tableModel.setTable(this.m_table);
        this.m_table.setSelectionMode(0);
        if (!Gems.getGems().getViewOnlyMode()) {
            this.addMouseListenerToTable(this.m_table);
        }
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(835, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(350, 10));
        bpanel.add(bx);
        this.m_closeButton = new JButton("Close");
        this.m_closeButton.addActionListener(new ClosePressed());
        this.m_refreshButton = new JButton("Refresh");
        bpanel.add(this.m_refreshButton);
        this.m_refreshButton.addActionListener(new RefreshAction());
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_closeButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 2, 4, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.pack();
        if (start) {
            this.lookupDestinations();
        }
        this.show();
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GemsDestDisplay.this.editDestProperties();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    private JMenuBar constructMenuBar(String pattern) {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Log Updates To CSV File...");
        menuItem.addActionListener(new LogToFile());
        menu.add(menuItem);
        menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsDestDisplay.this.dispose();
            }
        });
        if (!Gems.getGems().getViewOnlyMode()) {
            menu = new JMenu("Edit");
            menu.setMnemonic(69);
            menuBar.add(menu);
            menuItem = new JMenuItem(this.m_type + " Properties...");
            menuItem.addActionListener(new EditPropAction());
            menu.add(menuItem);
            menuItem = new JMenuItem(this.m_type + " Permissions...");
            menuItem.addActionListener(new EditPermAction());
            menu.add(menuItem);
        }
        menu = new JMenu("View");
        menu.setMnemonic(86);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("Refresh"));
        menuItem.addActionListener(new RefreshAction());
        this.m_autoRefresh = new JCheckBoxMenuItem("Auto Refresh");
        if (Gems.getGems().getDisplayRefresh() > 0) {
            menuItem = menu.add(this.m_autoRefresh);
            this.m_autoRefresh.setState(true);
        } else {
            this.m_autoRefresh.setState(false);
        }
        return menuBar;
    }

    public String getStoreFilter() {
        if (this.m_patternText.startsWith("$TMP$.") || this.m_patternText.startsWith("$sys.")) {
            return "";
        }
        if (this.m_type.equals("Queue")) {
            return this.m_cn.getQueueStoreFilter();
        }
        return this.m_cn.getTopicStoreFilter();
    }

    public void editDestProperties() {
        String dest = this.m_tableModel.getSelectedCol1();
        GemsDestPropEditor d = new GemsDestPropEditor(this.m_frame, this.m_cn, this.m_type, dest);
    }

    public int getPermType() {
        if (this.m_permType.getSelectedItem() == PERM_TYPE.NoTemporaries) {
            return 3;
        }
        if (this.m_permType.getSelectedItem() == PERM_TYPE.Static) {
            return 1;
        }
        if (this.m_permType.getSelectedItem() == PERM_TYPE.Dynamic) {
            return 2;
        }
        if (this.m_permType.getSelectedItem() == PERM_TYPE.System) {
            if (this.m_type.equals("Queue")) {
                return 1;
            }
            return 3;
        }
        return 4;
    }

    public void lookupDestinations() {
        if (this.m_destThread != null && this.m_destThread.isAlive()) {
            System.err.println("GemsDestDisplay: get destinatons already in progress, please wait");
            return;
        }
        this.m_tableModel.setRowCount(0);
        this.m_tableModel.setColumnCount(0);
        ServerInfo si = this.m_cn.getJmsServerInfo(false);
        boolean showWait = false;
        if (si != null) {
            if (this.m_isQueue) {
                if (si.getQueueCount() > Gems.getGems().getMaxQueues() && this.m_pattern.getText().equals(">")) {
                    int opt = JOptionPane.showConfirmDialog(this, "There are " + si.getQueueCount() + " queues, set a pattern to filter the number of queues. \nAre you sure you want to continue?\n(Auto Refresh will be disabled)", "Lookup Queues", 0);
                    if (opt != 0) {
                        return;
                    }
                    this.m_autoRefresh.setState(false);
                    showWait = true;
                } else {
                    this.m_autoRefresh.setState(true);
                }
            } else if (si.getTopicCount() > Gems.getGems().getMaxTopics() && this.m_pattern.getText().equals(">")) {
                int opt = JOptionPane.showConfirmDialog(this, "There are " + si.getTopicCount() + " topics, set a pattern to filter the number of topics. \nAre you sure you want to continue?\n(Auto Refresh will be disabled)", "Lookup Topics", 0);
                if (opt != 0) {
                    return;
                }
                this.m_autoRefresh.setState(false);
                showWait = true;
            } else {
                this.m_autoRefresh.setState(true);
            }
            this.m_isFirstUpdate = true;
            if (Gems.getGems().getDisplayRefresh() == 0) {
                this.m_autoRefresh.setState(false);
            }
            if (this.m_pattern.getText().length() == 0) {
                this.m_tableModel.populateErrorInfo("No " + this.m_type + " name pattern configured");
                return;
            }
            if (!this.m_cn.isConnected()) {
                this.m_tableModel.populateErrorInfo("Not connected to EMS server");
                return;
            }
            if (showWait) {
                this.m_tableModel.populateInfo("Retrieving destination info...");
            }
            this.m_patternText = this.m_pattern.getText();
            this.m_isRunning = true;
            this.m_destThread = new GetDestThread();
            this.m_destThread.start();
        }
    }

    public void getDestinationsOLD() {
        if (this.m_pattern.getText().length() == 0) {
            this.m_tableModel.populateErrorInfo("No " + this.m_type + " name pattern configured");
            return;
        }
        if (!this.m_cn.isConnected()) {
            this.m_tableModel.populateErrorInfo("Not connected to EMS server");
            return;
        }
        try {
            int permType = 3;
            if (this.m_pattern.getText().startsWith("$TMP$.")) {
                permType = 4;
            }
            if (this.m_isQueue) {
                QueueInfo[] qi = this.m_cn.getQueues(this.m_pattern.getText(), permType);
                this.m_tableModel.populateQueuesInfo(this.m_cn, qi);
                if (this.m_filePrint != null) {
                    this.doLogging((DestinationInfo[])qi);
                }
            } else {
                TopicInfo[] ti = this.m_cn.getTopics(this.m_pattern.getText(), permType);
                this.m_tableModel.populateTopicsInfo(this.m_cn, ti);
            }
            if (this.m_timer == null) {
                this.m_timer = new Timer(Gems.getGems().getDisplayRefresh() * 1000 + 1000, new RefreshTimerAction());
                this.m_timer.setInitialDelay(0);
                this.m_timer.start();
            } else {
                this.m_timer.restart();
            }
            if (this.m_filePrint != null) {
                this.doLogging(this.m_destInfo);
            }
        }
        catch (Exception e) {
            System.err.println("JMSException: " + e.getMessage());
            this.m_autoRefresh.setState(false);
            return;
        }
    }

    public void doLogging(DestinationInfo[] q) {
        if (q == null) {
            return;
        }
        Date d = new Date();
        try {
            for (int i = 0; i < q.length; ++i) {
                StringBuffer b = new StringBuffer(this.dateFormatMillis.format(d).toString());
                b.append(this.m_csvDelim);
                b.append(q[i].getName());
                b.append(this.m_csvDelim);
                b.append(q[i].getPendingMessageCount());
                b.append(this.m_csvDelim);
                b.append(GemsUtilities.getHumanReadableSize(q[i].getPendingMessageSize()));
                b.append(this.m_csvDelim);
                if (q[i] instanceof QueueInfo) {
                    b.append(((QueueInfo)q[i]).getReceiverCount());
                    b.append(this.m_csvDelim);
                } else {
                    b.append(((TopicInfo)q[i]).getSubscriberCount());
                    b.append(this.m_csvDelim);
                }
                b.append(q[i].getInboundStatistics().getTotalMessages());
                b.append(this.m_csvDelim);
                b.append(q[i].getOutboundStatistics().getTotalMessages());
                b.append(this.m_csvDelim);
                b.append(q[i].getInboundStatistics().getMessageRate());
                b.append(this.m_csvDelim);
                b.append(q[i].getOutboundStatistics().getMessageRate());
                b.append(this.m_csvDelim);
                try {
                    b.append(q[i].getPendingPersistentMessageCount());
                    b.append(this.m_csvDelim);
                    b.append(GemsUtilities.getHumanReadableSize(q[i].getPendingPersistentMessageSize()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.m_filePrint.println(b.toString());
            }
        }
        catch (Exception e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    @Override
    public void dispose() {
        this.m_isRunning = false;
        if (this.m_timer != null) {
            this.m_timer.stop();
        }
        super.dispose();
    }

    class LogToFile
    implements ActionListener {
        LogToFile() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (GemsDestDisplay.this.m_filePrint != null) {
                    GemsDestDisplay.this.m_filePrint.close();
                    GemsDestDisplay.this.m_filePrint = null;
                }
                if (GemsDestDisplay.this.m_fileOut != null) {
                    GemsDestDisplay.this.m_fileOut.close();
                    GemsDestDisplay.this.m_fileOut = null;
                }
            }
            catch (IOException ie) {
                GemsDestDisplay.this.m_filePrint = null;
                GemsDestDisplay.this.m_fileOut = null;
            }
            try {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Log Updates To CSV File");
                int returnVal = chooser.showOpenDialog(GemsDestDisplay.this.m_frame);
                if (returnVal == 0) {
                    GemsDestDisplay.this.m_file = chooser.getSelectedFile();
                    GemsDestDisplay.this.m_fileOut = new FileOutputStream(GemsDestDisplay.this.m_file, false);
                    GemsDestDisplay.this.m_filePrint = new PrintStream(GemsDestDisplay.this.m_fileOut);
                    StringBuffer b = new StringBuffer("Timestamp");
                    b.append(GemsDestDisplay.this.m_csvDelim);
                    if (GemsDestDisplay.this.m_isQueue) {
                        b.append("QueueName");
                    } else {
                        b.append("TopicName");
                    }
                    b.append(GemsDestDisplay.this.m_csvDelim);
                    b.append("PendingMsgCount");
                    b.append(GemsDestDisplay.this.m_csvDelim);
                    b.append("PendingMsgSize");
                    b.append(GemsDestDisplay.this.m_csvDelim);
                    if (GemsDestDisplay.this.m_isQueue) {
                        b.append("ReceiverCount");
                    } else {
                        b.append("SubscriberCount");
                    }
                    b.append(GemsDestDisplay.this.m_csvDelim);
                    b.append("InTotalMsgs");
                    b.append(GemsDestDisplay.this.m_csvDelim);
                    b.append("OutTotalMsgs");
                    b.append(GemsDestDisplay.this.m_csvDelim);
                    b.append("InMsgRate");
                    b.append(GemsDestDisplay.this.m_csvDelim);
                    b.append("OutMsgRate");
                    b.append(GemsDestDisplay.this.m_csvDelim);
                    b.append("PendingPersMsgCount");
                    b.append(GemsDestDisplay.this.m_csvDelim);
                    b.append("PendingPersMsgSize");
                    GemsDestDisplay.this.m_filePrint.println(b.toString());
                }
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(GemsDestDisplay.this.m_frame, ie.getMessage(), "Error", 1);
                return;
            }
        }
    }

    class ViewSystemAction
    implements ActionListener {
        ViewSystemAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestDisplay.this.m_pattern.setText("$sys.>");
            GemsDestDisplay.this.lookupDestinations();
        }
    }

    class ViewTempsAction
    implements ActionListener {
        ViewTempsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestDisplay.this.m_pattern.setText("$TMP$.>");
            GemsDestDisplay.this.lookupDestinations();
        }
    }

    class ViewTypeAction
    implements ActionListener {
        ViewTypeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsDestDisplay.this.m_permType.getSelectedItem() == PERM_TYPE.System) {
                GemsDestDisplay.this.m_pattern.setText("$sys.>");
            } else if (GemsDestDisplay.this.m_permType.getSelectedItem() == PERM_TYPE.Temporaries) {
                GemsDestDisplay.this.m_pattern.setText("$TMP$.>");
            } else if (GemsDestDisplay.this.m_pattern.getText().startsWith("$sys.") || GemsDestDisplay.this.m_pattern.getText().startsWith("$TMP$.")) {
                GemsDestDisplay.this.m_pattern.setText(GemsDestDisplay.this.m_patternOrig);
            }
            GemsDestDisplay.this.lookupDestinations();
        }
    }

    class RefreshTimerAction
    implements ActionListener {
        RefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsDestDisplay.this.m_destInfo == null && (GemsDestDisplay.this.m_isFirstUpdate || GemsDestDisplay.this.m_autoRefresh.getState())) {
                if (GemsDestDisplay.this.m_destThread != null && GemsDestDisplay.this.m_destThread.isAlive()) {
                    return;
                }
                GemsDestDisplay.this.m_destThread = new GetDestThread();
                GemsDestDisplay.this.m_destThread.start();
                GemsDestDisplay.this.m_isFirstUpdate = false;
                return;
            }
            if (GemsDestDisplay.this.m_destInfo != null) {
                if (GemsDestDisplay.this.m_isQueue) {
                    if (GemsDestDisplay.this.m_pattern.getText().startsWith("$TMP$.")) {
                        GemsDestDisplay.this.m_tableModel.populateTmpQueuesInfo(GemsDestDisplay.this.m_cn, (QueueInfo[])GemsDestDisplay.this.m_destInfo);
                    } else {
                        GemsDestDisplay.this.m_tableModel.populateQueuesInfo(GemsDestDisplay.this.m_cn, (QueueInfo[])GemsDestDisplay.this.m_destInfo);
                    }
                } else if (GemsDestDisplay.this.m_pattern.getText().startsWith("$TMP$.")) {
                    GemsDestDisplay.this.m_tableModel.populateTmpTopicsInfo(GemsDestDisplay.this.m_cn, (TopicInfo[])GemsDestDisplay.this.m_destInfo);
                } else {
                    GemsDestDisplay.this.m_tableModel.populateTopicsInfo(GemsDestDisplay.this.m_cn, (TopicInfo[])GemsDestDisplay.this.m_destInfo);
                }
            } else if (GemsDestDisplay.this.m_table.getRowCount() == 1 && GemsDestDisplay.this.m_table.getColumnCount() == 1) {
                GemsDestDisplay.this.m_tableModel.populateErrorInfo("Failed to retrieve destination info.");
            }
            GemsDestDisplay.this.m_store.setText(GemsDestDisplay.this.getStoreFilter());
            GemsDestDisplay.this.m_destInfo = null;
            GemsDestDisplay.this.m_isFirstUpdate = false;
        }
    }

    class RefreshAction
    implements ActionListener {
        RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsDestDisplay.this.m_destThread != null && GemsDestDisplay.this.m_destThread.isAlive()) {
                System.err.println("GemsDestDisplay: get destinatons already in progress, please wait");
                return;
            }
            if (GemsDestDisplay.this.m_timer != null) {
                GemsDestDisplay.this.m_isRunning = true;
                GemsDestDisplay.this.m_isFirstUpdate = true;
                GemsDestDisplay.this.m_timer.restart();
            }
        }
    }

    class LookupAction
    implements ActionListener {
        LookupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsDestDisplay.this.m_pattern.getText().startsWith("$sys.")) {
                GemsDestDisplay.this.m_permType.setSelectedItem((Object)PERM_TYPE.System);
            } else if (GemsDestDisplay.this.m_pattern.getText().startsWith("$TMP$.")) {
                GemsDestDisplay.this.m_permType.setSelectedItem((Object)PERM_TYPE.Temporaries);
            } else if (GemsDestDisplay.this.m_permType.getSelectedItem() == PERM_TYPE.Temporaries || GemsDestDisplay.this.m_permType.getSelectedItem() == PERM_TYPE.System) {
                GemsDestDisplay.this.m_permType.setSelectedItem((Object)PERM_TYPE.NoTemporaries);
            }
            GemsDestDisplay.this.lookupDestinations();
        }
    }

    class EditPermAction
    implements ActionListener {
        EditPermAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String dest = GemsDestDisplay.this.m_tableModel.getSelectedCol1();
            GemsPermissionDialog d = new GemsPermissionDialog(GemsDestDisplay.this.m_frame, "Set " + GemsDestDisplay.this.m_type + " Permissions", GemsDestDisplay.this.m_type.equals("Queue"), GemsDestDisplay.this.m_cn, dest);
        }
    }

    class EditPropAction
    implements ActionListener {
        EditPropAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestDisplay.this.editDestProperties();
        }
    }

    class GetDestThread
    extends Thread {
        GetDestThread() {
        }

        @Override
        public void run() {
            if (GemsDestDisplay.this.m_isRunning) {
                boolean doFilter = true;
                int permType = GemsDestDisplay.this.getPermType();
                if (GemsDestDisplay.this.m_pattern.getText().startsWith("$TMP$.")) {
                    doFilter = false;
                } else if (GemsDestDisplay.this.m_pattern.getText().startsWith("$sys.")) {
                    doFilter = false;
                }
                GemsDestDisplay.this.m_destInfo = GemsDestDisplay.this.m_isQueue ? GemsDestDisplay.this.m_cn.getQueues(GemsDestDisplay.this.m_patternText, permType, false, doFilter) : GemsDestDisplay.this.m_cn.getTopics(GemsDestDisplay.this.m_patternText, permType, false, doFilter);
                if (!GemsDestDisplay.this.m_isRunning) {
                    return;
                }
                if (GemsDestDisplay.this.m_timer == null) {
                    GemsDestDisplay.this.m_timer = new Timer(Gems.getGems().getDisplayRefresh() * 1000 + 1000, new RefreshTimerAction());
                    GemsDestDisplay.this.m_timer.setInitialDelay(10);
                    GemsDestDisplay.this.m_timer.start();
                } else {
                    GemsDestDisplay.this.m_timer.restart();
                }
                if (GemsDestDisplay.this.m_filePrint != null) {
                    GemsDestDisplay.this.doLogging(GemsDestDisplay.this.m_destInfo);
                }
                if (GemsDestDisplay.this.m_destInfo == null) {
                    GemsDestDisplay.this.m_isRunning = false;
                    GemsDestDisplay.this.m_autoRefresh.setState(false);
                }
                GemsDestDisplay.this.m_destThread = null;
            }
        }
    }

    public class SubmitListener
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                if (GemsDestDisplay.this.m_pattern.getText().startsWith("$sys.")) {
                    GemsDestDisplay.this.m_permType.setSelectedItem((Object)PERM_TYPE.System);
                } else if (GemsDestDisplay.this.m_pattern.getText().startsWith("$TMP$.")) {
                    GemsDestDisplay.this.m_permType.setSelectedItem((Object)PERM_TYPE.Temporaries);
                } else if (GemsDestDisplay.this.m_permType.getSelectedItem() == PERM_TYPE.Temporaries || GemsDestDisplay.this.m_permType.getSelectedItem() == PERM_TYPE.System) {
                    GemsDestDisplay.this.m_permType.setSelectedItem((Object)PERM_TYPE.NoTemporaries);
                }
                GemsDestDisplay.this.lookupDestinations();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    class ClosePressed
    implements ActionListener {
        ClosePressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestDisplay.this.dispose();
        }
    }

    public static enum PERM_TYPE {
        NoTemporaries,
        Static,
        Dynamic,
        Temporaries,
        System;

    }
}

