/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsBrowserOptionsDialog;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestMonitorSelectorDialog;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsMonitorDestMessageTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.Tibjms;
import com.tibco.tibjms.TibjmsTopicConnectionFactory;
import com.tibco.tibjms.admin.TibjmsAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.text.DefaultEditorKit;

public class GemsDestMonitor
extends JFrame {
    JFrame m_frame;
    JPanel m_panel;
    boolean m_running = false;
    boolean m_isQueue = false;
    int m_maxMsgs = 30;
    int m_events = 0;
    Message m_msg = null;
    TibjmsAdmin m_admin = null;
    TopicSession m_session = null;
    GemsConnectionNode m_cn;
    TopicConnection m_connection = null;
    TopicSubscriber m_subscriber = null;
    Topic m_topic = null;
    Timer m_timer = new Timer(Gems.getGems().getMsgReadDelay(), new RefreshTimerAction());
    protected String m_selector = "";
    protected JTextField m_conn;
    protected JTextField m_dest;
    protected JButton m_destwiz;
    protected JTextField m_msgsRead;
    protected JTextField m_msgsDisplay;
    protected JButton m_startButton;
    protected JButton m_stopButton;
    protected JCheckBox m_noLimit;
    protected JCheckBox m_incJMSMsg;
    protected JMenuItem m_selectorMenuItem;
    JTable m_table;
    protected GemsMonitorDestMessageTableModel m_tableModel;
    protected boolean m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
    protected JMenuItem m_optMenuItem;
    protected JMenuItem m_dumpMenuItem;
    protected JMenuItem m_dumpJMSMenuItem;
    TableSorter m_sorter;
    protected JComboBox m_eventType;

    public GemsDestMonitor(GemsConnectionNode cn, String dest, boolean isQueue, String title) {
        super(Gems.getGems().getTitlePrefix() + title);
        this.setLocation(600, 175);
        this.setDefaultCloseOperation(2);
        this.m_frame = this;
        this.m_cn = cn;
        this.m_isQueue = isQueue;
        String prefix = isQueue ? "Queue" : "Topic";
        this.m_tableModel = new GemsMonitorDestMessageTableModel(false, false);
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 15);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JPanel qpanel = new JPanel(true);
        qpanel.setLayout(new BoxLayout(qpanel, 0));
        JLabel l2 = new JLabel(prefix + " To Monitor:", 11);
        this.m_dest = new JTextField(dest, 30);
        l2.setLabelFor(this.m_dest);
        panel.add(l2);
        qpanel.add(this.m_dest);
        this.m_destwiz = new JButton("...");
        this.m_destwiz.setPreferredSize(new Dimension(18, 16));
        this.m_destwiz.addActionListener(new DestinationWizardAction());
        qpanel.add(this.m_destwiz);
        panel.add(qpanel);
        JPanel mpanel = new JPanel(true);
        mpanel.setLayout(new BoxLayout(mpanel, 0));
        JLabel l9 = new JLabel("Events to Read:", 11);
        this.m_msgsRead = new JTextField("10", 20);
        this.m_msgsRead.setMinimumSize(new Dimension(40, 24));
        l9.setLabelFor(this.m_msgsRead);
        panel.add(l9);
        panel.add(this.m_msgsRead);
        this.m_noLimit = new JCheckBox("No Limit", false);
        JPanel spanel = new JPanel(true);
        spanel.setLayout(new BoxLayout(spanel, 0));
        JLabel l4 = new JLabel("Event Type:", 11);
        this.m_eventType = new JComboBox();
        l4.setLabelFor(this.m_eventType);
        for (EVENT_TYPE dm : EVENT_TYPE.values()) {
            this.m_eventType.addItem(dm);
        }
        this.m_eventType.setSelectedItem((Object)EVENT_TYPE.All);
        JLabel l5 = new JLabel("", 11);
        this.m_incJMSMsg = new JCheckBox("Include JMS Msgs:", false);
        this.m_incJMSMsg.setHorizontalTextPosition(2);
        l5.setLabelFor(this.m_incJMSMsg);
        panel.add(l4);
        spanel.add(this.m_eventType);
        spanel.add(l5);
        spanel.add(this.m_incJMSMsg);
        panel.add(spanel);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.setSelectionMode(0);
        this.m_tableModel.m_table = this.m_table;
        this.addMouseListenerToTable(this.m_table);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(650, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(350, 10));
        bpanel.add(bx);
        this.m_startButton = new JButton("Start");
        this.m_startButton.addActionListener(new StartPressed());
        this.m_stopButton = new JButton("Stop");
        this.m_stopButton.addActionListener(new StopPressed());
        this.m_stopButton.setEnabled(false);
        bpanel.add(this.m_startButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_stopButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 2, 4, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.pack();
        this.show();
    }

    public void start() {
        if (this.m_dest.getText().length() == 0 || this.m_dest.getText().equals(">")) {
            JOptionPane.showMessageDialog(this.m_frame, "Invalid destination", "Error", 1);
            return;
        }
        this.m_events = 0;
        this.m_running = true;
        this.m_dest.setEnabled(false);
        this.m_msgsRead.setEnabled(false);
        this.m_startButton.setEnabled(false);
        this.m_stopButton.setEnabled(true);
        this.m_noLimit.setEnabled(false);
        this.m_incJMSMsg.setEnabled(false);
        this.m_destwiz.setEnabled(false);
        this.m_optMenuItem.setEnabled(false);
        this.m_dumpMenuItem.setEnabled(false);
        this.m_dumpJMSMenuItem.setEnabled(false);
        this.m_selectorMenuItem.setEnabled(false);
        this.m_eventType.setEnabled(false);
        try {
            this.m_maxMsgs = Integer.parseInt(this.m_msgsRead.getText());
        }
        catch (Exception ie) {
            this.m_maxMsgs = 10;
        }
        if (this.m_maxMsgs > Gems.getGems().getMaxMonitorEvents()) {
            JOptionPane.showMessageDialog(this.m_frame, "Max monitor events is " + Gems.getGems().getMaxMonitorEvents(), "Error", 1);
            this.m_maxMsgs = Gems.getGems().getMaxMonitorEvents();
            this.m_msgsRead.setText(String.valueOf(this.m_maxMsgs));
        }
        this.m_tableModel.buildColumnHeaders();
        try {
            TibjmsTopicConnectionFactory factory = new TibjmsTopicConnectionFactory(this.m_cn.m_url, null, this.m_cn.m_sslParams);
            this.m_connection = factory.createTopicConnection(this.m_cn.m_user, this.m_cn.m_password);
            this.m_session = this.m_connection.createTopicSession(false, 1);
            String d = "$sys.monitor.";
            d = this.m_isQueue ? (this.m_incJMSMsg.isSelected() ? d + "Q." : d + "q.") : (this.m_incJMSMsg.isSelected() ? d + "T." : d + "t.");
            d = this.m_eventType.getSelectedItem() == EVENT_TYPE.All ? d + "*." : (this.m_eventType.getSelectedItem() == EVENT_TYPE.Receive ? d + "r." : (this.m_eventType.getSelectedItem() == EVENT_TYPE.Send ? d + "s." : (this.m_eventType.getSelectedItem() == EVENT_TYPE.Acknowledge ? d + "a." : (this.m_eventType.getSelectedItem() == EVENT_TYPE.PrematureExit ? d + "p." : d + "*."))));
            this.m_topic = this.m_session.createTopic(d + this.m_dest.getText());
            this.m_subscriber = this.m_selector != null && this.m_selector.length() > 0 ? this.m_session.createSubscriber(this.m_topic, this.m_selector, false) : this.m_session.createSubscriber(this.m_topic);
            this.m_connection.start();
            this.m_timer.start();
        }
        catch (JMSException e) {
            JOptionPane.showMessageDialog(this.m_frame, e.getMessage(), "Error", 1);
            this.stop();
        }
    }

    public void stop() {
        this.m_timer.stop();
        this.m_running = false;
        try {
            if (this.m_subscriber != null) {
                this.m_subscriber.close();
                this.m_subscriber = null;
            }
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (JMSException e) {
            System.err.println("Exception: " + e.getMessage());
        }
        this.m_dest.setEnabled(true);
        this.m_msgsRead.setEnabled(true);
        this.m_startButton.setEnabled(true);
        this.m_stopButton.setEnabled(false);
        this.m_noLimit.setEnabled(true);
        this.m_incJMSMsg.setEnabled(true);
        this.m_destwiz.setEnabled(true);
        this.m_optMenuItem.setEnabled(true);
        this.m_dumpMenuItem.setEnabled(true);
        this.m_dumpJMSMenuItem.setEnabled(true);
        this.m_selectorMenuItem.setEnabled(true);
        this.m_eventType.setEnabled(true);
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GemsDestMonitor.this.showMessageFrame();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        this.m_dumpMenuItem = new JMenuItem("Save Monitor Events To File...");
        this.m_dumpMenuItem.addActionListener(new DumpToFile(false));
        menu.add(this.m_dumpMenuItem);
        this.m_dumpJMSMenuItem = new JMenuItem("Save JMS Messages To File...");
        this.m_dumpJMSMenuItem.addActionListener(new DumpToFile(true));
        menu.add(this.m_dumpJMSMenuItem);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsDestMonitor.this.dispose();
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menu.add(menuItem);
        menu.addSeparator();
        this.m_selectorMenuItem = menu.add(new JMenuItem("Selector..."));
        this.m_selectorMenuItem.addActionListener(new SelectorWizardAction());
        this.m_optMenuItem = menu.add(new JMenuItem("Options..."));
        this.m_optMenuItem.addActionListener(new EditOptionsAction());
        menuBar.add(menu);
        menu = new JMenu("Message");
        menu.setMnemonic(77);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("View Monitor Event..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsDestMonitor.this.showMessageFrame();
            }
        });
        menuItem = menu.add(new JMenuItem("View JMS Message..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsDestMonitor.this.showOrigMessageFrame();
            }
        });
        return menuBar;
    }

    public void showMessageFrame() {
        Message m = this.m_tableModel.getSelectedMessage();
        if (m != null) {
            GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, null, true, null, true);
            f.populate(m);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "Select a Monitor Event to view!", "View Event", 1);
        }
    }

    public void showOrigMessageFrame() {
        Message m = this.m_tableModel.getSelectedMessage();
        if (m != null && m instanceof MapMessage) {
            try {
                MapMessage mapMsg = (MapMessage)m;
                if (mapMsg.itemExists("message_bytes")) {
                    Message msg = Tibjms.createFromBytes((byte[])mapMsg.getBytes("message_bytes"));
                    GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, null, false, null, false);
                    f.populate(msg);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(null, "There is no JMS message associated with this monitor event message", "Error", 1);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "Select a Message to view!", "View Message", 1);
        }
    }

    void dumpJMSMsgsToFile(File f) throws IOException {
        FileOutputStream fout = new FileOutputStream(f, true);
        PrintStream p = new PrintStream(fout);
        int count = 0;
        for (int r = 0; r < this.m_tableModel.getRowCount(); ++r) {
            String id;
            Message m;
            int row = r;
            if (!this.m_viewoldestFirst) {
                row = this.m_table.getRowCount() - r - 1;
            }
            if ((m = (Message)this.m_tableModel.m_msgs.get(id = this.m_tableModel.m_showCheckbox ? (String)this.m_tableModel.getValueAt(row, 1) : (String)this.m_tableModel.getValueAt(row, 0))) == null || !(m instanceof MapMessage)) continue;
            try {
                Message msg;
                MapMessage mapMsg = (MapMessage)m;
                if (!mapMsg.itemExists("message_bytes") || (msg = Tibjms.createFromBytes((byte[])mapMsg.getBytes("message_bytes"))) == null) continue;
                this.m_tableModel.writeMessage(msg, p);
                ++count;
                continue;
            }
            catch (Exception ie) {
                System.err.println("Exception: " + ie.getMessage());
            }
        }
        if (count == 0) {
            JOptionPane.showMessageDialog(null, "There are no JMS messages to save", "Error", 1);
        }
        p.close();
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    class DumpToFile
    implements ActionListener {
        boolean m_jms = false;

        public DumpToFile(boolean jms) {
            this.m_jms = jms;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setApproveButtonText("Save");
                if (this.m_jms) {
                    chooser.setDialogTitle("Save JMS Messages To File (appends)");
                } else {
                    chooser.setDialogTitle("Save Events To File (appends)");
                }
                int returnVal = chooser.showOpenDialog(GemsDestMonitor.this.m_frame);
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    if (this.m_jms) {
                        GemsDestMonitor.this.dumpJMSMsgsToFile(f);
                    } else {
                        GemsDestMonitor.this.m_tableModel.dumpMsgsToFile(f, GemsDestMonitor.this.m_viewoldestFirst);
                    }
                }
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(GemsDestMonitor.this.m_frame, ie.getMessage(), "Error", 1);
                return;
            }
        }
    }

    class SelectorWizardAction
    implements ActionListener {
        SelectorWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestMonitorSelectorDialog dp = new GemsDestMonitorSelectorDialog((Frame)GemsDestMonitor.this.m_frame, "Selector Editor:");
            String s = dp.getSelector(GemsDestMonitor.this.m_selector);
            if (!dp.m_cancelled) {
                GemsDestMonitor.this.m_selector = s;
            }
        }
    }

    class DestinationWizardAction
    implements ActionListener {
        DestinationWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsDestMonitor.this.m_frame, GemsDestMonitor.this.m_cn, GemsDestMonitor.this.m_isQueue ? GemsDestination.DEST_TYPE.Queue : GemsDestination.DEST_TYPE.Topic);
            if (dp.m_retDest != null) {
                GemsDestMonitor.this.m_dest.setText(dp.m_retDest.m_destName);
            }
        }
    }

    class EditOptionsAction
    implements ActionListener {
        EditOptionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new GemsBrowserOptionsDialog((Frame)GemsDestMonitor.this.m_frame, "Edit Options");
            GemsDestMonitor.this.m_timer.setDelay(Gems.getGems().getMsgReadDelay());
            GemsDestMonitor.this.m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
        }
    }

    class StopPressed
    implements ActionListener {
        StopPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestMonitor.this.stop();
        }
    }

    class StartPressed
    implements ActionListener {
        StartPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestMonitor.this.start();
        }
    }

    class RefreshTimerAction
    implements ActionListener {
        long m_checkBacklogCount = 0L;

        RefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsDestMonitor.this.m_running) {
                try {
                    Message message = GemsDestMonitor.this.m_subscriber.receiveNoWait();
                    if (message != null) {
                        GemsDestMonitor.this.m_tableModel.addMessage(message, GemsDestMonitor.this.m_viewoldestFirst);
                        if (!GemsDestMonitor.this.m_noLimit.isSelected() && ++GemsDestMonitor.this.m_events >= GemsDestMonitor.this.m_maxMsgs) {
                            GemsDestMonitor.this.stop();
                        }
                    }
                    if (Gems.getGems().getMaxMonitorBacklog() > 0L && ++this.m_checkBacklogCount >= (long)(5000 / Gems.getGems().getMsgReadDelay())) {
                        long backlog = 0L;
                        backlog = GemsDestMonitor.this.m_cn.getTopicConsumerBacklog(GemsDestMonitor.this.m_topic.getTopicName());
                        if (backlog > Gems.getGems().getMaxMonitorBacklog()) {
                            GemsDestMonitor.this.stop();
                            JOptionPane.showMessageDialog(GemsDestMonitor.this.m_frame, "A consumer for monitor topic " + GemsDestMonitor.this.m_topic.getTopicName() + "\nhas a pending backlog of " + backlog + " messages, monitor will stop.", "Error", 1);
                        }
                        this.m_checkBacklogCount = 0L;
                    }
                }
                catch (JMSException ex) {
                    System.err.println("Exception: " + ex.getMessage());
                    GemsDestMonitor.this.stop();
                }
            }
        }
    }

    public static enum EVENT_TYPE {
        All,
        Receive,
        Send,
        Acknowledge,
        PrematureExit;

    }
}

