/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsDetailsTableModel;
import com.tibco.gems.GemsQueueNode;
import com.tibco.gems.GemsTopicNode;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.PopupDestPropTableHandler;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.admin.QueueInfo;
import com.tibco.tibjms.admin.TopicInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class GemsDestPropEditor
extends JDialog {
    JFrame m_frame;
    JPanel m_panel;
    GemsConnectionNode m_cn;
    protected String m_type;
    protected JTextField m_conn;
    protected JTextField m_dest;
    protected JButton m_closeButton;
    protected JButton m_refreshButton;
    protected JButton m_lookup;
    protected JLabel m_warn;
    protected JLabel m_text;
    JTable m_table;
    protected GemsDetailsTableModel m_tableModel;
    TableSorter m_sorter;

    public GemsDestPropEditor(JFrame f, GemsConnectionNode cn, String type, String dest) {
        super(f, Gems.getGems().getTitlePrefix() + type + " Property Editor", true);
        this.setLocationRelativeTo(f);
        this.setDefaultCloseOperation(2);
        this.m_frame = f;
        this.m_cn = cn;
        this.m_type = type;
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 20);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JPanel spanel = new JPanel(true);
        spanel.setLayout(new BoxLayout(spanel, 0));
        spanel.setMinimumSize(new Dimension(300, 24));
        JLabel l5 = new JLabel(type + ":", 11);
        this.m_dest = new JTextField(dest, 32);
        this.m_dest.addKeyListener(new SubmitListener());
        if (Gems.getGems().getViewOnlyMode() && (this.m_type.equals("Queue") && cn.getQueueNamePattern().length() > 1 || this.m_type.equals("Topic") && cn.getTopicNamePattern().length() > 1)) {
            this.m_dest.setEditable(false);
        }
        l5.setLabelFor(this.m_dest);
        panel.add(l5);
        spanel.add(this.m_dest);
        this.m_lookup = new JButton("...");
        this.m_lookup.addActionListener(new LookupAction());
        spanel.add(this.m_lookup);
        panel.add(spanel);
        this.m_warn = new JLabel("", 11);
        this.m_text = new JLabel(" ", 2);
        panel.add(this.m_warn);
        panel.add(this.m_text);
        this.m_tableModel = new GemsDetailsTableModel();
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_tableModel.setPopupHandler(new PopupDestPropTableHandler(this.m_table, this.m_tableModel, this));
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_tableModel.setTable(this.m_table);
        this.m_table.setSelectionMode(0);
        if (!Gems.getGems().getViewOnlyMode()) {
            this.addMouseListenerToTable(this.m_table);
        }
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(635, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(225, 10));
        bpanel.add(bx);
        this.m_refreshButton = new JButton("Refresh");
        this.m_refreshButton.addActionListener(new RefreshPressed());
        bpanel.add(this.m_refreshButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        this.m_closeButton = new JButton("Close");
        this.m_closeButton.addActionListener(new ClosePressed());
        bpanel.add(this.m_closeButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 3, 2, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.getProperties();
        this.pack();
        this.show();
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GemsDestPropEditor.this.editSelectedProperty();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsDestPropEditor.this.dispose();
            }
        });
        if (!Gems.getGems().getViewOnlyMode()) {
            menu = new JMenu("Edit");
            menu.setMnemonic(69);
            menuBar.add(menu);
            menuItem = new JMenuItem("Edit Property...");
            menuItem.addActionListener(new EditPropAction());
            menu.add(menuItem);
        }
        return menuBar;
    }

    public void editSelectedProperty() {
        this.editProperty(this.m_tableModel.getSelectedCol1());
    }

    public void editRowProperty(int row) {
        String p = (String)this.m_table.getValueAt(row, 0);
        this.editProperty(p);
    }

    public void editProperty(String p) {
        if (this.m_type.equals("Queue")) {
            GemsQueueNode.setProperty(this.m_frame, this.m_cn, p, this.m_dest.getText());
        } else {
            GemsTopicNode.setProperty(this.m_frame, this.m_cn, p, this.m_dest.getText());
        }
        this.getProperties();
    }

    public void getProperties() {
        if (this.m_dest.getText().length() == 0) {
            return;
        }
        if (this.m_type.equals("Queue")) {
            QueueInfo qi = this.m_tableModel.populateQueueInfo(this.m_cn, this.m_dest.getText());
            if (qi != null && (qi.getMaxMsgs() > 0L && qi.getPendingMessageCount() >= qi.getMaxMsgs() || qi.getMaxBytes() > 0L && qi.getPendingMessageSize() >= qi.getMaxBytes())) {
                this.m_text.setText("<html><FONT COLOR=RED>Warning PendingMsgCount/Size has reached MaxMsgs/Bytes limit");
            } else if (this.m_cn.getLargeDestCount() > 0L && qi.getPendingMessageCount() >= this.m_cn.getLargeDestCount() || this.m_cn.getLargeDestMemory() > 0L && qi.getPendingMessageSize() >= this.m_cn.getLargeDestMemory()) {
                this.m_text.setText("<html><FONT COLOR=RED>Warning PendingMsgCount/Size has reached server's large destination limit");
            } else {
                this.m_text.setText(" ");
            }
        } else {
            TopicInfo ti = this.m_tableModel.populateTopicInfo(this.m_cn, this.m_dest.getText());
            if (ti != null && (ti.getMaxMsgs() > 0L && ti.getPendingMessageCount() >= ti.getMaxMsgs() || ti.getMaxBytes() > 0L && ti.getPendingMessageSize() >= ti.getMaxBytes())) {
                this.m_text.setText("<html><FONT COLOR=RED>Warning PendingMsgCount/Size has reached MaxMsgs/Bytes limit");
            } else if (this.m_cn.getLargeDestCount() > 0L && ti.getPendingMessageCount() >= this.m_cn.getLargeDestCount() || this.m_cn.getLargeDestMemory() > 0L && ti.getPendingMessageSize() >= this.m_cn.getLargeDestMemory()) {
                this.m_text.setText("<html><FONT COLOR=RED>Warning PendingMsgCount/Size has reached server's large destination limit");
            } else {
                this.m_text.setText(" ");
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    class EditPropAction
    implements ActionListener {
        EditPropAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestPropEditor.this.editSelectedProperty();
        }
    }

    class LookupAction
    implements ActionListener {
        LookupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsDestPropEditor.this.m_frame, GemsDestPropEditor.this.m_cn, GemsDestPropEditor.this.m_type.equals("Queue") ? GemsDestination.DEST_TYPE.Queue : GemsDestination.DEST_TYPE.Topic);
            if (dp.m_retDest != null) {
                GemsDestPropEditor.this.m_dest.setText(dp.m_retDest.m_destName);
                GemsDestPropEditor.this.getProperties();
            }
        }
    }

    public class SubmitListener
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                GemsDestPropEditor.this.getProperties();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    class RefreshPressed
    implements ActionListener {
        RefreshPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestPropEditor.this.getProperties();
        }
    }

    class ClosePressed
    implements ActionListener {
        ClosePressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestPropEditor.this.dispose();
        }
    }
}

