/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsCheckboxRenderer;
import com.tibco.tibjms.admin.DestinationInfo;
import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class GemsDestTableModel
extends DefaultTableModel {
    JTable m_table;
    boolean m_isEditable;
    boolean m_showCheckbox = false;
    Object m_obj = new Object();
    MyRenderer m_renderer = new MyRenderer();
    GemsCheckboxRenderer m_checkRenderer = new GemsCheckboxRenderer();
    SimpleDateFormat dateFormatMillis = new SimpleDateFormat("EEE MMM dd HH:mm:ss SSS zzz yyyy");

    public GemsDestTableModel(boolean editable, boolean showCheckbox) {
        this.m_isEditable = editable;
        this.m_showCheckbox = showCheckbox;
    }

    public Class getColumnClass(int columnIndex) {
        Object o = this.getValueAt(0, columnIndex);
        if (o != null) {
            return o.getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.m_showCheckbox && col < 1) {
            return true;
        }
        return this.m_isEditable;
    }

    public Vector getSelectedDestinations() {
        Vector<String> v = new Vector<String>();
        if (this.m_showCheckbox) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!((Boolean)this.m_table.getValueAt(i, 0)).booleanValue()) continue;
                v.add((String)this.m_table.getValueAt(i, 1));
            }
        }
        return v;
    }

    public void selectAllRows() {
        if (this.m_showCheckbox) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.m_table.setValueAt(new Boolean(true), i, 0);
            }
        }
    }

    public void toggleSelectedRow() {
        this.m_table.setValueAt(new Boolean((Boolean)this.m_table.getValueAt(this.m_table.getSelectedRow(), 0) == false), this.m_table.getSelectedRow(), 0);
    }

    public void buildColumnHeaders() {
        this.setRowCount(0);
        this.setColumnCount(0);
        this.m_table.setAutoResizeMode(0);
        if (Gems.getGems().getColourPendingMsgs()) {
            this.m_table.setDefaultRenderer(Long.class, this.m_renderer);
        }
        this.m_table.setDefaultRenderer(String.class, this.m_renderer);
        this.m_table.setDefaultRenderer(Boolean.class, this.m_checkRenderer);
        Object[] cols = this.m_showCheckbox ? new String[]{"Sel", "Destination", "ConsumerCount", "PendingMsgCount", "PendingMsgSize"} : new String[]{"Destination", "ConsumerCount", "PendingMsgCount", "PendingMsgSize"};
        this.setColumnIdentifiers(cols);
        if (this.m_showCheckbox) {
            this.m_table.getColumn("Sel").setPreferredWidth(30);
        }
        this.m_table.getColumn("Destination").setPreferredWidth(250);
        this.m_table.getColumn("ConsumerCount").setPreferredWidth(110);
        this.m_table.getColumn("PendingMsgCount").setPreferredWidth(120);
        this.m_table.getColumn("PendingMsgSize").setPreferredWidth(120);
    }

    public void addDestination(DestinationInfo d) {
        if (d != null) {
            if (d.getName().equals(">")) {
                return;
            }
            if (d.getName().startsWith("$sys")) {
                return;
            }
            Object[] r = this.m_showCheckbox ? new Object[]{new Boolean(false), d.getName(), new Long(d.getConsumerCount()), new Long(d.getPendingMessageCount()), new Long(d.getPendingMessageSize())} : new Object[]{d.getName(), new Long(d.getConsumerCount()), new Long(d.getPendingMessageCount()), new Long(d.getPendingMessageSize())};
            this.addRow(r);
        }
    }

    public void populateDestinationInfo(DestinationInfo[] di) {
        this.setRowCount(0);
        if (di == null) {
            return;
        }
        for (int i = 0; i < di.length; ++i) {
            this.addDestination(di[i]);
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        public MyRenderer() {
            this.setToolTipText("Select checkboxes of destinations to purge");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Long) {
                this.setHorizontalAlignment(4);
                if ((Long)value > 0L && table.getColumnName(column).startsWith("Pending")) {
                    cell.setBackground(Color.orange);
                } else if (isSelected) {
                    cell.setBackground(table.getSelectionBackground());
                } else {
                    cell.setBackground(Color.white);
                }
            } else {
                this.setHorizontalAlignment(2);
                if (isSelected) {
                    cell.setBackground(table.getSelectionBackground());
                } else {
                    cell.setBackground(Color.white);
                }
            }
            return cell;
        }
    }
}

