/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.admin.DestinationInfo;
import com.tibco.tibjms.admin.ServerInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;

public class GemsDestinationPicker
extends JDialog {
    JFrame m_frame;
    JPanel m_panel;
    GemsConnectionNode m_cn;
    GemsDestination m_retDest = null;
    protected JComboBox m_type;
    protected JTextField m_pattern;
    protected JButton m_okButton;
    protected JButton m_cancelButton;
    protected JButton m_lookup;
    JTable m_table;
    protected MyTableModel m_tableModel;
    TableSorter m_sorter;
    String m_patternInit = ">";

    public GemsDestinationPicker(JFrame f, GemsConnectionNode cn) {
        super(f, "Destination Picker (" + cn.getName() + ")", true);
        this.m_frame = f;
        this.m_cn = cn;
        this.init();
        this.pack();
        this.show();
    }

    public GemsDestinationPicker(JFrame f, GemsConnectionNode cn, GemsDestination.DEST_TYPE dt) {
        super(f, "Destination Picker (" + cn.getName() + ")", true);
        this.m_frame = f;
        this.m_cn = cn;
        if (Gems.getGems().getViewOnlyMode()) {
            this.m_patternInit = dt == GemsDestination.DEST_TYPE.Queue ? cn.getQueueNamePattern() : cn.getTopicNamePattern();
        }
        this.init();
        this.m_type.setSelectedItem((Object)dt);
        this.m_type.setEnabled(false);
        this.pack();
        this.show();
    }

    public GemsDestinationPicker(JFrame f, GemsConnectionNode cn, GemsDestination.DEST_TYPE dt, String pattern) {
        super(f, "Destination Picker (" + cn.getName() + ")", true);
        this.m_frame = f;
        this.m_cn = cn;
        this.m_patternInit = Gems.getGems().getViewOnlyMode() ? (dt == GemsDestination.DEST_TYPE.Queue ? cn.getQueueNamePattern() : cn.getTopicNamePattern()) : pattern;
        this.init();
        this.m_type.setSelectedItem((Object)dt);
        this.m_type.setEnabled(false);
        this.pack();
        this.show();
    }

    public void init() {
        this.setLocationRelativeTo(this.m_frame);
        this.setDefaultCloseOperation(2);
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Destination Type:", 11);
        this.m_type = new JComboBox();
        for (GemsDestination.DEST_TYPE dm : GemsDestination.DEST_TYPE.values()) {
            this.m_type.addItem(dm);
        }
        this.m_type.addItemListener(new DestTypeSelectAction());
        l1.setLabelFor(this.m_type);
        panel.add(l1);
        panel.add(this.m_type);
        JPanel spanel = new JPanel(true);
        spanel.setLayout(new BoxLayout(spanel, 0));
        spanel.setMinimumSize(new Dimension(200, 24));
        JLabel l5 = new JLabel(" Pattern:", 11);
        this.m_pattern = new JTextField(this.m_patternInit, 30);
        this.m_pattern.addKeyListener(new SubmitListener());
        if (this.m_patternInit.length() > 1 && Gems.getGems().getViewOnlyMode()) {
            this.m_pattern.setEditable(false);
        }
        l5.setLabelFor(this.m_pattern);
        panel.add(l5);
        spanel.add(this.m_pattern);
        this.m_lookup = new JButton("LookUp");
        this.m_lookup.addActionListener(new LookupAction());
        spanel.add(this.m_lookup);
        panel.add(spanel);
        this.m_tableModel = new MyTableModel();
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.setSelectionMode(0);
        this.addMouseListenerToTable(this.m_table);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(330, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(175, 10));
        bpanel.add(bx);
        this.m_okButton = new JButton("Ok");
        this.m_okButton.addActionListener(new OkPressed());
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.addActionListener(new CancelPressed());
        bpanel.add(this.m_okButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_cancelButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 2, 2, 5, 5, 5, 5);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsDestinationPicker.this.dispose();
            }
        });
        menu = new JMenu("View");
        menu.setMnemonic(86);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("Temp Destinations"));
        menuItem.addActionListener(new ViewTempsAction());
        menuItem = menu.add(new JMenuItem("System Destinations"));
        menuItem.addActionListener(new ViewSysAction());
        return menuBar;
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GemsDestinationPicker.this.ok();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    public DestinationInfo[] getDestinationInfo() {
        try {
            int opt;
            if (!this.m_cn.isConnected()) {
                return null;
            }
            ServerInfo si = this.m_cn.getJmsServerInfo(false);
            if (this.m_type.getSelectedItem() == GemsDestination.DEST_TYPE.Queue) {
                int opt2;
                if (si != null && si.getQueueCount() > Gems.getGems().getMaxQueues() && this.m_pattern.getText().equals(">") && (opt2 = JOptionPane.showConfirmDialog(this, "There are " + si.getQueueCount() + " queues, set a pattern to filter the number of queues. \nAre you sure you want to continue?", "Lookup Queues", 0)) != 0) {
                    return null;
                }
                return this.m_cn.getQueues(this.m_pattern.getText(), this.m_pattern.getText().startsWith("$TMP$") ? 4 : 3, true, !this.m_pattern.getText().startsWith("$TMP$") && !this.m_pattern.getText().startsWith("$sys."));
            }
            if (si != null && si.getTopicCount() > Gems.getGems().getMaxTopics() && this.m_pattern.getText().equals(">") && (opt = JOptionPane.showConfirmDialog(this, "There are " + si.getTopicCount() + " topics, set a pattern to filter the number of queues. \nAre you sure you want to continue?", "Lookup Topics", 0)) != 0) {
                return null;
            }
            return this.m_cn.getTopics(this.m_pattern.getText(), this.m_pattern.getText().startsWith("$TMP$") ? 4 : 3, true, !this.m_pattern.getText().startsWith("$TMP$") && !this.m_pattern.getText().startsWith("$sys."));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 1);
            return null;
        }
    }

    public void ok() {
        int r = this.m_table.getSelectedRow();
        if (r < 0) {
            JOptionPane.showMessageDialog(this, "No destination selected", "Error", 1);
        } else {
            String d = (String)this.m_table.getValueAt(r, 0);
            this.m_retDest = new GemsDestination(d, (GemsDestination.DEST_TYPE)((Object)this.m_type.getSelectedItem()));
            this.dispose();
        }
    }

    public void cancel() {
        this.dispose();
    }

    public void lookupDestinations() {
        this.m_tableModel.setRowCount(0);
        this.m_tableModel.setColumnCount(0);
        Object[] cols = new String[]{"Destination Name"};
        this.m_tableModel.setColumnIdentifiers(cols);
        this.populateDestinationInfo(this.getDestinationInfo());
    }

    public void populateDestinationInfo(DestinationInfo[] di) {
        this.m_tableModel.setRowCount(0);
        if (di == null) {
            return;
        }
        for (int i = 0; i < di.length; ++i) {
            this.addDestination(di[i]);
        }
    }

    public void addDestination(DestinationInfo d) {
        if (d != null) {
            if (d.getName().equals(">")) {
                return;
            }
            if (!this.m_pattern.getText().startsWith("$sys.") && d.getName().startsWith("$sys.")) {
                return;
            }
            Object[] r = new Object[]{d.getName()};
            this.m_tableModel.addRow(r);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    class MyTableModel
    extends DefaultTableModel {
        MyTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class DestTypeSelectAction
    implements ItemListener {
        DestTypeSelectAction() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                // empty if block
            }
        }
    }

    class ViewTempsAction
    implements ActionListener {
        ViewTempsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker.this.m_pattern.setText("$TMP$.>");
            GemsDestinationPicker.this.lookupDestinations();
        }
    }

    class ViewSysAction
    implements ActionListener {
        ViewSysAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker.this.m_pattern.setText("$sys.>");
            GemsDestinationPicker.this.lookupDestinations();
        }
    }

    class LookupAction
    implements ActionListener {
        LookupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker.this.lookupDestinations();
        }
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker.this.cancel();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker.this.ok();
        }
    }

    public class SubmitListener
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                GemsDestinationPicker.this.m_tableModel.setRowCount(0);
                GemsDestinationPicker.this.m_tableModel.setColumnCount(0);
                Object[] cols = new String[]{"Destination Name"};
                GemsDestinationPicker.this.m_tableModel.setColumnIdentifiers(cols);
                GemsDestinationPicker.this.populateDestinationInfo(GemsDestinationPicker.this.getDestinationInfo());
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

