/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsDetailsTableModel;
import com.tibco.gems.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class GemsDetailsPanel
extends JPanel {
    protected GemsDetailsTableModel m_tableModel;
    JTable m_table;
    TableSorter m_sorter;

    public GemsDetailsPanel(String tableModelClass) {
        super(true);
        this.setLayout(new BorderLayout());
        try {
            Class<?> c = Class.forName(tableModelClass);
            Constructor<?> cons = c.getConstructor(new Class[0]);
            this.m_tableModel = (GemsDetailsTableModel)cons.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            System.err.println("Exception building DetailsTableModel class: " + ex.getMessage());
            return;
        }
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.getTableHeader().setToolTipText("Click to specify sorting; Control-Click to specify secondary sorting");
        this.m_tableModel.setTable(this.m_table);
        this.addMouseListenerToTable(this.m_table);
        this.m_table.setSelectionMode(0);
        JScrollPane spane = new JScrollPane(this.m_table);
        this.add((Component)spane, "Center");
    }

    public GemsDetailsTableModel getModel() {
        return this.m_tableModel;
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Gems.getGems().getTreeModel().detailsPanelDoubleClick(GemsDetailsPanel.this.m_tableModel.getSelectedCol1());
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }
}

