/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsCellValue;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsService;
import com.tibco.gems.GemsServiceTable;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.GetPopupHandler;
import com.tibco.gems.MsgCellValue;
import com.tibco.gems.PopupDetailsTableHandler;
import com.tibco.gems.PopupHandler;
import com.tibco.gems.SSCellFFValue;
import com.tibco.gems.SSCellValue;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.admin.ACLEntry;
import com.tibco.tibjms.admin.AdminACLEntry;
import com.tibco.tibjms.admin.BridgeInfo;
import com.tibco.tibjms.admin.ChannelInfo;
import com.tibco.tibjms.admin.ConnectionFactoryInfo;
import com.tibco.tibjms.admin.ConnectionInfo;
import com.tibco.tibjms.admin.ConsumerInfo;
import com.tibco.tibjms.admin.DbStoreInfo;
import com.tibco.tibjms.admin.DestinationBridgeInfo;
import com.tibco.tibjms.admin.DurableInfo;
import com.tibco.tibjms.admin.FTLTransportInfo;
import com.tibco.tibjms.admin.FileStoreInfo;
import com.tibco.tibjms.admin.GroupInfo;
import com.tibco.tibjms.admin.MStoreInfo;
import com.tibco.tibjms.admin.ProducerInfo;
import com.tibco.tibjms.admin.QueueInfo;
import com.tibco.tibjms.admin.RVCMTransportInfo;
import com.tibco.tibjms.admin.RVTransportInfo;
import com.tibco.tibjms.admin.RouteInfo;
import com.tibco.tibjms.admin.SSTransportInfo;
import com.tibco.tibjms.admin.StoreInfo;
import com.tibco.tibjms.admin.SubscriptionInfo;
import com.tibco.tibjms.admin.TibjmsAdmin;
import com.tibco.tibjms.admin.TibjmsAdminException;
import com.tibco.tibjms.admin.TopicInfo;
import com.tibco.tibjms.admin.TransactionInfo;
import com.tibco.tibjms.admin.TransportInfo;
import com.tibco.tibjms.admin.UserInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class GemsDetailsTableModel
extends DefaultTableModel
implements GetPopupHandler {
    JTable m_table;
    MyRenderer m_renderer = new MyRenderer();
    Hashtable m_colWidths = null;
    boolean flag = true;
    PopupHandler m_popup = null;
    SimpleDateFormat dateFormatMillis = new SimpleDateFormat("EEE MMM dd HH:mm:ss SSS zzz yyyy");
    static String[] s_error_cols = new String[]{"Error"};
    static String[] s_info_cols = new String[]{"Info"};
    static String[] s_service_cols = new String[]{"ServiceName", "StartPeriod", "RequestCount", "ResponseCount", "AvgRequests/Min", "AvgRespTime(ms)", "MaxRespTime(ms)", "RespTimeLimit(ms)", "%WithinLimit", "OverLimitCount", "LastRequestAt"};
    static String[] s_queues_cols = new String[]{"QueueName", "PendingMsgCount", "PendingMsgSize", "ReceiverCount", "InTotalMsgs", "OutTotalMsgs", "InMsgRate", "OutMsgRate", "PendPersMsgCount", "PendPersMsgSize", "InTotalBytes", "OutTotalBytes", "InByteRate", "OutByteRate", "AvgMsgSize", "StoreName", "Static", "Routed", "RouteConnected", "RouteName"};
    static String[] s_tmp_queues_cols = new String[]{"QueueName", "ConnID", "PendingMsgCount", "PendingMsgSize", "ReceiverCount", "InTotalMsgs", "OutTotalMsgs", "InMsgRate", "OutMsgRate", "PendPersMsgCount", "PendPersMsgSize", "StoreName"};
    static String[] s_topics_cols = new String[]{"TopicName", "PendingMsgCount", "PendingMsgSize", "SubscriberCount", "InTotalMsgs", "OutTotalMsgs", "InMsgRate", "OutMsgRate", "InTotalBytes", "OutTotalBytes", "InByteRate", "OutByteRate", "AvgMsgSize", "DurableCount", "Static", "StoreName", "Global"};
    static String[] s_tmp_topics_cols = new String[]{"TopicName", "ConnID", "PendingMsgCount", "PendingMsgSize", "SubscriberCount", "InTotalMsgs", "OutTotalMsgs", "InMsgRate", "OutMsgRate", "StoreName"};
    static String[] s_conn_cols = new String[]{"ID", "Type", "Host", "Address", "Port", "ClientID", "ConsumerCount", "ProducerCount", "SessionCount", "StartTime", "UpTime", "URL", "Username", "ClientVersion", "ClientType", "isFT", "isXA", "isAdmin", "UncommittedCount", "UncommittedSize"};
    static String[] s_sys_conn_cols = new String[]{"ID", "Type", "Host", "Address", "ConsumerCount", "ProducerCount", "SessionCount", "StartTime", "UpTime", "URL", "Username", "ClientVersion", "isFT", "UncommittedCount", "UncommittedSize"};
    static String[] s_user_conn_cols = new String[]{"Username", "ConnectionCount", "SessionCount", "ConsumerCount", "ProducerCount", "isFTCount", "isAdminCount"};
    static String[] s_bridge_cols = new String[]{"SourceName", "SourceType", "Targets"};
    static String[] s_destbridge_cols = new String[]{"Source", "SourceType", "Target", "TargetType", "Selector"};
    static String[] s_storesFile_cols_old = new String[]{"StoreName", "FileName", "FileSize", "FreeSpace", "UsedSpace", "Fragmentation", "MsgSize", "MsgCount", "SyncWrites", "SwappedSize", "SwappedCount", "WriteRate", "AvgWriteTime(ms)", "WriteUsage", "DestDefrag", "SyncProgress"};
    static String[] s_storesFile_cols = new String[]{"StoreName", "StoreType", "FileName", "FileSize", "FreeSpace", "UsedSpace", "Fragmentation", "MsgSize", "MsgCount", "SyncWrites", "SwappedSize", "SwappedCount", "WriteRate", "AvgWriteTime(ms)", "WriteUsage", "DestDefrag", "SyncProgress", "DiscardScanInterval", "DiscardScanBytes", "FirstScanFinished"};
    static String[] s_storesMStore_cols_old = new String[]{"StoreName", "FileName", "FileSize", "FreeSpace", "UsedSpace", "MsgCount", "SwappedCount", "DiscardScanInterval", "DiscardScanBytes", "FirstScanFinished", "WriteRate", "AvgWriteTime(ms)", "WriteUsage"};
    static String[] s_storesDb_cols = new String[]{"StoreName", "URL", "UserName", "MsgCount", "SwappedCount", "DriverName", "DriverDialect", "AvgWriteTime(ms)", "WriteUsage"};
    static String[] s_group_cols = new String[]{"GroupName", "Description", "isExternal", "Users"};
    static String[] s_chan_cols = new String[]{"Name", "Address", "Interface", "Active", "ByteRate", "MsgRate", "TotalBytes", "TotalMsgs", "BacklogCount", "BacklogSize", "BufferedBytes", "MaxRate", "MaxTime", "TransmittedBytes", "RetransmittedBytes", "TTL", "Priority"};
    static String[] s_fact_cols = new String[]{"Aliases", "URL", "Type", "ClientID", "ConnectCount", "ConnectDelay", "ReconnectCount", "ReconnectDelay", "XA", "LB Metric", "MulticastEnabled", "MulticastDaemon"};
    static String[] s_cons_cols_old = new String[]{"ID", "CreateTime", "DestinationName", "DestinationType", "DurableName", "PendingMsgCount", "PendingMsgSize", "Selector", "ConnectionID", "SessionID", "Username", "ByteRate", "MsgRate", "TotalBytes", "TotalMsgs", "Multicast"};
    static String[] s_cons_cols = new String[]{"ID", "CreateTime", "DestinationName", "Active", "PendingMsgCount", "PendingMsgSize", "ByteRate", "MsgRate", "TotalBytes", "TotalMsgs", "MillisSinceLastSent", "MillisSinceLastAck", "UnackedMsgCount", "Selector", "Username", "ConnectionID", "SessionID", "System", "AckMode", "DestinationType", "DurableName", "Multicast"};
    static String[] s_subs_cols = new String[]{"ID", "CreateTime", "Name", "TopicName", "PendingMsgCount", "PendingMsgSize", "ConsumerCount", "Selector", "isDurable", "isShared"};
    static String[] s_route_cols = new String[]{"Name", "URL", "Connected", "ConnectionID", "Stalled", "ZoneName", "ZoneType", "InTotalMsgs", "OutTotalMsgs", "InMsgRate", "OutMsgRate", "inSelectors", "outSelectors", "Configured", "BacklogCount", "BacklogSize", "TopicPrefetch"};
    static String[] s_dur_cols = new String[]{"DurableName", "TopicName", "Active", "PendingMsgCount", "PendingMsgSize", "ClientID", "ConsumerID", "Username", "Selector", "NoLocal", "DeliveredMsgCount", "Static", "isShared"};
    static String[] s_qprop_cols = new String[]{"QueueProperty", "Value"};
    static String[] s_tprop_cols = new String[]{"TopicProperty", "Value"};
    static String[] s_jndi_cols = new String[]{"JNDI Property", "Value"};
    static String[] s_prod_cols = new String[]{"ID", "CreateTime", "DestinationName", "DestinationType", "ConnectionID", "SessionID", "Username", "ByteRate", "MsgRate", "TotalBytes", "TotalMsgs"};
    static String[] s_acl_cols = new String[]{"DestinationName", "DestinationType", "PrincipalName", "PrincipalType", "isExternal", "Permissions"};
    static String[] s_adminacl_cols = new String[]{"PrincipalName", "PrincipalType", "isExternal", "AdministrativePermissions"};
    static String[] s_user_cols = new String[]{"UserName", "Desciption", "isExternal"};
    static String[] s_transact_cols = new String[]{"State", "GlobalTransactionId", "FormatId", "BranchQualifier"};
    static String[] s_transprt_cols = new String[]{"TransportName", "Type", "QueueImportDelMode", "TopicImportDelMode", "ExportHeaders", "ExportProperties", "FurtherInfo"};
    static String[] s_client_cols = new String[]{"ClientID", "ConnectionID", "ConsumerCount", "ProducerCount", "SessionCount", "InTotalMsgs", "OutTotalMsgs", "InMsgRate", "OutMsgRate"};

    public void refresh() throws Exception {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GemsDetailsTableModel.this.fireTableStructureChanged();
            }
        });
    }

    public GemsDetailsTableModel() {
        this.initColumnWidths();
    }

    @Override
    public PopupHandler getPopupHandler() {
        if (this.m_popup == null) {
            this.m_popup = new PopupDetailsTableHandler(this.m_table, this);
        }
        return this.m_popup;
    }

    public void setPopupHandler(PopupHandler pop) {
        this.m_popup = pop;
    }

    public void setTable(JTable table) {
        this.m_table = table;
        if (Gems.getGems().getColourPendingMsgs()) {
            this.m_table.setDefaultRenderer(new Long(1L).getClass(), this.m_renderer);
            this.m_table.setDefaultRenderer(new Object().getClass(), this.m_renderer);
            this.m_table.setDefaultRenderer(new MsgCellValue(0L).getClass(), this.m_renderer);
            this.m_table.setDefaultRenderer(new GemsCellValue("").getClass(), this.m_renderer);
        }
    }

    public Class getColumnClass(int c) {
        Object v = this.getValueAt(0, c);
        if (v != null) {
            if (v instanceof MsgCellValue) {
                return new Long(0L).getClass();
            }
            if (v instanceof GemsCellValue) {
                return new String().getClass();
            }
            return v.getClass();
        }
        return new String().getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public String getSelectedCol1() {
        if (this.m_table.getSelectedRow() < 0) {
            return null;
        }
        if (this.getColumnCount() == 1 && this.getColumnName(0).equals("Error")) {
            return null;
        }
        Object val = this.m_table.getValueAt(this.m_table.getSelectedRow(), 0);
        if (val instanceof Long) {
            return String.valueOf((Long)val);
        }
        return (String)val;
    }

    public String getSelectedCol(int col) {
        if (this.m_table.getSelectedRow() < 0) {
            return null;
        }
        Object val = this.m_table.getValueAt(this.m_table.getSelectedRow(), col - 1);
        if (val instanceof Long) {
            return String.valueOf((Long)val);
        }
        return (String)val;
    }

    public int getSelectedRow() {
        return this.m_table.getSelectedRow();
    }

    public void maintainSelection(int row, String col1) {
        if (row < 0 || row >= this.m_table.getRowCount()) {
            return;
        }
        Object v = this.m_table.getValueAt(row, 0);
        String val = v instanceof Long ? String.valueOf((Long)v) : (String)v;
        if (val.equals(col1)) {
            this.m_table.addRowSelectionInterval(row, row);
        }
    }

    public void selectRow(String col1) {
        for (int i = 0; i < this.m_table.getRowCount(); ++i) {
            Object v = this.m_table.getValueAt(i, 0);
            if (v == null || !(v instanceof Long) || !col1.equals(String.valueOf(v))) continue;
            this.m_table.addRowSelectionInterval(i, i);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(i, 0, false));
            return;
        }
    }

    public void populateErrorInfo(String error) {
        this.setRowCount(0);
        this.setColumnCount(0);
        this.m_table.setAutoResizeMode(4);
        this.setColumnIdentifiers(s_error_cols);
        this.addRow(new Object[]{error});
    }

    public void populateInfo(String info) {
        this.setRowCount(0);
        this.setColumnCount(0);
        this.m_table.setAutoResizeMode(4);
        this.setColumnIdentifiers(s_info_cols);
        this.addRow(new Object[]{info});
    }

    public void populateServiceInfo(GemsServiceTable st) {
        if (st == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 11 || !this.getColumnName(0).equals("ServiceName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_service_cols);
            this.setupColumnWidths();
        }
        try {
            Enumeration e = st.m_services.keys();
            while (e.hasMoreElements()) {
                GemsService s = (GemsService)st.m_services.get(e.nextElement());
                Date d = new Date();
                Date d1 = new Date();
                d.setTime(s.m_started);
                d1.setTime(s.m_lastRequest);
                long n = System.currentTimeMillis();
                double avg = 0.0;
                double mins = (double)(n - s.m_started) / 60000.0;
                if (mins >= 1.0) {
                    avg = (double)s.m_hits / mins;
                }
                double avgl = 0.0;
                if (s.m_responses > 0L) {
                    avgl = (double)s.m_totalLatency / (double)s.m_responses;
                }
                double pl = 100.0;
                if (s.m_responses > 0L) {
                    pl -= (double)s.m_overLimitCount / (double)s.m_responses * 100.0;
                }
                Object[] r = new Object[]{s.m_name, st.m_running ? d.toString() : "Disabled", new Long(s.m_hits), new Long(s.m_responses), new Double(avg), new Double(avgl), new Long(s.m_maxLatency), new Long(s.m_respLimit), new Double(pl), new Long(s.m_overLimitCount), s.m_lastRequest > 0L ? this.dateFormatMillis.format(d1).toString() : ""};
                this.addRow(r);
            }
        }
        catch (Exception e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateQueuesInfo(GemsConnectionNode cn, QueueInfo[] q) {
        if (q == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 20 || !this.getColumnName(0).equals("QueueName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_queues_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(1, -1);
        }
        this.populateQueuesInfoNext(cn, q, false);
    }

    public void populateTmpQueuesInfo(GemsConnectionNode cn, QueueInfo[] q) {
        if (q == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 12 || !this.getColumnName(0).equals("QueueName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_tmp_queues_cols);
            this.setupColumnWidths();
        }
        this.populateQueuesInfoNext(cn, q, true);
    }

    public void populateQueuesInfoNext(GemsConnectionNode cn, QueueInfo[] q, boolean isTemp) {
        if (q == null) {
            return;
        }
        try {
            Object ppmc = new String("N/A");
            Object ppms = new String("N/A");
            for (int i = 0; i < q.length; ++i) {
                Object[] r;
                String isr = "?";
                String rn = "";
                String st = "";
                try {
                    isr = String.valueOf(q[i].isRouted());
                    rn = q[i].getRouteName();
                    st = q[i].getStore();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    ppmc = new Long(q[i].getPendingPersistentMessageCount());
                    ppms = new GemsCellValue(GemsUtilities.getHumanReadableSize(q[i].getPendingPersistentMessageSize()), q[i].getPendingPersistentMessageSize());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                long mm = 0L;
                long mb = 0L;
                try {
                    mm = q[i].getMaxMsgs();
                    mb = q[i].getMaxBytes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (mm <= 0L) {
                        mm = cn.getLargeDestCount();
                    } else if (cn.getLargeDestCount() > 0L && cn.getLargeDestCount() < mm) {
                        mm = cn.getLargeDestCount();
                    }
                    if (mb <= 0L) {
                        mb = cn.getLargeDestMemory();
                    } else if (cn.getLargeDestMemory() > 0L && cn.getLargeDestMemory() < mb) {
                        mb = cn.getLargeDestMemory();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!isTemp) {
                    long ams = q[i].getInboundStatistics().getTotalMessages() > 0L ? q[i].getInboundStatistics().getTotalBytes() / q[i].getInboundStatistics().getTotalMessages() : 0L;
                    r = new Object[]{q[i].getName(), new MsgCellValue(q[i].getPendingMessageCount(), mm), new GemsCellValue(GemsUtilities.getHumanReadableSize(q[i].getPendingMessageSize()), q[i].getPendingMessageSize(), (Long)1L, (Long)mb), new Long(q[i].getReceiverCount()), new Long(q[i].getInboundStatistics().getTotalMessages()), new Long(q[i].getOutboundStatistics().getTotalMessages()), new Long(q[i].getInboundStatistics().getMessageRate()), new Long(q[i].getOutboundStatistics().getMessageRate()), ppmc, ppms, new Long(q[i].getInboundStatistics().getTotalBytes()), new Long(q[i].getOutboundStatistics().getTotalBytes()), new Long(q[i].getInboundStatistics().getByteRate()), new Long(q[i].getOutboundStatistics().getByteRate()), new GemsCellValue(GemsUtilities.getHumanReadableSize(ams), ams), st, String.valueOf(q[i].isStatic()), isr, String.valueOf(q[i].isRouteConnected()), rn};
                } else {
                    Object cid = new String("");
                    try {
                        cid = new Long(q[i].connectionID());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    r = new Object[]{q[i].getName(), cid, new MsgCellValue(q[i].getPendingMessageCount(), mm), new GemsCellValue(GemsUtilities.getHumanReadableSize(q[i].getPendingMessageSize()), q[i].getPendingMessageSize(), (Long)1L, (Long)mb), new Long(q[i].getReceiverCount()), new Long(q[i].getInboundStatistics().getTotalMessages()), new Long(q[i].getOutboundStatistics().getTotalMessages()), new Long(q[i].getInboundStatistics().getMessageRate()), new Long(q[i].getOutboundStatistics().getMessageRate()), ppmc, ppms, st};
                }
                this.addRow(r);
            }
        }
        catch (Exception e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateTopicsInfo(GemsConnectionNode cn, TopicInfo[] q) {
        if (q == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 17 || !this.getColumnName(0).equals("TopicName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_topics_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(1, -1);
        }
        this.populateTopicsInfoNext(cn, q, false);
    }

    public void populateTmpTopicsInfo(GemsConnectionNode cn, TopicInfo[] q) {
        if (q == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 10 || !this.getColumnName(0).equals("TopicName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_tmp_topics_cols);
            this.setupColumnWidths();
        }
        this.populateTopicsInfoNext(cn, q, true);
    }

    public void populateTopicsInfoNext(GemsConnectionNode cn, TopicInfo[] q, boolean isTemp) {
        if (q == null) {
            return;
        }
        try {
            for (int i = 0; i < q.length; ++i) {
                Object[] r;
                String st = "";
                try {
                    st = q[i].getStore();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                long mm = 0L;
                long mb = 0L;
                try {
                    mm = q[i].getMaxMsgs();
                    mb = q[i].getMaxBytes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (mm <= 0L) {
                        mm = cn.getLargeDestCount();
                    } else if (cn.getLargeDestCount() > 0L && cn.getLargeDestCount() < mm) {
                        mm = cn.getLargeDestCount();
                    }
                    if (mb <= 0L) {
                        mb = cn.getLargeDestMemory();
                    } else if (cn.getLargeDestMemory() > 0L && cn.getLargeDestMemory() < mb) {
                        mb = cn.getLargeDestMemory();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!isTemp) {
                    long ams = q[i].getInboundStatistics().getTotalMessages() > 0L ? q[i].getInboundStatistics().getTotalBytes() / q[i].getInboundStatistics().getTotalMessages() : 0L;
                    r = new Object[]{q[i].getName(), new MsgCellValue(q[i].getPendingMessageCount(), mm), new GemsCellValue(GemsUtilities.getHumanReadableSize(q[i].getPendingMessageSize()), q[i].getPendingMessageSize(), (Long)1L, (Long)mb), new Long(q[i].getSubscriberCount()), new Long(q[i].getInboundStatistics().getTotalMessages()), new Long(q[i].getOutboundStatistics().getTotalMessages()), new Long(q[i].getInboundStatistics().getMessageRate()), new Long(q[i].getOutboundStatistics().getMessageRate()), new Long(q[i].getInboundStatistics().getTotalBytes()), new Long(q[i].getOutboundStatistics().getTotalBytes()), new Long(q[i].getInboundStatistics().getByteRate()), new Long(q[i].getOutboundStatistics().getByteRate()), new GemsCellValue(GemsUtilities.getHumanReadableSize(ams), ams), new Long(q[i].getDurableCount()), String.valueOf(q[i].isStatic()), st, String.valueOf(q[i].isGlobal())};
                } else {
                    Object cid = new String("");
                    try {
                        cid = new Long(q[i].connectionID());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    r = new Object[]{q[i].getName(), cid, new MsgCellValue(q[i].getPendingMessageCount(), mm), new GemsCellValue(GemsUtilities.getHumanReadableSize(q[i].getPendingMessageSize()), q[i].getPendingMessageSize(), (Long)1L, (Long)mb), new Long(q[i].getSubscriberCount()), new Long(q[i].getInboundStatistics().getTotalMessages()), new Long(q[i].getOutboundStatistics().getTotalMessages()), new Long(q[i].getInboundStatistics().getMessageRate()), new Long(q[i].getOutboundStatistics().getMessageRate()), st};
                }
                this.addRow(r);
            }
        }
        catch (Exception e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateConnectionInfo(GemsConnectionNode cn) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 20 || !this.getColumnName(2).equals("Host")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_conn_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(7, -1);
        }
        try {
            ConnectionInfo[] c;
            try {
                c = cn.m_adminConn.getConnections(cn.getUserNameFilter(), null);
            }
            catch (TibjmsAdminException e) {
                System.err.println("JMSException: " + e.getMessage());
                return;
            }
            catch (Throwable t) {
                c = cn.m_adminConn.getConnections();
            }
            Date d = new Date();
            for (int i = 0; c != null && i < c.length; ++i) {
                Long uc = new Long(-1L);
                String us = "?";
                String pt = "";
                try {
                    uc = new Long(c[i].getUncommittedCount());
                    us = GemsUtilities.getHumanReadableSize(new Long(c[i].getUncommittedSize()));
                    pt = String.valueOf(c[i].getPort());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                d.setTime(c[i].getStartTime());
                Object[] r = new Object[]{new Long(c[i].getID()), c[i].getType() != null ? c[i].getType() : "<unknown>", c[i].getHost() != null ? c[i].getHost() : "<unknown>", c[i].getAddress() != null ? c[i].getAddress() : "<unknown>", pt, c[i].getClientID() != null ? c[i].getClientID() : new String(), new Long(c[i].getConsumerCount()), new Long(c[i].getProducerCount()), new Long(c[i].getSessionCount()), d.toString(), GemsUtilities.getFullHumanReadableTime(c[i].getUpTime()), c[i].getURL() != null ? c[i].getURL() : "<unknown>", c[i].getUserName() != null ? c[i].getUserName() : "<unknown>", c[i].getVersionInfo() != null ? c[i].getVersionInfo().toString() : "<unknown>", c[i].getClientType() != null ? c[i].getClientType() : "<unknown>", String.valueOf(c[i].isFT()), String.valueOf(c[i].isXA()), String.valueOf(c[i].isAdmin()), uc, us};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateSystemConnectionInfo(TibjmsAdmin s) {
        if (s == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 15 || !this.getColumnName(2).equals("Host")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_sys_conn_cols);
            this.setupColumnWidths();
        }
        try {
            ConnectionInfo[] c = s.getSystemConnections();
            Date d = new Date();
            for (int i = 0; c != null && i < c.length; ++i) {
                Long uc = new Long(-1L);
                String us = "?";
                try {
                    uc = new Long(c[i].getUncommittedCount());
                    us = GemsUtilities.getHumanReadableSize(new Long(c[i].getUncommittedSize()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                d.setTime(c[i].getStartTime());
                Object[] r = new Object[]{new Long(c[i].getID()), c[i].getType() != null ? c[i].getType() : "<unknown>", c[i].getHost() != null ? c[i].getHost() : "<unknown>", c[i].getAddress(), new Long(c[i].getConsumerCount()), new Long(c[i].getProducerCount()), new Long(c[i].getSessionCount()), d.toString(), GemsUtilities.getFullHumanReadableTime(c[i].getUpTime()), c[i].getURL(), c[i].getUserName(), c[i].getVersionInfo().toString(), String.valueOf(c[i].isFT()), uc, us};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
        catch (Exception ex) {
            return;
        }
    }

    public void populateUserConnectionInfo(GemsConnectionNode cn) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 7 || !this.getColumnName(1).equals("ConnectionCount")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_user_conn_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(1, -1);
        }
        try {
            UserConn uc;
            ConnectionInfo[] c;
            try {
                c = cn.m_adminConn.getConnections(cn.getUserNameFilter(), null);
            }
            catch (Throwable t) {
                c = cn.m_adminConn.getConnections();
            }
            Hashtable<String, UserConn> ht = new Hashtable<String, UserConn>();
            for (int i = 0; c != null && i < c.length; ++i) {
                String user = c[i].getUserName();
                if (user == null || user.length() == 0) continue;
                uc = (UserConn)ht.get(user);
                if (uc != null) {
                    ++uc.m_connCount;
                    uc.m_consCount += (long)c[i].getConsumerCount();
                    uc.m_prodCount += (long)c[i].getProducerCount();
                    uc.m_sessCount += (long)c[i].getSessionCount();
                    if (c[i].isFT()) {
                        ++uc.m_ftCount;
                    }
                    if (!c[i].isAdmin()) continue;
                    ++uc.m_adminCount;
                    continue;
                }
                uc = new UserConn(user, c[i].getConsumerCount(), c[i].getProducerCount(), c[i].getSessionCount());
                if (c[i].isFT()) {
                    ++uc.m_ftCount;
                }
                if (c[i].isAdmin()) {
                    ++uc.m_adminCount;
                }
                ht.put(user, uc);
            }
            Enumeration cls = ht.elements();
            while (cls.hasMoreElements()) {
                uc = (UserConn)cls.nextElement();
                Object[] r = new Object[]{uc.m_user, new Long(uc.m_connCount), new Long(uc.m_sessCount), new Long(uc.m_consCount), new Long(uc.m_prodCount), new Long(uc.m_ftCount), new Long(uc.m_adminCount)};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
        catch (Exception ex) {
            return;
        }
    }

    public void populateBridgeInfo(GemsConnectionNode cn) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        try {
            DestinationBridgeInfo[] d = cn.m_adminConn.getDestinationBridges(0, ">");
            this.populatetDesBridgeInfo(d);
            return;
        }
        catch (Throwable e) {
            this.setRowCount(0);
            if (this.getColumnCount() != 3 || !this.getColumnName(0).equals("SourceName")) {
                this.setColumnCount(0);
                this.m_table.setAutoResizeMode(0);
                this.setColumnIdentifiers(s_bridge_cols);
                this.setupColumnWidths();
                ((TableSorter)this.m_table.getModel()).setSortingStatus(0, 1);
            }
            try {
                BridgeInfo[] c = cn.m_adminConn.getBridges();
                for (int i = 0; c != null && i < c.length; ++i) {
                    Object[] r = new Object[]{c[i].getName(), c[i].getType() == 1 ? new String("Queue") : new String("Topic"), GemsUtilities.arrayToString(c[i].getTargets())};
                    this.addRow(r);
                }
            }
            catch (TibjmsAdminException ex) {
                System.err.println("JMSException: " + ex.getMessage());
                return;
            }
            return;
        }
    }

    public void populatetDesBridgeInfo(DestinationBridgeInfo[] c) {
        if (this.getColumnCount() != 5 || !this.getColumnName(0).equals("Source")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_destbridge_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(0, 1);
        }
        for (int i = 0; c != null && i < c.length; ++i) {
            Object[] r = new Object[]{c[i].getSourceName(), c[i].getSourceType() == 1 ? new String("Queue") : new String("Topic"), c[i].getTargetName(), c[i].getTargetType() == 1 ? new String("Queue") : new String("Topic"), c[i].getSelector()};
            this.addRow(r);
        }
    }

    public void populateStoresFileInfoOld(GemsConnectionNode cn) {
        String[] st;
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 16 || !this.getColumnName(1).equals("FileName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_storesFile_cols);
            this.setupColumnWidths();
        }
        try {
            st = cn.m_adminConn.getStores();
        }
        catch (Throwable t) {
            try {
                StoreInfo si = cn.m_adminConn.getStoreInfo(2);
                Object[] r = new Object[]{"$sys.nonfailsafe", "async-msgs.db", GemsUtilities.getHumanReadableSize(si.getFileSize()), GemsUtilities.getHumanReadableSize(si.getFreeSpace()), GemsUtilities.getHumanReadableSize(si.getUsedSpace()), "N/A", GemsUtilities.getHumanReadableSize(si.getMsgBytes()), String.valueOf(si.getMsgCount()), "false", GemsUtilities.getHumanReadableSize(si.getSwappedBytes()), String.valueOf(si.getSwappedCount()), "", "", "", "", ""};
                this.addRow(r);
                si = cn.m_adminConn.getStoreInfo(1);
                r = new Object[]{"$sys.failsafe", "sync-msgs.db", GemsUtilities.getHumanReadableSize(si.getFileSize()), GemsUtilities.getHumanReadableSize(si.getFreeSpace()), GemsUtilities.getHumanReadableSize(si.getUsedSpace()), "N/A", GemsUtilities.getHumanReadableSize(si.getMsgBytes()), String.valueOf(si.getMsgCount()), "true", GemsUtilities.getHumanReadableSize(si.getSwappedBytes()), String.valueOf(si.getSwappedCount()), "", "", "", "", ""};
                this.addRow(r);
            }
            catch (TibjmsAdminException e) {
                System.err.println("JMSException: " + e.getMessage());
                return;
            }
            return;
        }
        try {
            for (int i = 0; i < st.length; ++i) {
                String s = st[i];
                StoreInfo si = cn.m_adminConn.getStoreInfo(s);
                FileStoreInfo fi = null;
                if (!(si instanceof FileStoreInfo)) continue;
                fi = (FileStoreInfo)si;
                String frag = "N/A";
                try {
                    frag = String.valueOf(fi.getFragmentation()) + "%";
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String avgwr = "N/A";
                String wruse = "N/A";
                String destfr = "N/A";
                String wrrate = "N/A";
                String syncpro = "N/A";
                try {
                    avgwr = String.valueOf(fi.getAverageWriteTime() * 1000.0);
                    wruse = String.valueOf(fi.getWriteUsage());
                    destfr = String.valueOf(fi.getDestinationDefrag());
                    wrrate = String.valueOf(fi.getWriteRate());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    syncpro = fi.getSyncProgress() == -1 ? "N/A" : String.valueOf(fi.getSyncProgress());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Object[] r = new Object[]{s, fi.getFileName(), new GemsCellValue(GemsUtilities.getHumanReadableSize(fi.getSize()), fi.getSize()), new GemsCellValue(GemsUtilities.getHumanReadableSize(fi.getNotInUseSpace()), fi.getNotInUseSpace()), new GemsCellValue(GemsUtilities.getHumanReadableSize(fi.getInUseSpace()), fi.getInUseSpace()), frag, new GemsCellValue(GemsUtilities.getHumanReadableSize(si.getMsgBytes()), si.getMsgBytes()), String.valueOf(si.getMsgCount()), String.valueOf(fi.isSynchronousWriteEnabled()), new GemsCellValue(GemsUtilities.getHumanReadableSize(si.getSwappedBytes()), si.getSwappedBytes()), String.valueOf(si.getSwappedCount()), wrrate, avgwr, wruse, destfr, syncpro};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateStoresFileInfo(GemsConnectionNode cn) {
        String[] st;
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 20 || !this.getColumnName(1).equals("StoreType")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_storesFile_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(3, -1);
        }
        try {
            st = cn.m_adminConn.getStores();
        }
        catch (Throwable t) {
            try {
                StoreInfo si = cn.m_adminConn.getStoreInfo(2);
                Object[] r = new Object[]{"$sys.nonfailsafe", "File", "async-msgs.db", GemsUtilities.getHumanReadableSize(si.getFileSize()), GemsUtilities.getHumanReadableSize(si.getFreeSpace()), GemsUtilities.getHumanReadableSize(si.getUsedSpace()), "N/A", GemsUtilities.getHumanReadableSize(si.getMsgBytes()), String.valueOf(si.getMsgCount()), "false", GemsUtilities.getHumanReadableSize(si.getSwappedBytes()), String.valueOf(si.getSwappedCount()), "", "", "", "", "", "", "", ""};
                this.addRow(r);
                si = cn.m_adminConn.getStoreInfo(1);
                r = new Object[]{"$sys.failsafe", "File", "sync-msgs.db", GemsUtilities.getHumanReadableSize(si.getFileSize()), GemsUtilities.getHumanReadableSize(si.getFreeSpace()), GemsUtilities.getHumanReadableSize(si.getUsedSpace()), "N/A", GemsUtilities.getHumanReadableSize(si.getMsgBytes()), String.valueOf(si.getMsgCount()), "true", GemsUtilities.getHumanReadableSize(si.getSwappedBytes()), String.valueOf(si.getSwappedCount()), "", "", "", "", "", "", "", ""};
                this.addRow(r);
            }
            catch (TibjmsAdminException e) {
                System.err.println("JMSException: " + e.getMessage());
                return;
            }
            return;
        }
        try {
            for (int i = 0; i < st.length; ++i) {
                Object[] r;
                String wruse;
                String avgwr;
                String s = st[i];
                StoreInfo si = cn.m_adminConn.getStoreInfo(s);
                FileStoreInfo fi = null;
                MStoreInfo mi = null;
                if (si instanceof FileStoreInfo) {
                    fi = (FileStoreInfo)si;
                    String frag = "N/A";
                    try {
                        frag = String.valueOf(fi.getFragmentation()) + "%";
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    avgwr = "N/A";
                    wruse = "N/A";
                    String destfr = "N/A";
                    String wrrate = "N/A";
                    String syncpro = "N/A";
                    try {
                        avgwr = String.valueOf(fi.getAverageWriteTime() * 1000.0);
                        wruse = String.valueOf(fi.getWriteUsage());
                        destfr = String.valueOf(fi.getDestinationDefrag());
                        wrrate = String.valueOf(fi.getWriteRate());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        syncpro = fi.getSyncProgress() == -1 ? "N/A" : String.valueOf(fi.getSyncProgress());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    r = new Object[]{s, new String("File"), fi.getFileName(), new GemsCellValue(GemsUtilities.getHumanReadableSize(fi.getSize()), fi.getSize()), new GemsCellValue(GemsUtilities.getHumanReadableSize(fi.getNotInUseSpace()), fi.getNotInUseSpace()), new GemsCellValue(GemsUtilities.getHumanReadableSize(fi.getInUseSpace()), fi.getInUseSpace()), frag, new GemsCellValue(GemsUtilities.getHumanReadableSize(si.getMsgBytes()), si.getMsgBytes()), String.valueOf(si.getMsgCount()), String.valueOf(fi.isSynchronousWriteEnabled()), new GemsCellValue(GemsUtilities.getHumanReadableSize(si.getSwappedBytes()), si.getSwappedBytes()), String.valueOf(si.getSwappedCount()), wrrate, avgwr, wruse, destfr, syncpro, "N/A", "N/A", "N/A"};
                    this.addRow(r);
                    continue;
                }
                if (!(si instanceof MStoreInfo)) continue;
                mi = (MStoreInfo)si;
                String wrrate = "N/A";
                avgwr = "N/A";
                wruse = "N/A";
                try {
                    wrrate = String.valueOf(mi.getWriteRate());
                    avgwr = String.valueOf(mi.getAverageWriteTime() * 1000.0);
                    wruse = String.valueOf(mi.getWriteUsage());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                r = new Object[]{s, new String("MStore"), mi.getFileName(), new GemsCellValue(GemsUtilities.getHumanReadableSize(fi.getSize()), fi.getSize()), new GemsCellValue(GemsUtilities.getHumanReadableSize(fi.getNotInUseSpace()), fi.getNotInUseSpace()), new GemsCellValue(GemsUtilities.getHumanReadableSize(fi.getInUseSpace()), fi.getInUseSpace()), "N/A", new GemsCellValue(GemsUtilities.getHumanReadableSize(si.getMsgBytes()), si.getMsgBytes()), String.valueOf(si.getMsgCount()), "N/A", new GemsCellValue(GemsUtilities.getHumanReadableSize(si.getSwappedBytes()), si.getSwappedBytes()), String.valueOf(si.getSwappedCount()), wrrate, avgwr, wruse, "N/A", "N/A", String.valueOf(mi.getDiscardScanInterval()), GemsUtilities.getHumanReadableSize(mi.getDiscardScanBytes()), String.valueOf(mi.isFirstScanFinished())};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateStoresMStoreInfoOld(GemsConnectionNode cn) {
        String[] st;
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 13 || !this.getColumnName(7).equals("DiscardScanInterval")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_storesMStore_cols_old);
            this.setupColumnWidths();
        }
        try {
            st = cn.m_adminConn.getStores();
        }
        catch (Throwable t) {
            return;
        }
        try {
            for (int i = 0; i < st.length; ++i) {
                String s = st[i];
                StoreInfo si = cn.m_adminConn.getStoreInfo(s);
                MStoreInfo fi = null;
                if (!(si instanceof MStoreInfo)) continue;
                fi = (MStoreInfo)si;
                String wrrate = "N/A";
                String avgwr = "N/A";
                String wruse = "N/A";
                try {
                    wrrate = String.valueOf(fi.getWriteRate());
                    avgwr = String.valueOf(fi.getAverageWriteTime() * 1000.0);
                    wruse = String.valueOf(fi.getWriteUsage());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Object[] r = new Object[]{s, fi.getFileName(), GemsUtilities.getHumanReadableSize(fi.getSize()), GemsUtilities.getHumanReadableSize(fi.getNotInUseSpace()), GemsUtilities.getHumanReadableSize(fi.getInUseSpace()), String.valueOf(si.getMsgCount()), String.valueOf(si.getSwappedCount()), String.valueOf(fi.getDiscardScanInterval()), GemsUtilities.getHumanReadableSize(fi.getDiscardScanBytes()), String.valueOf(fi.isFirstScanFinished()), wrrate, avgwr, wruse};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateStoresDbInfo(GemsConnectionNode cn) {
        String[] st;
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 9 || !this.getColumnName(5).equals("DriverName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_storesDb_cols);
            this.setupColumnWidths();
        }
        try {
            st = cn.m_adminConn.getStores();
        }
        catch (Throwable t) {
            return;
        }
        try {
            for (int i = 0; i < st.length; ++i) {
                String s = st[i];
                StoreInfo si = cn.m_adminConn.getStoreInfo(s);
                DbStoreInfo di = null;
                if (!(si instanceof DbStoreInfo)) continue;
                di = (DbStoreInfo)si;
                String avgwr = "N/A";
                String wruse = "N/A";
                try {
                    avgwr = String.valueOf(di.getAverageWriteTime() * 1000.0);
                    wruse = String.valueOf(di.getWriteUsage());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Object[] r = new Object[]{s, di.getURL(), di.getUserName(), String.valueOf(si.getMsgCount()), String.valueOf(si.getSwappedCount()), di.getDriverName(), di.getDriverDialect(), avgwr, wruse};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateGroupInfo(GemsConnectionNode cn) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 4 || !this.getColumnName(0).equals("GroupName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_group_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(0, 1);
        }
        try {
            GroupInfo[] c = cn.m_adminConn.getGroups();
            for (int i = 0; c != null && i < c.length; ++i) {
                StringBuffer u = new StringBuffer();
                UserInfo[] ui = c[i].getUsers();
                for (int j = 0; j < ui.length; ++j) {
                    if (j > 0) {
                        u.append(", ");
                    }
                    u.append(ui[j].getName());
                }
                Object[] r = new Object[]{c[i].getName(), c[i].getDescription(), String.valueOf(c[i].isExternal()), new String(u)};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateChannelsInfo(GemsConnectionNode cn) {
        ChannelInfo[] c;
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 17 || !this.getColumnName(1).equals("Address")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_chan_cols);
            this.setupColumnWidths();
        }
        try {
            c = cn.m_adminConn.getChannels();
        }
        catch (Throwable t) {
            return;
        }
        try {
            for (int i = 0; c != null && i < c.length; ++i) {
                Object[] r = new Object[]{c[i].getName(), c[i].getAddress(), c[i].getInterface(), String.valueOf(c[i].isActive()), new Long(c[i].getStatistics().getByteRate()), new Long(c[i].getStatistics().getMessageRate()), new Long(c[i].getStatistics().getTotalBytes()), new Long(c[i].getStatistics().getTotalMessages()), new Long(c[i].getBacklogCount()), GemsUtilities.getHumanReadableSize(new Long(c[i].getBacklogSize())), GemsUtilities.getHumanReadableSize(new Long(c[i].getBufferedBytes())), GemsUtilities.getHumanReadableSize(new Long(c[i].getMaxRate())), new Long(c[i].getMaxTime()), GemsUtilities.getHumanReadableSize(new Long(c[i].getTransmittedBytes())), GemsUtilities.getHumanReadableSize(new Long(c[i].getRetransmittedBytes())), new Long(c[i].getTtl()), new Long(c[i].getPriority())};
                this.addRow(r);
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            return;
        }
    }

    public void populateFactoryInfo(GemsConnectionNode cn) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 12 || !this.getColumnName(0).equals("Aliases")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_fact_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(0, 1);
        }
        try {
            ConnectionFactoryInfo[] c = cn.m_adminConn.getConnectionFactories();
            for (int i = 0; c != null && i < c.length; ++i) {
                boolean mc = false;
                String md = "";
                try {
                    mc = c[i].getMulticastEnabled();
                    md = c[i].getMulticastDaemon();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String typ = "Generic";
                if (c[i].getDestinationType() == 1) {
                    typ = "Queue";
                } else if (c[i].getDestinationType() == 2) {
                    typ = "Topic";
                }
                String met = "None";
                if (c[i].getMetric() == 1) {
                    met = "Connections";
                } else if (c[i].getMetric() == 2) {
                    met = "ByteRate";
                }
                Object[] r = new Object[]{GemsUtilities.arrayToString(c[i].getJNDINames()), c[i].getURL(), typ, c[i].getClientID(), new Long(c[i].getConnectAttemptCount()), new Long(c[i].getConnectAttemptDelay()), new Long(c[i].getReconnectAttemptCount()), new Long(c[i].getReconnectAttemptDelay()), String.valueOf(c[i].getXAType()), met, String.valueOf(mc), md};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateConsumerInfo(GemsConnectionNode cn) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 22 || !this.getColumnName(3).equals("Active")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_cons_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(4, -1);
        }
        try {
            try {
                ConsumerInfo[] c = cn.m_adminConn.getConsumers(null, cn.getUserNameFilter(), null, false, 5);
                this.addConsumerInfo(c);
            }
            catch (Throwable t) {
                this.setRowCount(0);
                ConsumerInfo[] c = cn.m_adminConn.getConsumersStatistics();
                this.addConsumerInfo(c);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void addConsumerInfo(ConsumerInfo[] c) {
        try {
            Date d = new Date();
            for (int i = 0; c != null && i < c.length; ++i) {
                String sel = "?";
                Long mpc = new Long(-1L);
                Long mps = new Long(-1L);
                try {
                    sel = c[i].getSelector();
                    mpc = new Long(c[i].getPendingMessageCount());
                    mps = new Long(c[i].getPendingMessageSize());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                boolean act = true;
                boolean sys = false;
                long lastAck = -1L;
                long lastSent = -1L;
                int ackm = 0;
                long unackCount = -1L;
                ConsumerInfo.Details cid = c[i].getDetails();
                if (cid != null) {
                    try {
                        act = cid.isActive();
                        sys = cid.isSystem();
                        lastAck = cid.getElapsedSinceLastAcknowledged();
                        lastSent = cid.getElapsedSinceLastSent();
                        ackm = cid.getSessionAcknowledgeMode();
                        unackCount = cid.getCurrentMsgCountSentByServer();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                String ackMode = ackm == 5 ? "Transacted" : (ackm == 1 ? "NoAck" : (ackm == 3 ? "DupsOk" : (ackm == 4 ? "Client" : (ackm == 2 ? "Auto" : "Unknown"))));
                d.setTime(c[i].getCreateTime());
                boolean mc = false;
                try {
                    mc = c[i].isMulticast();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String typ = "Generic";
                if (c[i].getDestinationType() == 1) {
                    typ = "Queue";
                } else if (c[i].getDestinationType() == 2) {
                    typ = "Topic";
                }
                Object[] r = new Object[]{new Long(c[i].getID()), d.toString(), c[i].getDestinationName(), String.valueOf(act), mpc, mps, new Long(c[i].getStatistics().getByteRate()), new Long(c[i].getStatistics().getMessageRate()), new Long(c[i].getStatistics().getTotalBytes()), new Long(c[i].getStatistics().getTotalMessages()), new Long(lastSent), new Long(lastAck), new Long(unackCount), sel, c[i].getUsername(), new Long(c[i].getConnectionID()), new Long(c[i].getSessionID()), String.valueOf(sys), ackMode, typ, c[i].getDurableName(), String.valueOf(mc)};
                this.addRow(r);
            }
        }
        catch (Exception e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void addSubscriptionInfo(SubscriptionInfo[] c) {
        try {
            Date d = new Date();
            for (int i = 0; c != null && i < c.length; ++i) {
                String sel = "?";
                Long mpc = new Long(-1L);
                Long mps = new Long(-1L);
                sel = c[i].getSelector();
                mpc = new Long(c[i].getPendingMessageCount());
                mps = new Long(c[i].getPendingMessageSize());
                d.setTime(c[i].getCreateTime());
                Object[] r = new Object[]{new Long(c[i].getID()), d.toString(), c[i].getName(), c[i].getTopicName(), mpc, mps, new Long(c[i].getConsumerCount()), sel, String.valueOf(c[i].isDurable()), String.valueOf(c[i].isShared())};
                this.addRow(r);
            }
        }
        catch (Exception e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateRoutesInfo(TibjmsAdmin s) {
        if (s == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 17 || !this.getColumnName(1).equals("URL")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_route_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(9, -1);
        }
        try {
            RouteInfo[] c = s.getRoutes();
            for (int i = 0; c != null && i < c.length; ++i) {
                Long bc = new Long(-1L);
                String bs = "?";
                Long tp = new Long(0L);
                try {
                    bc = new Long(c[i].getBacklogCount());
                    bs = GemsUtilities.getHumanReadableSize(new Long(c[i].getBacklogSize()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    tp = new Long(c[i].getTopicPrefetch());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                short zt = c[i].getZoneType();
                Object[] r = new Object[]{c[i].getName(), c[i].getURL(), String.valueOf(c[i].isConnected()), new Long(c[i].getConnectionID()), String.valueOf(c[i].isStalled()), c[i].getZoneName(), zt == 0 ? new String("MultiHop") : (zt == 1 ? new String("OneHop") : new String("Unknown")), new Long(c[i].getInboundStatistics().getTotalMessages()), new Long(c[i].getOutboundStatistics().getTotalMessages()), new Long(c[i].getInboundStatistics().getMessageRate()), new Long(c[i].getOutboundStatistics().getMessageRate()), GemsUtilities.arrayToString(c[i].getIncomingSelectors()), GemsUtilities.arrayToString(c[i].getOutgoingSelectors()), String.valueOf(c[i].isConfigured()), bc, bs, tp};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateDurablesInfo(TibjmsAdmin s) {
        if (s == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 13 || !this.getColumnName(0).equals("DurableName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_dur_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(3, -1);
        }
        try {
            DurableInfo[] c = s.getDurables();
            for (int i = 0; c != null && i < c.length; ++i) {
                String stat = new String();
                Long delMsgs = new Long(-1L);
                try {
                    stat = String.valueOf(c[i].isStatic());
                    delMsgs = new Long(c[i].getDeliveredMessageCount());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                boolean active = false;
                try {
                    active = c[i].isConnected();
                }
                catch (Throwable t) {
                    active = c[i].isActive();
                }
                String shared = "";
                try {
                    shared = String.valueOf(c[i].isShared());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Object[] r = new Object[]{c[i].getDurableName(), c[i].getTopicName(), String.valueOf(active), new Long(c[i].getPendingMessageCount()), new Long(c[i].getPendingMessageSize()), c[i].getClientID() != null ? c[i].getClientID() : new String(), new Long(c[i].getConsumerID()), c[i].getUserName(), c[i].getSelector(), String.valueOf(c[i].isNoLocalEnabled()), delMsgs, stat, shared};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public QueueInfo populateQueueInfo(GemsConnectionNode cn, String queue) {
        this.setRowCount(0);
        if (this.getColumnCount() != 2 || !this.getColumnName(0).equals("QueueProperty")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(2);
            this.setColumnIdentifiers(s_qprop_cols);
        }
        if (cn.m_adminConn == null) {
            return null;
        }
        QueueInfo ti = null;
        try {
            ti = cn.m_adminConn.getQueue(queue);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return null;
        }
        if (ti == null) {
            return null;
        }
        Object[] r = new String[]{"Name", queue};
        this.addRow(r);
        long mm = 0L;
        long mb = 0L;
        try {
            mm = ti.getMaxMsgs();
            mb = ti.getMaxBytes();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (mm <= 0L) {
                mm = cn.getLargeDestCount();
            } else if (cn.getLargeDestCount() > 0L && cn.getLargeDestCount() < mm) {
                mm = cn.getLargeDestCount();
            }
            if (mb <= 0L) {
                mb = cn.getLargeDestMemory();
            } else if (cn.getLargeDestMemory() > 0L && cn.getLargeDestMemory() < mb) {
                mb = cn.getLargeDestMemory();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new Object[]{"PendingMessageCount", new GemsCellValue(String.valueOf(ti.getPendingMessageCount()), ti.getPendingMessageCount(), 0L, mm, false)};
        this.addRow(r);
        r = new Object[]{"PendingMessageSize", new GemsCellValue(GemsUtilities.getHumanReadableSize(ti.getPendingMessageSize()), ti.getPendingMessageSize(), 0L, mb, false)};
        this.addRow(r);
        try {
            r = new String[]{"PendingPersistentMessageCount", String.valueOf(ti.getPendingPersistentMessageCount())};
            this.addRow(r);
            r = new String[]{"PendingPersistentMessageSize", GemsUtilities.getHumanReadableSize(ti.getPendingPersistentMessageSize())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"InboundByteRate", String.valueOf(ti.getInboundStatistics().getByteRate())};
        this.addRow(r);
        r = new String[]{"InboundMessageRate", String.valueOf(ti.getInboundStatistics().getMessageRate())};
        this.addRow(r);
        r = new String[]{"InboundTotalBytes", String.valueOf(ti.getInboundStatistics().getTotalBytes())};
        this.addRow(r);
        r = new String[]{"InboundTotalMessages", String.valueOf(ti.getInboundStatistics().getTotalMessages())};
        this.addRow(r);
        r = new String[]{"OutboundByteRate", String.valueOf(ti.getOutboundStatistics().getByteRate())};
        this.addRow(r);
        r = new String[]{"OutboundMessageRate", String.valueOf(ti.getOutboundStatistics().getMessageRate())};
        this.addRow(r);
        r = new String[]{"OutboundTotalBytes", String.valueOf(ti.getOutboundStatistics().getTotalBytes())};
        this.addRow(r);
        r = new String[]{"OutboundTotalMessages", String.valueOf(ti.getOutboundStatistics().getTotalMessages())};
        this.addRow(r);
        r = new String[]{"ConsumerCount", String.valueOf(ti.getConsumerCount())};
        this.addRow(r);
        r = new String[]{"DeliveredMessageCount", String.valueOf(ti.getDeliveredMessageCount())};
        this.addRow(r);
        r = new String[]{"InTransitMessageCount", String.valueOf(ti.getInTransitMessageCount())};
        this.addRow(r);
        r = new String[]{"MaxRedelivery", String.valueOf(ti.getMaxRedelivery())};
        this.addRow(r);
        r = new String[]{"isMaxRedeliveryInherited", String.valueOf(ti.isMaxRedeliveryInherited())};
        this.addRow(r);
        r = new String[]{"Prefetch", String.valueOf(ti.getPrefetch())};
        this.addRow(r);
        r = new String[]{"isPrefetchInherited", String.valueOf(ti.isPrefetchInherited())};
        this.addRow(r);
        r = new String[]{"ReceiverCount", String.valueOf(ti.getReceiverCount())};
        this.addRow(r);
        r = new String[]{"isExclusive", String.valueOf(ti.isExclusive())};
        this.addRow(r);
        r = new String[]{"isExclusiveInherited", String.valueOf(ti.isExclusiveInherited())};
        this.addRow(r);
        try {
            r = new String[]{"isRouted", String.valueOf(ti.isRouted())};
            this.addRow(r);
            r = new String[]{"getRouteName", ti.getRouteName()};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"isRouteConnected", String.valueOf(ti.isRouteConnected())};
        this.addRow(r);
        r = new String[]{"FlowControl", String.valueOf(ti.getFlowControlMaxBytes())};
        this.addRow(r);
        r = new String[]{"isFlowControlInherited", String.valueOf(ti.isFlowControlMaxBytesInherited())};
        this.addRow(r);
        r = new String[]{"MaxBytes", String.valueOf(ti.getMaxBytes())};
        this.addRow(r);
        r = new String[]{"isMaxBytesInherited", String.valueOf(ti.isMaxBytesInherited())};
        this.addRow(r);
        r = new String[]{"MsgTrace", String.valueOf(ti.getMsgTrace())};
        this.addRow(r);
        r = new String[]{"isMsgTraceInherited", String.valueOf(ti.isMsgTraceInherited())};
        this.addRow(r);
        r = new String[]{"isFailsafe", String.valueOf(ti.isFailsafe())};
        this.addRow(r);
        r = new String[]{"isFailsafeInherited", String.valueOf(ti.isFailsafeInherited())};
        this.addRow(r);
        r = new String[]{"isGlobal", String.valueOf(ti.isGlobal())};
        this.addRow(r);
        r = new String[]{"isGlobalInherited", String.valueOf(ti.isGlobalInherited())};
        this.addRow(r);
        r = new String[]{"isStatic", String.valueOf(ti.isStatic())};
        this.addRow(r);
        r = new String[]{"isTemporary", String.valueOf(ti.isTemporary())};
        this.addRow(r);
        r = new String[]{"isSecure", String.valueOf(ti.isSecure())};
        this.addRow(r);
        r = new String[]{"isSecureInherited", String.valueOf(ti.isSecureInherited())};
        this.addRow(r);
        r = new String[]{"isSenderName", String.valueOf(ti.isSenderName())};
        this.addRow(r);
        r = new String[]{"isSenderNameInherited", String.valueOf(ti.isSenderNameInherited())};
        this.addRow(r);
        r = new String[]{"isSenderNameEnforced", String.valueOf(ti.isSenderNameEnforced())};
        this.addRow(r);
        r = new String[]{"isSenderNameEnforcedInherited", String.valueOf(ti.isSenderNameEnforcedInherited())};
        this.addRow(r);
        try {
            r = new String[]{"ExpiryOverride", String.valueOf(ti.getExpiryOverride())};
            this.addRow(r);
            r = new String[]{"isExpiryOverrideInherited", String.valueOf(ti.isExpiryOverrideInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"OverflowPolicy", String.valueOf(ti.getOverflowPolicy())};
            this.addRow(r);
            r = new String[]{"isOverflowPolicyInherited", String.valueOf(ti.isOverflowPolicyInherited())};
            this.addRow(r);
            r = new String[]{"MaxMsgs", String.valueOf(ti.getMaxMsgs())};
            this.addRow(r);
            r = new String[]{"isMaxMsgsInherited", String.valueOf(ti.isMaxMsgsInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"JNDINames", GemsUtilities.arrayToString(ti.getJNDINames())};
        this.addRow(r);
        r = new String[]{"ImportTransports", GemsUtilities.arrayToString(ti.getImportTransports())};
        this.addRow(r);
        try {
            r = new String[]{"isImportTransportsInherited", String.valueOf(ti.isImportTransportsInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"BridgeTargets", GemsUtilities.arrayToString(ti.getBridgeTargets())};
        this.addRow(r);
        try {
            r = new String[]{"isBridgeTargetsInherited", String.valueOf(ti.isBridgeTargetsInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"Store", ti.getStore()};
            this.addRow(r);
            r = new String[]{"isStoreInherited", String.valueOf(ti.isStoreInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"RedeliveryDelay", String.valueOf(ti.getRedeliveryDelay())};
            this.addRow(r);
            r = new String[]{"isRedeliveryDelayInherited", String.valueOf(ti.isRedeliveryDelayInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (ti.isTemporary()) {
                r = new String[]{"ConnectionID", String.valueOf(ti.connectionID())};
                this.addRow(r);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ti;
    }

    public TopicInfo populateTopicInfo(GemsConnectionNode cn, String topic) {
        this.setRowCount(0);
        if (this.getColumnCount() != 2 || !this.getColumnName(0).equals("TopicProperty")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(2);
            this.setColumnIdentifiers(s_tprop_cols);
        }
        if (cn.m_adminConn == null) {
            return null;
        }
        TopicInfo ti = null;
        try {
            ti = cn.m_adminConn.getTopic(topic);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return null;
        }
        if (ti == null) {
            return null;
        }
        long mm = 0L;
        long mb = 0L;
        try {
            mm = ti.getMaxMsgs();
            mb = ti.getMaxBytes();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (mm <= 0L) {
                mm = cn.getLargeDestCount();
            } else if (cn.getLargeDestCount() > 0L && cn.getLargeDestCount() < mm) {
                mm = cn.getLargeDestCount();
            }
            if (mb <= 0L) {
                mb = cn.getLargeDestMemory();
            } else if (cn.getLargeDestMemory() > 0L && cn.getLargeDestMemory() < mb) {
                mb = cn.getLargeDestMemory();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object[] r = new String[]{"Name", topic};
        this.addRow(r);
        r = new Object[]{"PendingMessageCount", new GemsCellValue(String.valueOf(ti.getPendingMessageCount()), ti.getPendingMessageCount(), 0L, mm, false)};
        this.addRow(r);
        r = new Object[]{"PendingMessageSize", new GemsCellValue(GemsUtilities.getHumanReadableSize(ti.getPendingMessageSize()), ti.getPendingMessageSize(), 0L, mb, false)};
        this.addRow(r);
        try {
            r = new String[]{"PendingPersistentMessageCount", String.valueOf(ti.getPendingPersistentMessageCount())};
            this.addRow(r);
            r = new String[]{"PendingPersistentMessageSize", GemsUtilities.getHumanReadableSize(ti.getPendingPersistentMessageSize())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"InboundByteRate", String.valueOf(ti.getInboundStatistics().getByteRate())};
        this.addRow(r);
        r = new String[]{"InboundMessageRate", String.valueOf(ti.getInboundStatistics().getMessageRate())};
        this.addRow(r);
        r = new String[]{"InboundTotalBytes", String.valueOf(ti.getInboundStatistics().getTotalBytes())};
        this.addRow(r);
        r = new String[]{"InboundTotalMessages", String.valueOf(ti.getInboundStatistics().getTotalMessages())};
        this.addRow(r);
        r = new String[]{"OutboundByteRate", String.valueOf(ti.getOutboundStatistics().getByteRate())};
        this.addRow(r);
        r = new String[]{"OutboundMessageRate", String.valueOf(ti.getOutboundStatistics().getMessageRate())};
        this.addRow(r);
        r = new String[]{"OutboundTotalBytes", String.valueOf(ti.getOutboundStatistics().getTotalBytes())};
        this.addRow(r);
        r = new String[]{"OutboundTotalMessages", String.valueOf(ti.getOutboundStatistics().getTotalMessages())};
        this.addRow(r);
        r = new String[]{"ActiveDurableCount", String.valueOf(ti.getActiveDurableCount())};
        this.addRow(r);
        r = new String[]{"DurableCount", String.valueOf(ti.getDurableCount())};
        this.addRow(r);
        try {
            r = new String[]{"DurableSubscriptionCount", String.valueOf(ti.getDurableSubscriptionCount())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"ConsumerCount", String.valueOf(ti.getConsumerCount())};
        this.addRow(r);
        r = new String[]{"SubscriberCount", String.valueOf(ti.getSubscriberCount())};
        this.addRow(r);
        try {
            r = new String[]{"SubscriptionCount", String.valueOf(ti.getSubscriptionCount())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"FlowControl", String.valueOf(ti.getFlowControlMaxBytes())};
        this.addRow(r);
        r = new String[]{"isFlowControlInherited", String.valueOf(ti.isFlowControlMaxBytesInherited())};
        this.addRow(r);
        r = new String[]{"MaxBytes", String.valueOf(ti.getMaxBytes())};
        this.addRow(r);
        r = new String[]{"isMaxBytesInherited", String.valueOf(ti.isMaxBytesInherited())};
        this.addRow(r);
        r = new String[]{"MsgTrace", String.valueOf(ti.getMsgTrace())};
        this.addRow(r);
        r = new String[]{"isMsgTraceInherited", String.valueOf(ti.isMsgTraceInherited())};
        this.addRow(r);
        r = new String[]{"isFailsafe", String.valueOf(ti.isFailsafe())};
        this.addRow(r);
        r = new String[]{"isFailsafeInherited", String.valueOf(ti.isFailsafeInherited())};
        this.addRow(r);
        r = new String[]{"isGlobal", String.valueOf(ti.isGlobal())};
        this.addRow(r);
        r = new String[]{"isGlobalInherited", String.valueOf(ti.isGlobalInherited())};
        this.addRow(r);
        r = new String[]{"isStatic", String.valueOf(ti.isStatic())};
        this.addRow(r);
        r = new String[]{"isTemporary", String.valueOf(ti.isTemporary())};
        this.addRow(r);
        r = new String[]{"isSecure", String.valueOf(ti.isSecure())};
        this.addRow(r);
        r = new String[]{"isSecureInherited", String.valueOf(ti.isSecureInherited())};
        this.addRow(r);
        r = new String[]{"isSenderName", String.valueOf(ti.isSenderName())};
        this.addRow(r);
        r = new String[]{"isSenderNameInherited", String.valueOf(ti.isSenderNameInherited())};
        this.addRow(r);
        r = new String[]{"isSenderNameEnforced", String.valueOf(ti.isSenderNameEnforced())};
        this.addRow(r);
        r = new String[]{"isSenderNameEnforcedInherited", String.valueOf(ti.isSenderNameEnforcedInherited())};
        this.addRow(r);
        try {
            r = new String[]{"ExpiryOverride", String.valueOf(ti.getExpiryOverride())};
            this.addRow(r);
            r = new String[]{"isExpiryOverrideInherited", String.valueOf(ti.isExpiryOverrideInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"OverflowPolicy", String.valueOf(ti.getOverflowPolicy())};
            this.addRow(r);
            r = new String[]{"isOverflowPolicyInherited", String.valueOf(ti.isOverflowPolicyInherited())};
            this.addRow(r);
            r = new String[]{"MaxMsgs", String.valueOf(ti.getMaxMsgs())};
            this.addRow(r);
            r = new String[]{"isMaxMsgsInherited", String.valueOf(ti.isMaxMsgsInherited())};
            this.addRow(r);
            r = new String[]{"Prefetch", String.valueOf(ti.getPrefetch())};
            this.addRow(r);
            r = new String[]{"isPrefetchInherited", String.valueOf(ti.isPrefetchInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"JNDINames", GemsUtilities.arrayToString(ti.getJNDINames())};
        this.addRow(r);
        r = new String[]{"ImportTransports", GemsUtilities.arrayToString(ti.getImportTransports())};
        this.addRow(r);
        try {
            r = new String[]{"isImportTransportsInherited", String.valueOf(ti.isImportTransportsInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"ExportTransports", GemsUtilities.arrayToString(ti.getExportTransports())};
        this.addRow(r);
        try {
            r = new String[]{"isExportTransportsInherited", String.valueOf(ti.isExportTransportsInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        r = new String[]{"BridgeTargets", GemsUtilities.arrayToString(ti.getBridgeTargets())};
        this.addRow(r);
        try {
            r = new String[]{"isBridgeTargetsInherited", String.valueOf(ti.isBridgeTargetsInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            r = new String[]{"Channel", ti.getChannel()};
            this.addRow(r);
            r = new String[]{"isChannelInherited", String.valueOf(ti.isChannelInherited())};
            this.addRow(r);
            r = new String[]{"isMulticastEnabled", String.valueOf(ti.isMulticastEnabled())};
            this.addRow(r);
            r = new String[]{"Store", ti.getStore()};
            this.addRow(r);
            r = new String[]{"isStoreInherited", String.valueOf(ti.isStoreInherited())};
            this.addRow(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ti;
    }

    public void populateJNDIInfo(GemsConnectionNode cn, String name) {
        this.setRowCount(0);
        this.setColumnCount(0);
        this.m_table.setAutoResizeMode(2);
        Object obj = null;
        try {
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", "com.tibco.tibjms.naming.TibjmsInitialContextFactory");
            env.put("java.naming.provider.url", cn.m_url);
            env.put("java.naming.security.principal", cn.m_user);
            env.put("java.naming.security.credentials", cn.m_password);
            if (cn.m_url.startsWith("ssl:")) {
                env.put("com.tibco.tibjms.naming.security_protocol", "ssl");
                env.put("com.tibco.tibjms.naming.ssl_enable_verify_host", new Boolean("false"));
            }
            InitialContext jndiContext = new InitialContext(env);
            obj = jndiContext.lookup(name);
        }
        catch (NamingException ne) {
            this.populateErrorInfo(ne.getMessage());
            System.err.println("NamingException: " + ne.getMessage());
            return;
        }
        if (obj == null) {
            return;
        }
        this.setColumnIdentifiers(s_jndi_cols);
        try {
            Object[] r;
            if (obj instanceof Topic) {
                Topic ti = (Topic)obj;
                r = new String[]{"Object Type", "Topic"};
                this.addRow(r);
                r = new String[]{"Topic Name", ti.getTopicName()};
                this.addRow(r);
            } else if (obj instanceof Queue) {
                Queue qi = (Queue)obj;
                r = new String[]{"Object Type", "Queue"};
                this.addRow(r);
                r = new String[]{"Queue Name", qi.getQueueName()};
                this.addRow(r);
            } else if (!(obj instanceof ConnectionFactory)) {
                r = new String[]{"Object Type", obj.getClass().getName()};
                this.addRow(r);
            }
            Object aobj = cn.m_adminConn.lookup(name);
            if (aobj == null) {
                return;
            }
            if (aobj instanceof TopicInfo) {
                TopicInfo ti = (TopicInfo)aobj;
                r = new String[]{"JNDI Names", GemsUtilities.arrayToString(ti.getJNDINames()), name};
                this.addRow(r);
            } else if (aobj instanceof QueueInfo) {
                QueueInfo qi = (QueueInfo)aobj;
                r = new String[]{"JNDI Names", GemsUtilities.arrayToString(qi.getJNDINames()), name};
                this.addRow(r);
            } else if (aobj instanceof ConnectionFactoryInfo) {
                ConnectionFactoryInfo ci = (ConnectionFactoryInfo)aobj;
                if (ci.getDestinationType() == 1) {
                    r = new String[]{"Object Type", "QueueConnectionFactory"};
                    this.addRow(r);
                } else if (ci.getDestinationType() == 2) {
                    r = new String[]{"Object Type", "TopicConnectionFactory"};
                    this.addRow(r);
                } else {
                    r = new String[]{"Object Type", "GenericConnectionFactory"};
                    this.addRow(r);
                }
                r = new String[]{"JNDI Names", GemsUtilities.arrayToString(ci.getJNDINames()), name};
                this.addRow(r);
                r = new String[]{"URL", ci.getURL()};
                this.addRow(r);
            }
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
        }
    }

    public void populateProducerInfo(GemsConnectionNode cn) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 11 || !this.getColumnName(5).equals("SessionID")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_prod_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(8, -1);
        }
        try {
            ProducerInfo[] c;
            try {
                c = cn.m_adminConn.getProducersStatistics(null, cn.getUserNameFilter(), null);
            }
            catch (TibjmsAdminException e) {
                System.err.println("JMSException: " + e.getMessage());
                return;
            }
            catch (Throwable t) {
                c = cn.m_adminConn.getProducersStatistics();
            }
            Date d = new Date();
            for (int i = 0; c != null && i < c.length; ++i) {
                String cid = null;
                if (Gems.getGems().getShowClientId()) {
                    cid = cn.getClientID(c[i].getConnectionID());
                }
                if (cid == null) {
                    cid = new String();
                }
                d.setTime(c[i].getCreateTime());
                String typ = "Generic";
                if (c[i].getDestinationType() == 1) {
                    typ = "Queue";
                } else if (c[i].getDestinationType() == 2) {
                    typ = "Topic";
                }
                Object[] r = new Object[]{new Long(c[i].getID()), d.toString(), c[i].getDestinationName(), typ, new Long(c[i].getConnectionID()), new Long(c[i].getSessionID()), c[i].getUsername(), new Long(c[i].getStatistics().getByteRate()), new Long(c[i].getStatistics().getMessageRate()), new Long(c[i].getStatistics().getTotalBytes()), new Long(c[i].getStatistics().getTotalMessages())};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateACLInfo(GemsConnectionNode cn) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 6 || !this.getColumnName(2).equals("PrincipalName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_acl_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(0, 1);
        }
        try {
            ACLEntry[] a = cn.m_adminConn.getACLEntries();
            Date d = new Date();
            for (int i = 0; a != null && i < a.length; ++i) {
                Object[] r = new Object[]{a[i].getDestination().getName(), a[i].getDestination() instanceof QueueInfo ? new String("Queue") : new String("Topic"), a[i].getPrincipal().getName(), a[i].getPrincipal() instanceof UserInfo ? new String("User") : new String("Group"), String.valueOf(a[i].getPrincipal().isExternal()), a[i].getPermissions().toString()};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateAdminACLInfo(GemsConnectionNode cn) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 4 || !this.getColumnName(0).equals("PrincipalName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_adminacl_cols);
            this.setupColumnWidths();
            ((TableSorter)this.m_table.getModel()).setSortingStatus(0, 1);
        }
        try {
            Object[] a = cn.m_adminConn.getPermissions();
            Date d = new Date();
            for (int i = 0; a != null && i < a.length; ++i) {
                if (!(a[i] instanceof AdminACLEntry)) continue;
                Object[] r = new Object[]{((AdminACLEntry)a[i]).getPrincipal().getName(), ((AdminACLEntry)a[i]).getPrincipal() instanceof UserInfo ? new String("User") : new String("Group"), String.valueOf(((AdminACLEntry)a[i]).getPrincipal().isExternal()), ((AdminACLEntry)a[i]).getPermissions().toString()};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateUserInfo(TibjmsAdmin s) {
        if (s == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 3 || !this.getColumnName(0).equals("UserName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(2);
            this.setColumnIdentifiers(s_user_cols);
            ((TableSorter)this.m_table.getModel()).setSortingStatus(0, 1);
        }
        try {
            UserInfo[] c = s.getUsers();
            for (int i = 0; c != null && i < c.length; ++i) {
                Object[] r = new Object[]{String.valueOf(c[i].getName()), c[i].getDescription(), String.valueOf(c[i].isExternal())};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateTransactionInfo(TibjmsAdmin s) {
        if (s == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 4 || !this.getColumnName(1).equals("GlobalTransactionId")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_transact_cols);
            this.setupColumnWidths();
        }
        try {
            TransactionInfo[] c = s.getTransactions();
            for (int i = 0; c != null && i < c.length; ++i) {
                StringBuffer sb1 = new StringBuffer();
                StringBuffer sb2 = new StringBuffer();
                byte[] globalTxId = c[i].getGlobalTransactionId();
                for (int k = 0; k < globalTxId.length; ++k) {
                    if (globalTxId[k] >= 32 && globalTxId[k] <= 126 && globalTxId[k] != 37) {
                        sb1.append((char)globalTxId[k]);
                        continue;
                    }
                    sb1.append("%" + Byte.toString(globalTxId[k]));
                }
                byte[] branchQual = c[i].getBranchQualifier();
                for (int j = 0; j < branchQual.length; ++j) {
                    if (branchQual[j] >= 32 && branchQual[j] <= 126 && branchQual[j] != 37) {
                        sb2.append((char)branchQual[j]);
                        continue;
                    }
                    sb2.append("%" + Byte.toString(branchQual[j]));
                }
                Object[] r = new Object[]{this.TxStateToString(c[i].getState()), sb1.toString(), String.valueOf(c[i].getFormatId()), sb2.toString()};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public String TxStateToString(char s) {
        if (s == 'A') {
            return new String("Active");
        }
        if (s == 'E') {
            return new String("EndSuccess");
        }
        if (s == 'P') {
            return new String("Prepared");
        }
        if (s == 'R') {
            return new String("RollbackOnly");
        }
        if (s == 'S') {
            return new String("Suspended");
        }
        return new String("Unknown");
    }

    public void populateTransportInfo(TibjmsAdmin a) {
        if (a == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 7 || !this.getColumnName(0).equals("TransportName")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_transprt_cols);
            this.setupColumnWidths();
        }
        try {
            TransportInfo[] c = a.getTransports();
            for (int i = 0; c != null && i < c.length; ++i) {
                String s;
                block23: {
                    s = new String();
                    if (c[i] instanceof RVTransportInfo) {
                        RVTransportInfo rv = (RVTransportInfo)c[i];
                        s = s + "Service='" + rv.getService() + "', ";
                        s = s + "Network='" + rv.getNetwork() + "', ";
                        s = s + "Daemon='" + rv.getDaemon() + "', ";
                        try {
                            s = s + rv.getPolicy().toString();
                        }
                        catch (Throwable throwable) {}
                    } else if (c[i] instanceof RVCMTransportInfo) {
                        RVCMTransportInfo rv = (RVCMTransportInfo)c[i];
                        s = s + "RV Tport='" + rv.getRVTransportName() + "', ";
                        s = s + "CM Name='" + rv.getCMName() + "', ";
                        s = s + "CM Ledger='" + rv.getLedger() + "', ";
                        s = s + "Sync Ledger=" + rv.getSyncLedger() + ", ";
                        s = s + "Request Old=" + rv.getRequestOld() + ", ";
                        s = s + "Default Time Limit=" + rv.getDefaultTimeLimit() + ", ";
                        try {
                            s = s + "Explicit Config Only=" + rv.getExplicitConfigOnly() + ", ";
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            s = s + rv.getPolicy().toString();
                        }
                        catch (Throwable throwable) {}
                    } else if (c[i] instanceof SSTransportInfo) {
                        SSTransportInfo ss = (SSTransportInfo)c[i];
                        s = s + "ServerNames='" + ss.getServerNames() + "', ";
                        s = s + "Username='" + ss.getUsername() + "', ";
                        s = s + "Project='" + ss.getProject() + "', ";
                        s = s + "DeliveryMode=" + GemsDetailsTableModel.deliveryModeAsString(ss.getDeliveryMode()) + ", ";
                        s = s + "LoadBalanceMode=" + GemsDetailsTableModel.loadBalanceModeAsString(ss.getLoadBalanceMode()) + ", ";
                        s = s + "OverrideLoadBalanceMode=" + (ss.getOverrideLoadBalanceMode() ? "enabled" : "disabled") + ", ";
                        s = s + "GMDFileDelete=" + (ss.getGmdFileDelete() ? "enabled" : "disabled") + ", ";
                        s = s + "SubscribeMode=" + GemsDetailsTableModel.subscribeModeAsString(ss.getSubscribeMode()) + ", ";
                        try {
                            s = s + "ImportSSHeaders=" + GemsDetailsTableModel.importSSHeadersAsString(ss.getImportSSHeaders()) + ", ";
                            s = s + "PreserveGMD=" + GemsDetailsTableModel.preserveGMDAsString(ss.getPreserveGMD()) + "";
                        }
                        catch (Throwable throwable) {}
                    } else {
                        try {
                            if (!(c[i] instanceof FTLTransportInfo)) break block23;
                            FTLTransportInfo ftl = (FTLTransportInfo)c[i];
                            s = s + "Endpoint='" + ftl.getEndpointName() + "', ";
                            s = s + "Subscriber='" + ftl.getSubscriberName() + "', ";
                            s = s + "MatchString='" + ftl.getMatchString() + "', ";
                            Map constants = ftl.getConstants();
                            if (constants != null) {
                                for (Map.Entry entry : constants.entrySet()) {
                                    s = s + "Constant='" + (String)entry.getKey() + ":" + (String)entry.getValue() + "', ";
                                }
                            }
                            s = s + "ExportFormat='" + ftl.getExportFormat() + "']";
                        }
                        catch (Throwable t5) {
                            continue;
                        }
                    }
                }
                int t = c[i].getType();
                int topic_import = c[i].getTopicImportDeliveryMode();
                int queue_import = c[i].getQueueImportDeliveryMode();
                Object[] objectArray = new Object[7];
                objectArray[0] = c[i].getName();
                Object object = t != 0 ? (t != 1 ? (t != 2 ? (t != 3 ? (t != 4 ? "UNKNOWN" : "FTL") : "SS") : "RVCM") : "RV") : (objectArray[1] = "ALL");
                Object object2 = queue_import != 1 ? (queue_import != 2 ? (queue_import != 22 ? "UNKNOWN" : "RELIABLE") : "PERSISTENT") : (objectArray[2] = "NON_PERSISTENT");
                objectArray[3] = topic_import != 1 ? (topic_import != 2 ? (topic_import != 22 ? "UNKNOWN" : "RELIABLE") : "PERSISTENT") : "NON_PERSISTENT";
                objectArray[4] = String.valueOf(c[i].getExportHeaders());
                objectArray[5] = String.valueOf(c[i].getExportProperties());
                objectArray[6] = s;
                Object[] r = objectArray;
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    private static String deliveryModeAsString(int i) {
        switch (i) {
            case 0: {
                return "best_effort";
            }
            case 1: {
                return "some";
            }
            case 2: {
                return "all";
            }
            case 3: {
                return "ordered";
            }
            case 4: {
                return "persistent";
            }
        }
        return "unknown";
    }

    private static String loadBalanceModeAsString(int i) {
        switch (i) {
            case 0: {
                return "none";
            }
            case 1: {
                return "round_robin";
            }
            case 2: {
                return "weighted";
            }
            case 3: {
                return "sorted";
            }
        }
        return "unknown";
    }

    private static String subscribeModeAsString(int i) {
        switch (i) {
            case 0: {
                return "exact";
            }
            case 1: {
                return "all";
            }
        }
        return "unknown";
    }

    private static String importSSHeadersAsString(int i) {
        switch (i) {
            case 0: {
                return "none";
            }
            case 1: {
                return "type_num";
            }
            case 2: {
                return "all";
            }
        }
        return "unknown";
    }

    private static String preserveGMDAsString(int i) {
        switch (i) {
            case 0: {
                return "never";
            }
            case 1: {
                return "always";
            }
            case 2: {
                return "receivers";
            }
        }
        return "unknown";
    }

    public void populateStringInfo(Object[] o) {
        this.setRowCount(0);
        this.setColumnCount(0);
        if (o == null) {
            return;
        }
        this.m_table.setAutoResizeMode(2);
        this.addColumn("Info");
        for (int i = 0; i < o.length; ++i) {
            Object[] r = new String[]{o[i].toString()};
            this.addRow(r);
        }
    }

    public void populateClientsInfoOld(GemsConnectionNode cn) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 9 || !this.getColumnName(0).equals("ClientID")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            Object[] cols = new String[]{"ClientID", "ConnectionCount", "ConsumerCount", "ProducerCount", "SessionCount", "InTotalMsgs", "OutTotalMsgs", "InMsgRate", "OutMsgRate"};
            this.setColumnIdentifiers(cols);
            this.setupColumnWidths();
        }
        try {
            Client cl;
            Hashtable<String, Client> ht = new Hashtable<String, Client>();
            ConnectionInfo[] c = cn.m_adminConn.getConnections();
            for (int i = 0; c != null && i < c.length; ++i) {
                String cid = c[i].getClientID();
                if (cid == null || cid.length() == 0) continue;
                cl = (Client)ht.get(cid);
                if (cl != null) {
                    ++cl.m_connCount;
                    cl.m_consCount += (long)c[i].getConsumerCount();
                    cl.m_prodCount += (long)c[i].getProducerCount();
                    cl.m_sessCount += (long)c[i].getSessionCount();
                } else {
                    cl = new Client(cid, c[i].getConsumerCount(), c[i].getProducerCount(), c[i].getSessionCount());
                    ht.put(cid, cl);
                }
                ProducerInfo[] p = cn.m_adminConn.getProducersStatistics(new Long(c[i].getID()), null, null);
                for (int j = 0; p != null && j < p.length; ++j) {
                    if (cl == null) continue;
                    cl.m_outMsgs += p[j].getStatistics().getTotalMessages();
                    cl.m_outMsgRate += p[j].getStatistics().getMessageRate();
                }
                ConsumerInfo[] ci = cn.m_adminConn.getConsumersStatistics(new Long(c[i].getID()), null, null);
                for (int k = 0; ci != null && k < ci.length; ++k) {
                    if (cl == null) continue;
                    cl.m_inMsgs += ci[k].getStatistics().getTotalMessages();
                    cl.m_inMsgRate += ci[k].getStatistics().getMessageRate();
                }
            }
            Enumeration cls = ht.elements();
            while (cls.hasMoreElements()) {
                cl = (Client)cls.nextElement();
                Object[] r = new Object[]{cl.m_id, new Long(cl.m_connCount), new Long(cl.m_consCount), new Long(cl.m_prodCount), new Long(cl.m_sessCount), new Long(cl.m_inMsgs), new Long(cl.m_outMsgs), new Long(cl.m_inMsgRate), new Long(cl.m_outMsgRate)};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateClientsInfo(GemsConnectionNode cn) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        this.setRowCount(0);
        if (this.getColumnCount() != 9 || !this.getColumnName(0).equals("ClientID")) {
            this.setColumnCount(0);
            this.m_table.setAutoResizeMode(0);
            this.setColumnIdentifiers(s_client_cols);
            this.setupColumnWidths();
        }
        try {
            ConnectionInfo[] c = cn.m_adminConn.getConnections();
            for (int i = 0; c != null && i < c.length; ++i) {
                String cid = c[i].getClientID();
                if (cid == null || cid.length() == 0) continue;
                long m_inMsgs = 0L;
                long m_outMsgs = 0L;
                long m_inMsgRate = 0L;
                long m_outMsgRate = 0L;
                ProducerInfo[] p = cn.m_adminConn.getProducersStatistics(new Long(c[i].getID()), null, null);
                for (int j = 0; p != null && j < p.length; ++j) {
                    m_outMsgs += p[j].getStatistics().getTotalMessages();
                    m_outMsgRate += p[j].getStatistics().getMessageRate();
                }
                ConsumerInfo[] ci = cn.m_adminConn.getConsumersStatistics(new Long(c[i].getID()), null, null);
                for (int k = 0; ci != null && k < ci.length; ++k) {
                    m_inMsgs += ci[k].getStatistics().getTotalMessages();
                    m_inMsgRate += ci[k].getStatistics().getMessageRate();
                }
                Object[] r = new Object[]{cid, new Long(c[i].getID()), new Long(c[i].getConsumerCount()), new Long(c[i].getProducerCount()), new Long(c[i].getSessionCount()), new Long(m_inMsgs), new Long(m_outMsgs), new Long(m_inMsgRate), new Long(m_outMsgRate)};
                this.addRow(r);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void initColumnWidths() {
        if (this.m_colWidths == null) {
            this.m_colWidths = new Hashtable();
        }
        this.m_colWidths.put(new String("UpTime"), new Integer(150));
        this.m_colWidths.put(new String("ClientID"), new Integer(150));
        this.m_colWidths.put(new String("ConnectionID"), new Integer(80));
        this.m_colWidths.put(new String("ConnectionCount"), new Integer(120));
        this.m_colWidths.put(new String("ConsumerCount"), new Integer(100));
        this.m_colWidths.put(new String("ProducerCount"), new Integer(100));
        this.m_colWidths.put(new String("SessionCount"), new Integer(100));
        this.m_colWidths.put(new String("InTotalMsgs"), new Integer(80));
        this.m_colWidths.put(new String("InMsgRate"), new Integer(70));
        this.m_colWidths.put(new String("OutTotalMsgs"), new Integer(80));
        this.m_colWidths.put(new String("OutMsgRate"), new Integer(80));
        this.m_colWidths.put(new String("OutTotalBytes"), new Integer(90));
        this.m_colWidths.put(new String("PrincipalName"), new Integer(100));
        this.m_colWidths.put(new String("PrincipalType"), new Integer(100));
        this.m_colWidths.put(new String("AdministrativePermissions"), new Integer(600));
        this.m_colWidths.put(new String("DestinationName"), new Integer(200));
        this.m_colWidths.put(new String("DestinationType"), new Integer(100));
        this.m_colWidths.put(new String("PrincipalName"), new Integer(100));
        this.m_colWidths.put(new String("Permissions"), new Integer(400));
        this.m_colWidths.put(new String("QueueName"), new Integer(275));
        this.m_colWidths.put(new String("PendingMsgCount"), new Integer(110));
        this.m_colWidths.put(new String("PendingMsgSize"), new Integer(100));
        this.m_colWidths.put(new String("PendPersMsgCount"), new Integer(120));
        this.m_colWidths.put(new String("PendPersMsgSize"), new Integer(110));
        this.m_colWidths.put(new String("ReceiverCount"), new Integer(90));
        this.m_colWidths.put(new String("RouteConnected"), new Integer(100));
        this.m_colWidths.put(new String("RouteName"), new Integer(100));
        this.m_colWidths.put(new String("TopicName"), new Integer(275));
        this.m_colWidths.put(new String("SubscriberCount"), new Integer(100));
        this.m_colWidths.put(new String("DurableCount"), new Integer(90));
        this.m_colWidths.put(new String("ID"), new Integer(50));
        this.m_colWidths.put(new String("Type"), new Integer(100));
        this.m_colWidths.put(new String("Address"), new Integer(100));
        this.m_colWidths.put(new String("ClientID"), new Integer(100));
        this.m_colWidths.put(new String("Host"), new Integer(110));
        this.m_colWidths.put(new String("ClientVersion"), new Integer(100));
        this.m_colWidths.put(new String("StartTime"), new Integer(200));
        this.m_colWidths.put(new String("SourceName"), new Integer(200));
        this.m_colWidths.put(new String("Source"), new Integer(200));
        this.m_colWidths.put(new String("SourceType"), new Integer(100));
        this.m_colWidths.put(new String("Targets"), new Integer(500));
        this.m_colWidths.put(new String("Target"), new Integer(200));
        this.m_colWidths.put(new String("TargetType"), new Integer(100));
        this.m_colWidths.put(new String("FileName"), new Integer(200));
        this.m_colWidths.put(new String("SwappedSize"), new Integer(100));
        this.m_colWidths.put(new String("SwappedCount"), new Integer(100));
        this.m_colWidths.put(new String("GroupName"), new Integer(100));
        this.m_colWidths.put(new String("Description"), new Integer(150));
        this.m_colWidths.put(new String("Users"), new Integer(500));
        this.m_colWidths.put(new String("Aliases"), new Integer(200));
        this.m_colWidths.put(new String("URL"), new Integer(200));
        this.m_colWidths.put(new String("ConnectDelay"), new Integer(100));
        this.m_colWidths.put(new String("ConnectCount"), new Integer(100));
        this.m_colWidths.put(new String("ReconnectCount"), new Integer(110));
        this.m_colWidths.put(new String("ReconnectDelay"), new Integer(110));
        this.m_colWidths.put(new String("XA"), new Integer(50));
        this.m_colWidths.put(new String("LB Metric"), new Integer(80));
        this.m_colWidths.put(new String("CreateTime"), new Integer(200));
        this.m_colWidths.put(new String("DurableName"), new Integer(100));
        this.m_colWidths.put(new String("Selector"), new Integer(180));
        this.m_colWidths.put(new String("Name"), new Integer(100));
        this.m_colWidths.put(new String("inSelectors"), new Integer(120));
        this.m_colWidths.put(new String("outSelectors"), new Integer(120));
        this.m_colWidths.put(new String("Configured"), new Integer(70));
        this.m_colWidths.put(new String("Stalled"), new Integer(60));
        this.m_colWidths.put(new String("ZoneName"), new Integer(120));
        this.m_colWidths.put(new String("ZoneType"), new Integer(120));
        this.m_colWidths.put(new String("Active"), new Integer(40));
        this.m_colWidths.put(new String("Static"), new Integer(50));
        this.m_colWidths.put(new String("Global"), new Integer(50));
        this.m_colWidths.put(new String("DeliveredMsgCount"), new Integer(110));
        this.m_colWidths.put(new String("ServiceName"), new Integer(150));
        this.m_colWidths.put(new String("StartPeriod"), new Integer(200));
        this.m_colWidths.put(new String("RequestCount"), new Integer(100));
        this.m_colWidths.put(new String("ResponseCount"), new Integer(100));
        this.m_colWidths.put(new String("AvgRequests/Min"), new Integer(110));
        this.m_colWidths.put(new String("AvgRespTime(ms)"), new Integer(110));
        this.m_colWidths.put(new String("MaxRespTime(ms)"), new Integer(110));
        this.m_colWidths.put(new String("RespTimeLimit(ms)"), new Integer(120));
        this.m_colWidths.put(new String("%WithinLimit"), new Integer(90));
        this.m_colWidths.put(new String("OverLimitCount"), new Integer(100));
        this.m_colWidths.put(new String("LastRequestAt"), new Integer(200));
        this.m_colWidths.put(new String("StoreName"), new Integer(100));
        this.m_colWidths.put(new String("BacklogCount"), new Integer(100));
        this.m_colWidths.put(new String("BacklogSize"), new Integer(100));
        this.m_colWidths.put(new String("BufferedBytes"), new Integer(100));
        this.m_colWidths.put(new String("TransmittedBytes"), new Integer(120));
        this.m_colWidths.put(new String("RetransmittedBytes"), new Integer(130));
        this.m_colWidths.put(new String("Interface"), new Integer(100));
        this.m_colWidths.put(new String("DriverName"), new Integer(150));
        this.m_colWidths.put(new String("DriverDialect"), new Integer(150));
        this.m_colWidths.put(new String("UncommittedSize"), new Integer(110));
        this.m_colWidths.put(new String("UncommittedCount"), new Integer(110));
        this.m_colWidths.put(new String("SyncWrites"), new Integer(80));
        this.m_colWidths.put(new String("Fragmentation"), new Integer(100));
        this.m_colWidths.put(new String("DiscardScanInterval"), new Integer(120));
        this.m_colWidths.put(new String("DiscardScanBytes"), new Integer(115));
        this.m_colWidths.put(new String("FirstScanFinished"), new Integer(100));
        this.m_colWidths.put(new String("State"), new Integer(150));
        this.m_colWidths.put(new String("GlobalTransactionId"), new Integer(300));
        this.m_colWidths.put(new String("FormatId"), new Integer(200));
        this.m_colWidths.put(new String("BranchQualifier"), new Integer(300));
        this.m_colWidths.put(new String("TransportName"), new Integer(100));
        this.m_colWidths.put(new String("QueueImportDelMode"), new Integer(135));
        this.m_colWidths.put(new String("TopicImportDelMode"), new Integer(130));
        this.m_colWidths.put(new String("ExportHeaders"), new Integer(95));
        this.m_colWidths.put(new String("ExportProperties"), new Integer(105));
        this.m_colWidths.put(new String("FurtherInfo"), new Integer(700));
        this.m_colWidths.put(new String("AvgWriteTime(ms)"), new Integer(110));
        this.m_colWidths.put(new String("MillisSinceLastSent"), new Integer(110));
        this.m_colWidths.put(new String("MillisSinceLastAck"), new Integer(110));
        this.m_colWidths.put(new String("UnackedMsgCount"), new Integer(110));
        this.m_colWidths.put(new String("MsgRate"), new Integer(60));
        this.m_colWidths.put(new String("ByteRate"), new Integer(60));
        this.m_colWidths.put(new String("System"), new Integer(50));
        this.m_colWidths.put(new String("Multicast"), new Integer(60));
        this.m_colWidths.put(new String("TotalBytes"), new Integer(70));
        this.m_colWidths.put(new String("TotalMsgs"), new Integer(70));
        this.m_colWidths.put(new String("isAdminCount"), new Integer(100));
        this.m_colWidths.put(new String("Username"), new Integer(100));
        this.m_colWidths.put(new String("SyncProgress"), new Integer(100));
        this.m_colWidths.put(new String("StoreType"), new Integer(80));
        this.m_colWidths.put(new String("MulticastEnabled"), new Integer(100));
        this.m_colWidths.put(new String("MulticastDaemon"), new Integer(100));
        this.m_colWidths.put(new String("TopicPrefetch"), new Integer(100));
        String colw = Gems.getGems().getDetailPaneColWidths();
        String[] colv = colw.split(",");
        for (int i = 0; i < colv.length; ++i) {
            try {
                int x = colv[i].indexOf(58);
                if (x <= 0) continue;
                String p = colv[i].substring(0, x);
                String v = colv[i].substring(x + 1);
                this.m_colWidths.put(p, Integer.valueOf(v));
                continue;
            }
            catch (NumberFormatException e) {
                System.err.println("NumberFormatException: " + e.getMessage());
                return;
            }
        }
    }

    public void setupColumnWidths() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn col = this.m_table.getColumnModel().getColumn(i);
            col.addPropertyChangeListener(new ColumnListener());
            Integer w = (Integer)this.m_colWidths.get(col.getHeaderValue());
            if (w == null) continue;
            col.setPreferredWidth(w);
        }
    }

    class ColumnListener
    implements PropertyChangeListener {
        ColumnListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!GemsDetailsTableModel.this.flag) {
                return;
            }
            if (e.getPropertyName().equals("preferredWidth")) {
                TableColumn tableColumn = (TableColumn)e.getSource();
                GemsDetailsTableModel.this.m_colWidths.put(tableColumn.getHeaderValue(), e.getNewValue());
            }
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.getColumnModel().getColumn(column).getPreferredWidth() <= 15) {
                value = null;
            }
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof MsgCellValue) {
                MsgCellValue mv = (MsgCellValue)value;
                this.setHorizontalAlignment(4);
                if (mv.m_errorLimit > 0L && mv.m_cellValue >= mv.m_errorLimit) {
                    cell.setBackground(Color.red);
                    cell.setForeground(table.getForeground());
                } else if (mv.m_warnLimit > 0L && mv.m_cellValue >= mv.m_warnLimit) {
                    cell.setBackground(Color.orange);
                    cell.setForeground(table.getForeground());
                } else if (isSelected) {
                    cell.setBackground(table.getSelectionBackground());
                } else {
                    cell.setBackground(Color.white);
                }
            } else if (value instanceof GemsCellValue) {
                GemsCellValue mv = (GemsCellValue)value;
                if (mv.m_rightAlign) {
                    this.setHorizontalAlignment(4);
                } else {
                    this.setHorizontalAlignment(2);
                }
                if (mv.m_errorLimit != null && mv.m_errorLimit > 0L && mv.m_value >= mv.m_errorLimit) {
                    cell.setBackground(Color.red);
                    cell.setForeground(table.getForeground());
                } else if (mv.m_warnLimit != null && mv.m_warnLimit > 0L && mv.m_value >= mv.m_warnLimit) {
                    cell.setBackground(Color.orange);
                    cell.setForeground(table.getForeground());
                } else if (isSelected) {
                    cell.setBackground(table.getSelectionBackground());
                } else {
                    cell.setBackground(Color.white);
                }
            } else if (value instanceof SSCellValue) {
                SSCellValue mv = (SSCellValue)value;
                cell.setBackground(mv.CellColour());
            } else if (value instanceof SSCellFFValue) {
                SSCellFFValue mv = (SSCellFFValue)value;
                cell.setFont(new Font("Courier New", 0, 12));
                cell.setBackground(Color.white);
            } else if (value instanceof Long) {
                this.setHorizontalAlignment(4);
                if ((Long)value > 0L && table.getColumnName(column).startsWith("Pending")) {
                    cell.setBackground(Color.orange);
                    cell.setForeground(table.getForeground());
                } else if ((Long)value == 0L && table.getColumnName(column).equals("ConnectionID")) {
                    cell.setBackground(Color.orange);
                    cell.setForeground(table.getForeground());
                } else if (isSelected) {
                    cell.setBackground(table.getSelectionBackground());
                } else {
                    cell.setBackground(Color.white);
                }
            } else if (value instanceof String) {
                this.setHorizontalAlignment(2);
                String s = (String)value;
                if (table.getColumnName(column).equals("Connected") && s.equals("false")) {
                    cell.setBackground(Color.red);
                    cell.setForeground(table.getForeground());
                } else if (table.getColumnName(column).equals("Stalled") && s.equals("true")) {
                    cell.setBackground(Color.orange);
                    cell.setForeground(table.getForeground());
                } else if (table.getColumnName(column).equals("RouteConnected") && s.equals("false") && column > 1) {
                    Object v;
                    if (table.getColumnName(column - 1).equals("Routed") && (v = table.getValueAt(row, column - 1)) instanceof String && ((String)v).equals("true")) {
                        cell.setBackground(Color.red);
                        cell.setForeground(table.getForeground());
                    }
                } else if (table.getColumnName(column).equals("Routed") && s.equals("true") && table.getColumnCount() > column) {
                    Object v;
                    if (table.getColumnName(column + 1).equals("RouteConnected") && (v = table.getValueAt(row, column + 1)) instanceof String && ((String)v).equals("false")) {
                        cell.setBackground(Color.red);
                        cell.setForeground(table.getForeground());
                    }
                } else if (isSelected) {
                    cell.setBackground(table.getSelectionBackground());
                } else {
                    cell.setBackground(Color.white);
                }
            } else {
                this.setHorizontalAlignment(2);
                if (isSelected) {
                    cell.setBackground(table.getSelectionBackground());
                } else {
                    cell.setBackground(Color.white);
                }
            }
            return cell;
        }
    }

    class Client {
        String m_id;
        long m_connCount;
        long m_consCount;
        long m_prodCount;
        long m_sessCount;
        long m_inMsgs;
        long m_outMsgs;
        long m_inMsgRate;
        long m_outMsgRate;

        Client(String id, long consCount, long prodCount, long sessCount) {
            this.m_id = id;
            this.m_connCount = 1L;
            this.m_consCount = consCount;
            this.m_prodCount = prodCount;
            this.m_sessCount = sessCount;
            this.m_inMsgs = 0L;
            this.m_outMsgs = 0L;
            this.m_inMsgRate = 0L;
            this.m_outMsgRate = 0L;
        }
    }

    class UserConn {
        String m_user;
        long m_connCount;
        long m_consCount;
        long m_prodCount;
        long m_sessCount;
        long m_ftCount;
        long m_adminCount;

        UserConn(String user, long consCount, long prodCount, long sessCount) {
            this.m_user = user;
            this.m_connCount = 1L;
            this.m_consCount = consCount;
            this.m_prodCount = prodCount;
            this.m_sessCount = sessCount;
            this.m_ftCount = 0L;
            this.m_adminCount = 0L;
        }
    }
}

