/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import org.json.simple.JSONObject;

public class GemsDummyFileStoreInfo {
    String m_name = "store1";
    String m_description = "";
    String m_file = "SSD/store1.db";
    String m_type = "file";
    String m_mode = "async";
    String m_file_minimum = "100MB";
    boolean m_file_crc = false;
    boolean m_truncate = true;

    public GemsDummyFileStoreInfo() {
    }

    public GemsDummyFileStoreInfo(String path, String storename) {
        if (storename != null) {
            this.m_name = storename;
        }
        if (path != null) {
            this.m_file = path + '/' + this.m_name + ".db";
        }
    }

    public String getStoreName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getFilePath() {
        return this.m_file;
    }

    public String getType() {
        return this.m_type;
    }

    public String getMode() {
        return this.m_mode;
    }

    public boolean getUseCrcValidation() {
        return this.m_file_crc;
    }

    public boolean getTruncateUnusedSpace() {
        return this.m_truncate;
    }

    public String getFileMinimum() {
        return this.m_file_minimum;
    }

    public void setStoreName(String name) {
        this.m_name = name;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setFilePath(String file) {
        this.m_file = file;
    }

    public void setMode(String mode) {
        if (mode.equals("sync") || mode.equals("async")) {
            this.m_mode = mode;
        }
    }

    public void setUseCrcValidation(boolean file_crc) {
        this.m_file_crc = file_crc;
    }

    public void setTruncateUnusedSpace(boolean truncate) {
        this.m_truncate = truncate;
    }

    public void setFileMinimum(String min) {
        this.m_file_minimum = min;
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put((Object)"name", (Object)this.m_name);
        o.put((Object)"file", (Object)this.m_file);
        o.put((Object)"type", (Object)this.m_type);
        o.put((Object)"mode", (Object)this.m_mode);
        if (this.m_description != null && this.m_description.length() > 0) {
            o.put((Object)"description", (Object)this.m_description);
        }
        if (!this.m_file_crc) {
            o.put((Object)"file_crc", (Object)this.m_file_crc);
        }
        if (!this.m_truncate) {
            o.put((Object)"file_truncate", (Object)this.m_truncate);
        }
        o.put((Object)"file_minimum", (Object)this.m_file_minimum);
        return o;
    }
}

