/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsBrowserOptionsDialog;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsMessageCopier;
import com.tibco.gems.GemsMessageDestroyer;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsMessageTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.TibjmsTopicConnectionFactory;
import com.tibco.tibjms.admin.TibjmsAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSubscriber;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.text.DefaultEditorKit;

public class GemsDurableBrowser
extends JFrame {
    JFrame m_frame;
    JPanel m_panel;
    boolean m_running = false;
    boolean m_noLocal = false;
    int m_msgs = 0;
    int m_maxMsgs = 10;
    Message m_msg = null;
    TibjmsAdmin m_admin = null;
    Session m_session = null;
    GemsConnectionNode m_cn;
    TopicConnection m_connection = null;
    TopicSubscriber m_subscriber = null;
    Timer m_timer = new Timer(Gems.getGems().getMsgReadDelay(), new RefreshTimerAction());
    protected JTextField m_conn;
    protected JTextField m_durable;
    protected JTextField m_topic;
    protected JTextField m_clientId;
    protected JTextField m_msgsRead;
    protected JTextField m_msgsDisplay;
    protected JTextField m_filter;
    protected String m_selector;
    protected JButton m_startButton;
    protected JButton m_stopButton;
    protected JCheckBox m_ackMsgs;
    JTable m_table;
    protected GemsMessageTableModel m_tableModel;
    protected boolean m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
    protected JMenuItem m_optMenuItem;
    protected JMenuItem m_dumpMenuItem;
    TableSorter m_sorter;

    public GemsDurableBrowser(GemsConnectionNode cn, String durable, String clientId, String topic, String selector, boolean noLocal) {
        super(Gems.getGems().getTitlePrefix() + "Durable Browser");
        this.setLocation(400, 175);
        this.setDefaultCloseOperation(2);
        this.m_frame = this;
        this.m_cn = cn;
        this.m_noLocal = noLocal;
        this.m_selector = selector;
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 20);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JLabel l2 = new JLabel("Topic Name:", 11);
        this.m_topic = new JTextField(topic, 20);
        this.m_topic.setEditable(false);
        this.m_topic.setMaximumSize(new Dimension(0, 24));
        l2.setLabelFor(this.m_topic);
        panel.add(l2);
        panel.add(this.m_topic);
        JLabel l3 = new JLabel("Durable Name:", 11);
        this.m_durable = new JTextField(durable, 20);
        this.m_durable.setEditable(false);
        this.m_durable.setMaximumSize(new Dimension(0, 24));
        l3.setLabelFor(this.m_durable);
        panel.add(l3);
        panel.add(this.m_durable);
        JLabel l4 = new JLabel("Client Id:", 11);
        this.m_clientId = new JTextField(clientId, 20);
        this.m_clientId.setMaximumSize(new Dimension(0, 24));
        this.m_clientId.setEditable(false);
        l4.setLabelFor(this.m_clientId);
        panel.add(l4);
        panel.add(this.m_clientId);
        JLabel l5 = new JLabel("Destination Filter:", 11);
        this.m_filter = new JTextField("", 20);
        this.m_filter.setMaximumSize(new Dimension(0, 24));
        l5.setLabelFor(this.m_filter);
        panel.add(l5);
        panel.add(this.m_filter);
        JPanel mpanel = new JPanel(true);
        mpanel.setLayout(new BoxLayout(mpanel, 0));
        JLabel l9 = new JLabel("Msgs to Read:", 11);
        this.m_msgsRead = new JTextField("10", 20);
        this.m_msgsRead.setMinimumSize(new Dimension(40, 24));
        l9.setLabelFor(this.m_msgsRead);
        panel.add(l9);
        mpanel.add(this.m_msgsRead);
        this.m_ackMsgs = new JCheckBox("Purge Msgs Read", false);
        if (!Gems.getGems().getViewOnlyMode()) {
            mpanel.add(this.m_ackMsgs);
        }
        panel.add(mpanel);
        this.m_tableModel = new GemsMessageTableModel(false, true);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.setSelectionMode(0);
        this.m_tableModel.m_table = this.m_table;
        this.addMouseListenerToTable(this.m_table);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(450, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(250, 10));
        bpanel.add(bx);
        this.m_startButton = new JButton("Start");
        this.m_startButton.addActionListener(new StartPressed());
        this.m_stopButton = new JButton("Stop");
        this.m_stopButton.addActionListener(new StopPressed());
        this.m_stopButton.setEnabled(false);
        bpanel.add(this.m_startButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_stopButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 3, 4, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.pack();
        this.show();
    }

    public void start() {
        if (this.m_filter != null && this.m_filter.getText().length() > 0 && this.m_ackMsgs.isSelected()) {
            JOptionPane.showMessageDialog(this.m_frame, "Destinaton filter cannot be used with purge messages.", "Error", 1);
            return;
        }
        this.m_running = true;
        this.m_msgs = 0;
        this.m_durable.setEnabled(false);
        this.m_topic.setEnabled(false);
        this.m_clientId.setEnabled(false);
        this.m_msgsRead.setEnabled(false);
        this.m_startButton.setEnabled(false);
        this.m_stopButton.setEnabled(true);
        this.m_ackMsgs.setEnabled(false);
        this.m_filter.setEnabled(false);
        this.m_optMenuItem.setEnabled(false);
        this.m_dumpMenuItem.setEnabled(false);
        try {
            this.m_maxMsgs = Integer.parseInt(this.m_msgsRead.getText());
        }
        catch (Exception ie) {
            this.m_maxMsgs = 10;
        }
        this.m_tableModel.buildColumnHeaders();
        try {
            TibjmsTopicConnectionFactory factory = new TibjmsTopicConnectionFactory(this.m_cn.m_url, null, this.m_cn.m_sslParams);
            this.m_connection = factory.createTopicConnection(this.m_cn.m_user, this.m_cn.m_password);
            if (this.m_clientId.getText().length() > 0) {
                this.m_connection.setClientID(this.m_clientId.getText());
            }
            this.m_session = this.m_connection.createSession(false, 2);
            Topic topic = this.m_session.createTopic(this.m_topic.getText());
            String sel = null;
            if (this.m_selector != null && this.m_selector.length() > 0) {
                sel = this.m_selector;
            }
            this.m_subscriber = this.m_session.createDurableSubscriber(topic, this.m_durable.getText(), sel, this.m_noLocal);
            this.m_connection.start();
            this.m_timer.start();
        }
        catch (JMSException e) {
            JOptionPane.showMessageDialog(this.m_frame, e.getMessage(), "Error", 1);
            this.stop();
        }
    }

    public void stop() {
        this.m_timer.stop();
        this.m_running = false;
        try {
            if (this.m_subscriber != null) {
                this.m_subscriber.close();
                this.m_subscriber = null;
            }
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (JMSException e) {
            System.err.println("Exception: " + e.getMessage());
        }
        this.m_durable.setEnabled(true);
        this.m_topic.setEnabled(true);
        this.m_clientId.setEnabled(true);
        this.m_msgsRead.setEnabled(true);
        this.m_startButton.setEnabled(true);
        this.m_stopButton.setEnabled(false);
        this.m_ackMsgs.setEnabled(true);
        this.m_filter.setEnabled(true);
        this.m_optMenuItem.setEnabled(true);
        this.m_dumpMenuItem.setEnabled(true);
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GemsDurableBrowser.this.showMessageFrame();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        this.m_dumpMenuItem = new JMenuItem("Save Messages To File...");
        this.m_dumpMenuItem.addActionListener(new DumpToFile());
        menu.add(this.m_dumpMenuItem);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsDurableBrowser.this.dispose();
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem("Select All");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menuItem.addActionListener(new SelectAllAction());
        menu.add(menuItem);
        menu.addSeparator();
        this.m_optMenuItem = menu.add(new JMenuItem("Options..."));
        this.m_optMenuItem.addActionListener(new EditOptionsAction());
        menuBar.add(menu);
        menu = new JMenu("Message");
        menu.setMnemonic(77);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("View Message..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsDurableBrowser.this.showMessageFrame();
            }
        });
        if (!Gems.getGems().getViewOnlyMode()) {
            menuItem = menu.add(new JMenuItem("Copy Checked Messages..."));
            menuItem.addActionListener(new CopyMessageAction());
            menuItem = menu.add(new JMenuItem("Destroy Checked Messages..."));
            menuItem.addActionListener(new DestroyMessageAction());
        }
        return menuBar;
    }

    public void showMessageFrame() {
        Message m = this.m_tableModel.getSelectedMessage();
        if (m != null) {
            GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, null, true, null, false);
            f.populate(m);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "Select a Message to view!", "View Message", 1);
        }
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    class DumpToFile
    implements ActionListener {
        DumpToFile() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Save Messages To File (appends)");
                int returnVal = chooser.showOpenDialog(GemsDurableBrowser.this.m_frame);
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    GemsDurableBrowser.this.m_tableModel.dumpMsgsToFile(f, GemsDurableBrowser.this.m_viewoldestFirst);
                }
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(GemsDurableBrowser.this.m_frame, ie.getMessage(), "Error", 1);
                return;
            }
        }
    }

    class DestroyMessageAction
    implements ActionListener {
        DestroyMessageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Vector m = GemsDurableBrowser.this.m_tableModel.getSelectedMessages();
            if (m.size() == 0) {
                JOptionPane.showMessageDialog(GemsDurableBrowser.this.m_frame, "Select Messages to destroy using checkbox!", "Destroy Messages", 1);
            }
            if (m.size() > 0) {
                String sel = null;
                if (GemsDurableBrowser.this.m_selector != null && GemsDurableBrowser.this.m_selector.length() > 0) {
                    sel = GemsDurableBrowser.this.m_selector;
                }
                GemsMessageDestroyer gemsMessageDestroyer = new GemsMessageDestroyer((Frame)GemsDurableBrowser.this.m_frame, GemsDurableBrowser.this.m_cn, m, null);
            }
        }
    }

    class CopyMessageAction
    implements ActionListener {
        CopyMessageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Vector m = GemsDurableBrowser.this.m_tableModel.getSelectedMessages();
            if (m.size() == 0) {
                JOptionPane.showMessageDialog(GemsDurableBrowser.this.m_frame, "Select Messages to copy using checkbox!", "Copy Messages", 1);
            }
            if (m.size() > 0) {
                GemsMessageCopier gemsMessageCopier = new GemsMessageCopier(GemsDurableBrowser.this.m_frame, GemsDurableBrowser.this.m_cn, GemsDurableBrowser.this.m_durable.getText(), "Durable", m);
            }
        }
    }

    class SelectAllAction
    implements ActionListener {
        SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDurableBrowser.this.m_tableModel.selectAllRows();
        }
    }

    class EditOptionsAction
    implements ActionListener {
        EditOptionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new GemsBrowserOptionsDialog((Frame)GemsDurableBrowser.this.m_frame, "Edit Durable Browser Options");
            GemsDurableBrowser.this.m_timer.setDelay(Gems.getGems().getMsgReadDelay());
            GemsDurableBrowser.this.m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
        }
    }

    class StopPressed
    implements ActionListener {
        StopPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDurableBrowser.this.stop();
        }
    }

    class StartPressed
    implements ActionListener {
        StartPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDurableBrowser.this.start();
        }
    }

    class RefreshTimerAction
    implements ActionListener {
        RefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsDurableBrowser.this.m_running) {
                try {
                    boolean gotMsg = false;
                    Message message = null;
                    while (!gotMsg) {
                        message = GemsDurableBrowser.this.m_subscriber.receiveNoWait();
                        if (message != null) {
                            Topic top;
                            gotMsg = true;
                            if (GemsDurableBrowser.this.m_filter == null || GemsDurableBrowser.this.m_filter.getText().length() <= 0 || (top = (Topic)message.getJMSDestination()).getTopicName().equals(GemsDurableBrowser.this.m_filter.getText())) continue;
                            gotMsg = false;
                            continue;
                        }
                        return;
                    }
                    GemsDurableBrowser.this.m_tableModel.addMessage(message, GemsDurableBrowser.this.m_viewoldestFirst);
                    if (GemsDurableBrowser.this.m_ackMsgs.isSelected()) {
                        message.acknowledge();
                    }
                    if (++GemsDurableBrowser.this.m_msgs >= GemsDurableBrowser.this.m_maxMsgs) {
                        GemsDurableBrowser.this.stop();
                    }
                }
                catch (JMSException ex) {
                    System.err.println("Exception: " + ex.getMessage());
                    GemsDurableBrowser.this.stop();
                }
            }
        }
    }
}

