/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GemsDynamicPropertyDialog
extends JDialog
implements ActionListener {
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private boolean isOK = false;
    private Map propertyControls;
    private String m_className;
    private String m_comment;
    private Object m_obj;
    private JPanel m_panel;

    public GemsDynamicPropertyDialog(JFrame frame, String name, String className, String comment, Object obj) {
        super(frame, name, true);
        this.m_className = className;
        this.m_comment = comment;
        this.m_obj = obj;
        this.init();
    }

    public GemsDynamicPropertyDialog(JDialog owner, String name, String className, String comment, Object obj) {
        super(owner, name, true);
        this.m_className = className;
        this.m_comment = comment;
        this.m_obj = obj;
        this.init();
    }

    public void init() {
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.m_panel = this.getPanel(this.m_className);
        this.getContentPane().setLayout(new BorderLayout());
        if (this.m_comment != null) {
            this.getContentPane().add((Component)new JLabel(this.m_comment), "North");
        }
        this.getContentPane().add((Component)this.m_panel, "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 0));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel buttonContainer = new JPanel(new FlowLayout(1));
        buttonContainer.add(buttonPanel);
        this.getContentPane().add((Component)buttonContainer, "South");
        if (this.m_obj != null) {
            try {
                for (String propertyName : this.propertyControls.keySet()) {
                    Method method;
                    String pn;
                    Object propertyValue = null;
                    Class<?> cl = Class.forName(this.m_className);
                    JComponent component = (JComponent)this.propertyControls.get(propertyName);
                    if (component instanceof JTextField) {
                        pn = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                        method = cl.getMethod("get" + pn, new Class[0]);
                        propertyValue = method.invoke(this.m_obj, new Object[0]);
                        if (propertyValue == null) continue;
                        ((JTextField)component).setText(propertyValue.toString());
                        continue;
                    }
                    if (!(component instanceof JCheckBox)) continue;
                    pn = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                    method = cl.getMethod("get" + pn, new Class[0]);
                    propertyValue = method.invoke(this.m_obj, new Object[0]);
                    if (propertyValue == null || !(propertyValue instanceof Boolean)) continue;
                    ((JCheckBox)component).setSelected((Boolean)propertyValue);
                }
            }
            catch (Exception ie) {
                System.err.println("Exception: " + ie.toString());
            }
        }
    }

    public Object getObject() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension panelSize = this.m_panel.getSize();
        int width = panelSize.width;
        int height = panelSize.height + 30;
        this.setSize(width, height);
        this.setLocation(screen.width / 2 - width / 2, screen.height / 2 - height / 2);
        this.pack();
        this.setVisible(true);
        if (!this.isOK) {
            return null;
        }
        TreeMap<String, String> propertyMap = new TreeMap<String, String>();
        for (String propertyName : this.propertyControls.keySet()) {
            String propertyValue = null;
            JComponent component = (JComponent)this.propertyControls.get(propertyName);
            if (component instanceof JTextField) {
                propertyValue = ((JTextField)component).getText();
            } else if (component instanceof JCheckBox) {
                propertyValue = Boolean.toString(((JCheckBox)component).isSelected());
            }
            propertyMap.put(propertyName, propertyValue);
        }
        return GemsUtilities.buildObject(this.m_className, propertyMap);
    }

    protected JPanel getPanel(String className) {
        try {
            Class<?> c = Class.forName(className);
            return this.getPanel(c);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected JPanel getPanel(Class c) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.gridy = 1;
        constraints.ipadx = 2;
        constraints.ipady = 2;
        int height = 0;
        JPanel panel = new JPanel(gridbag);
        Map props = GemsUtilities.getWriteableProperties(c);
        this.propertyControls = new TreeMap();
        for (String propertyName : props.keySet()) {
            String className = (String)props.get(propertyName);
            if (GemsUtilities.isPrimitiveType(className)) {
                StringBuffer sb = new StringBuffer();
                sb.append(Character.toUpperCase(propertyName.charAt(0)));
                boolean lastCharUpperCase = false;
                boolean nextCharUpperCase = false;
                for (int j = 1; j < propertyName.length(); ++j) {
                    char ch = propertyName.charAt(j);
                    if (Character.isUpperCase(ch)) {
                        if (!lastCharUpperCase && j > 1) {
                            sb.append(" ");
                        }
                        lastCharUpperCase = true;
                    } else {
                        lastCharUpperCase = false;
                    }
                    sb.append(ch);
                }
                sb.append(":");
                JLabel label = new JLabel(sb.toString());
                constraints.gridx = 0;
                constraints.anchor = 12;
                gridbag.setConstraints(label, constraints);
                panel.add(label);
                constraints.gridx = 1;
                constraints.anchor = 18;
                if (className.equals("boolean") || className.equals("java.lang.Boolean")) {
                    JCheckBox checkbox = new JCheckBox();
                    this.propertyControls.put(propertyName, checkbox);
                    gridbag.setConstraints(checkbox, constraints);
                    panel.add(checkbox);
                } else {
                    JTextField textField = new JTextField(35);
                    this.propertyControls.put(propertyName, textField);
                    gridbag.setConstraints(textField, constraints);
                    panel.add(textField);
                }
                height += 32;
            }
            ++constraints.gridy;
        }
        panel.setSize(470, height);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.isOK = e.getSource() == this.okButton;
        this.setVisible(false);
    }
}

