/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsMessageTableModel;
import java.util.Date;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;

public class GemsEventMessageTableModel
extends GemsMessageTableModel {
    static String[] s_info_cols = new String[]{"Info"};

    public GemsEventMessageTableModel(boolean editable, boolean showCheckbox) {
        super(editable, showCheckbox);
    }

    @Override
    public void buildColumnHeaders() {
        this.setRowCount(0);
        this.m_msgs.clear();
        this.m_table.setAutoResizeMode(0);
        this.m_table.setDefaultRenderer(this.m_obj.getClass(), this.m_renderer);
        this.m_table.setDefaultRenderer(Date.class, this.m_renderer);
        Object[] cols = new String[]{"MonitorEventID", "Timestamp", "EventClass", "EventAction", "EventReason", "ConnHostname", "ConnUsername", "TargetDestination", "TargetDestType"};
        if (this.getColumnCount() != 9 || !this.getColumnName(2).equals("EventClass")) {
            this.setColumnCount(0);
            this.setColumnIdentifiers(cols);
            this.m_table.getColumn("MonitorEventID").setPreferredWidth(100);
            this.m_table.getColumn("TargetDestination").setPreferredWidth(200);
            this.m_table.getColumn("ConnHostname").setPreferredWidth(120);
            this.m_table.getColumn("ConnUsername").setPreferredWidth(120);
            this.m_table.getColumn("EventClass").setPreferredWidth(150);
            this.m_table.getColumn("EventReason").setPreferredWidth(120);
            this.m_table.getColumn("EventAction").setPreferredWidth(120);
            this.m_table.getColumn("TargetDestType").setPreferredWidth(100);
            this.m_table.getColumn("Timestamp").setPreferredWidth(180);
        }
    }

    @Override
    public void addMessage(Message m, boolean oldestFirst) {
        Date d = new Date();
        try {
            if (m != null) {
                String a;
                if (m.getJMSMessageID() == null) {
                    m.setJMSMessageID("tmpId" + String.valueOf(++s_msgId));
                }
                this.m_msgs.put(m.getJMSMessageID(), m);
                String c = m.getStringProperty("event_class");
                if (c == null) {
                    c = new String();
                }
                if ((a = m.getStringProperty("event_action")) == null) {
                    a = new String();
                }
                d.setTime(m.getJMSTimestamp());
                Object[] r = new Object[]{m.getJMSMessageID(), d, c, a, m.getStringProperty("event_reason"), m.getStringProperty("conn_hostname"), m.getStringProperty("conn_username"), m.getStringProperty("target_dest_name"), m.getStringProperty("target_dest_type")};
                if (oldestFirst) {
                    this.addRow(r);
                } else {
                    this.insertRow(0, r);
                }
            } else {
                System.err.println("Empty message!");
            }
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    @Override
    public void populateMessageInfo(Vector msgs) {
        if (msgs == null) {
            this.setRowCount(0);
            this.setColumnCount(0);
            this.m_msgs.clear();
            this.m_table.setAutoResizeMode(4);
            this.setColumnIdentifiers(s_info_cols);
            this.addRow(new String[]{"To configure Server Event Monitoring choose \"Edit Monitor Events...\" from Edit menu."});
            return;
        }
        this.buildColumnHeaders();
        for (int i = 0; i < msgs.size(); ++i) {
            Message m = (Message)msgs.elementAt(i);
            this.addMessage(m, false);
        }
    }
}

