/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.tibjms.TibjmsTopicConnectionFactory;
import java.util.Random;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class GemsEventMonitor
implements MessageListener {
    public Vector m_subscriptions = new Vector();
    public Vector m_subscribers = new Vector();
    public Vector m_messages = new Vector();
    public boolean m_running = false;
    public long m_maxEvents;
    protected GemsConnectionNode m_cn;
    protected TopicSession m_sess = null;
    protected TopicConnection m_connection = null;
    protected StartThread m_timer = null;
    protected Random m_random = new Random();
    public boolean m_enabled = false;
    protected MonitorDisconnectThread m_discThread = null;

    public GemsEventMonitor(GemsConnectionNode cn, long maxEvents, boolean enabled) {
        this.m_cn = cn;
        this.m_maxEvents = maxEvents;
        this.m_enabled = enabled;
    }

    public synchronized void systemStart() {
        if (this.m_enabled) {
            this.userStart();
        }
    }

    public synchronized void systemStop(boolean force) {
        if (force) {
            this.m_running = false;
            if (this.m_timer != null) {
                this.m_timer.interrupt();
            }
            try {
                if (this.m_connection != null) {
                    this.m_discThread = new MonitorDisconnectThread((Connection)this.m_connection, 10);
                    this.m_discThread.start();
                    System.err.println("Warning, after connection timeout; event monitoring for " + this.m_cn.getUrl() + " has been disabled");
                    this.m_enabled = false;
                }
            }
            catch (Exception e) {
                Gems.debug("GemsEventMonitor:systemStop: Exception: " + e.toString());
            }
            this.m_connection = null;
            this.m_sess = null;
            this.m_subscribers.removeAllElements();
            this.m_messages.removeAllElements();
        } else {
            this.userStop();
        }
    }

    public synchronized void userStart() {
        this.stopMonitor();
        this.reset();
        this.m_timer = new StartThread();
        this.m_timer.start();
    }

    public synchronized void userStop() {
        this.m_running = false;
        if (this.m_timer != null) {
            this.m_timer.interrupt();
        }
        this.stopMonitor();
        this.reset();
    }

    public synchronized void clearAll() {
        this.systemStop(false);
        this.m_subscriptions.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        GemsEventMonitor gemsEventMonitor = this;
        synchronized (gemsEventMonitor) {
            this.m_messages.removeAllElements();
        }
        Gems.getGems().treeRepaint();
    }

    public synchronized Vector getMessages() {
        return this.m_messages;
    }

    public synchronized void startMonitor() {
        if (this.m_subscriptions.size() == 0) {
            System.err.println("GemsEventMonitor:start: No subscriptions found");
            return;
        }
        try {
            TibjmsTopicConnectionFactory factory = new TibjmsTopicConnectionFactory(this.m_cn.m_url, null, this.m_cn.m_sslParams);
            this.m_connection = factory.createTopicConnection(this.m_cn.m_user, this.m_cn.m_password);
            this.m_sess = this.m_connection.createTopicSession(false, 22);
            for (int i = 0; i < this.m_subscriptions.size(); ++i) {
                subscription s = (subscription)this.m_subscriptions.get(i);
                Topic t = this.m_sess.createTopic(s.m_dest);
                TopicSubscriber sub = this.m_sess.createSubscriber(t, s.m_sel, false);
                sub.setMessageListener((MessageListener)this);
                this.m_subscribers.add(sub);
                Gems.debug("GemsEventMonitor:start: Adding subscription: " + s.m_dest);
            }
            this.m_connection.start();
            this.m_running = true;
        }
        catch (JMSException e) {
            System.err.println("GemsEventMonitor:start: Exception: " + e.getMessage());
            if (e.getMessage().equals("Not permitted")) {
                System.err.println("To use EventMonitor for " + this.m_cn.m_url + " please add subscribe permission for user " + this.m_cn.m_user + " to topics:");
                for (int i = 0; i < this.m_subscriptions.size(); ++i) {
                    subscription s = (subscription)this.m_subscriptions.get(i);
                    System.err.println(s.m_dest);
                }
            }
            return;
        }
    }

    public synchronized void stopMonitor() {
        try {
            if (this.m_connection == null) {
                return;
            }
            this.m_connection.stop();
            for (int i = 0; i < this.m_subscribers.size(); ++i) {
                TopicSubscriber s = (TopicSubscriber)this.m_subscribers.get(i);
                s.close();
            }
            this.m_subscribers.removeAllElements();
            if (this.m_sess != null) {
                this.m_sess.close();
                this.m_sess = null;
            }
            this.m_connection.close();
            this.m_connection = null;
            this.m_messages.removeAllElements();
        }
        catch (Exception e) {
            Gems.debug("GemsEventMonitor:stop: Exception: " + e.toString());
            return;
        }
    }

    public synchronized void addSubscription(String monitorTopic, String sel) {
        if (monitorTopic != null && monitorTopic.length() > 0) {
            this.m_subscriptions.add(new subscription(monitorTopic, sel));
        }
    }

    public int getMessageCount() {
        return this.m_messages.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        GemsEventMonitor gemsEventMonitor = this;
        synchronized (gemsEventMonitor) {
            this.m_messages.add(msg);
            if ((long)this.m_messages.size() > this.m_maxEvents) {
                this.m_messages.removeElementAt(0);
            }
            Gems.getGems().scheduleRepaint();
            if (this.m_messages.size() == 1) {
                Gems.getGems().treeRepaint();
            }
        }
    }

    class MonitorDisconnectThread
    extends Thread {
        int delay = 10;
        long start = 0L;
        Connection monConn = null;

        MonitorDisconnectThread(Connection conn, int delay) {
            this.delay = delay * 1000;
            this.monConn = conn;
        }

        public boolean isRunning() {
            return this.monConn != null;
        }

        public long runTime() {
            if (this.start > 0L) {
                return (System.currentTimeMillis() - this.start) / 1000L;
            }
            return 0L;
        }

        @Override
        public void run() {
            this.start = System.currentTimeMillis();
            try {
                MonitorDisconnectThread.sleep(this.delay);
                Gems.debug("MonitorDisconnectThread: closing connection");
                this.monConn.close();
                Gems.debug("MonitorDisconnectThread: successfully closed connection after " + this.runTime() + "secs");
            }
            catch (Exception ie) {
                Gems.debug("MonitorDisconnectThread: Exception " + ie.toString());
                System.err.println("Timedout monitor connection failed to close, please restart Gems");
            }
            this.monConn = null;
        }
    }

    class StartThread
    extends Thread {
        StartThread() {
        }

        @Override
        public void run() {
            try {
                StartThread.sleep(3000 + GemsEventMonitor.this.m_random.nextInt(5000));
            }
            catch (Exception ie) {
                Gems.debug("StartThread.Exception: " + ie.getMessage());
                return;
            }
            GemsEventMonitor.this.startMonitor();
        }
    }

    class subscription {
        String m_dest;
        String m_sel;

        public subscription(String dest, String sel) {
            this.m_dest = dest;
            this.m_sel = sel;
        }
    }
}

