/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsEventMonitor;
import com.tibco.gems.GemsPropertyTableModel;
import com.tibco.gems.GemsUtilities;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;

public class GemsEventMonitorDialog
extends JDialog {
    protected JComboBox m_server;
    protected boolean m_cancelled = false;
    protected String m_selected;
    protected GemsConnectionNode m_cn;
    protected GemsPropertyTableModel m_tableModel;
    protected JTable m_table;
    protected String m_type;
    protected Hashtable m_connTable;
    protected Frame m_frame;
    protected JCheckBox m_enabled;
    protected JTextField m_maxEvents;
    protected JMenuBar m_menuBar = new JMenuBar();

    public GemsEventMonitorDialog(Frame frame, GemsConnectionNode cn) {
        super(frame, "Edit Monitor Events", true);
        this.m_cn = cn;
        this.m_frame = frame;
        this.buildFrame(frame);
        this.updateEvents();
        if (this.m_server.getItemCount() == 0) {
            return;
        }
        this.pack();
        this.setVisible(true);
    }

    public void buildFrame(Frame frame) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel toppanel = new JPanel(new SpringLayout());
        mainPanel.add(toppanel);
        JLabel l2 = new JLabel("Event Monitor For:", 11);
        this.m_server = new JComboBox();
        this.populateServers();
        this.m_server.addActionListener(new ServerSelected());
        toppanel.add(l2);
        toppanel.add(this.m_server);
        JLabel l3 = new JLabel("Monitoring Enabled:", 11);
        this.m_enabled = new JCheckBox();
        toppanel.add(l3);
        toppanel.add(this.m_enabled);
        JLabel l4 = new JLabel("Max Displayed Events:", 11);
        this.m_maxEvents = new JTextField("50");
        toppanel.add(l4);
        toppanel.add(this.m_maxEvents);
        GemsUtilities.makeCompactGrid(toppanel, 3, 2, 5, 5, 5, 5);
        this.m_tableModel = new GemsPropertyTableModel(true, true, true, false);
        this.m_table = new JTable(this.m_tableModel);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_tableModel.m_table = this.m_table;
        JScrollPane sp = new JScrollPane(this.m_table);
        sp.setPreferredSize(new Dimension(600, 300));
        JPanel midPanel = new JPanel();
        midPanel.setBorder(new TitledBorder("Receive events from these selected $sys.monitor topics"));
        midPanel.setLayout(new BoxLayout(midPanel, 1));
        JPanel pbutpanel = new JPanel(new FlowLayout());
        JButton a3 = new JButton("Apply");
        a3.addActionListener(new ApplyPressed());
        pbutpanel.add(a3);
        JButton a4 = new JButton("ApplyToAll");
        a4.addActionListener(new ApplyToAllPressed());
        pbutpanel.add(a4);
        JButton p2 = new JButton("Reset");
        p2.addActionListener(new ResetPressed());
        pbutpanel.add(p2);
        midPanel.add(sp);
        midPanel.add(pbutpanel);
        mainPanel.add(midPanel);
        JPanel holdbut = new JPanel();
        holdbut.setLayout(new FlowLayout());
        JButton b3 = new JButton("OK");
        JButton c3 = new JButton("Close");
        holdbut.add(c3);
        b3.addActionListener(new OkPressed());
        c3.addActionListener(new CancelPressed());
        mainPanel.add(holdbut);
        this.setContentPane(mainPanel);
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        this.setLocationRelativeTo(frame);
    }

    private JMenuBar constructMenuBar() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        this.m_menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsEventMonitorDialog.this.dispose();
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        this.m_menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("New System Monitor Event"));
        menuItem.addActionListener(new NewSystemMonitorEvent());
        menuItem = menu.add(new JMenuItem("New Queue Monitor Event"));
        menuItem.addActionListener(new NewQueueMonitorEvent());
        menuItem = menu.add(new JMenuItem("New Topic Monitor Event"));
        menuItem.addActionListener(new NewTopicMonitorEvent());
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("Reset To Default"));
        menuItem.addActionListener(new ResetMonitorEvent());
        return this.m_menuBar;
    }

    public String getSelectedProp() {
        return this.m_selected;
    }

    public void populateServers() {
        this.m_connTable = GemsConnectionNode.getConnections();
        Enumeration pe = this.m_connTable.keys();
        if (this.m_connTable.size() == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (pe.hasMoreElements()) {
            String i = (String)pe.nextElement();
            list.add(i);
            Collections.sort(list);
            this.m_server.insertItemAt(i, list.indexOf(i));
            if (this.m_cn == null || !i.startsWith(this.m_cn.getName())) continue;
            this.m_server.setSelectedItem(i);
        }
        if (this.m_server.getSelectedItem() == null) {
            this.m_server.setSelectedIndex(0);
        }
    }

    public void updateEvents() {
        GemsEventMonitor ev;
        this.m_tableModel.emptyPropertyInfo("Select", "MonitorEvent", "Selector");
        if (this.m_server.getItemCount() == 0) {
            return;
        }
        GemsConnectionNode cn = (GemsConnectionNode)this.m_connTable.get(this.m_server.getSelectedItem());
        if (cn != null && cn.isConnected() && (ev = cn.getEventMonitor()) != null) {
            this.m_enabled.setSelected(ev.m_enabled);
            this.m_maxEvents.setText(String.valueOf(ev.m_maxEvents));
            for (int i = 0; i < ev.m_subscriptions.size(); ++i) {
                GemsEventMonitor.subscription sub = (GemsEventMonitor.subscription)ev.m_subscriptions.get(i);
                this.m_tableModel.addProperty(true, sub.m_dest, sub.m_sel);
            }
            return;
        }
    }

    public void setEvents(boolean all) {
        if (this.m_table.getCellEditor() != null) {
            this.m_table.getCellEditor().stopCellEditing();
        }
        if (this.m_enabled.isSelected()) {
            for (int i = 0; i < this.m_table.getRowCount(); ++i) {
                if (!((Boolean)this.m_table.getValueAt(i, 0)).booleanValue() || !((String)this.m_table.getValueAt(i, 1)).endsWith(".>")) continue;
                int opt = JOptionPane.showConfirmDialog(this, "Warning, subscribing to wildcard monitor event topics can cause backlogs in the EMS server.\nAre you sure you want to continue?", "Edit Monitor Events", 0);
                if (opt == 0) break;
                return;
            }
        }
        if (all) {
            int opt = JOptionPane.showConfirmDialog(this, "Are you sure you want to set these monitor events for ALL EMS servers?", "Edit Monitor Events", 0);
            if (opt == 0) {
                for (int c = 0; c < this.m_server.getItemCount(); ++c) {
                    GemsConnectionNode cn = (GemsConnectionNode)this.m_connTable.get(this.m_server.getItemAt(c));
                    if (cn == null || !cn.isConnected()) continue;
                    GemsEventMonitor ev = cn.getEventMonitor();
                    if (ev == null) {
                        cn.addEventMonitor(50L, false);
                    }
                    if ((ev = cn.getEventMonitor()) == null) continue;
                    long maxEvents2 = 50L;
                    try {
                        maxEvents2 = Long.valueOf(this.m_maxEvents.getText());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ev.m_enabled = this.m_enabled.isSelected();
                    ev.m_maxEvents = maxEvents2;
                    ev.clearAll();
                    for (int i = 0; i < this.m_table.getRowCount(); ++i) {
                        if (!((Boolean)this.m_table.getValueAt(i, 0)).booleanValue()) continue;
                        ev.addSubscription((String)this.m_table.getValueAt(i, 1), (String)this.m_table.getValueAt(i, 2));
                    }
                    ev.systemStart();
                }
            }
        } else {
            GemsConnectionNode cn = (GemsConnectionNode)this.m_connTable.get(this.m_server.getSelectedItem());
            if (cn != null && cn.isConnected()) {
                GemsEventMonitor ev = cn.getEventMonitor();
                if (ev == null) {
                    cn.addEventMonitor(50L, false);
                }
                if ((ev = cn.getEventMonitor()) != null) {
                    long maxEvents = 50L;
                    try {
                        maxEvents = Long.valueOf(this.m_maxEvents.getText());
                    }
                    catch (Throwable maxEvents2) {
                        // empty catch block
                    }
                    ev.m_enabled = this.m_enabled.isSelected();
                    ev.m_maxEvents = maxEvents;
                    ev.clearAll();
                    for (int i = 0; i < this.m_table.getRowCount(); ++i) {
                        if (!((Boolean)this.m_table.getValueAt(i, 0)).booleanValue()) continue;
                        ev.addSubscription((String)this.m_table.getValueAt(i, 1), (String)this.m_table.getValueAt(i, 2));
                    }
                    ev.systemStart();
                }
            }
        }
        this.updateEvents();
    }

    public void resetEvents() {
        this.m_enabled.setSelected(true);
        this.m_maxEvents.setText("50");
        this.m_tableModel.emptyPropertyInfo("Select", "MonitorTopic", "Selector");
        this.m_tableModel.addProperty(true, "$sys.monitor.server.warning", "");
        this.m_tableModel.addProperty(true, "$sys.monitor.limits.*", "");
        this.m_tableModel.addProperty(false, "$sys.monitor.connection.error", "");
        this.m_tableModel.addProperty(false, "$sys.monitor.route.error", "");
        this.m_tableModel.addProperty(false, "$sys.monitor.flow.*", "");
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsEventMonitorDialog.this.m_cancelled = true;
            GemsEventMonitorDialog.this.dispose();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsEventMonitorDialog.this.setEvents(false);
            GemsEventMonitorDialog.this.dispose();
        }
    }

    class ApplyToAllPressed
    implements ActionListener {
        ApplyToAllPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsEventMonitorDialog.this.setEvents(true);
        }
    }

    class ApplyPressed
    implements ActionListener {
        ApplyPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsEventMonitorDialog.this.setEvents(false);
        }
    }

    class ServerSelected
    implements ActionListener {
        ServerSelected() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsEventMonitorDialog.this.m_selected = (String)GemsEventMonitorDialog.this.m_server.getSelectedItem();
            GemsEventMonitorDialog.this.updateEvents();
        }
    }

    class ResetPressed
    implements ActionListener {
        ResetPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsEventMonitorDialog.this.resetEvents();
        }
    }

    class ResetMonitorEvent
    implements ActionListener {
        ResetMonitorEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsEventMonitorDialog.this.resetEvents();
        }
    }

    class NewTopicMonitorEvent
    implements ActionListener {
        NewTopicMonitorEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsEventMonitorDialog.this.m_tableModel.addProperty(true, "$sys.monitor.T.r.<TopicName>", "");
        }
    }

    class NewQueueMonitorEvent
    implements ActionListener {
        NewQueueMonitorEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsEventMonitorDialog.this.m_tableModel.addProperty(true, "$sys.monitor.Q.r.<QueueName>", "");
        }
    }

    class NewSystemMonitorEvent
    implements ActionListener {
        NewSystemMonitorEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsEventMonitorDialog.this.m_tableModel.addProperty(true, "$sys.monitor.<SysType>.<EventType>", "");
        }
    }
}

