/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsIconNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class GemsIconNodeRenderer
extends DefaultTreeCellRenderer {
    Font font = null;
    Font bfont;
    Color col = UIManager.getColor("Tree.textForeground");
    Color scol = UIManager.getColor("Tree.selectionForeground");

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (this.font == null) {
            this.font = this.getFont();
            if (this.font != null) {
                this.bfont = new Font(this.font.getName(), 1, this.font.getSize());
            }
        }
        if (value != null && value instanceof GemsConnectionNode) {
            if (((GemsConnectionNode)value).isStandbyMode()) {
                this.setTextNonSelectionColor(this.col);
                this.setTextSelectionColor(this.scol);
                this.setFont(this.font);
            } else if (((GemsConnectionNode)value).showError()) {
                this.setTextNonSelectionColor(Color.red);
                this.setTextSelectionColor(Color.red);
                this.setFont(this.bfont);
            } else if (((GemsConnectionNode)value).showWarning()) {
                this.setTextNonSelectionColor(Color.orange);
                this.setTextSelectionColor(Color.orange);
                this.setFont(this.bfont);
            } else {
                this.setTextNonSelectionColor(this.col);
                this.setTextSelectionColor(this.scol);
                this.setFont(this.font);
            }
        } else {
            this.setTextNonSelectionColor(this.col);
            this.setTextSelectionColor(this.scol);
            this.setFont(this.font);
        }
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value != null && value instanceof GemsIconNode) {
            Icon icon = ((GemsIconNode)value).getIcon();
            if (icon == null) {
                Hashtable icons = (Hashtable)tree.getClientProperty("JTree.icons");
                String name = ((GemsIconNode)value).getIconName();
                if (icons != null && name != null && (icon = (Icon)icons.get(name)) != null) {
                    this.setIcon(icon);
                }
            } else {
                this.setIcon(icon);
            }
        } else {
            this.setIcon(null);
        }
        return this;
    }
}

