/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDetailsTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.PopupTableHandler;
import com.tibco.tibjms.admin.TibjmsAdminException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class GemsJNDILookup
extends JDialog {
    JFrame m_frame;
    JPanel m_panel;
    GemsConnectionNode m_cn;
    protected String m_type;
    protected JTextField m_conn;
    protected JTextField m_jndiname;
    protected JButton m_closeButton;
    protected JButton m_lookup;
    JTable m_table;
    protected GemsDetailsTableModel m_tableModel;

    public GemsJNDILookup(JFrame f, GemsConnectionNode cn) {
        super(f, Gems.getGems().getTitlePrefix() + " JNDI Lookup", true);
        this.setLocationRelativeTo(f);
        this.setDefaultCloseOperation(2);
        this.m_frame = f;
        this.m_cn = cn;
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 20);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JPanel spanel = new JPanel(true);
        spanel.setLayout(new BoxLayout(spanel, 0));
        spanel.setMinimumSize(new Dimension(200, 24));
        JLabel l5 = new JLabel("JNDI Name:", 11);
        this.m_jndiname = new JTextField("", 22);
        this.m_jndiname.addKeyListener(new SubmitListener());
        l5.setLabelFor(this.m_jndiname);
        panel.add(l5);
        spanel.add(this.m_jndiname);
        this.m_lookup = new JButton("Lookup");
        this.m_lookup.addActionListener(new LookupAction());
        spanel.add(this.m_lookup);
        panel.add(spanel);
        this.m_tableModel = new GemsDetailsTableModel();
        this.m_table = new JTable(this.m_tableModel);
        this.m_tableModel.setPopupHandler(new PopupTableHandler(this.m_table));
        this.m_tableModel.setTable(this.m_table);
        this.m_table.setSelectionMode(0);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(485, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(225, 10));
        bpanel.add(bx);
        this.m_closeButton = new JButton("Close");
        this.m_closeButton.addActionListener(new ClosePressed());
        bpanel.add(this.m_closeButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 2, 2, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.pack();
        this.show();
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsJNDILookup.this.dispose();
            }
        });
        return menuBar;
    }

    public Object jndiLookupByCF(String name) {
        Object obj = null;
        try {
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", "com.tibco.tibjms.naming.TibjmsInitialContextFactory");
            env.put("java.naming.provider.url", this.m_cn.m_url);
            env.put("java.naming.security.principal", this.m_cn.m_user);
            env.put("java.naming.security.credentials", this.m_cn.m_password);
            if (this.m_cn.m_url.startsWith("ssl:")) {
                env.put("com.tibco.tibjms.naming.security_protocol", "ssl");
                env.put("com.tibco.tibjms.naming.ssl_enable_verify_host", new Boolean("false"));
            }
            InitialContext jndiContext = new InitialContext(env);
            obj = jndiContext.lookup(name);
        }
        catch (NamingException ne) {
            System.err.println("NamingException: " + ne.getMessage());
        }
        return obj;
    }

    public Object jndiLookupByAdmin(String name) {
        Object obj = null;
        try {
            obj = this.m_cn.m_adminConn.lookup(name);
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
        }
        return obj;
    }

    public void getProperties() {
        Object ob = null;
        this.m_tableModel.setRowCount(0);
        if (this.m_jndiname.getText().length() == 0) {
            return;
        }
        if (!this.m_cn.isConnected()) {
            return;
        }
        this.m_tableModel.populateJNDIInfo(this.m_cn, this.m_jndiname.getText());
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    class LookupAction
    implements ActionListener {
        LookupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsJNDILookup.this.getProperties();
        }
    }

    public class SubmitListener
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                GemsJNDILookup.this.getProperties();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    class ClosePressed
    implements ActionListener {
        ClosePressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsJNDILookup.this.dispose();
        }
    }
}

