/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsConnectionPicker;
import com.tibco.gems.GemsDummyConnectionFactoryInfo;
import com.tibco.gems.GemsDummyFileStoreInfo;
import com.tibco.gems.GemsDynamicPropertyDialog;
import com.tibco.gems.GemsProperty;
import com.tibco.gems.GemsSetPropDialog;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.admin.ACLEntry;
import com.tibco.tibjms.admin.AdminACLEntry;
import com.tibco.tibjms.admin.AdminPermissions;
import com.tibco.tibjms.admin.BridgeInfo;
import com.tibco.tibjms.admin.BridgeTarget;
import com.tibco.tibjms.admin.Configuration;
import com.tibco.tibjms.admin.DestinationInfo;
import com.tibco.tibjms.admin.DurableInfo;
import com.tibco.tibjms.admin.GroupInfo;
import com.tibco.tibjms.admin.LDAPParams;
import com.tibco.tibjms.admin.Permissions;
import com.tibco.tibjms.admin.PrincipalInfo;
import com.tibco.tibjms.admin.QueueInfo;
import com.tibco.tibjms.admin.RouteInfo;
import com.tibco.tibjms.admin.ServerInfo;
import com.tibco.tibjms.admin.TibjmsAdmin;
import com.tibco.tibjms.admin.TibjmsAdminException;
import com.tibco.tibjms.admin.TopicInfo;
import com.tibco.tibjms.admin.UserInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GemsJSONConfigEditor
extends JDialog {
    JDialog m_this = null;
    GemsConnectionNode m_cn = null;
    boolean m_changed = false;
    Configuration m_config = null;
    JSONParser m_parser = new JSONParser();
    Object[] options = new Object[]{"Replace", "Merge", "Cancel"};
    static Hashtable props = null;
    static String warn1 = "<html><font size='+1'><b>Advanced use only, always save a copy to file before making changes.<br>Consult EMS server log for error information if update server fails.";
    static String warn2 = "<html><font size='+1'><b>Advanced use only, always save a copy to file before making changes.<br>Consult EMS server log for error information if update server fails.<br><font color='red'>The server requires a restart for deployed changes to take affect";
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel lblWarning;
    private JScrollPane scrollPane1;
    private JTextPane txtConfig;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton saveButton;
    private JButton saveAsButton;
    private JButton validateButton;
    private ValidationFrame validFrame;

    public GemsJSONConfigEditor(Frame owner, GemsConnectionNode cn) {
        super(owner, Gems.getGems().getTitlePrefix() + "Server JSON Config Editor", true);
        this.init();
        this.setDefaultCloseOperation(2);
        this.m_this = this;
        this.m_cn = cn;
        this.initComponents();
        this.setLocation(500, 50);
        this.pack();
        this.m_changed = false;
        this.show();
    }

    public synchronized void init() {
        if (props == null) {
            try {
                props = new Hashtable();
                props.put("reserve_memory", new GemsProperty("reserve_memory", Class.forName("java.lang.String"), "<html>Specifies memory for use in emergency situations to prevent<br>the EMS server from being unstable in low memory situations</html>", new String("32MB")));
                props.put("destination_backlog_swapout", new GemsProperty("destination_backlog_swapout", Class.forName("java.lang.String"), "<html>Specifies the number of messages that may be stored in a<br>destination before message swapping is enabled</html>", new String("1000000")));
                props.put("max_msg_memory", new GemsProperty("max_msg_memory", Class.forName("java.lang.String"), "<html>Maximum memory the server can use for messages.<br>When msg_swapping is enabled, and messages overflow this limit,<br>the server begins to swap messages out to disk.</html>", new String("1GB")));
                props.put("ft_reconnect_timeout", new GemsProperty("ft_reconnect_timeout", Class.forName("java.lang.String"), "<html>Length of time (secs) the server which has just become active following a failover<br>will wait for clients to reconnect before their state is removed from storage.<br>(For Appliances in a DR quad this may need to be increased)</html>", new String("60")));
                props.put("msg_swapping", new GemsProperty("msg_swapping", Class.forName("java.lang.String"), "<html>Set to true/false to enable/disable message swapping.</html>", new String("true")));
                props.put("max_connections", new GemsProperty("max_connections", Class.forName("java.lang.String"), "<html>Maximum number of simultaneous client connections.<br>Set to 0 to allow unlimited simultaneous connections.</html>", new String("0")));
                props.put("clock_sync_interval", new GemsProperty("clock_sync_interval", Class.forName("java.lang.String"), "<html>Interval in secs between clock synchronization commands sent by server to clients.<br>0 indicates that the clocks are only synchronized when the client connects to the server.</html>", new String("86400")));
                props.put("client_heartbeat_server", new GemsProperty("client_heartbeat_server", Class.forName("java.lang.String"), "<html>Specifies the interval (in seconds) clients send heartbeats to the server<br></html>", new String("10")));
                props.put("client_timeout_server_connection", new GemsProperty("client_timeout_server_connection", Class.forName("java.lang.String"), "<html>If a client does not receive a heartbeat for a period exceeding<br>this limit (in seconds), it closes the connection.<br>Recommended setting is 3.5 times the heartbeat interval</html>", new String("35")));
                props.put("server_heartbeat_client", new GemsProperty("server_heartbeat_client", Class.forName("java.lang.String"), "<html>Specifies the interval (in seconds) the server send heartbeats to clients<br></html>", new String("10")));
                props.put("server_timeout_client_connection", new GemsProperty("server_timeout_client_connection", Class.forName("java.lang.String"), "<html>If the server does not receive a heartbeat for a period exceeding<br>this limit (in seconds), it closes the connection.<br>Recommended setting is 3 times the heartbeat interval</html>", new String("30")));
                props.put("routing", new GemsProperty("routing", Boolean.TYPE, "<html>Set to true/false to enable/disable routing</html>", new Boolean(false)));
                props.put("server_heartbeat_server", new GemsProperty("server_heartbeat_server", Class.forName("java.lang.String"), "<html>Specifies the interval (in seconds) the server send heartbeats to other servers<br></html>", new String("10")));
                props.put("server_timeout_server_connection", new GemsProperty("server_timeout_server_connection", Class.forName("java.lang.String"), "<html>If the server does not receive a heartbeat for a period exceeding<br>this limit (in seconds), it closes the connection.<br>Recommended setting is 3 times the heartbeat interval</html>", new String("30")));
                props.put("authorization", new GemsProperty("authorization", Boolean.TYPE, "<html>Set to true/false to enable/disable server authorization</html>", new Boolean(false)));
                props.put("user_auth", new GemsProperty("user_auth", Class.forName("java.lang.String"), "<html>Comma separated list of local and/or ldap and/or jaas. Order is significant.<br>Note jaas is not available on the EMS Appliance.</html>", new String("local")));
                props.put("logfile_max_size", new GemsProperty("logfile_max_size", Class.forName("java.lang.String"), "<html>Maximum log file size before it is rotated.'0' specifies no limit.</html>", new String("10MB")));
                props.put("logfile_max_count", new GemsProperty("logfile_max_count", Class.forName("java.lang.String"), "<html>Maximum number of log files to keep.</html>", new String("100")));
                props.put("ldap_credential", new GemsProperty("ldap_credential", Class.forName("java.lang.String"), "<html>The password associated with the user defined in the ldap_principal property.<br>Password cannot be an empty string.</html>", new String("")));
                props.put("password", new GemsProperty("password", Class.forName("java.lang.String"), "<html>Server password used to log in to other routed servers that have authorization enabled.</html>", new String("")));
                props.put("user password", new GemsProperty("user password", Class.forName("java.lang.String"), "<html>User password used to authenticate connection to server.</html>", new String("")));
                props.put("always_exit_on_disk_error", new GemsProperty("always_exit_on_disk_error", Boolean.TYPE, "<html>Set to true/false to indicate whether or not the server is configured to exit on any disk error<br>Available from EMS8.4 only</html>", new Boolean(true)));
                props.put("network_thread_count", new GemsProperty("network_thread_count", Class.forName("java.lang.String"), "<html>Number of server network IO threads for message processing</html>", new String("1")));
                props.put("max_client_msg_size", new GemsProperty("max_client_msg_size", Class.forName("java.lang.String"), "<html>The maximum allowed size of an incoming client message<br> 0 means no limit, max 2GB </html>", new String("0")));
                props.put("large_destination_count", new GemsProperty("large_destination_count", Class.forName("java.lang.String"), "<html>The number of messages that an unbounded destination can hold<br>before the server logs warnings about the destination's message count<br>Available from EMS8.4 only</html>", new String("100000")));
                props.put("large_destination_memory", new GemsProperty("large_destination_memory", Class.forName("java.lang.String"), "<html>The amount of message memory in bytes that an unbounded destination can hold<br>before the server logs warnings about the destination's size<br>Available from EMS8.4 only</html>", new String("100MB")));
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
    }

    private void closeButtonActionPerformed() {
        if (this.m_changed) {
            int opt = JOptionPane.showConfirmDialog(this, "Are you sure you want to quit, any changes will be lost?", "Close", 0);
            if (opt == 0) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void initComponents() {
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.lblWarning = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.txtConfig = new JTextPane();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.saveButton = new JButton();
        this.saveAsButton = new JButton();
        this.validateButton = new JButton();
        this.dialogPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialogPane.setLayout(new BorderLayout(20, 20));
        this.contentPanel.setLayout(new BorderLayout(10, 10));
        JPanel connPanel = new JPanel(true);
        connPanel.setLayout(new BoxLayout(connPanel, 0));
        JLabel l1 = new JLabel("Editing JSON Configuration for Server: ");
        JTextField conn = new JTextField(this.m_cn != null ? this.m_cn.getName() + "(" + this.m_cn.getUrl() + ")" : "", 30);
        conn.setEditable(false);
        l1.setLabelFor(conn);
        connPanel.add(l1);
        connPanel.add(conn);
        this.contentPanel.add((Component)connPanel, "First");
        this.lblWarning.setText("<html>Advanced use only, always save a copy to file before making changes.<br>Consult EMS server log for error information if update server fails.");
        this.lblWarning.setFont(new Font("Tahoma", 1, 14));
        this.contentPanel.add((Component)this.lblWarning, "Last");
        this.scrollPane1.setHorizontalScrollBarPolicy(31);
        this.scrollPane1.setVerticalScrollBarPolicy(22);
        this.scrollPane1.setPreferredSize(new Dimension(600, 600));
        this.txtConfig.setText("text");
        this.txtConfig.setFont(new Font("Courier", 0, 14));
        this.scrollPane1.setViewportView(this.txtConfig);
        this.contentPanel.add((Component)this.scrollPane1, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.okButton.setText("Close");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsJSONConfigEditor.this.closeButtonActionPerformed();
            }
        });
        this.saveButton.setText("Update Server... ");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsJSONConfigEditor.this.saveButtonActionPerformed(false);
            }
        });
        this.saveAsButton.setText("Save To File...");
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsJSONConfigEditor.this.saveAsButtonActionPerformed();
            }
        });
        this.validateButton.setText("Validate...");
        this.validateButton.addActionListener(new ValidateAction());
        this.buttonBar.add(this.validateButton);
        this.buttonBar.add(this.saveButton);
        this.buttonBar.add(this.saveAsButton);
        this.buttonBar.add(this.okButton);
        this.dialogPane.add((Component)this.buttonBar, "Last");
        this.txtConfig.setText(this.getServerConfig());
        this.txtConfig.setCaretPosition(0);
        this.setContentPane(this.dialogPane);
        this.txtConfig.getDocument().addDocumentListener(new MyDocListener());
    }

    void updateWarning() {
        try {
            if (this.m_cn.m_adminConn != null && this.m_cn.m_adminConn.isRestartRequired()) {
                this.lblWarning.setText(warn2);
            } else {
                this.lblWarning.setText(warn1);
            }
        }
        catch (TibjmsAdminException e) {
            System.err.println("TibjmsAdminException: " + e.toString());
        }
    }

    void updateWarning(boolean restart) {
        if (restart) {
            this.lblWarning.setText(warn2);
        } else {
            this.lblWarning.setText(warn1);
        }
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Load From File...");
        menuItem.addActionListener(new LoadFile());
        menu.add(menuItem);
        menuItem = new JMenuItem("Save To File...");
        menuItem.addActionListener(new SaveFile());
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GemsJSONConfigEditor.this.m_changed) {
                    int opt = JOptionPane.showConfirmDialog(GemsJSONConfigEditor.this.m_this, "Are you sure you want to quit, any changes will be lost?", "Close", 0);
                    if (opt == 0) {
                        GemsJSONConfigEditor.this.dispose();
                    }
                } else {
                    GemsJSONConfigEditor.this.dispose();
                }
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuBar.add(menu);
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Find...");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        menuItem.addActionListener(new Find());
        menu.add(menuItem);
        menu = new JMenu("Create");
        menu.setMnemonic(67);
        menuBar.add(menu);
        menuItem = new JMenuItem("New File Store...");
        menuItem.addActionListener(new NewFileStore());
        menu.add(menuItem);
        menuItem = new JMenuItem("New Connection Factory...");
        menuItem.addActionListener(new NewConnectionFactory());
        menu.add(menuItem);
        menuItem = new JMenuItem("New Listen Port...");
        menuItem.addActionListener(new NewListenPort());
        menu.add(menuItem);
        menu = new JMenu("Set Property");
        menu.setMnemonic(83);
        menuBar.add(menu);
        Enumeration pe = props.keys();
        menuItem = new JMenuItem("Set \"reserve_memory\"...");
        menuItem.addActionListener(new SetServerProperty("reserve_memory"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"max_msg_memory\"...");
        menuItem.addActionListener(new SetServerProperty("max_msg_memory"));
        menu.add(menuItem);
        if (!this.m_cn.isAppliance()) {
            menuItem = new JMenuItem("Set \"msg_swapping\"...");
            menuItem.addActionListener(new SetServerProperty("msg_swapping"));
            menu.add(menuItem);
        }
        menuItem = new JMenuItem("Set \"ft_reconnect_timeout\"...");
        menuItem.addActionListener(new SetServerProperty("ft_reconnect_timeout"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"max_connections\"...");
        menuItem.addActionListener(new SetServerProperty("max_connections"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"clock_sync_interval\"...");
        menuItem.addActionListener(new SetServerProperty("clock_sync_interval"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"always_exit_on_disk_error\"...");
        menuItem.addActionListener(new SetServerProperty("always_exit_on_disk_error"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"health_check_listen\"...");
        menuItem.addActionListener(new SetHealthListenPort());
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"secondary_health_check_listen\"...");
        menuItem.addActionListener(new SetSecondaryHealthListenPort());
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Set \"client_heartbeat_server\"...");
        menuItem.addActionListener(new SetServerProperty("client_heartbeat_server"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"client_timeout_server_connection\"...");
        menuItem.addActionListener(new SetServerProperty("client_timeout_server_connection"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"server_heartbeat_client\"...");
        menuItem.addActionListener(new SetServerProperty("server_heartbeat_client"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"server_timeout_client_connection\"...");
        menuItem.addActionListener(new SetServerProperty("server_timeout_client_connection"));
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Set \"destination_backlog_swapout\"...");
        menuItem.addActionListener(new SetServerProperty("destination_backlog_swapout"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"large_destination_count\"...");
        menuItem.addActionListener(new SetServerProperty("large_destination_count"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"large_destination_memory\"...");
        menuItem.addActionListener(new SetServerProperty("large_destination_memory"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"max_client_msg_size\"...");
        menuItem.addActionListener(new SetServerProperty("max_client_msg_size"));
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Set \"routing\"...");
        menuItem.addActionListener(new SetServerProperty("routing"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"server_heartbeat_server\"...");
        menuItem.addActionListener(new SetServerProperty("server_heartbeat_server"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"server_timeout_server_connection\"...");
        menuItem.addActionListener(new SetServerProperty("server_timeout_server_connection"));
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Set \"authorization\"...");
        menuItem.addActionListener(new SetServerProperty("authorization"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"Server password\"...");
        menuItem.addActionListener(new SetServerProperty("password", true));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"user_auth\"...");
        menuItem.addActionListener(new SetServerProperty("user_auth"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"LDAP password\"...");
        menuItem.addActionListener(new SetServerProperty("ldap_credential", true));
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Set \"logfile_max_size\"...");
        menuItem.addActionListener(new SetServerProperty("logfile_max_size"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set \"logfile_max_count\"...");
        menuItem.addActionListener(new SetServerProperty("logfile_max_count"));
        menu.add(menuItem);
        menu = new JMenu("Import");
        menu.setMnemonic(73);
        menuBar.add(menu);
        menuItem = new JMenuItem("Import Queues from Server...");
        menuItem.addActionListener(new ImportQueues());
        menu.add(menuItem);
        menuItem = new JMenuItem("Import Topics from Server...");
        menuItem.addActionListener(new ImportTopics());
        menu.add(menuItem);
        menuItem = new JMenuItem("Import Bridges from Server...");
        menuItem.addActionListener(new ImportBridges());
        menu.add(menuItem);
        menuItem = new JMenuItem("Import Durables from Server...");
        menuItem.addActionListener(new ImportDurables());
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Import Groups from Server...");
        menuItem.addActionListener(new ImportGroups());
        menu.add(menuItem);
        menuItem = new JMenuItem("Import Users from Server...");
        menuItem.addActionListener(new ImportUsers());
        menu.add(menuItem);
        menuItem = new JMenuItem("Import ACLs from Server...");
        menuItem.addActionListener(new ImportACLs());
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Import Routes from Server...");
        menuItem.addActionListener(new ImportRoutes());
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Import LDAP Settings from Server...");
        menuItem.addActionListener(new ImportLDAP());
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Import from JSON File...");
        menuItem.addActionListener(new ImportFromJSON());
        menu.add(menuItem);
        menu = new JMenu("Actions");
        menu.setMnemonic(65);
        menuBar.add(menu);
        menuItem = new JMenuItem("Validate...");
        menuItem.addActionListener(new ValidateAction());
        menu.add(menuItem);
        menuItem = new JMenuItem("Update Server...");
        menuItem.addActionListener(new UpdateServer());
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Refresh From Server...");
        menuItem.addActionListener(new RefreshFromServer());
        menu.add(menuItem);
        menuItem = new JMenuItem("Force Update Server...");
        menuItem.addActionListener(new ForceUpdateServer());
        menu.add(menuItem);
        return menuBar;
    }

    void refreshServerConfig() {
        int opt = JOptionPane.showConfirmDialog(this, "Refresh configuration from server (any local changes will be lost), are you sure?", "Refresh JSON Configuration", 0);
        if (opt == 0) {
            this.txtConfig.setText(this.getServerConfig());
        }
    }

    String getServerConfig() {
        try {
            if (this.m_cn != null && this.m_cn.isConnected()) {
                this.m_config = this.m_cn.getJmsAdmin().getConfiguration();
                if (this.m_config == null) {
                    return "Error: EMS API method TibjmsAdmin.getConfiguration returned null, please update your EMS client.";
                }
                JSONObject jo = (JSONObject)this.m_parser.parse(new String(this.m_config.getAsBytes()));
                JSONWriter out = new JSONWriter();
                jo.writeJSONString((Writer)out);
                String newJson = out.toString();
                newJson = newJson.replaceAll("\\\\/", "/");
                return newJson;
            }
            return "Error: Server not selected or not connected";
        }
        catch (ParseException pe) {
            System.err.println("Parse Exception: " + pe.toString());
            Gems.debug(new String(this.m_config.getAsBytes()));
            return "Error: " + pe.toString();
        }
        catch (NoSuchMethodError m) {
            System.err.println("Exception: " + m.toString());
            return "Error: NoSuchMethodError Exception for EMS API method TibjmsAdmin.getConfiguration, please update your EMS client.";
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            return "Error: failed to retreive JSON configuration; " + e.getMessage();
        }
    }

    private void saveButtonActionPerformed(boolean force) {
        try {
            String msg = force ? "Configuration on server will be overwritten and ANY OTHER UPDATES\nAPPLIED SINCE OPENING THIS EDITOR WILL BE LOST, are you sure?" : "Configuration on server will be overwritten, are you sure?\nUse Validate option before applying.";
            int opt = JOptionPane.showConfirmDialog(this, msg, (force ? "Force " : "") + "Update Server JSON Configuration", 0);
            if (opt == 0) {
                if (this.m_cn != null && this.m_cn.isConnected() && this.m_config != null) {
                    JSONObject jo = (JSONObject)this.m_parser.parse(this.txtConfig.getText());
                    this.m_config.set(this.txtConfig.getText());
                    if (force) {
                        this.m_cn.getJmsAdmin().forceConfiguration(this.m_config);
                    } else {
                        this.m_cn.getJmsAdmin().synchronizeConfiguration(this.m_config);
                    }
                    boolean restart = this.m_cn.getJmsAdmin().isRestartRequired();
                    JOptionPane.showMessageDialog(this, "Configuration updates successfully applied to server" + (restart ? " (server restart required for some changes to take effect)" : ""), "Success", 1);
                    this.m_changed = false;
                } else {
                    JOptionPane.showMessageDialog(this, "Error: Not connected to Server", "Error", 1);
                }
            }
        }
        catch (ParseException pe) {
            JOptionPane.showMessageDialog(this, "Parse error:" + (Object)((Object)pe), "Error", 1);
            this.txtConfig.requestFocus();
            this.txtConfig.setCaretPosition(pe.getPosition());
            DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.ORANGE);
            try {
                this.txtConfig.getHighlighter().addHighlight(pe.getPosition(), pe.getPosition() + 1, painter);
            }
            catch (BadLocationException ble) {
                System.err.println("Exception: " + ble.getMessage());
            }
            return;
        }
        catch (TibjmsAdminException ax) {
            JOptionPane.showMessageDialog(this, ax.getMessage() + "\nRefresh configuration from the server and reapply your changes, or\nuse Force Update Server to overwrite (any other changes since opening the editor will be lost)", "Error", 1);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 1);
            return;
        }
    }

    private void saveAsButtonActionPerformed() {
        try {
            JSONObject jo = (JSONObject)this.m_parser.parse(this.txtConfig.getText());
            JFileChooser chooser = new JFileChooser(new File("."));
            chooser.setApproveButtonText("Save");
            chooser.setDialogTitle("Save JSON Config To File");
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                f.createNewFile();
                FileOutputStream fout = new FileOutputStream(f);
                PrintStream p = new PrintStream(fout);
                p.println(this.txtConfig.getText());
                p.close();
                this.m_changed = false;
            }
        }
        catch (ParseException pe) {
            JOptionPane.showMessageDialog(this, "Parse error:" + (Object)((Object)pe), "Error", 1);
            this.txtConfig.requestFocus();
            this.txtConfig.setCaretPosition(pe.getPosition());
            DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.ORANGE);
            try {
                this.txtConfig.getHighlighter().addHighlight(pe.getPosition(), pe.getPosition() + 1, painter);
            }
            catch (BadLocationException ble) {
                System.err.println("Exception: " + ble.getMessage());
            }
            return;
        }
        catch (IOException ie) {
            JOptionPane.showMessageDialog(this, ie.getMessage(), "Error", 1);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "Error", 1);
            return;
        }
    }

    private void addDestProps(JSONObject q, DestinationInfo qi, HashMap storesToImport, HashMap storesToIgnore) {
        try {
            q.put((Object)"name", (Object)qi.getName());
            String[] jn = qi.getJNDINames();
            if (jn != null && jn.length > 0) {
                JSONArray jlist = new JSONArray();
                q.put((Object)"jndinames", (Object)jlist);
                for (int i = 0; i < jn.length; ++i) {
                    JSONObject j = new JSONObject();
                    jlist.add((Object)j);
                    j.put((Object)"name", (Object)jn[i]);
                }
            }
            if (!qi.isPrefetchInherited()) {
                if (qi.getPrefetch() == -1) {
                    q.put((Object)"prefetch", (Object)"none");
                } else if (qi.getPrefetch() != 0) {
                    q.put((Object)"prefetch", (Object)qi.getPrefetch());
                }
            }
            if (!qi.isMaxBytesInherited() && qi.getMaxBytes() != 0L) {
                q.put((Object)"maxbytes", (Object)qi.getMaxBytes());
            }
            if (!qi.isFlowControlMaxBytesInherited() && qi.getFlowControlMaxBytes() != 0L) {
                q.put((Object)"flowControl", (Object)String.valueOf(qi.getFlowControlMaxBytes()));
            }
            if (!qi.isGlobalInherited() && qi.isGlobal()) {
                q.put((Object)"global", (Object)"true");
            }
            if (!qi.isSecureInherited() && qi.isSecure()) {
                q.put((Object)"secure", (Object)"true");
            }
            if (!qi.isSenderNameInherited() && qi.isSenderName()) {
                q.put((Object)"sender_name", (Object)"true");
            }
            if (!qi.isSenderNameEnforcedInherited() && qi.isSenderNameEnforced()) {
                q.put((Object)"sender_name_enforced", (Object)"true");
            }
            if (!qi.isExpiryOverrideInherited() && qi.getExpiryOverride() != 0L) {
                q.put((Object)"expiration", (Object)(String.valueOf(qi.getExpiryOverride()) + "msec"));
            }
            if (!qi.isMaxMsgsInherited() && qi.getMaxMsgs() != 0L) {
                q.put((Object)"maxmsgs", (Object)qi.getMaxMsgs());
            }
            if (!qi.isOverflowPolicyInherited() && qi.getOverflowPolicy() != 0) {
                if (qi.getOverflowPolicy() == 1) {
                    q.put((Object)"overflowPolicy", (Object)"discardOld");
                } else {
                    q.put((Object)"overflowPolicy", (Object)"rejectIncoming");
                }
            }
            if (!qi.isStoreInherited() && qi.getStore() != null && !qi.getStore().equals("$sys.nonfailsafe") && this.importStore(qi.getStore(), storesToImport, storesToIgnore)) {
                q.put((Object)"store", (Object)qi.getStore());
            }
            if (!qi.isRedeliveryDelayInherited() && qi.getRedeliveryDelay() != 0L) {
                q.put((Object)"redeliveryDelay", (Object)(String.valueOf(qi.getRedeliveryDelay()) + "msec"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    boolean importStore(String store, HashMap storesToImport, HashMap storesToIgnore) {
        try {
            while (true) {
                int opt;
                if (storesToImport.containsKey(store)) {
                    return true;
                }
                if (storesToIgnore.containsKey(store)) {
                    return false;
                }
                JSONObject jo = (JSONObject)this.m_parser.parse(this.txtConfig.getText());
                JSONArray ja = (JSONArray)jo.get((Object)"stores");
                if (ja != null) {
                    for (int i = 0; i < ja.size(); ++i) {
                        JSONObject o = (JSONObject)ja.get(i);
                        String sn = (String)o.get((Object)"name");
                        if (sn == null || !sn.equalsIgnoreCase(store)) continue;
                        storesToImport.put(store, store);
                        return true;
                    }
                }
                if ((opt = JOptionPane.showConfirmDialog(this, "Error: Store " + store + " does not exist. Do you want to create this store? (Click No to ignore this store, destinations for this store will default to $sys.nonfailsafe)", "Error", 0)) == 0) {
                    this.createNewFileStore(store);
                    continue;
                }
                storesToIgnore.put(store, store);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_this, ex.toString() + " (Store will be ignored)", "Error", 1);
            return false;
        }
    }

    public void createNewFileStore(String storename) {
        try {
            int i;
            int i2;
            String f;
            JSONObject jo = (JSONObject)this.m_parser.parse(this.txtConfig.getText());
            JSONArray ja = (JSONArray)jo.get((Object)"stores");
            JSONObject o = (JSONObject)ja.get(0);
            String p = null;
            if (o != null && (f = (String)o.get((Object)"file")) != null && (i2 = f.lastIndexOf(47)) > -1) {
                p = f.substring(0, i2);
            }
            GemsDummyFileStoreInfo fi = new GemsDummyFileStoreInfo(p, storename);
            boolean cont = true;
            String com = "<html>&nbsp;Enter File Store configuration:<br>&nbsp;For Mode enter sync for failsafe, or async for non-failsafe.<br>&nbsp;For Appliances use SSD or HDD for file path e.g. SSD/myStoreFile.db<br></html>";
            block2: while (cont) {
                GemsDynamicPropertyDialog d = new GemsDynamicPropertyDialog(this.m_this, "Create File Store", "com.tibco.gems.GemsDummyFileStoreInfo", com, (Object)fi);
                if ((fi = (GemsDummyFileStoreInfo)d.getObject()) == null) {
                    return;
                }
                if (ja == null) continue;
                cont = false;
                for (int i3 = 0; i3 < ja.size(); ++i3) {
                    o = (JSONObject)ja.get(i3);
                    String sn = (String)o.get((Object)"name");
                    if (sn != null && sn.equalsIgnoreCase(fi.getStoreName())) {
                        JOptionPane.showMessageDialog(this.m_this, "Error: a store with this name already exists.", "Error", 1);
                        cont = true;
                        continue block2;
                    }
                    String fn = (String)o.get((Object)"file");
                    if (fn == null || !fn.equalsIgnoreCase(fi.getFilePath())) continue;
                    JOptionPane.showMessageDialog(this.m_this, "Error: a store with this file path already exists.", "Error", 1);
                    cont = true;
                    continue block2;
                }
            }
            ja.add((Object)fi.toJSON());
            JSONWriter out = new JSONWriter();
            jo.writeJSONString((Writer)out);
            String newJson = out.toString();
            newJson = newJson.replaceAll("\\\\/", "/");
            this.txtConfig.setText(newJson);
            if (storename == null && (i = this.txtConfig.getText().indexOf("stores")) >= 0 && (i = this.txtConfig.getText().indexOf("name\":\"" + fi.getStoreName(), i)) >= 0) {
                this.txtConfig.requestFocus();
                this.txtConfig.setCaretPosition(i);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_this, ex.toString(), "Error", 1);
            return;
        }
    }

    public boolean isValidPort(String input) {
        try {
            Integer i = Integer.parseInt(input);
            return i >= 5000 && i <= 64000;
        }
        catch (Exception e) {
            return false;
        }
    }

    public class ValidationFrame
    extends JDialog {
        private JPanel dialogPane;
        private JPanel contentPanel;
        private JLabel lblWarning;
        private JScrollPane scrollPane1;
        private JTextArea results;
        private JPanel buttonBar;
        private JButton okButton;
        private JButton validButton;

        public ValidationFrame(JDialog owner) {
            super(owner, "Validate JSON Config", false);
            this.results = null;
            this.initComponents();
        }

        private void okButtonActionPerformed() {
            this.setVisible(false);
        }

        private void initComponents() {
            this.dialogPane = new JPanel();
            this.contentPanel = new JPanel();
            this.lblWarning = new JLabel();
            this.scrollPane1 = new JScrollPane();
            this.results = new JTextArea();
            this.buttonBar = new JPanel();
            this.okButton = new JButton();
            this.validButton = new JButton();
            this.setDefaultCloseOperation(2);
            this.dialogPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.dialogPane.setLayout(new BorderLayout(20, 20));
            this.contentPanel.setLayout(new BorderLayout(10, 10));
            this.lblWarning.setText("Use Edit menu in JSON Editor to search for any duplicates found.  ");
            this.lblWarning.setFont(new Font("Tahoma", 1, 14));
            this.contentPanel.add((Component)this.lblWarning, "First");
            this.scrollPane1.setPreferredSize(new Dimension(475, 275));
            this.results.setEditable(false);
            this.scrollPane1.setViewportView(this.results);
            this.contentPanel.add((Component)this.scrollPane1, "Center");
            this.dialogPane.add((Component)this.contentPanel, "Center");
            this.okButton.setText("Close");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValidationFrame.this.okButtonActionPerformed();
                }
            });
            this.validButton.setText("Revalidate");
            this.validButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValidationFrame.this.validButtonActionPerformed();
                }
            });
            this.buttonBar.add(this.validButton);
            this.buttonBar.add(this.okButton);
            this.dialogPane.add((Component)this.buttonBar, "Last");
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
            if (this.getOwner().getLocationOnScreen().x < this.getLocation().x) {
                this.setLocation(this.getLocation().x + 200, this.getLocation().y);
            } else {
                this.setLocation(this.getLocation().x - 200, this.getLocation().y);
            }
            this.setContentPane(this.dialogPane);
            this.pack();
        }

        int checkDuplicates(JSONArray ja, String t, String n) {
            HashMap<String, String> list = new HashMap<String, String>();
            int ret = 0;
            if (ja != null) {
                for (int i = 0; i < ja.size(); ++i) {
                    JSONObject o = (JSONObject)ja.get(i);
                    String sn = (String)o.get((Object)n);
                    if (sn == null) continue;
                    if (list.containsKey(sn)) {
                        ++ret;
                        this.results.append("Duplicate " + t + " found, " + n + ": " + sn + "\n");
                        continue;
                    }
                    list.put(sn, sn);
                }
            }
            this.results.append(ja.size() + " " + t + "s found, " + ret + " duplicates\n");
            return ret;
        }

        int checkBridgeDuplicates(JSONArray ja, String src_type, String dest_type) {
            HashMap<String, String> list = new HashMap<String, String>();
            int ret = 0;
            int cnt = 0;
            if (ja != null) {
                for (int i = 0; i < ja.size(); ++i) {
                    JSONObject o = (JSONObject)ja.get(i);
                    String sn = (String)o.get((Object)src_type);
                    if (sn == null) continue;
                    JSONArray da = (JSONArray)o.get((Object)"destinations");
                    if (da.size() == 1) {
                        JSONObject d = (JSONObject)da.get(0);
                        String dn = (String)d.get((Object)dest_type);
                        if (dn == null) continue;
                        ++cnt;
                        String sd = (String)list.get(sn);
                        if (sd != null && sd.equals(dn)) {
                            ++ret;
                            this.results.append("Duplicate " + src_type + " to " + dest_type + " bridge found, source " + sn + " target " + dn + "\n");
                            continue;
                        }
                        list.put(sn, dn);
                        continue;
                    }
                    Gems.debug("Bad bridge destinations size " + da.size());
                }
            }
            this.results.append(cnt + " " + src_type + " to " + dest_type + " bridges found, " + ret + " duplicates\n");
            return ret;
        }

        void doValidate() {
            block27: {
                try {
                    this.results.setText("");
                    try {
                        JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                        JSONArray ja = (JSONArray)jo.get((Object)"stores");
                        this.checkDuplicates(ja, "store", "name");
                        ja = (JSONArray)jo.get((Object)"queues");
                        this.checkDuplicates(ja, "queue", "name");
                        ja = (JSONArray)jo.get((Object)"topics");
                        this.checkDuplicates(ja, "topic", "name");
                        ja = (JSONArray)jo.get((Object)"bridges");
                        this.checkBridgeDuplicates(ja, "topic", "topic");
                        this.checkBridgeDuplicates(ja, "topic", "queue");
                        this.checkBridgeDuplicates(ja, "queue", "topic");
                        this.checkBridgeDuplicates(ja, "queue", "queue");
                        ja = (JSONArray)jo.get((Object)"durables");
                        this.checkDuplicates(ja, "durable", "name");
                        ja = (JSONArray)jo.get((Object)"groups");
                        this.checkDuplicates(ja, "group", "name");
                        ja = (JSONArray)jo.get((Object)"users");
                        this.checkDuplicates(ja, "user", "name");
                        ja = (JSONArray)jo.get((Object)"routes");
                        this.checkDuplicates(ja, "route", "name");
                        JSONObject to = (JSONObject)jo.get((Object)"tibemsd");
                        if (to == null) break block27;
                        boolean m = false;
                        Boolean ms = null;
                        Boolean rt = null;
                        if (to.containsKey((Object)"msg_swapping")) {
                            try {
                                ms = new Boolean((String)to.get((Object)"msg_swapping"));
                            }
                            catch (Exception e1) {
                                try {
                                    ms = (Boolean)to.get((Object)"msg_swapping");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!to.containsKey((Object)"reserve_memory")) {
                            this.results.append("It is recommended to set server property: reserve_memory\n");
                            m = true;
                        }
                        if ((ms == null || ms.booleanValue()) && !to.containsKey((Object)"destination_backlog_swapout")) {
                            this.results.append("It is recommended to set server property: destination_backlog_swapout\n");
                            m = true;
                        }
                        if (!to.containsKey((Object)"client_heartbeat_server")) {
                            this.results.append("It is recommended to set server property: client_heartbeat_server\n");
                            m = true;
                        }
                        if (!to.containsKey((Object)"client_timeout_server_connection")) {
                            this.results.append("It is recommended to set server property: client_timeout_server_connection\n");
                            m = true;
                        }
                        if (!to.containsKey((Object)"server_heartbeat_client")) {
                            this.results.append("It is recommended to set server property: server_heartbeat_client\n");
                            m = true;
                        }
                        if (!to.containsKey((Object)"server_timeout_client_connection")) {
                            this.results.append("It is recommended to set server property: server_timeout_client_connection\n");
                            m = true;
                        }
                        try {
                            rt = (Boolean)to.get((Object)"routing");
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                        if (rt != null && rt.booleanValue()) {
                            if (!to.containsKey((Object)"server_heartbeat_server")) {
                                this.results.append("For routing it is recommended to set server property: server_heartbeat_server\n");
                                m = true;
                            }
                            if (!to.containsKey((Object)"server_timeout_server_connection")) {
                                this.results.append("For routing it is recommended to set server property: server_timeout_server_connection\n");
                                m = true;
                            }
                        }
                        if (m) {
                            this.results.append("Use \"Set Property\" menu in JSON Editor to set server properties\n");
                        }
                        JSONArray pl = (JSONArray)to.get((Object)"primary_listens");
                        JSONArray sl = (JSONArray)to.get((Object)"secondary_listens");
                        if (pl == null || sl == null || sl.size() <= 0) break block27;
                        if (pl.size() != sl.size()) {
                            this.results.append("Warning; primary_listens and secondary_listens have different number of entries\n");
                        }
                        Boolean au = null;
                        String sn = null;
                        try {
                            sn = (String)to.get((Object)"server");
                            au = (Boolean)to.get((Object)"authorization");
                            JSONArray ul = (JSONArray)jo.get((Object)"users");
                            if (sn != null && au != null && au.booleanValue() && ul != null) {
                                boolean ok = false;
                                for (int i = 0; i < ul.size(); ++i) {
                                    JSONObject o = (JSONObject)ul.get(i);
                                    String un = (String)o.get((Object)"name");
                                    if (un == null || !un.equals(sn)) continue;
                                    ok = true;
                                    break;
                                }
                                if (!ok) {
                                    this.results.append("Warning; with authorization a user named " + sn + " must exist for FT connection\n");
                                }
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (ParseException pe) {
                        this.results.append("JSON parse error:\n");
                        this.results.append(pe.toString());
                        GemsJSONConfigEditor.this.txtConfig.requestFocus();
                        GemsJSONConfigEditor.this.txtConfig.setCaretPosition(pe.getPosition());
                        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.ORANGE);
                        GemsJSONConfigEditor.this.txtConfig.getHighlighter().addHighlight(pe.getPosition(), pe.getPosition() + 1, painter);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), "Error", 1);
                    return;
                }
            }
        }

        private void validButtonActionPerformed() {
            this.doValidate();
        }

        public String getSelectedText() {
            if (this.results != null) {
                return this.results.getSelectedText();
            }
            return "";
        }
    }

    public class MyDocListener
    implements DocumentListener {
        boolean first = true;

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (!this.first) {
                GemsJSONConfigEditor.this.m_changed = true;
            }
            this.first = false;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (!this.first) {
                GemsJSONConfigEditor.this.m_changed = true;
            }
            this.first = false;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (!this.first) {
                GemsJSONConfigEditor.this.m_changed = true;
            }
            this.first = false;
        }
    }

    public class JSONWriter
    extends StringWriter {
        private int indent = 0;

        @Override
        public void write(int c) {
            if ((char)c == '[' || (char)c == '{') {
                super.write(c);
                super.write(10);
                ++this.indent;
                this.writeIndentation();
            } else if ((char)c == ',') {
                super.write(c);
                super.write(10);
                this.writeIndentation();
            } else if ((char)c == ']' || (char)c == '}') {
                super.write(10);
                --this.indent;
                this.writeIndentation();
                super.write(c);
            } else {
                super.write(c);
            }
        }

        private void writeIndentation() {
            for (int i = 0; i < this.indent; ++i) {
                super.write("   ");
            }
        }
    }

    class SetUserProperty
    implements ActionListener {
        String prop;
        boolean passw = false;

        public SetUserProperty(String prop) {
            this.prop = prop;
        }

        public SetUserProperty(String prop, boolean passw) {
            this.prop = prop;
            this.passw = passw;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsProperty gp = (GemsProperty)props.get(this.prop);
            if (gp != null) {
                GemsSetPropDialog d = new GemsSetPropDialog((Dialog)GemsJSONConfigEditor.this.m_this, "Set User Password", false, this.passw);
                try {
                    JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                    JSONArray ja = (JSONArray)jo.get((Object)"users");
                    if (ja != null) {
                        Hashtable<String, GemsProperty> us = new Hashtable<String, GemsProperty>();
                        for (int i = 0; i < ja.size(); ++i) {
                            JSONObject o = (JSONObject)ja.get(i);
                            String un = (String)o.get((Object)"name");
                            us.put(un, new GemsProperty(un, gp.type, gp.help));
                        }
                        String v = d.getValue(us, null, null, true);
                        if (v != null) {
                            String u = d.m_selProp;
                            for (int i = 0; i < ja.size(); ++i) {
                                JSONObject o = (JSONObject)ja.get(i);
                                String un = (String)o.get((Object)"name");
                                if (!un.equals(u)) continue;
                                if ((v = TibjmsAdmin.manglePassword((String)v)) == null) break;
                                o.put((Object)"password", (Object)v);
                                break;
                            }
                            JSONWriter out = new JSONWriter();
                            jo.writeJSONString((Writer)out);
                            String newJson = out.toString();
                            newJson = newJson.replaceAll("\\\\/", "/");
                            GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                            int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("users");
                            if (i >= 0 && (i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf(u, i)) >= 0) {
                                GemsJSONConfigEditor.this.txtConfig.requestFocus();
                                GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
            }
        }
    }

    class SetServerProperty
    implements ActionListener {
        String prop;
        boolean passw = false;

        public SetServerProperty(String prop) {
            this.prop = prop;
        }

        public SetServerProperty(String prop, boolean passw) {
            this.prop = prop;
            this.passw = passw;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block19: {
                GemsProperty gp = (GemsProperty)props.get(this.prop);
                if (gp != null) {
                    GemsSetPropDialog d = new GemsSetPropDialog((Dialog)GemsJSONConfigEditor.this.m_this, "Set Server Property", true, this.passw);
                    try {
                        JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                        JSONObject to = (JSONObject)jo.get((Object)"tibemsd");
                        if (to == null) break block19;
                        String sp = null;
                        try {
                            if (gp.type.isAssignableFrom(Class.forName("java.lang.String"))) {
                                sp = (String)to.get((Object)gp.name);
                            } else if (gp.type.isAssignableFrom(Boolean.TYPE)) {
                                Boolean b = (Boolean)to.get((Object)gp.name);
                                sp = b.toString();
                            } else if (gp.type.isAssignableFrom(Long.TYPE)) {
                                Long l = (Long)to.get((Object)gp.name);
                                sp = l.toString();
                            }
                        }
                        catch (Exception x) {
                            Gems.debug(x.toString());
                        }
                        String v = d.getValue(gp, sp);
                        if (v != null && this.passw) {
                            v = TibjmsAdmin.manglePassword((String)v);
                        }
                        if (v != null) {
                            if (gp.type.isAssignableFrom(Class.forName("java.lang.String"))) {
                                to.put((Object)gp.name, (Object)v);
                            } else if (gp.type.isAssignableFrom(Boolean.TYPE)) {
                                to.put((Object)gp.name, (Object)Boolean.valueOf(v));
                            } else if (gp.type.isAssignableFrom(Long.TYPE)) {
                                to.put((Object)gp.name, (Object)Long.valueOf(v));
                            } else {
                                System.err.println("Error JSON type " + gp.type.toString() + " not supported");
                            }
                            JSONWriter out = new JSONWriter();
                            jo.writeJSONString((Writer)out);
                            String newJson = out.toString();
                            newJson = newJson.replaceAll("\\\\/", "/");
                            GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                            int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("tibemsd");
                            if (i >= 0 && (i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf(gp.name, i)) >= 0) {
                                GemsJSONConfigEditor.this.txtConfig.requestFocus();
                                GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                            }
                        }
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                }
            }
        }
    }

    class ValidateAction
    implements ActionListener {
        ValidateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsJSONConfigEditor.this.validFrame == null) {
                GemsJSONConfigEditor.this.validFrame = new ValidationFrame(GemsJSONConfigEditor.this.m_this);
            }
            GemsJSONConfigEditor.this.validFrame.setVisible(true);
            GemsJSONConfigEditor.this.validFrame.doValidate();
        }
    }

    class SetSecondaryHealthListenPort
    implements ActionListener {
        SetSecondaryHealthListenPort() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JPanel messagePanel = new JPanel();
                messagePanel.setLayout(new BoxLayout(messagePanel, 1));
                messagePanel.add(new JLabel("Enter Secondary Health Check Listen Port:"));
                JTextField juf = new JTextField(10);
                messagePanel.add(juf);
                messagePanel.add(new JLabel("<html>Enter port in range[5000-64000]<br>"));
                int result = JOptionPane.showConfirmDialog(null, messagePanel, "Set Secondary Health Check Listen Port", 2);
                String port = null;
                if (result == 0) {
                    port = juf.getText();
                    if (port == null || port.length() == 0 || !GemsJSONConfigEditor.this.isValidPort(port)) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error invalid port", "Error", 1);
                        return;
                    }
                } else {
                    return;
                }
                String purl = null;
                String surl = null;
                JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                JSONObject to = (JSONObject)jo.get((Object)"tibemsd");
                if (to != null) {
                    String shl = (String)to.get((Object)"secondary_health_check_listen");
                    JSONArray sl = (JSONArray)to.get((Object)"secondary_listens");
                    if (shl == null || shl.length() == 0) {
                        if (sl == null || sl.size() == 0) {
                            JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: no secondary_listens found.", "Error", 1);
                            return;
                        }
                        for (int i = 0; sl != null && i < sl.size(); ++i) {
                            JSONObject o = (JSONObject)sl.get(i);
                            if (o.containsKey((Object)"ft_active") && sl.size() != 1) continue;
                            surl = (String)o.get((Object)"url");
                            surl = "http" + surl.substring(surl.indexOf(58));
                            surl = surl.substring(0, surl.lastIndexOf(58) + 1);
                            break;
                        }
                    } else {
                        surl = shl.substring(0, shl.lastIndexOf(58) + 1);
                    }
                    messagePanel = new JPanel();
                    messagePanel.setLayout(new BoxLayout(messagePanel, 1));
                    messagePanel.add(new JLabel("Confirm the following secondary health check listen URL:"));
                    messagePanel.add(new JLabel(" "));
                    messagePanel.add(new JLabel("secondary_health_check_listen URL:"));
                    JTextField st = new JTextField(25);
                    if (surl != null) {
                        st.setText(surl + port);
                    }
                    messagePanel.add(st);
                    result = JOptionPane.showConfirmDialog(null, messagePanel, "Set Secondary Health Check Listen Port", 2);
                    if (result == 0) {
                        surl = st.getText();
                        if (surl != null && surl.length() > 0) {
                            to.put((Object)"secondary_health_check_listen", (Object)surl);
                        }
                    } else {
                        return;
                    }
                }
                JSONWriter out = new JSONWriter();
                jo.writeJSONString((Writer)out);
                String newJson = out.toString();
                newJson = newJson.replaceAll("\\\\/", "/");
                GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("tibemsd");
                if (i >= 0 && (i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf(purl, i)) >= 0) {
                    GemsJSONConfigEditor.this.txtConfig.requestFocus();
                    GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class SetHealthListenPort
    implements ActionListener {
        SetHealthListenPort() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JPanel messagePanel = new JPanel();
                messagePanel.setLayout(new BoxLayout(messagePanel, 1));
                messagePanel.add(new JLabel("Enter Health Check Listen Port:"));
                JTextField juf = new JTextField(10);
                messagePanel.add(juf);
                messagePanel.add(new JLabel("<html>Enter port in range[5000-64000]<br>"));
                int result = JOptionPane.showConfirmDialog(null, messagePanel, "Set Health Check Listen Port", 2);
                String port = null;
                if (result == 0) {
                    port = juf.getText();
                    if (port == null || port.length() == 0 || !GemsJSONConfigEditor.this.isValidPort(port)) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error invalid port", "Error", 1);
                        return;
                    }
                } else {
                    return;
                }
                String purl = null;
                Object surl = null;
                JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                JSONObject to = (JSONObject)jo.get((Object)"tibemsd");
                if (to != null) {
                    String hl = (String)to.get((Object)"health_check_listen");
                    JSONArray pl = (JSONArray)to.get((Object)"primary_listens");
                    if (hl == null || hl.length() == 0) {
                        if (pl == null || pl.size() == 0) {
                            JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: no primary_listens found.", "Error", 1);
                            return;
                        }
                        for (int i = 0; i < pl.size(); ++i) {
                            JSONObject o = (JSONObject)pl.get(i);
                            if (o.containsKey((Object)"ft_active") && pl.size() != 1) continue;
                            purl = (String)o.get((Object)"url");
                            purl = "http" + purl.substring(purl.indexOf(58));
                            purl = purl.substring(0, purl.lastIndexOf(58) + 1);
                            break;
                        }
                    } else {
                        purl = hl.substring(0, hl.lastIndexOf(58) + 1);
                    }
                    messagePanel = new JPanel();
                    messagePanel.setLayout(new BoxLayout(messagePanel, 1));
                    messagePanel.add(new JLabel("Confirm the following new health check listen URL:"));
                    messagePanel.add(new JLabel(" "));
                    messagePanel.add(new JLabel("health_check_listen URL:"));
                    JTextField pt = new JTextField(25);
                    if (purl != null) {
                        pt.setText(purl + port);
                    }
                    messagePanel.add(pt);
                    result = JOptionPane.showConfirmDialog(null, messagePanel, "Set Health Check Listen Port", 2);
                    if (result == 0) {
                        purl = pt.getText();
                        if (purl != null && purl.length() > 0) {
                            to.put((Object)"health_check_listen", (Object)purl);
                        }
                    } else {
                        return;
                    }
                }
                JSONWriter out = new JSONWriter();
                jo.writeJSONString((Writer)out);
                String newJson = out.toString();
                newJson = newJson.replaceAll("\\\\/", "/");
                GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("tibemsd");
                if (i >= 0 && (i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf(purl, i)) >= 0) {
                    GemsJSONConfigEditor.this.txtConfig.requestFocus();
                    GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class NewListenPort
    implements ActionListener {
        NewListenPort() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int i;
                JPanel messagePanel = new JPanel();
                messagePanel.setLayout(new BoxLayout(messagePanel, 1));
                messagePanel.add(new JLabel("Add New Listen Port:"));
                JTextField juf = new JTextField(10);
                messagePanel.add(juf);
                messagePanel.add(new JLabel("<html>Enter port in range[5000-64000]<br>(For EMS Appliance ensure it's not use by other instance on FT pair)"));
                int result = JOptionPane.showConfirmDialog(null, messagePanel, "New Listen Port", 2);
                String port = null;
                if (result == 0) {
                    port = juf.getText();
                    if (port == null || port.length() == 0 || !GemsJSONConfigEditor.this.isValidPort(port)) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error invalid port", "Error", 1);
                        return;
                    }
                } else {
                    return;
                }
                String purl = null;
                String surl = null;
                JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                JSONObject to = (JSONObject)jo.get((Object)"tibemsd");
                if (to != null) {
                    JSONObject o;
                    JSONArray pl = (JSONArray)to.get((Object)"primary_listens");
                    JSONArray sl = (JSONArray)to.get((Object)"secondary_listens");
                    if (pl == null || pl.size() == 0) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: no primary_listens found.", "Error", 1);
                        return;
                    }
                    for (i = 0; i < pl.size(); ++i) {
                        o = (JSONObject)pl.get(i);
                        if (o.containsKey((Object)"ft_active") && pl.size() != 1) continue;
                        purl = (String)o.get((Object)"url");
                        purl = purl.substring(0, purl.lastIndexOf(58) + 1);
                        break;
                    }
                    for (i = 0; sl != null && i < sl.size(); ++i) {
                        o = (JSONObject)sl.get(i);
                        if (o.containsKey((Object)"ft_active") && sl.size() != 1) continue;
                        surl = (String)o.get((Object)"url");
                        surl = surl.substring(0, surl.lastIndexOf(58) + 1);
                        break;
                    }
                    messagePanel = new JPanel();
                    messagePanel.setLayout(new BoxLayout(messagePanel, 1));
                    messagePanel.add(new JLabel("Confirm the following new listen URLs:"));
                    messagePanel.add(new JLabel(" "));
                    messagePanel.add(new JLabel("primary_listens URL:"));
                    JTextField pt = new JTextField(25);
                    if (purl != null) {
                        pt.setText(purl + port);
                    }
                    messagePanel.add(pt);
                    messagePanel.add(new JLabel("secondary_listens URL:"));
                    JTextField st = new JTextField(25);
                    if (surl != null) {
                        st.setText(surl + port);
                    }
                    messagePanel.add(st);
                    result = JOptionPane.showConfirmDialog(null, messagePanel, "New Listen Port", 2);
                    if (result == 0) {
                        JSONObject u;
                        purl = pt.getText();
                        surl = st.getText();
                        if (purl != null && purl.length() > 0) {
                            u = new JSONObject();
                            u.put((Object)"url", (Object)purl);
                            pl.add((Object)u);
                        }
                        if (surl != null && surl.length() > 0) {
                            if (sl == null) {
                                sl = new JSONArray();
                                to.put((Object)"secondary_listens", (Object)sl);
                            }
                            u = new JSONObject();
                            u.put((Object)"url", (Object)surl);
                            sl.add((Object)u);
                        }
                    } else {
                        return;
                    }
                }
                JSONWriter out = new JSONWriter();
                jo.writeJSONString((Writer)out);
                String newJson = out.toString();
                newJson = newJson.replaceAll("\\\\/", "/");
                GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("tibemsd");
                if (i >= 0 && (i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf(purl, i)) >= 0) {
                    GemsJSONConfigEditor.this.txtConfig.requestFocus();
                    GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class NewConnectionFactory
    implements ActionListener {
        NewConnectionFactory() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                JSONArray ja = (JSONArray)jo.get((Object)"factories");
                GemsDummyConnectionFactoryInfo fi = new GemsDummyConnectionFactoryInfo();
                boolean cont = true;
                String com = "<html>&nbsp;Jndi Name is mandatory, other fields can be left blank for defaults.<br>&nbsp;Set Destination Type to 1 for Queue, 2 for Topic, or leave blank for generic. <br>&nbsp;For load balancing, set Metric to 1 for connections, 2 for byte rate, or leave blank for none.</html>";
                block2: while (cont) {
                    GemsDynamicPropertyDialog d = new GemsDynamicPropertyDialog(GemsJSONConfigEditor.this.m_this, "Create Connection Factory", "com.tibco.gems.GemsDummyConnectionFactoryInfo", com, (Object)fi);
                    if ((fi = (GemsDummyConnectionFactoryInfo)((Object)d.getObject())) == null) {
                        return;
                    }
                    if (ja == null) continue;
                    cont = false;
                    for (int i = 0; i < ja.size(); ++i) {
                        JSONObject o = (JSONObject)ja.get(i);
                        String fn = (String)o.get((Object)"name");
                        if (fn == null || fn.length() == 0) {
                            JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: a factory name must be entered.", "Error", 1);
                            cont = true;
                            continue block2;
                        }
                        if (fn == null || !fn.equalsIgnoreCase(fi.getJndiName())) continue;
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: a factory with this name already exists.", "Error", 1);
                        cont = true;
                        continue block2;
                    }
                }
                ja.add((Object)fi.toJSON());
                JSONWriter out = new JSONWriter();
                jo.writeJSONString((Writer)out);
                String newJson = out.toString();
                newJson = newJson.replaceAll("\\\\/", "/");
                GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("factories");
                if (i >= 0 && (i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("name\":\"" + fi.getJndiName(), i)) >= 0) {
                    GemsJSONConfigEditor.this.txtConfig.requestFocus();
                    GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class NewFileStore
    implements ActionListener {
        NewFileStore() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsJSONConfigEditor.this.createNewFileStore(null);
        }
    }

    class ImportFromJSON
    implements ActionListener {
        File currentDir = null;

        ImportFromJSON() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                StringBuilder sb;
                BufferedReader d;
                String json = null;
                JSONObject jo = null;
                JFileChooser chooser = new JFileChooser(this.currentDir);
                chooser.setDialogTitle("Import Config From JSON File");
                int returnVal = chooser.showOpenDialog(GemsJSONConfigEditor.this.m_this);
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    this.currentDir = chooser.getCurrentDirectory();
                    d = new BufferedReader(new FileReader(f));
                    String line = d.readLine();
                    sb = new StringBuilder();
                    while (line != null) {
                        sb.append(line);
                        sb.append('\n');
                        line = d.readLine();
                    }
                } else {
                    return;
                }
                d.close();
                jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(sb.toString());
                json = sb.toString();
                String s = (String)JOptionPane.showInputDialog(GemsJSONConfigEditor.this.m_this, "Choose the JSON configuration part to import.\nE.g. one of; queues, topics, users, acls etc.", "Import from JSON File", -1, null, null, null);
                if (s == null || s.length() == 0) {
                    return;
                }
                Object o = jo.get((Object)s);
                if (s == null || !(o instanceof JSONArray) || ((JSONArray)o).size() == 0) {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "JSON array type for " + s + " not found, or empty", "Error", 1);
                    return;
                }
                JSONArray ja = (JSONArray)o;
                boolean c = false;
                int n = JOptionPane.showOptionDialog(GemsJSONConfigEditor.this.m_this, "Are you sure you want to import " + ja.size() + " " + s + "\nSelect \"Replace\" to replace all " + s + ", or \"Merge\" to keep existing " + s + ".\nNote; merge does not detect duplicates.", "Import from JSON File", 1, 3, null, GemsJSONConfigEditor.this.options, GemsJSONConfigEditor.this.options[2]);
                if (n != 0 && n != 1) {
                    return;
                }
                try {
                    if (s.equals("users")) {
                        for (int i = 0; i < ja.size(); ++i) {
                            String np;
                            JSONObject uo = (JSONObject)ja.get(i);
                            String pw = (String)uo.get((Object)"password");
                            String nm = (String)uo.get((Object)"name");
                            if (pw == null || pw.length() != 34 || !(np = TibjmsAdmin.unmanglePassword((String)pw)).equals(pw)) continue;
                            System.err.println("Error migrating password for user: " + nm + " (password must be set manually)");
                            uo.put((Object)"password", null);
                            Gems.debug("Remangling password- old: " + pw + " new: " + np);
                        }
                    }
                }
                catch (Throwable i) {
                    // empty catch block
                }
                JSONObject jo1 = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                if (n == 0) {
                    jo1.put((Object)s, (Object)ja);
                } else {
                    JSONArray ja1 = (JSONArray)jo1.get((Object)s);
                    if (ja1 != null) {
                        ja1.addAll((Collection)ja);
                    } else {
                        jo1.put((Object)s, (Object)ja);
                    }
                }
                JSONWriter out = new JSONWriter();
                jo1.writeJSONString((Writer)out);
                String newJson = out.toString();
                newJson = newJson.replaceAll("\\\\/", "/");
                GemsJSONConfigEditor.this.txtConfig.setText(newJson);
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Parse error:" + (Object)((Object)pe), "Error", 1);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class ImportLDAP
    implements ActionListener {
        ImportLDAP() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsConnectionPicker cp = new GemsConnectionPicker(GemsJSONConfigEditor.this.m_this, null, "import LDAP from");
                GemsConnectionNode cn = cp.getConnection();
                if (GemsJSONConfigEditor.this.m_cn != null && GemsJSONConfigEditor.this.m_cn == cn) {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Cannot import from the same Server!", "Error", 1);
                    return;
                }
                if (cn != null && cn.isConnected()) {
                    int n = JOptionPane.showConfirmDialog(GemsJSONConfigEditor.this.m_this, "Are you sure you want to import LDAP settings from server: " + cn.getName() + "\nExisting LDAP configration will be overwritten.\nPasswords cannot be imported, use \"Set Property\" menu to set LDAP credential", "Import LDAP", 0);
                    if (n != 0) {
                        return;
                    }
                    ServerInfo si = cn.getJmsServerInfo(false);
                    LDAPParams ld = null;
                    if (si != null && (ld = si.getLDAPParams()) != null) {
                        JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                        JSONObject to = (JSONObject)jo.get((Object)"tibemsd");
                        if (to != null) {
                            String lds = ld.toString();
                            String v = GemsUtilities.getPropValueFromString("ldapalgfilt", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams());
                            if (v != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_all_groups_filter", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapalufilt", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_all_users_filter", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapcache", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_cache_enabled", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapcttl", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_cache_ttl", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapconntp", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_conn_type", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapdgnmatr", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_dynamic_group_attribute", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapdgclass", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_dynamic_group_class", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapdmuatr", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_dynamic_member_url_attribute", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapgbasedn", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_group_base_dn", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapgnmfilt", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_group_filter", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapgscope", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_group_scope", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapprinc", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_principal", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapsgnmatr", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_static_group_attribute", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapsgclass", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_static_group_class", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapsmematr", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_static_member_attribute", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapsgmfilt", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_static_group_member_filter", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapcadir", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_tls_cacert_dir", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapcafile", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_tls_cacert_file", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapcipher", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_tls_cipher_suite", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapcert", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_tls_client_cert", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapkey", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_tls_key_file", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldaprand", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_tls_rand_file", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapurl", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_url", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapunmatr", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_user_attribute", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapubasedn", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_user_base_dn", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapuclass", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_user_class", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapunmfilt", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_user_filter", (Object)v);
                            }
                            if ((v = GemsUtilities.getPropValueFromString("ldapuscope", lds, GemsJSONConfigEditor.this.m_cn.getLDAPParams())) != null && v.length() != 0 && !v.equals("null")) {
                                to.put((Object)"ldap_user_scope", (Object)v);
                            }
                        }
                        JSONWriter out = new JSONWriter();
                        jo.writeJSONString((Writer)out);
                        String newJson = out.toString();
                        newJson = newJson.replaceAll("\\\\/", "/");
                        GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "LDAP configuration was successfully imported from server: " + cn.getName() + "\nSelect \"Update Server...\" to apply", "Success", 1);
                        int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("tibemsd");
                        if (i < 0) return;
                        GemsJSONConfigEditor.this.txtConfig.requestFocus();
                        GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                        return;
                    }
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "No LDAP configuration could be imported from: " + cn.getName() + "\nCheck the server is active and has LDAP configured.", "Fail", 1);
                    return;
                }
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Not connected to Server", "Error", 1);
                return;
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Parse error:" + (Object)((Object)pe), "Error", 1);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class ImportRoutes
    implements ActionListener {
        ImportRoutes() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsConnectionPicker cp = new GemsConnectionPicker(GemsJSONConfigEditor.this.m_this, null, "import routes from");
                GemsConnectionNode cn = cp.getConnection();
                int c = 0;
                if (GemsJSONConfigEditor.this.m_cn != null && GemsJSONConfigEditor.this.m_cn == cn) {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Cannot import from the same Server!", "Error", 1);
                    return;
                }
                if (cn != null && cn.isConnected()) {
                    int n = JOptionPane.showOptionDialog(GemsJSONConfigEditor.this.m_this, "Are you sure you want to import all routes users from server: " + cn.getName() + " (SSL and selectors not supported)\nSelect \"Replace\" to replace all routes, or \"Merge\" to keep existing routes.\nNote; merge does not detect duplicates.", "Import Routes", 1, 3, null, GemsJSONConfigEditor.this.options, GemsJSONConfigEditor.this.options[2]);
                    if (n != 0 && n != 1) {
                        return;
                    }
                    RouteInfo[] ri = cn.getJmsAdmin().getRoutes();
                    JSONArray ulist = new JSONArray();
                    for (int i = 0; ri != null && i < ri.length; ++i) {
                        if (!ri[i].isConfigured()) continue;
                        JSONObject u = new JSONObject();
                        u.put((Object)"name", (Object)ri[i].getName());
                        u.put((Object)"url", (Object)ri[i].getURL());
                        u.put((Object)"zone_name", (Object)ri[i].getZoneName());
                        if (ri[i].getZoneType() == 1) {
                            u.put((Object)"zone_type", (Object)"1hop");
                        }
                        ulist.add((Object)u);
                        ++c;
                    }
                    if (c == 0) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "0 routes were imported from server: " + cn.getName() + "\nCheck the server is active and has routes configured.", "Fail", 1);
                        return;
                    }
                    JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                    if (n == 0) {
                        jo.put((Object)"routes", (Object)ulist);
                    } else {
                        JSONArray ja = (JSONArray)jo.get((Object)"routes");
                        if (ja != null) {
                            ja.addAll((Collection)ulist);
                        } else {
                            jo.put((Object)"routes", (Object)ulist);
                        }
                    }
                    JSONWriter out = new JSONWriter();
                    jo.writeJSONString((Writer)out);
                    String newJson = out.toString();
                    newJson = newJson.replaceAll("\\\\/", "/");
                    GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, c + " routes were successfully imported from server: " + cn.getName() + "\nSelect \"Update Server...\" to apply", "Success", 1);
                    int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("routes");
                    if (i >= 0) {
                        GemsJSONConfigEditor.this.txtConfig.requestFocus();
                        GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                    }
                } else {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Not connected to Server", "Error", 1);
                }
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Parse error:" + (Object)((Object)pe), "Error", 1);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class ImportACLs
    implements ActionListener {
        ImportACLs() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsConnectionPicker cp = new GemsConnectionPicker(GemsJSONConfigEditor.this.m_this, null, "import ACLs from");
                GemsConnectionNode cn = cp.getConnection();
                int c = 0;
                if (GemsJSONConfigEditor.this.m_cn != null && GemsJSONConfigEditor.this.m_cn == cn) {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Cannot import from the same Server!", "Error", 1);
                    return;
                }
                if (cn != null && cn.isConnected()) {
                    int n = JOptionPane.showOptionDialog(GemsJSONConfigEditor.this.m_this, "Are you sure you want to import all ACLs from server: " + cn.getName() + "\nSelect \"Replace\" to replace all ACLs, or \"Merge\" to keep existing ACLs.\nNote; merge does not detect duplicates.", "Import ACLs", 1, 3, null, GemsJSONConfigEditor.this.options, GemsJSONConfigEditor.this.options[2]);
                    if (n != 0 && n != 1) {
                        return;
                    }
                    Object[] al = cn.getJmsAdmin().getPermissions();
                    JSONArray ulist = new JSONArray();
                    for (int i = 0; al != null && i < al.length; ++i) {
                        ACLEntry acl;
                        if (al[i] instanceof ACLEntry) {
                            acl = (ACLEntry)al[i];
                            DestinationInfo di = acl.getDestination();
                            PrincipalInfo pi = acl.getPrincipal();
                            Permissions p = acl.getPermissions();
                            JSONObject u = new JSONObject();
                            if (pi instanceof UserInfo) {
                                u.put((Object)"user", (Object)pi.getName());
                            } else {
                                u.put((Object)"group", (Object)pi.getName());
                            }
                            u.put((Object)"dest", (Object)di.getName());
                            if (di instanceof TopicInfo) {
                                u.put((Object)"type", (Object)"topic");
                                if (p.hasPermission(64L)) {
                                    u.put((Object)"durable", (Object)true);
                                }
                                if (p.hasPermission(32L)) {
                                    u.put((Object)"subscribe", (Object)true);
                                }
                                if (p.hasPermission(16L)) {
                                    u.put((Object)"publish", (Object)true);
                                }
                                if (p.hasPermission(128L)) {
                                    u.put((Object)"use_durable", (Object)true);
                                }
                            } else {
                                u.put((Object)"type", (Object)"queue");
                                if (p.hasPermission(4L)) {
                                    u.put((Object)"browse", (Object)true);
                                }
                                if (p.hasPermission(2L)) {
                                    u.put((Object)"receive", (Object)true);
                                }
                                if (p.hasPermission(1L)) {
                                    u.put((Object)"send", (Object)true);
                                }
                            }
                            if (p.hasPermission(131072L)) {
                                u.put((Object)"create", (Object)true);
                            }
                            if (p.hasPermission(262144L)) {
                                u.put((Object)"delete", (Object)true);
                            }
                            if (p.hasPermission(524288L)) {
                                u.put((Object)"modify", (Object)true);
                            }
                            if (p.hasPermission(0x100000L)) {
                                u.put((Object)"purge", (Object)true);
                            }
                            if (p.hasPermission(65536L)) {
                                u.put((Object)"view", (Object)true);
                            }
                            ulist.add((Object)u);
                            ++c;
                            continue;
                        }
                        if (!(al[i] instanceof AdminACLEntry)) continue;
                        acl = (AdminACLEntry)al[i];
                        PrincipalInfo pi = acl.getPrincipal();
                        AdminPermissions p = acl.getPermissions();
                        JSONObject u = new JSONObject();
                        u.put((Object)"type", (Object)"admin");
                        if (pi instanceof UserInfo) {
                            u.put((Object)"user", (Object)pi.getName());
                        } else {
                            u.put((Object)"group", (Object)pi.getName());
                        }
                        if (p.hasPositivePermission(0x4000000000000000L)) {
                            u.put((Object)"all", (Object)true);
                        }
                        if (p.hasPositivePermission(16384L)) {
                            u.put((Object)"change_acl", (Object)true);
                        }
                        if (p.hasPositivePermission(0x8000000L)) {
                            u.put((Object)"change_admin_acl", (Object)true);
                        }
                        if (p.hasPositivePermission(0x20000000L)) {
                            u.put((Object)"change_bridge", (Object)true);
                        }
                        if (p.hasPositivePermission(0x80000000L)) {
                            u.put((Object)"change_channel", (Object)true);
                        }
                        if (p.hasPositivePermission(32L)) {
                            u.put((Object)"change_connection", (Object)true);
                        }
                        if (p.hasPositivePermission(128L)) {
                            u.put((Object)"change_durable", (Object)true);
                        }
                        if (p.hasPositivePermission(2L)) {
                            u.put((Object)"change_factory", (Object)true);
                        }
                        if (p.hasPositivePermission(4096L)) {
                            u.put((Object)"change_group", (Object)true);
                        }
                        if (p.hasPositivePermission(0x400000L)) {
                            u.put((Object)"change_message", (Object)true);
                        }
                        if (p.hasPositivePermission(8L)) {
                            u.put((Object)"change_route", (Object)true);
                        }
                        if (p.hasPositivePermission(0x1000000L)) {
                            u.put((Object)"change_server", (Object)true);
                        }
                        if (p.hasPositivePermission(1024L)) {
                            u.put((Object)"change_user", (Object)true);
                        }
                        if (p.hasPositivePermission(131072L)) {
                            u.put((Object)"create_destination", (Object)true);
                        }
                        if (p.hasPositivePermission(262144L)) {
                            u.put((Object)"delete_destination", (Object)true);
                        }
                        if (p.hasPositivePermission(524288L)) {
                            u.put((Object)"modify_destination", (Object)true);
                        }
                        if (p.hasPositivePermission(0x80000000000000L)) {
                            u.put((Object)"protect1", (Object)true);
                        }
                        if (p.hasPositivePermission(0x100000000000000L)) {
                            u.put((Object)"protect1", (Object)true);
                        }
                        if (p.hasPositivePermission(0x200000000000000L)) {
                            u.put((Object)"protect3", (Object)true);
                        }
                        if (p.hasPositivePermission(0x400000000000000L)) {
                            u.put((Object)"protect4", (Object)true);
                        }
                        if (p.hasPositivePermission(0x100000L)) {
                            u.put((Object)"purge_destination", (Object)true);
                        }
                        if (p.hasPositivePermission(256L)) {
                            u.put((Object)"purge_durable", (Object)true);
                        }
                        if (p.hasPositivePermission(0x2000000L)) {
                            u.put((Object)"shutdown_server", (Object)true);
                        }
                        if (p.hasPositivePermission(8192L)) {
                            u.put((Object)"view_acl", (Object)true);
                        }
                        if (p.hasPositivePermission(0x4000000L)) {
                            u.put((Object)"view_admin_acl", (Object)true);
                        }
                        if (p.hasPositivePermission(0x2000000000000000L)) {
                            u.put((Object)"view_all", (Object)true);
                        }
                        if (p.hasPositivePermission(0x10000000L)) {
                            u.put((Object)"view_bridge", (Object)true);
                        }
                        if (p.hasPositivePermission(0x40000000L)) {
                            u.put((Object)"view_channel", (Object)true);
                        }
                        if (p.hasPositivePermission(16L)) {
                            u.put((Object)"view_connection", (Object)true);
                        }
                        if (p.hasPositivePermission(65536L)) {
                            u.put((Object)"view_destination", (Object)true);
                        }
                        if (p.hasPositivePermission(64L)) {
                            u.put((Object)"view_durable", (Object)true);
                        }
                        if (p.hasPositivePermission(1L)) {
                            u.put((Object)"view_factory", (Object)true);
                        }
                        if (p.hasPositivePermission(2048L)) {
                            u.put((Object)"view_group", (Object)true);
                        }
                        if (p.hasPositivePermission(0x200000L)) {
                            u.put((Object)"view_message", (Object)true);
                        }
                        if (p.hasPositivePermission(4L)) {
                            u.put((Object)"view_route", (Object)true);
                        }
                        if (p.hasPositivePermission(0x800000L)) {
                            u.put((Object)"view_server", (Object)true);
                        }
                        if (p.hasPositivePermission(512L)) {
                            u.put((Object)"view_user", (Object)true);
                        }
                        ulist.add((Object)u);
                        ++c;
                    }
                    if (c == 0) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "0 ACLs were imported from server: " + cn.getName() + "\nCheck the server is active and has ACLs configured.", "Fail", 1);
                        return;
                    }
                    JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                    if (n == 0) {
                        jo.put((Object)"acls", (Object)ulist);
                    } else {
                        JSONArray ja = (JSONArray)jo.get((Object)"acls");
                        if (ja != null) {
                            ja.addAll((Collection)ulist);
                        } else {
                            jo.put((Object)"acls", (Object)ulist);
                        }
                    }
                    JSONWriter out = new JSONWriter();
                    jo.writeJSONString((Writer)out);
                    String newJson = out.toString();
                    newJson = newJson.replaceAll("\\\\/", "/");
                    GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, c + " ACLs were successfully imported from server: " + cn.getName() + "\nSelect \"Update Server...\" to apply", "Success", 1);
                    int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("acls");
                    if (i >= 0) {
                        GemsJSONConfigEditor.this.txtConfig.requestFocus();
                        GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                    }
                } else {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Not connected to Server", "Error", 1);
                }
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Parse error:" + (Object)((Object)pe), "Error", 1);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class ImportUsers
    implements ActionListener {
        ImportUsers() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsConnectionPicker cp = new GemsConnectionPicker(GemsJSONConfigEditor.this.m_this, null, "import users from");
                GemsConnectionNode cn = cp.getConnection();
                int c = 0;
                if (GemsJSONConfigEditor.this.m_cn != null && GemsJSONConfigEditor.this.m_cn == cn) {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Cannot import from the same Server!", "Error", 1);
                    return;
                }
                if (cn != null && cn.isConnected()) {
                    int n = JOptionPane.showOptionDialog(GemsJSONConfigEditor.this.m_this, "Are you sure you want to import all non-external users from server: " + cn.getName() + "?\nSelect \"Replace\" to replace all users, or \"Merge\" to keep existing users (Use validate after merging to check for duplicates)\nNote: passwords cannot be migrated, to import users with passwords convert .conf files to .json (using tibemsconf2json) then use \"Import from JSON File...\"", "Import Users", 1, 3, null, GemsJSONConfigEditor.this.options, GemsJSONConfigEditor.this.options[2]);
                    if (n != 0 && n != 1) {
                        return;
                    }
                    UserInfo[] ui = cn.getJmsAdmin().getUsers();
                    JSONArray ulist = new JSONArray();
                    for (int i = 0; ui != null && i < ui.length; ++i) {
                        if (ui[i].isExternal()) continue;
                        JSONObject u = new JSONObject();
                        u.put((Object)"name", (Object)ui[i].getName());
                        u.put((Object)"description", (Object)ui[i].getDescription());
                        ulist.add((Object)u);
                        ++c;
                    }
                    if (c == 0) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "0 users were imported from server: " + cn.getName() + "\nCheck the server is active and has users configured.", "Fail", 1);
                        return;
                    }
                    JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                    if (n == 0) {
                        jo.put((Object)"users", (Object)ulist);
                    } else {
                        JSONArray ja = (JSONArray)jo.get((Object)"users");
                        if (ja != null) {
                            ja.addAll((Collection)ulist);
                        } else {
                            jo.put((Object)"users", (Object)ulist);
                        }
                    }
                    JSONWriter out = new JSONWriter();
                    jo.writeJSONString((Writer)out);
                    String newJson = out.toString();
                    newJson = newJson.replaceAll("\\\\/", "/");
                    GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, c + " users were successfully imported from server: " + cn.getName() + "\nSelect \"Update Server...\" to apply", "Success", 1);
                    int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("users");
                    if (i >= 0) {
                        GemsJSONConfigEditor.this.txtConfig.requestFocus();
                        GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                    }
                } else {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Not connected to Server", "Error", 1);
                }
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Parse error:" + (Object)((Object)pe), "Error", 1);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class ImportGroups
    implements ActionListener {
        ImportGroups() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsConnectionPicker cp = new GemsConnectionPicker(GemsJSONConfigEditor.this.m_this, null, "import groups from");
                GemsConnectionNode cn = cp.getConnection();
                int c = 0;
                if (GemsJSONConfigEditor.this.m_cn != null && GemsJSONConfigEditor.this.m_cn == cn) {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Cannot import from the same Server!", "Error", 1);
                    return;
                }
                if (cn != null && cn.isConnected()) {
                    int n = JOptionPane.showOptionDialog(GemsJSONConfigEditor.this.m_this, "Are you sure you want to import all non-external groups from server: " + cn.getName() + "\nSelect \"Replace\" to replace all groups, or \"Merge\" to keep existing groups.\n(Use validate after merging to check for duplicates)", "Import Groups", 1, 3, null, GemsJSONConfigEditor.this.options, GemsJSONConfigEditor.this.options[2]);
                    if (n != 0 && n != 1) {
                        return;
                    }
                    GroupInfo[] gi = cn.getJmsAdmin().getGroups();
                    JSONArray glist = new JSONArray();
                    for (int i = 0; gi != null && i < gi.length; ++i) {
                        if (gi[i].isExternal() || gi[i].getName().equals("all")) continue;
                        JSONObject g = new JSONObject();
                        g.put((Object)"name", (Object)gi[i].getName());
                        g.put((Object)"description", (Object)gi[i].getDescription());
                        glist.add((Object)g);
                        ++c;
                        UserInfo[] ul = gi[i].getUsers();
                        JSONArray ulist = new JSONArray();
                        for (int j = 0; j < ul.length; ++j) {
                            JSONObject u = new JSONObject();
                            ulist.add((Object)u);
                            u.put((Object)"name", (Object)ul[j].getName());
                        }
                        g.put((Object)"members", (Object)ulist);
                    }
                    if (c == 0) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "0 groups were imported from server: " + cn.getName() + "\nCheck the server is active and has groups configured.", "Fail", 1);
                        return;
                    }
                    JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                    if (n == 0) {
                        jo.put((Object)"groups", (Object)glist);
                    } else {
                        JSONArray ja = (JSONArray)jo.get((Object)"groups");
                        if (ja != null) {
                            ja.addAll((Collection)glist);
                        } else {
                            jo.put((Object)"groups", (Object)glist);
                        }
                    }
                    JSONWriter out = new JSONWriter();
                    jo.writeJSONString((Writer)out);
                    String newJson = out.toString();
                    newJson = newJson.replaceAll("\\\\/", "/");
                    GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, c + " groups were successfully imported from server: " + cn.getName() + "\nSelect \"Update Server...\" to apply", "Success", 1);
                    int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("groups");
                    if (i >= 0) {
                        GemsJSONConfigEditor.this.txtConfig.requestFocus();
                        GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                    }
                } else {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Not connected to Server", "Error", 1);
                }
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Parse error:" + (Object)((Object)pe), "Error", 1);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class ImportDurables
    implements ActionListener {
        ImportDurables() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsConnectionPicker cp = new GemsConnectionPicker(GemsJSONConfigEditor.this.m_this, null, "import durables from");
                GemsConnectionNode cn = cp.getConnection();
                int c = 0;
                if (GemsJSONConfigEditor.this.m_cn != null && GemsJSONConfigEditor.this.m_cn == cn) {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Cannot import from the same Server!", "Error", 1);
                    return;
                }
                if (cn != null && cn.isConnected()) {
                    int n = JOptionPane.showOptionDialog(GemsJSONConfigEditor.this.m_this, "Are you sure you want to import all static durables from server: " + cn.getName() + "\nSelect \"Replace\" to replace all durables, or \"Merge\" to keep existing durables.\n(Use validate after merging to check for duplicates)", "Import Durables", 1, 3, null, GemsJSONConfigEditor.this.options, GemsJSONConfigEditor.this.options[2]);
                    if (n != 0 && n != 1) {
                        return;
                    }
                    DurableInfo[] di = cn.getJmsAdmin().getDurables();
                    JSONArray dlist = new JSONArray();
                    for (int i = 0; di != null && i < di.length; ++i) {
                        if (!di[i].isStatic()) continue;
                        JSONObject d = new JSONObject();
                        d.put((Object)"name", (Object)di[i].getDurableName());
                        d.put((Object)"topic", (Object)di[i].getTopicName());
                        if (di[i].getSelector() != null) {
                            d.put((Object)"selector", (Object)di[i].getSelector());
                        }
                        if (di[i].getClientID() != null) {
                            d.put((Object)"clientid", (Object)di[i].getClientID());
                        }
                        if (di[i].isNoLocalEnabled()) {
                            d.put((Object)"nolocal", (Object)"true");
                        }
                        dlist.add((Object)d);
                        ++c;
                    }
                    if (c == 0) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "0 durables were imported from server: " + cn.getName() + "\nCheck the server is active and has durables configured.", "Fail", 1);
                        return;
                    }
                    JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                    if (n == 0) {
                        jo.put((Object)"durables", (Object)dlist);
                    } else {
                        JSONArray ja = (JSONArray)jo.get((Object)"durables");
                        if (ja != null) {
                            ja.addAll((Collection)dlist);
                        } else {
                            jo.put((Object)"durables", (Object)dlist);
                        }
                    }
                    JSONWriter out = new JSONWriter();
                    jo.writeJSONString((Writer)out);
                    String newJson = out.toString();
                    newJson = newJson.replaceAll("\\\\/", "/");
                    GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, c + " durables were successfully imported from server: " + cn.getName() + "\nSelect \"Update Server...\" to apply", "Success", 1);
                    int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("durables");
                    if (i >= 0) {
                        GemsJSONConfigEditor.this.txtConfig.requestFocus();
                        GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                    }
                } else {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Not connected to Server", "Error", 1);
                }
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Parse error:" + (Object)((Object)pe), "Error", 1);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class ImportBridges
    implements ActionListener {
        ImportBridges() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsConnectionPicker cp = new GemsConnectionPicker(GemsJSONConfigEditor.this.m_this, null, "import bridges from");
                GemsConnectionNode cn = cp.getConnection();
                int c = 0;
                if (GemsJSONConfigEditor.this.m_cn != null && GemsJSONConfigEditor.this.m_cn == cn) {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Cannot import from the same Server!", "Error", 1);
                    return;
                }
                if (cn != null && cn.isConnected()) {
                    int n = JOptionPane.showOptionDialog(GemsJSONConfigEditor.this.m_this, "Are you sure you want to import all bridges from server: " + cn.getName() + "\nSelect \"Replace\" to replace all bridges, or \"Merge\" to keep existing bridges.\n(Use validate after merging to check for duplicates)", "Import Bridges", 1, 3, null, GemsJSONConfigEditor.this.options, GemsJSONConfigEditor.this.options[2]);
                    if (n != 0 && n != 1) {
                        return;
                    }
                    BridgeInfo[] bi = cn.getJmsAdmin().getBridges();
                    JSONArray blist = new JSONArray();
                    for (int i = 0; bi != null && i < bi.length; ++i) {
                        BridgeTarget[] tl = bi[i].getTargets();
                        for (int j = 0; j < tl.length; ++j) {
                            JSONObject b = new JSONObject();
                            JSONArray tlist = new JSONArray();
                            if (bi[i].getType() == 1) {
                                b.put((Object)"queue", (Object)bi[i].getName());
                            } else {
                                b.put((Object)"topic", (Object)bi[i].getName());
                            }
                            blist.add((Object)b);
                            ++c;
                            JSONObject t = new JSONObject();
                            tlist.add((Object)t);
                            if (tl[j].getType() == 1) {
                                t.put((Object)"queue", (Object)tl[j].getName());
                            } else {
                                t.put((Object)"topic", (Object)tl[j].getName());
                            }
                            if (tl[j].getSelector() != null) {
                                t.put((Object)"selector", (Object)tl[j].getSelector());
                            }
                            b.put((Object)"destinations", (Object)tlist);
                        }
                    }
                    if (c == 0) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "0 bridges were imported from server: " + cn.getName() + "\nCheck the server is active and has bridges configured.", "Fail", 1);
                        return;
                    }
                    JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                    if (n == 0) {
                        jo.put((Object)"bridges", (Object)blist);
                    } else {
                        JSONArray ja = (JSONArray)jo.get((Object)"bridges");
                        if (ja != null) {
                            ja.addAll((Collection)blist);
                        } else {
                            jo.put((Object)"bridges", (Object)blist);
                        }
                    }
                    JSONWriter out = new JSONWriter();
                    jo.writeJSONString((Writer)out);
                    String newJson = out.toString();
                    newJson = newJson.replaceAll("\\\\/", "/");
                    GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, c + " bridges were successfully imported from server: " + cn.getName() + "\nSelect \"Update Server...\" to apply", "Success", 1);
                    int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("bridges");
                    if (i >= 0) {
                        GemsJSONConfigEditor.this.txtConfig.requestFocus();
                        GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                    }
                } else {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Not connected to Server", "Error", 1);
                }
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Parse error:" + (Object)((Object)pe), "Error", 1);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class ImportTopics
    implements ActionListener {
        ImportTopics() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsConnectionPicker cp = new GemsConnectionPicker(GemsJSONConfigEditor.this.m_this, null, "import topics from");
                GemsConnectionNode cn = cp.getConnection();
                int c = 0;
                if (GemsJSONConfigEditor.this.m_cn != null && GemsJSONConfigEditor.this.m_cn == cn) {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Cannot import from the same Server!", "Error", 1);
                    return;
                }
                if (cn != null && cn.isConnected()) {
                    int n = JOptionPane.showOptionDialog(GemsJSONConfigEditor.this.m_this, "Are you sure you want to import all static topics from server: " + cn.getName() + "\nSelect \"Replace\" to replace all topics, or \"Merge\" to keep existing topics.\n(Use validate after merging to check for duplicates)", "Import Topics", 1, 3, null, GemsJSONConfigEditor.this.options, GemsJSONConfigEditor.this.options[2]);
                    if (n != 0 && n != 1) {
                        return;
                    }
                    HashMap storesToImport = new HashMap();
                    HashMap storesToIgnore = new HashMap();
                    TopicInfo[] qi = cn.getTopics(null, 1);
                    JSONArray qlist = new JSONArray();
                    for (int i = 0; qi != null && i < qi.length; ++i) {
                        JSONObject q = new JSONObject();
                        qlist.add((Object)q);
                        ++c;
                        GemsJSONConfigEditor.this.addDestProps(q, (DestinationInfo)qi[i], storesToImport, storesToIgnore);
                        try {
                            if (qi[i].isChannelInherited() || qi[i].getChannel() == null) continue;
                            q.put((Object)"channel", (Object)qi[i].getChannel());
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (c == 0) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "0 topics were imported from server: " + cn.getName() + "\nCheck the server is active and has static topics configured.", "Fail", 1);
                        return;
                    }
                    JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                    if (n == 0) {
                        jo.put((Object)"topics", (Object)qlist);
                    } else {
                        JSONArray ja = (JSONArray)jo.get((Object)"topics");
                        if (ja != null) {
                            ja.addAll((Collection)qlist);
                        } else {
                            jo.put((Object)"topics", (Object)qlist);
                        }
                    }
                    JSONWriter out = new JSONWriter();
                    jo.writeJSONString((Writer)out);
                    String newJson = out.toString();
                    newJson = newJson.replaceAll("\\\\/", "/");
                    GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, c + " topics were successfully imported from server: " + cn.getName() + "\nSelect \"Update Server...\" to apply", "Success", 1);
                    int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("topics");
                    if (i >= 0) {
                        GemsJSONConfigEditor.this.txtConfig.requestFocus();
                        GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                    }
                } else {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Not connected to Server", "Error", 1);
                }
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Parse error:" + (Object)((Object)pe), "Error", 1);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class ImportQueues
    implements ActionListener {
        ImportQueues() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GemsConnectionPicker cp = new GemsConnectionPicker(GemsJSONConfigEditor.this.m_this, null, "import queues from");
                GemsConnectionNode cn = cp.getConnection();
                int c = 0;
                if (GemsJSONConfigEditor.this.m_cn != null && GemsJSONConfigEditor.this.m_cn == cn) {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Cannot import from the same Server!", "Error", 1);
                    return;
                }
                if (cn != null && cn.isConnected()) {
                    int n = JOptionPane.showOptionDialog(GemsJSONConfigEditor.this.m_this, "Are you sure you want to import all queues from server: " + cn.getName() + "\nSelect \"Replace\" to replace all queues, or \"Merge\" to keep existing queues.\n(Use validate after merging to check for duplicates)", "Import Queues", 1, 3, null, GemsJSONConfigEditor.this.options, GemsJSONConfigEditor.this.options[2]);
                    if (n != 0 && n != 1) {
                        return;
                    }
                    HashMap storesToImport = new HashMap();
                    HashMap storesToIgnore = new HashMap();
                    QueueInfo[] qi = cn.getQueues(null, 1);
                    JSONArray qlist = new JSONArray();
                    for (int i = 0; qi != null && i < qi.length; ++i) {
                        if (qi[i].getName().startsWith("$sys.")) continue;
                        JSONObject q = new JSONObject();
                        qlist.add((Object)q);
                        ++c;
                        GemsJSONConfigEditor.this.addDestProps(q, (DestinationInfo)qi[i], storesToImport, storesToIgnore);
                        try {
                            if (!qi[i].isExclusiveInherited() && qi[i].isExclusive()) {
                                q.put((Object)"exclusive", (Object)"true");
                            }
                            if (qi[i].isMaxRedeliveryInherited() || qi[i].getMaxRedelivery() == 0) continue;
                            q.put((Object)"maxRedelivery", (Object)qi[i].getMaxRedelivery());
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (c == 0) {
                        JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "0 queues were imported from server: " + cn.getName() + "\nCheck the server is active and has static queues configured.", "Fail", 1);
                        return;
                    }
                    JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(GemsJSONConfigEditor.this.txtConfig.getText());
                    if (n == 0) {
                        jo.put((Object)"queues", (Object)qlist);
                    } else {
                        JSONArray ja = (JSONArray)jo.get((Object)"queues");
                        if (ja != null) {
                            ja.addAll((Collection)qlist);
                        } else {
                            jo.put((Object)"queues", (Object)qlist);
                        }
                    }
                    JSONWriter out = new JSONWriter();
                    jo.writeJSONString((Writer)out);
                    String newJson = out.toString();
                    newJson = newJson.replaceAll("\\\\/", "/");
                    GemsJSONConfigEditor.this.txtConfig.setText(newJson);
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, c + " queues were successfully imported from server: " + cn.getName() + "\nSelect \"Update Server...\" to apply", "Success", 1);
                    int i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf("queues");
                    if (i >= 0) {
                        GemsJSONConfigEditor.this.txtConfig.requestFocus();
                        GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                    }
                } else {
                    JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Error: Not connected to Server", "Error", 1);
                }
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Parse error:" + (Object)((Object)pe), "Error", 1);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, ex.toString(), "Error", 1);
                return;
            }
        }
    }

    class RefreshFromServer
    implements ActionListener {
        RefreshFromServer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsJSONConfigEditor.this.refreshServerConfig();
        }
    }

    class ForceUpdateServer
    implements ActionListener {
        ForceUpdateServer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsJSONConfigEditor.this.saveButtonActionPerformed(true);
        }
    }

    class UpdateServer
    implements ActionListener {
        UpdateServer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsJSONConfigEditor.this.saveButtonActionPerformed(false);
        }
    }

    class SaveFile
    implements ActionListener {
        SaveFile() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsJSONConfigEditor.this.saveAsButtonActionPerformed();
        }
    }

    class LoadFile
    implements ActionListener {
        LoadFile() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setDialogTitle("Load JSON Config From File");
                int returnVal = chooser.showOpenDialog(GemsJSONConfigEditor.this.m_this);
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    BufferedReader d = new BufferedReader(new FileReader(f));
                    String line = d.readLine();
                    StringBuilder sb = new StringBuilder();
                    while (line != null) {
                        sb.append(line);
                        sb.append('\n');
                        line = d.readLine();
                    }
                    d.close();
                    JSONObject jo = (JSONObject)GemsJSONConfigEditor.this.m_parser.parse(sb.toString());
                    GemsJSONConfigEditor.this.txtConfig.setText(sb.toString());
                }
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Parse error:" + (Object)((Object)pe), "Error", 1);
                return;
            }
            catch (IOException ie) {
                System.err.println("JavaIOException: " + ie.getMessage());
                return;
            }
        }
    }

    class Find
    implements ActionListener {
        Find() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            String s;
            String sel = null;
            if (GemsJSONConfigEditor.this.validFrame != null && GemsJSONConfigEditor.this.validFrame.isVisible()) {
                sel = GemsJSONConfigEditor.this.validFrame.getSelectedText();
            }
            if (sel == null || sel.length() == 0) {
                sel = GemsJSONConfigEditor.this.txtConfig.getSelectedText();
            }
            if ((s = (String)JOptionPane.showInputDialog(GemsJSONConfigEditor.this.m_this, "Enter the text to find.", "Find", -1, null, null, sel)) == null || s.length() == 0) {
                return;
            }
            int p = GemsJSONConfigEditor.this.txtConfig.getCaretPosition();
            if (p > 0) {
                ++p;
            }
            if ((i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf(s, p)) >= 0) {
                GemsJSONConfigEditor.this.txtConfig.requestFocus();
                GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                GemsJSONConfigEditor.this.txtConfig.moveCaretPosition(i + s.length());
            } else if (p > 0 && (i = GemsJSONConfigEditor.this.txtConfig.getText().indexOf(s)) >= 0) {
                GemsJSONConfigEditor.this.txtConfig.requestFocus();
                GemsJSONConfigEditor.this.txtConfig.setCaretPosition(i);
                GemsJSONConfigEditor.this.txtConfig.moveCaretPosition(i + s.length());
            } else {
                JOptionPane.showMessageDialog(GemsJSONConfigEditor.this.m_this, "Text not found:", "Error", 1);
            }
        }
    }
}

