/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsPropertyTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.admin.ServerInfo;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;

public class GemsLimitsDialog
extends JDialog {
    protected JComboBox m_server;
    protected boolean m_cancelled = false;
    protected String m_selected;
    protected GemsConnectionNode m_cn;
    protected GemsPropertyTableModel m_tableModel;
    protected JTable m_table;
    protected String m_type;
    protected Hashtable m_connTable;
    protected Frame m_frame;
    protected JLabel m_label;

    public GemsLimitsDialog(Frame frame, String type, GemsConnectionNode cn) {
        super(frame, "Edit Server Monitor Highlight " + type + " Limits", true);
        this.m_cn = cn;
        this.m_type = type;
        this.m_frame = frame;
        this.buildFrame(frame);
        if (this.m_server.getItemCount() == 0) {
            return;
        }
        this.updateLimits();
        this.pack();
        this.setVisible(true);
    }

    public void buildFrame(Frame frame) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel toppanel = new JPanel(new SpringLayout());
        mainPanel.add(toppanel);
        JLabel l2 = new JLabel("Server:", 11);
        this.m_server = new JComboBox();
        this.populateServers();
        this.m_server.addActionListener(new ServerSelected());
        toppanel.add(l2);
        toppanel.add(this.m_server);
        GemsUtilities.makeCompactGrid(toppanel, 1, 2, 5, 5, 5, 5);
        this.m_tableModel = new GemsPropertyTableModel(true, true);
        this.m_table = new JTable(this.m_tableModel);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_tableModel.m_table = this.m_table;
        JScrollPane sp = new JScrollPane(this.m_table);
        sp.setPreferredSize(new Dimension(375, 280));
        JPanel midPanel = new JPanel();
        midPanel.setBorder(new TitledBorder("Highlight as " + this.m_type + " when server values exceed these limits"));
        midPanel.setLayout(new BoxLayout(midPanel, 1));
        JPanel pbutpanel = new JPanel(new FlowLayout());
        JButton a3 = new JButton("Apply");
        a3.addActionListener(new ApplyPressed());
        pbutpanel.add(a3);
        JButton a4 = new JButton("ApplyToAll");
        a4.addActionListener(new ApplyToAllPressed());
        pbutpanel.add(a4);
        JButton p2 = new JButton("Reset");
        p2.addActionListener(new ResetPressed());
        pbutpanel.add(p2);
        midPanel.add(sp);
        this.m_label = new JLabel();
        this.m_label.setHorizontalAlignment(2);
        midPanel.add(this.m_label);
        midPanel.add(pbutpanel);
        mainPanel.add(midPanel);
        JPanel holdbut = new JPanel();
        holdbut.setLayout(new FlowLayout());
        JButton b3 = new JButton("OK");
        JButton c3 = new JButton("Close");
        holdbut.add(c3);
        b3.addActionListener(new OkPressed());
        c3.addActionListener(new CancelPressed());
        mainPanel.add(holdbut);
        this.setContentPane(mainPanel);
        this.setLocationRelativeTo(frame);
    }

    public String getSelectedProp() {
        return this.m_selected;
    }

    public void populateServers() {
        this.m_connTable = GemsConnectionNode.getConnections();
        Enumeration pe = this.m_connTable.keys();
        if (this.m_connTable.size() == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (pe.hasMoreElements()) {
            String i = (String)pe.nextElement();
            list.add(i);
            Collections.sort(list);
            this.m_server.insertItemAt(i, list.indexOf(i));
            if (this.m_cn == null || !i.startsWith(this.m_cn.getName())) continue;
            this.m_server.setSelectedItem(i);
        }
        if (this.m_server.getSelectedItem() == null) {
            this.m_server.setSelectedIndex(0);
        }
    }

    public void updateLimits() {
        this.resetLimits();
        GemsConnectionNode cn = (GemsConnectionNode)this.m_connTable.get(this.m_server.getSelectedItem());
        if (cn != null && cn.isConnected()) {
            Hashtable limits = this.m_type.equals("Warning") ? cn.getWarnLimits() : cn.getErrorLimits();
            Enumeration k = limits.keys();
            while (k.hasMoreElements()) {
                String l = (String)k.nextElement();
                Long v = (Long)limits.get(l);
                for (int i = 0; i < this.m_table.getRowCount(); ++i) {
                    if (!((String)this.m_table.getValueAt(i, 1)).equals(l)) continue;
                    this.m_table.setValueAt(new Boolean("true"), i, 0);
                    this.m_table.setValueAt(v, i, 2);
                }
            }
        }
    }

    public void setLimits(boolean all) {
        block6: {
            block5: {
                if (this.m_table.getCellEditor() != null) {
                    this.m_table.getCellEditor().stopCellEditing();
                }
                if (!all) break block5;
                int opt = JOptionPane.showConfirmDialog(this, "Are you sure you want to set " + this.m_type + " limits for ALL EMS servers?", this.m_type + " Limits", 0);
                if (opt != 0) break block6;
                for (int c = 0; c < this.m_server.getItemCount(); ++c) {
                    GemsConnectionNode cn = (GemsConnectionNode)this.m_connTable.get(this.m_server.getItemAt(c));
                    if (cn == null || !cn.isConnected()) continue;
                    Hashtable limits = this.m_type.equals("Warning") ? cn.getWarnLimits() : cn.getErrorLimits();
                    limits.clear();
                    for (int i = 0; i < this.m_table.getRowCount(); ++i) {
                        Boolean b = (Boolean)this.m_table.getValueAt(i, 0);
                        if (!b.booleanValue()) continue;
                        limits.put((String)this.m_table.getValueAt(i, 1), (Long)this.m_table.getValueAt(i, 2));
                    }
                }
                break block6;
            }
            GemsConnectionNode cn = (GemsConnectionNode)this.m_connTable.get(this.m_server.getSelectedItem());
            if (cn != null && cn.isConnected()) {
                Hashtable limits = this.m_type.equals("Warning") ? cn.getWarnLimits() : cn.getErrorLimits();
                limits.clear();
                for (int i = 0; i < this.m_table.getRowCount(); ++i) {
                    Boolean b = (Boolean)this.m_table.getValueAt(i, 0);
                    if (!b.booleanValue()) continue;
                    limits.put((String)this.m_table.getValueAt(i, 1), (Long)this.m_table.getValueAt(i, 2));
                }
            }
        }
    }

    public void resetLimits() {
        ServerInfo si;
        this.m_tableModel.emptyPropertyInfo("Enabled", "ServerStatistic", "LimitValue");
        long warnMsgMem = 500000000L;
        long errorMsgMem = 1000000000L;
        GemsConnectionNode cn = (GemsConnectionNode)this.m_connTable.get(this.m_server.getSelectedItem());
        if (cn != null && cn.isConnected() && (si = cn.getJmsServerInfo(false)) != null) {
            warnMsgMem = si.getMaxMsgMemory() / 2L;
            errorMsgMem = si.getMaxMsgMemory() * 3L / 4L;
        }
        if (this.m_type.equals("Warning")) {
            this.m_tableModel.addProperty(true, "Connections", new Long(2000L));
            this.m_tableModel.addProperty(true, "Sessions", new Long(20000L));
            this.m_tableModel.addProperty(true, "Queues", new Long(2000L));
            this.m_tableModel.addProperty(true, "Topics", new Long(2000L));
            this.m_tableModel.addProperty(true, "Durables", new Long(2000L));
            this.m_tableModel.addProperty(true, "PendingMsgs", new Long(1000000L));
            this.m_tableModel.addProperty(true, "PendingMsgSize", new Long(500000000L));
            this.m_tableModel.addProperty(true, "MsgMem", new Long(warnMsgMem));
            this.m_tableModel.addProperty(true, "InMsgRate", new Long(5000L));
            this.m_tableModel.addProperty(false, "OutMsgRate", new Long(5000L));
            this.m_tableModel.addProperty(true, "DiskReadRate", new Long(1000000L));
            this.m_tableModel.addProperty(false, "DiskWriteRate", new Long(5000000L));
            this.m_tableModel.addProperty(true, "AsyncDBSize", new Long(1000000000L));
            this.m_tableModel.addProperty(true, "SyncDBSize", new Long(1000000000L));
            this.m_tableModel.addProperty(true, "RespTime", new Long(500L));
            this.m_label.setText("MsgMem warning limit defaults to 50% of server MaxMsgMemory setting");
        } else {
            this.m_tableModel.addProperty(true, "Connections", new Long(5000L));
            this.m_tableModel.addProperty(true, "Sessions", new Long(50000L));
            this.m_tableModel.addProperty(true, "Queues", new Long(5000L));
            this.m_tableModel.addProperty(true, "Topics", new Long(5000L));
            this.m_tableModel.addProperty(true, "Durables", new Long(5000L));
            this.m_tableModel.addProperty(true, "PendingMsgs", new Long(5000000L));
            this.m_tableModel.addProperty(true, "PendingMsgSize", new Long(4000000000L));
            this.m_tableModel.addProperty(true, "MsgMem", new Long(errorMsgMem));
            this.m_tableModel.addProperty(true, "InMsgRate", new Long(10000L));
            this.m_tableModel.addProperty(false, "OutMsgRate", new Long(10000L));
            this.m_tableModel.addProperty(true, "DiskReadRate", new Long(10000000L));
            this.m_tableModel.addProperty(false, "DiskWriteRate", new Long(20000000L));
            this.m_tableModel.addProperty(true, "AsyncDBSize", new Long(4000000000L));
            this.m_tableModel.addProperty(true, "SyncDBSize", new Long(4000000000L));
            this.m_tableModel.addProperty(true, "RespTime", new Long(1000L));
            this.m_label.setText("MsgMem error limit defaults to 75% of server MaxMsgMemory setting");
        }
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsLimitsDialog.this.m_cancelled = true;
            GemsLimitsDialog.this.dispose();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsLimitsDialog.this.setLimits(false);
            GemsLimitsDialog.this.dispose();
        }
    }

    class ApplyToAllPressed
    implements ActionListener {
        ApplyToAllPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsLimitsDialog.this.setLimits(true);
        }
    }

    class ApplyPressed
    implements ActionListener {
        ApplyPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsLimitsDialog.this.setLimits(false);
        }
    }

    class ServerSelected
    implements ActionListener {
        ServerSelected() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsLimitsDialog.this.m_selected = (String)GemsLimitsDialog.this.m_server.getSelectedItem();
            GemsLimitsDialog.this.updateLimits();
        }
    }

    class ResetPressed
    implements ActionListener {
        ResetPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsLimitsDialog.this.resetLimits();
        }
    }
}

