/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsBridgeTableModel;
import com.tibco.gems.GemsBrowserFilterDialog;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsCreateBridgeDialog;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.admin.BridgeInfo;
import com.tibco.tibjms.admin.DestinationBridgeInfo;
import com.tibco.tibjms.admin.TibjmsAdminException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;

public class GemsManageBridgesDialog
extends JDialog {
    JFrame m_frame;
    JPanel m_panel;
    GemsConnectionNode m_cn;
    protected String m_destType;
    protected String m_bridgeType;
    protected JTextField m_conn;
    protected JTextField m_pattern;
    protected JTextField m_filter;
    Pattern m_filterPattern = null;
    protected JButton m_okButton;
    protected JButton m_cancelButton;
    protected JComboBox m_destTypeCombo;
    JTable m_table;
    protected GemsBridgeTableModel m_tableModel;
    TableSorter m_sorter;

    public GemsManageBridgesDialog(JFrame f, GemsConnectionNode cn, String destType, String dest, String bridgeType) {
        super(f, Gems.getGems().getTitlePrefix() + "Manage Bridges", true);
        this.setDefaultCloseOperation(2);
        this.m_frame = f;
        this.m_cn = cn;
        this.m_destType = destType;
        this.m_bridgeType = bridgeType;
        String prefix = "Target";
        if (bridgeType.equals("Target")) {
            prefix = "Source";
        }
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("EMS Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 20);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        panel.add(new JLabel(prefix + " Destination Type:"));
        this.m_destTypeCombo = new JComboBox();
        this.m_destTypeCombo.addItem("Queue");
        this.m_destTypeCombo.addItem("Topic");
        this.m_destTypeCombo.setSelectedItem(this.m_destType);
        panel.add(this.m_destTypeCombo);
        JPanel qpanel = new JPanel(true);
        qpanel.setLayout(new BoxLayout(qpanel, 0));
        JLabel l5 = new JLabel(prefix + " Destination Pattern:", 11);
        if (dest == null || dest.length() == 0) {
            dest = ">";
        }
        this.m_pattern = new JTextField(dest, 32);
        l5.setLabelFor(this.m_pattern);
        panel.add(l5);
        JButton m_destwiz = new JButton("  Lookup...");
        m_destwiz.addActionListener(new DestinationWizardAction());
        qpanel.add(this.m_pattern);
        qpanel.add(m_destwiz);
        panel.add(qpanel);
        JPanel fpanel = new JPanel(true);
        fpanel.setLayout(new BoxLayout(fpanel, 0));
        JLabel l6 = new JLabel("Target Destination Filter:", 11);
        this.m_filter = new JTextField("", 32);
        this.m_filter.setEnabled(false);
        l6.setLabelFor(this.m_filter);
        panel.add(l6);
        JButton m_filtwiz = new JButton("Set Filter...");
        m_filtwiz.addActionListener(new FilterWizardAction());
        fpanel.add(this.m_filter);
        fpanel.add(m_filtwiz);
        panel.add(fpanel);
        this.m_tableModel = new GemsBridgeTableModel(false, true, this);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.setRowSelectionAllowed(false);
        this.m_tableModel.m_table = this.m_table;
        this.addMouseListenerToTable(this.m_table);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(735, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(275, 10));
        bpanel.add(bx);
        this.m_okButton = new JButton("Find Bridges");
        this.m_okButton.addActionListener(new OkPressed());
        this.m_cancelButton = new JButton("Close");
        this.m_cancelButton.addActionListener(new CancelPressed());
        bpanel.add(this.m_okButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_cancelButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 4, 2, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.pack();
        this.setLocationRelativeTo(f);
        this.show();
    }

    public void start() {
        this.m_tableModel.buildColumnHeaders();
        this.m_sorter.setSortingStatus(1, 1);
        this.m_tableModel.populateBridgeInfo(this.getBridgeInfo(), this.m_filterPattern);
    }

    public void stop() {
        this.dispose();
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && GemsManageBridgesDialog.this.m_table.getSelectedColumn() > 0) {
                    GemsManageBridgesDialog.this.m_tableModel.toggleSelectedRow();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsManageBridgesDialog.this.dispose();
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuBar.add(menu);
        menuItem = new JMenuItem("Select All");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menuItem.addActionListener(new SelectAllAction());
        menu.add(menuItem);
        if (!Gems.getGems().getViewOnlyMode()) {
            menu.addSeparator();
            menuItem = new JMenuItem("Create New Target...");
            menuItem.addActionListener(new CreateBridgeAction());
            menu.add(menuItem);
            menuItem = new JMenuItem("Destroy Selected Bridges");
            menuItem.addActionListener(new DeleteBridgesAction());
            menu.add(menuItem);
        }
        return menuBar;
    }

    public BridgeInfo[] getBridgeInfo() {
        try {
            return this.m_cn.getJmsAdmin().getBridges(this.m_destTypeCombo.getSelectedItem().equals("Queue") ? 1 : 2, this.m_pattern.getText());
        }
        catch (TibjmsAdminException e) {
            JOptionPane.showMessageDialog(this.m_frame, e.getMessage(), "Error", 1);
            return null;
        }
    }

    public void createBridge(String dest) {
        if (!Gems.getGems().isStandbyOpsAllowed(this.m_cn)) {
            return;
        }
        GemsCreateBridgeDialog d = new GemsCreateBridgeDialog(null, this.m_cn, this.m_destTypeCombo.getSelectedItem().equals("Queue"), dest);
        if (d.createBridge()) {
            this.start();
        }
    }

    public void deleteSelectedBridges() {
        if (!Gems.getGems().isStandbyOpsAllowed(this.m_cn)) {
            return;
        }
        Vector b = this.m_tableModel.getSelectedBridges();
        if (b.size() <= 0) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog(null, "Destroy All Selected Bridges?", "Destroy Bridge", 0);
        if (opt == 0 && this.m_cn != null && this.m_cn.m_adminConn != null) {
            for (int i = 0; i < b.size(); ++i) {
                try {
                    DestinationBridgeInfo db = (DestinationBridgeInfo)b.get(i);
                    this.m_cn.m_adminConn.destroyDestinationBridge(db.getSourceType(), db.getSourceName(), db.getTargetType(), db.getTargetName());
                    continue;
                }
                catch (TibjmsAdminException ex) {
                    JOptionPane.showMessageDialog(this.m_frame, ex.getMessage(), "Error", 1);
                    return;
                }
            }
            this.start();
        }
    }

    public void deleteBridge(String dest, String dtyp, String targ, String ttyp) {
        if (!Gems.getGems().isStandbyOpsAllowed(this.m_cn)) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog(null, "<html>Destroy Bridge:<p>Source " + dtyp + ":" + dest + "<p>Target " + ttyp + ": " + targ + "</html>", "Destroy Bridge", 0);
        if (opt == 0 && this.m_cn != null && this.m_cn.m_adminConn != null) {
            try {
                this.m_cn.m_adminConn.destroyDestinationBridge(dtyp.equals("Queue") ? 1 : 2, dest, ttyp.equals("Queue") ? 1 : 2, targ);
            }
            catch (TibjmsAdminException ex) {
                JOptionPane.showMessageDialog(this.m_frame, ex.getMessage(), "Error", 1);
                return;
            }
            this.start();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    class FilterWizardAction
    implements ActionListener {
        FilterWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsBrowserFilterDialog dp = new GemsBrowserFilterDialog((Frame)GemsManageBridgesDialog.this.m_frame, "Target Filter Editor:");
            Pattern p = dp.getFilter(GemsManageBridgesDialog.this.m_filterPattern, "destinations");
            if (!dp.m_cancelled) {
                GemsManageBridgesDialog.this.m_filterPattern = p;
            }
            if (GemsManageBridgesDialog.this.m_filterPattern != null && GemsManageBridgesDialog.this.m_filterPattern.pattern().length() > 0) {
                GemsManageBridgesDialog.this.m_filter.setText(GemsManageBridgesDialog.this.m_filterPattern.pattern());
            } else {
                GemsManageBridgesDialog.this.m_filter.setText("");
                GemsManageBridgesDialog.this.m_filterPattern = null;
            }
        }
    }

    class DestinationWizardAction
    implements ActionListener {
        DestinationWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsManageBridgesDialog.this.m_frame, GemsManageBridgesDialog.this.m_cn, GemsManageBridgesDialog.this.m_destTypeCombo.getSelectedItem().equals("Queue") ? GemsDestination.DEST_TYPE.Queue : GemsDestination.DEST_TYPE.Topic);
            if (dp.m_retDest != null) {
                GemsManageBridgesDialog.this.m_pattern.setText(dp.m_retDest.m_destName);
            }
        }
    }

    class DeleteBridgesAction
    implements ActionListener {
        DeleteBridgesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsManageBridgesDialog.this.deleteSelectedBridges();
        }
    }

    class CreateBridgeAction
    implements ActionListener {
        CreateBridgeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsManageBridgesDialog.this.createBridge(GemsManageBridgesDialog.this.m_pattern.getText());
        }
    }

    class SelectAllAction
    implements ActionListener {
        SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsManageBridgesDialog.this.m_tableModel.selectAllRows();
        }
    }

    class LookupAction
    implements ActionListener {
        LookupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsManageBridgesDialog.this.start();
        }
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsManageBridgesDialog.this.dispose();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsManageBridgesDialog.this.start();
        }
    }
}

