/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.TibjmsConnectionFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.Timer;

public class GemsMessageCopier
extends JDialog {
    JFrame m_frame;
    JPanel m_panel;
    boolean m_running = false;
    GemsConnectionNode m_scn;
    Connection m_targetConnection = null;
    Session m_targetSession = null;
    Connection m_sourceConnection = null;
    Session m_sourceSession = null;
    QueueBrowser m_browser = null;
    Enumeration m_browserMmsgs = null;
    Timer m_timer = null;
    protected JComboBox m_sourceConn;
    protected JTextField m_sourceDest;
    protected JComboBox m_targetConn;
    protected JComboBox m_targetType;
    protected JTextField m_targetDest;
    protected JTextArea m_results;
    protected JButton m_startButton;
    protected JButton m_stopButton;
    protected JButton m_sourceLookup;
    protected JButton m_targetLookup;
    protected Hashtable m_connTable;
    protected Vector m_msgs;
    int m_msgsNum = 0;
    Destination m_jmsdest = null;
    MessageProducer m_msgProducer = null;

    public GemsMessageCopier(JFrame frame, GemsConnectionNode cn, String sourceDest, String sourceType, Vector msgs) {
        super(frame, "Copy " + (msgs == null ? "All Queue" : "Selected") + " Messages To:", true);
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
        this.m_frame = frame;
        this.m_scn = cn;
        this.m_msgs = msgs;
        this.m_timer = msgs != null ? new Timer(100, new CopySelectedMsgsTimerAction()) : new Timer(50, new CopyAllMsgsTimerAction());
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        this.m_connTable = GemsConnectionNode.getConnections();
        JLabel l1 = new JLabel("Source Server:", 11);
        this.m_sourceConn = new JComboBox();
        Enumeration pe = this.m_connTable.keys();
        ArrayList<String> list = new ArrayList<String>();
        while (pe.hasMoreElements()) {
            String i = (String)pe.nextElement();
            list.add(i);
            Collections.sort(list);
            this.m_sourceConn.insertItemAt(i, list.indexOf(i));
            if (cn == null || !i.startsWith(cn.getName())) continue;
            this.m_sourceConn.setSelectedItem(i);
        }
        if (this.m_sourceConn.getSelectedItem() == null) {
            this.m_sourceConn.setSelectedIndex(0);
        }
        this.m_sourceConn.setMaximumSize(new Dimension(0, 24));
        if (msgs != null) {
            this.m_sourceConn.setEnabled(false);
        }
        l1.setLabelFor(this.m_sourceConn);
        panel.add(l1);
        panel.add(this.m_sourceConn);
        JPanel spanel1 = new JPanel(true);
        spanel1.setLayout(new BoxLayout(spanel1, 0));
        spanel1.setMinimumSize(new Dimension(300, 24));
        JLabel l2 = new JLabel("Source " + sourceType + " Name:", 11);
        this.m_sourceDest = new JTextField(sourceDest != null ? sourceDest : "", 32);
        l2.setLabelFor(this.m_sourceDest);
        panel.add(l2);
        spanel1.add(this.m_sourceDest);
        if (msgs == null) {
            this.m_sourceLookup = new JButton("LookUp...");
            this.m_sourceLookup.addActionListener(new SourceLookupAction());
            spanel1.add(this.m_sourceLookup);
        } else {
            this.m_sourceDest.setEnabled(false);
        }
        panel.add(spanel1);
        JLabel l3 = new JLabel("Destination Server:", 11);
        this.m_targetConn = new JComboBox();
        pe = this.m_connTable.keys();
        list = new ArrayList();
        while (pe.hasMoreElements()) {
            String i = (String)pe.nextElement();
            list.add(i);
            Collections.sort(list);
            this.m_targetConn.insertItemAt(i, list.indexOf(i));
            if (cn == null || !i.startsWith(cn.getName())) continue;
            this.m_targetConn.setSelectedItem(i);
        }
        if (this.m_targetConn.getSelectedItem() == null) {
            this.m_targetConn.setSelectedIndex(0);
        }
        this.m_targetConn.setMaximumSize(new Dimension(0, 24));
        l3.setLabelFor(this.m_targetConn);
        panel.add(l3);
        panel.add(this.m_targetConn);
        JLabel l4 = new JLabel("Destination Type:", 11);
        this.m_targetType = new JComboBox();
        this.m_targetType.addItem("Queue");
        this.m_targetType.addItem("Topic");
        this.m_targetType.setMaximumSize(new Dimension(0, 24));
        l4.setLabelFor(this.m_targetType);
        panel.add(l4);
        panel.add(this.m_targetType);
        JPanel spanel2 = new JPanel(true);
        spanel2.setLayout(new BoxLayout(spanel2, 0));
        spanel2.setMinimumSize(new Dimension(300, 24));
        JLabel l5 = new JLabel("Destination Name:", 11);
        this.m_targetDest = new JTextField("", 32);
        l5.setLabelFor(this.m_targetDest);
        panel.add(l5);
        spanel2.add(this.m_targetDest);
        this.m_targetLookup = new JButton("LookUp...");
        this.m_targetLookup.addActionListener(new TargetLookupAction());
        spanel2.add(this.m_targetLookup);
        panel.add(spanel2);
        this.m_results = new JTextArea("");
        this.m_results.setEditable(false);
        JScrollPane spane = new JScrollPane(this.m_results);
        spane.setPreferredSize(new Dimension(430, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(200, 10));
        bpanel.add(bx);
        this.m_startButton = new JButton("Start");
        this.m_startButton.addActionListener(new StartPressed());
        this.m_stopButton = new JButton("Stop");
        this.m_stopButton.setEnabled(false);
        this.m_stopButton.addActionListener(new StopPressed());
        bpanel.add(this.m_startButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_stopButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 5, 2, 5, 5, 5, 5);
        this.pack();
        this.show();
    }

    public void start() {
        int opt;
        if (this.m_sourceDest.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a destination to copy from", "Error", 1);
            return;
        }
        if (this.m_targetDest.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a destination to copy to", "Error", 1);
            return;
        }
        if (this.m_targetConn.getSelectedItem().equals(this.m_sourceConn.getSelectedItem()) && this.m_targetDest.getText().equals(this.m_sourceDest.getText()) && (opt = JOptionPane.showConfirmDialog(this.m_frame, "Source and Target are the same, are you sure you want to copy messages?", "Copy Messages", 0)) != 0) {
            return;
        }
        this.m_running = true;
        this.m_sourceConn.setEnabled(false);
        this.m_targetConn.setEnabled(false);
        this.m_targetType.setEnabled(false);
        this.m_startButton.setEnabled(false);
        this.m_stopButton.setEnabled(true);
        this.m_sourceDest.setEnabled(false);
        this.m_targetDest.setEnabled(false);
        if (this.m_sourceLookup != null) {
            this.m_sourceLookup.setEnabled(false);
        }
        this.m_targetLookup.setEnabled(false);
        this.m_results.setText("");
        try {
            if (this.m_msgs != null) {
                GemsConnectionNode cn = (GemsConnectionNode)this.m_connTable.get(this.m_targetConn.getSelectedItem());
                this.m_results.append("Connecting to destination server: " + this.m_targetConn.getSelectedItem() + "\n");
                TibjmsConnectionFactory factory = new TibjmsConnectionFactory(cn.m_url, null, cn.m_sslParams);
                this.m_targetConnection = factory.createConnection(cn.m_user, cn.m_password);
                this.m_results.append("Creating transacted session\n");
                this.m_targetSession = this.m_targetConnection.createSession(true, 1);
                if (this.m_targetType.getSelectedItem().equals("Queue")) {
                    this.m_results.append("Creating producer to queue: " + this.m_targetDest.getText() + "\n");
                    this.m_jmsdest = this.m_targetSession.createQueue(this.m_targetDest.getText());
                } else {
                    this.m_results.append("Creating producer to topic: " + this.m_targetDest.getText() + "\n");
                    this.m_jmsdest = this.m_targetSession.createTopic(this.m_targetDest.getText());
                }
                this.m_msgProducer = this.m_targetSession.createProducer(null);
                this.m_targetConnection.start();
                this.m_msgsNum = this.m_msgs.size();
                this.m_timer.start();
            } else {
                GemsConnectionNode scn = (GemsConnectionNode)this.m_connTable.get(this.m_sourceConn.getSelectedItem());
                this.m_results.append("Connecting to source server: " + this.m_sourceConn.getSelectedItem() + "\n");
                TibjmsConnectionFactory factory = new TibjmsConnectionFactory(scn.m_url, null, scn.m_sslParams);
                this.m_sourceConnection = factory.createConnection(scn.m_user, scn.m_password);
                this.m_results.append("Creating session\n");
                this.m_sourceSession = this.m_sourceConnection.createSession(false, 1);
                this.m_results.append("Creating browser on queue: " + this.m_sourceDest.getText() + "\n");
                Queue fromQueue = this.m_sourceSession.createQueue(this.m_sourceDest.getText());
                this.m_browser = this.m_sourceSession.createBrowser(fromQueue, null);
                this.m_browserMmsgs = this.m_browser.getEnumeration();
                this.m_msgsNum = 0;
                GemsConnectionNode tcn = (GemsConnectionNode)this.m_connTable.get(this.m_targetConn.getSelectedItem());
                this.m_results.append("Connecting to destination server: " + this.m_targetConn.getSelectedItem() + "\n");
                factory = new TibjmsConnectionFactory(tcn.m_url, null, tcn.m_sslParams);
                this.m_targetConnection = factory.createConnection(tcn.m_user, tcn.m_password);
                this.m_results.append("Creating transacted session\n");
                this.m_targetSession = this.m_targetConnection.createSession(true, 1);
                if (this.m_targetType.getSelectedItem().equals("Queue")) {
                    this.m_results.append("Creating producer to queue: " + this.m_targetDest.getText() + "\n");
                    this.m_jmsdest = this.m_targetSession.createQueue(this.m_targetDest.getText());
                } else {
                    this.m_results.append("Creating producer to topic: " + this.m_targetDest.getText() + "\n");
                    this.m_jmsdest = this.m_targetSession.createTopic(this.m_targetDest.getText());
                }
                this.m_msgProducer = this.m_targetSession.createProducer(null);
                this.m_sourceConnection.start();
                this.m_targetConnection.start();
                this.m_timer.start();
            }
        }
        catch (Exception e) {
            this.m_results.append("Exception: " + e.getMessage() + "\n");
            this.stop();
        }
    }

    public void stop() {
        this.m_timer.stop();
        this.m_running = false;
        try {
            if (this.m_sourceSession != null) {
                this.m_sourceSession.close();
                this.m_sourceSession = null;
            }
            if (this.m_sourceConnection != null) {
                this.m_sourceConnection.close();
                this.m_sourceConnection = null;
            }
            if (this.m_targetSession != null) {
                this.m_targetSession.close();
                this.m_targetSession = null;
            }
            if (this.m_targetConnection != null) {
                this.m_targetConnection.close();
                this.m_targetConnection = null;
            }
        }
        catch (JMSException e) {
            System.err.println("Exception: " + e.getMessage());
        }
        if (this.m_msgs == null) {
            this.m_sourceDest.setEnabled(true);
            this.m_sourceConn.setEnabled(true);
        }
        this.m_targetDest.setEnabled(true);
        this.m_startButton.setEnabled(true);
        this.m_stopButton.setEnabled(false);
        this.m_targetConn.setEnabled(true);
        this.m_targetType.setEnabled(true);
        if (this.m_sourceLookup != null) {
            this.m_sourceLookup.setEnabled(true);
        }
        this.m_targetLookup.setEnabled(true);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsMessageCopier.this.dispose();
            }
        });
        return menuBar;
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    class TargetLookupAction
    implements ActionListener {
        TargetLookupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = (GemsConnectionNode)GemsMessageCopier.this.m_connTable.get(GemsMessageCopier.this.m_targetConn.getSelectedItem());
            if (cn == null) {
                return;
            }
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsMessageCopier.this.m_frame, cn, GemsMessageCopier.this.m_targetType.getSelectedItem().equals("Queue") ? GemsDestination.DEST_TYPE.Queue : GemsDestination.DEST_TYPE.Topic);
            if (dp.m_retDest != null) {
                GemsMessageCopier.this.m_targetDest.setText(dp.m_retDest.m_destName);
            }
        }
    }

    class SourceLookupAction
    implements ActionListener {
        SourceLookupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = (GemsConnectionNode)GemsMessageCopier.this.m_connTable.get(GemsMessageCopier.this.m_sourceConn.getSelectedItem());
            if (cn == null) {
                return;
            }
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsMessageCopier.this.m_frame, cn, GemsDestination.DEST_TYPE.Queue);
            if (dp.m_retDest != null) {
                GemsMessageCopier.this.m_sourceDest.setText(dp.m_retDest.m_destName);
            }
        }
    }

    class StopPressed
    implements ActionListener {
        StopPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsMessageCopier.this.m_running) {
                GemsMessageCopier.this.m_results.append("Aborting copy, Rolling back");
            }
            GemsMessageCopier.this.stop();
        }
    }

    class StartPressed
    implements ActionListener {
        StartPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageCopier.this.start();
        }
    }

    class CopySelectedMsgsTimerAction
    implements ActionListener {
        CopySelectedMsgsTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsMessageCopier.this.m_running) {
                try {
                    Message msg;
                    if (GemsMessageCopier.this.m_msgsNum <= 0) {
                        GemsMessageCopier.this.m_results.append("Commiting messages \n");
                        GemsMessageCopier.this.m_targetSession.commit();
                        GemsMessageCopier.this.m_results.append("Done\n");
                        GemsMessageCopier.this.stop();
                    } else if ((msg = (Message)GemsMessageCopier.this.m_msgs.elementAt(--GemsMessageCopier.this.m_msgsNum)) != null) {
                        GemsMessageCopier.this.m_results.append("Copying message: " + msg.getJMSMessageID() + "\n");
                        long exp = msg.getJMSExpiration();
                        if (exp > 0L) {
                            long now = System.currentTimeMillis();
                            if (exp > now) {
                                GemsMessageCopier.this.m_results.append("Migrating expiration of " + (exp -= now) + "(millis from now) for message " + msg.getJMSMessageID() + "\n");
                            } else {
                                GemsMessageCopier.this.m_results.append("Bad expiration " + exp + " for message " + msg.getJMSMessageID() + " cannot migrate expiration\n");
                                exp = 0L;
                            }
                        }
                        GemsMessageCopier.this.m_msgProducer.send(GemsMessageCopier.this.m_jmsdest, msg, msg.getJMSDeliveryMode(), msg.getJMSPriority(), exp);
                        GemsMessageCopier.this.m_results.append("Message sent as: " + msg.getJMSMessageID() + "\n");
                    } else {
                        GemsMessageCopier.this.m_results.append("Error failed to copy message\n");
                        GemsMessageCopier.this.stop();
                    }
                }
                catch (JMSException ex) {
                    GemsMessageCopier.this.m_results.append("Exception: " + ex.getMessage() + "\n");
                    GemsMessageCopier.this.m_results.append("Rolling back");
                    try {
                        GemsMessageCopier.this.m_targetSession.rollback();
                    }
                    catch (JMSException x) {
                        GemsMessageCopier.this.m_results.append("Exception: " + x.getMessage() + "\n");
                    }
                    GemsMessageCopier.this.stop();
                }
                catch (Exception ex1) {
                    if (Gems.getGems().getDebug()) {
                        ex1.printStackTrace();
                    }
                    GemsMessageCopier.this.m_results.append("Exception: " + ex1.getMessage() + "\n");
                    GemsMessageCopier.this.m_results.append("Rolling back");
                    try {
                        GemsMessageCopier.this.m_targetSession.rollback();
                    }
                    catch (JMSException x) {
                        GemsMessageCopier.this.m_results.append("Exception: " + x.getMessage() + "\n");
                    }
                    GemsMessageCopier.this.stop();
                }
            }
        }
    }

    class CopyAllMsgsTimerAction
    implements ActionListener {
        CopyAllMsgsTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsMessageCopier.this.m_running) {
                try {
                    if (GemsMessageCopier.this.m_browserMmsgs.hasMoreElements()) {
                        Message message = (Message)GemsMessageCopier.this.m_browserMmsgs.nextElement();
                        if (message != null) {
                            GemsMessageCopier.this.m_results.append("Copying message: " + message.getJMSMessageID() + "\n");
                            long exp = message.getJMSExpiration();
                            if (exp > 0L) {
                                long now = System.currentTimeMillis();
                                if (exp > now) {
                                    GemsMessageCopier.this.m_results.append("Migrating expiration of " + (exp -= now) + "(millis from now) for message " + message.getJMSMessageID() + "\n");
                                } else {
                                    GemsMessageCopier.this.m_results.append("Bad expiration " + exp + " for message " + message.getJMSMessageID() + " cannot migrate expiration\n");
                                    exp = 0L;
                                }
                            }
                            GemsMessageCopier.this.m_msgProducer.send(GemsMessageCopier.this.m_jmsdest, message, message.getJMSDeliveryMode(), message.getJMSPriority(), exp);
                            GemsMessageCopier.this.m_results.append("Message sent as: " + message.getJMSMessageID() + "\n");
                            ++GemsMessageCopier.this.m_msgsNum;
                        } else {
                            GemsMessageCopier.this.m_results.append("Error failed to copy message\n");
                            GemsMessageCopier.this.stop();
                        }
                    } else {
                        GemsMessageCopier.this.m_results.append("Commiting " + GemsMessageCopier.this.m_msgsNum + " messages \n");
                        GemsMessageCopier.this.m_targetSession.commit();
                        GemsMessageCopier.this.m_results.append("Done\n");
                        GemsMessageCopier.this.stop();
                    }
                }
                catch (JMSException ex) {
                    GemsMessageCopier.this.m_results.append("Exception: " + ex.getMessage() + "\n");
                    GemsMessageCopier.this.m_results.append("Rolling back");
                    try {
                        GemsMessageCopier.this.m_targetSession.rollback();
                    }
                    catch (JMSException x) {
                        GemsMessageCopier.this.m_results.append("Exception: " + x.getMessage() + "\n");
                    }
                    GemsMessageCopier.this.stop();
                }
                catch (Exception ex1) {
                    if (Gems.getGems().getDebug()) {
                        ex1.printStackTrace();
                    }
                    GemsMessageCopier.this.m_results.append("Exception: " + ex1.getMessage() + "\n");
                    GemsMessageCopier.this.m_results.append("Rolling back");
                    try {
                        GemsMessageCopier.this.m_targetSession.rollback();
                    }
                    catch (JMSException x) {
                        GemsMessageCopier.this.m_results.append("Exception: " + x.getMessage() + "\n");
                    }
                    GemsMessageCopier.this.stop();
                }
            }
        }
    }
}

