/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.TibjmsQueueConnectionFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.Timer;

public class GemsMessageDestroyer
extends JDialog {
    Frame m_frame;
    JPanel m_panel;
    boolean m_running = false;
    boolean m_started = false;
    GemsConnectionNode m_cn;
    Timer m_timer = new Timer(100, new RefreshTimerAction());
    protected JTextField m_conn;
    protected JTextArea m_results;
    protected JButton m_startButton;
    protected JButton m_stopButton;
    protected JRadioButton m_adminAPIButton;
    protected JRadioButton m_JMSReadButton;
    protected Vector m_msgs;
    protected String m_queue;
    protected boolean m_adminAPI = true;
    int m_msgsNum = 0;
    QueueSession m_session = null;
    QueueConnection m_connection = null;

    public GemsMessageDestroyer(Frame frame, GemsConnectionNode cn, Vector msgs, String queue) {
        super(frame, "Destroy Selected Messages:", true);
        this.m_queue = queue;
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
        this.m_frame = frame;
        this.m_cn = cn;
        this.m_msgs = msgs;
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("EMS Server:", 11);
        this.m_conn = new JTextField(this.m_cn.getName(), 32);
        this.m_conn.setEditable(false);
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        this.m_adminAPIButton = new JRadioButton("Use Admin API (requires track msg ids)");
        this.m_adminAPIButton.addActionListener(new adminAPIPressed());
        this.m_adminAPIButton.setSelected(true);
        this.m_JMSReadButton = new JRadioButton("Use JMS Read");
        this.m_JMSReadButton.addActionListener(new JMSReadPressed());
        if (this.m_queue == null) {
            this.m_JMSReadButton.setEnabled(false);
        }
        panel.add(this.m_JMSReadButton);
        panel.add(this.m_adminAPIButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_JMSReadButton);
        group.add(this.m_adminAPIButton);
        this.m_results = new JTextArea("");
        this.m_results.append("Press Start to destroy " + this.m_msgs.size() + " message(s) on EMS: " + this.m_cn.getName() + "\n");
        if (this.m_queue == null) {
            this.m_results.append("Note messages will be destroyed for ALL durable subscribers!\n");
        }
        this.m_results.setEditable(false);
        JScrollPane spane = new JScrollPane(this.m_results);
        spane.setPreferredSize(new Dimension(430, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(175, 10));
        bpanel.add(bx);
        this.m_startButton = new JButton("Start");
        this.m_startButton.addActionListener(new StartPressed());
        this.m_stopButton = new JButton("Close");
        this.m_stopButton.addActionListener(new StopPressed());
        bpanel.add(this.m_startButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_stopButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 2, 2, 5, 5, 5, 5);
        this.pack();
        this.show();
    }

    public void start() {
        this.m_running = true;
        this.m_startButton.setEnabled(false);
        this.m_adminAPIButton.setEnabled(false);
        this.m_JMSReadButton.setEnabled(false);
        this.m_stopButton.setText("Stop");
        if (!this.m_started) {
            this.m_msgsNum = this.m_msgs.size();
            this.m_started = true;
        }
        if (this.m_adminAPI) {
            this.m_timer.start();
        } else {
            try {
                TibjmsQueueConnectionFactory factory = new TibjmsQueueConnectionFactory(this.m_cn.m_url, null, this.m_cn.m_sslParams);
                this.m_connection = factory.createQueueConnection(this.m_cn.m_user, this.m_cn.m_password);
                this.m_session = this.m_connection.createQueueSession(false, 1);
                this.m_connection.start();
                this.m_timer.start();
            }
            catch (JMSException e) {
                JOptionPane.showMessageDialog(this.m_frame, e.getMessage(), "Error", 1);
                this.stop(false);
            }
        }
    }

    public void stop(boolean allowContinue) {
        this.m_timer.stop();
        this.m_running = false;
        try {
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (JMSException e) {
            System.err.println("Exception: " + e.getMessage());
        }
        if (allowContinue) {
            this.m_startButton.setEnabled(true);
            this.m_startButton.setText("Continue");
        }
        this.m_stopButton.setText("Close");
    }

    public void reset() {
        this.m_started = false;
        this.m_startButton.setText("Start");
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsMessageDestroyer.this.dispose();
            }
        });
        return menuBar;
    }

    @Override
    public void dispose() {
        this.stop(false);
        super.dispose();
    }

    class adminAPIPressed
    implements ActionListener {
        adminAPIPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageDestroyer.this.m_adminAPI = true;
        }
    }

    class JMSReadPressed
    implements ActionListener {
        JMSReadPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageDestroyer.this.m_adminAPI = false;
        }
    }

    class StopPressed
    implements ActionListener {
        StopPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsMessageDestroyer.this.m_stopButton.getText().equals("Close")) {
                GemsMessageDestroyer.this.dispose();
            } else {
                GemsMessageDestroyer.this.stop(true);
            }
        }
    }

    class StartPressed
    implements ActionListener {
        StartPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageDestroyer.this.start();
        }
    }

    class RefreshTimerAction
    implements ActionListener {
        RefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsMessageDestroyer.this.m_running) {
                try {
                    Message msg;
                    if (GemsMessageDestroyer.this.m_msgsNum <= 0) {
                        GemsMessageDestroyer.this.m_results.append("Done\n");
                        GemsMessageDestroyer.this.stop(false);
                    } else if ((msg = (Message)GemsMessageDestroyer.this.m_msgs.elementAt(--GemsMessageDestroyer.this.m_msgsNum)) != null) {
                        GemsMessageDestroyer.this.m_results.append("Destroying message: " + msg.getJMSMessageID() + "\n");
                        String mid = msg.getJMSMessageID();
                        if (mid == null || mid.length() == 0 || mid.startsWith("tmpId")) {
                            GemsMessageDestroyer.this.m_results.append("Error: Cannot destroy message. Message has no JMSMessageID\n");
                            GemsMessageDestroyer.this.stop(true);
                        } else if (GemsMessageDestroyer.this.m_adminAPI) {
                            GemsMessageDestroyer.this.m_cn.removeMessage(msg);
                        } else {
                            Queue queue = GemsMessageDestroyer.this.m_session.createQueue(GemsMessageDestroyer.this.m_queue);
                            QueueReceiver qr = GemsMessageDestroyer.this.m_session.createReceiver(queue, "JMSMessageID='" + mid + "'");
                            Message m = qr.receive(Gems.getGems().getAdminTimeout());
                            if (m != null) {
                                GemsMessageDestroyer.this.m_results.append(mid + " successfully read from queue " + GemsMessageDestroyer.this.m_queue + "\n");
                            } else {
                                GemsMessageDestroyer.this.m_results.append(mid + " time out from read after " + Gems.getGems().getAdminTimeout() + " milliseconds\n");
                            }
                            qr.close();
                        }
                    } else {
                        GemsMessageDestroyer.this.m_results.append("Error: null message\n");
                        GemsMessageDestroyer.this.stop(true);
                    }
                }
                catch (Exception ex) {
                    GemsMessageDestroyer.this.m_results.append("Exception: " + ex.getMessage() + "\n");
                    GemsMessageDestroyer.this.stop(true);
                }
            }
        }
    }
}

