/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsMessageText;
import com.tibco.gems.GemsMsgPropTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.Tibjms;
import com.tibco.tibjms.TibjmsConnectionFactory;
import com.tibco.tibjms.admin.TibjmsAdmin;
import com.tibco.tibjms.admin.TibjmsAdminException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class GemsMessageFrame
extends JDialog {
    GemsMsgPropTableModel m_tableModel = null;
    GemsMsgPropTableModel m_mapTableModel = null;
    JMenuBar m_menuBar = new JMenuBar();
    JMenu m_mapmenu = null;
    JFrame m_frame;
    JTable m_table;
    JPanel m_panel;
    JPanel m_headPanel;
    JPanel m_textPanel;
    JPanel m_mapPanel = null;
    JPanel m_bytesPanel = null;
    JTextArea m_bytesTextArea;
    GemsMessageText m_text;
    JButton m_sendButt;
    JMenuItem m_saveMenuItem;
    boolean m_send;
    JTabbedPane m_tabPane;
    String m_destination;
    String m_destprop;
    boolean m_isQueue;
    Message m_msg = null;
    TibjmsAdmin m_admin = null;
    Connection m_connection = null;
    Session m_session = null;
    GemsConnectionNode m_cn = null;
    SimpleDateFormat dateFormatMillis = new SimpleDateFormat("EEE MMM dd HH:mm:ss SSS zzz yyyy");
    boolean m_isMonitorMsg;
    boolean m_isEditor = false;
    JDialog m_this;

    public GemsMessageFrame(GemsConnectionNode cn, boolean send, String dest, boolean isQueue, JFrame parent, boolean isMonitorMsg) {
        super(parent, Gems.getGems().getTitlePrefix() + (isMonitorMsg ? "Monitor Event" : "Message: "), false);
        this.m_isMonitorMsg = isMonitorMsg;
        this.m_frame = parent;
        this.m_cn = cn;
        this.m_send = send;
        this.m_isQueue = isQueue;
        this.m_destination = dest;
        this.m_this = this;
        this.init();
        this.setLocationRelativeTo(parent);
        this.setLocation(this.getX(), this.getY() - 175);
        this.pack();
        this.show();
    }

    public GemsMessageFrame(GemsConnectionNode cn, boolean send, String dest, boolean isQueue, JFrame parent, boolean isMonitorMsg, boolean isMap) {
        super(parent, Gems.getGems().getTitlePrefix() + (isMonitorMsg ? "Monitor Event" : "Message: "), false);
        this.m_isMonitorMsg = isMonitorMsg;
        this.m_frame = parent;
        this.m_cn = cn;
        this.m_send = send;
        this.m_isQueue = isQueue;
        this.m_destination = dest;
        this.m_this = this;
        this.init();
        if (isMap) {
            this.createMapUI();
            this.m_mapTableModel.populateEmptyPropertyInfo(0);
        }
        this.setLocationRelativeTo(parent);
        this.setLocation(this.getX(), this.getY() - 165);
        this.pack();
        this.show();
    }

    public GemsMessageFrame(GemsConnectionNode cn, boolean send, String dest, boolean isQueue, JFrame parent, boolean isMonitorMsg, boolean isMap, boolean isEditor) {
        super(parent, Gems.getGems().getTitlePrefix() + (isMonitorMsg ? "Monitor Event" : "Message: "), false);
        this.m_isMonitorMsg = isMonitorMsg;
        this.m_frame = parent;
        this.m_cn = cn;
        this.m_send = send;
        this.m_isQueue = isQueue;
        this.m_destination = dest;
        this.m_isEditor = isEditor;
        this.m_this = this;
        this.init();
        if (isMap) {
            this.createMapUI();
            this.m_mapTableModel.populateEmptyPropertyInfo(0);
        }
        this.setLocationRelativeTo(parent);
        this.setLocation(this.getX(), this.getY() - 165);
        this.pack();
    }

    public GemsMessageFrame(GemsConnectionNode cn, boolean send, String dest, boolean isQueue, JFrame parent, boolean isMonitorMsg, boolean isMap, boolean isEditor, boolean modal) {
        super(parent, Gems.getGems().getTitlePrefix() + (isMonitorMsg ? "Monitor Event" : "Message: "), modal);
        this.m_isMonitorMsg = isMonitorMsg;
        this.m_frame = parent;
        this.m_cn = cn;
        this.m_send = send;
        this.m_isQueue = isQueue;
        this.m_destination = dest;
        this.m_isEditor = isEditor;
        this.m_this = this;
        this.init();
        if (isMap) {
            this.createMapUI();
            this.m_mapTableModel.populateEmptyPropertyInfo(0);
        }
        this.setLocationRelativeTo(parent);
        this.setLocation(this.getX(), this.getY() - 165);
        this.pack();
        if (!isEditor) {
            this.show();
        }
    }

    public void init() {
        this.setDefaultCloseOperation(2);
        if (this.m_cn != null) {
            this.m_admin = this.m_cn.m_adminConn;
        }
        if (this.m_send) {
            if (this.m_isQueue) {
                this.setTitle(Gems.getGems().getTitlePrefix() + "Send TextMessage To Queue");
            } else {
                this.setTitle(Gems.getGems().getTitlePrefix() + "Publish TextMessage To Topic");
            }
            this.m_destprop = this.m_destination;
        } else {
            this.m_destprop = this.m_isQueue ? new String("Queue[") : new String("Topic[");
            this.m_destprop = this.m_destprop + this.m_destination + ']';
        }
        JMenuBar menuBar = this.constructMenuBar(this.m_send);
        this.setJMenuBar(menuBar);
        this.m_panel = new JPanel(true);
        this.m_panel.setLayout(new BorderLayout());
        this.m_tabPane = new JTabbedPane();
        this.m_panel.add((Component)this.m_tabPane, "Center");
        this.getContentPane().add("Center", this.m_panel);
        this.m_headPanel = new JPanel(new BorderLayout());
        this.m_tableModel = new GemsMsgPropTableModel(this.m_send);
        this.m_table = new JTable(this.m_tableModel);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_tableModel.m_table = this.m_table;
        JScrollPane spane = new JScrollPane(this.m_table);
        this.m_headPanel.add((Component)spane, "Center");
        this.m_tabPane.addTab("Header", this.m_headPanel);
        this.m_textPanel = new JPanel(new BorderLayout());
        this.m_text = new GemsMessageText();
        this.m_text.setLineWrap(true);
        if (!this.m_send) {
            this.m_text.setEditable(false);
        }
        JScrollPane spane1 = new JScrollPane(this.m_text);
        this.m_textPanel.add((Component)spane1, "Center");
        this.m_tabPane.addTab("Text Body", this.m_textPanel);
        if (this.m_send) {
            this.m_sendButt = this.m_isEditor ? new JButton("OK") : (this.m_isQueue ? new JButton("Send Message") : new JButton("Publish Message"));
            this.m_sendButt.addActionListener(new SendPressed());
            this.m_panel.add((Component)this.m_sendButt, "South");
            if (this.m_isEditor) {
                this.m_tableModel.emptyEditorPropertyInfo(this.m_destprop);
            } else {
                this.m_tableModel.emptyPropertyInfo(this.m_destprop);
            }
            this.m_text.setText("<Message text>");
        }
    }

    public void createMapUI() {
        if (this.m_mapPanel == null) {
            this.m_mapPanel = new JPanel(new BorderLayout());
            this.m_mapTableModel = new GemsMsgPropTableModel(this.m_send, true);
            JTable table = new JTable(this.m_mapTableModel);
            table.getTableHeader().setReorderingAllowed(false);
            this.m_mapTableModel.m_table = table;
            JScrollPane spane = new JScrollPane(table);
            this.m_mapPanel.add((Component)spane, "Center");
            this.m_tabPane.addTab("Map Body", this.m_mapPanel);
            this.m_tabPane.remove(this.m_textPanel);
        }
        this.m_mapTableModel.setRowCount(0);
        if (this.m_send) {
            if (this.m_isQueue) {
                this.setTitle(Gems.getGems().getTitlePrefix() + "Send MapMessage To Queue");
            } else {
                this.setTitle(Gems.getGems().getTitlePrefix() + "Publish MapMessage To Topic");
            }
            if (this.m_mapmenu == null) {
                this.m_mapmenu = new JMenu("Map");
                this.m_mapmenu.setMnemonic(77);
                this.m_menuBar.add(this.m_mapmenu);
                JMenu sm = new JMenu("Add Field");
                this.m_mapmenu.add(sm);
                JMenuItem menuItem = sm.add(new JMenuItem("String"));
                menuItem.addActionListener(new AddStringField());
                menuItem = sm.add(new JMenuItem("Boolean"));
                menuItem.addActionListener(new AddBooleanField());
                menuItem = sm.add(new JMenuItem("Integer"));
                menuItem.addActionListener(new AddIntegerField());
                menuItem = sm.add(new JMenuItem("Byte"));
                menuItem.addActionListener(new AddByteField());
                menuItem = sm.add(new JMenuItem("Short"));
                menuItem.addActionListener(new AddShortField());
                menuItem = sm.add(new JMenuItem("Long"));
                menuItem.addActionListener(new AddLongField());
                menuItem = sm.add(new JMenuItem("Float"));
                menuItem.addActionListener(new AddFloatField());
                menuItem = sm.add(new JMenuItem("Double"));
                menuItem.addActionListener(new AddDoubleField());
            }
        }
    }

    public void createBytesFieldUI(String fname, boolean asText) {
        if (this.m_bytesPanel == null) {
            this.m_bytesPanel = new JPanel(new BorderLayout());
            this.m_bytesTextArea = new JTextArea();
            this.m_bytesTextArea.setLineWrap(true);
            this.m_bytesTextArea.setEditable(false);
            JScrollPane spane = new JScrollPane(this.m_bytesTextArea);
            this.m_bytesPanel.add((Component)spane, "Center");
            this.m_tabPane.addTab(fname + " Field", this.m_bytesPanel);
        } else {
            this.m_tabPane.setTitleAt(2, fname + " Field");
        }
        if (this.m_msg != null && this.m_msg instanceof MapMessage) {
            try {
                if (asText) {
                    this.m_bytesTextArea.setText(new String(((MapMessage)this.m_msg).getBytes(fname)));
                } else {
                    this.m_bytesTextArea.setText(GemsUtilities.dumpBytes(((MapMessage)this.m_msg).getBytes(fname)));
                }
                this.m_tabPane.setSelectedIndex(2);
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getMessage());
                return;
            }
        }
    }

    public void createTextUI() {
        if (this.m_mapPanel != null) {
            this.m_tabPane.remove(this.m_mapPanel);
            this.m_mapPanel = null;
            this.m_mapTableModel = null;
            this.m_tabPane.addTab("Text Body", this.m_textPanel);
        }
        if (this.m_send) {
            if (this.m_isQueue) {
                this.setTitle(Gems.getGems().getTitlePrefix() + "Send TextMessage To Queue");
            } else {
                this.setTitle(Gems.getGems().getTitlePrefix() + "Publish TextMessage To Topic");
            }
        }
    }

    public void createSimpleUI() {
        if (this.m_tabPane.getTabCount() > 1) {
            this.m_tabPane.remove(this.m_textPanel);
        }
        if (this.m_send) {
            if (this.m_isQueue) {
                this.setTitle(Gems.getGems().getTitlePrefix() + "Send SimpleMessage To Queue");
            } else {
                this.setTitle(Gems.getGems().getTitlePrefix() + "Publish SimpleMessage To Topic");
            }
        }
    }

    public void populate(Message m) {
        this.m_msg = m;
        this.m_saveMenuItem.setEnabled(true);
        try {
            String s = m.getClass().getName();
            int i = s.lastIndexOf("Tibjms");
            String id = new String();
            if (m.getJMSMessageID() != null) {
                id = m.getJMSMessageID();
            }
            if (this.m_isMonitorMsg) {
                this.setTitle(Gems.getGems().getTitlePrefix() + " MonitorEvent: " + id);
            } else if (i > 0) {
                this.setTitle(Gems.getGems().getTitlePrefix() + s.substring(i + 6) + " " + id);
            }
            this.m_tableModel.populatePropertyInfo(m);
            this.m_text.setMessageText(m);
            if (m instanceof TextMessage) {
                if (this.m_tabPane.getTabCount() > 1) {
                    this.m_tabPane.setTitleAt(1, "Text Body");
                }
            } else if (m instanceof MapMessage) {
                this.createMapUI();
                MapMessage mm = (MapMessage)m;
                this.m_mapTableModel.populateMapMsg(mm);
            } else if (m instanceof BytesMessage) {
                if (this.m_tabPane.getTabCount() > 1) {
                    this.m_tabPane.setTitleAt(1, "Bytes Body (" + ((BytesMessage)m).getBodyLength() + " bytes)");
                }
            } else if (m instanceof StreamMessage) {
                if (this.m_tabPane.getTabCount() > 1) {
                    this.m_tabPane.setTitleAt(1, "Body");
                }
            } else if (m instanceof ObjectMessage) {
                if (this.m_tabPane.getTabCount() > 1) {
                    this.m_tabPane.setTitleAt(1, "Body");
                }
            } else {
                this.createSimpleUI();
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            return;
        }
    }

    public void openSubMapMsg(String name) {
        if (this.m_msg != null && this.m_msg instanceof MapMessage) {
            try {
                MapMessage mapMsg = (MapMessage)this.m_msg;
                Object o = mapMsg.getObject(name);
                if (o != null && o instanceof MapMessage) {
                    GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, this.m_destination, this.m_isQueue, this.m_frame, false);
                    f.populate((Message)((MapMessage)o));
                } else if (mapMsg.itemExists("message_bytes")) {
                    Message msg = Tibjms.createFromBytes((byte[])mapMsg.getBytes("message_bytes"));
                    GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, this.m_destination, this.m_isQueue, this.m_frame, false);
                    f.populate(msg);
                }
            }
            catch (Exception ie) {
                Gems.debug(ie.getMessage());
                return;
            }
        }
    }

    public GemsMsgPropTableModel getModel() {
        return this.m_tableModel;
    }

    Message createMessage(Session session) throws JMSException {
        Object msg = null;
        msg = this.m_mapPanel != null ? session.createMapMessage() : session.createTextMessage();
        msg.setJMSMessageID(this.m_tableModel.getJMSMessageID());
        msg.setJMSCorrelationID(this.m_tableModel.getJMSCorrelationID());
        msg.setJMSDeliveryMode(this.m_tableModel.getJMSDeliveryMode());
        msg.setJMSExpiration((long)this.m_tableModel.getJMSExpiration());
        msg.setJMSPriority(this.m_tableModel.getJMSPriority());
        msg.setJMSType(this.m_tableModel.getJMSType());
        GemsDestination rpt = this.m_tableModel.getJMSReplyTo();
        if (rpt != null) {
            if (rpt.m_destType == GemsDestination.DEST_TYPE.Queue) {
                msg.setJMSReplyTo((Destination)session.createQueue(rpt.m_destName));
            } else {
                msg.setJMSReplyTo((Destination)session.createTopic(rpt.m_destName));
            }
        }
        for (int i = this.m_tableModel.getHeaderRows(); i < this.m_tableModel.getRowCount(); ++i) {
            String p = (String)this.m_tableModel.getValueAt(i, 0);
            if (p == null || p.length() <= 0) continue;
            Object o = this.m_tableModel.getValueAt(i, 1);
            if (o instanceof String) {
                msg.setStringProperty(p, (String)o);
                continue;
            }
            if (o instanceof Boolean) {
                msg.setBooleanProperty(p, ((Boolean)o).booleanValue());
                continue;
            }
            if (o instanceof Integer) {
                msg.setIntProperty(p, ((Integer)o).intValue());
                continue;
            }
            if (o instanceof Long) {
                msg.setLongProperty(p, ((Long)o).longValue());
                continue;
            }
            if (o instanceof Short) {
                msg.setShortProperty(p, ((Short)o).shortValue());
                continue;
            }
            if (o instanceof Byte) {
                msg.setByteProperty(p, ((Byte)o).byteValue());
                continue;
            }
            if (o instanceof Float) {
                msg.setFloatProperty(p, ((Float)o).floatValue());
                continue;
            }
            if (!(o instanceof Double)) continue;
            msg.setDoubleProperty(p, ((Double)o).doubleValue());
        }
        if (msg instanceof TextMessage) {
            ((TextMessage)msg).setText(this.m_text.getText());
        } else if (msg instanceof MapMessage) {
            MapMessage mm = msg;
            for (int i = this.m_mapTableModel.getHeaderRows(); i < this.m_mapTableModel.getRowCount(); ++i) {
                String p = (String)this.m_mapTableModel.getValueAt(i, 0);
                if (p == null || p.length() <= 0) continue;
                Object o = this.m_mapTableModel.getValueAt(i, 1);
                if (o instanceof String) {
                    mm.setString(p, (String)o);
                    continue;
                }
                if (o instanceof Boolean) {
                    mm.setBoolean(p, ((Boolean)o).booleanValue());
                    continue;
                }
                if (o instanceof Integer) {
                    mm.setInt(p, ((Integer)o).intValue());
                    continue;
                }
                if (o instanceof Long) {
                    mm.setLong(p, ((Long)o).longValue());
                    continue;
                }
                if (o instanceof Short) {
                    mm.setShort(p, ((Short)o).shortValue());
                    continue;
                }
                if (o instanceof Byte) {
                    mm.setByte(p, ((Byte)o).byteValue());
                    continue;
                }
                if (o instanceof Float) {
                    mm.setFloat(p, ((Float)o).floatValue());
                    continue;
                }
                if (!(o instanceof Double)) continue;
                mm.setDouble(p, ((Double)o).doubleValue());
            }
        }
        return msg;
    }

    private JMenuBar constructMenuBar(boolean send) {
        JMenuItem menuItem;
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        this.m_menuBar.add(menu);
        if (send) {
            JMenu sm;
            menuItem = menu.add(new JMenuItem("Load from File..."));
            menuItem.addActionListener(new LoadMessage());
            JMenu pmenu = new JMenu("Property");
            pmenu.setMnemonic(80);
            this.m_menuBar.add(pmenu);
            if (!this.m_isEditor) {
                sm = new JMenu("Add JMS Property");
                pmenu.add(sm);
                menuItem = sm.add(new JMenuItem("JMSReplyTo..."));
                menuItem.addActionListener(new AddJMSReplyToProperty());
            }
            sm = new JMenu("Add Tibco Property");
            pmenu.add(sm);
            menuItem = sm.add(new JMenuItem("JMS_TIBCO_COMPRESS"));
            menuItem.addActionListener(new AddCompressProperty());
            menuItem = sm.add(new JMenuItem("JMS_TIBCO_PRESERVE_UNDELIVERED"));
            menuItem.addActionListener(new AddPreserveProperty());
            sm = new JMenu("Add Custom Property");
            pmenu.add(sm);
            menuItem = sm.add(new JMenuItem("String"));
            menuItem.addActionListener(new AddStringProperty());
            menuItem = sm.add(new JMenuItem("Boolean"));
            menuItem.addActionListener(new AddBooleanProperty());
            menuItem = sm.add(new JMenuItem("Integer"));
            menuItem.addActionListener(new AddIntegerProperty());
            menuItem = sm.add(new JMenuItem("Byte"));
            menuItem.addActionListener(new AddByteProperty());
            menuItem = sm.add(new JMenuItem("Short"));
            menuItem.addActionListener(new AddShortProperty());
            menuItem = sm.add(new JMenuItem("Long"));
            menuItem.addActionListener(new AddLongProperty());
            menuItem = sm.add(new JMenuItem("Float"));
            menuItem.addActionListener(new AddFloatProperty());
            menuItem = sm.add(new JMenuItem("Double"));
            menuItem.addActionListener(new AddDoubleProperty());
        }
        this.m_saveMenuItem = menu.add(new JMenuItem("Save to File..."));
        if (send) {
            this.m_saveMenuItem.setEnabled(false);
        }
        this.m_saveMenuItem.addActionListener(new SaveMessage());
        menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsMessageFrame.this.dispose();
            }
        });
        if (this.m_isMonitorMsg) {
            menu = new JMenu("Message");
            menu.setMnemonic(77);
            this.m_menuBar.add(menu);
            menuItem = menu.add(new JMenuItem("View Original JMS Message..."));
            menuItem.addActionListener(new ViewOrigMsg(this));
        }
        return this.m_menuBar;
    }

    public void close() {
        try {
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (JMSException e) {
            System.err.println("Exception: " + e.getMessage());
        }
    }

    @Override
    public void dispose() {
        this.close();
        super.dispose();
    }

    class ViewOrigMsg
    implements ActionListener {
        Component parent;

        public ViewOrigMsg(Component p) {
            this.parent = p;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsMessageFrame.this.m_isMonitorMsg && GemsMessageFrame.this.m_msg != null) {
                try {
                    MapMessage mapMsg = (MapMessage)GemsMessageFrame.this.m_msg;
                    if (mapMsg.itemExists("message_bytes")) {
                        Message msg = Tibjms.createFromBytes((byte[])mapMsg.getBytes("message_bytes"));
                        GemsMessageFrame f = new GemsMessageFrame(GemsMessageFrame.this.m_cn, false, GemsMessageFrame.this.m_destination, GemsMessageFrame.this.m_isQueue, GemsMessageFrame.this.m_frame, false);
                        f.populate(msg);
                    } else {
                        JOptionPane.showMessageDialog(null, "There is no JMS message associated with this monitor event message", "Error", 1);
                    }
                }
                catch (Exception ie) {
                    Gems.debug(ie.getMessage());
                    return;
                }
            }
        }
    }

    class AddJMSReplyToProperty
    implements ActionListener {
        AddJMSReplyToProperty() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsMessageFrame.this.m_frame, GemsMessageFrame.this.m_cn);
            if (dp.m_retDest != null) {
                GemsMessageFrame.this.m_tabPane.setSelectedIndex(0);
                GemsMessageFrame.this.m_tableModel.addJMSReplyToProperty(dp.m_retDest);
            }
        }
    }

    class AddDoubleField
    implements ActionListener {
        AddDoubleField() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(1);
            GemsMessageFrame.this.m_mapTableModel.addDoubleProperty();
        }
    }

    class AddFloatField
    implements ActionListener {
        AddFloatField() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(1);
            GemsMessageFrame.this.m_mapTableModel.addFloatProperty();
        }
    }

    class AddBooleanField
    implements ActionListener {
        AddBooleanField() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(1);
            GemsMessageFrame.this.m_mapTableModel.addBooleanProperty();
        }
    }

    class AddByteField
    implements ActionListener {
        AddByteField() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(1);
            GemsMessageFrame.this.m_mapTableModel.addByteProperty();
        }
    }

    class AddShortField
    implements ActionListener {
        AddShortField() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(1);
            GemsMessageFrame.this.m_mapTableModel.addShortProperty();
        }
    }

    class AddLongField
    implements ActionListener {
        AddLongField() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(1);
            GemsMessageFrame.this.m_mapTableModel.addLongProperty();
        }
    }

    class AddIntegerField
    implements ActionListener {
        AddIntegerField() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(1);
            GemsMessageFrame.this.m_mapTableModel.addIntProperty();
        }
    }

    class AddStringField
    implements ActionListener {
        AddStringField() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(1);
            GemsMessageFrame.this.m_mapTableModel.addStringProperty();
        }
    }

    class AddPreserveProperty
    implements ActionListener {
        AddPreserveProperty() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(0);
            GemsMessageFrame.this.m_tableModel.addPreserveProperty();
        }
    }

    class AddCompressProperty
    implements ActionListener {
        AddCompressProperty() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(0);
            GemsMessageFrame.this.m_tableModel.addCompressProperty();
        }
    }

    class AddDoubleProperty
    implements ActionListener {
        AddDoubleProperty() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(0);
            GemsMessageFrame.this.m_tableModel.addDoubleProperty();
        }
    }

    class AddFloatProperty
    implements ActionListener {
        AddFloatProperty() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(0);
            GemsMessageFrame.this.m_tableModel.addFloatProperty();
        }
    }

    class AddBooleanProperty
    implements ActionListener {
        AddBooleanProperty() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(0);
            GemsMessageFrame.this.m_tableModel.addBooleanProperty();
        }
    }

    class AddByteProperty
    implements ActionListener {
        AddByteProperty() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(0);
            GemsMessageFrame.this.m_tableModel.addByteProperty();
        }
    }

    class AddShortProperty
    implements ActionListener {
        AddShortProperty() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(0);
            GemsMessageFrame.this.m_tableModel.addShortProperty();
        }
    }

    class AddLongProperty
    implements ActionListener {
        AddLongProperty() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(0);
            GemsMessageFrame.this.m_tableModel.addLongProperty();
        }
    }

    class AddIntegerProperty
    implements ActionListener {
        AddIntegerProperty() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(0);
            GemsMessageFrame.this.m_tableModel.addIntProperty();
        }
    }

    class AddStringProperty
    implements ActionListener {
        AddStringProperty() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageFrame.this.m_tabPane.setSelectedIndex(0);
            GemsMessageFrame.this.m_tableModel.addStringProperty();
        }
    }

    class LoadMessage
    implements ActionListener {
        LoadMessage() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block18: {
                try {
                    String l;
                    JFileChooser chooser = new JFileChooser(new File("."));
                    chooser.setDialogTitle("Load Messages From File");
                    int returnVal = chooser.showOpenDialog(GemsMessageFrame.this.m_frame);
                    if (returnVal != 0) break block18;
                    File f = chooser.getSelectedFile();
                    BufferedReader d = new BufferedReader(new FileReader(f));
                    GemsMessageFrame.this.m_text.setText("");
                    GemsMessageFrame.this.m_tableModel.emptyPropertyInfo(GemsMessageFrame.this.m_destprop);
                    StringBuffer t = new StringBuffer();
                    StringBuffer t1 = new StringBuffer();
                    boolean first = true;
                    boolean first1 = true;
                    boolean found = false;
                    boolean readingHeader = false;
                    block2: while ((l = d.readLine()) != null) {
                        int i;
                        if (!first1) {
                            t1.append('\n');
                        }
                        t1.append(l);
                        first1 = false;
                        if (l.startsWith("$Header:") || l.startsWith("$MsgHeader$")) {
                            readingHeader = true;
                        }
                        if (readingHeader && l.startsWith("JMS") && (i = l.indexOf(61)) > 0) {
                            String val = l.substring(i + 1);
                            if (l.startsWith("JMSType")) {
                                GemsMessageFrame.this.m_tableModel.setJMSType(val);
                            } else if (l.startsWith("JMSCorrelationID")) {
                                GemsMessageFrame.this.m_tableModel.setJMSCorrelationID(val);
                            }
                        }
                        boolean endMsg = false;
                        if (!l.startsWith("$Properties:") && !l.startsWith("$MsgProperties$")) continue;
                        found = true;
                        while ((l = d.readLine()) != null && !endMsg) {
                            if (l.startsWith("$Body:") || l.startsWith("$TextBody:") || l.startsWith("$MsgTextBody$")) {
                                while ((l = d.readLine()) != null) {
                                    if (l.startsWith("$MsgEnd$") || l.startsWith("$MsgStart$")) {
                                        endMsg = true;
                                        break;
                                    }
                                    if (!first) {
                                        t.append('\n');
                                    }
                                    t.append(l);
                                    first = false;
                                }
                                GemsMessageFrame.this.createTextUI();
                                GemsMessageFrame.this.m_text.setText(t.toString());
                                break block2;
                            }
                            if (l.startsWith("$MapBody:") || l.startsWith("$MsgMapBody$")) {
                                GemsMessageFrame.this.createMapUI();
                                GemsMessageFrame.this.m_mapTableModel.populateEmptyPropertyInfo(0);
                                while ((l = d.readLine()) != null) {
                                    if (l.startsWith("$MsgEnd$") || l.startsWith("$MsgStart$")) {
                                        endMsg = true;
                                        break block2;
                                    }
                                    if (GemsMessageFrame.this.m_mapTableModel == null) continue;
                                    GemsMessageFrame.this.m_mapTableModel.addPropertyInfo(l);
                                }
                                break block2;
                            }
                            if (!l.startsWith("JMS_") && l.startsWith("JMS")) continue;
                            GemsMessageFrame.this.m_tableModel.addPropertyInfo(l);
                        }
                        break block2;
                    }
                    if (!found) {
                        GemsMessageFrame.this.m_text.setText(t1.toString());
                    }
                    d.close();
                }
                catch (IOException ie) {
                    System.err.println("JavaIOException: " + ie.getMessage());
                    return;
                }
            }
        }
    }

    class SaveMessage
    implements ActionListener {
        SaveMessage() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsMessageFrame.this.m_msg == null) {
                return;
            }
            try {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Save Message To File");
                int returnVal = chooser.showOpenDialog(GemsMessageFrame.this.m_frame);
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    f.createNewFile();
                    FileOutputStream fout = new FileOutputStream(f);
                    PrintStream p = new PrintStream(fout);
                    p.println("$MsgHeader$");
                    p.println("JMSMessageID=" + GemsMessageFrame.this.m_msg.getJMSMessageID());
                    Date d = new Date();
                    d.setTime(GemsMessageFrame.this.m_msg.getJMSTimestamp());
                    p.println("JMSTimestamp=" + GemsMessageFrame.this.dateFormatMillis.format(d).toString());
                    p.println("JMSDestination=" + GemsMessageFrame.this.m_msg.getJMSDestination());
                    String dm = GemsMessageFrame.this.m_msg.getJMSDeliveryMode() == 2 ? "PERSISTENT" : (GemsMessageFrame.this.m_msg.getJMSDeliveryMode() == 1 ? "NON_PERSISTENT" : "RELIABLE");
                    p.println("JMSDeliveryMode=" + dm);
                    if (GemsMessageFrame.this.m_msg.getJMSCorrelationID() != null) {
                        p.println("JMSCorrelationID=" + GemsMessageFrame.this.m_msg.getJMSCorrelationID());
                    }
                    if (GemsMessageFrame.this.m_msg.getJMSType() != null) {
                        p.println("JMSType=" + GemsMessageFrame.this.m_msg.getJMSType());
                    }
                    if (GemsMessageFrame.this.m_msg.getJMSReplyTo() != null) {
                        p.println("JMSReplyTo=" + GemsMessageFrame.this.m_msg.getJMSReplyTo());
                    }
                    if (GemsMessageFrame.this.m_msg.getJMSExpiration() != 0L) {
                        d.setTime(GemsMessageFrame.this.m_msg.getJMSExpiration());
                        p.println("JMSExpiration=" + GemsMessageFrame.this.dateFormatMillis.format(d).toString());
                    }
                    if (Gems.getGems().isJMS2() && GemsMessageFrame.this.m_msg.getJMSDeliveryTime() != 0L) {
                        d.setTime(GemsMessageFrame.this.m_msg.getJMSDeliveryTime());
                        p.println("JMSDeliveryTime=" + GemsMessageFrame.this.dateFormatMillis.format(d).toString());
                    }
                    p.println("JMSPriority=" + String.valueOf(GemsMessageFrame.this.m_msg.getJMSPriority()));
                    boolean rd = GemsMessageFrame.this.m_msg.getJMSRedelivered();
                    if (rd) {
                        p.println("JMSRedelivered=true");
                    }
                    p.println("$MsgProperties$");
                    Enumeration props = GemsMessageFrame.this.m_msg.getPropertyNames();
                    while (props.hasMoreElements()) {
                        String ps = (String)props.nextElement();
                        p.println(ps + "=" + GemsMsgPropTableModel.toTypedString(null, GemsMessageFrame.this.m_msg.getObjectProperty(ps)));
                    }
                    if (GemsMessageFrame.this.m_msg instanceof TextMessage) {
                        TextMessage textMsg = (TextMessage)GemsMessageFrame.this.m_msg;
                        p.println("$MsgTextBody$");
                        p.println(textMsg.getText());
                    } else if (GemsMessageFrame.this.m_msg instanceof MapMessage) {
                        MapMessage innerMapMsg = (MapMessage)GemsMessageFrame.this.m_msg;
                        p.println("$MsgMapBody$");
                        Enumeration pops = innerMapMsg.getMapNames();
                        while (pops.hasMoreElements()) {
                            String pn = (String)pops.nextElement();
                            p.println(pn + "=" + GemsMsgPropTableModel.toTypedString(null, innerMapMsg.getObject(pn)));
                        }
                    } else if (GemsMessageFrame.this.m_msg instanceof BytesMessage) {
                        BytesMessage bytesMsg = (BytesMessage)GemsMessageFrame.this.m_msg;
                        p.println("$MagBytesBody$");
                        bytesMsg.reset();
                        long s = bytesMsg.getBodyLength();
                        byte[] b = new byte[(int)s];
                        bytesMsg.readBytes(b, (int)s);
                        p.println(GemsUtilities.dumpBytes(b));
                    } else if (GemsMessageFrame.this.m_msg instanceof StreamMessage) {
                        StreamMessage streamMsg = (StreamMessage)GemsMessageFrame.this.m_msg;
                        p.println("$MagStreamBody$");
                        p.println(streamMsg.toString());
                    } else if (GemsMessageFrame.this.m_msg instanceof ObjectMessage) {
                        ObjectMessage objectMsg = (ObjectMessage)GemsMessageFrame.this.m_msg;
                        p.println("$MagObjectBody$");
                        p.println(objectMsg.toString());
                    }
                    p.close();
                }
            }
            catch (JMSException ex) {
                System.err.println("JMSException: " + ex.getMessage());
                return;
            }
            catch (IOException ie) {
                System.err.println("JavaIOException: " + ie.getMessage());
                return;
            }
        }
    }

    class SendPressed
    implements ActionListener {
        SendPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsMessageFrame.this.m_table.getCellEditor() != null) {
                GemsMessageFrame.this.m_table.getCellEditor().stopCellEditing();
            }
            if (GemsMessageFrame.this.m_mapTableModel != null && GemsMessageFrame.this.m_mapTableModel.m_table != null && GemsMessageFrame.this.m_mapTableModel.m_table.getCellEditor() != null) {
                GemsMessageFrame.this.m_mapTableModel.m_table.getCellEditor().stopCellEditing();
            }
            if (GemsMessageFrame.this.m_isEditor) {
                GemsMessageFrame.this.dispose();
                return;
            }
            String dest = GemsMessageFrame.this.m_tableModel.getJMSDestination();
            try {
                if (GemsMessageFrame.this.m_isQueue) {
                    if (GemsMessageFrame.this.m_admin.getQueue(dest) == null) {
                        JOptionPane.showMessageDialog(GemsMessageFrame.this.m_this, "The destination queue does not exist!", "Error", 1);
                        return;
                    }
                } else if (GemsMessageFrame.this.m_admin.getTopic(dest) == null) {
                    JOptionPane.showMessageDialog(GemsMessageFrame.this.m_this, "The destination topic does not exist!", "Error", 1);
                    return;
                }
            }
            catch (TibjmsAdminException ex) {
                JOptionPane.showMessageDialog(GemsMessageFrame.this.m_this, ex.getMessage(), "Error", 1);
                return;
            }
            catch (Exception ex1) {
                JOptionPane.showMessageDialog(GemsMessageFrame.this.m_this, "Connection Error, please close send message window and retry", "Error", 1);
                return;
            }
            MessageProducer msgProducer = null;
            try {
                if (GemsMessageFrame.this.m_connection == null) {
                    TibjmsConnectionFactory factory = new TibjmsConnectionFactory(GemsMessageFrame.this.m_cn.m_url, null, GemsMessageFrame.this.m_cn.m_sslParams);
                    GemsMessageFrame.this.m_connection = factory.createConnection(GemsMessageFrame.this.m_cn.m_user, GemsMessageFrame.this.m_cn.m_password);
                    GemsMessageFrame.this.m_connection.start();
                }
                if (GemsMessageFrame.this.m_session == null) {
                    GemsMessageFrame.this.m_session = GemsMessageFrame.this.m_connection.createSession(false, 1);
                }
                Object destination = GemsMessageFrame.this.m_isQueue ? GemsMessageFrame.this.m_session.createQueue(dest) : GemsMessageFrame.this.m_session.createTopic(dest);
                msgProducer = GemsMessageFrame.this.m_session.createProducer(null);
                Message msg = GemsMessageFrame.this.createMessage(GemsMessageFrame.this.m_session);
                if (Gems.getGems().isJMS2()) {
                    msgProducer.setDeliveryDelay(GemsMessageFrame.this.m_tableModel.getJMSDeliveryTime());
                }
                msgProducer.send((Destination)destination, msg, GemsMessageFrame.this.m_tableModel.getJMSDeliveryMode(), GemsMessageFrame.this.m_tableModel.getJMSPriority(), (long)GemsMessageFrame.this.m_tableModel.getJMSExpiration());
                if (GemsMessageFrame.this.m_isQueue) {
                    GemsMessageFrame.this.m_sendButt.setText("Send Again");
                } else {
                    GemsMessageFrame.this.m_sendButt.setText("Publish Again");
                }
                msgProducer.close();
            }
            catch (JMSException ex) {
                JOptionPane.showMessageDialog(GemsMessageFrame.this.m_this, ex.getMessage(), "Error", 1);
                System.err.println("Exception: " + ex.getMessage());
                GemsMessageFrame.this.close();
                return;
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(GemsMessageFrame.this.m_this, exc.getMessage(), "Error", 1);
                System.err.println("Exception: " + exc.getMessage());
                return;
            }
        }
    }
}

