/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsBrowserOptionsDialog;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsMessageSenderTableModel;
import com.tibco.gems.GemsMsgPropTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.TibjmsConnectionFactory;
import com.tibco.tibjms.admin.TibjmsAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.text.DefaultEditorKit;

public class GemsMessageSender
extends JFrame {
    JFrame m_frame;
    JPanel m_panel;
    boolean m_running = false;
    boolean m_isQueue = false;
    Message m_msg = null;
    TibjmsAdmin m_admin = null;
    Session m_session = null;
    GemsConnectionNode m_cn;
    Connection m_connection = null;
    MessageProducer m_producer = null;
    Destination m_jmsdest = null;
    Timer m_timer = new Timer(200, new RefreshTimerAction());
    protected boolean m_viewoldestFirst = true;
    protected JTextField m_conn;
    protected JTextField m_dest;
    protected JButton m_destwiz;
    protected JTextField m_msgsDisplay;
    protected JButton m_startButton;
    protected JButton m_stopButton;
    protected JTextField m_delay;
    protected JCheckBox m_noDelay;
    JTable m_table;
    protected GemsMessageSenderTableModel m_tableModel;
    protected JMenuItem m_dumpMenuItem;
    protected JMenuItem m_optMenuItem;
    TableSorter m_sorter;
    Hashtable m_msgs = null;
    Vector m_rows = null;
    int m_msgCount = 0;

    public GemsMessageSender(GemsConnectionNode cn, String dest, boolean isQueue, String title) {
        super(Gems.getGems().getTitlePrefix() + title);
        this.setLocation(650, 175);
        this.setDefaultCloseOperation(2);
        this.m_frame = this;
        this.m_cn = cn;
        this.m_isQueue = isQueue;
        String prefix = isQueue ? "Queue" : "Topic";
        this.m_tableModel = new GemsMessageSenderTableModel(false, true);
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 25);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JPanel qpanel = new JPanel(true);
        qpanel.setLayout(new BoxLayout(qpanel, 0));
        JLabel l2 = new JLabel(prefix + " To Send To:", 11);
        this.m_dest = new JTextField(dest, 30);
        l2.setLabelFor(this.m_dest);
        panel.add(l2);
        qpanel.add(this.m_dest);
        this.m_destwiz = new JButton("...");
        this.m_destwiz.setPreferredSize(new Dimension(18, 16));
        this.m_destwiz.addActionListener(new DestinationWizardAction());
        qpanel.add(this.m_destwiz);
        panel.add(qpanel);
        JLabel l9 = new JLabel("", 11);
        panel.add(l9);
        JLabel l5 = new JLabel("", 11);
        panel.add(l5);
        JPanel mpanel = new JPanel(true);
        mpanel.setLayout(new BoxLayout(mpanel, 0));
        JLabel l7 = new JLabel("Delay Between Sends(ms):", 11);
        this.m_delay = new JTextField("200", 20);
        this.m_delay.setMinimumSize(new Dimension(40, 24));
        mpanel.setPreferredSize(new Dimension(100, 24));
        l7.setLabelFor(this.m_delay);
        panel.add(l7);
        mpanel.add(this.m_delay);
        this.m_noDelay = new JCheckBox("None", false);
        mpanel.add(this.m_noDelay);
        panel.add(mpanel);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.setSelectionMode(0);
        this.m_tableModel.m_table = this.m_table;
        this.addMouseListenerToTable(this.m_table);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(650, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(350, 10));
        bpanel.add(bx);
        this.m_startButton = new JButton("Start");
        this.m_startButton.addActionListener(new StartPressed());
        this.m_stopButton = new JButton("Stop");
        this.m_stopButton.addActionListener(new StopPressed());
        this.m_stopButton.setEnabled(false);
        bpanel.add(this.m_startButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_stopButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 2, 4, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.pack();
        this.show();
    }

    public void start() {
        if (this.m_dest.getText().length() == 0 || this.m_dest.getText().equals(">")) {
            JOptionPane.showMessageDialog(this.m_frame, "Invalid destination", "Error", 1);
            return;
        }
        if (this.m_session == null) {
            return;
        }
        this.m_running = true;
        this.m_dest.setEnabled(false);
        this.m_startButton.setEnabled(false);
        this.m_stopButton.setEnabled(true);
        this.m_destwiz.setEnabled(false);
        this.m_dumpMenuItem.setEnabled(false);
        this.m_noDelay.setEnabled(false);
        this.m_delay.setEnabled(false);
        this.m_msgCount = 0;
        int delay = 0;
        try {
            delay = Integer.parseInt(this.m_delay.getText());
        }
        catch (Exception ie) {
            delay = 200;
        }
        if (this.m_noDelay.isSelected()) {
            delay = 0;
        }
        this.m_msgs = (Hashtable)this.m_tableModel.m_msgs.clone();
        this.m_rows = new Vector();
        for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
            this.m_rows.add((String)this.m_tableModel.m_table.getValueAt(i, 1));
        }
        this.m_tableModel.buildColumnHeaders();
        if (this.m_dest.getText() == null || this.m_dest.getText().length() == 0) {
            this.stop();
            return;
        }
        try {
            this.m_jmsdest = this.m_isQueue ? this.m_session.createQueue(this.m_dest.getText()) : this.m_session.createTopic(this.m_dest.getText());
            this.m_producer = this.m_session.createProducer(this.m_jmsdest);
            if (this.m_timer == null) {
                this.m_timer = new Timer(delay, new RefreshTimerAction());
            } else {
                this.m_timer.setDelay(delay);
            }
            this.m_timer.setInitialDelay(200);
            this.m_timer.start();
        }
        catch (JMSException e) {
            JOptionPane.showMessageDialog(this.m_frame, e.getMessage(), "Error", 1);
            this.stop();
        }
    }

    public void connect() {
        if (this.m_connection != null) {
            return;
        }
        try {
            TibjmsConnectionFactory factory = new TibjmsConnectionFactory(this.m_cn.m_url, null, this.m_cn.m_sslParams);
            this.m_connection = factory.createConnection(this.m_cn.m_user, this.m_cn.m_password);
            this.m_session = this.m_connection.createSession(false, 1);
            this.m_connection.start();
        }
        catch (JMSException e) {
            JOptionPane.showMessageDialog(this.m_frame, e.getMessage(), "Error", 1);
        }
    }

    public void stop() {
        this.m_timer.stop();
        this.m_running = false;
        this.m_msgs = null;
        this.m_rows = null;
        try {
            if (this.m_producer != null) {
                this.m_producer.close();
                this.m_producer = null;
            }
        }
        catch (JMSException e) {
            System.err.println("Exception: " + e.getMessage());
        }
        this.m_dest.setEnabled(true);
        this.m_startButton.setEnabled(true);
        this.m_stopButton.setEnabled(false);
        this.m_destwiz.setEnabled(true);
        this.m_dumpMenuItem.setEnabled(true);
        this.m_noDelay.setEnabled(true);
        this.m_delay.setEnabled(true);
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GemsMessageSender.this.showMessageFrame();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Load Messages from File..."));
        menuItem.addActionListener(new LoadMessagesAction());
        this.m_dumpMenuItem = new JMenuItem("Save Messages To File...");
        this.m_dumpMenuItem.addActionListener(new DumpToFile());
        menu.add(this.m_dumpMenuItem);
        menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsMessageSender.this.dispose();
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem("Select All");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menuItem.addActionListener(new SelectAllAction());
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Message");
        menu.setMnemonic(77);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("View Message..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsMessageSender.this.showMessageFrame();
            }
        });
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("Add New TextMessage..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsMessageSender.this.addNewMessage(false, false);
            }
        });
        menuItem = menu.add(new JMenuItem("Add New MapMessage..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsMessageSender.this.addNewMessage(false, true);
            }
        });
        menuItem = menu.add(new JMenuItem("Insert New TextMessage..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsMessageSender.this.addNewMessage(true, false);
            }
        });
        menuItem = menu.add(new JMenuItem("Insert New MapMessage..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsMessageSender.this.addNewMessage(true, true);
            }
        });
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("Remove Checked Messages"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsMessageSender.this.m_tableModel.removeSelectedMessages();
            }
        });
        return menuBar;
    }

    public void showMessageFrame() {
        Message m = this.m_tableModel.getSelectedMessage();
        if (m != null) {
            GemsMessageFrame f = new GemsMessageFrame(this.m_cn, true, this.m_dest.getText(), true, null, false, false, true, true);
            f.populate(m);
            f.show();
            try {
                m = f.createMessage(this.m_session);
                this.m_tableModel.updateSelectedMessage(m);
            }
            catch (JMSException e) {
                System.err.println("JMSException: " + e.getMessage());
            }
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "Select a Message to view!", "View Message", 1);
        }
    }

    public void addNewMessage(boolean insert, boolean isMap) {
        GemsMessageFrame f = new GemsMessageFrame(this.m_cn, true, this.m_dest.getText(), true, null, false, isMap, true, true);
        f.show();
        try {
            this.connect();
            Message m = f.createMessage(this.m_session);
            if (this.m_tableModel.getColumnCount() == 0) {
                this.m_tableModel.buildColumnHeaders();
            }
            this.m_tableModel.addMessage(m, !insert, this.m_tableModel.m_table.getSelectedRow());
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
        }
    }

    void loadMessages(File f) {
        BufferedReader inReader = null;
        Vector<TextMessage> msgs = new Vector<TextMessage>();
        try {
            if (f == null) {
                return;
            }
            this.connect();
            if (this.m_session == null) {
                return;
            }
            inReader = new BufferedReader(new FileReader(f));
            while (true) {
                String l;
                boolean foundmsg = false;
                while ((l = inReader.readLine()) != null) {
                    if (!l.startsWith("$MsgStart$") && !l.startsWith("$MsgHeader$") && !l.startsWith("$Header")) continue;
                    foundmsg = true;
                    break;
                }
                if (!foundmsg) break;
                TextMessage msg = null;
                TextMessage textmsg = this.m_session.createTextMessage();
                MapMessage mapmsg = this.m_session.createMapMessage();
                StringBuffer t = new StringBuffer();
                boolean endMsg = false;
                block7: while ((l = inReader.readLine()) != null && !endMsg) {
                    if (l.startsWith("$MsgProperties$") || l.startsWith("$Properties")) {
                        while ((l = inReader.readLine()) != null && !endMsg) {
                            if (l.startsWith("$MsgTextBody$") || l.startsWith("$TextBody") || l.startsWith("$Body")) {
                                msg = textmsg;
                                boolean first = true;
                                while ((l = inReader.readLine()) != null) {
                                    if (l.startsWith("$MsgEnd$") || l.startsWith("$MsgStart$")) {
                                        endMsg = true;
                                        break;
                                    }
                                    if (!first) {
                                        t.append('\n');
                                    }
                                    t.append(l);
                                    first = false;
                                }
                                textmsg.setText(t.toString());
                                break block7;
                            }
                            if (l.startsWith("$MsgMapBody$") || l.startsWith("$MapBody")) {
                                msg = mapmsg;
                                while ((l = inReader.readLine()) != null) {
                                    if (l.startsWith("$MsgEnd$") || l.startsWith("$MsgStart$")) {
                                        endMsg = true;
                                        break block7;
                                    }
                                    this.setMapMsgProp(l, mapmsg);
                                }
                                break block7;
                            }
                            if (l.startsWith("$Msg")) {
                                if (!l.startsWith("$MsgEnd$") && !l.startsWith("$MsgStart$")) {
                                    System.err.println("Warning: Message type " + l + " not supported");
                                }
                                foundmsg = false;
                                break block7;
                            }
                            this.setMsgProp(l, (Message)textmsg);
                            this.setMsgProp(l, (Message)mapmsg);
                        }
                        break;
                    }
                    if (l.startsWith("$MsgHeader$")) continue;
                    this.setJMSMsgProp(l, (Message)textmsg);
                    this.setJMSMsgProp(l, (Message)mapmsg);
                }
                if (!foundmsg || msg == null) continue;
                msgs.add(msg);
            }
        }
        catch (JMSException ex) {
            System.err.println("JMSException: " + ex.getMessage());
        }
        catch (IOException ie) {
            System.err.println("JavaIOException: " + ie.getMessage());
        }
        try {
            if (inReader != null) {
                inReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (msgs.size() == 0) {
            JOptionPane.showMessageDialog(this.m_frame, "Error: No messages found in input file", "Error", 1);
        } else {
            this.m_tableModel.populateMessageInfo(msgs, this.m_viewoldestFirst);
        }
    }

    void setJMSMsgProp(String ps, Message m) {
        try {
            int i = ps.indexOf(61);
            if (i > 0) {
                String p = ps.substring(0, i);
                String v = ps.substring(i + 1);
                if (p.equals("JMSDeliveryMode")) {
                    if (v.startsWith("PERSISTENT")) {
                        m.setJMSDeliveryMode(2);
                    } else if (v.startsWith("NON")) {
                        m.setJMSDeliveryMode(1);
                    } else {
                        m.setJMSDeliveryMode(22);
                    }
                } else if (p.equals("JMSCorrelationID")) {
                    m.setJMSCorrelationID(v);
                } else if (p.equals("JMSType")) {
                    m.setJMSType(v);
                } else if (p.equals("JMSExpiration")) {
                    m.setJMSExpiration(0L);
                } else if (p.equals("JMSPriority")) {
                    m.setJMSPriority(Integer.parseInt(v));
                } else if (Gems.getGems().isJMS2() && p.equals("JMSDeliveryTime")) {
                    m.setJMSDeliveryTime(0L);
                } else if (!(p.equals("JMSMessageID") || p.equals("JMSTimestamp") || p.equals("JMSDestination"))) {
                    System.err.println("Warning: Unsupported JMS property: " + p);
                }
            }
        }
        catch (JMSException ex) {
            System.err.println("JMSException: " + ex.getMessage());
            return;
        }
    }

    void setMsgProp(String p, Message m) {
        try {
            int i = p.indexOf(61);
            if (i > 0 && !p.startsWith("JMSX")) {
                String val = p.substring(i + 1);
                int j = val.indexOf(58);
                if (j > 0) {
                    switch (GemsMsgPropTableModel.getTypeFromString(val.substring(0, j))) {
                        case 9: {
                            m.setStringProperty(p.substring(0, i), val.substring(j + 1));
                            break;
                        }
                        case 5: {
                            m.setIntProperty(p.substring(0, i), Integer.valueOf(val.substring(j + 1)).intValue());
                            break;
                        }
                        case 6: {
                            m.setLongProperty(p.substring(0, i), Long.valueOf(val.substring(j + 1)).longValue());
                            break;
                        }
                        case 1: {
                            m.setBooleanProperty(p.substring(0, i), Boolean.valueOf(val.substring(j + 1)).booleanValue());
                            break;
                        }
                        case 4: {
                            m.setShortProperty(p.substring(0, i), Short.valueOf(val.substring(j + 1)).shortValue());
                            break;
                        }
                        case 2: {
                            m.setByteProperty(p.substring(0, i), Byte.valueOf(val.substring(j + 1)).byteValue());
                            break;
                        }
                        case 8: {
                            m.setDoubleProperty(p.substring(0, i), Double.valueOf(val.substring(j + 1)).doubleValue());
                            break;
                        }
                        case 7: {
                            m.setFloatProperty(p.substring(0, i), Float.valueOf(val.substring(j + 1)).floatValue());
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 18: {
                            System.err.println("Warning: Unsupported header type conversion: " + val.substring(0, j) + " for property: " + p.substring(0, i));
                            break;
                        }
                        default: {
                            m.setStringProperty(p.substring(0, i), val);
                            break;
                        }
                    }
                } else {
                    m.setStringProperty(p.substring(0, i), val);
                }
            }
        }
        catch (JMSException ex) {
            System.err.println("JMSException: " + ex.getMessage());
            return;
        }
    }

    void setMapMsgProp(String p, MapMessage m) {
        try {
            int i = p.indexOf(61);
            if (i > 0) {
                String val = p.substring(i + 1);
                int j = val.indexOf(58);
                if (j > 0) {
                    switch (GemsMsgPropTableModel.getTypeFromString(val.substring(0, j))) {
                        case 9: {
                            m.setString(p.substring(0, i), val.substring(j + 1));
                            break;
                        }
                        case 5: {
                            m.setInt(p.substring(0, i), Integer.valueOf(val.substring(j + 1)).intValue());
                            break;
                        }
                        case 6: {
                            m.setLong(p.substring(0, i), Long.valueOf(val.substring(j + 1)).longValue());
                            break;
                        }
                        case 1: {
                            m.setBoolean(p.substring(0, i), Boolean.valueOf(val.substring(j + 1)).booleanValue());
                            break;
                        }
                        case 4: {
                            m.setShort(p.substring(0, i), Short.valueOf(val.substring(j + 1)).shortValue());
                            break;
                        }
                        case 2: {
                            m.setByte(p.substring(0, i), Byte.valueOf(val.substring(j + 1)).byteValue());
                            break;
                        }
                        case 8: {
                            m.setDouble(p.substring(0, i), Double.valueOf(val.substring(j + 1)).doubleValue());
                            break;
                        }
                        case 7: {
                            m.setFloat(p.substring(0, i), Float.valueOf(val.substring(j + 1)).floatValue());
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 18: {
                            System.err.println("Warning: Unsupported MapMsg type conversion: " + val.substring(0, j) + " for property: " + p.substring(0, i));
                            break;
                        }
                        default: {
                            m.setString(p.substring(0, i), val);
                            break;
                        }
                    }
                } else {
                    m.setString(p.substring(0, i), val);
                }
            } else {
                System.err.println("Warning: Invalid MapMsg field: " + p);
            }
        }
        catch (JMSException ex) {
            System.err.println("JMSException: " + ex.getMessage());
            return;
        }
    }

    @Override
    public void dispose() {
        this.stop();
        try {
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (JMSException e) {
            System.err.println("Exception: " + e.getMessage());
        }
        super.dispose();
    }

    class DumpToFile
    implements ActionListener {
        DumpToFile() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Save Messages To File (appends)");
                int returnVal = chooser.showOpenDialog(GemsMessageSender.this.m_frame);
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    GemsMessageSender.this.m_tableModel.dumpMsgsToFile(f, GemsMessageSender.this.m_viewoldestFirst);
                }
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(GemsMessageSender.this.m_frame, ie.getMessage(), "Error", 1);
                return;
            }
        }
    }

    class LoadMessagesAction
    implements ActionListener {
        LoadMessagesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser(new File("."));
            chooser.setDialogTitle("Load Messages From File");
            int returnVal = chooser.showOpenDialog(GemsMessageSender.this.m_frame);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                GemsMessageSender.this.loadMessages(f);
            }
        }
    }

    class SelectAllAction
    implements ActionListener {
        SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageSender.this.m_tableModel.selectAllRows();
        }
    }

    class EditOptionsAction
    implements ActionListener {
        EditOptionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new GemsBrowserOptionsDialog(GemsMessageSender.this.m_frame, "Edit Options", false, false, false);
            GemsMessageSender.this.m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
        }
    }

    class DestinationWizardAction
    implements ActionListener {
        DestinationWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsMessageSender.this.m_frame, GemsMessageSender.this.m_cn, GemsMessageSender.this.m_isQueue ? GemsDestination.DEST_TYPE.Queue : GemsDestination.DEST_TYPE.Topic);
            if (dp.m_retDest != null) {
                GemsMessageSender.this.m_dest.setText(dp.m_retDest.m_destName);
            }
        }
    }

    class StopPressed
    implements ActionListener {
        StopPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageSender.this.stop();
        }
    }

    class StartPressed
    implements ActionListener {
        StartPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsMessageSender.this.start();
        }
    }

    class RefreshTimerAction
    implements ActionListener {
        RefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsMessageSender.this.m_running && GemsMessageSender.this.m_msgCount < GemsMessageSender.this.m_rows.size()) {
                try {
                    Message msg;
                    int row = GemsMessageSender.this.m_msgCount;
                    if (!GemsMessageSender.this.m_viewoldestFirst) {
                        row = GemsMessageSender.this.m_rows.size() - GemsMessageSender.this.m_msgCount - 1;
                    }
                    if ((msg = (Message)GemsMessageSender.this.m_msgs.get((String)GemsMessageSender.this.m_rows.elementAt(row))) != null) {
                        GemsMessageSender.this.m_producer.send(msg, msg.getJMSDeliveryMode(), msg.getJMSPriority(), msg.getJMSExpiration());
                        GemsMessageSender.this.m_tableModel.addMessage(msg, GemsMessageSender.this.m_viewoldestFirst);
                    }
                    ++GemsMessageSender.this.m_msgCount;
                }
                catch (JMSException ex) {
                    JOptionPane.showMessageDialog(GemsMessageSender.this.m_frame, ex.getMessage(), "Error", 1);
                    GemsMessageSender.this.stop();
                }
            } else {
                GemsMessageSender.this.stop();
            }
        }
    }
}

