/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsCellValue;
import com.tibco.gems.GemsCheckboxRenderer;
import com.tibco.gems.GemsMsgPropTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.GetPopupHandler;
import com.tibco.gems.PopupHandler;
import com.tibco.gems.PopupMsgTableHandler;
import com.tibco.tibjms.Tibjms;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class GemsMessageTableModel
extends DefaultTableModel
implements GetPopupHandler {
    JTable m_table;
    Hashtable m_msgs = new Hashtable();
    boolean m_isEditable;
    public boolean m_showCheckbox = false;
    static long s_msgId = 0L;
    Object m_obj = new Object();
    PopupHandler m_popup = null;
    MyRenderer m_renderer = null;
    GemsCheckboxRenderer m_checkRenderer = new GemsCheckboxRenderer();
    SimpleDateFormat dateFormatMillis = new SimpleDateFormat("EEE MMM dd HH:mm:ss SSS zzz yyyy");

    public GemsMessageTableModel(boolean editable, boolean showCheckbox) {
        this.m_isEditable = editable;
        this.m_showCheckbox = showCheckbox;
        this.m_renderer = new MyRenderer();
    }

    @Override
    public PopupHandler getPopupHandler() {
        if (this.m_popup == null) {
            this.m_popup = new PopupMsgTableHandler(this.m_table, this);
        }
        return this.m_popup;
    }

    public Class getColumnClass(int columnIndex) {
        Object o = this.getValueAt(0, columnIndex);
        if (o != null) {
            if (o instanceof GemsCellValue) {
                return new String().getClass();
            }
            return o.getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.m_showCheckbox && col < 1) {
            return true;
        }
        return this.m_isEditable;
    }

    public Message getSelectedMessage() {
        if (this.m_msgs == null) {
            return null;
        }
        if (this.m_table.getSelectedRow() < 0) {
            return null;
        }
        if (this.m_showCheckbox) {
            return (Message)this.m_msgs.get((String)this.m_table.getValueAt(this.m_table.getSelectedRow(), 1));
        }
        return (Message)this.m_msgs.get((String)this.m_table.getValueAt(this.m_table.getSelectedRow(), 0));
    }

    public Message getMessageAt(int row) {
        if (this.m_msgs == null) {
            return null;
        }
        if (this.m_showCheckbox) {
            return (Message)this.m_msgs.get((String)this.m_table.getValueAt(row, 1));
        }
        return (Message)this.m_msgs.get((String)this.m_table.getValueAt(row, 0));
    }

    public Vector getSelectedMessages() {
        Vector v = new Vector();
        if (this.m_showCheckbox) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!((Boolean)this.m_table.getValueAt(i, 0)).booleanValue()) continue;
                v.add(this.m_msgs.get((String)this.m_table.getValueAt(i, 1)));
            }
        }
        return v;
    }

    public void removeSelectedMessages() {
        if (this.m_showCheckbox) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!((Boolean)this.m_table.getValueAt(i, 0)).booleanValue()) continue;
                this.m_msgs.remove((String)this.m_table.getValueAt(i, 1));
                this.removeRow(i);
                --i;
            }
        }
    }

    public void selectAllRows() {
        if (this.m_showCheckbox) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.m_table.setValueAt(new Boolean(true), i, 0);
            }
        }
    }

    public void toggleSelectedRow() {
        if (this.m_showCheckbox) {
            this.m_table.setValueAt(new Boolean((Boolean)this.m_table.getValueAt(this.m_table.getSelectedRow(), 0) == false), this.m_table.getSelectedRow(), 0);
        }
    }

    public void buildColumnHeaders() {
        this.setRowCount(0);
        this.setColumnCount(0);
        this.m_msgs.clear();
        this.m_table.setAutoResizeMode(0);
        this.m_table.setDefaultRenderer(Object.class, this.m_renderer);
        this.m_table.setDefaultRenderer(String.class, this.m_renderer);
        this.m_table.setDefaultRenderer(Date.class, this.m_renderer);
        this.m_table.setDefaultRenderer(Boolean.class, this.m_checkRenderer);
        Object[] cols = this.m_showCheckbox ? new String[]{"Sel", "MessageID", "Timestamp", "Type", "MsgSize", "Destination", "DeliveryMode", "DeliveryTime", "CorrelationID"} : new String[]{"MessageID", "Timestamp", "Type", "MsgSize", "Destination", "DeliveryMode", "DeliveryTime", "CorrelationID"};
        this.setColumnIdentifiers(cols);
        if (this.m_showCheckbox) {
            this.m_table.getColumn("Sel").setPreferredWidth(30);
        }
        this.m_table.getColumn("MessageID").setPreferredWidth(220);
        this.m_table.getColumn("Destination").setPreferredWidth(150);
        this.m_table.getColumn("DeliveryMode").setPreferredWidth(100);
        this.m_table.getColumn("CorrelationID").setPreferredWidth(100);
        this.m_table.getColumn("Timestamp").setPreferredWidth(200);
        this.m_table.getColumn("DeliveryTime").setPreferredWidth(200);
    }

    public void updateSelectedMessage(Message m) {
        try {
            String dm;
            int s = this.m_table.getSelectedRow();
            if (m.getJMSMessageID() == null) {
                m.setJMSMessageID("tmpId" + String.valueOf(++s_msgId));
                String type = m.getJMSType();
                if (type == null || type.length() == 0) {
                    type = m instanceof TextMessage ? "[Text]" : (m instanceof MapMessage ? "[Map]" : (m instanceof BytesMessage ? "[Bytes]" : (m instanceof StreamMessage ? "[Stream]" : (m instanceof ObjectMessage ? "[Object]" : ""))));
                }
                if (this.m_showCheckbox) {
                    this.m_msgs.remove(this.getValueAt(s, 1));
                    this.setValueAt(m.getJMSMessageID(), s, 1);
                    this.setValueAt(type, s, 3);
                    this.setValueAt("", s, 5);
                } else {
                    this.m_msgs.remove(this.getValueAt(s, 0));
                    this.setValueAt(m.getJMSMessageID(), s, 0);
                    this.setValueAt(type, s, 2);
                    this.setValueAt("", s, 4);
                }
            }
            this.m_msgs.put(m.getJMSMessageID(), m);
            String string = m.getJMSDeliveryMode() == 2 ? "PERSISTENT" : (dm = m.getJMSDeliveryMode() == 1 ? "NON_PERSISTENT" : "RELIABLE");
            if (this.m_showCheckbox) {
                this.setValueAt(dm, s, 6);
                this.setValueAt(m.getJMSCorrelationID(), s, 8);
            } else {
                this.setValueAt(dm, s, 5);
                this.setValueAt(m.getJMSCorrelationID(), s, 7);
            }
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void addMessage(Message m, boolean oldestFirst) {
        this.addMessage(m, oldestFirst, 0);
    }

    public void addMessage(Message m, boolean oldestFirst, int index) {
        Date d = new Date();
        Date d1 = null;
        try {
            if (m != null) {
                if (m.getJMSMessageID() == null) {
                    m.setJMSMessageID("tmpId" + String.valueOf(++s_msgId));
                }
                this.m_msgs.put(m.getJMSMessageID(), m);
                String dm = m.getJMSDeliveryMode() == 2 ? "PERSISTENT" : (m.getJMSDeliveryMode() == 1 ? "NON_PERSISTENT" : "RELIABLE");
                String type = m.getJMSType();
                if (type == null || type.length() == 0) {
                    type = m instanceof TextMessage ? "[Text]" : (m instanceof MapMessage ? "[Map]" : (m instanceof BytesMessage ? "[Bytes]" : (m instanceof StreamMessage ? "[Stream]" : (m instanceof ObjectMessage ? "[Object]" : ""))));
                }
                d.setTime(m.getJMSTimestamp());
                if (Gems.getGems().isJMS2() && m.getJMSDeliveryTime() != 0L) {
                    d1 = new Date();
                    d1.setTime(m.getJMSDeliveryTime());
                }
                String dest = new String();
                if (m.getJMSDestination() != null) {
                    dest = m.getJMSDestination().toString();
                }
                Object[] r = this.m_showCheckbox ? new Object[]{new Boolean(false), m.getJMSMessageID(), d, type, new GemsCellValue(GemsUtilities.getHumanReadableSize(Tibjms.getMessageSize((Message)m)), Tibjms.getMessageSize((Message)m)), dest, dm, d1, m.getJMSCorrelationID()} : new Object[]{m.getJMSMessageID(), d, type, new GemsCellValue(GemsUtilities.getHumanReadableSize(Tibjms.getMessageSize((Message)m)), Tibjms.getMessageSize((Message)m)), dest, dm, d1, m.getJMSCorrelationID()};
                if (oldestFirst) {
                    this.addRow(r);
                } else {
                    if (index < 0 || index >= this.getRowCount()) {
                        index = 0;
                    }
                    this.insertRow(index, r);
                }
            } else {
                System.err.println("Empty message!");
            }
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateMessageInfo(Vector msgs, boolean oldestFirst) {
        if (msgs == null) {
            return;
        }
        this.buildColumnHeaders();
        for (int i = 0; i < msgs.size(); ++i) {
            Message m = (Message)msgs.elementAt(i);
            this.addMessage(m, oldestFirst);
        }
    }

    public void populateMessageInfo(Vector msgs) {
        if (msgs == null) {
            return;
        }
        boolean oldestFirst = Gems.getGems().getViewOldMessagesFirst();
        this.populateMessageInfo(msgs, oldestFirst);
    }

    public String getToolTip() {
        if (this.m_showCheckbox) {
            return "Double-click to display message, select checkbox for messages to copy or destroy";
        }
        return "Double-click to display message";
    }

    void dumpMsgsToFile(File f, boolean oldestfirst) throws IOException {
        FileOutputStream fout = new FileOutputStream(f, true);
        PrintStream p = new PrintStream(fout);
        for (int r = 0; r < this.m_table.getRowCount(); ++r) {
            int row = r;
            if (!oldestfirst) {
                row = this.m_table.getRowCount() - r - 1;
            }
            String id = this.m_showCheckbox ? (String)this.getValueAt(row, 1) : (String)this.getValueAt(row, 0);
            this.writeMessage((Message)this.m_msgs.get(id), p);
        }
        p.close();
    }

    void writeMessage(Message msg, PrintStream p) {
        if (msg == null) {
            return;
        }
        try {
            p.println("$MsgStart$");
            p.println("$MsgHeader$");
            p.println("JMSMessageID=" + msg.getJMSMessageID());
            Date d = new Date();
            d.setTime(msg.getJMSTimestamp());
            p.println("JMSTimestamp=" + this.dateFormatMillis.format(d).toString());
            p.println("JMSDestination=" + msg.getJMSDestination());
            String dm = msg.getJMSDeliveryMode() == 2 ? "PERSISTENT" : (msg.getJMSDeliveryMode() == 1 ? "NON_PERSISTENT" : "RELIABLE");
            p.println("JMSDeliveryMode=" + dm);
            if (msg.getJMSCorrelationID() != null) {
                p.println("JMSCorrelationID=" + msg.getJMSCorrelationID());
            }
            if (msg.getJMSType() != null) {
                p.println("JMSType=" + msg.getJMSType());
            }
            if (msg.getJMSReplyTo() != null) {
                p.println("JMSReplyTo=" + msg.getJMSReplyTo());
            }
            if (msg.getJMSExpiration() > 0L) {
                d.setTime(msg.getJMSExpiration());
                p.println("JMSExpiration=" + d.toString());
            }
            if (Gems.getGems().isJMS2() && msg.getJMSDeliveryTime() != 0L) {
                d.setTime(msg.getJMSDeliveryTime());
                p.println("JMSDeliveryTime=" + this.dateFormatMillis.format(d).toString());
            }
            p.println("$MsgProperties$");
            Enumeration props = msg.getPropertyNames();
            while (props.hasMoreElements()) {
                String ps = (String)props.nextElement();
                p.println(ps + "=" + GemsMsgPropTableModel.toTypedString(null, msg.getObjectProperty(ps)));
            }
            if (msg instanceof TextMessage) {
                p.println("$MsgTextBody$");
                TextMessage textMsg = (TextMessage)msg;
                p.println(textMsg.getText());
            } else if (msg instanceof MapMessage) {
                MapMessage innerMapMsg = (MapMessage)msg;
                p.println("$MsgMapBody$");
                Enumeration pops = innerMapMsg.getMapNames();
                while (pops.hasMoreElements()) {
                    String pn = (String)pops.nextElement();
                    p.println(pn + "=" + GemsMsgPropTableModel.toTypedString(null, innerMapMsg.getObject(pn)));
                }
            } else if (msg instanceof BytesMessage) {
                p.println("$MsgBytesBody$");
                BytesMessage bytesMsg = (BytesMessage)msg;
                bytesMsg.reset();
                long s = bytesMsg.getBodyLength();
                byte[] b = new byte[(int)s];
                bytesMsg.readBytes(b, (int)s);
                p.println(GemsUtilities.dumpBytes(b));
            } else if (msg instanceof StreamMessage) {
                p.println("$MsgStreamBody$");
                StreamMessage streamMsg = (StreamMessage)msg;
                p.println(streamMsg.toString());
            } else if (msg instanceof ObjectMessage) {
                p.println("$MsgObjectBody$");
                ObjectMessage objectMsg = (ObjectMessage)msg;
                p.println(objectMsg.toString());
            }
            p.println("$MsgEnd$");
            p.println("");
        }
        catch (JMSException ex) {
            System.err.println("JMSException: " + ex.getMessage());
            return;
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        public MyRenderer() {
            this.setToolTipText(GemsMessageTableModel.this.getToolTip());
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Date) {
                this.setText(value == null ? "" : GemsMessageTableModel.this.dateFormatMillis.format(value).toString());
            } else {
                super.setValue(value);
            }
        }
    }
}

