/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsUtilities;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.swing.JTextArea;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class GemsMessageText
extends JTextArea {
    public static final int MODE_NONE = 0;
    public static final int MODE_HEXBYTES = 1;
    public static final int MODE_ASCIIBYTES = 2;
    public static final int MODE_TEXT = 3;
    public static final int MODE_XML = 4;
    protected int m_mode = 0;
    protected Message m_msg = null;
    protected JTextArea m_text = null;

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int mode) {
        if (this.m_msg == null) {
            return;
        }
        try {
            if (this.m_msg instanceof BytesMessage) {
                if (mode == 1) {
                    BytesMessage bytesMsg = (BytesMessage)this.m_msg;
                    bytesMsg.reset();
                    long s = bytesMsg.getBodyLength();
                    if (s > (long)Gems.getGems().getMaxDisplayBytes()) {
                        System.err.println("Warning: Bytes message display limited to " + Gems.getGems().getMaxDisplayBytes() + " bytes (configurable in gems.props)");
                        s = Gems.getGems().getMaxDisplayBytes();
                    }
                    byte[] b = new byte[(int)s];
                    bytesMsg.readBytes(b, (int)s);
                    this.setText(GemsUtilities.dumpBytes(b));
                    this.m_mode = 1;
                } else if (mode == 2) {
                    BytesMessage bytesMsg = (BytesMessage)this.m_msg;
                    bytesMsg.reset();
                    long s = bytesMsg.getBodyLength();
                    if (s > (long)Gems.getGems().getMaxDisplayBytes()) {
                        System.err.println("Warning: Bytes message display limited to " + Gems.getGems().getMaxDisplayBytes() + " bytes (configurable in gems.props)");
                        s = Gems.getGems().getMaxDisplayBytes();
                    }
                    byte[] b = new byte[(int)s];
                    bytesMsg.readBytes(b, (int)s);
                    this.setText(new String(b));
                    this.m_mode = 2;
                }
            } else if (this.m_msg instanceof TextMessage) {
                TextMessage textMsg = (TextMessage)this.m_msg;
                if (mode == 3) {
                    this.setText(textMsg.getText());
                    this.m_mode = 3;
                } else if (mode == 4) {
                    try {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document doc = db.parse(new InputSource(new StringReader(textMsg.getText())));
                        TransformerFactory tfactory = TransformerFactory.newInstance();
                        Transformer serializer = tfactory.newTransformer();
                        serializer.setOutputProperty("indent", "yes");
                        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        serializer.transform(new DOMSource(doc), new StreamResult(out));
                        this.setText(out.toString());
                        this.m_mode = 4;
                    }
                    catch (Exception e) {
                        System.err.println("Exception: " + e.getMessage());
                        this.setText(textMsg.getText());
                        this.m_mode = 3;
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            return;
        }
    }

    public void setMessageText(Message m) {
        this.m_msg = m;
        this.m_mode = 0;
        try {
            if (m instanceof TextMessage) {
                TextMessage textMsg = (TextMessage)m;
                this.setText(textMsg.getText());
                this.m_mode = 3;
            } else if (m instanceof MapMessage) {
                MapMessage innerMapMsg = (MapMessage)m;
                this.setText(innerMapMsg.toString());
            } else if (m instanceof BytesMessage) {
                BytesMessage bytesMsg = (BytesMessage)m;
                bytesMsg.reset();
                long s = bytesMsg.getBodyLength();
                if (s > (long)Gems.getGems().getMaxDisplayBytes()) {
                    System.err.println("Warning: Bytes message display limited to " + Gems.getGems().getMaxDisplayBytes() + " bytes (configurable in gems.props)");
                    s = Gems.getGems().getMaxDisplayBytes();
                }
                byte[] b = new byte[(int)s];
                bytesMsg.readBytes(b, (int)s);
                this.setText(GemsUtilities.dumpBytes(b));
                this.m_mode = 1;
            } else if (m instanceof StreamMessage) {
                StreamMessage streamMsg = (StreamMessage)m;
                this.setText(streamMsg.toString());
            } else if (m instanceof ObjectMessage) {
                ObjectMessage objectMsg = (ObjectMessage)m;
                this.setText(objectMsg.toString());
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            return;
        }
    }
}

