/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsMessageTableModel;
import com.tibco.gems.GemsUtilities;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;

public class GemsMonitorDestMessageTableModel
extends GemsMessageTableModel {
    Hashtable m_timestamps = null;

    public GemsMonitorDestMessageTableModel(boolean editable, boolean showCheckbox) {
        super(editable, showCheckbox);
    }

    public int noOfMonitoredMsgs() {
        return this.m_timestamps.size();
    }

    @Override
    public void buildColumnHeaders() {
        Object ot = null;
        this.setRowCount(0);
        this.setColumnCount(0);
        this.m_msgs.clear();
        if (this.m_timestamps == null) {
            this.m_timestamps = new Hashtable();
        }
        this.m_timestamps.clear();
        this.m_table.setAutoResizeMode(0);
        this.m_table.setDefaultRenderer(this.m_obj.getClass(), this.m_renderer);
        this.m_table.setDefaultRenderer(Date.class, this.m_renderer);
        Object[] cols = new String[]{"MonitorEventID", "EventTimestamp", "JMSMessageID", "MsgTimestamp", "EventAction", "Latency(ms)", "EventReason", "ConnHostname", "ConnUsername", "TargetDestination", "JMSMessageSize"};
        this.setColumnIdentifiers(cols);
        this.m_table.getColumn("MonitorEventID").setPreferredWidth(100);
        this.m_table.getColumn("JMSMessageID").setPreferredWidth(220);
        this.m_table.getColumn("TargetDestination").setPreferredWidth(200);
        this.m_table.getColumn("Latency(ms)").setPreferredWidth(80);
        this.m_table.getColumn("ConnHostname").setPreferredWidth(110);
        this.m_table.getColumn("ConnUsername").setPreferredWidth(100);
        this.m_table.getColumn("JMSMessageSize").setPreferredWidth(100);
        this.m_table.getColumn("EventAction").setPreferredWidth(80);
        this.m_table.getColumn("EventReason").setPreferredWidth(90);
        this.m_table.getColumn("EventTimestamp").setPreferredWidth(180);
        this.m_table.getColumn("MsgTimestamp").setPreferredWidth(180);
    }

    @Override
    public void addMessage(Message m, boolean oldestFirst) {
        Date d = new Date();
        Date dm = new Date();
        byte[] bytes = null;
        try {
            if (m == null) {
                System.err.println("GemsDestMonitor: Empty message!");
                return;
            }
            if (m instanceof MapMessage && ((MapMessage)m).itemExists("message_bytes")) {
                bytes = ((MapMessage)m).getBytes("message_bytes");
            }
            if (m.getJMSMessageID() == null) {
                m.setJMSMessageID("tmpId" + String.valueOf(++s_msgId));
            }
            String msgid = m.getStringProperty("msg_id");
            String event = m.getStringProperty("event_action");
            if (msgid == null) {
                System.err.println("GemsDestMonitor: missing msg_id from monitor message!");
                return;
            }
            if (event == null) {
                System.err.println("GemsDestMonitor: missing event_action from monitor message!");
                return;
            }
            this.m_msgs.put(m.getJMSMessageID(), m);
            Long ot = (Long)this.m_timestamps.get(msgid);
            if (ot == null) {
                this.m_timestamps.put(msgid, m.getJMSTimestamp());
            }
            d.setTime(m.getJMSTimestamp());
            dm.setTime(m.getLongProperty("msg_timestamp"));
            Long lat = new Long(0L);
            if (ot != null) {
                lat = m.getJMSTimestamp() - ot;
            }
            Object[] r = new Object[]{m.getJMSMessageID(), d, msgid, dm, m.getStringProperty("event_action"), lat, m.getStringProperty("event_reason"), m.getStringProperty("conn_hostname"), m.getStringProperty("conn_username"), m.getStringProperty("target_dest_name"), bytes != null ? GemsUtilities.getHumanReadableSize(bytes.length) : ""};
            if (oldestFirst) {
                this.addRow(r);
            } else {
                this.insertRow(0, r);
            }
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }
}

