/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsMessageTableModel;
import java.util.Date;
import javax.jms.JMSException;
import javax.jms.Message;

public class GemsMonitorMessageTableModel
extends GemsMessageTableModel {
    public GemsMonitorMessageTableModel(boolean editable, boolean showCheckbox) {
        super(editable, showCheckbox);
    }

    @Override
    public void buildColumnHeaders() {
        this.setRowCount(0);
        this.setColumnCount(0);
        this.m_msgs.clear();
        this.m_table.setAutoResizeMode(0);
        this.m_table.setDefaultRenderer(this.m_obj.getClass(), this.m_renderer);
        this.m_table.setDefaultRenderer(Date.class, this.m_renderer);
        Object[] cols = new String[]{"MonitorEventID", "Timestamp", "EventAction", "EventReason", "ConnHostname", "ConnUsername"};
        this.setColumnIdentifiers(cols);
        this.m_table.getColumn("MonitorEventID").setPreferredWidth(100);
        this.m_table.getColumn("ConnHostname").setPreferredWidth(120);
        this.m_table.getColumn("ConnUsername").setPreferredWidth(120);
        this.m_table.getColumn("EventAction").setPreferredWidth(90);
        this.m_table.getColumn("EventReason").setPreferredWidth(90);
        this.m_table.getColumn("Timestamp").setPreferredWidth(180);
    }

    @Override
    public void addMessage(Message m, boolean oldestFirst) {
        Date d = new Date();
        try {
            if (m != null) {
                if (m.getJMSMessageID() == null) {
                    m.setJMSMessageID("tmpId" + String.valueOf(++s_msgId));
                }
                this.m_msgs.put(m.getJMSMessageID(), m);
                d.setTime(m.getJMSTimestamp());
                Object[] r = new Object[]{m.getJMSMessageID(), d, m.getStringProperty("event_action"), m.getStringProperty("event_reason"), m.getStringProperty("conn_hostname"), m.getStringProperty("conn_username")};
                if (oldestFirst) {
                    this.addRow(r);
                } else {
                    this.insertRow(0, r);
                }
            } else {
                System.err.println("Empty message!");
            }
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }
}

