/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsPropertyTableModel;
import com.tibco.gems.GetPopupHandler;
import com.tibco.gems.PopupHandler;
import com.tibco.gems.PopupMsgPropTableHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.StreamMessage;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class GemsMsgPropTableModel
extends GemsPropertyTableModel
implements GetPopupHandler {
    boolean m_isMapMsg = false;
    boolean m_hasSubMapMsg = false;
    int s_headerRows = 6;
    SimpleDateFormat dateFormatMillis = new SimpleDateFormat("EEE MMM dd HH:mm:ss SSS zzz yyyy");

    public GemsMsgPropTableModel(boolean editable) {
        super(editable);
        if (!Gems.getGems().getShowExtendedProperties()) {
            this.s_headerRows -= 3;
        }
        if (Gems.getGems().isJMS2() && Gems.getGems().getShowExtendedProperties()) {
            ++this.s_headerRows;
        }
    }

    public GemsMsgPropTableModel(boolean editable, boolean isMap) {
        super(editable);
        this.s_headerRows = 0;
        this.m_isMapMsg = isMap;
    }

    @Override
    public PopupHandler getPopupHandler() {
        if (this.m_popup == null) {
            this.m_popup = new PopupMsgPropTableHandler(this.m_table);
        }
        return this.m_popup;
    }

    @Override
    public String getToolTip() {
        if (Gems.getGems().isJMS2()) {
            return "Double-click to set value. For Expiration/DeliveryTime set a TTL/delay in millisecs.";
        }
        return "Double-click to set value. For Expiration set a TTL in millisecs.";
    }

    public int getHeaderRows() {
        return this.s_headerRows;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.m_isEditable) {
            return row >= this.s_headerRows || col != 0;
        }
        return false;
    }

    public boolean hasSubMapMsg() {
        return this.m_hasSubMapMsg;
    }

    public boolean isMapMsg() {
        return this.m_isMapMsg;
    }

    public void populateMapMsg(MapMessage m) {
        this.m_isMapMsg = true;
        this.setRowCount(0);
        this.setColumnCount(0);
        if (m == null) {
            return;
        }
        this.addColumn("Field");
        this.addColumn("Value");
        if (this.m_isEditable) {
            TableColumn tc = this.m_table.getColumn("Value");
            tc.setCellEditor(new MultiEditor());
            tc.setCellRenderer(new GemsPropertyTableModel.MultiRenderer(this));
        }
        try {
            Enumeration props = m.getMapNames();
            while (props.hasMoreElements()) {
                String p = (String)props.nextElement();
                Object[] r = this.m_isEditable ? new Object[]{p, m.getObject(p)} : new String[]{p, GemsMsgPropTableModel.toTypedString(this, m.getObject(p))};
                this.addRow(r);
            }
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    static int getTypeFromString(String s) {
        if (s.equals("String")) {
            return 9;
        }
        if (s.equals("Integer")) {
            return 5;
        }
        if (s.equals("Long")) {
            return 6;
        }
        if (s.equals("Boolean")) {
            return 1;
        }
        if (s.equals("Short")) {
            return 4;
        }
        if (s.equals("Byte")) {
            return 2;
        }
        if (s.equals("Double")) {
            return 8;
        }
        if (s.equals("Float")) {
            return 7;
        }
        if (s.equals("byte[]")) {
            return 10;
        }
        if (s.equals("MapMag")) {
            return 11;
        }
        if (s.equals("StreamMsg")) {
            return 18;
        }
        if (s.equals("short-array")) {
            return 12;
        }
        if (s.equals("int-array")) {
            return 13;
        }
        if (s.equals("long-array")) {
            return 14;
        }
        if (s.equals("float-array")) {
            return 15;
        }
        if (s.equals("double-array")) {
            return 16;
        }
        return 255;
    }

    static int getPropType(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return 9;
        }
        if (obj instanceof Integer) {
            return 5;
        }
        if (obj instanceof Long) {
            return 6;
        }
        if (obj instanceof Boolean) {
            return 1;
        }
        if (obj instanceof Short) {
            return 4;
        }
        if (obj instanceof Byte) {
            return 2;
        }
        if (obj instanceof Double) {
            return 8;
        }
        return !(obj instanceof Float) ? 255 : 7;
    }

    static int getFieldType(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return 9;
        }
        if (obj instanceof Integer) {
            return 5;
        }
        if (obj instanceof Long) {
            return 6;
        }
        if (obj instanceof Boolean) {
            return 1;
        }
        if (obj instanceof Short) {
            return 4;
        }
        if (obj instanceof Double) {
            return 8;
        }
        if (obj instanceof byte[]) {
            return 10;
        }
        if (obj instanceof Byte) {
            return 2;
        }
        if (obj instanceof Float) {
            return 7;
        }
        return !(obj instanceof Character) ? 255 : 3;
    }

    static int getExtendedType(Object obj) {
        if (obj == null) {
            return 255;
        }
        if (obj instanceof MapMessage) {
            return 11;
        }
        if (obj instanceof StreamMessage) {
            return 18;
        }
        if (obj instanceof short[]) {
            return 12;
        }
        if (obj instanceof int[]) {
            return 13;
        }
        if (obj instanceof long[]) {
            return 14;
        }
        if (obj instanceof float[]) {
            return 15;
        }
        return !(obj instanceof double[]) ? 255 : 16;
    }

    static String getTypeName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof byte[]) {
            return "byte[]";
        }
        String s = obj.getClass().getName();
        if (s.length() < 1) {
            return s;
        }
        int i = s.lastIndexOf(46, s.length() - 1);
        if (i >= 0 && i < s.length() - 1) {
            s = s.substring(i + 1, s.length());
        }
        return s;
    }

    static String toTypedString(GemsMsgPropTableModel me, Object obj) {
        if (obj == null) {
            return null;
        }
        String s = "";
        String s2 = "";
        int i = GemsMsgPropTableModel.getFieldType(obj);
        if (i != 255) {
            s2 = GemsMsgPropTableModel.getTypeName(obj);
        } else {
            i = GemsMsgPropTableModel.getExtendedType(obj);
        }
        switch (i) {
            case 10: {
                byte[] abyte0 = (byte[])obj;
                String s1 = String.valueOf(abyte0.length) + " bytes";
                return s2 + ":" + s1;
            }
            case 11: {
                if (me != null) {
                    me.m_hasSubMapMsg = true;
                }
                return "MapMsg:{" + ((MapMessage)obj).toString() + " }";
            }
            case 18: {
                return "StreamMsg:{" + ((StreamMessage)obj).toString() + " }";
            }
            case 12: {
                return "short-array:[" + ((short[])obj).length + " elements]";
            }
            case 13: {
                return "int-array:[" + ((int[])obj).length + " elements]";
            }
            case 14: {
                return "long-array:[" + ((long[])obj).length + " elements]";
            }
            case 15: {
                return "float-array:[" + ((float[])obj).length + " elements]";
            }
            case 16: {
                return "double-array:[" + ((double[])obj).length + " elements]";
            }
            case 255: {
                return "<unknown type>";
            }
        }
        return s2 + ":" + obj.toString();
    }

    public void populatePropertyInfo(Message m) {
        this.setRowCount(0);
        this.setColumnCount(0);
        if (m == null) {
            return;
        }
        this.addColumn("Property");
        this.addColumn("Value");
        if (this.m_isEditable) {
            TableColumn tc = this.m_table.getColumn("Value");
            tc.setCellEditor(new MultiEditor());
            tc.setCellRenderer(new GemsPropertyTableModel.MultiRenderer(this));
        }
        try {
            boolean b;
            String tp;
            String CID;
            Object dm;
            Object[] r;
            Date d = new Date();
            String ID = m.getJMSMessageID();
            if (ID != null && ID.length() > 0) {
                r = new String[]{"JMSMessageID", ID};
                this.addRow(r);
            }
            d.setTime(m.getJMSTimestamp());
            Gems.debug("JMSTimestamp: " + m.getJMSTimestamp());
            r = new String[]{"JMSTimestamp", this.dateFormatMillis.format(d).toString()};
            this.addRow(r);
            if (this.m_isEditable) {
                dm = m.getJMSDeliveryMode() == 2 ? DELMODE.PERSISTENT : (m.getJMSDeliveryMode() == 1 ? DELMODE.NON_PERSISTENT : DELMODE.RELIABLE);
                r = new Object[]{"JMSDeliveryMode", dm};
                this.addRow(r);
            } else {
                dm = m.getJMSDeliveryMode() == 2 ? "PERSISTENT" : (m.getJMSDeliveryMode() == 1 ? "NON_PERSISTENT" : "RELIABLE");
                r = new String[]{"JMSDeliveryMode", dm};
                this.addRow(r);
            }
            Destination des = m.getJMSDestination();
            if (des != null) {
                r = new String[]{"JMSDestination", des.toString()};
                this.addRow(r);
            }
            if ((CID = m.getJMSCorrelationID()) != null && CID.length() > 0) {
                r = new String[]{"JMSCorrelationID", CID};
                this.addRow(r);
            }
            if ((tp = m.getJMSType()) != null && tp.length() > 0) {
                r = new String[]{"JMSType", tp};
                this.addRow(r);
            }
            if (b = m.getJMSRedelivered()) {
                r = new String[]{"JMSRedelivered", "true"};
                this.addRow(r);
            }
            if (Gems.getGems().getShowExtendedProperties()) {
                if (this.m_isEditable) {
                    r = new String[]{"JMSExpiration", "0"};
                    this.addRow(r);
                } else if (m.getJMSExpiration() != 0L) {
                    d.setTime(m.getJMSExpiration());
                    r = new String[]{"JMSExpiration", this.dateFormatMillis.format(d).toString()};
                    this.addRow(r);
                }
                r = new String[]{"JMSPriority", String.valueOf(m.getJMSPriority())};
                this.addRow(r);
                if (m.getJMSReplyTo() != null) {
                    r = new String[]{"JMSReplyTo", m.getJMSReplyTo().toString()};
                    this.addRow(r);
                }
                if (Gems.getGems().isJMS2() && this.m_isEditable) {
                    r = new String[]{"JMSDeliveryTime", "0"};
                    this.addRow(r);
                } else if (Gems.getGems().isJMS2() && m.getJMSDeliveryTime() != 0L) {
                    d.setTime(m.getJMSDeliveryTime());
                    r = new String[]{"JMSDeliveryTime", this.dateFormatMillis.format(d).toString()};
                    this.addRow(r);
                }
            }
            if (this.m_isEditable) {
                this.s_headerRows = this.getRowCount();
            }
            Enumeration props = m.getPropertyNames();
            while (props.hasMoreElements()) {
                String p = (String)props.nextElement();
                if (p.equals("msg_timestamp")) {
                    d.setTime(m.getLongProperty("msg_timestamp"));
                    r = new String[]{"msg_timestamp", this.dateFormatMillis.format(d).toString()};
                    Gems.debug("msg_timestamp: " + m.getLongProperty("msg_timestamp"));
                } else {
                    r = new Object[]{p, m.getObjectProperty(p)};
                }
                this.addRow(r);
            }
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void populateEmptyPropertyInfo(int rows) {
        this.setRowCount(0);
        this.setColumnCount(0);
        if (this.m_isMapMsg) {
            this.addColumn("Field");
        } else {
            this.addColumn("Property");
        }
        this.addColumn("Value");
        TableColumn tc = this.m_table.getColumn("Value");
        tc.setCellEditor(new MultiEditor());
        tc.setCellRenderer(new GemsPropertyTableModel.MultiRenderer(this));
        for (int i = 0; i < rows; ++i) {
            Object[] r = new String[]{new String(), new String()};
            this.addRow(r);
        }
    }

    public void emptyEditorPropertyInfo(String dest) {
        this.setRowCount(0);
        this.setColumnCount(0);
        this.addColumn("Property");
        this.addColumn("Value");
        TableColumn tc = this.m_table.getColumn("Value");
        tc.setCellEditor(new MultiEditor());
        tc.setCellRenderer(new GemsPropertyTableModel.MultiRenderer(this));
        Object[] r = new Object[]{"JMSDeliveryMode", DELMODE.NON_PERSISTENT};
        this.addRow(r);
        r = new String[]{"JMSType", ""};
        this.addRow(r);
        if (Gems.getGems().getShowExtendedProperties()) {
            r = new String[]{"JMSExpiration", "0"};
            this.addRow(r);
            r = new String[]{"JMSPriority", "4"};
            this.addRow(r);
            if (Gems.getGems().isJMS2()) {
                r = new String[]{"JMSDeliveryTime", "0"};
                this.addRow(r);
            }
        }
        this.s_headerRows = this.getRowCount();
    }

    public void emptyPropertyInfo(String dest) {
        this.setRowCount(0);
        this.setColumnCount(0);
        this.addColumn("Property");
        this.addColumn("Value");
        TableColumn tc = this.m_table.getColumn("Value");
        tc.setCellEditor(new MultiEditor());
        tc.setCellRenderer(new GemsPropertyTableModel.MultiRenderer(this));
        Object[] r = new Object[]{"JMSDeliveryMode", DELMODE.NON_PERSISTENT};
        this.addRow(r);
        r = new String[]{"JMSDestination", dest};
        this.addRow(r);
        r = new String[]{"JMSCorrelationID", ""};
        this.addRow(r);
        r = new String[]{"JMSType", ""};
        this.addRow(r);
        if (Gems.getGems().getShowExtendedProperties()) {
            r = new String[]{"JMSExpiration", "0"};
            this.addRow(r);
            r = new String[]{"JMSPriority", "4"};
            this.addRow(r);
            if (Gems.getGems().isJMS2()) {
                r = new String[]{"JMSDeliveryTime", "0"};
                this.addRow(r);
            }
        }
    }

    String getJMSMessageID() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, 0)).equals("JMSMessageID")) continue;
            return (String)this.getValueAt(i, 1);
        }
        return null;
    }

    String getJMSCorrelationID() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, 0)).equals("JMSCorrelationID")) continue;
            return (String)this.getValueAt(i, 1);
        }
        return "";
    }

    void setJMSCorrelationID(String c) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, 0)).equals("JMSCorrelationID")) continue;
            this.setValueAt(c, i, 1);
        }
    }

    int getJMSDeliveryMode() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object d;
            if (!((String)this.getValueAt(i, 0)).equals("JMSDeliveryMode") || !((d = this.getValueAt(i, 1)) instanceof DELMODE)) continue;
            if ((DELMODE)((Object)d) == DELMODE.PERSISTENT) {
                return 2;
            }
            if ((DELMODE)((Object)d) != DELMODE.RELIABLE) continue;
            return 22;
        }
        return 1;
    }

    String getJMSDestination() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, 0)).equals("JMSDestination")) continue;
            return (String)this.getValueAt(i, 1);
        }
        return "";
    }

    int getJMSExpiration() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, 0)).equals("JMSExpiration")) continue;
            return Integer.parseInt((String)this.getValueAt(i, 1));
        }
        return 0;
    }

    long getJMSDeliveryTime() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, 0)).equals("JMSDeliveryTime")) continue;
            return Long.parseLong((String)this.getValueAt(i, 1));
        }
        return 0L;
    }

    int getJMSPriority() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, 0)).equals("JMSPriority")) continue;
            return Integer.parseInt((String)this.getValueAt(i, 1));
        }
        return 4;
    }

    GemsDestination getJMSReplyTo() {
        int i = 0;
        for (i = 0; i < this.m_table.getRowCount(); ++i) {
            String n = (String)this.getValueAt(i, 0);
            if (n.equals("JMSReplyTo")) {
                return (GemsDestination)this.getValueAt(i, 1);
            }
            if (!n.startsWith("JMS")) break;
        }
        return null;
    }

    String getJMSType() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, 0)).equals("JMSType")) continue;
            return (String)this.getValueAt(i, 1);
        }
        return "";
    }

    void setJMSType(String t) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, 0)).equals("JMSType")) continue;
            this.setValueAt(t, i, 1);
        }
    }

    public void addPropertyInfo(String p) {
        int i = p.indexOf(61);
        if (i > 0) {
            String val = p.substring(i + 1);
            int j = val.indexOf(58);
            try {
                if (j > 0) {
                    switch (GemsMsgPropTableModel.getTypeFromString(val.substring(0, j))) {
                        case 9: {
                            Object[] r = new Object[]{p.substring(0, i), val.substring(j + 1)};
                            this.addRow(r);
                            return;
                        }
                        case 5: {
                            Object[] r = new Object[]{p.substring(0, i), new Integer(val.substring(j + 1))};
                            this.addRow(r);
                            return;
                        }
                        case 6: {
                            Object[] r = new Object[]{p.substring(0, i), new Long(val.substring(j + 1))};
                            this.addRow(r);
                            return;
                        }
                        case 1: {
                            Object[] r = new Object[]{p.substring(0, i), new Boolean(val.substring(j + 1))};
                            this.addRow(r);
                            return;
                        }
                        case 4: {
                            Object[] r = new Object[]{p.substring(0, i), new Short(val.substring(j + 1))};
                            this.addRow(r);
                            return;
                        }
                        case 2: {
                            Object[] r = new Object[]{p.substring(0, i), new Byte(val.substring(j + 1))};
                            this.addRow(r);
                            return;
                        }
                        case 8: {
                            Object[] r = new Object[]{p.substring(0, i), new Double(val.substring(j + 1))};
                            this.addRow(r);
                            return;
                        }
                        case 7: {
                            Object[] r = new Object[]{p.substring(0, i), new Float(val.substring(j + 1))};
                            this.addRow(r);
                            return;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 18: {
                            System.err.println("Unsupported message property type conversion: " + val.substring(0, j));
                            return;
                        }
                        case 255: {
                            Object[] r = new Object[]{p.substring(0, i), val};
                            this.addRow(r);
                            return;
                        }
                    }
                } else {
                    Object[] r = new String[]{p.substring(0, i), val};
                    this.addRow(r);
                }
            }
            catch (Exception exc) {
                System.err.println("Exception: " + exc.getMessage());
            }
        }
    }

    public void addJMSReplyToProperty(GemsDestination d) {
        int i = 0;
        for (i = 0; i < this.m_table.getRowCount(); ++i) {
            String n = (String)this.getValueAt(i, 0);
            if (n.equals("JMSReplyTo")) {
                return;
            }
            if (!n.startsWith("JMS") || n.startsWith("JMS_")) break;
        }
        Object[] r = new Object[]{"JMSReplyTo", d};
        this.insertRow(i, r);
    }

    public void addCompressProperty() {
        int i = 0;
        for (i = 0; i < this.m_table.getRowCount(); ++i) {
            String n = (String)this.getValueAt(i, 0);
            if (n.equals("JMS_TIBCO_COMPRESS")) {
                return;
            }
            if (!n.startsWith("JMS")) break;
        }
        Object[] r = new Object[]{"JMS_TIBCO_COMPRESS", new Boolean("true")};
        this.insertRow(i, r);
    }

    public void addPreserveProperty() {
        int i = 0;
        for (i = 0; i < this.m_table.getRowCount(); ++i) {
            String n = (String)this.getValueAt(i, 0);
            if (n.equals("JMS_TIBCO_PRESERVE_UNDELIVERED")) {
                return;
            }
            if (!n.startsWith("JMS")) break;
        }
        Object[] r = new Object[]{"JMS_TIBCO_PRESERVE_UNDELIVERED", new Boolean("true")};
        this.insertRow(i, r);
    }

    private class MultiEditor
    implements TableCellEditor {
        private static final int DEFAULT = 0;
        private static final int COMBO_BOOL = 1;
        private static final int COMBO_DELMODE = 2;
        private static final int NOEDIT_DEST = 3;
        private DefaultCellEditor[] cellEditors;
        private JComboBox delmodeComboBox;
        private JComboBox boolComboBox;
        private JTextField noEditTextField = new JTextField();
        private JTextField defaultTextField = new JTextField();
        private int cellEditorID;
        private Object currObj = null;

        public MultiEditor() {
            this.cellEditors = new DefaultCellEditor[4];
            this.delmodeComboBox = new JComboBox();
            for (DELMODE dm : DELMODE.values()) {
                this.delmodeComboBox.addItem(dm);
            }
            this.cellEditors[2] = new DefaultCellEditor(this.delmodeComboBox);
            this.boolComboBox = new JComboBox();
            this.boolComboBox.addItem("true");
            this.boolComboBox.addItem("false");
            this.cellEditors[1] = new DefaultCellEditor(this.boolComboBox);
            this.defaultTextField.setMargin(new Insets(0, 0, 0, 0));
            this.cellEditors[0] = new DefaultCellEditor(this.defaultTextField);
            this.noEditTextField.setEditable(false);
            this.cellEditors[3] = new DefaultCellEditor(this.noEditTextField);
            this.cellEditorID = 0;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currObj = value;
            if (value instanceof DELMODE) {
                this.cellEditorID = 2;
            } else if (value instanceof Boolean) {
                this.cellEditorID = 1;
                this.boolComboBox.setSelectedItem(value.toString());
            } else if (value instanceof GemsDestination) {
                for (Container p = GemsMsgPropTableModel.this.m_table.getParent(); p != null; p = p.getParent()) {
                    if (!(p instanceof GemsMessageFrame)) continue;
                    GemsDestinationPicker dp = new GemsDestinationPicker(((GemsMessageFrame)p).m_frame, ((GemsMessageFrame)p).m_cn);
                    if (dp.m_retDest == null) break;
                    value = this.currObj = dp.m_retDest;
                    break;
                }
                this.cellEditorID = 3;
            } else {
                this.cellEditorID = 0;
            }
            return this.cellEditors[this.cellEditorID].getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            switch (this.cellEditorID) {
                case 2: {
                    return this.delmodeComboBox.getSelectedItem();
                }
                case 1: {
                    return new Boolean((String)this.boolComboBox.getSelectedItem());
                }
                case 3: {
                    return this.currObj;
                }
            }
            try {
                Object o = this.cellEditors[this.cellEditorID].getCellEditorValue();
                if (this.currObj instanceof String) {
                    return o;
                }
                if (this.currObj instanceof Integer) {
                    return new Integer((String)o);
                }
                if (this.currObj instanceof Long) {
                    return new Long((String)o);
                }
                if (this.currObj instanceof Short) {
                    return new Short((String)o);
                }
                if (this.currObj instanceof Byte) {
                    return new Byte((String)o);
                }
                if (this.currObj instanceof Float) {
                    return new Float((String)o);
                }
                if (this.currObj instanceof Double) {
                    return new Double((String)o);
                }
                return o;
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(null, exc.getMessage(), "Error", 1);
                System.err.println("Exception: " + exc.getMessage());
                return this.currObj;
            }
        }

        public Component getComponent() {
            return this.cellEditors[this.cellEditorID].getComponent();
        }

        @Override
        public boolean stopCellEditing() {
            return this.cellEditors[this.cellEditorID].stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.cellEditors[this.cellEditorID].cancelCellEditing();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.cellEditors[this.cellEditorID].isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.cellEditors[this.cellEditorID].shouldSelectCell(anEvent);
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.cellEditors[this.cellEditorID].addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.cellEditors[this.cellEditorID].removeCellEditorListener(l);
        }

        public void setClickCountToStart(int n) {
            this.cellEditors[this.cellEditorID].setClickCountToStart(n);
        }

        public int getClickCountToStart() {
            return this.cellEditors[this.cellEditorID].getClickCountToStart();
        }
    }

    private static enum DELMODE {
        NON_PERSISTENT,
        PERSISTENT,
        RELIABLE;

    }
}

