/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsCheckNode;
import com.tibco.gems.GemsCheckRenderer;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.admin.ACLEntry;
import com.tibco.tibjms.admin.DestinationInfo;
import com.tibco.tibjms.admin.GroupInfo;
import com.tibco.tibjms.admin.Permissions;
import com.tibco.tibjms.admin.PrincipalInfo;
import com.tibco.tibjms.admin.QueueInfo;
import com.tibco.tibjms.admin.TibjmsAdminException;
import com.tibco.tibjms.admin.TopicInfo;
import com.tibco.tibjms.admin.UserInfo;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class GemsPermissionDialog
extends JDialog {
    protected JTree m_perms;
    protected JFrame m_frame;
    protected JCheckBox m_isAdmin;
    protected JTextField m_dest;
    protected JComboBox m_principal;
    protected boolean m_cancelled = false;
    protected String m_selected;
    protected GemsCheckNode[] m_px;
    protected GemsConnectionNode m_cn;
    protected boolean m_isQueue = false;
    protected JButton m_destwiz;
    Comparator<PrincipalInfo> principalComparator = new Comparator<PrincipalInfo>(){

        @Override
        public int compare(PrincipalInfo p1, PrincipalInfo p2) {
            return p1.getName().compareTo(p2.getName());
        }
    };

    public GemsPermissionDialog(JFrame frame, String title, boolean isQueue, GemsConnectionNode cn, String dest) {
        super(frame, title, true);
        this.m_cn = cn;
        this.m_frame = frame;
        this.m_isQueue = isQueue;
        this.buildFrame(frame, dest);
        this.updatePermissions(true);
        this.pack();
        this.show();
    }

    public GemsPermissionDialog(JFrame frame, GemsConnectionNode cn, String dest, String destType, String principal, String principalType, String isExternal) {
        super(frame, "Set " + destType + " Permissions", true);
        this.m_frame = frame;
        this.m_cn = cn;
        this.m_isQueue = destType.equals("Queue");
        String n = principal;
        n = principalType.equals("User") ? n + " (user" : n + " (group";
        n = isExternal.equals("true") ? n + ", external)" : n + ")";
        this.buildFrame(frame, dest);
        this.m_principal.setSelectedItem(n);
        this.m_selected = (String)this.m_principal.getSelectedItem();
        this.updatePermissions(true);
        this.pack();
        this.show();
    }

    public void buildFrame(Frame frame, String dest) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel toppanel = new JPanel(new SpringLayout());
        mainPanel.add(toppanel);
        JPanel qpanel = new JPanel(true);
        qpanel.setLayout(new BoxLayout(qpanel, 0));
        JLabel l1 = new JLabel(this.m_isQueue ? "Queue:" : "Topic:", 11);
        this.m_dest = new JTextField(20);
        this.m_dest.setText(dest);
        toppanel.add(l1);
        qpanel.add(this.m_dest);
        this.m_destwiz = new JButton("...");
        this.m_destwiz.setPreferredSize(new Dimension(18, 16));
        this.m_destwiz.addActionListener(new DestinationWizardAction());
        qpanel.add(this.m_destwiz);
        toppanel.add(qpanel);
        JLabel l2 = new JLabel("Principal:", 11);
        this.m_principal = new JComboBox();
        this.populatePrincipals();
        this.m_principal.addActionListener(new PrincipalSelected());
        toppanel.add(l2);
        toppanel.add(this.m_principal);
        GemsUtilities.makeCompactGrid(toppanel, 2, 2, 5, 5, 5, 5);
        this.m_px = this.m_isQueue ? new GemsCheckNode[]{new GemsCheckNode("All Permissions:"), new GemsCheckNode("JMS Permissions:"), new GemsCheckNode("Send To Queue"), new GemsCheckNode("Receive From Queue"), new GemsCheckNode("Browse Queue"), new GemsCheckNode("Admin Permissions:"), new GemsCheckNode("View Queue"), new GemsCheckNode("Create Queue"), new GemsCheckNode("Modify Queue"), new GemsCheckNode("Delete Queue"), new GemsCheckNode("Purge Queue")} : new GemsCheckNode[]{new GemsCheckNode("All Permissions:"), new GemsCheckNode("JMS Permissions:"), new GemsCheckNode("Subscribe To Topic"), new GemsCheckNode("Publish To Topic"), new GemsCheckNode("Create Durable"), new GemsCheckNode("Use Durable"), new GemsCheckNode("Admin Permissions:"), new GemsCheckNode("View Topic"), new GemsCheckNode("Create Topic"), new GemsCheckNode("Modify Topic"), new GemsCheckNode("Delete Topic"), new GemsCheckNode("Purge Topic")};
        this.m_perms = new JTree(this.m_px[0]);
        this.m_perms.setBorder(new EtchedBorder());
        this.m_perms.setCellRenderer(new GemsCheckRenderer());
        this.m_perms.getSelectionModel().setSelectionMode(1);
        this.m_perms.putClientProperty("JTree.lineStyle", "Angled");
        this.m_perms.addMouseListener(new NodeSelectionListener(this.m_perms));
        int p = 0;
        for (int c = 1; c < this.m_px.length; ++c) {
            if (((String)this.m_px[c].getUserObject()).endsWith(":") && p > 0) {
                p = 0;
            }
            this.m_px[p].add(this.m_px[c]);
            if (!((String)this.m_px[c].getUserObject()).endsWith(":") || p != 0) continue;
            p = c;
        }
        this.m_perms.expandRow(0);
        this.m_perms.expandRow(1);
        this.m_perms.expandRow(5);
        this.m_perms.expandRow(6);
        JScrollPane sp = new JScrollPane(this.m_perms);
        sp.setPreferredSize(new Dimension(350, 300));
        JPanel midPanel = new JPanel();
        midPanel.setBorder(new TitledBorder("Permissions"));
        midPanel.setLayout(new BoxLayout(midPanel, 1));
        JPanel pbutpanel = new JPanel(new FlowLayout());
        JButton a3 = new JButton("Apply");
        a3.addActionListener(new ApplyPressed());
        pbutpanel.add(a3);
        JButton p2 = new JButton("Reset");
        p2.addActionListener(new ResetPressed());
        pbutpanel.add(p2);
        midPanel.add(sp);
        JPanel pbpanel = new JPanel(new FlowLayout());
        JButton p1 = new JButton("Permit All");
        JButton p3 = new JButton("Restrict All");
        pbpanel.add(p1);
        pbpanel.add(p3);
        midPanel.add(pbutpanel);
        mainPanel.add(midPanel);
        JPanel holdbut = new JPanel();
        holdbut.setLayout(new FlowLayout());
        JButton b3 = new JButton("OK");
        JButton c3 = new JButton("Cancel");
        holdbut.add(b3);
        holdbut.add(c3);
        b3.addActionListener(new OkPressed());
        c3.addActionListener(new CancelPressed());
        mainPanel.add(holdbut);
        this.setContentPane(mainPanel);
        this.setLocationRelativeTo(frame);
    }

    public String getSelectedProp() {
        return this.m_selected;
    }

    public void populatePrincipals() {
        try {
            UserInfo[] u = this.m_cn.m_adminConn.getUsers();
            Arrays.sort(u, this.principalComparator);
            for (int i = 0; i < u.length; ++i) {
                if (u[i].getName().equals("admin")) continue;
                String n = u[i].getName() + " (user";
                n = u[i].isExternal() ? n + ", external)" : n + ")";
                this.m_principal.addItem(n);
            }
            GroupInfo[] g = this.m_cn.m_adminConn.getGroups();
            Arrays.sort(g, this.principalComparator);
            for (int i = 0; i < g.length; ++i) {
                if (g[i].getName().equals("$admin")) continue;
                String n = g[i].getName() + " (group";
                n = g[i].isExternal() ? n + ", external)" : n + ")";
                this.m_principal.addItem(n);
            }
            this.m_selected = (String)this.m_principal.getSelectedItem();
        }
        catch (TibjmsAdminException e) {
            System.err.println("JMSException: " + e.getMessage());
        }
    }

    public void updatePermissions(boolean first) {
        if (first && this.m_dest.getText().length() == 0) {
            return;
        }
        try {
            for (int i = 0; i < this.m_px.length; ++i) {
                this.m_px[i].setSelected(false);
            }
            ACLEntry[] acl = this.m_isQueue ? this.m_cn.m_adminConn.getQueueACLEntries(this.m_dest.getText()) : this.m_cn.m_adminConn.getTopicACLEntries(this.m_dest.getText());
            for (int i = 0; i < acl.length; ++i) {
                String n = acl[i].getPrincipal().getName();
                n = acl[i].getPrincipal() instanceof UserInfo ? n + " (user" : n + " (group";
                if (!this.m_selected.startsWith(n)) continue;
                Permissions p = acl[i].getPermissions();
                if (this.m_isQueue) {
                    if (p.hasPermission(1L)) {
                        this.m_px[2].setSelected(true);
                    }
                    if (p.hasPermission(2L)) {
                        this.m_px[3].setSelected(true);
                    }
                    if (p.hasPermission(4L)) {
                        this.m_px[4].setSelected(true);
                    }
                    if (p.hasPermission(65536L)) {
                        this.m_px[6].setSelected(true);
                    }
                    if (p.hasPermission(131072L)) {
                        this.m_px[7].setSelected(true);
                    }
                    if (p.hasPermission(524288L)) {
                        this.m_px[8].setSelected(true);
                    }
                    if (p.hasPermission(262144L)) {
                        this.m_px[9].setSelected(true);
                    }
                    if (p.hasPermission(0x100000L)) {
                        this.m_px[10].setSelected(true);
                    }
                } else {
                    if (p.hasPermission(32L)) {
                        this.m_px[2].setSelected(true);
                    }
                    if (p.hasPermission(16L)) {
                        this.m_px[3].setSelected(true);
                    }
                    if (p.hasPermission(64L)) {
                        this.m_px[4].setSelected(true);
                    }
                    if (p.hasPermission(128L)) {
                        this.m_px[5].setSelected(true);
                    }
                    if (p.hasPermission(65536L)) {
                        this.m_px[7].setSelected(true);
                    }
                    if (p.hasPermission(131072L)) {
                        this.m_px[8].setSelected(true);
                    }
                    if (p.hasPermission(524288L)) {
                        this.m_px[9].setSelected(true);
                    }
                    if (p.hasPermission(262144L)) {
                        this.m_px[10].setSelected(true);
                    }
                    if (p.hasPermission(0x100000L)) {
                        this.m_px[11].setSelected(true);
                    }
                }
                break;
            }
        }
        catch (TibjmsAdminException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 1);
        }
        this.m_perms.repaint();
    }

    public void setPermissions() {
        try {
            UserInfo pr;
            QueueInfo d;
            Permissions gp = new Permissions();
            Permissions rp = new Permissions();
            if (this.m_isQueue) {
                d = new QueueInfo(this.m_dest.getText());
                if (this.m_px[2].isSelected()) {
                    gp.setPermission(1L, true);
                } else {
                    rp.setPermission(1L, true);
                }
                if (this.m_px[3].isSelected()) {
                    gp.setPermission(2L, true);
                } else {
                    rp.setPermission(2L, true);
                }
                if (this.m_px[4].isSelected()) {
                    gp.setPermission(4L, true);
                } else {
                    rp.setPermission(4L, true);
                }
                if (this.m_px[6].isSelected()) {
                    gp.setPermission(65536L, true);
                } else {
                    rp.setPermission(65536L, true);
                }
                if (this.m_px[7].isSelected()) {
                    gp.setPermission(131072L, true);
                } else {
                    rp.setPermission(131072L, true);
                }
                if (this.m_px[8].isSelected()) {
                    gp.setPermission(524288L, true);
                } else {
                    rp.setPermission(524288L, true);
                }
                if (this.m_px[9].isSelected()) {
                    gp.setPermission(262144L, true);
                } else {
                    rp.setPermission(262144L, true);
                }
                if (this.m_px[10].isSelected()) {
                    gp.setPermission(0x100000L, true);
                } else {
                    rp.setPermission(0x100000L, true);
                }
            } else {
                d = new TopicInfo(this.m_dest.getText());
                if (this.m_px[2].isSelected()) {
                    gp.setPermission(32L, true);
                } else {
                    rp.setPermission(32L, true);
                }
                if (this.m_px[3].isSelected()) {
                    gp.setPermission(16L, true);
                } else {
                    rp.setPermission(16L, true);
                }
                if (this.m_px[4].isSelected()) {
                    gp.setPermission(64L, true);
                } else {
                    rp.setPermission(64L, true);
                }
                if (this.m_px[5].isSelected()) {
                    gp.setPermission(128L, true);
                } else {
                    rp.setPermission(128L, true);
                }
                if (this.m_px[7].isSelected()) {
                    gp.setPermission(65536L, true);
                } else {
                    rp.setPermission(65536L, true);
                }
                if (this.m_px[8].isSelected()) {
                    gp.setPermission(131072L, true);
                } else {
                    rp.setPermission(131072L, true);
                }
                if (this.m_px[9].isSelected()) {
                    gp.setPermission(524288L, true);
                } else {
                    rp.setPermission(524288L, true);
                }
                if (this.m_px[10].isSelected()) {
                    gp.setPermission(262144L, true);
                } else {
                    rp.setPermission(262144L, true);
                }
                if (this.m_px[11].isSelected()) {
                    gp.setPermission(0x100000L, true);
                } else {
                    rp.setPermission(0x100000L, true);
                }
            }
            int i = this.m_selected.lastIndexOf(" (user");
            if (i > 0) {
                pr = new UserInfo(this.m_selected.substring(0, i));
            } else {
                i = this.m_selected.lastIndexOf(" (group");
                pr = new GroupInfo(this.m_selected.substring(0, i));
            }
            if (!gp.isEmpty()) {
                this.m_cn.m_adminConn.grant(new ACLEntry((DestinationInfo)d, (PrincipalInfo)pr, gp));
            }
            if (!rp.isEmpty()) {
                this.m_cn.m_adminConn.revoke(new ACLEntry((DestinationInfo)d, (PrincipalInfo)pr, rp));
            }
            Gems.getGems().scheduleRepaint();
        }
        catch (TibjmsAdminException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 1);
            this.updatePermissions(false);
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int y;
            int x = e.getX();
            int row = this.tree.getRowForLocation(x, y = e.getY());
            TreePath path = this.tree.getPathForRow(row);
            if (path != null) {
                GemsCheckNode node = (GemsCheckNode)path.getLastPathComponent();
                boolean isSelected = !node.isSelected();
                node.setSelected(isSelected);
                if (node.getSelectionMode() == 4) {
                    this.tree.expandPath(path);
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
                if (row >= 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
            }
        }
    }

    class DestinationWizardAction
    implements ActionListener {
        DestinationWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsPermissionDialog.this.m_frame, GemsPermissionDialog.this.m_cn, GemsPermissionDialog.this.m_isQueue ? GemsDestination.DEST_TYPE.Queue : GemsDestination.DEST_TYPE.Topic);
            if (dp.m_retDest != null) {
                GemsPermissionDialog.this.m_dest.setText(dp.m_retDest.m_destName);
            }
        }
    }

    class CancelPressed
    implements ActionListener {
        CancelPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsPermissionDialog.this.m_cancelled = true;
            GemsPermissionDialog.this.dispose();
        }
    }

    class OkPressed
    implements ActionListener {
        OkPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsPermissionDialog.this.setPermissions();
            GemsPermissionDialog.this.dispose();
        }
    }

    class ApplyPressed
    implements ActionListener {
        ApplyPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsPermissionDialog.this.setPermissions();
        }
    }

    class PrincipalSelected
    implements ActionListener {
        PrincipalSelected() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsPermissionDialog.this.m_selected = (String)GemsPermissionDialog.this.m_principal.getSelectedItem();
            GemsPermissionDialog.this.updatePermissions(false);
        }
    }

    class ResetPressed
    implements ActionListener {
        ResetPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsPermissionDialog.this.updatePermissions(false);
        }
    }
}

