/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestTableModel;
import com.tibco.gems.GemsMessageTableModel;
import com.tibco.gems.GemsMessageText;
import com.tibco.gems.GemsServerInfoTableModel;
import com.tibco.gems.GemsServerMonitorTableModel;
import com.tibco.gems.GetPopupHandler;
import com.tibco.gems.PopupHandler;
import com.tibco.gems.TableSorter;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class GemsPopupEventQueue
extends EventQueue {
    public JPopupMenu popup;
    public BasicAction cut;
    public BasicAction copy;
    public BasicAction paste;
    public BasicAction selectAll;
    public BasicAction hexbytes;
    public BasicAction asciibytes;
    public BasicAction textAct;
    public BasicAction xmlAct;
    public BasicAction save2csv;
    public BasicAction servprop;
    public BasicAction clear;
    public BasicAction showtotal;
    public BasicAction servtrace;
    public BasicAction disct;
    static File m_currentdir = null;

    public void createTextPopupMenu(JTextComponent tc) {
        this.cut = new CutAction("Cut", null);
        this.copy = new CopyAction("Copy", null);
        this.paste = new PasteAction("Paste", null);
        this.selectAll = new SelectAllAction("Select All", null);
        this.cut.setTextComponent(tc);
        this.copy.setTextComponent(tc);
        this.paste.setTextComponent(tc);
        this.selectAll.setTextComponent(tc);
        this.popup = new JPopupMenu();
        this.popup.add(this.cut);
        this.popup.add(this.copy);
        this.popup.add(this.paste);
        this.popup.addSeparator();
        this.popup.add(this.selectAll);
        if (tc instanceof GemsMessageText) {
            if (((GemsMessageText)tc).getMode() == 1) {
                this.popup.addSeparator();
                this.asciibytes = new AsciiBytesAction("View as Text", null);
                this.asciibytes.setTextComponent(tc);
                this.popup.add(this.asciibytes);
            } else if (((GemsMessageText)tc).getMode() == 2) {
                this.popup.addSeparator();
                this.hexbytes = new HexBytesAction("View as Hex", null);
                this.hexbytes.setTextComponent(tc);
                this.popup.add(this.hexbytes);
            } else if (((GemsMessageText)tc).getMode() == 4) {
                this.popup.addSeparator();
                this.textAct = new TextAction("View as Text", null);
                this.textAct.setTextComponent(tc);
                this.popup.add(this.textAct);
            } else if (((GemsMessageText)tc).getMode() == 3) {
                this.popup.addSeparator();
                this.xmlAct = new XmlAction("View as XML", null);
                this.xmlAct.setTextComponent(tc);
                this.popup.add(this.xmlAct);
            }
        }
    }

    public void createTablePopupMenu(JTable tc, Object v, int r, int c) {
        this.copy = new TableCopyAction("Copy Cell", null);
        this.servprop = new TableServerPropertyAction("Set Server Property...", null);
        this.servtrace = new TableServerTraceAction("Set Server Trace...", null);
        this.save2csv = new TableSave2CSVAction("Save Table To CSV File...", null);
        this.disct = new DisableClientTraceAction("Disable Client Trace...", null);
        this.copy.setTableComponent(tc, v);
        this.save2csv.setTableComponent(tc, v);
        this.servprop.setTableComponent(tc, v);
        this.popup = new JPopupMenu();
        this.popup.add(this.copy);
        this.popup.addSeparator();
        this.popup.add(this.save2csv);
        TableSorter sr = null;
        if (tc.getModel() instanceof TableSorter) {
            sr = (TableSorter)tc.getModel();
        }
        if (sr != null && !Gems.getGems().getViewOnlyMode() && sr.getTableModel() instanceof GemsServerInfoTableModel) {
            this.popup.addSeparator();
            this.popup.add(this.servprop);
            this.popup.add(this.servtrace);
            this.popup.addSeparator();
            this.popup.add(this.disct);
        } else if (tc.getModel() instanceof GemsServerMonitorTableModel) {
            this.showtotal = new ShowTotalAction("Show/Hide Totals", null);
            this.showtotal.setTableComponent(tc, v);
            this.popup.addSeparator();
            this.popup.add(this.showtotal);
        }
    }

    public void createEventTablePopupMenu(JTable tc, Object v) {
        this.copy = new TableCopyAction("Copy Cell", null);
        this.clear = new TableClearEventsAction("Clear Events", null);
        this.copy.setTableComponent(tc, v);
        this.clear.setTableComponent(tc, v);
        this.popup = new JPopupMenu();
        this.popup.add(this.copy);
        this.popup.addSeparator();
        this.popup.add(this.clear);
    }

    public void createCheckTablePopupMenu(JTable tc, Object v) {
        this.copy = new TableCopyAction("Copy Cell", null);
        this.selectAll = new TableSelectAllAction("Select All", null);
        this.copy.setTableComponent(tc, v);
        this.selectAll.setTableComponent(tc, v);
        this.popup = new JPopupMenu();
        this.popup.add(this.copy);
        this.popup.addSeparator();
        this.popup.add(this.selectAll);
    }

    public void showPopup(Component parent, MouseEvent me) {
        if (this.popup == null) {
            return;
        }
        this.popup.validate();
        this.popup.show(parent, me.getX(), me.getY());
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        super.dispatchEvent(event);
        if (!(event instanceof MouseEvent)) {
            return;
        }
        MouseEvent me = (MouseEvent)event;
        if (!me.isPopupTrigger()) {
            return;
        }
        Component comp = SwingUtilities.getDeepestComponentAt((Component)me.getSource(), me.getX(), me.getY());
        if (comp == null) {
            return;
        }
        Point p = me.getPoint();
        Point f = me.getComponent().getLocation();
        Point l = comp.getLocationOnScreen();
        l.translate((int)(-f.getX()), (int)(-f.getY()));
        p.translate((int)(-l.getX()), (int)(-l.getY()));
        boolean isTable = false;
        Object v = null;
        int r = 0;
        int c = 0;
        if (comp instanceof JTable) {
            isTable = true;
            c = ((JTable)comp).columnAtPoint(p);
            r = ((JTable)comp).rowAtPoint(p);
            v = ((JTable)comp).getModel().getValueAt(r, c);
            if (v == null) {
                v = new String();
            }
        } else if (!(comp instanceof JTextComponent) && !(comp instanceof JTree)) {
            return;
        }
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        if (isTable) {
            TableSorter sr = null;
            if (((JTable)comp).getModel() instanceof TableSorter) {
                sr = (TableSorter)((JTable)comp).getModel();
            }
            if (sr != null && sr.getTableModel() instanceof GemsDestTableModel) {
                this.createCheckTablePopupMenu((JTable)comp, v);
            } else if (((JTable)comp).getModel() instanceof GetPopupHandler) {
                PopupHandler ph = ((GetPopupHandler)((Object)((JTable)comp).getModel())).getPopupHandler();
                this.popup = ph.createPopup(p);
            } else if (sr != null && sr.getTableModel() instanceof GetPopupHandler) {
                PopupHandler ph = ((GetPopupHandler)((Object)sr.getTableModel())).getPopupHandler();
                this.popup = ph.createPopup(p);
            } else {
                this.createTablePopupMenu((JTable)comp, v, r, c);
            }
        } else if (comp instanceof JTree) {
            PopupHandler ph = ((GetPopupHandler)((Object)((JTree)comp).getModel())).getPopupHandler();
            this.popup = ph.createPopup(p);
        } else {
            ((JTextComponent)comp).grabFocus();
            this.createTextPopupMenu((JTextComponent)comp);
        }
        this.showPopup((Component)me.getSource(), me);
    }

    public class TableClearEventsAction
    extends BasicAction {
        int row;

        public TableClearEventsAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableSorter model = (TableSorter)this.tabcomp.getModel();
            Gems.getGems().clearCurrentEventsDisplay();
        }
    }

    public class TableSelectAllAction
    extends BasicAction {
        public TableSelectAllAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl A"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableSorter model = (TableSorter)this.tabcomp.getModel();
            if (model.getTableModel() instanceof GemsDestTableModel) {
                GemsDestTableModel mod = (GemsDestTableModel)model.getTableModel();
                mod.selectAllRows();
            } else if (model.getTableModel() instanceof GemsMessageTableModel) {
                GemsMessageTableModel mod = (GemsMessageTableModel)model.getTableModel();
                mod.selectAllRows();
            }
        }
    }

    public class TableSave2CSVAction
    extends BasicAction {
        public TableSave2CSVAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TableModel model = this.tabcomp.getModel();
                JFileChooser chooser = new JFileChooser(m_currentdir);
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Save Table To CSV File");
                int returnVal = chooser.showOpenDialog(this.tabcomp);
                m_currentdir = chooser.getCurrentDirectory();
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    f.createNewFile();
                    FileOutputStream fout = new FileOutputStream(f);
                    PrintWriter writer = new PrintWriter(fout);
                    int m = model.getColumnCount();
                    int n = model.getRowCount();
                    StringBuffer b = new StringBuffer();
                    for (int j = 0; j < m; ++j) {
                        TableColumn col = this.tabcomp.getColumnModel().getColumn(j);
                        b.append(col.getHeaderValue());
                        if (j + 1 >= m) continue;
                        b.append(Gems.getGems().getCSVFileDelimiter());
                    }
                    if (b.charAt(0) == 'I' && b.charAt(1) == 'D') {
                        writer.print('\'');
                    }
                    writer.println(b.toString());
                    for (int i = 0; i < n; ++i) {
                        StringBuffer builder = new StringBuffer();
                        for (int j = 0; j < m; ++j) {
                            builder.append(model.getValueAt(i, j));
                            if (j + 1 >= m) continue;
                            builder.append(Gems.getGems().getCSVFileDelimiter());
                        }
                        writer.println(builder.toString());
                    }
                    writer.close();
                }
            }
            catch (IOException ie) {
                System.err.println("JavaIOException: " + ie.getMessage());
                return;
            }
        }

        @Override
        public boolean isEnabled() {
            return this.tabcomp != null;
        }
    }

    public class TableCopyAction
    extends BasicAction {
        public TableCopyAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringSelection ss = new StringSelection(this.v.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }

        @Override
        public boolean isEnabled() {
            return this.tabcomp != null;
        }
    }

    public class ShowTotalAction
    extends BasicAction {
        public ShowTotalAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gems.getGems().setShowTotals(!Gems.getGems().getShowTotals());
        }

        @Override
        public boolean isEnabled() {
            return this.tabcomp != null;
        }
    }

    public class DisableClientTraceAction
    extends BasicAction {
        public DisableClientTraceAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            if (cn != null) {
                cn.disableClientTrace();
            }
        }

        @Override
        public boolean isEnabled() {
            GemsConnectionNode cn = Gems.getGems().getConnectionNode();
            return cn != null && cn.isClientTraceEnabled();
        }
    }

    public class TableServerTraceAction
    extends BasicAction {
        public TableServerTraceAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gems.getGems().getTreeModel().setServerTrace();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public class TableServerPropertyAction
    extends BasicAction {
        public TableServerPropertyAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gems.getGems().getTreeModel().serverPanelDoubleClick((String)this.v);
        }

        @Override
        public boolean isEnabled() {
            return this.v != null;
        }
    }

    public class SelectAllAction
    extends BasicAction {
        public SelectAllAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl A"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.txtcomp.selectAll();
        }

        @Override
        public boolean isEnabled() {
            return this.txtcomp != null && this.txtcomp.isEnabled() && this.txtcomp.getText().length() > 0 && (this.txtcomp.getSelectedText() == null || this.txtcomp.getSelectedText().length() < this.txtcomp.getText().length());
        }
    }

    public class PasteAction
    extends BasicAction {
        public PasteAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl V"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.txtcomp.paste();
        }

        @Override
        public boolean isEnabled() {
            Transferable content = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            return this.txtcomp != null && this.txtcomp.isEnabled() && this.txtcomp.isEditable() && content.isDataFlavorSupported(DataFlavor.stringFlavor);
        }
    }

    public class CopyAction
    extends BasicAction {
        public CopyAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl C"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.txtcomp.copy();
        }

        @Override
        public boolean isEnabled() {
            return this.txtcomp != null && this.txtcomp.getSelectedText() != null;
        }
    }

    public class CutAction
    extends BasicAction {
        public CutAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl X"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.txtcomp.cut();
        }

        @Override
        public boolean isEnabled() {
            return this.txtcomp != null && this.txtcomp.isEditable() && this.txtcomp.getSelectedText() != null;
        }
    }

    public abstract class BasicAction
    extends AbstractAction {
        JTextComponent txtcomp;
        JTable tabcomp;
        Object v;

        public BasicAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("ShortDescription", text);
        }

        public void setTextComponent(JTextComponent comp) {
            this.txtcomp = comp;
        }

        public void setTableComponent(JTable comp, Object v) {
            this.tabcomp = comp;
            this.v = v;
        }

        @Override
        public abstract void actionPerformed(ActionEvent var1);
    }

    public class AsciiBytesAction
    extends BasicAction {
        public AsciiBytesAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.txtcomp != null) {
                ((GemsMessageText)this.txtcomp).setMode(2);
            }
        }

        @Override
        public boolean isEnabled() {
            return this.txtcomp != null;
        }
    }

    public class HexBytesAction
    extends BasicAction {
        public HexBytesAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((GemsMessageText)this.txtcomp).setMode(1);
        }

        @Override
        public boolean isEnabled() {
            return this.txtcomp != null;
        }
    }

    public class XmlAction
    extends BasicAction {
        public XmlAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((GemsMessageText)this.txtcomp).setMode(4);
        }

        @Override
        public boolean isEnabled() {
            return this.txtcomp != null;
        }
    }

    public class TextAction
    extends BasicAction {
        public TextAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((GemsMessageText)this.txtcomp).setMode(3);
        }

        @Override
        public boolean isEnabled() {
            return this.txtcomp != null;
        }
    }
}

