/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import java.lang.reflect.Method;

public class GemsProperty {
    protected String name;
    protected Class type;
    protected String help;
    protected Object defValue = null;

    public GemsProperty(String name, Class type) {
        this.name = name;
        this.type = type;
        this.help = "<html> <br> <br> </html>";
    }

    public GemsProperty(String name, Class type, String help) {
        this.name = name;
        this.type = type;
        this.help = help;
    }

    public GemsProperty(String name, Class type, String help, Object def) {
        this.name = name;
        this.type = type;
        this.help = help;
        this.defValue = def;
    }

    public void setValue(Object obj, String value) {
        try {
            Class<?> cls = Class.forName(obj.getClass().getName());
            Class[] partypes = new Class[]{this.type};
            Method meth = cls.getMethod(this.getSetMethod(), partypes);
            Object[] arglist = new Object[1];
            if (this.type.isAssignableFrom(Long.TYPE)) {
                arglist[0] = new Long(value);
            } else if (this.type.isAssignableFrom(Boolean.TYPE)) {
                arglist[0] = new Boolean(value);
            } else if (this.type.isAssignableFrom(Class.forName("java.lang.String"))) {
                arglist[0] = value;
            } else if (this.type.isAssignableFrom(Integer.TYPE)) {
                arglist[0] = new Integer(value);
            } else if (this.type.isAssignableFrom(Byte.TYPE)) {
                arglist[0] = new Byte(value);
            } else {
                System.err.println("GemsProperty type not supported: " + this.type.getName());
            }
            meth.invoke(obj, arglist);
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    public String getValue(Object obj) {
        try {
            Class<?> cls = Class.forName(obj.getClass().getName());
            Method meth = cls.getMethod(this.getGetMethod(), null);
            Object ret = meth.invoke(obj, (Object[])null);
            return ret == null ? "" : ret.toString();
        }
        catch (Throwable e) {
            System.err.println(e);
            return new String();
        }
    }

    public void setBoolean(Object obj, boolean value) {
        try {
            Class<?> cls = Class.forName(obj.getClass().getName());
            Class[] partypes = new Class[]{this.type};
            Method meth = cls.getMethod(this.getSetMethod(), partypes);
            Object[] arglist = new Object[]{new Boolean(value)};
            meth.invoke(obj, arglist);
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    public void setLong(Object obj, long value) {
        try {
            Class<?> cls = Class.forName(obj.getClass().getName());
            Class[] partypes = new Class[]{this.type};
            Method meth = cls.getMethod(this.getSetMethod(), partypes);
            Object[] arglist = new Object[]{new Long(value)};
            meth.invoke(obj, arglist);
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    public void setString(Object obj, String value) {
        try {
            Class<?> cls = Class.forName(obj.getClass().getName());
            Class[] partypes = new Class[]{this.type};
            Method meth = cls.getMethod(this.getSetMethod(), partypes);
            Object[] arglist = new Object[]{new String(value)};
            meth.invoke(obj, arglist);
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    public String getSetMethod() {
        return "set" + this.name;
    }

    public String getGetMethod() {
        if (this.type.isAssignableFrom(Boolean.TYPE)) {
            return "is" + this.name;
        }
        return "get" + this.name;
    }

    public String getHelpText() {
        return this.help;
    }

    public String getDefValue() {
        if (this.defValue != null) {
            return this.defValue.toString();
        }
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return null;
    }
}

