/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsCheckboxRenderer;
import com.tibco.gems.GetPopupHandler;
import com.tibco.gems.PopupHandler;
import com.tibco.gems.PopupPropertyTableHandler;
import java.awt.Component;
import java.awt.Insets;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class GemsPropertyTableModel
extends DefaultTableModel
implements GetPopupHandler {
    JTable m_table;
    boolean m_isEditable = false;
    boolean m_is1stColEditable = false;
    boolean m_areRowsFixed = true;
    PopupHandler m_popup = null;
    GemsCheckboxRenderer m_checkRenderer = new GemsCheckboxRenderer();
    public boolean m_showCheckbox = false;

    public GemsPropertyTableModel(boolean editable) {
        this.m_isEditable = editable;
    }

    public GemsPropertyTableModel(boolean editable, boolean showCheckbox) {
        this.m_isEditable = editable;
        this.m_showCheckbox = showCheckbox;
    }

    public GemsPropertyTableModel(boolean editable, boolean showCheckbox, boolean is1stColEditable, boolean areRowsFixed) {
        this.m_isEditable = editable;
        this.m_showCheckbox = showCheckbox;
        this.m_is1stColEditable = is1stColEditable;
        this.m_areRowsFixed = areRowsFixed;
    }

    public Class getColumnClass(int columnIndex) {
        Object o = this.getValueAt(0, columnIndex);
        if (o != null) {
            return o.getClass();
        }
        return String.class;
    }

    @Override
    public PopupHandler getPopupHandler() {
        if (this.m_popup == null) {
            this.m_popup = new PopupPropertyTableHandler(this.m_table, this);
        }
        return this.m_popup;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.m_isEditable && (this.m_showCheckbox ? col == 0 || col == 2 && (Boolean)this.m_table.getValueAt(row, 0) != false || col == 1 && (Boolean)this.m_table.getValueAt(row, 0) != false && this.m_is1stColEditable : this.m_is1stColEditable || col == 1);
    }

    public boolean isEditable() {
        return this.m_isEditable;
    }

    public Vector getSelectedRows() {
        Vector<String> v = new Vector<String>();
        if (this.m_showCheckbox) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!((Boolean)this.m_table.getValueAt(i, 0)).booleanValue()) continue;
                if (this.m_showCheckbox) {
                    v.add((String)this.m_table.getValueAt(i, 1));
                    continue;
                }
                v.add((String)this.m_table.getValueAt(i, 0));
            }
        }
        return v;
    }

    public void selectAllRows() {
        if (this.m_showCheckbox) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.m_table.setValueAt(new Boolean(true), i, 0);
            }
        }
    }

    public void toggleSelectedRow() {
        if (this.m_showCheckbox) {
            this.m_table.setValueAt(new Boolean((Boolean)this.m_table.getValueAt(this.m_table.getSelectedRow(), 0) == false), this.m_table.getSelectedRow(), 0);
        }
    }

    public void emptyPropertyInfo(String selectName, String propName, String valueName) {
        this.setRowCount(0);
        this.setColumnCount(0);
        Vector<String> cols = new Vector<String>();
        if (this.m_showCheckbox) {
            this.m_table.setDefaultRenderer(Boolean.class, this.m_checkRenderer);
            cols.add(selectName);
        }
        cols.add(propName);
        cols.add(valueName);
        this.setColumnIdentifiers(cols);
        if (this.m_showCheckbox) {
            this.m_table.getColumn(selectName).setMaxWidth(60);
        }
        TableColumn tc = this.m_table.getColumn(valueName);
        tc.setCellEditor(new MultiEditor());
        tc.setCellRenderer(new MultiRenderer());
        if (this.m_is1stColEditable) {
            tc = this.m_table.getColumn(propName);
            tc.setCellRenderer(new MultiRenderer());
        }
    }

    public void addProperty(String prop, Object val) {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean(true), prop, val} : new Object[]{prop, val};
        this.addRow(r);
    }

    public void addProperty(boolean enabled, String prop, Object val) {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean(enabled), prop, val} : new Object[]{prop, val};
        this.addRow(r);
    }

    public void addProperty() {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean(true), new String(), new String()} : new String[]{new String(), new String()};
        this.addRow(r);
    }

    public void addEmptyPropertyInfo(int rows) {
        for (int i = 0; i < rows; ++i) {
            Object[] r = this.m_showCheckbox ? new Object[]{new Boolean(true), new String(), new String()} : new String[]{new String(), new String()};
            this.addRow(r);
        }
    }

    public void addBooleanProperty() {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean("true"), "boolean" + this.m_table.getColumnName(0), new Boolean("true")} : new Object[]{"boolean" + this.m_table.getColumnName(0), new Boolean("true")};
        this.addRow(r);
    }

    public void addByteProperty() {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean("true"), "byte" + this.m_table.getColumnName(0), new Byte(0)} : new Object[]{"byte" + this.m_table.getColumnName(0), new Byte(0)};
        this.addRow(r);
    }

    public void addFloatProperty() {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean("true"), "float" + this.m_table.getColumnName(0), new Float(0.0)} : new Object[]{"float" + this.m_table.getColumnName(0), new Float(0.0)};
        this.addRow(r);
    }

    public void addDoubleProperty() {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean("true"), "double" + this.m_table.getColumnName(0), new Double(0.0)} : new Object[]{"double" + this.m_table.getColumnName(0), new Double(0.0)};
        this.addRow(r);
    }

    public void addStringProperty() {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean("true"), "string" + this.m_table.getColumnName(0), new String()} : new Object[]{"string" + this.m_table.getColumnName(0), new String()};
        this.addRow(r);
    }

    public void addShortProperty() {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean("true"), "short" + this.m_table.getColumnName(0), new Short(0)} : new Object[]{"short" + this.m_table.getColumnName(0), new Short(0)};
        this.addRow(r);
    }

    public void addLongProperty() {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean("true"), "long" + this.m_table.getColumnName(0), new Long(0L)} : new Object[]{"long" + this.m_table.getColumnName(0), new Long(0L)};
        this.addRow(r);
    }

    public void addIntProperty() {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean("true"), "int" + this.m_table.getColumnName(0), new Integer(0)} : new Object[]{"int" + this.m_table.getColumnName(0), new Integer(0)};
        this.addRow(r);
    }

    public void addIntegerProperty(String f, Integer i) {
        Object[] r = this.m_showCheckbox ? new Object[]{new Boolean("true"), f, i} : new Object[]{f, i};
        this.addRow(r);
    }

    public String getToolTip() {
        return "Double-click to set value";
    }

    private class MultiEditor
    implements TableCellEditor {
        private static final int DEFAULT = 0;
        private static final int COMBO_BOOL = 1;
        private static final int NOEDIT = 2;
        private DefaultCellEditor[] cellEditors;
        private JComboBox boolComboBox;
        private JTextField noEditTextField = new JTextField();
        private JTextField defaultTextField = new JTextField();
        private int cellEditorID;
        private Object currObj = null;

        public MultiEditor() {
            this.cellEditors = new DefaultCellEditor[4];
            this.boolComboBox = new JComboBox();
            this.boolComboBox.addItem("true");
            this.boolComboBox.addItem("false");
            this.cellEditors[1] = new DefaultCellEditor(this.boolComboBox);
            this.defaultTextField.setMargin(new Insets(0, 0, 0, 0));
            this.cellEditors[0] = new DefaultCellEditor(this.defaultTextField);
            this.noEditTextField.setEditable(false);
            this.cellEditors[2] = new DefaultCellEditor(this.noEditTextField);
            this.cellEditorID = 0;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currObj = value;
            if (value instanceof Boolean) {
                this.cellEditorID = 1;
                this.boolComboBox.setSelectedItem(value.toString());
            } else {
                this.cellEditorID = 0;
            }
            return this.cellEditors[this.cellEditorID].getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            switch (this.cellEditorID) {
                case 1: {
                    return new Boolean((String)this.boolComboBox.getSelectedItem());
                }
                case 2: {
                    return this.currObj;
                }
            }
            try {
                Object o = this.cellEditors[this.cellEditorID].getCellEditorValue();
                if (this.currObj instanceof String) {
                    return o;
                }
                if (this.currObj instanceof Integer) {
                    return new Integer((String)o);
                }
                if (this.currObj instanceof Long) {
                    return new Long((String)o);
                }
                if (this.currObj instanceof Short) {
                    return new Short((String)o);
                }
                if (this.currObj instanceof Byte) {
                    return new Byte((String)o);
                }
                if (this.currObj instanceof Float) {
                    return new Float((String)o);
                }
                if (this.currObj instanceof Double) {
                    return new Double((String)o);
                }
                return o;
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(null, exc.getMessage(), "Error", 1);
                System.err.println("Exception: " + exc.getMessage());
                return this.currObj;
            }
        }

        public Component getComponent() {
            return this.cellEditors[this.cellEditorID].getComponent();
        }

        @Override
        public boolean stopCellEditing() {
            return this.cellEditors[this.cellEditorID].stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.cellEditors[this.cellEditorID].cancelCellEditing();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.cellEditors[this.cellEditorID].isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.cellEditors[this.cellEditorID].shouldSelectCell(anEvent);
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.cellEditors[this.cellEditorID].addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.cellEditors[this.cellEditorID].removeCellEditorListener(l);
        }

        public void setClickCountToStart(int n) {
            this.cellEditors[this.cellEditorID].setClickCountToStart(n);
        }

        public int getClickCountToStart() {
            return this.cellEditors[this.cellEditorID].getClickCountToStart();
        }
    }

    class MultiRenderer
    extends DefaultTableCellRenderer {
        public MultiRenderer() {
            if (GemsPropertyTableModel.this.m_isEditable) {
                this.setToolTipText(GemsPropertyTableModel.this.getToolTip());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

