/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.admin.DestinationInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;

public abstract class GemsPurgeBase
extends JDialog {
    JFrame m_frame;
    JPanel m_panel;
    GemsConnectionNode m_cn;
    protected String m_type;
    protected JTextField m_conn;
    protected JTextField m_pattern;
    protected JButton m_startButton;
    protected JButton m_stopButton;
    protected JButton m_lookup;
    JTable m_table;
    protected GemsDestTableModel m_tableModel;
    TableSorter m_sorter;

    public GemsPurgeBase(JFrame f, GemsConnectionNode cn, String type, String pattern) {
        super(f, Gems.getGems().getTitlePrefix() + "Purge " + type + "s", true);
        this.setLocationRelativeTo(f);
        this.setDefaultCloseOperation(2);
        this.m_frame = f;
        this.m_cn = cn;
        this.m_type = type;
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 20);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JPanel spanel = new JPanel(true);
        spanel.setLayout(new BoxLayout(spanel, 0));
        spanel.setMinimumSize(new Dimension(300, 24));
        JLabel l5 = new JLabel(type + " Pattern:", 11);
        this.m_pattern = new JTextField(pattern, 32);
        l5.setLabelFor(this.m_pattern);
        panel.add(l5);
        spanel.add(this.m_pattern);
        this.m_lookup = new JButton("LookUp");
        this.m_lookup.addActionListener(new LookupAction());
        spanel.add(this.m_lookup);
        panel.add(spanel);
        this.m_tableModel = new GemsDestTableModel(false, true);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.setRowSelectionAllowed(false);
        this.m_tableModel.m_table = this.m_table;
        this.addMouseListenerToTable(this.m_table);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(635, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(225, 10));
        bpanel.add(bx);
        this.m_startButton = new JButton("Purge");
        this.m_startButton.addActionListener(new StartPressed());
        this.m_stopButton = new JButton("Cancel");
        this.m_stopButton.addActionListener(new StopPressed());
        bpanel.add(this.m_startButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_stopButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 2, 2, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.pack();
        this.show();
    }

    public void start() {
        this.purgeDestinations(this.m_tableModel.getSelectedDestinations());
        this.m_tableModel.populateDestinationInfo(this.getDestinationInfo());
    }

    public void stop() {
        this.dispose();
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && GemsPurgeBase.this.m_table.getSelectedColumn() > 0) {
                    GemsPurgeBase.this.m_tableModel.toggleSelectedRow();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsPurgeBase.this.dispose();
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuBar.add(menu);
        menuItem = new JMenuItem("Select All");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menuItem.addActionListener(new SelectAllAction());
        menu.add(menuItem);
        return menuBar;
    }

    public abstract DestinationInfo[] getDestinationInfo();

    public abstract void purgeDestinations(Vector var1);

    @Override
    public void dispose() {
        super.dispose();
    }

    class SelectAllAction
    implements ActionListener {
        SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsPurgeBase.this.m_tableModel.selectAllRows();
        }
    }

    class LookupAction
    implements ActionListener {
        LookupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsPurgeBase.this.m_tableModel.buildColumnHeaders();
            GemsPurgeBase.this.m_sorter.setSortingStatus(3, -1);
            GemsPurgeBase.this.m_tableModel.populateDestinationInfo(GemsPurgeBase.this.getDestinationInfo());
        }
    }

    class StopPressed
    implements ActionListener {
        StopPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsPurgeBase.this.stop();
        }
    }

    class StartPressed
    implements ActionListener {
        StartPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsPurgeBase.this.start();
        }
    }
}

