/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsBrowserFilterDialog;
import com.tibco.gems.GemsBrowserOptionsDialog;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsMessageCopier;
import com.tibco.gems.GemsMessageDestroyer;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsMessageTableModel;
import com.tibco.gems.GemsSelectorWizardDialog;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.TibjmsQueueConnectionFactory;
import com.tibco.tibjms.admin.TibjmsAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.text.DefaultEditorKit;

public class GemsQueueBrowser
extends JFrame {
    JFrame m_frame;
    JPanel m_panel;
    boolean m_running = false;
    int m_msgs = 0;
    int m_browsedMsgs = 0;
    int m_maxMsgs = 10;
    Message m_msg = null;
    TibjmsAdmin m_admin = null;
    QueueSession m_session = null;
    GemsConnectionNode m_cn;
    QueueConnection m_connection = null;
    QueueBrowser m_browser = null;
    Enumeration m_msgsEnum = null;
    Pattern m_pattern = null;
    Timer m_timer = new Timer(Gems.getGems().getMsgReadDelay(), new RefreshTimerAction());
    protected JTextField m_conn;
    protected JTextField m_queue;
    protected JTextField m_msgsRead;
    protected JTextField m_msgsDisplay;
    protected JTextField m_selector;
    protected JButton m_startButton;
    protected JButton m_stopButton;
    protected JButton m_nextButton;
    protected JButton m_selwiz;
    protected JButton m_destwiz;
    protected JCheckBox m_noLimit;
    protected JLabel m_status = new JLabel();
    JTable m_table;
    protected GemsMessageTableModel m_tableModel;
    protected boolean m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
    protected JMenuItem m_optMenuItem;
    protected JMenuItem m_filterMenuItem;
    protected JMenuItem m_selectorMenuItem;
    protected JMenuItem m_dumpMenuItem;
    TableSorter m_sorter;
    String m_prefix = "";

    public GemsQueueBrowser(GemsConnectionNode cn, String queue, String prefix) {
        super(Gems.getGems().getTitlePrefix() + "Queue Browser");
        this.setLocation(400, 175);
        this.setDefaultCloseOperation(2);
        this.m_frame = this;
        this.m_cn = cn;
        this.m_prefix = prefix;
        if (queue == null) {
            queue = "";
        }
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 20);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JPanel qpanel = new JPanel(true);
        qpanel.setLayout(new BoxLayout(qpanel, 0));
        JLabel l2 = new JLabel("Queue Name:", 11);
        this.m_queue = new JTextField(prefix + queue, 20);
        if (Gems.getGems().getQueueNamePattern().length() > 1 && Gems.getGems().getViewOnlyMode()) {
            this.m_queue.setEditable(false);
        }
        l2.setLabelFor(this.m_queue);
        panel.add(l2);
        qpanel.add(this.m_queue);
        this.m_destwiz = new JButton("...");
        this.m_destwiz.setPreferredSize(new Dimension(18, 16));
        this.m_destwiz.addActionListener(new DestinationWizardAction());
        qpanel.add(this.m_destwiz);
        panel.add(qpanel);
        JPanel spanel = new JPanel(true);
        spanel.setLayout(new BoxLayout(spanel, 0));
        spanel.setMinimumSize(new Dimension(140, 24));
        JLabel l5 = new JLabel("Selector:", 11);
        this.m_selector = new JTextField("", 20);
        l5.setLabelFor(this.m_selector);
        panel.add(l5);
        spanel.add(this.m_selector);
        this.m_selwiz = new JButton("...");
        this.m_selwiz.setPreferredSize(new Dimension(18, 16));
        this.m_selwiz.addActionListener(new SelectorWizardAction());
        spanel.add(this.m_selwiz);
        panel.add(spanel);
        JPanel mpanel = new JPanel(true);
        mpanel.setLayout(new BoxLayout(mpanel, 0));
        JLabel l9 = new JLabel("Msgs to Read:", 11);
        this.m_msgsRead = new JTextField("10", 20);
        this.m_msgsRead.setMinimumSize(new Dimension(40, 24));
        spanel.setMinimumSize(new Dimension(140, 24));
        l9.setLabelFor(this.m_msgsRead);
        panel.add(l9);
        panel.add(this.m_msgsRead);
        this.m_noLimit = new JCheckBox("No Limit", false);
        this.m_tableModel = new GemsMessageTableModel(false, true);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.setSelectionMode(0);
        this.m_tableModel.m_table = this.m_table;
        this.addMouseListenerToTable(this.m_table);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(975, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(400, 10));
        bpanel.add(bx);
        this.m_startButton = new JButton("Start");
        this.m_startButton.addActionListener(new StartPressed());
        this.m_stopButton = new JButton("Stop");
        this.m_stopButton.addActionListener(new StopPressed());
        this.m_stopButton.setEnabled(false);
        this.m_nextButton = new JButton("Next");
        this.m_nextButton.addActionListener(new NextPressed());
        this.m_nextButton.setEnabled(false);
        bpanel.add(this.m_startButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_stopButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_nextButton);
        bpanel.add(Box.createHorizontalGlue());
        bpanel.add(this.m_status);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 2, 4, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.pack();
        this.show();
    }

    public GemsQueueBrowser(GemsConnectionNode cn, String queue) {
        this(cn, queue, new String());
    }

    public void start() {
        this.m_running = true;
        this.m_msgs = 0;
        this.m_browsedMsgs = 0;
        this.m_queue.setEnabled(false);
        this.m_msgsRead.setEnabled(false);
        this.m_startButton.setEnabled(false);
        this.m_nextButton.setEnabled(false);
        this.m_stopButton.setEnabled(true);
        this.m_noLimit.setEnabled(false);
        this.m_selector.setEnabled(false);
        this.m_filterMenuItem.setEnabled(false);
        this.m_selwiz.setEnabled(false);
        this.m_destwiz.setEnabled(false);
        this.m_optMenuItem.setEnabled(false);
        this.m_selectorMenuItem.setEnabled(false);
        this.m_dumpMenuItem.setEnabled(false);
        this.m_status.setText("");
        try {
            this.m_maxMsgs = Integer.parseInt(this.m_msgsRead.getText());
        }
        catch (Exception ie) {
            this.m_maxMsgs = 10;
        }
        if (this.m_maxMsgs > Gems.getGems().getMaxMonitorEvents()) {
            JOptionPane.showMessageDialog(this.m_frame, "Max monitor events is " + Gems.getGems().getMaxMonitorEvents(), "Error", 1);
            this.m_maxMsgs = Gems.getGems().getMaxMonitorEvents();
            this.m_msgsRead.setText(String.valueOf(this.m_maxMsgs));
        }
        this.m_tableModel.buildColumnHeaders();
        try {
            TibjmsQueueConnectionFactory factory = new TibjmsQueueConnectionFactory(this.m_cn.m_url, null, this.m_cn.m_sslParams);
            this.m_connection = factory.createQueueConnection(this.m_cn.m_user, this.m_cn.m_password);
            this.m_session = this.m_connection.createQueueSession(false, 1);
            Queue queue = this.m_session.createQueue(this.m_queue.getText());
            this.m_connection.start();
            this.m_browser = this.m_selector != null && this.m_selector.getText().length() > 0 ? this.m_session.createBrowser(queue, this.m_selector.getText()) : this.m_session.createBrowser(queue);
            this.m_msgsEnum = this.m_browser.getEnumeration();
            this.m_timer.start();
        }
        catch (JMSException e) {
            JOptionPane.showMessageDialog(this.m_frame, e.getMessage(), "Error", 1);
            this.stop();
        }
    }

    public void stop() {
        this.m_timer.stop();
        this.m_running = false;
        try {
            this.m_msgsEnum = null;
            if (this.m_browser != null) {
                this.m_browser.close();
                this.m_browser = null;
            }
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (JMSException e) {
            System.err.println("Exception: " + e.getMessage());
        }
        this.m_queue.setEnabled(true);
        this.m_msgsRead.setEnabled(true);
        this.m_startButton.setEnabled(true);
        this.m_stopButton.setEnabled(false);
        this.m_nextButton.setEnabled(false);
        this.m_noLimit.setEnabled(true);
        this.m_selector.setEnabled(true);
        this.m_selwiz.setEnabled(true);
        this.m_destwiz.setEnabled(true);
        this.m_optMenuItem.setEnabled(true);
        this.m_filterMenuItem.setEnabled(true);
        this.m_selectorMenuItem.setEnabled(true);
        this.m_dumpMenuItem.setEnabled(true);
        this.m_status.setText("Browsed " + this.m_browsedMsgs + " messages ");
    }

    public void prepareNext() {
        this.m_timer.stop();
        this.m_running = false;
        this.m_queue.setEnabled(false);
        this.m_msgsRead.setEnabled(false);
        this.m_startButton.setEnabled(false);
        this.m_nextButton.setEnabled(true);
        this.m_stopButton.setEnabled(true);
        this.m_noLimit.setEnabled(false);
        this.m_selector.setEnabled(false);
        this.m_filterMenuItem.setEnabled(false);
        this.m_selwiz.setEnabled(false);
        this.m_destwiz.setEnabled(false);
        this.m_optMenuItem.setEnabled(false);
        this.m_selectorMenuItem.setEnabled(false);
        this.m_dumpMenuItem.setEnabled(false);
        this.m_status.setText("Browsed " + this.m_browsedMsgs + " messages ");
    }

    public void next() {
        this.m_tableModel.buildColumnHeaders();
        this.m_running = true;
        this.m_msgs = 0;
        this.m_timer.start();
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GemsQueueBrowser.this.showMessageFrame();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        this.m_dumpMenuItem = new JMenuItem("Save Messages To File...");
        this.m_dumpMenuItem.addActionListener(new DumpToFile());
        menu.add(this.m_dumpMenuItem);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsQueueBrowser.this.dispose();
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem("Select All");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menuItem.addActionListener(new SelectAllAction());
        menu.add(menuItem);
        menu.addSeparator();
        this.m_selectorMenuItem = menu.add(new JMenuItem("Selector..."));
        this.m_selectorMenuItem.addActionListener(new SelectorWizardAction());
        this.m_filterMenuItem = menu.add(new JMenuItem("TextMessage Filter..."));
        this.m_filterMenuItem.addActionListener(new FilterWizardAction());
        this.m_optMenuItem = menu.add(new JMenuItem("Options..."));
        this.m_optMenuItem.addActionListener(new EditOptionsAction());
        menuBar.add(menu);
        menu = new JMenu("Message");
        menu.setMnemonic(77);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("View Message..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsQueueBrowser.this.showMessageFrame();
            }
        });
        if (!Gems.getGems().getViewOnlyMode()) {
            menuItem = menu.add(new JMenuItem("Copy Checked Messages..."));
            menuItem.addActionListener(new CopyMessageAction());
            menuItem = menu.add(new JMenuItem("Destroy Checked Messages..."));
            menuItem.addActionListener(new DestroyMessageAction());
        }
        return menuBar;
    }

    public void showMessageFrame() {
        Message m = this.m_tableModel.getSelectedMessage();
        if (m != null) {
            GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, null, true, null, false);
            f.populate(m);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "Select a Message to view!", "View Message", 1);
        }
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    class DumpToFile
    implements ActionListener {
        DumpToFile() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Save Messages To File (appends)");
                int returnVal = chooser.showOpenDialog(GemsQueueBrowser.this.m_frame);
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    GemsQueueBrowser.this.m_tableModel.dumpMsgsToFile(f, GemsQueueBrowser.this.m_viewoldestFirst);
                }
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(GemsQueueBrowser.this.m_frame, ie.getMessage(), "Error", 1);
                return;
            }
        }
    }

    class SelectAllAction
    implements ActionListener {
        SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsQueueBrowser.this.m_tableModel.selectAllRows();
        }
    }

    class DestroyMessageAction
    implements ActionListener {
        DestroyMessageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Vector m = GemsQueueBrowser.this.m_tableModel.getSelectedMessages();
            if (m.size() == 0) {
                JOptionPane.showMessageDialog(GemsQueueBrowser.this.m_frame, "Select Messages to destroy using checkbox!", "Destroy Messages", 1);
            }
            if (m.size() > 0) {
                GemsMessageDestroyer gemsMessageDestroyer = new GemsMessageDestroyer((Frame)GemsQueueBrowser.this.m_frame, GemsQueueBrowser.this.m_cn, m, GemsQueueBrowser.this.m_queue.getText());
            }
        }
    }

    class CopyMessageAction
    implements ActionListener {
        CopyMessageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Vector m = GemsQueueBrowser.this.m_tableModel.getSelectedMessages();
            if (m.size() == 0) {
                JOptionPane.showMessageDialog(GemsQueueBrowser.this.m_frame, "Select Messages to copy using checkbox!", "Copy Messages", 1);
            }
            if (m.size() > 0) {
                GemsMessageCopier gemsMessageCopier = new GemsMessageCopier(GemsQueueBrowser.this.m_frame, GemsQueueBrowser.this.m_cn, GemsQueueBrowser.this.m_queue.getText(), "Queue", m);
            }
        }
    }

    class FilterWizardAction
    implements ActionListener {
        FilterWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsBrowserFilterDialog dp = new GemsBrowserFilterDialog((Frame)GemsQueueBrowser.this.m_frame, "TextMessage Filter Editor:");
            Pattern p = dp.getFilter(GemsQueueBrowser.this.m_pattern, "messages");
            if (!dp.m_cancelled) {
                GemsQueueBrowser.this.m_pattern = p;
            }
            if (GemsQueueBrowser.this.m_pattern != null && GemsQueueBrowser.this.m_pattern.pattern().length() == 0) {
                GemsQueueBrowser.this.m_pattern = null;
            }
        }
    }

    class DestinationWizardAction
    implements ActionListener {
        DestinationWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsQueueBrowser.this.m_frame, GemsQueueBrowser.this.m_cn, GemsDestination.DEST_TYPE.Queue, GemsQueueBrowser.this.m_prefix + ">");
            if (dp.m_retDest != null) {
                GemsQueueBrowser.this.m_queue.setText(dp.m_retDest.m_destName);
            }
        }
    }

    class SelectorWizardAction
    implements ActionListener {
        SelectorWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsSelectorWizardDialog dp = new GemsSelectorWizardDialog((Frame)GemsQueueBrowser.this.m_frame, "Selector Editor:", "Browse");
            if (!dp.m_cancelled && dp.m_selector.length() > 0) {
                GemsQueueBrowser.this.m_selector.setText(dp.m_selector);
            }
        }
    }

    class EditOptionsAction
    implements ActionListener {
        EditOptionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new GemsBrowserOptionsDialog((Frame)GemsQueueBrowser.this.m_frame, "Edit Queue Browser Options");
            GemsQueueBrowser.this.m_timer.setDelay(Gems.getGems().getMsgReadDelay());
            GemsQueueBrowser.this.m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
        }
    }

    class NextPressed
    implements ActionListener {
        NextPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsQueueBrowser.this.next();
        }
    }

    class StopPressed
    implements ActionListener {
        StopPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsQueueBrowser.this.stop();
        }
    }

    class StartPressed
    implements ActionListener {
        StartPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsQueueBrowser.this.start();
        }
    }

    class RefreshTimerAction
    implements ActionListener {
        RefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsQueueBrowser.this.m_running) {
                if (!GemsQueueBrowser.this.m_msgsEnum.hasMoreElements()) {
                    GemsQueueBrowser.this.stop();
                } else {
                    Message message = (Message)GemsQueueBrowser.this.m_msgsEnum.nextElement();
                    if (message != null) {
                        ++GemsQueueBrowser.this.m_browsedMsgs;
                        try {
                            if (GemsQueueBrowser.this.m_pattern != null && message instanceof TextMessage && !GemsQueueBrowser.this.m_pattern.matcher(((TextMessage)message).getText()).matches()) {
                                return;
                            }
                        }
                        catch (JMSException ex) {
                            System.err.println("Exception: " + ex.getMessage());
                            return;
                        }
                        GemsQueueBrowser.this.m_tableModel.addMessage(message, GemsQueueBrowser.this.m_viewoldestFirst);
                        if (!GemsQueueBrowser.this.m_noLimit.isSelected() && ++GemsQueueBrowser.this.m_msgs >= GemsQueueBrowser.this.m_maxMsgs) {
                            if (GemsQueueBrowser.this.m_msgsEnum.hasMoreElements()) {
                                GemsQueueBrowser.this.prepareNext();
                            } else {
                                GemsQueueBrowser.this.stop();
                            }
                        }
                    }
                }
            }
        }
    }
}

