/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsIconNode;
import com.tibco.gems.GemsProperty;
import com.tibco.gems.GemsSetPropDialog;
import com.tibco.tibjms.admin.QueueInfo;
import com.tibco.tibjms.admin.TibjmsAdminException;
import java.awt.Frame;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GemsQueueNode
extends GemsIconNode {
    static Hashtable props = null;

    public static synchronized void init() {
        if (props == null) {
            try {
                props = new Hashtable();
                props.put("isGlobal", new GemsProperty("Global", Boolean.TYPE, "<html>Enables or disables global routing of messages<br>on this destination</html>"));
                props.put("isFailsafe", new GemsProperty("Failsafe", Boolean.TYPE, "<html>Whether the server writes persistent messages<br>to disk synchronously (pre EMS5.0 only)</html>"));
                props.put("isSecure", new GemsProperty("Secure", Boolean.TYPE, "<html>Whether the server checks user permissions<br> on the destination</html>"));
                props.put("FlowControl", new GemsProperty("FlowControlMaxBytes", Long.TYPE, "<html>The target maximum size (bytes) the server<br>can use to store pending messages</html>"));
                props.put("MaxBytes", new GemsProperty("MaxBytes", Long.TYPE, "<html>The maximum size (in bytes) that the destination<br>can store, summed over all messages</html>"));
                props.put("isSenderName", new GemsProperty("SenderName", Boolean.TYPE, "<html>Whether the server may include the sender's<br>username for messages sent to this destination</html>"));
                props.put("isSenderNameEnforced", new GemsProperty("SenderNameEnforced", Boolean.TYPE, "<html>Whether the server must include the sender's<br>username for messages sent to this destination</html>"));
                props.put("MsgTrace", new GemsProperty("MsgTrace", Byte.TYPE, "<html>Set the level of message tracing<br>0 = none, 1 = basic, 3 = detail</html>"));
                props.put("Prefetch", new GemsProperty("Prefetch", Integer.TYPE, "<html>Number of messages prefetched by consumers<br>of this destination (0 = default, -1 = none)</html>"));
                props.put("MaxRedelivery", new GemsProperty("MaxRedelivery", Integer.TYPE, "<html>The number of attempts the server should make<br>to redeliver a message (0 = no limit)</html>"));
                props.put("isExclusive", new GemsProperty("Exclusive", Boolean.TYPE, "<html>Whether the server sends all messages on<br>the queue to one consumer</html>"));
                props.put("ExpiryOverride", new GemsProperty("ExpiryOverride", Long.TYPE, "<html>The expiry override for this destination<br>in millisecs (0 = disable override)</html>"));
                props.put("OverflowPolicy", new GemsProperty("OverflowPolicy", Integer.TYPE, "<html>Behaviour when message capacity is exceeded<br>0 = default, 1 = discardOld, 2 = rejectIncoming</html>"));
                props.put("MaxMsgs", new GemsProperty("MaxMsgs", Long.TYPE, "<html>The maximum number of messages that can be<br>waiting on a destination</html>"));
                props.put("Store", new GemsProperty("Store", Class.forName("java.lang.String"), "<html>Where messages on this destination are stored<br>First stop the flow of incoming messages!</html>"));
                props.put("RedeliveryDelay", new GemsProperty("RedeliveryDelay", Long.TYPE, "<html>The interval (millis) before returning an unacknowledged<br>message to the queue. 0 = no redelivery delay</html>"));
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
    }

    public GemsQueueNode(String name) {
        super(name, false);
        GemsQueueNode.init();
        this.setAllowsChildren(false);
        if (Gems.getGems().m_useMetalIcons) {
            this.setIconName("queue");
        }
    }

    public GemsQueueNode(String name, boolean routed) {
        super(name, false);
        GemsQueueNode.init();
        if (Gems.getGems().m_useMetalIcons) {
            if (routed) {
                this.setIconName("routedqueue");
            } else {
                this.setIconName("queue");
            }
        }
    }

    public boolean hasMessages() {
        return false;
    }

    public Vector getMessages() {
        return null;
    }

    public static void setProperty(JFrame frame, GemsConnectionNode cn, String prop, String queue) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        GemsQueueNode.init();
        try {
            GemsSetPropDialog pd;
            String val;
            GemsProperty p = null;
            String pval = null;
            QueueInfo ti = cn.m_adminConn.getQueue(queue);
            if (ti == null) {
                return;
            }
            if (prop != null && (p = (GemsProperty)props.get(prop)) != null) {
                pval = p.getValue(ti);
            }
            if ((val = (pd = new GemsSetPropDialog((Frame)frame, "Set Property on Queue " + queue)).getValue(props, prop, pval)) != null) {
                p = (GemsProperty)props.get(pd.getSelectedProp());
                p.setValue(ti, val);
                cn.m_adminConn.updateQueue(ti);
                Gems.getGems().scheduleRepaint();
            }
        }
        catch (TibjmsAdminException e) {
            JOptionPane.showMessageDialog(frame, e.getMessage(), "Set Queue Property", 0);
            return;
        }
    }

    public void setProperty(GemsConnectionNode cn, String prop) {
        if (cn == null || cn.m_adminConn == null) {
            return;
        }
        try {
            GemsSetPropDialog pd;
            String val;
            GemsProperty p = null;
            String pval = null;
            QueueInfo ti = cn.m_adminConn.getQueue((String)this.getUserObject());
            if (ti == null) {
                return;
            }
            if (prop != null && (p = (GemsProperty)props.get(prop)) != null) {
                pval = p.getValue(ti);
            }
            if ((val = (pd = new GemsSetPropDialog((Frame)Gems.getGems().m_frame, "Set Property on Queue " + (String)this.getUserObject())).getValue(props, prop, pval)) != null) {
                p = (GemsProperty)props.get(pd.getSelectedProp());
                p.setValue(ti, val);
                cn.m_adminConn.updateQueue(ti);
                Gems.getGems().scheduleRepaint();
            }
        }
        catch (TibjmsAdminException e) {
            JOptionPane.showMessageDialog(Gems.getGems().m_frame, e.getMessage(), "Set Queue Property", 0);
            return;
        }
    }
}

