/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.GemsMessageTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.tibjms.Tibjms;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;

public class GemsReqReplyMessageTableModel
extends GemsMessageTableModel {
    Hashtable m_replymsgs = null;

    public GemsReqReplyMessageTableModel(boolean editable, boolean showCheckbox) {
        super(editable, showCheckbox);
    }

    public Message getSelectedReplyMessage() {
        if (this.m_replymsgs == null) {
            return null;
        }
        if (this.m_table.getSelectedRow() < 0) {
            return null;
        }
        Message r = null;
        String idx = (String)this.m_table.getValueAt(this.m_table.getSelectedRow(), 4);
        if (idx != null) {
            r = (Message)this.m_replymsgs.get(idx);
        }
        if (r == null && (idx = (String)this.m_table.getValueAt(this.m_table.getSelectedRow(), 5)) != null) {
            r = (Message)this.m_replymsgs.get(idx);
        }
        return r;
    }

    public Message getReplyMessageAt(int row) {
        if (this.m_replymsgs == null) {
            return null;
        }
        Message r = null;
        String idx = (String)this.m_table.getValueAt(row, 4);
        if (idx != null) {
            r = (Message)this.m_replymsgs.get(idx);
        }
        if (r == null && (idx = (String)this.m_table.getValueAt(row, 5)) != null) {
            r = (Message)this.m_replymsgs.get(idx);
        }
        return r;
    }

    public Message getReplyMessageFor(String msgId) {
        if (this.m_replymsgs == null) {
            return null;
        }
        Message r = null;
        if (msgId != null) {
            r = (Message)this.m_replymsgs.get(msgId);
        }
        return r;
    }

    public Message getNextPendingRequest(boolean oldestFirst) {
        if (this.m_msgs == null) {
            return null;
        }
        if (oldestFirst) {
            for (int r = 0; r < this.m_table.getRowCount(); ++r) {
                String v = (String)this.m_table.getValueAt(r, 2);
                if (!v.startsWith("pending")) continue;
                return (Message)this.m_msgs.get((String)this.m_table.getValueAt(r, 0));
            }
        } else {
            for (int r = this.m_table.getRowCount() - 1; r >= 0; --r) {
                String v = (String)this.m_table.getValueAt(r, 2);
                if (!v.startsWith("pending")) continue;
                return (Message)this.m_msgs.get((String)this.m_table.getValueAt(r, 0));
            }
        }
        return null;
    }

    @Override
    public void buildColumnHeaders() {
        this.setRowCount(0);
        this.setColumnCount(0);
        this.m_msgs.clear();
        if (this.m_replymsgs == null) {
            this.m_replymsgs = new Hashtable();
        }
        this.m_replymsgs.clear();
        this.m_table.setAutoResizeMode(0);
        this.m_table.setDefaultRenderer(Object.class, this.m_renderer);
        this.m_table.setDefaultRenderer(String.class, this.m_renderer);
        this.m_table.setDefaultRenderer(Date.class, this.m_renderer);
        this.m_table.setDefaultRenderer(Boolean.class, this.m_checkRenderer);
        Object[] cols = new String[]{"RequestMessageID", "Timestamp", "ResponseTime(ms)", "Destination", "CorrelationID", "ReplyTo", "ReqMsgSize", "ReplyMsgSize"};
        this.setColumnIdentifiers(cols);
        if (this.m_showCheckbox) {
            this.m_table.getColumn("").setPreferredWidth(30);
        }
        this.m_table.getColumn("RequestMessageID").setPreferredWidth(220);
        this.m_table.getColumn("Destination").setPreferredWidth(150);
        this.m_table.getColumn("ReplyTo").setPreferredWidth(150);
        this.m_table.getColumn("ReplyMsgSize").setPreferredWidth(100);
        this.m_table.getColumn("ResponseTime(ms)").setPreferredWidth(120);
        this.m_table.getColumn("CorrelationID").setPreferredWidth(100);
        this.m_table.getColumn("Timestamp").setPreferredWidth(200);
    }

    public void updateRequestMessage(Message m, Message rp) {
        try {
            String id = m.getJMSMessageID();
            for (int r = 0; r < this.m_table.getRowCount(); ++r) {
                String v = (String)this.m_table.getValueAt(r, 0);
                String replysize = GemsUtilities.getHumanReadableSize(Tibjms.getMessageSize((Message)rp));
                if (!v.equals(id)) continue;
                long rt = rp.getJMSTimestamp() - m.getJMSTimestamp();
                this.m_table.setValueAt(rt < 0L ? "N/A" : String.valueOf(rt), r, 2);
                this.m_table.setValueAt(replysize, r, 7);
                String cid = m.getJMSCorrelationID();
                if (cid == null) {
                    cid = m.getStringProperty("arseq");
                }
                if (cid != null && cid.length() > 0) {
                    this.m_replymsgs.put(cid, rp);
                } else {
                    String tar = m.getJMSReplyTo().toString();
                    if (tar != null && tar.length() > 0) {
                        this.m_replymsgs.put(tar, rp);
                    } else {
                        System.err.println("GemsReqReplyMonitor.updateRequestMessage: Could not update request " + m.getJMSMessageID());
                    }
                }
                break;
            }
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void timeoutRequestMessage(Message m) {
        try {
            String id = m.getJMSMessageID();
            for (int r = 0; r < this.m_table.getRowCount(); ++r) {
                String v = (String)this.m_table.getValueAt(r, 0);
                if (!v.equals(id)) continue;
                this.m_table.setValueAt("no reply", r, 2);
                break;
            }
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    public void addRequestMessage(Message m, Message rep, boolean oldestFirst) {
        Date d = new Date();
        try {
            if (m != null) {
                if (m.getJMSMessageID() == null) {
                    m.setJMSMessageID("tmpId" + String.valueOf(++s_msgId));
                }
                this.m_msgs.put(m.getJMSMessageID(), m);
                String cid = m.getJMSCorrelationID();
                if (cid == null) {
                    cid = m.getStringProperty("arseq");
                }
                if (rep != null) {
                    if (cid != null && cid.length() > 0) {
                        this.m_replymsgs.put(cid, rep);
                    } else {
                        String tar = m.getJMSReplyTo().toString();
                        if (tar != null && tar.length() > 0) {
                            this.m_replymsgs.put(tar, rep);
                        }
                    }
                }
                String dm = m.getJMSDeliveryMode() == 2 ? "PERSISTENT" : (m.getJMSDeliveryMode() == 1 ? "NON_PERSISTENT" : "RELIABLE");
                long rt = -99L;
                String replysize = "";
                if (rep != null) {
                    rt = rep.getJMSTimestamp() - m.getJMSTimestamp();
                    replysize = GemsUtilities.getHumanReadableSize(Tibjms.getMessageSize((Message)rep));
                }
                d.setTime(m.getJMSTimestamp());
                if (m.getJMSMessageID() == null) {
                    m.setJMSMessageID("tmpId" + String.valueOf(++s_msgId));
                }
                Object[] r = new Object[]{m.getJMSMessageID(), d, rt == -99L ? "pending..." : (rt < 0L ? "N/A" : String.valueOf(rt)), m.getJMSDestination().toString(), cid, m.getJMSReplyTo() != null ? m.getJMSReplyTo().toString() : "", GemsUtilities.getHumanReadableSize(Tibjms.getMessageSize((Message)m)), replysize};
                if (oldestFirst) {
                    this.addRow(r);
                } else {
                    this.insertRow(0, r);
                }
            } else {
                System.err.println("Empty message!");
            }
        }
        catch (JMSException e) {
            System.err.println("JMSException: " + e.getMessage());
            return;
        }
    }

    void dumpMsgsToFile(File f) throws IOException {
        FileOutputStream fout = new FileOutputStream(f, true);
        PrintStream p = new PrintStream(fout);
        for (int r = 0; r < this.m_table.getRowCount(); ++r) {
            String id = this.m_showCheckbox ? (String)this.m_table.getValueAt(r, 1) : (String)this.m_table.getValueAt(r, 0);
            this.writeMessage((Message)this.m_msgs.get(id), p);
            if (this.m_replymsgs == null) continue;
            this.writeMessage(this.getReplyMessageAt(r), p);
        }
        p.close();
    }
}

