/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.gems;

import com.tibco.gems.Gems;
import com.tibco.gems.GemsBrowserOptionsDialog;
import com.tibco.gems.GemsConnectionNode;
import com.tibco.gems.GemsDestination;
import com.tibco.gems.GemsDestinationPicker;
import com.tibco.gems.GemsMessageFrame;
import com.tibco.gems.GemsReqReplyMessageTableModel;
import com.tibco.gems.GemsUtilities;
import com.tibco.gems.TableSorter;
import com.tibco.tibjms.Tibjms;
import com.tibco.tibjms.TibjmsTopicConnectionFactory;
import com.tibco.tibjms.admin.TibjmsAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.text.DefaultEditorKit;

public class GemsReqReplyMonitor
extends JFrame {
    JFrame m_frame;
    JPanel m_panel;
    boolean m_running = false;
    boolean m_useMonitorMsgTimestamp = Gems.getGems().getUseServerTimestamps();
    int m_msgs = 0;
    int m_maxMsgs = 10;
    Message m_msg = null;
    TibjmsAdmin m_admin = null;
    TopicSession m_session = null;
    TopicSession m_replysession = null;
    GemsConnectionNode m_cn;
    TopicConnection m_connection = null;
    TopicSubscriber m_subscriber = null;
    TopicSubscriber m_replySubscriber = null;
    Topic m_replyTopic = null;
    Topic m_reqTopic = null;
    Timer m_timer = new Timer(Gems.getGems().getMsgReadDelay(), new RefreshTimerAction());
    protected JTextField m_conn;
    protected JTextField m_reqDest;
    protected JTextField m_msgsRead;
    protected JTextField m_msgsDisplay;
    protected JTextField m_replyDest;
    protected JButton m_destwiz;
    protected JButton m_startButton;
    protected JButton m_stopButton;
    protected JCheckBox m_noLimit;
    JTable m_table;
    protected GemsReqReplyMessageTableModel m_tableModel;
    protected boolean m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
    protected long m_failCount = Gems.getGems().getRequestReplyTimeout() * 1000 / Gems.getGems().getMsgReadDelay();
    protected JMenuItem m_optMenuItem;
    protected JMenuItem m_dumpMenuItem;
    TableSorter m_sorter;
    boolean m_isQueue = true;
    public Hashtable m_pending = new Hashtable();

    public GemsReqReplyMonitor(GemsConnectionNode cn, String reqDest, boolean isQueue, String title) {
        super(Gems.getGems().getTitlePrefix() + title);
        this.setLocation(400, 175);
        this.setDefaultCloseOperation(2);
        this.m_frame = this;
        this.m_cn = cn;
        this.m_isQueue = isQueue;
        String prefix = isQueue ? "Queue" : "Topic";
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        JPanel m_panel = new JPanel(true);
        m_panel.setLayout(new BorderLayout());
        this.getContentPane().add("Center", m_panel);
        JPanel panel = new JPanel(new SpringLayout(), true);
        m_panel.add((Component)panel, "North");
        JLabel l1 = new JLabel("Server:", 11);
        this.m_conn = new JTextField(cn.getName(), 20);
        this.m_conn.setEditable(false);
        this.m_conn.setMaximumSize(new Dimension(0, 24));
        l1.setLabelFor(this.m_conn);
        panel.add(l1);
        panel.add(this.m_conn);
        JPanel qpanel = new JPanel(true);
        qpanel.setLayout(new BoxLayout(qpanel, 0));
        JLabel l2 = new JLabel("Request " + prefix + " Name:", 11);
        this.m_reqDest = new JTextField(reqDest, 20);
        l2.setLabelFor(this.m_reqDest);
        panel.add(l2);
        qpanel.add(this.m_reqDest);
        this.m_destwiz = new JButton("...");
        this.m_destwiz.setPreferredSize(new Dimension(18, 16));
        this.m_destwiz.addActionListener(new DestinationWizardAction());
        qpanel.add(this.m_destwiz);
        panel.add(qpanel);
        JLabel l5 = new JLabel("Reply " + prefix + " Name:", 11);
        this.m_replyDest = new JTextField("$TMP$.>", 20);
        this.m_replyDest.setMaximumSize(new Dimension(0, 24));
        l5.setLabelFor(this.m_replyDest);
        panel.add(l5);
        panel.add(this.m_replyDest);
        JPanel mpanel = new JPanel(true);
        mpanel.setLayout(new BoxLayout(mpanel, 0));
        JLabel l9 = new JLabel("Requests to Read:", 11);
        this.m_msgsRead = new JTextField("10", 20);
        this.m_msgsRead.setMinimumSize(new Dimension(40, 24));
        mpanel.setPreferredSize(new Dimension(100, 24));
        l9.setLabelFor(this.m_msgsRead);
        panel.add(l9);
        panel.add(this.m_msgsRead);
        this.m_noLimit = new JCheckBox("No Limit", false);
        this.m_tableModel = new GemsReqReplyMessageTableModel(false, false);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_table = new JTable(this.m_sorter);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.setSelectionMode(0);
        this.m_tableModel.m_table = this.m_table;
        this.addMouseListenerToTable(this.m_table);
        JScrollPane spane = new JScrollPane(this.m_table);
        spane.setPreferredSize(new Dimension(480, 300));
        m_panel.add((Component)spane, "Center");
        JPanel bpanel = new JPanel(true);
        bpanel.setLayout(new BoxLayout(bpanel, 0));
        Component bx = Box.createRigidArea(new Dimension(230, 10));
        bpanel.add(bx);
        this.m_startButton = new JButton("Start");
        this.m_startButton.addActionListener(new StartPressed());
        this.m_stopButton = new JButton("Stop");
        this.m_stopButton.addActionListener(new StopPressed());
        this.m_stopButton.setEnabled(false);
        bpanel.add(this.m_startButton);
        bx = Box.createRigidArea(new Dimension(20, 10));
        bpanel.add(bx);
        bpanel.add(this.m_stopButton);
        m_panel.add((Component)bpanel, "South");
        GemsUtilities.makeCompactGrid(panel, 2, 4, 5, 5, 5, 5);
        this.m_frame.setIconImage(Gems.getGems().m_icon.getImage());
        this.pack();
        this.show();
    }

    public void start() {
        if (this.m_reqDest.getText().length() == 0 || this.m_reqDest.getText().equals(">")) {
            JOptionPane.showMessageDialog(this.m_frame, "Invalid request destination", "Error", 1);
            return;
        }
        this.m_running = true;
        this.m_msgs = 0;
        this.m_reqDest.setEnabled(false);
        this.m_msgsRead.setEnabled(false);
        this.m_startButton.setEnabled(false);
        this.m_stopButton.setEnabled(true);
        this.m_noLimit.setEnabled(false);
        this.m_replyDest.setEnabled(false);
        this.m_destwiz.setEnabled(false);
        this.m_optMenuItem.setEnabled(false);
        this.m_dumpMenuItem.setEnabled(false);
        if (this.m_failCount < 2L) {
            this.m_failCount = 2L;
        }
        try {
            this.m_maxMsgs = Integer.parseInt(this.m_msgsRead.getText());
        }
        catch (Exception ie) {
            this.m_maxMsgs = 10;
        }
        if (this.m_maxMsgs > Gems.getGems().getMaxMonitorEvents()) {
            JOptionPane.showMessageDialog(this.m_frame, "Max monitor events is " + Gems.getGems().getMaxMonitorEvents(), "Error", 1);
            this.m_maxMsgs = Gems.getGems().getMaxMonitorEvents();
            this.m_msgsRead.setText(String.valueOf(this.m_maxMsgs));
        }
        this.m_tableModel.buildColumnHeaders();
        try {
            TibjmsTopicConnectionFactory factory = new TibjmsTopicConnectionFactory(this.m_cn.m_url, null, this.m_cn.m_sslParams);
            this.m_connection = factory.createTopicConnection(this.m_cn.m_user, this.m_cn.m_password);
            this.m_session = this.m_connection.createTopicSession(false, 22);
            this.m_replysession = this.m_connection.createTopicSession(false, 22);
            if (this.m_isQueue) {
                this.m_reqTopic = this.m_session.createTopic("$sys.monitor.Q.r." + this.m_reqDest.getText());
                this.m_replyTopic = this.m_replysession.createTopic("$sys.monitor.Q.r." + this.m_replyDest.getText());
            } else {
                this.m_reqTopic = this.m_session.createTopic("$sys.monitor.T.r." + this.m_reqDest.getText());
                this.m_replyTopic = this.m_replysession.createTopic("$sys.monitor.T.r." + this.m_replyDest.getText());
            }
            this.m_replySubscriber = this.m_replysession.createSubscriber(this.m_replyTopic);
            this.m_replySubscriber.setMessageListener((MessageListener)new OnSyncReplyMessage());
            this.m_subscriber = this.m_session.createSubscriber(this.m_reqTopic);
            this.m_connection.start();
            this.m_timer.start();
        }
        catch (JMSException e) {
            JOptionPane.showMessageDialog(this.m_frame, e.getMessage(), "Error", 1);
            this.stop();
        }
    }

    public void stop() {
        this.m_timer.stop();
        this.m_running = false;
        try {
            if (this.m_replySubscriber != null) {
                this.m_replySubscriber.close();
                this.m_replySubscriber = null;
            }
            if (this.m_subscriber != null) {
                this.m_subscriber.close();
                this.m_subscriber = null;
            }
            if (this.m_replysession != null) {
                this.m_replysession.close();
                this.m_replysession = null;
            }
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (JMSException e) {
            System.err.println("Exception: " + e.getMessage());
        }
        this.m_reqDest.setEnabled(true);
        this.m_msgsRead.setEnabled(true);
        this.m_startButton.setEnabled(true);
        this.m_stopButton.setEnabled(false);
        this.m_noLimit.setEnabled(true);
        this.m_replyDest.setEnabled(true);
        this.m_destwiz.setEnabled(true);
        this.m_optMenuItem.setEnabled(true);
        this.m_dumpMenuItem.setEnabled(true);
        this.m_pending.clear();
    }

    public void addMouseListenerToTable(JTable table) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GemsReqReplyMonitor.this.showRequestMessageFrame();
                }
            }
        };
        table.addMouseListener(listMouseListener);
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        this.m_dumpMenuItem = new JMenuItem("Save Messages To File...");
        this.m_dumpMenuItem.addActionListener(new DumpToFile());
        menu.add(this.m_dumpMenuItem);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsReqReplyMonitor.this.dispose();
            }
        });
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menu.add(menuItem);
        menu.addSeparator();
        this.m_optMenuItem = menu.add(new JMenuItem("Options..."));
        this.m_optMenuItem.addActionListener(new EditOptionsAction());
        menuBar.add(menu);
        menu = new JMenu("View");
        menu.setMnemonic(86);
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("View Selected Request Message..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsReqReplyMonitor.this.showRequestMessageFrame();
            }
        });
        menuItem = menu.add(new JMenuItem("View Selected Reply Message..."));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemsReqReplyMonitor.this.showReplyMessageFrame();
            }
        });
        return menuBar;
    }

    public void showReplyMessageFrame() {
        Message m = this.m_tableModel.getSelectedReplyMessage();
        if (m != null) {
            GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, null, true, null, false);
            f.populate(m);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "There is no reply Message to view!", "View Reply Message", 1);
        }
    }

    public void showRequestMessageFrame() {
        Message m = this.m_tableModel.getSelectedMessage();
        if (m != null) {
            GemsMessageFrame f = new GemsMessageFrame(this.m_cn, false, null, true, null, false);
            f.populate(m);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "Select a Message to view!", "View Request Message", 1);
        }
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    class DumpToFile
    implements ActionListener {
        DumpToFile() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setApproveButtonText("Save");
                chooser.setDialogTitle("Save Messages To File (appends)");
                int returnVal = chooser.showOpenDialog(GemsReqReplyMonitor.this.m_frame);
                if (returnVal == 0) {
                    File f = chooser.getSelectedFile();
                    GemsReqReplyMonitor.this.m_tableModel.dumpMsgsToFile(f);
                }
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(GemsReqReplyMonitor.this.m_frame, ie.getMessage(), "Error", 1);
                return;
            }
        }
    }

    class OnSyncReplyMessage
    implements MessageListener {
        OnSyncReplyMessage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message msg) {
            block13: {
                try {
                    String cid;
                    if (msg == null) {
                        return;
                    }
                    MapMessage mapMsg = (MapMessage)msg;
                    if (!mapMsg.itemExists("message_bytes")) break block13;
                    Message msg1 = Tibjms.createFromBytes((byte[])mapMsg.getBytes("message_bytes"));
                    if (GemsReqReplyMonitor.this.m_useMonitorMsgTimestamp) {
                        msg1.setJMSTimestamp(mapMsg.getJMSTimestamp());
                    }
                    if ((cid = msg1.getJMSCorrelationID()) == null) {
                        cid = msg1.getStringProperty("arseq");
                    }
                    if (cid != null && cid.length() > 0) {
                        OnSyncReplyMessage onSyncReplyMessage = this;
                        synchronized (onSyncReplyMessage) {
                            GemsReqReplyMonitor.this.m_pending.put(cid, msg1);
                        }
                        Gems.debug("GemsReqReplyMonitor.onRespMessage: CID: " + cid);
                        break block13;
                    }
                    String tar = msg1.getJMSDestination().toString();
                    if (tar == null || tar.length() <= 0) break block13;
                    if (tar.indexOf("$TMP$") >= 0) {
                        OnSyncReplyMessage onSyncReplyMessage = this;
                        synchronized (onSyncReplyMessage) {
                            GemsReqReplyMonitor.this.m_pending.put(tar, msg1);
                            break block13;
                        }
                    }
                    System.err.println("GemsReqReplyMonitor.onRespMessage: invalid response message, non-temporary replies must set JMSCorrelationID");
                }
                catch (JMSException e) {
                    Gems.debug("GemsReqReplyMonitor.onRespMessage: Exception: " + e.toString());
                }
            }
        }
    }

    class DestinationWizardAction
    implements ActionListener {
        DestinationWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsDestinationPicker dp = new GemsDestinationPicker(GemsReqReplyMonitor.this.m_frame, GemsReqReplyMonitor.this.m_cn, GemsReqReplyMonitor.this.m_isQueue ? GemsDestination.DEST_TYPE.Queue : GemsDestination.DEST_TYPE.Topic);
            if (dp.m_retDest != null) {
                GemsReqReplyMonitor.this.m_reqDest.setText(dp.m_retDest.m_destName);
            }
        }
    }

    class EditOptionsAction
    implements ActionListener {
        EditOptionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new GemsBrowserOptionsDialog(GemsReqReplyMonitor.this.m_frame, "Edit Options", true);
            GemsReqReplyMonitor.this.m_timer.setDelay(Gems.getGems().getMsgReadDelay());
            GemsReqReplyMonitor.this.m_viewoldestFirst = Gems.getGems().getViewOldMessagesFirst();
            GemsReqReplyMonitor.this.m_useMonitorMsgTimestamp = Gems.getGems().getUseServerTimestamps();
            GemsReqReplyMonitor.this.m_failCount = Gems.getGems().getRequestReplyTimeout() * 1000 / Gems.getGems().getMsgReadDelay();
            if (GemsReqReplyMonitor.this.m_failCount < 2L) {
                GemsReqReplyMonitor.this.m_failCount = 2L;
            }
        }
    }

    class StopPressed
    implements ActionListener {
        StopPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsReqReplyMonitor.this.stop();
        }
    }

    class StartPressed
    implements ActionListener {
        StartPressed() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GemsReqReplyMonitor.this.start();
        }
    }

    class RefreshTimerAction
    implements ActionListener {
        String m_lastmid = null;
        int m_repeatcount = 0;
        long m_checkBacklogCount = 0L;

        RefreshTimerAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (GemsReqReplyMonitor.this.m_running) {
                try {
                    Object tar;
                    String cid;
                    MapMessage mapMsg;
                    Message message = GemsReqReplyMonitor.this.m_subscriber.receiveNoWait();
                    if (message != null && (GemsReqReplyMonitor.this.m_noLimit.isSelected() || GemsReqReplyMonitor.this.m_msgs < GemsReqReplyMonitor.this.m_maxMsgs) && (mapMsg = (MapMessage)message).itemExists("message_bytes")) {
                        Message msg = Tibjms.createFromBytes((byte[])mapMsg.getBytes("message_bytes"));
                        if (GemsReqReplyMonitor.this.m_useMonitorMsgTimestamp) {
                            msg.setJMSTimestamp(mapMsg.getJMSTimestamp());
                        }
                        boolean valid = true;
                        cid = msg.getJMSCorrelationID();
                        if (cid == null) {
                            cid = msg.getStringProperty("arseq");
                        }
                        tar = null;
                        Destination replyDest = msg.getJMSReplyTo();
                        if (replyDest != null) {
                            tar = replyDest.toString();
                        }
                        Message reply = null;
                        if (cid != null && cid.length() > 0) {
                            RefreshTimerAction refreshTimerAction = this;
                            synchronized (refreshTimerAction) {
                                reply = (Message)GemsReqReplyMonitor.this.m_pending.remove(cid);
                            }
                        }
                        if (tar != null && ((String)tar).length() > 0 && ((String)tar).indexOf("$TMP$") >= 0) {
                            RefreshTimerAction refreshTimerAction = this;
                            synchronized (refreshTimerAction) {
                                reply = (Message)GemsReqReplyMonitor.this.m_pending.remove(tar);
                            }
                        }
                        String mid = msg.getJMSMessageID();
                        if (reply == null && mid != null) {
                            Gems.debug("GemsReqReplyMonitor.onReqMessage: checking pending replies for request MsgID:" + mid);
                            RefreshTimerAction refreshTimerAction = this;
                            synchronized (refreshTimerAction) {
                                reply = (Message)GemsReqReplyMonitor.this.m_pending.remove(mid);
                            }
                        }
                        if (tar == null || ((String)tar).length() == 0) {
                            Gems.debug("GemsReqReplyMonitor.onReqMessage: request message: " + msg.getJMSMessageID() + "  JMSReplyTo property not set");
                            valid = false;
                        }
                        GemsReqReplyMonitor.this.m_tableModel.addRequestMessage(msg, reply, GemsReqReplyMonitor.this.m_viewoldestFirst);
                        ++GemsReqReplyMonitor.this.m_msgs;
                    }
                    Message pm = null;
                    Message reply = null;
                    pm = GemsReqReplyMonitor.this.m_tableModel.getNextPendingRequest(GemsReqReplyMonitor.this.m_viewoldestFirst);
                    if (pm != null) {
                        String mid = pm.getJMSMessageID();
                        if (this.m_lastmid != null && mid != null && this.m_lastmid.equals(mid)) {
                            if ((long)(++this.m_repeatcount) > GemsReqReplyMonitor.this.m_failCount) {
                                GemsReqReplyMonitor.this.m_tableModel.timeoutRequestMessage(pm);
                                this.m_repeatcount = 0;
                                GemsReqReplyMonitor.this.m_timer.restart();
                                return;
                            }
                        } else {
                            this.m_lastmid = pm.getJMSMessageID();
                            this.m_repeatcount = 0;
                        }
                        if ((cid = pm.getJMSCorrelationID()) == null) {
                            cid = pm.getStringProperty("arseq");
                        }
                        if (cid != null && cid.length() > 0) {
                            tar = this;
                            synchronized (tar) {
                                reply = (Message)GemsReqReplyMonitor.this.m_pending.remove(cid);
                            }
                            if (reply != null) {
                                GemsReqReplyMonitor.this.m_tableModel.updateRequestMessage(pm, reply);
                            }
                        } else {
                            RefreshTimerAction refreshTimerAction;
                            tar = null;
                            if (pm.getJMSReplyTo() != null) {
                                tar = pm.getJMSReplyTo().toString();
                            }
                            if (tar != null && ((String)tar).length() > 0 && ((String)tar).indexOf("$TMP$") >= 0) {
                                refreshTimerAction = this;
                                synchronized (refreshTimerAction) {
                                    reply = (Message)GemsReqReplyMonitor.this.m_pending.remove(tar);
                                }
                                if (reply != null) {
                                    GemsReqReplyMonitor.this.m_tableModel.updateRequestMessage(pm, reply);
                                }
                            }
                            if (reply == null && mid != null) {
                                Gems.debug("GemsReqReplyMonitor.onReqMessage: checking pending request MsgID: " + mid);
                                refreshTimerAction = this;
                                synchronized (refreshTimerAction) {
                                    reply = (Message)GemsReqReplyMonitor.this.m_pending.remove(mid);
                                }
                                if (reply != null) {
                                    GemsReqReplyMonitor.this.m_tableModel.updateRequestMessage(pm, reply);
                                }
                            }
                        }
                    }
                    if (!GemsReqReplyMonitor.this.m_noLimit.isSelected() && GemsReqReplyMonitor.this.m_msgs >= GemsReqReplyMonitor.this.m_maxMsgs && pm == null) {
                        GemsReqReplyMonitor.this.stop();
                    }
                    if (Gems.getGems().getMaxMonitorBacklog() > 0L && ++this.m_checkBacklogCount >= (long)(5000 / Gems.getGems().getMsgReadDelay())) {
                        long backlog = GemsReqReplyMonitor.this.m_pending.size();
                        if (backlog > Gems.getGems().getMaxMonitorBacklog()) {
                            GemsReqReplyMonitor.this.stop();
                            JOptionPane.showMessageDialog(GemsReqReplyMonitor.this.m_frame, "Consumer for monitor topic " + GemsReqReplyMonitor.this.m_replyTopic.getTopicName() + "\nhas a backlog of " + backlog + " messages, monitor will stop.", "Error", 1);
                        }
                        if ((backlog = GemsReqReplyMonitor.this.m_cn.getTopicConsumerBacklog(GemsReqReplyMonitor.this.m_replyTopic.getTopicName())) > Gems.getGems().getMaxMonitorBacklog()) {
                            GemsReqReplyMonitor.this.stop();
                            JOptionPane.showMessageDialog(GemsReqReplyMonitor.this.m_frame, "A consumer for monitor topic " + GemsReqReplyMonitor.this.m_replyTopic.getTopicName() + "\nhas a pending backlog of " + backlog + " messages, monitor will stop.", "Error", 1);
                        }
                        if ((backlog = GemsReqReplyMonitor.this.m_cn.getTopicConsumerBacklog(GemsReqReplyMonitor.this.m_reqTopic.getTopicName())) > Gems.getGems().getMaxMonitorBacklog()) {
                            GemsReqReplyMonitor.this.stop();
                            JOptionPane.showMessageDialog(GemsReqReplyMonitor.this.m_frame, "A consumer for monitor topic " + GemsReqReplyMonitor.this.m_reqTopic.getTopicName() + "\nhas a pending backlog of " + backlog + " messages, monitor will stop.", "Error", 1);
                        }
                        this.m_checkBacklogCount = 0L;
                    }
                }
                catch (JMSException ex) {
                    System.err.println("Exception: " + ex.getMessage());
                    GemsReqReplyMonitor.this.stop();
                }
            }
        }
    }
}

